// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2023 Atlan Pte. Ltd. */
package com.atlan.model.tasks;

import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.search.IndexSearchDSL;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

/**
 * Search abstraction mechanism, to simplify the most common searches against Atlan task queue
 * (removing the need to understand the guts of Elastic).
 */
@SuppressWarnings("cast")
public class FluentTasks {
    /**
     * Build a fluent search against the provided Atlan tenant.
     *
     * @param client connectivity to an Atlan tenant
     * @return the start of a fluent search against the tenant
     */
    public static FluentTasksBuilder builder(AtlanClient client) {
        return _internal().client(client);
    }

    /**
     * Client through which to retrieve the assets.
     */
    AtlanClient client;
    /**
     * Criteria by which to sort the results.
     */
    List<SortOptions> sorts;
    /**
     * Aggregations to run against the results of the search.
     * You provide any key you want to the map (you'll use it to look at the results of a specific aggregation).
     */
    Map<String, Aggregation> aggregations;
    /**
     * Number of results to retrieve per underlying API request.
     */
    Integer pageSize;
    /**
     * Criteria that must be present on every search result. (Translated to filters.)
     */
    private List<Query> wheres;
    /**
     * Criteria that must not be present on any search result.
     */
    private List<Query> whereNots;
    /**
     * A collection of criteria at least some of which should be present on each search result.
     * You can control "how many" of the criteria are a minimum for each search result to match
     * through the `minimum` parameter.
     * @see #minSomes
     */
    private List<Query> whereSomes;
    /**
     * The minimum number of criteria in the "whereSomes" that must match on each search result. (Defaults to 1.)
     */
    private int minSomes;

    /**
     * Translate the Atlan compound query into an Elastic Query object.
     *
     * @return an Elastic Query object that represents the compound query
     */
    public Query toQuery() {
        BoolQuery.Builder builder = new BoolQuery.Builder();
        if (wheres != null && !wheres.isEmpty()) {
            builder.filter(wheres);
        }
        if (whereNots != null && !whereNots.isEmpty()) {
            builder.mustNot(whereNots);
        }
        if (whereSomes != null && !whereSomes.isEmpty()) {
            builder.should(whereSomes).minimumShouldMatch("" + minSomes);
        }
        return builder.build()._toQuery();
    }

    /**
     * Translate the Atlan fluent search into an Atlan search request.
     *
     * @return an Atlan search request that encapsulates the fluent search
     */
    public TaskSearchRequest toRequest() {
        return _requestBuilder().build();
    }

    /**
     * Return the total number of assets that will match the supplied criteria,
     * using the most minimal query possible (retrieves minimal data).
     *
     * @return the count of assets that will match the supplied criteria
     * @throws AtlanException on any issues interacting with the Atlan APIs
     */
    public long count() throws AtlanException {
        if (client == null) {
            throw new InvalidRequestException(ErrorCode.NO_ATLAN_CLIENT);
        }
        // As long as there is a client, build the search request for just a single result (with count)
        // and then just return the count
        TaskSearchRequest request = TaskSearchRequest.builder(_dsl().size(1).clearAggregations().build()).build();
        return request.search(client).getApproximateCount();
    }

    /**
     * Run the fluent search to retrieve assets that match the supplied criteria.
     *
     * @return a stream of assets that match the specified criteria, lazily-fetched
     * @throws AtlanException on any issues interacting with the Atlan APIs
     */
    public Stream<AtlanTask> stream() throws AtlanException {
        return stream(false);
    }

    /**
     * Run the fluent search to retrieve assets that match the supplied criteria.
     *
     * @param parallel if true, returns a parallel stream
     * @return a stream of assets that match the specified criteria, lazily-fetched
     * @throws AtlanException on any issues interacting with the Atlan APIs
     */
    public Stream<AtlanTask> stream(boolean parallel) throws AtlanException {
        if (client == null) {
            throw new InvalidRequestException(ErrorCode.NO_ATLAN_CLIENT);
        }
        TaskSearchRequest request = toRequest();
        if (parallel) {
            return request.search(client).parallelStream();
        } else {
            return request.search(client).stream();
        }
    }

    /**
     * Translate the Atlan fluent search into an Atlan search DSL builder.
     *
     * @return an Atlan search DSL builder that encapsulates the fluent search
     */
    protected IndexSearchDSL.IndexSearchDSLBuilder<?, ?> _dsl() {
        return IndexSearchDSL.builder(toQuery());
    }

    /**
     * Translate the Atlan fluent search into an Atlan search request builder.
     *
     * @return an Atlan search request builder that encapsulates the fluent search
     */
    protected TaskSearchRequest.TaskSearchRequestBuilder<?, ?> _requestBuilder() {
        IndexSearchDSL.IndexSearchDSLBuilder<?, ?> dsl = _dsl();
        if (pageSize != null) {
            dsl.size(pageSize);
        }
        if (sorts != null) {
            dsl.sort(sorts);
        }
        if (aggregations != null) {
            dsl.aggregations(aggregations);
        }
        return TaskSearchRequest.builder(dsl.build());
    }


    public static class FluentTasksBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanClient client;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<SortOptions> sorts;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> aggregations$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Aggregation> aggregations$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Integer pageSize;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Query> wheres;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Query> whereNots;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<Query> whereSomes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean minSomes$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private int minSomes$value;

        /**
         * Translate the Atlan fluent search into an Atlan search request builder.
         *
         * @return an Atlan search request builder that encapsulates the fluent search
         */
        public TaskSearchRequest.TaskSearchRequestBuilder<?, ?> toRequestBuilder() {
            return build()._requestBuilder();
        }

        /**
         * Translate the Atlan fluent search into an Atlan search request.
         *
         * @return an Atlan search request that encapsulates the fluent search
         */
        public TaskSearchRequest toRequest() {
            return build().toRequest();
        }

        /**
         * Return the total number of assets that will match the supplied criteria,
         * using the most minimal query possible (retrieves minimal data).
         *
         * @return the count of assets that will match the supplied criteria
         * @throws AtlanException on any issues interacting with the Atlan APIs
         */
        public long count() throws AtlanException {
            return build().count();
        }

        /**
         * Run the fluent search to retrieve assets that match the supplied criteria.
         *
         * @return a stream of assets that match the specified criteria, lazily-fetched
         * @throws AtlanException on any issues interacting with the Atlan APIs
         */
        public Stream<AtlanTask> stream() throws AtlanException {
            return build().stream();
        }

        /**
         * Run the fluent search to retrieve assets that match the supplied criteria.
         *
         * @param parallel if true, returns a parallel stream
         * @return a stream of assets that match the specified criteria, lazily-fetched
         * @throws AtlanException on any issues interacting with the Atlan APIs
         */
        public Stream<AtlanTask> stream(boolean parallel) throws AtlanException {
            return build().stream(parallel);
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        FluentTasksBuilder() {
        }

        /**
         * Client through which to retrieve the assets.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentTasks.FluentTasksBuilder client(final AtlanClient client) {
            this.client = client;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentTasks.FluentTasksBuilder sort(final SortOptions sort) {
            if (this.sorts == null) this.sorts = new java.util.ArrayList<SortOptions>();
            this.sorts.add(sort);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentTasks.FluentTasksBuilder sorts(final java.util.Collection<? extends SortOptions> sorts) {
            if (sorts == null) {
                throw new java.lang.NullPointerException("sorts cannot be null");
            }
            if (this.sorts == null) this.sorts = new java.util.ArrayList<SortOptions>();
            this.sorts.addAll(sorts);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentTasks.FluentTasksBuilder clearSorts() {
            if (this.sorts != null) this.sorts.clear();
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentTasks.FluentTasksBuilder aggregate(final String aggregateKey, final Aggregation aggregateValue) {
            if (this.aggregations$key == null) {
                this.aggregations$key = new java.util.ArrayList<String>();
                this.aggregations$value = new java.util.ArrayList<Aggregation>();
            }
            this.aggregations$key.add(aggregateKey);
            this.aggregations$value.add(aggregateValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentTasks.FluentTasksBuilder aggregations(final java.util.Map<? extends String, ? extends Aggregation> aggregations) {
            if (aggregations == null) {
                throw new java.lang.NullPointerException("aggregations cannot be null");
            }
            if (this.aggregations$key == null) {
                this.aggregations$key = new java.util.ArrayList<String>();
                this.aggregations$value = new java.util.ArrayList<Aggregation>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Aggregation> $lombokEntry : aggregations.entrySet()) {
                this.aggregations$key.add($lombokEntry.getKey());
                this.aggregations$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentTasks.FluentTasksBuilder clearAggregations() {
            if (this.aggregations$key != null) {
                this.aggregations$key.clear();
                this.aggregations$value.clear();
            }
            return this;
        }

        /**
         * Number of results to retrieve per underlying API request.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentTasks.FluentTasksBuilder pageSize(final Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentTasks.FluentTasksBuilder where(final Query where) {
            if (this.wheres == null) this.wheres = new java.util.ArrayList<Query>();
            this.wheres.add(where);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentTasks.FluentTasksBuilder wheres(final java.util.Collection<? extends Query> wheres) {
            if (wheres == null) {
                throw new java.lang.NullPointerException("wheres cannot be null");
            }
            if (this.wheres == null) this.wheres = new java.util.ArrayList<Query>();
            this.wheres.addAll(wheres);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentTasks.FluentTasksBuilder clearWheres() {
            if (this.wheres != null) this.wheres.clear();
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentTasks.FluentTasksBuilder whereNot(final Query whereNot) {
            if (this.whereNots == null) this.whereNots = new java.util.ArrayList<Query>();
            this.whereNots.add(whereNot);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentTasks.FluentTasksBuilder whereNots(final java.util.Collection<? extends Query> whereNots) {
            if (whereNots == null) {
                throw new java.lang.NullPointerException("whereNots cannot be null");
            }
            if (this.whereNots == null) this.whereNots = new java.util.ArrayList<Query>();
            this.whereNots.addAll(whereNots);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentTasks.FluentTasksBuilder clearWhereNots() {
            if (this.whereNots != null) this.whereNots.clear();
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentTasks.FluentTasksBuilder whereSome(final Query whereSome) {
            if (this.whereSomes == null) this.whereSomes = new java.util.ArrayList<Query>();
            this.whereSomes.add(whereSome);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentTasks.FluentTasksBuilder whereSomes(final java.util.Collection<? extends Query> whereSomes) {
            if (whereSomes == null) {
                throw new java.lang.NullPointerException("whereSomes cannot be null");
            }
            if (this.whereSomes == null) this.whereSomes = new java.util.ArrayList<Query>();
            this.whereSomes.addAll(whereSomes);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentTasks.FluentTasksBuilder clearWhereSomes() {
            if (this.whereSomes != null) this.whereSomes.clear();
            return this;
        }

        /**
         * The minimum number of criteria in the "whereSomes" that must match on each search result. (Defaults to 1.)
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentTasks.FluentTasksBuilder minSomes(final int minSomes) {
            this.minSomes$value = minSomes;
            minSomes$set = true;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public FluentTasks build() {
            java.util.List<SortOptions> sorts;
            switch (this.sorts == null ? 0 : this.sorts.size()) {
            case 0: 
                sorts = java.util.Collections.emptyList();
                break;
            case 1: 
                sorts = java.util.Collections.singletonList(this.sorts.get(0));
                break;
            default: 
                sorts = java.util.Collections.unmodifiableList(new java.util.ArrayList<SortOptions>(this.sorts));
            }
            java.util.Map<String, Aggregation> aggregations;
            switch (this.aggregations$key == null ? 0 : this.aggregations$key.size()) {
            case 0: 
                aggregations = java.util.Collections.emptyMap();
                break;
            case 1: 
                aggregations = java.util.Collections.singletonMap(this.aggregations$key.get(0), this.aggregations$value.get(0));
                break;
            default: 
                aggregations = new java.util.LinkedHashMap<String, Aggregation>(this.aggregations$key.size() < 1073741824 ? 1 + this.aggregations$key.size() + (this.aggregations$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.aggregations$key.size(); $i++) aggregations.put(this.aggregations$key.get($i), (Aggregation) this.aggregations$value.get($i));
                aggregations = java.util.Collections.unmodifiableMap(aggregations);
            }
            java.util.List<Query> wheres;
            switch (this.wheres == null ? 0 : this.wheres.size()) {
            case 0: 
                wheres = java.util.Collections.emptyList();
                break;
            case 1: 
                wheres = java.util.Collections.singletonList(this.wheres.get(0));
                break;
            default: 
                wheres = java.util.Collections.unmodifiableList(new java.util.ArrayList<Query>(this.wheres));
            }
            java.util.List<Query> whereNots;
            switch (this.whereNots == null ? 0 : this.whereNots.size()) {
            case 0: 
                whereNots = java.util.Collections.emptyList();
                break;
            case 1: 
                whereNots = java.util.Collections.singletonList(this.whereNots.get(0));
                break;
            default: 
                whereNots = java.util.Collections.unmodifiableList(new java.util.ArrayList<Query>(this.whereNots));
            }
            java.util.List<Query> whereSomes;
            switch (this.whereSomes == null ? 0 : this.whereSomes.size()) {
            case 0: 
                whereSomes = java.util.Collections.emptyList();
                break;
            case 1: 
                whereSomes = java.util.Collections.singletonList(this.whereSomes.get(0));
                break;
            default: 
                whereSomes = java.util.Collections.unmodifiableList(new java.util.ArrayList<Query>(this.whereSomes));
            }
            int minSomes$value = this.minSomes$value;
            if (!this.minSomes$set) minSomes$value = FluentTasks.$default$minSomes();
            return new FluentTasks(this.client, sorts, aggregations, this.pageSize, wheres, whereNots, whereSomes, minSomes$value);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "FluentTasks.FluentTasksBuilder(client=" + this.client + ", sorts=" + this.sorts + ", aggregations$key=" + this.aggregations$key + ", aggregations$value=" + this.aggregations$value + ", pageSize=" + this.pageSize + ", wheres=" + this.wheres + ", whereNots=" + this.whereNots + ", whereSomes=" + this.whereSomes + ", minSomes$value=" + this.minSomes$value + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static int $default$minSomes() {
        return 1;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    FluentTasks(final AtlanClient client, final List<SortOptions> sorts, final Map<String, Aggregation> aggregations, final Integer pageSize, final List<Query> wheres, final List<Query> whereNots, final List<Query> whereSomes, final int minSomes) {
        this.client = client;
        this.sorts = sorts;
        this.aggregations = aggregations;
        this.pageSize = pageSize;
        this.wheres = wheres;
        this.whereNots = whereNots;
        this.whereSomes = whereSomes;
        this.minSomes = minSomes;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static FluentTasks.FluentTasksBuilder _internal() {
        return new FluentTasks.FluentTasksBuilder();
    }
}
