// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.tasks;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.search.IndexSearchDSL;

/**
 * Class from which to configure and run a search against Atlan's task queue.
 */
public class TaskSearchRequest extends AtlanObject {
    private static final long serialVersionUID = 2L;

    /**
     * Build a search using the provided query and default options.
     *
     * @param query the query to use for the search
     * @return the search request, with default options
     */
    public static TaskSearchRequestBuilder<?, ?> builder(Query query) {
        return builder(IndexSearchDSL.of(query));
    }

    /**
     * Build a search using the provided DSL and default options.
     *
     * @param dsl the query details to use for the search
     * @return the search request, with default options
     */
    public static TaskSearchRequestBuilder<?, ?> builder(IndexSearchDSL dsl) {
        return TaskSearchRequest._internal().dsl(dsl);
    }

    /**
     * Parameters for the search itself.
     */
    IndexSearchDSL dsl;

    /**
     * Run the search.
     *
     * @return the matching task queue records
     */
    public TaskSearchResponse search() throws AtlanException {
        return search(Atlan.getDefaultClient());
    }

    /**
     * Run the search.
     *
     * @param client connectivity to the Atlan tenant on which to search the task queue
     * @return the matching task queue records
     */
    public TaskSearchResponse search(AtlanClient client) throws AtlanException {
        return client.tasks.search(this);
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class TaskSearchRequestBuilder<C extends TaskSearchRequest, B extends TaskSearchRequest.TaskSearchRequestBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IndexSearchDSL dsl;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            TaskSearchRequest.TaskSearchRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final TaskSearchRequest instance, final TaskSearchRequest.TaskSearchRequestBuilder<?, ?> b) {
            b.dsl(instance.dsl);
        }

        /**
         * Parameters for the search itself.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B dsl(final IndexSearchDSL dsl) {
            this.dsl = dsl;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "TaskSearchRequest.TaskSearchRequestBuilder(super=" + super.toString() + ", dsl=" + this.dsl + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static final class TaskSearchRequestBuilderImpl extends TaskSearchRequest.TaskSearchRequestBuilder<TaskSearchRequest, TaskSearchRequest.TaskSearchRequestBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private TaskSearchRequestBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected TaskSearchRequest.TaskSearchRequestBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public TaskSearchRequest build() {
            return new TaskSearchRequest(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected TaskSearchRequest(final TaskSearchRequest.TaskSearchRequestBuilder<?, ?> b) {
        super(b);
        this.dsl = b.dsl;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static TaskSearchRequest.TaskSearchRequestBuilder<?, ?> _internal() {
        return new TaskSearchRequest.TaskSearchRequestBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TaskSearchRequest.TaskSearchRequestBuilder<?, ?> toBuilder() {
        return new TaskSearchRequest.TaskSearchRequestBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Parameters for the search itself.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IndexSearchDSL getDsl() {
        return this.dsl;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof TaskSearchRequest)) return false;
        final TaskSearchRequest other = (TaskSearchRequest) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$dsl = this.getDsl();
        final java.lang.Object other$dsl = other.getDsl();
        if (this$dsl == null ? other$dsl != null : !this$dsl.equals(other$dsl)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof TaskSearchRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $dsl = this.getDsl();
        result = result * PRIME + ($dsl == null ? 43 : $dsl.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "TaskSearchRequest(super=" + super.toString() + ", dsl=" + this.getDsl() + ")";
    }
}
