// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.typedefs;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.enums.AtlanIcon;
import com.atlan.model.enums.AtlanTagColor;
import com.atlan.model.enums.AtlanTypeCategory;
import java.util.List;

/**
 * Structural definition of an Atlan tag.
 */
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = AtlanTagDef.AtlanTagDefBuilderImpl.class)
public class AtlanTagDef extends TypeDef {
    private static final long serialVersionUID = 2L;
    /**
     * Fixed category for Atlan tag typedefs.
     */
    AtlanTypeCategory category;
    /**
     * Options that describe the Atlan tag.
     */
    AtlanTagOptions options;
    /**
     * Unused.
     */
    List<String> superTypes;
    /**
     * List of the types of entities that the Atlan tag can be applied to.
     */
    List<String> entityTypes;
    /**
     * Unused.
     */
    List<String> subTypes;
    /**
     * TBC
     */
    Boolean skipDisplayNameUniquenessCheck;

    /**
     * Builds the minimal object necessary to create an Atlan tag definition, using the default tag icon.
     *
     * @param displayName the human-readable name for the Atlan tag
     * @param color the color to use for the Atlan tag
     * @return the minimal request necessary to create the Atlan tag typedef, as a builder
     */
    public static AtlanTagDefBuilder<?, ?> creator(String displayName, AtlanTagColor color) {
        return AtlanTagDef.builder().name(displayName).displayName(displayName).options(AtlanTagOptions.of(color));
    }

    /**
     * Builds the minimal object necessary to create an Atlan tag definition.
     *
     * @param displayName the human-readable name for the Atlan tag
     * @param icon the built-in icon to use for the Atlan tag
     * @param color the color to use for the Atlan tag
     * @return the minimal request necessary to create the Atlan tag typedef, as a builder
     */
    public static AtlanTagDefBuilder<?, ?> creator(String displayName, AtlanIcon icon, AtlanTagColor color) {
        return AtlanTagDef.builder().name(displayName).displayName(displayName).options(AtlanTagOptions.withIcon(icon, color));
    }

    /**
     * Builds the minimal object necessary to create an Atlan tag definition.
     *
     * @param displayName the human-readable name for the Atlan tag
     * @param url URL to an image to use for the Atlan tag
     * @return the minimal request necessary to create the Atlan tag typedef, as a builder
     * @throws AtlanException on any issues uploading the image from the provided URL
     */
    public static AtlanTagDefBuilder<?, ?> creator(String displayName, String url) throws AtlanException {
        return AtlanTagDef.builder().name(displayName).displayName(displayName).options(AtlanTagOptions.withImage(url));
    }

    /**
     * Builds the minimal object necessary to create an Atlan tag definition.
     *
     * @param displayName the human-readable name for the Atlan tag
     * @param options to use when creating the Atlan tag
     * @return the minimal request necessary to create the Atlan tag typedef, as a builder
     * @throws AtlanException on any issues uploading the image from the provided URL
     */
    public static AtlanTagDefBuilder<?, ?> creator(String displayName, AtlanTagOptions options) throws AtlanException {
        return AtlanTagDef.builder().name(displayName).displayName(displayName).options(options);
    }

    /**
     * Create this Atlan tag definition in Atlan.
     *
     * @param client connectivity to an Atlan tenant
     * @return the result of the creation, or null if the creation failed
     * @throws AtlanException on any API communication issues
     */
    public synchronized AtlanTagDef create(AtlanClient client) throws AtlanException {
        TypeDefResponse response = client.typeDefs.create(this);
        if (response != null && !response.getAtlanTagDefs().isEmpty()) {
            return response.getAtlanTagDefs().get(0);
        }
        return null;
    }

    /**
     * Hard-deletes (purges) an Atlan tag by its human-readable name. This operation is irreversible.
     * If there are any existing Atlan tag instances, this operation will fail.
     *
     * @param displayName human-readable name of the Atlan tag
     * @throws AtlanException on any error during the API invocation
     */
    public static synchronized void purge(String displayName) throws AtlanException {
        purge(Atlan.getDefaultClient(), displayName);
    }

    /**
     * Hard-deletes (purges) an Atlan tag by its human-readable name. This operation is irreversible.
     * If there are any existing Atlan tag instances, this operation will fail.
     *
     * @param client connectivity to the Atlan tenant from which the Atlan tag should be purged
     * @param displayName human-readable name of the Atlan tag
     * @param client connectivity to an Atlan tenant
     * @throws AtlanException on any error during the API invocation
     */
    public static synchronized void purge(AtlanClient client, String displayName) throws AtlanException {
        String internalName = client.getAtlanTagCache().getIdForName(displayName);
        client.typeDefs.purge(internalName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static AtlanTypeCategory $default$category() {
        return AtlanTypeCategory.ATLAN_TAG;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$skipDisplayNameUniquenessCheck() {
        return false;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AtlanTagDefBuilder<C extends AtlanTagDef, B extends AtlanTagDef.AtlanTagDefBuilder<C, B>> extends TypeDef.TypeDefBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean category$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanTypeCategory category$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanTagOptions options;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<String> superTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<String> entityTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<String> subTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean skipDisplayNameUniquenessCheck$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean skipDisplayNameUniquenessCheck$value;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AtlanTagDef.AtlanTagDefBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AtlanTagDef instance, final AtlanTagDef.AtlanTagDefBuilder<?, ?> b) {
            b.category(instance.category);
            b.options(instance.options);
            b.superTypes(instance.superTypes);
            b.entityTypes(instance.entityTypes);
            b.subTypes(instance.subTypes);
            b.skipDisplayNameUniquenessCheck(instance.skipDisplayNameUniquenessCheck);
        }

        /**
         * Fixed category for Atlan tag typedefs.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B category(final AtlanTypeCategory category) {
            this.category$value = category;
            category$set = true;
            return self();
        }

        /**
         * Options that describe the Atlan tag.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B options(final AtlanTagOptions options) {
            this.options = options;
            return self();
        }

        /**
         * Unused.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B superTypes(final List<String> superTypes) {
            this.superTypes = superTypes;
            return self();
        }

        /**
         * List of the types of entities that the Atlan tag can be applied to.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B entityTypes(final List<String> entityTypes) {
            this.entityTypes = entityTypes;
            return self();
        }

        /**
         * Unused.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B subTypes(final List<String> subTypes) {
            this.subTypes = subTypes;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B skipDisplayNameUniquenessCheck(final Boolean skipDisplayNameUniquenessCheck) {
            this.skipDisplayNameUniquenessCheck$value = skipDisplayNameUniquenessCheck;
            skipDisplayNameUniquenessCheck$set = true;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AtlanTagDef.AtlanTagDefBuilder(super=" + super.toString() + ", category$value=" + this.category$value + ", options=" + this.options + ", superTypes=" + this.superTypes + ", entityTypes=" + this.entityTypes + ", subTypes=" + this.subTypes + ", skipDisplayNameUniquenessCheck$value=" + this.skipDisplayNameUniquenessCheck$value + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class AtlanTagDefBuilderImpl extends AtlanTagDef.AtlanTagDefBuilder<AtlanTagDef, AtlanTagDef.AtlanTagDefBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanTagDefBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AtlanTagDef.AtlanTagDefBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AtlanTagDef build() {
            return new AtlanTagDef(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AtlanTagDef(final AtlanTagDef.AtlanTagDefBuilder<?, ?> b) {
        super(b);
        if (b.category$set) this.category = b.category$value;
         else this.category = AtlanTagDef.$default$category();
        this.options = b.options;
        this.superTypes = b.superTypes;
        this.entityTypes = b.entityTypes;
        this.subTypes = b.subTypes;
        if (b.skipDisplayNameUniquenessCheck$set) this.skipDisplayNameUniquenessCheck = b.skipDisplayNameUniquenessCheck$value;
         else this.skipDisplayNameUniquenessCheck = AtlanTagDef.$default$skipDisplayNameUniquenessCheck();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AtlanTagDef.AtlanTagDefBuilder<?, ?> builder() {
        return new AtlanTagDef.AtlanTagDefBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanTagDef.AtlanTagDefBuilder<?, ?> toBuilder() {
        return new AtlanTagDef.AtlanTagDefBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Options that describe the Atlan tag.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanTagOptions getOptions() {
        return this.options;
    }

    /**
     * Unused.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getSuperTypes() {
        return this.superTypes;
    }

    /**
     * List of the types of entities that the Atlan tag can be applied to.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getEntityTypes() {
        return this.entityTypes;
    }

    /**
     * Unused.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getSubTypes() {
        return this.subTypes;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getSkipDisplayNameUniquenessCheck() {
        return this.skipDisplayNameUniquenessCheck;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AtlanTagDef)) return false;
        final AtlanTagDef other = (AtlanTagDef) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$skipDisplayNameUniquenessCheck = this.getSkipDisplayNameUniquenessCheck();
        final java.lang.Object other$skipDisplayNameUniquenessCheck = other.getSkipDisplayNameUniquenessCheck();
        if (this$skipDisplayNameUniquenessCheck == null ? other$skipDisplayNameUniquenessCheck != null : !this$skipDisplayNameUniquenessCheck.equals(other$skipDisplayNameUniquenessCheck)) return false;
        final java.lang.Object this$category = this.getCategory();
        final java.lang.Object other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) return false;
        final java.lang.Object this$options = this.getOptions();
        final java.lang.Object other$options = other.getOptions();
        if (this$options == null ? other$options != null : !this$options.equals(other$options)) return false;
        final java.lang.Object this$superTypes = this.getSuperTypes();
        final java.lang.Object other$superTypes = other.getSuperTypes();
        if (this$superTypes == null ? other$superTypes != null : !this$superTypes.equals(other$superTypes)) return false;
        final java.lang.Object this$entityTypes = this.getEntityTypes();
        final java.lang.Object other$entityTypes = other.getEntityTypes();
        if (this$entityTypes == null ? other$entityTypes != null : !this$entityTypes.equals(other$entityTypes)) return false;
        final java.lang.Object this$subTypes = this.getSubTypes();
        final java.lang.Object other$subTypes = other.getSubTypes();
        if (this$subTypes == null ? other$subTypes != null : !this$subTypes.equals(other$subTypes)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AtlanTagDef;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $skipDisplayNameUniquenessCheck = this.getSkipDisplayNameUniquenessCheck();
        result = result * PRIME + ($skipDisplayNameUniquenessCheck == null ? 43 : $skipDisplayNameUniquenessCheck.hashCode());
        final java.lang.Object $category = this.getCategory();
        result = result * PRIME + ($category == null ? 43 : $category.hashCode());
        final java.lang.Object $options = this.getOptions();
        result = result * PRIME + ($options == null ? 43 : $options.hashCode());
        final java.lang.Object $superTypes = this.getSuperTypes();
        result = result * PRIME + ($superTypes == null ? 43 : $superTypes.hashCode());
        final java.lang.Object $entityTypes = this.getEntityTypes();
        result = result * PRIME + ($entityTypes == null ? 43 : $entityTypes.hashCode());
        final java.lang.Object $subTypes = this.getSubTypes();
        result = result * PRIME + ($subTypes == null ? 43 : $subTypes.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AtlanTagDef(super=" + super.toString() + ", category=" + this.getCategory() + ", options=" + this.getOptions() + ", superTypes=" + this.getSuperTypes() + ", entityTypes=" + this.getEntityTypes() + ", subTypes=" + this.getSubTypes() + ", skipDisplayNameUniquenessCheck=" + this.getSkipDisplayNameUniquenessCheck() + ")";
    }

    /**
     * Fixed category for Atlan tag typedefs.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanTypeCategory getCategory() {
        return this.category;
    }
}
