// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.typedefs;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.ApiException;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.AtlanImage;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.*;
import java.io.IOException;
import java.net.MalformedURLException;

/**
 * Options that can be defined for an Atlan tag.
 */
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = AtlanTagOptions.AtlanTagOptionsBuilderImpl.class)
public class AtlanTagOptions extends AtlanObject {
    private static final long serialVersionUID = 2L;

    /**
     * Provide Atlan tag options that set the color for the tag, using the default tag icon.
     *
     * @param color to use to represent the Atlan tag
     * @return the necessary options for setting this color for the Atlan tag
     */
    public static AtlanTagOptions of(AtlanTagColor color) {
        return withIcon(AtlanIcon.ATLAN_TAG, color);
    }

    /**
     * Provide Atlan tag options that set the icon and color for the tag, using a built-in icon.
     *
     * @param icon to use to represent the Atlan tag
     * @param color to use to represent the Atlan tag
     * @return the necessary options for setting this icon and color for the Atlan tag
     */
    public static AtlanTagOptions withIcon(AtlanIcon icon, AtlanTagColor color) {
        return AtlanTagOptions.builder().color(color.getValue()).iconName(icon).iconType(TagIconType.ICON).imageID("").build();
    }

    /**
     * Provide Atlan tag options that set the image for the tag, using an uploaded image.
     *
     * @param url URL to the image to use for the Atlan tag
     * @return the necessary options for setting this image for the Atlan tag
     * @throws AtlanException on any API communication issues trying to upload the image
     */
    public static AtlanTagOptions withImage(String url) throws AtlanException {
        return withImage(Atlan.getDefaultClient(), url);
    }

    /**
     * Provide Atlan tag options that set the image for the tag, using an uploaded image.
     *
     * @param client connectivity to the Atlan tenant in which the tag is intended to be created
     * @param url URL to the image to use for the Atlan tag
     * @return the necessary options for setting this image for the Atlan tag
     * @throws AtlanException on any API communication issues trying to upload the image
     */
    public static AtlanTagOptions withImage(AtlanClient client, String url) throws AtlanException {
        try {
            AtlanImage result = client.images.upload(url);
            return AtlanTagOptions.builder().iconType(TagIconType.IMAGE).imageID(result.getId()).color(AtlanTagColor.GRAY.getValue()).iconName(AtlanIcon.ATLAN_TAG).build();
        } catch (MalformedURLException e) {
            throw new InvalidRequestException(ErrorCode.INVALID_URL, e);
        } catch (IOException e) {
            throw new ApiException(ErrorCode.INACCESSIBLE_URL, e);
        }
    }

    /**
     * Provide Atlan tag options that set the logo for the tag to the provided emoji.
     *
     * @param emoji the emoji character to use for the logo
     * @return the necessary options for setting this emoji character as the logo for the Atlan tag
     */
    public static AtlanTagOptions withEmoji(String emoji) {
        return AtlanTagOptions.builder().iconType(TagIconType.EMOJI).emoji(emoji).color(AtlanTagColor.GRAY.getValue()).iconName(AtlanIcon.ATLAN_TAG).build();
    }

    /**
     * Color to use for the Atlan tag.
     */
    String color;
    /**
     * Name of icon to use to represent the tag visually.
     */
    AtlanIcon iconName;
    /**
     * Type of icon to use for representing the tag visually.
     */
    TagIconType iconType;
    /**
     * If the {@code iconType} is emoji, this should hold the emoji character.
     */
    String emoji;
    /**
     * Unique identifier (GUID) of an image to use for the tag.
     */
    String imageID;


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AtlanTagOptionsBuilder<C extends AtlanTagOptions, B extends AtlanTagOptions.AtlanTagOptionsBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String color;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanIcon iconName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private TagIconType iconType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String emoji;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String imageID;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AtlanTagOptions.AtlanTagOptionsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AtlanTagOptions instance, final AtlanTagOptions.AtlanTagOptionsBuilder<?, ?> b) {
            b.color(instance.color);
            b.iconName(instance.iconName);
            b.iconType(instance.iconType);
            b.emoji(instance.emoji);
            b.imageID(instance.imageID);
        }

        /**
         * Color to use for the Atlan tag.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B color(final String color) {
            this.color = color;
            return self();
        }

        /**
         * Name of icon to use to represent the tag visually.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B iconName(final AtlanIcon iconName) {
            this.iconName = iconName;
            return self();
        }

        /**
         * Type of icon to use for representing the tag visually.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B iconType(final TagIconType iconType) {
            this.iconType = iconType;
            return self();
        }

        /**
         * If the {@code iconType} is emoji, this should hold the emoji character.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B emoji(final String emoji) {
            this.emoji = emoji;
            return self();
        }

        /**
         * Unique identifier (GUID) of an image to use for the tag.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B imageID(final String imageID) {
            this.imageID = imageID;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AtlanTagOptions.AtlanTagOptionsBuilder(super=" + super.toString() + ", color=" + this.color + ", iconName=" + this.iconName + ", iconType=" + this.iconType + ", emoji=" + this.emoji + ", imageID=" + this.imageID + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class AtlanTagOptionsBuilderImpl extends AtlanTagOptions.AtlanTagOptionsBuilder<AtlanTagOptions, AtlanTagOptions.AtlanTagOptionsBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanTagOptionsBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AtlanTagOptions.AtlanTagOptionsBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AtlanTagOptions build() {
            return new AtlanTagOptions(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AtlanTagOptions(final AtlanTagOptions.AtlanTagOptionsBuilder<?, ?> b) {
        super(b);
        this.color = b.color;
        this.iconName = b.iconName;
        this.iconType = b.iconType;
        this.emoji = b.emoji;
        this.imageID = b.imageID;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AtlanTagOptions.AtlanTagOptionsBuilder<?, ?> builder() {
        return new AtlanTagOptions.AtlanTagOptionsBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanTagOptions.AtlanTagOptionsBuilder<?, ?> toBuilder() {
        return new AtlanTagOptions.AtlanTagOptionsBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Color to use for the Atlan tag.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getColor() {
        return this.color;
    }

    /**
     * Name of icon to use to represent the tag visually.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanIcon getIconName() {
        return this.iconName;
    }

    /**
     * Type of icon to use for representing the tag visually.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public TagIconType getIconType() {
        return this.iconType;
    }

    /**
     * If the {@code iconType} is emoji, this should hold the emoji character.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEmoji() {
        return this.emoji;
    }

    /**
     * Unique identifier (GUID) of an image to use for the tag.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getImageID() {
        return this.imageID;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AtlanTagOptions)) return false;
        final AtlanTagOptions other = (AtlanTagOptions) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$color = this.getColor();
        final java.lang.Object other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) return false;
        final java.lang.Object this$iconName = this.getIconName();
        final java.lang.Object other$iconName = other.getIconName();
        if (this$iconName == null ? other$iconName != null : !this$iconName.equals(other$iconName)) return false;
        final java.lang.Object this$iconType = this.getIconType();
        final java.lang.Object other$iconType = other.getIconType();
        if (this$iconType == null ? other$iconType != null : !this$iconType.equals(other$iconType)) return false;
        final java.lang.Object this$emoji = this.getEmoji();
        final java.lang.Object other$emoji = other.getEmoji();
        if (this$emoji == null ? other$emoji != null : !this$emoji.equals(other$emoji)) return false;
        final java.lang.Object this$imageID = this.getImageID();
        final java.lang.Object other$imageID = other.getImageID();
        if (this$imageID == null ? other$imageID != null : !this$imageID.equals(other$imageID)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AtlanTagOptions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $color = this.getColor();
        result = result * PRIME + ($color == null ? 43 : $color.hashCode());
        final java.lang.Object $iconName = this.getIconName();
        result = result * PRIME + ($iconName == null ? 43 : $iconName.hashCode());
        final java.lang.Object $iconType = this.getIconType();
        result = result * PRIME + ($iconType == null ? 43 : $iconType.hashCode());
        final java.lang.Object $emoji = this.getEmoji();
        result = result * PRIME + ($emoji == null ? 43 : $emoji.hashCode());
        final java.lang.Object $imageID = this.getImageID();
        result = result * PRIME + ($imageID == null ? 43 : $imageID.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AtlanTagOptions(super=" + super.toString() + ", color=" + this.getColor() + ", iconName=" + this.getIconName() + ", iconType=" + this.getIconType() + ", emoji=" + this.getEmoji() + ", imageID=" + this.getImageID() + ")";
    }
}
