// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.typedefs;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanAttributeType;
import com.atlan.model.enums.AtlanCustomAttributeCardinality;
import com.atlan.model.enums.AtlanCustomAttributePrimitiveType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import lombok.*;

/**
 * Defines the structure of a single attribute for a type definition in Atlan.
 */
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = AttributeDef.AttributeDefBuilderImpl.class)
public class AttributeDef extends AtlanObject implements Comparable<AttributeDef> {
    private static final long serialVersionUID = 2L;
    // Sort attribute definitions in a set based purely on their name (two attributes
    // in the same set with the same name should be a conflict / duplicate)
    private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
    private static final Comparator<AttributeDef> attributeDefComparator = Comparator.comparing(AttributeDef::getName, stringComparator);

    /**
     * Instantiate an attribute definition from the provided parameters.
     *
     * @param displayName human-readable name of the attribute
     * @param type primitive type of the attribute (non-enum)
     * @param multiValued true if multiple values are allowed for the attribute, otherwise false
     * @return the attribute definition
     * @throws AtlanException if there is any API error trying to construct the attribute (usually due to a non-existent enumeration)
     */
    public static AttributeDef of(String displayName, AtlanCustomAttributePrimitiveType type, boolean multiValued) throws AtlanException {
        return of(Atlan.getDefaultClient(), displayName, type, multiValued);
    }

    /**
     * Instantiate an attribute definition from the provided parameters.
     *
     * @param client connectivity to the Atlan tenant on which this attribute is intended to be created
     * @param displayName human-readable name of the attribute
     * @param type primitive type of the attribute (non-enum)
     * @param multiValued true if multiple values are allowed for the attribute, otherwise false
     * @return the attribute definition
     * @throws AtlanException if there is any API error trying to construct the attribute (usually due to a non-existent enumeration)
     */
    public static AttributeDef of(AtlanClient client, String displayName, AtlanCustomAttributePrimitiveType type, boolean multiValued) throws AtlanException {
        return of(client, displayName, type, null, multiValued);
    }

    /**
     * Instantiate an attribute definition from the provided parameters.
     *
     * @param displayName human-readable name of the attribute
     * @param type primitive type of the attribute (non-enum)
     * @param multiValued true if multiple values are allowed for the attribute, otherwise false
     * @param otherOptions other options to set on the attribute
     * @return the attribute definition
     * @throws AtlanException if there is any API error trying to construct the attribute (usually due to a non-existent enumeration)
     */
    public static AttributeDef of(String displayName, AtlanCustomAttributePrimitiveType type, boolean multiValued, AttributeDefOptions otherOptions) throws AtlanException {
        return of(Atlan.getDefaultClient(), displayName, type, multiValued, otherOptions);
    }

    /**
     * Instantiate an attribute definition from the provided parameters.
     *
     * @param client connectivity to the Atlan tenant on which this attribute is intended to be created
     * @param displayName human-readable name of the attribute
     * @param type primitive type of the attribute (non-enum)
     * @param multiValued true if multiple values are allowed for the attribute, otherwise false
     * @param otherOptions other options to set on the attribute
     * @return the attribute definition
     * @throws AtlanException if there is any API error trying to construct the attribute (usually due to a non-existent enumeration)
     */
    public static AttributeDef of(AtlanClient client, String displayName, AtlanCustomAttributePrimitiveType type, boolean multiValued, AttributeDefOptions otherOptions) throws AtlanException {
        return of(client, displayName, type, null, multiValued, otherOptions);
    }

    /**
     * Instantiate an attribute definition from the provided parameters.
     *
     * @param displayName human-readable name of the attribute
     * @param type primitive type of the attribute
     * @param optionsName name of the options (enumeration) if the primitive type is an enumeration (can be null otherwise)
     * @param multiValued true if multiple values are allowed for the attribute, otherwise false
     * @return the attribute definition
     * @throws AtlanException if there is any API error trying to construct the attribute (usually due to a non-existent enumeration)
     */
    public static AttributeDef of(String displayName, AtlanCustomAttributePrimitiveType type, String optionsName, boolean multiValued) throws AtlanException {
        return of(Atlan.getDefaultClient(), displayName, type, optionsName, multiValued);
    }

    /**
     * Instantiate an attribute definition from the provided parameters.
     *
     * @param client connectivity to the Atlan tenant on which this attribute is intended to be created
     * @param displayName human-readable name of the attribute
     * @param type primitive type of the attribute
     * @param optionsName name of the options (enumeration) if the primitive type is an enumeration (can be null otherwise)
     * @param multiValued true if multiple values are allowed for the attribute, otherwise false
     * @return the attribute definition
     * @throws AtlanException if there is any API error trying to construct the attribute (usually due to a non-existent enumeration)
     */
    public static AttributeDef of(AtlanClient client, String displayName, AtlanCustomAttributePrimitiveType type, String optionsName, boolean multiValued) throws AtlanException {
        return of(client, displayName, type, optionsName, multiValued, null);
    }

    /**
     * Instantiate an attribute definition from the provided parameters.
     *
     * @param displayName human-readable name of the attribute
     * @param type primitive type of the attribute
     * @param optionsName name of the options (enumeration) if the primitive type is an enumeration (can be null otherwise)
     * @param multiValued true if multiple values are allowed for the attribute, otherwise false
     * @param otherOptions other options to set on the attribute
     * @return the attribute definition
     * @throws AtlanException if there is any API error trying to construct the attribute (usually due to a non-existent enumeration)
     */
    public static AttributeDef of(String displayName, AtlanCustomAttributePrimitiveType type, String optionsName, boolean multiValued, AttributeDefOptions otherOptions) throws AtlanException {
        return of(Atlan.getDefaultClient(), displayName, type, optionsName, multiValued, otherOptions);
    }

    /**
     * Instantiate an attribute definition from the provided parameters.
     *
     * @param client connectivity to the Atlan tenant on which this attribute is intended to be created
     * @param displayName human-readable name of the attribute
     * @param type primitive type of the attribute
     * @param optionsName name of the options (enumeration) if the primitive type is an enumeration (can be null otherwise)
     * @param multiValued true if multiple values are allowed for the attribute, otherwise false
     * @param otherOptions other options to set on the attribute
     * @return the attribute definition
     * @throws AtlanException if there is any API error trying to construct the attribute (usually due to a non-existent enumeration)
     */
    public static AttributeDef of(AtlanClient client, String displayName, AtlanCustomAttributePrimitiveType type, String optionsName, boolean multiValued, AttributeDefOptions otherOptions) throws AtlanException {
        AttributeDefBuilder<?, ?> builder = AttributeDef.builder().displayName(displayName);
        String baseType;
        boolean addEnumValues = false;
        switch (type) {
        case OPTIONS: 
            baseType = optionsName;
            addEnumValues = true;
            break;
        case USERS: 
        case GROUPS: 
        case URL: 
        case SQL: 
            baseType = AtlanCustomAttributePrimitiveType.STRING.getValue();
            break;
        default: 
            baseType = type.getValue();
            break;
        }
        if (multiValued) {
            builder.typeName("array<" + baseType + ">").options(AttributeDefOptions.of(type, optionsName, otherOptions).toBuilder().multiValueSelect(true).build());
        } else {
            builder.typeName(baseType).options(AttributeDefOptions.of(type, optionsName, otherOptions));
        }
        if (addEnumValues) {
            builder.enumValues(client.getEnumCache().getByName(optionsName).getValidValues());
        }
        return builder.build();
    }

    /**
     * Build up an attribute definition from the provided parameters and default settings for all other parameters.
     * NOTE: INTERNAL USE ONLY.
     *
     * @param name name of the attribute
     * @param type primitive type of the attribute (non-enum, non-struct)
     * @return a builder for an attribute definition
     */
    public static AttributeDefBuilder<?, ?> creator(String name, AtlanAttributeType type) {
        return creator(name, type, null, AtlanCustomAttributeCardinality.SINGLE);
    }

    /**
     * Build up an attribute definition from the provided parameters and default settings for all other parameters.
     * NOTE: INTERNAL USE ONLY.
     *
     * @param name name of the attribute
     * @param type type of the attribute
     * @param relatedObjectType name of the enumeration or struct, if the attribute type is an enumeration or struct (can be null otherwise)
     * @param cardinality whether the attribute is single or multivalued
     * @return a builder for an attribute definition
     */
    public static AttributeDefBuilder<?, ?> creator(String name, AtlanAttributeType type, String relatedObjectType, AtlanCustomAttributeCardinality cardinality) {
        String typeName;
        switch (type) {
        case ENUM: 
        case STRUCT: 
            typeName = relatedObjectType;
            break;
        default: 
            typeName = type.getValue();
            break;
        }
        if (cardinality != AtlanCustomAttributeCardinality.SINGLE) {
            typeName = "array<" + typeName + ">";
        }
        return AttributeDef.builder().name(name).typeName(typeName).cardinality(cardinality);
    }

    /**
     * Internal hashed-string name for the attribute.
     */
    @JsonInclude(JsonInclude.Include.ALWAYS)
    String name;
    /**
     * Human-readable name of the attribute.
     */
    String displayName;
    /**
     * Explanation of the attribute.
     */
    @JsonInclude(JsonInclude.Include.ALWAYS)
    String description;
    /**
     * Type of the attribute.
     * <ul>
     *   <li>This can either be a primitive Atlan type or the name of a custom metadata enumeration (options).</li>
     *   <li>The primitive Atlan types' values are defined in the {@link AtlanCustomAttributePrimitiveType} enumeration.</li>
     *   <li>Note: there are a number of custom types there as well ({@code users}, {@code groups}, {@code url}, and {@code SQL}). The {@code typeName} for all of these custom types is {@code STRING}, and the more detailed type only appears in the {@link #options}.</li>
     *   <li>For fields that can be multivalued, use {@code array<type>} for the typeName.</li>
     * </ul>
     */
    String typeName;
    /**
     * Specifies an (optional) default value for the attribute.
     */
    String defaultValue;
    /**
     * Indicates whether the attribute has a default value of being empty (true) or not (false).
     */
    Boolean isDefaultValueNull;
    /**
     * Indicates whether the attribute is mandatory (false) or optional (true).
     */
    Boolean isOptional;
    /**
     * Specifies whether the attribute is single or multivalued.
     */
    AtlanCustomAttributeCardinality cardinality;
    /**
     * Specifies the minimum number of values the attribute can have.
     */
    Long valuesMinCount;
    /**
     * Specifies the maximum number of values the attribute can have.
     */
    Long valuesMaxCount;
    /**
     * Specifies whether the attribute must have unique values (true) or not (false).
     */
    Boolean isUnique;
    /**
     * Specifies whether the attribute can be searched (true) or not (false).
     */
    Boolean isIndexable;
    /**
     * Whether changes to this attribute's value generate an event (true) or not (false).
     */
    Boolean includeInNotification;
    /**
     * TBC
     */
    final Boolean skipScrubbing;
    /**
     * TBC
     */
    final Long searchWeight;
    /**
     * TBC
     */
    final String indexType;
    /**
     * Options for the attribute.
     */
    AttributeDefOptions options;
    /**
     * Whether the attribute is being newly created (true) or not (false).
     */
    Boolean isNew;
    /**
     * List of values for an enumeration.
     */
    List<String> enumValues;
    /**
     * TBC
     */
    final List<Constraint> constraints;
    /**
     * TBC
     */
    final Map<String, String> indexTypeESConfig;
    /**
     * TBC
     */
    final Map<String, Map<String, String>> indexTypeESFields;
    /**
     * TBC
     */
    final Map<String, List<String>> autoUpdateAttributes;

    /**
     * Whether this attribute is archived (true) or active (false).
     * @return boolean
     */
    @JsonIgnore
    public boolean isArchived() {
        return options != null && options.getIsArchived() != null && options.getIsArchived();
    }

    /**
     * Determine the basic type of this attribute (irrespective of whether it is multivalued or not).
     * For example, the basic type of {@code array<string>} is just {@code string}.
     *
     * @return the basic type of this attribute
     */
    @JsonIgnore
    public String getBasicType() {
        return getBasicType(getTypeName());
    }

    /**
     * Determine the container of this attribute, if any.
     * For example, the container of {@code array<string>} is a list or sorted set.
     *
     * @return the container of this attribute, if any, or null if it is a single-valued attribute
     */
    @JsonIgnore
    public String getContainerType() {
        return getContainerType(getTypeName());
    }

    /**
     * Determine the basic type of the attribute (irrespective of whether it is multivalued or not).
     * For example, the basic type of {@code array<string>} is just {@code string}.
     *
     * @param type typeName of the attribute
     * @return the basic type of this attribute
     */
    public static String getBasicType(String type) {
        String baseType = type;
        if (type.contains("<")) {
            if (type.startsWith("array<")) {
                if (type.startsWith("array<map<")) {
                    baseType = getEmbeddedType(type.substring("array<".length(), type.length() - 1));
                } else {
                    baseType = getEmbeddedType(type);
                }
            } else if (type.startsWith("map<")) {
                baseType = getEmbeddedType(type);
            }
        }
        return baseType;
    }

    /**
     * Determine the container of the attribute, if any.
     * For example, the container of {@code array<string>} is a list or sorted set.
     *
     * @param type typeName of the attribute
     * @return the container of this attribute, if any, or null if it is a single-valued attribute
     */
    public static String getContainerType(String type) {
        String container = null;
        if (type.contains("<")) {
            if (type.startsWith("array<")) {
                if (type.startsWith("array<map<")) {
                    container = "List<Map<";
                } else {
                    container = "SortedSet<";
                }
            } else if (type.startsWith("map<")) {
                container = "Map<";
            }
        }
        return container;
    }

    /**
     * Determine the primitive type of the attribute when it's values are contained in an
     * array or map.
     *
     * @param attrType data type of the attribute
     * @return the primitive contained type of the attribute's values
     */
    private static String getEmbeddedType(String attrType) {
        return attrType.substring(attrType.indexOf("<") + 1, attrType.indexOf(">"));
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int compareTo(AttributeDef o) {
        return attributeDefComparator.compare(this, o);
    }


    public static abstract class AttributeDefBuilder<C extends AttributeDef, B extends AttributeDef.AttributeDefBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean name$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String name$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String displayName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean description$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String description$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String defaultValue;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isDefaultValueNull;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean isOptional$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isOptional$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean cardinality$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanCustomAttributeCardinality cardinality$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean valuesMinCount$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long valuesMinCount$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean valuesMaxCount$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long valuesMaxCount$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean isUnique$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isUnique$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean isIndexable$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isIndexable$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean includeInNotification$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean includeInNotification$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean skipScrubbing;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long searchWeight;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String indexType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AttributeDefOptions options;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean isNew$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isNew$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> enumValues;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<Constraint> constraints;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, String> indexTypeESConfig;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, Map<String, String>> indexTypeESFields;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, List<String>> autoUpdateAttributes;

        /**
         * Mark this attribute definition as archived. Note that this will only do so if
         * the attribute is already defined (i.e. has some options). Otherwise, this operation does
         * nothing to the attribute definition.
         *
         * @param by name of the user who is archiving the attribute definition
         */
        public B archive(String by) {
            if (options != null) {
                long removalEpoch = Instant.now().toEpochMilli();
                options = options.toBuilder().isArchived(true).archivedBy(by).archivedAt(removalEpoch).build();
                displayName = displayName + "-archived-" + removalEpoch;
            }
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AttributeDef.AttributeDefBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AttributeDef instance, final AttributeDef.AttributeDefBuilder<?, ?> b) {
            b.name(instance.name);
            b.displayName(instance.displayName);
            b.description(instance.description);
            b.typeName(instance.typeName);
            b.defaultValue(instance.defaultValue);
            b.isDefaultValueNull(instance.isDefaultValueNull);
            b.isOptional(instance.isOptional);
            b.cardinality(instance.cardinality);
            b.valuesMinCount(instance.valuesMinCount);
            b.valuesMaxCount(instance.valuesMaxCount);
            b.isUnique(instance.isUnique);
            b.isIndexable(instance.isIndexable);
            b.includeInNotification(instance.includeInNotification);
            b.skipScrubbing(instance.skipScrubbing);
            b.searchWeight(instance.searchWeight);
            b.indexType(instance.indexType);
            b.options(instance.options);
            b.isNew(instance.isNew);
            b.enumValues(instance.enumValues == null ? java.util.Collections.<String>emptyList() : instance.enumValues);
            b.constraints(instance.constraints);
            b.indexTypeESConfig(instance.indexTypeESConfig);
            b.indexTypeESFields(instance.indexTypeESFields);
            b.autoUpdateAttributes(instance.autoUpdateAttributes);
        }

        /**
         * Internal hashed-string name for the attribute.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B name(final String name) {
            this.name$value = name;
            name$set = true;
            return self();
        }

        /**
         * Human-readable name of the attribute.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B displayName(final String displayName) {
            this.displayName = displayName;
            return self();
        }

        /**
         * Explanation of the attribute.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B description(final String description) {
            this.description$value = description;
            description$set = true;
            return self();
        }

        /**
         * Type of the attribute.
         * <ul>
         *   <li>This can either be a primitive Atlan type or the name of a custom metadata enumeration (options).</li>
         *   <li>The primitive Atlan types' values are defined in the {@link AtlanCustomAttributePrimitiveType} enumeration.</li>
         *   <li>Note: there are a number of custom types there as well ({@code users}, {@code groups}, {@code url}, and {@code SQL}). The {@code typeName} for all of these custom types is {@code STRING}, and the more detailed type only appears in the {@link #options}.</li>
         *   <li>For fields that can be multivalued, use {@code array<type>} for the typeName.</li>
         * </ul>
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeName(final String typeName) {
            this.typeName = typeName;
            return self();
        }

        /**
         * Specifies an (optional) default value for the attribute.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B defaultValue(final String defaultValue) {
            this.defaultValue = defaultValue;
            return self();
        }

        /**
         * Indicates whether the attribute has a default value of being empty (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isDefaultValueNull(final Boolean isDefaultValueNull) {
            this.isDefaultValueNull = isDefaultValueNull;
            return self();
        }

        /**
         * Indicates whether the attribute is mandatory (false) or optional (true).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isOptional(final Boolean isOptional) {
            this.isOptional$value = isOptional;
            isOptional$set = true;
            return self();
        }

        /**
         * Specifies whether the attribute is single or multivalued.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cardinality(final AtlanCustomAttributeCardinality cardinality) {
            this.cardinality$value = cardinality;
            cardinality$set = true;
            return self();
        }

        /**
         * Specifies the minimum number of values the attribute can have.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B valuesMinCount(final Long valuesMinCount) {
            this.valuesMinCount$value = valuesMinCount;
            valuesMinCount$set = true;
            return self();
        }

        /**
         * Specifies the maximum number of values the attribute can have.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B valuesMaxCount(final Long valuesMaxCount) {
            this.valuesMaxCount$value = valuesMaxCount;
            valuesMaxCount$set = true;
            return self();
        }

        /**
         * Specifies whether the attribute must have unique values (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isUnique(final Boolean isUnique) {
            this.isUnique$value = isUnique;
            isUnique$set = true;
            return self();
        }

        /**
         * Specifies whether the attribute can be searched (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isIndexable(final Boolean isIndexable) {
            this.isIndexable$value = isIndexable;
            isIndexable$set = true;
            return self();
        }

        /**
         * Whether changes to this attribute's value generate an event (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B includeInNotification(final Boolean includeInNotification) {
            this.includeInNotification$value = includeInNotification;
            includeInNotification$set = true;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B skipScrubbing(final Boolean skipScrubbing) {
            this.skipScrubbing = skipScrubbing;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B searchWeight(final Long searchWeight) {
            this.searchWeight = searchWeight;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B indexType(final String indexType) {
            this.indexType = indexType;
            return self();
        }

        /**
         * Options for the attribute.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B options(final AttributeDefOptions options) {
            this.options = options;
            return self();
        }

        /**
         * Whether the attribute is being newly created (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isNew(final Boolean isNew) {
            this.isNew$value = isNew;
            isNew$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B enumValue(final String enumValue) {
            if (this.enumValues == null) this.enumValues = new java.util.ArrayList<String>();
            this.enumValues.add(enumValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B enumValues(final java.util.Collection<? extends String> enumValues) {
            if (enumValues == null) {
                throw new java.lang.NullPointerException("enumValues cannot be null");
            }
            if (this.enumValues == null) this.enumValues = new java.util.ArrayList<String>();
            this.enumValues.addAll(enumValues);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearEnumValues() {
            if (this.enumValues != null) this.enumValues.clear();
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B constraints(final List<Constraint> constraints) {
            this.constraints = constraints;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B indexTypeESConfig(final Map<String, String> indexTypeESConfig) {
            this.indexTypeESConfig = indexTypeESConfig;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B indexTypeESFields(final Map<String, Map<String, String>> indexTypeESFields) {
            this.indexTypeESFields = indexTypeESFields;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B autoUpdateAttributes(final Map<String, List<String>> autoUpdateAttributes) {
            this.autoUpdateAttributes = autoUpdateAttributes;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AttributeDef.AttributeDefBuilder(super=" + super.toString() + ", name$value=" + this.name$value + ", displayName=" + this.displayName + ", description$value=" + this.description$value + ", typeName=" + this.typeName + ", defaultValue=" + this.defaultValue + ", isDefaultValueNull=" + this.isDefaultValueNull + ", isOptional$value=" + this.isOptional$value + ", cardinality$value=" + this.cardinality$value + ", valuesMinCount$value=" + this.valuesMinCount$value + ", valuesMaxCount$value=" + this.valuesMaxCount$value + ", isUnique$value=" + this.isUnique$value + ", isIndexable$value=" + this.isIndexable$value + ", includeInNotification$value=" + this.includeInNotification$value + ", skipScrubbing=" + this.skipScrubbing + ", searchWeight=" + this.searchWeight + ", indexType=" + this.indexType + ", options=" + this.options + ", isNew$value=" + this.isNew$value + ", enumValues=" + this.enumValues + ", constraints=" + this.constraints + ", indexTypeESConfig=" + this.indexTypeESConfig + ", indexTypeESFields=" + this.indexTypeESFields + ", autoUpdateAttributes=" + this.autoUpdateAttributes + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$name() {
        return "";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$description() {
        return "";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$isOptional() {
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static AtlanCustomAttributeCardinality $default$cardinality() {
        return AtlanCustomAttributeCardinality.SINGLE;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Long $default$valuesMinCount() {
        return 0L;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Long $default$valuesMaxCount() {
        return 1L;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$isUnique() {
        return false;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$isIndexable() {
        return false;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$includeInNotification() {
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$isNew() {
        return true;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class AttributeDefBuilderImpl extends AttributeDef.AttributeDefBuilder<AttributeDef, AttributeDef.AttributeDefBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AttributeDefBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AttributeDef.AttributeDefBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AttributeDef build() {
            return new AttributeDef(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AttributeDef(final AttributeDef.AttributeDefBuilder<?, ?> b) {
        super(b);
        if (b.name$set) this.name = b.name$value;
         else this.name = AttributeDef.$default$name();
        this.displayName = b.displayName;
        if (b.description$set) this.description = b.description$value;
         else this.description = AttributeDef.$default$description();
        this.typeName = b.typeName;
        this.defaultValue = b.defaultValue;
        this.isDefaultValueNull = b.isDefaultValueNull;
        if (b.isOptional$set) this.isOptional = b.isOptional$value;
         else this.isOptional = AttributeDef.$default$isOptional();
        if (b.cardinality$set) this.cardinality = b.cardinality$value;
         else this.cardinality = AttributeDef.$default$cardinality();
        if (b.valuesMinCount$set) this.valuesMinCount = b.valuesMinCount$value;
         else this.valuesMinCount = AttributeDef.$default$valuesMinCount();
        if (b.valuesMaxCount$set) this.valuesMaxCount = b.valuesMaxCount$value;
         else this.valuesMaxCount = AttributeDef.$default$valuesMaxCount();
        if (b.isUnique$set) this.isUnique = b.isUnique$value;
         else this.isUnique = AttributeDef.$default$isUnique();
        if (b.isIndexable$set) this.isIndexable = b.isIndexable$value;
         else this.isIndexable = AttributeDef.$default$isIndexable();
        if (b.includeInNotification$set) this.includeInNotification = b.includeInNotification$value;
         else this.includeInNotification = AttributeDef.$default$includeInNotification();
        this.skipScrubbing = b.skipScrubbing;
        this.searchWeight = b.searchWeight;
        this.indexType = b.indexType;
        this.options = b.options;
        if (b.isNew$set) this.isNew = b.isNew$value;
         else this.isNew = AttributeDef.$default$isNew();
        java.util.List<String> enumValues;
        switch (b.enumValues == null ? 0 : b.enumValues.size()) {
        case 0: 
            enumValues = java.util.Collections.emptyList();
            break;
        case 1: 
            enumValues = java.util.Collections.singletonList(b.enumValues.get(0));
            break;
        default: 
            enumValues = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(b.enumValues));
        }
        this.enumValues = enumValues;
        this.constraints = b.constraints;
        this.indexTypeESConfig = b.indexTypeESConfig;
        this.indexTypeESFields = b.indexTypeESFields;
        this.autoUpdateAttributes = b.autoUpdateAttributes;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AttributeDef.AttributeDefBuilder<?, ?> builder() {
        return new AttributeDef.AttributeDefBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AttributeDef.AttributeDefBuilder<?, ?> toBuilder() {
        return new AttributeDef.AttributeDefBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Internal hashed-string name for the attribute.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
        return this.name;
    }

    /**
     * Human-readable name of the attribute.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDisplayName() {
        return this.displayName;
    }

    /**
     * Explanation of the attribute.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Type of the attribute.
     * <ul>
     *   <li>This can either be a primitive Atlan type or the name of a custom metadata enumeration (options).</li>
     *   <li>The primitive Atlan types' values are defined in the {@link AtlanCustomAttributePrimitiveType} enumeration.</li>
     *   <li>Note: there are a number of custom types there as well ({@code users}, {@code groups}, {@code url}, and {@code SQL}). The {@code typeName} for all of these custom types is {@code STRING}, and the more detailed type only appears in the {@link #options}.</li>
     *   <li>For fields that can be multivalued, use {@code array<type>} for the typeName.</li>
     * </ul>
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeName() {
        return this.typeName;
    }

    /**
     * Specifies an (optional) default value for the attribute.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDefaultValue() {
        return this.defaultValue;
    }

    /**
     * Indicates whether the attribute has a default value of being empty (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsDefaultValueNull() {
        return this.isDefaultValueNull;
    }

    /**
     * Indicates whether the attribute is mandatory (false) or optional (true).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsOptional() {
        return this.isOptional;
    }

    /**
     * Specifies whether the attribute is single or multivalued.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanCustomAttributeCardinality getCardinality() {
        return this.cardinality;
    }

    /**
     * Specifies the minimum number of values the attribute can have.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getValuesMinCount() {
        return this.valuesMinCount;
    }

    /**
     * Specifies the maximum number of values the attribute can have.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getValuesMaxCount() {
        return this.valuesMaxCount;
    }

    /**
     * Specifies whether the attribute must have unique values (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsUnique() {
        return this.isUnique;
    }

    /**
     * Specifies whether the attribute can be searched (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsIndexable() {
        return this.isIndexable;
    }

    /**
     * Whether changes to this attribute's value generate an event (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIncludeInNotification() {
        return this.includeInNotification;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getSkipScrubbing() {
        return this.skipScrubbing;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getSearchWeight() {
        return this.searchWeight;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIndexType() {
        return this.indexType;
    }

    /**
     * Options for the attribute.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AttributeDefOptions getOptions() {
        return this.options;
    }

    /**
     * Whether the attribute is being newly created (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsNew() {
        return this.isNew;
    }

    /**
     * List of values for an enumeration.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getEnumValues() {
        return this.enumValues;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getIndexTypeESConfig() {
        return this.indexTypeESConfig;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Map<String, String>> getIndexTypeESFields() {
        return this.indexTypeESFields;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, List<String>> getAutoUpdateAttributes() {
        return this.autoUpdateAttributes;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AttributeDef)) return false;
        final AttributeDef other = (AttributeDef) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$isDefaultValueNull = this.getIsDefaultValueNull();
        final java.lang.Object other$isDefaultValueNull = other.getIsDefaultValueNull();
        if (this$isDefaultValueNull == null ? other$isDefaultValueNull != null : !this$isDefaultValueNull.equals(other$isDefaultValueNull)) return false;
        final java.lang.Object this$isOptional = this.getIsOptional();
        final java.lang.Object other$isOptional = other.getIsOptional();
        if (this$isOptional == null ? other$isOptional != null : !this$isOptional.equals(other$isOptional)) return false;
        final java.lang.Object this$valuesMinCount = this.getValuesMinCount();
        final java.lang.Object other$valuesMinCount = other.getValuesMinCount();
        if (this$valuesMinCount == null ? other$valuesMinCount != null : !this$valuesMinCount.equals(other$valuesMinCount)) return false;
        final java.lang.Object this$valuesMaxCount = this.getValuesMaxCount();
        final java.lang.Object other$valuesMaxCount = other.getValuesMaxCount();
        if (this$valuesMaxCount == null ? other$valuesMaxCount != null : !this$valuesMaxCount.equals(other$valuesMaxCount)) return false;
        final java.lang.Object this$isUnique = this.getIsUnique();
        final java.lang.Object other$isUnique = other.getIsUnique();
        if (this$isUnique == null ? other$isUnique != null : !this$isUnique.equals(other$isUnique)) return false;
        final java.lang.Object this$isIndexable = this.getIsIndexable();
        final java.lang.Object other$isIndexable = other.getIsIndexable();
        if (this$isIndexable == null ? other$isIndexable != null : !this$isIndexable.equals(other$isIndexable)) return false;
        final java.lang.Object this$includeInNotification = this.getIncludeInNotification();
        final java.lang.Object other$includeInNotification = other.getIncludeInNotification();
        if (this$includeInNotification == null ? other$includeInNotification != null : !this$includeInNotification.equals(other$includeInNotification)) return false;
        final java.lang.Object this$skipScrubbing = this.getSkipScrubbing();
        final java.lang.Object other$skipScrubbing = other.getSkipScrubbing();
        if (this$skipScrubbing == null ? other$skipScrubbing != null : !this$skipScrubbing.equals(other$skipScrubbing)) return false;
        final java.lang.Object this$searchWeight = this.getSearchWeight();
        final java.lang.Object other$searchWeight = other.getSearchWeight();
        if (this$searchWeight == null ? other$searchWeight != null : !this$searchWeight.equals(other$searchWeight)) return false;
        final java.lang.Object this$isNew = this.getIsNew();
        final java.lang.Object other$isNew = other.getIsNew();
        if (this$isNew == null ? other$isNew != null : !this$isNew.equals(other$isNew)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$displayName = this.getDisplayName();
        final java.lang.Object other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) return false;
        final java.lang.Object this$description = this.getDescription();
        final java.lang.Object other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
        final java.lang.Object this$typeName = this.getTypeName();
        final java.lang.Object other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) return false;
        final java.lang.Object this$defaultValue = this.getDefaultValue();
        final java.lang.Object other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) return false;
        final java.lang.Object this$cardinality = this.getCardinality();
        final java.lang.Object other$cardinality = other.getCardinality();
        if (this$cardinality == null ? other$cardinality != null : !this$cardinality.equals(other$cardinality)) return false;
        final java.lang.Object this$indexType = this.getIndexType();
        final java.lang.Object other$indexType = other.getIndexType();
        if (this$indexType == null ? other$indexType != null : !this$indexType.equals(other$indexType)) return false;
        final java.lang.Object this$options = this.getOptions();
        final java.lang.Object other$options = other.getOptions();
        if (this$options == null ? other$options != null : !this$options.equals(other$options)) return false;
        final java.lang.Object this$enumValues = this.getEnumValues();
        final java.lang.Object other$enumValues = other.getEnumValues();
        if (this$enumValues == null ? other$enumValues != null : !this$enumValues.equals(other$enumValues)) return false;
        final java.lang.Object this$constraints = this.getConstraints();
        final java.lang.Object other$constraints = other.getConstraints();
        if (this$constraints == null ? other$constraints != null : !this$constraints.equals(other$constraints)) return false;
        final java.lang.Object this$indexTypeESConfig = this.getIndexTypeESConfig();
        final java.lang.Object other$indexTypeESConfig = other.getIndexTypeESConfig();
        if (this$indexTypeESConfig == null ? other$indexTypeESConfig != null : !this$indexTypeESConfig.equals(other$indexTypeESConfig)) return false;
        final java.lang.Object this$indexTypeESFields = this.getIndexTypeESFields();
        final java.lang.Object other$indexTypeESFields = other.getIndexTypeESFields();
        if (this$indexTypeESFields == null ? other$indexTypeESFields != null : !this$indexTypeESFields.equals(other$indexTypeESFields)) return false;
        final java.lang.Object this$autoUpdateAttributes = this.getAutoUpdateAttributes();
        final java.lang.Object other$autoUpdateAttributes = other.getAutoUpdateAttributes();
        if (this$autoUpdateAttributes == null ? other$autoUpdateAttributes != null : !this$autoUpdateAttributes.equals(other$autoUpdateAttributes)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AttributeDef;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $isDefaultValueNull = this.getIsDefaultValueNull();
        result = result * PRIME + ($isDefaultValueNull == null ? 43 : $isDefaultValueNull.hashCode());
        final java.lang.Object $isOptional = this.getIsOptional();
        result = result * PRIME + ($isOptional == null ? 43 : $isOptional.hashCode());
        final java.lang.Object $valuesMinCount = this.getValuesMinCount();
        result = result * PRIME + ($valuesMinCount == null ? 43 : $valuesMinCount.hashCode());
        final java.lang.Object $valuesMaxCount = this.getValuesMaxCount();
        result = result * PRIME + ($valuesMaxCount == null ? 43 : $valuesMaxCount.hashCode());
        final java.lang.Object $isUnique = this.getIsUnique();
        result = result * PRIME + ($isUnique == null ? 43 : $isUnique.hashCode());
        final java.lang.Object $isIndexable = this.getIsIndexable();
        result = result * PRIME + ($isIndexable == null ? 43 : $isIndexable.hashCode());
        final java.lang.Object $includeInNotification = this.getIncludeInNotification();
        result = result * PRIME + ($includeInNotification == null ? 43 : $includeInNotification.hashCode());
        final java.lang.Object $skipScrubbing = this.getSkipScrubbing();
        result = result * PRIME + ($skipScrubbing == null ? 43 : $skipScrubbing.hashCode());
        final java.lang.Object $searchWeight = this.getSearchWeight();
        result = result * PRIME + ($searchWeight == null ? 43 : $searchWeight.hashCode());
        final java.lang.Object $isNew = this.getIsNew();
        result = result * PRIME + ($isNew == null ? 43 : $isNew.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $displayName = this.getDisplayName();
        result = result * PRIME + ($displayName == null ? 43 : $displayName.hashCode());
        final java.lang.Object $description = this.getDescription();
        result = result * PRIME + ($description == null ? 43 : $description.hashCode());
        final java.lang.Object $typeName = this.getTypeName();
        result = result * PRIME + ($typeName == null ? 43 : $typeName.hashCode());
        final java.lang.Object $defaultValue = this.getDefaultValue();
        result = result * PRIME + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        final java.lang.Object $cardinality = this.getCardinality();
        result = result * PRIME + ($cardinality == null ? 43 : $cardinality.hashCode());
        final java.lang.Object $indexType = this.getIndexType();
        result = result * PRIME + ($indexType == null ? 43 : $indexType.hashCode());
        final java.lang.Object $options = this.getOptions();
        result = result * PRIME + ($options == null ? 43 : $options.hashCode());
        final java.lang.Object $enumValues = this.getEnumValues();
        result = result * PRIME + ($enumValues == null ? 43 : $enumValues.hashCode());
        final java.lang.Object $constraints = this.getConstraints();
        result = result * PRIME + ($constraints == null ? 43 : $constraints.hashCode());
        final java.lang.Object $indexTypeESConfig = this.getIndexTypeESConfig();
        result = result * PRIME + ($indexTypeESConfig == null ? 43 : $indexTypeESConfig.hashCode());
        final java.lang.Object $indexTypeESFields = this.getIndexTypeESFields();
        result = result * PRIME + ($indexTypeESFields == null ? 43 : $indexTypeESFields.hashCode());
        final java.lang.Object $autoUpdateAttributes = this.getAutoUpdateAttributes();
        result = result * PRIME + ($autoUpdateAttributes == null ? 43 : $autoUpdateAttributes.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AttributeDef(super=" + super.toString() + ", name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", typeName=" + this.getTypeName() + ", defaultValue=" + this.getDefaultValue() + ", isDefaultValueNull=" + this.getIsDefaultValueNull() + ", isOptional=" + this.getIsOptional() + ", cardinality=" + this.getCardinality() + ", valuesMinCount=" + this.getValuesMinCount() + ", valuesMaxCount=" + this.getValuesMaxCount() + ", isUnique=" + this.getIsUnique() + ", isIndexable=" + this.getIsIndexable() + ", includeInNotification=" + this.getIncludeInNotification() + ", skipScrubbing=" + this.getSkipScrubbing() + ", searchWeight=" + this.getSearchWeight() + ", indexType=" + this.getIndexType() + ", options=" + this.getOptions() + ", isNew=" + this.getIsNew() + ", enumValues=" + this.getEnumValues() + ", constraints=" + this.getConstraints() + ", indexTypeESConfig=" + this.getIndexTypeESConfig() + ", indexTypeESFields=" + this.getIndexTypeESFields() + ", autoUpdateAttributes=" + this.getAutoUpdateAttributes() + ")";
    }
}
