// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.typedefs;

import com.atlan.exception.AtlanException;
import com.atlan.model.assets.*;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanCustomAttributePrimitiveType;
import com.atlan.serde.SetToStringSerializer;
import com.atlan.serde.StringToSetDeserializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Set;
import javax.annotation.processing.Generated;

/**
 * Options that can be set on each attribute within a type definition.
 */
@Generated("com.atlan.generators.ModelGeneratorV2")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = AttributeDefOptions.AttributeDefOptionsBuilderImpl.class)
public class AttributeDefOptions extends AtlanObject {
    private static final long serialVersionUID = 2L;
    public static final Set<String> ALL_ASSET_TYPES = Set.of(ADLSAccount.TYPE_NAME, ADLSContainer.TYPE_NAME, ADLSObject.TYPE_NAME, APIPath.TYPE_NAME, APISpec.TYPE_NAME, AirflowDag.TYPE_NAME, AirflowTask.TYPE_NAME, AnomaloCheck.TYPE_NAME, AtlanCollection.TYPE_NAME, AtlanQuery.TYPE_NAME, AuthPolicy.TYPE_NAME, AuthService.TYPE_NAME, AzureEventHub.TYPE_NAME, AzureEventHubConsumerGroup.TYPE_NAME, AzureServiceBusNamespace.TYPE_NAME, AzureServiceBusTopic.TYPE_NAME, BIProcess.TYPE_NAME, Badge.TYPE_NAME, BusinessPolicy.TYPE_NAME, BusinessPolicyException.TYPE_NAME, BusinessPolicyIncident.TYPE_NAME, BusinessPolicyLog.TYPE_NAME, CalculationView.TYPE_NAME, Cognite3DModel.TYPE_NAME, CogniteAsset.TYPE_NAME, CogniteEvent.TYPE_NAME, CogniteFile.TYPE_NAME, CogniteSequence.TYPE_NAME, CogniteTimeSeries.TYPE_NAME, CognosDashboard.TYPE_NAME, CognosDatasource.TYPE_NAME, CognosExploration.TYPE_NAME, CognosFile.TYPE_NAME, CognosFolder.TYPE_NAME, CognosModule.TYPE_NAME, CognosPackage.TYPE_NAME, CognosReport.TYPE_NAME, Column.TYPE_NAME, ColumnProcess.TYPE_NAME, Connection.TYPE_NAME, CosmosMongoDBAccount.TYPE_NAME, CosmosMongoDBCollection.TYPE_NAME, CosmosMongoDBDatabase.TYPE_NAME, Cube.TYPE_NAME, CubeDimension.TYPE_NAME, CubeField.TYPE_NAME, CubeHierarchy.TYPE_NAME, DMAttribute.TYPE_NAME, DMAttributeAssociation.TYPE_NAME, DMDataModel.TYPE_NAME, DMEntity.TYPE_NAME, DMEntityAssociation.TYPE_NAME, DMVersion.TYPE_NAME, DataContract.TYPE_NAME, DataStudioAsset.TYPE_NAME, Database.TYPE_NAME, DatabricksUnityCatalogTag.TYPE_NAME, DbtColumnProcess.TYPE_NAME, DbtMetric.TYPE_NAME, DbtModel.TYPE_NAME, DbtModelColumn.TYPE_NAME, DbtProcess.TYPE_NAME, DbtSource.TYPE_NAME, DbtTag.TYPE_NAME, DbtTest.TYPE_NAME, DomoCard.TYPE_NAME, DomoDashboard.TYPE_NAME, DomoDataset.TYPE_NAME, DomoDatasetColumn.TYPE_NAME, DynamoDBGlobalSecondaryIndex.TYPE_NAME, DynamoDBLocalSecondaryIndex.TYPE_NAME, DynamoDBTable.TYPE_NAME, Folder.TYPE_NAME, Function.TYPE_NAME, GCSBucket.TYPE_NAME, GCSObject.TYPE_NAME, Insight.TYPE_NAME, KafkaConsumerGroup.TYPE_NAME, KafkaTopic.TYPE_NAME, LineageProcess.TYPE_NAME, Link.TYPE_NAME, LookerDashboard.TYPE_NAME, LookerExplore.TYPE_NAME, LookerField.TYPE_NAME, LookerFolder.TYPE_NAME, LookerLook.TYPE_NAME, LookerModel.TYPE_NAME, LookerProject.TYPE_NAME, LookerQuery.TYPE_NAME, LookerTile.TYPE_NAME, LookerView.TYPE_NAME, MCIncident.TYPE_NAME, MCMonitor.TYPE_NAME, MaterializedView.TYPE_NAME, MatillionComponent.TYPE_NAME, MatillionGroup.TYPE_NAME, MatillionJob.TYPE_NAME, MatillionProject.TYPE_NAME, MetabaseCollection.TYPE_NAME, MetabaseDashboard.TYPE_NAME, MetabaseQuestion.TYPE_NAME, MicroStrategyAttribute.TYPE_NAME, MicroStrategyCube.TYPE_NAME, MicroStrategyDocument.TYPE_NAME, MicroStrategyDossier.TYPE_NAME, MicroStrategyFact.TYPE_NAME, MicroStrategyMetric.TYPE_NAME, MicroStrategyProject.TYPE_NAME, MicroStrategyReport.TYPE_NAME, MicroStrategyVisualization.TYPE_NAME, ModeChart.TYPE_NAME, ModeCollection.TYPE_NAME, ModeQuery.TYPE_NAME, ModeReport.TYPE_NAME, ModeWorkspace.TYPE_NAME, ModelAttribute.TYPE_NAME, ModelAttributeAssociation.TYPE_NAME, ModelDataModel.TYPE_NAME, ModelEntity.TYPE_NAME, ModelEntityAssociation.TYPE_NAME, ModelVersion.TYPE_NAME, MongoDBCollection.TYPE_NAME, MongoDBDatabase.TYPE_NAME, Persona.TYPE_NAME, PowerBIColumn.TYPE_NAME, PowerBIDashboard.TYPE_NAME, PowerBIDataflow.TYPE_NAME, PowerBIDataset.TYPE_NAME, PowerBIDatasource.TYPE_NAME, PowerBIMeasure.TYPE_NAME, PowerBIPage.TYPE_NAME, PowerBIReport.TYPE_NAME, PowerBITable.TYPE_NAME, PowerBITile.TYPE_NAME, PowerBIWorkspace.TYPE_NAME, PresetChart.TYPE_NAME, PresetDashboard.TYPE_NAME, PresetDataset.TYPE_NAME, PresetWorkspace.TYPE_NAME, Procedure.TYPE_NAME, Purpose.TYPE_NAME, QlikApp.TYPE_NAME, QlikChart.TYPE_NAME, QlikDataset.TYPE_NAME, QlikSheet.TYPE_NAME, QlikSpace.TYPE_NAME, QlikStream.TYPE_NAME, QuickSightAnalysis.TYPE_NAME, QuickSightAnalysisVisual.TYPE_NAME, QuickSightDashboard.TYPE_NAME, QuickSightDashboardVisual.TYPE_NAME, QuickSightDataset.TYPE_NAME, QuickSightDatasetField.TYPE_NAME, QuickSightFolder.TYPE_NAME, Readme.TYPE_NAME, ReadmeTemplate.TYPE_NAME, RedashDashboard.TYPE_NAME, RedashQuery.TYPE_NAME, RedashVisualization.TYPE_NAME, S3Bucket.TYPE_NAME, S3Object.TYPE_NAME, SalesforceDashboard.TYPE_NAME, SalesforceField.TYPE_NAME, SalesforceObject.TYPE_NAME, SalesforceOrganization.TYPE_NAME, SalesforceReport.TYPE_NAME, Schema.TYPE_NAME, SchemaRegistrySubject.TYPE_NAME, SigmaDataElement.TYPE_NAME, SigmaDataElementField.TYPE_NAME, SigmaDataset.TYPE_NAME, SigmaDatasetColumn.TYPE_NAME, SigmaPage.TYPE_NAME, SigmaWorkbook.TYPE_NAME, SisenseDashboard.TYPE_NAME, SisenseDatamodel.TYPE_NAME, SisenseDatamodelTable.TYPE_NAME, SisenseFolder.TYPE_NAME, SisenseWidget.TYPE_NAME, SnowflakeDynamicTable.TYPE_NAME, SnowflakePipe.TYPE_NAME, SnowflakeStream.TYPE_NAME, SnowflakeTag.TYPE_NAME, SodaCheck.TYPE_NAME, SparkJob.TYPE_NAME, Stakeholder.TYPE_NAME, StakeholderTitle.TYPE_NAME, SupersetChart.TYPE_NAME, SupersetDashboard.TYPE_NAME, SupersetDataset.TYPE_NAME, Table.TYPE_NAME, TablePartition.TYPE_NAME, TableauCalculatedField.TYPE_NAME, TableauDashboard.TYPE_NAME, TableauDatasource.TYPE_NAME, TableauDatasourceField.TYPE_NAME, TableauFlow.TYPE_NAME, TableauMetric.TYPE_NAME, TableauProject.TYPE_NAME, TableauSite.TYPE_NAME, TableauWorkbook.TYPE_NAME, TableauWorksheet.TYPE_NAME, TagAttachment.TYPE_NAME, Task.TYPE_NAME, ThoughtspotAnswer.TYPE_NAME, ThoughtspotColumn.TYPE_NAME, ThoughtspotDashlet.TYPE_NAME, ThoughtspotLiveboard.TYPE_NAME, ThoughtspotTable.TYPE_NAME, ThoughtspotView.TYPE_NAME, ThoughtspotWorksheet.TYPE_NAME, View.TYPE_NAME, Workflow.TYPE_NAME, WorkflowRun.TYPE_NAME);
    public static final Set<String> ALL_GLOSSARY_TYPES = Set.of(Glossary.TYPE_NAME, GlossaryTerm.TYPE_NAME, GlossaryCategory.TYPE_NAME);
    public static final Set<String> ALL_DOMAIN_TYPES = Set.of(DataDomain.TYPE_NAME, DataProduct.TYPE_NAME);
    public static final Set<String> ALL_OTHER_TYPES = Set.of(File.TYPE_NAME);
    public static final Set<String> ALL_DOMAINS = Set.of("*/super");

    /**
     * Instantiate a new set of attribute options from the provided parameters.
     * @param type primitive type of the attribute
     * @param optionsName name of the options (enumeration) if the primitive type is an enumeration (can be null otherwise)
     * @return the attribute options
     * @throws AtlanException on any API issues looking up existing connections and glossaries
     */
    public static AttributeDefOptions of(AtlanCustomAttributePrimitiveType type, String optionsName) throws AtlanException {
        return of(type, optionsName, null);
    }

    /**
     * Instantiate a new set of attribute options from the provided parameters.
     * @param type primitive type of the attribute
     * @param optionsName name of the options (enumeration) if the primitive type is an enumeration (can be null otherwise)
     * @param options starting point of options on which to extend
     * @return the attribute options
     * @throws AtlanException on any API issues looking up existing connections and glossaries
     */
    public static AttributeDefOptions of(AtlanCustomAttributePrimitiveType type, String optionsName, AttributeDefOptions options) throws AtlanException {
        AttributeDefOptionsBuilder<?, ?> builder;
        if (options != null) {
            // If we are provided options, use those as the starting point
            builder = options.toBuilder();
        } else {
            // Otherwise set defaults to allow the attribute to be available on all assets
            builder = AttributeDefOptions.builder().applicableConnections(Connection.getAllQualifiedNames()).applicableAssetTypes(ALL_ASSET_TYPES).applicableGlossaries(Glossary.getAllQualifiedNames()).applicableGlossaryTypes(ALL_GLOSSARY_TYPES).applicableDomains(ALL_DOMAINS).applicableDomainTypes(ALL_DOMAIN_TYPES).applicableOtherAssetTypes(ALL_OTHER_TYPES);
        }
        builder.primitiveType(type);
        switch (type) {
        case USERS: 
        case GROUPS: 
        case URL: 
        case SQL: 
            builder.customType(type.getValue());
            break;
        case OPTIONS: 
            builder.isEnum(true).enumType(optionsName);
            break;
        default: 
            // do nothing
            break;
        }
        return builder.build();
    }

    /**
     * Indicates the version of the custom metadata structure. This determines which other options are available and used.
     */
    String customMetadataVersion;
    /**
     * Optional description of the attribute.
     */
    String description;
    /**
     * Set of entities on which this attribute can be applied.
     * Note: generally this should be left as-is. Any overrides should instead be applied through
     * one or more of {@link #applicableAssetTypes}, {@link #applicableGlossaryTypes}, or {@link #applicableOtherAssetTypes}.
     */
    @JsonSerialize(using = SetToStringSerializer.class)
    @JsonDeserialize(using = StringToSetDeserializer.class)
    Set<String> applicableEntityTypes;
    /**
     * Set of entities on which this attribute should appear.
     * Note: this is only used when customMetadataVersion is less than v2.
     * @deprecated see {@link #applicableAssetTypes}, {@link #applicableGlossaryTypes}, {@link #applicableOtherAssetTypes} instead
     */
    @JsonSerialize(using = SetToStringSerializer.class)
    @JsonDeserialize(using = StringToSetDeserializer.class)
    @Deprecated
    Set<String> customApplicableEntityTypes;
    /**
     * Qualified names of connections to which to restrict the attribute.
     * Only assets within one of these connections will have this attribute available.
     * To further restrict the types of assets within the connections, see {@link #applicableAssetTypes}.
     */
    @JsonSerialize(using = SetToStringSerializer.class)
    @JsonDeserialize(using = StringToSetDeserializer.class)
    Set<String> applicableConnections;
    /**
     * Qualified names of glossaries to which to restrict the attribute.
     * Only glossary assets within one of these glossaries will have this attribute available.
     * To further restrict the types of assets within the glossaries, see {@link #applicableGlossaryTypes}.
     */
    @JsonSerialize(using = SetToStringSerializer.class)
    @JsonDeserialize(using = StringToSetDeserializer.class)
    Set<String> applicableGlossaries;
    /**
     * Qualified names of domains to which to restrict the attribute.
     * Only domains and data products within one of these domains will have this attribute available.
     * To further restrict the types of assets within the domains, see {@link #applicableDomainTypes}.
     */
    @JsonSerialize(using = SetToStringSerializer.class)
    @JsonDeserialize(using = StringToSetDeserializer.class)
    Set<String> applicableDomains;
    /**
     * Asset type names to which to restrict the attribute.
     * Only assets of one of these types will have this attribute available.
     * To further restrict the assets for this custom metadata by connection, see {@link #applicableConnections}.
     */
    @JsonSerialize(using = SetToStringSerializer.class)
    @JsonDeserialize(using = StringToSetDeserializer.class)
    @JsonProperty("assetTypesList")
    Set<String> applicableAssetTypes;
    /**
     * Glossary type names to which to restrict the attribute.
     * Only glossary assets of one of these types will have this attribute available.
     * To further restrict the glossary content for this custom metadata by glossary, see {@link #applicableGlossaries}.
     */
    @JsonSerialize(using = SetToStringSerializer.class)
    @JsonDeserialize(using = StringToSetDeserializer.class)
    @JsonProperty("glossaryTypeList")
    Set<String> applicableGlossaryTypes;
    /**
     * Data product type names to which to restrict the attribute.
     * These cover asset types in data products and data domains.
     * Only assets of one of these types will have this attribute available.
     */
    @JsonSerialize(using = SetToStringSerializer.class)
    @JsonDeserialize(using = StringToSetDeserializer.class)
    @JsonProperty("domainTypesList")
    Set<String> applicableDomainTypes;
    /**
     * Any other asset type names to which to restrict the attribute.
     * These cover any asset type that is not managed within a connection or a glossary.
     * Only assets of one of these types will have this attribute available.
     */
    @JsonSerialize(using = SetToStringSerializer.class)
    @JsonDeserialize(using = StringToSetDeserializer.class)
    @JsonProperty("otherAssetTypeList")
    Set<String> applicableOtherAssetTypes;
    /**
     * Whether the attribute should be searchable (true) or not (false).
     */
    Boolean allowSearch;
    /**
     * Maximum length allowed for a string value.
     */
    String maxStrLength;
    /**
     * Whether this attribute should appear in the filterable facets of discovery (true) or not (false).
     */
    Boolean allowFiltering;
    /**
     * Whether this attribute can have multiple values (true) or only a single value (false).
     */
    Boolean multiValueSelect;
    /**
     * Whether users will see this attribute in the overview tab of the sidebar (true) or not (false).
     */
    Boolean showInOverview;
    /**
     * Whether the attribute is deprecated ("true") or not (null or "false").
     */
    String isDeprecated;
    /**
     * Primitive type of the attribute.
     */
    AtlanCustomAttributePrimitiveType primitiveType;
    /**
     * Whether the attribute is an enumeration (true) or not (false).
     */
    Boolean isEnum;
    /**
     * Name of the enumeration (options), when the attribute is an enumeration.
     */
    String enumType;
    /**
     * Used for Atlan-specific types like {@code users}, {@code groups}, {@code url}, and {@code SQL}.
     */
    String customType;
    /**
     * If true for a date attribute, then time-level precision is also available in the UI (otherwise only date-level)
     */
    Boolean hasTimePrecision;
    /**
     * Whether the attribute has been deleted (true) or is still active (false).
     */
    Boolean isArchived;
    /**
     * When the attribute was deleted.
     */
    Long archivedAt;
    /**
     * User who deleted the attribute.
     */
    String archivedBy;
    /**
     * TBC
     */
    String isSoftReference;
    /**
     * TBC
     */
    String isAppendOnPartialUpdate;

    /**
     * Append the provided set of attribute definition options onto this attribute definition.
     * Note that certain options are ignored by the append, specifically: primitiveType, isEnum,
     * enumType, customType, multiValueSelect, isArchived, archivedAt, archivedBy. These should only be set
     * by the appropriate initial setup {@link #of(AtlanCustomAttributePrimitiveType, String)} or archival
     * of an attribute definition.
     *
     * @param options to append to this set of attribute definition options
     * @return the combined set of attribute definition options
     */
    public AttributeDefOptions append(AttributeDefOptions options) {
        if (options == null) {
            return this;
        }
        if (options.description != null) {
            this.description = options.description;
        }
        if (options.applicableEntityTypes != null) {
            this.applicableEntityTypes = options.applicableEntityTypes;
        }
        if (options.customApplicableEntityTypes != null) {
            this.customApplicableEntityTypes = options.customApplicableEntityTypes;
        }
        if (options.applicableConnections != null) {
            this.applicableConnections = options.applicableConnections;
        }
        if (options.applicableGlossaries != null) {
            this.applicableGlossaries = options.applicableGlossaries;
        }
        if (options.applicableDomains != null) {
            this.applicableDomains = options.applicableDomains;
        }
        if (options.applicableAssetTypes != null) {
            this.applicableAssetTypes = options.applicableAssetTypes;
        }
        if (options.applicableGlossaryTypes != null) {
            this.applicableGlossaryTypes = options.applicableGlossaryTypes;
        }
        if (options.applicableDomainTypes != null) {
            this.applicableDomainTypes = options.applicableDomainTypes;
        }
        if (options.applicableOtherAssetTypes != null) {
            this.applicableOtherAssetTypes = options.applicableOtherAssetTypes;
        }
        if (options.allowSearch != null) {
            this.allowSearch = options.allowSearch;
        }
        if (options.maxStrLength != null) {
            this.maxStrLength = options.maxStrLength;
        }
        if (options.allowFiltering != null) {
            this.allowFiltering = options.allowFiltering;
        }
        if (options.showInOverview != null) {
            this.showInOverview = options.showInOverview;
        }
        if (options.isDeprecated != null) {
            this.isDeprecated = options.isDeprecated;
        }
        if (options.hasTimePrecision != null) {
            this.hasTimePrecision = options.hasTimePrecision;
        }
        return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$customMetadataVersion() {
        return "v2";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Set<String> $default$applicableEntityTypes() {
        return Set.of("Asset");
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$allowSearch() {
        return false;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static String $default$maxStrLength() {
        return "100000000";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$allowFiltering() {
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$multiValueSelect() {
        return false;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$showInOverview() {
        return false;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$isEnum() {
        return false;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class AttributeDefOptionsBuilder<C extends AttributeDefOptions, B extends AttributeDefOptions.AttributeDefOptionsBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean customMetadataVersion$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String customMetadataVersion$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String description;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean applicableEntityTypes$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Set<String> applicableEntityTypes$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Set<String> customApplicableEntityTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> applicableConnections;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> applicableGlossaries;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> applicableDomains;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> applicableAssetTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> applicableGlossaryTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> applicableDomainTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> applicableOtherAssetTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean allowSearch$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean allowSearch$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean maxStrLength$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String maxStrLength$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean allowFiltering$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean allowFiltering$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean multiValueSelect$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean multiValueSelect$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean showInOverview$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean showInOverview$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String isDeprecated;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanCustomAttributePrimitiveType primitiveType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean isEnum$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isEnum$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String enumType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String customType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean hasTimePrecision;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isArchived;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long archivedAt;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String archivedBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String isSoftReference;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String isAppendOnPartialUpdate;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            AttributeDefOptions.AttributeDefOptionsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final AttributeDefOptions instance, final AttributeDefOptions.AttributeDefOptionsBuilder<?, ?> b) {
            b.customMetadataVersion(instance.customMetadataVersion);
            b.description(instance.description);
            b.applicableEntityTypes(instance.applicableEntityTypes);
            b.customApplicableEntityTypes(instance.customApplicableEntityTypes);
            b.applicableConnections(instance.applicableConnections == null ? java.util.Collections.<String>emptySet() : instance.applicableConnections);
            b.applicableGlossaries(instance.applicableGlossaries == null ? java.util.Collections.<String>emptySet() : instance.applicableGlossaries);
            b.applicableDomains(instance.applicableDomains == null ? java.util.Collections.<String>emptySet() : instance.applicableDomains);
            b.applicableAssetTypes(instance.applicableAssetTypes == null ? java.util.Collections.<String>emptySet() : instance.applicableAssetTypes);
            b.applicableGlossaryTypes(instance.applicableGlossaryTypes == null ? java.util.Collections.<String>emptySet() : instance.applicableGlossaryTypes);
            b.applicableDomainTypes(instance.applicableDomainTypes == null ? java.util.Collections.<String>emptySet() : instance.applicableDomainTypes);
            b.applicableOtherAssetTypes(instance.applicableOtherAssetTypes == null ? java.util.Collections.<String>emptySet() : instance.applicableOtherAssetTypes);
            b.allowSearch(instance.allowSearch);
            b.maxStrLength(instance.maxStrLength);
            b.allowFiltering(instance.allowFiltering);
            b.multiValueSelect(instance.multiValueSelect);
            b.showInOverview(instance.showInOverview);
            b.isDeprecated(instance.isDeprecated);
            b.primitiveType(instance.primitiveType);
            b.isEnum(instance.isEnum);
            b.enumType(instance.enumType);
            b.customType(instance.customType);
            b.hasTimePrecision(instance.hasTimePrecision);
            b.isArchived(instance.isArchived);
            b.archivedAt(instance.archivedAt);
            b.archivedBy(instance.archivedBy);
            b.isSoftReference(instance.isSoftReference);
            b.isAppendOnPartialUpdate(instance.isAppendOnPartialUpdate);
        }

        /**
         * Indicates the version of the custom metadata structure. This determines which other options are available and used.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B customMetadataVersion(final String customMetadataVersion) {
            this.customMetadataVersion$value = customMetadataVersion;
            customMetadataVersion$set = true;
            return self();
        }

        /**
         * Optional description of the attribute.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B description(final String description) {
            this.description = description;
            return self();
        }

        /**
         * Set of entities on which this attribute can be applied.
         * Note: generally this should be left as-is. Any overrides should instead be applied through
         * one or more of {@link #applicableAssetTypes}, {@link #applicableGlossaryTypes}, or {@link #applicableOtherAssetTypes}.
         * @return {@code this}.
         */
        @JsonDeserialize(using = StringToSetDeserializer.class)
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B applicableEntityTypes(final Set<String> applicableEntityTypes) {
            this.applicableEntityTypes$value = applicableEntityTypes;
            applicableEntityTypes$set = true;
            return self();
        }

        /**
         * Set of entities on which this attribute should appear.
         * Note: this is only used when customMetadataVersion is less than v2.
         * @deprecated see {@link #applicableAssetTypes}, {@link #applicableGlossaryTypes}, {@link #applicableOtherAssetTypes} instead
         * @return {@code this}.
         */
        @java.lang.Deprecated
        @JsonDeserialize(using = StringToSetDeserializer.class)
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B customApplicableEntityTypes(final Set<String> customApplicableEntityTypes) {
            this.customApplicableEntityTypes = customApplicableEntityTypes;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B applicableConnection(final String applicableConnection) {
            if (this.applicableConnections == null) this.applicableConnections = new java.util.ArrayList<String>();
            this.applicableConnections.add(applicableConnection);
            return self();
        }

        @JsonDeserialize(using = StringToSetDeserializer.class)
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B applicableConnections(final java.util.Collection<? extends String> applicableConnections) {
            if (applicableConnections == null) {
                throw new java.lang.NullPointerException("applicableConnections cannot be null");
            }
            if (this.applicableConnections == null) this.applicableConnections = new java.util.ArrayList<String>();
            this.applicableConnections.addAll(applicableConnections);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearApplicableConnections() {
            if (this.applicableConnections != null) this.applicableConnections.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B applicableGlossary(final String applicableGlossary) {
            if (this.applicableGlossaries == null) this.applicableGlossaries = new java.util.ArrayList<String>();
            this.applicableGlossaries.add(applicableGlossary);
            return self();
        }

        @JsonDeserialize(using = StringToSetDeserializer.class)
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B applicableGlossaries(final java.util.Collection<? extends String> applicableGlossaries) {
            if (applicableGlossaries == null) {
                throw new java.lang.NullPointerException("applicableGlossaries cannot be null");
            }
            if (this.applicableGlossaries == null) this.applicableGlossaries = new java.util.ArrayList<String>();
            this.applicableGlossaries.addAll(applicableGlossaries);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearApplicableGlossaries() {
            if (this.applicableGlossaries != null) this.applicableGlossaries.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B applicableDomain(final String applicableDomain) {
            if (this.applicableDomains == null) this.applicableDomains = new java.util.ArrayList<String>();
            this.applicableDomains.add(applicableDomain);
            return self();
        }

        @JsonDeserialize(using = StringToSetDeserializer.class)
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B applicableDomains(final java.util.Collection<? extends String> applicableDomains) {
            if (applicableDomains == null) {
                throw new java.lang.NullPointerException("applicableDomains cannot be null");
            }
            if (this.applicableDomains == null) this.applicableDomains = new java.util.ArrayList<String>();
            this.applicableDomains.addAll(applicableDomains);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearApplicableDomains() {
            if (this.applicableDomains != null) this.applicableDomains.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B applicableAssetType(final String applicableAssetType) {
            if (this.applicableAssetTypes == null) this.applicableAssetTypes = new java.util.ArrayList<String>();
            this.applicableAssetTypes.add(applicableAssetType);
            return self();
        }

        @JsonDeserialize(using = StringToSetDeserializer.class)
        @JsonProperty("assetTypesList")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B applicableAssetTypes(final java.util.Collection<? extends String> applicableAssetTypes) {
            if (applicableAssetTypes == null) {
                throw new java.lang.NullPointerException("applicableAssetTypes cannot be null");
            }
            if (this.applicableAssetTypes == null) this.applicableAssetTypes = new java.util.ArrayList<String>();
            this.applicableAssetTypes.addAll(applicableAssetTypes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearApplicableAssetTypes() {
            if (this.applicableAssetTypes != null) this.applicableAssetTypes.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B applicableGlossaryType(final String applicableGlossaryType) {
            if (this.applicableGlossaryTypes == null) this.applicableGlossaryTypes = new java.util.ArrayList<String>();
            this.applicableGlossaryTypes.add(applicableGlossaryType);
            return self();
        }

        @JsonDeserialize(using = StringToSetDeserializer.class)
        @JsonProperty("glossaryTypeList")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B applicableGlossaryTypes(final java.util.Collection<? extends String> applicableGlossaryTypes) {
            if (applicableGlossaryTypes == null) {
                throw new java.lang.NullPointerException("applicableGlossaryTypes cannot be null");
            }
            if (this.applicableGlossaryTypes == null) this.applicableGlossaryTypes = new java.util.ArrayList<String>();
            this.applicableGlossaryTypes.addAll(applicableGlossaryTypes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearApplicableGlossaryTypes() {
            if (this.applicableGlossaryTypes != null) this.applicableGlossaryTypes.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B applicableDomainType(final String applicableDomainType) {
            if (this.applicableDomainTypes == null) this.applicableDomainTypes = new java.util.ArrayList<String>();
            this.applicableDomainTypes.add(applicableDomainType);
            return self();
        }

        @JsonDeserialize(using = StringToSetDeserializer.class)
        @JsonProperty("domainTypesList")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B applicableDomainTypes(final java.util.Collection<? extends String> applicableDomainTypes) {
            if (applicableDomainTypes == null) {
                throw new java.lang.NullPointerException("applicableDomainTypes cannot be null");
            }
            if (this.applicableDomainTypes == null) this.applicableDomainTypes = new java.util.ArrayList<String>();
            this.applicableDomainTypes.addAll(applicableDomainTypes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearApplicableDomainTypes() {
            if (this.applicableDomainTypes != null) this.applicableDomainTypes.clear();
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B applicableOtherAssetType(final String applicableOtherAssetType) {
            if (this.applicableOtherAssetTypes == null) this.applicableOtherAssetTypes = new java.util.ArrayList<String>();
            this.applicableOtherAssetTypes.add(applicableOtherAssetType);
            return self();
        }

        @JsonDeserialize(using = StringToSetDeserializer.class)
        @JsonProperty("otherAssetTypeList")
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B applicableOtherAssetTypes(final java.util.Collection<? extends String> applicableOtherAssetTypes) {
            if (applicableOtherAssetTypes == null) {
                throw new java.lang.NullPointerException("applicableOtherAssetTypes cannot be null");
            }
            if (this.applicableOtherAssetTypes == null) this.applicableOtherAssetTypes = new java.util.ArrayList<String>();
            this.applicableOtherAssetTypes.addAll(applicableOtherAssetTypes);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearApplicableOtherAssetTypes() {
            if (this.applicableOtherAssetTypes != null) this.applicableOtherAssetTypes.clear();
            return self();
        }

        /**
         * Whether the attribute should be searchable (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B allowSearch(final Boolean allowSearch) {
            this.allowSearch$value = allowSearch;
            allowSearch$set = true;
            return self();
        }

        /**
         * Maximum length allowed for a string value.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B maxStrLength(final String maxStrLength) {
            this.maxStrLength$value = maxStrLength;
            maxStrLength$set = true;
            return self();
        }

        /**
         * Whether this attribute should appear in the filterable facets of discovery (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B allowFiltering(final Boolean allowFiltering) {
            this.allowFiltering$value = allowFiltering;
            allowFiltering$set = true;
            return self();
        }

        /**
         * Whether this attribute can have multiple values (true) or only a single value (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B multiValueSelect(final Boolean multiValueSelect) {
            this.multiValueSelect$value = multiValueSelect;
            multiValueSelect$set = true;
            return self();
        }

        /**
         * Whether users will see this attribute in the overview tab of the sidebar (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B showInOverview(final Boolean showInOverview) {
            this.showInOverview$value = showInOverview;
            showInOverview$set = true;
            return self();
        }

        /**
         * Whether the attribute is deprecated ("true") or not (null or "false").
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isDeprecated(final String isDeprecated) {
            this.isDeprecated = isDeprecated;
            return self();
        }

        /**
         * Primitive type of the attribute.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B primitiveType(final AtlanCustomAttributePrimitiveType primitiveType) {
            this.primitiveType = primitiveType;
            return self();
        }

        /**
         * Whether the attribute is an enumeration (true) or not (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isEnum(final Boolean isEnum) {
            this.isEnum$value = isEnum;
            isEnum$set = true;
            return self();
        }

        /**
         * Name of the enumeration (options), when the attribute is an enumeration.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B enumType(final String enumType) {
            this.enumType = enumType;
            return self();
        }

        /**
         * Used for Atlan-specific types like {@code users}, {@code groups}, {@code url}, and {@code SQL}.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B customType(final String customType) {
            this.customType = customType;
            return self();
        }

        /**
         * If true for a date attribute, then time-level precision is also available in the UI (otherwise only date-level)
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B hasTimePrecision(final Boolean hasTimePrecision) {
            this.hasTimePrecision = hasTimePrecision;
            return self();
        }

        /**
         * Whether the attribute has been deleted (true) or is still active (false).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isArchived(final Boolean isArchived) {
            this.isArchived = isArchived;
            return self();
        }

        /**
         * When the attribute was deleted.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B archivedAt(final Long archivedAt) {
            this.archivedAt = archivedAt;
            return self();
        }

        /**
         * User who deleted the attribute.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B archivedBy(final String archivedBy) {
            this.archivedBy = archivedBy;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isSoftReference(final String isSoftReference) {
            this.isSoftReference = isSoftReference;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isAppendOnPartialUpdate(final String isAppendOnPartialUpdate) {
            this.isAppendOnPartialUpdate = isAppendOnPartialUpdate;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "AttributeDefOptions.AttributeDefOptionsBuilder(super=" + super.toString() + ", customMetadataVersion$value=" + this.customMetadataVersion$value + ", description=" + this.description + ", applicableEntityTypes$value=" + this.applicableEntityTypes$value + ", customApplicableEntityTypes=" + this.customApplicableEntityTypes + ", applicableConnections=" + this.applicableConnections + ", applicableGlossaries=" + this.applicableGlossaries + ", applicableDomains=" + this.applicableDomains + ", applicableAssetTypes=" + this.applicableAssetTypes + ", applicableGlossaryTypes=" + this.applicableGlossaryTypes + ", applicableDomainTypes=" + this.applicableDomainTypes + ", applicableOtherAssetTypes=" + this.applicableOtherAssetTypes + ", allowSearch$value=" + this.allowSearch$value + ", maxStrLength$value=" + this.maxStrLength$value + ", allowFiltering$value=" + this.allowFiltering$value + ", multiValueSelect$value=" + this.multiValueSelect$value + ", showInOverview$value=" + this.showInOverview$value + ", isDeprecated=" + this.isDeprecated + ", primitiveType=" + this.primitiveType + ", isEnum$value=" + this.isEnum$value + ", enumType=" + this.enumType + ", customType=" + this.customType + ", hasTimePrecision=" + this.hasTimePrecision + ", isArchived=" + this.isArchived + ", archivedAt=" + this.archivedAt + ", archivedBy=" + this.archivedBy + ", isSoftReference=" + this.isSoftReference + ", isAppendOnPartialUpdate=" + this.isAppendOnPartialUpdate + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class AttributeDefOptionsBuilderImpl extends AttributeDefOptions.AttributeDefOptionsBuilder<AttributeDefOptions, AttributeDefOptions.AttributeDefOptionsBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AttributeDefOptionsBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected AttributeDefOptions.AttributeDefOptionsBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public AttributeDefOptions build() {
            return new AttributeDefOptions(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AttributeDefOptions(final AttributeDefOptions.AttributeDefOptionsBuilder<?, ?> b) {
        super(b);
        if (b.customMetadataVersion$set) this.customMetadataVersion = b.customMetadataVersion$value;
         else this.customMetadataVersion = AttributeDefOptions.$default$customMetadataVersion();
        this.description = b.description;
        if (b.applicableEntityTypes$set) this.applicableEntityTypes = b.applicableEntityTypes$value;
         else this.applicableEntityTypes = AttributeDefOptions.$default$applicableEntityTypes();
        this.customApplicableEntityTypes = b.customApplicableEntityTypes;
        java.util.Set<String> applicableConnections;
        switch (b.applicableConnections == null ? 0 : b.applicableConnections.size()) {
        case 0: 
            applicableConnections = java.util.Collections.emptySet();
            break;
        case 1: 
            applicableConnections = java.util.Collections.singleton(b.applicableConnections.get(0));
            break;
        default: 
            applicableConnections = new java.util.LinkedHashSet<String>(b.applicableConnections.size() < 1073741824 ? 1 + b.applicableConnections.size() + (b.applicableConnections.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            applicableConnections.addAll(b.applicableConnections);
            applicableConnections = java.util.Collections.unmodifiableSet(applicableConnections);
        }
        this.applicableConnections = applicableConnections;
        java.util.Set<String> applicableGlossaries;
        switch (b.applicableGlossaries == null ? 0 : b.applicableGlossaries.size()) {
        case 0: 
            applicableGlossaries = java.util.Collections.emptySet();
            break;
        case 1: 
            applicableGlossaries = java.util.Collections.singleton(b.applicableGlossaries.get(0));
            break;
        default: 
            applicableGlossaries = new java.util.LinkedHashSet<String>(b.applicableGlossaries.size() < 1073741824 ? 1 + b.applicableGlossaries.size() + (b.applicableGlossaries.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            applicableGlossaries.addAll(b.applicableGlossaries);
            applicableGlossaries = java.util.Collections.unmodifiableSet(applicableGlossaries);
        }
        this.applicableGlossaries = applicableGlossaries;
        java.util.Set<String> applicableDomains;
        switch (b.applicableDomains == null ? 0 : b.applicableDomains.size()) {
        case 0: 
            applicableDomains = java.util.Collections.emptySet();
            break;
        case 1: 
            applicableDomains = java.util.Collections.singleton(b.applicableDomains.get(0));
            break;
        default: 
            applicableDomains = new java.util.LinkedHashSet<String>(b.applicableDomains.size() < 1073741824 ? 1 + b.applicableDomains.size() + (b.applicableDomains.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            applicableDomains.addAll(b.applicableDomains);
            applicableDomains = java.util.Collections.unmodifiableSet(applicableDomains);
        }
        this.applicableDomains = applicableDomains;
        java.util.Set<String> applicableAssetTypes;
        switch (b.applicableAssetTypes == null ? 0 : b.applicableAssetTypes.size()) {
        case 0: 
            applicableAssetTypes = java.util.Collections.emptySet();
            break;
        case 1: 
            applicableAssetTypes = java.util.Collections.singleton(b.applicableAssetTypes.get(0));
            break;
        default: 
            applicableAssetTypes = new java.util.LinkedHashSet<String>(b.applicableAssetTypes.size() < 1073741824 ? 1 + b.applicableAssetTypes.size() + (b.applicableAssetTypes.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            applicableAssetTypes.addAll(b.applicableAssetTypes);
            applicableAssetTypes = java.util.Collections.unmodifiableSet(applicableAssetTypes);
        }
        this.applicableAssetTypes = applicableAssetTypes;
        java.util.Set<String> applicableGlossaryTypes;
        switch (b.applicableGlossaryTypes == null ? 0 : b.applicableGlossaryTypes.size()) {
        case 0: 
            applicableGlossaryTypes = java.util.Collections.emptySet();
            break;
        case 1: 
            applicableGlossaryTypes = java.util.Collections.singleton(b.applicableGlossaryTypes.get(0));
            break;
        default: 
            applicableGlossaryTypes = new java.util.LinkedHashSet<String>(b.applicableGlossaryTypes.size() < 1073741824 ? 1 + b.applicableGlossaryTypes.size() + (b.applicableGlossaryTypes.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            applicableGlossaryTypes.addAll(b.applicableGlossaryTypes);
            applicableGlossaryTypes = java.util.Collections.unmodifiableSet(applicableGlossaryTypes);
        }
        this.applicableGlossaryTypes = applicableGlossaryTypes;
        java.util.Set<String> applicableDomainTypes;
        switch (b.applicableDomainTypes == null ? 0 : b.applicableDomainTypes.size()) {
        case 0: 
            applicableDomainTypes = java.util.Collections.emptySet();
            break;
        case 1: 
            applicableDomainTypes = java.util.Collections.singleton(b.applicableDomainTypes.get(0));
            break;
        default: 
            applicableDomainTypes = new java.util.LinkedHashSet<String>(b.applicableDomainTypes.size() < 1073741824 ? 1 + b.applicableDomainTypes.size() + (b.applicableDomainTypes.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            applicableDomainTypes.addAll(b.applicableDomainTypes);
            applicableDomainTypes = java.util.Collections.unmodifiableSet(applicableDomainTypes);
        }
        this.applicableDomainTypes = applicableDomainTypes;
        java.util.Set<String> applicableOtherAssetTypes;
        switch (b.applicableOtherAssetTypes == null ? 0 : b.applicableOtherAssetTypes.size()) {
        case 0: 
            applicableOtherAssetTypes = java.util.Collections.emptySet();
            break;
        case 1: 
            applicableOtherAssetTypes = java.util.Collections.singleton(b.applicableOtherAssetTypes.get(0));
            break;
        default: 
            applicableOtherAssetTypes = new java.util.LinkedHashSet<String>(b.applicableOtherAssetTypes.size() < 1073741824 ? 1 + b.applicableOtherAssetTypes.size() + (b.applicableOtherAssetTypes.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            applicableOtherAssetTypes.addAll(b.applicableOtherAssetTypes);
            applicableOtherAssetTypes = java.util.Collections.unmodifiableSet(applicableOtherAssetTypes);
        }
        this.applicableOtherAssetTypes = applicableOtherAssetTypes;
        if (b.allowSearch$set) this.allowSearch = b.allowSearch$value;
         else this.allowSearch = AttributeDefOptions.$default$allowSearch();
        if (b.maxStrLength$set) this.maxStrLength = b.maxStrLength$value;
         else this.maxStrLength = AttributeDefOptions.$default$maxStrLength();
        if (b.allowFiltering$set) this.allowFiltering = b.allowFiltering$value;
         else this.allowFiltering = AttributeDefOptions.$default$allowFiltering();
        if (b.multiValueSelect$set) this.multiValueSelect = b.multiValueSelect$value;
         else this.multiValueSelect = AttributeDefOptions.$default$multiValueSelect();
        if (b.showInOverview$set) this.showInOverview = b.showInOverview$value;
         else this.showInOverview = AttributeDefOptions.$default$showInOverview();
        this.isDeprecated = b.isDeprecated;
        this.primitiveType = b.primitiveType;
        if (b.isEnum$set) this.isEnum = b.isEnum$value;
         else this.isEnum = AttributeDefOptions.$default$isEnum();
        this.enumType = b.enumType;
        this.customType = b.customType;
        this.hasTimePrecision = b.hasTimePrecision;
        this.isArchived = b.isArchived;
        this.archivedAt = b.archivedAt;
        this.archivedBy = b.archivedBy;
        this.isSoftReference = b.isSoftReference;
        this.isAppendOnPartialUpdate = b.isAppendOnPartialUpdate;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static AttributeDefOptions.AttributeDefOptionsBuilder<?, ?> builder() {
        return new AttributeDefOptions.AttributeDefOptionsBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AttributeDefOptions.AttributeDefOptionsBuilder<?, ?> toBuilder() {
        return new AttributeDefOptions.AttributeDefOptionsBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Indicates the version of the custom metadata structure. This determines which other options are available and used.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCustomMetadataVersion() {
        return this.customMetadataVersion;
    }

    /**
     * Optional description of the attribute.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set of entities on which this attribute can be applied.
     * Note: generally this should be left as-is. Any overrides should instead be applied through
     * one or more of {@link #applicableAssetTypes}, {@link #applicableGlossaryTypes}, or {@link #applicableOtherAssetTypes}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Set<String> getApplicableEntityTypes() {
        return this.applicableEntityTypes;
    }

    /**
     * Set of entities on which this attribute should appear.
     * Note: this is only used when customMetadataVersion is less than v2.
     * @deprecated see {@link #applicableAssetTypes}, {@link #applicableGlossaryTypes}, {@link #applicableOtherAssetTypes} instead
     */
    @java.lang.Deprecated
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Set<String> getCustomApplicableEntityTypes() {
        return this.customApplicableEntityTypes;
    }

    /**
     * Qualified names of connections to which to restrict the attribute.
     * Only assets within one of these connections will have this attribute available.
     * To further restrict the types of assets within the connections, see {@link #applicableAssetTypes}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Set<String> getApplicableConnections() {
        return this.applicableConnections;
    }

    /**
     * Qualified names of glossaries to which to restrict the attribute.
     * Only glossary assets within one of these glossaries will have this attribute available.
     * To further restrict the types of assets within the glossaries, see {@link #applicableGlossaryTypes}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Set<String> getApplicableGlossaries() {
        return this.applicableGlossaries;
    }

    /**
     * Qualified names of domains to which to restrict the attribute.
     * Only domains and data products within one of these domains will have this attribute available.
     * To further restrict the types of assets within the domains, see {@link #applicableDomainTypes}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Set<String> getApplicableDomains() {
        return this.applicableDomains;
    }

    /**
     * Asset type names to which to restrict the attribute.
     * Only assets of one of these types will have this attribute available.
     * To further restrict the assets for this custom metadata by connection, see {@link #applicableConnections}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Set<String> getApplicableAssetTypes() {
        return this.applicableAssetTypes;
    }

    /**
     * Glossary type names to which to restrict the attribute.
     * Only glossary assets of one of these types will have this attribute available.
     * To further restrict the glossary content for this custom metadata by glossary, see {@link #applicableGlossaries}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Set<String> getApplicableGlossaryTypes() {
        return this.applicableGlossaryTypes;
    }

    /**
     * Data product type names to which to restrict the attribute.
     * These cover asset types in data products and data domains.
     * Only assets of one of these types will have this attribute available.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Set<String> getApplicableDomainTypes() {
        return this.applicableDomainTypes;
    }

    /**
     * Any other asset type names to which to restrict the attribute.
     * These cover any asset type that is not managed within a connection or a glossary.
     * Only assets of one of these types will have this attribute available.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Set<String> getApplicableOtherAssetTypes() {
        return this.applicableOtherAssetTypes;
    }

    /**
     * Whether the attribute should be searchable (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getAllowSearch() {
        return this.allowSearch;
    }

    /**
     * Maximum length allowed for a string value.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMaxStrLength() {
        return this.maxStrLength;
    }

    /**
     * Whether this attribute should appear in the filterable facets of discovery (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getAllowFiltering() {
        return this.allowFiltering;
    }

    /**
     * Whether this attribute can have multiple values (true) or only a single value (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getMultiValueSelect() {
        return this.multiValueSelect;
    }

    /**
     * Whether users will see this attribute in the overview tab of the sidebar (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getShowInOverview() {
        return this.showInOverview;
    }

    /**
     * Whether the attribute is deprecated ("true") or not (null or "false").
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIsDeprecated() {
        return this.isDeprecated;
    }

    /**
     * Primitive type of the attribute.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanCustomAttributePrimitiveType getPrimitiveType() {
        return this.primitiveType;
    }

    /**
     * Whether the attribute is an enumeration (true) or not (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsEnum() {
        return this.isEnum;
    }

    /**
     * Name of the enumeration (options), when the attribute is an enumeration.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEnumType() {
        return this.enumType;
    }

    /**
     * Used for Atlan-specific types like {@code users}, {@code groups}, {@code url}, and {@code SQL}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCustomType() {
        return this.customType;
    }

    /**
     * If true for a date attribute, then time-level precision is also available in the UI (otherwise only date-level)
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getHasTimePrecision() {
        return this.hasTimePrecision;
    }

    /**
     * Whether the attribute has been deleted (true) or is still active (false).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsArchived() {
        return this.isArchived;
    }

    /**
     * When the attribute was deleted.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getArchivedAt() {
        return this.archivedAt;
    }

    /**
     * User who deleted the attribute.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getArchivedBy() {
        return this.archivedBy;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIsSoftReference() {
        return this.isSoftReference;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIsAppendOnPartialUpdate() {
        return this.isAppendOnPartialUpdate;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AttributeDefOptions)) return false;
        final AttributeDefOptions other = (AttributeDefOptions) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$allowSearch = this.getAllowSearch();
        final java.lang.Object other$allowSearch = other.getAllowSearch();
        if (this$allowSearch == null ? other$allowSearch != null : !this$allowSearch.equals(other$allowSearch)) return false;
        final java.lang.Object this$allowFiltering = this.getAllowFiltering();
        final java.lang.Object other$allowFiltering = other.getAllowFiltering();
        if (this$allowFiltering == null ? other$allowFiltering != null : !this$allowFiltering.equals(other$allowFiltering)) return false;
        final java.lang.Object this$multiValueSelect = this.getMultiValueSelect();
        final java.lang.Object other$multiValueSelect = other.getMultiValueSelect();
        if (this$multiValueSelect == null ? other$multiValueSelect != null : !this$multiValueSelect.equals(other$multiValueSelect)) return false;
        final java.lang.Object this$showInOverview = this.getShowInOverview();
        final java.lang.Object other$showInOverview = other.getShowInOverview();
        if (this$showInOverview == null ? other$showInOverview != null : !this$showInOverview.equals(other$showInOverview)) return false;
        final java.lang.Object this$isEnum = this.getIsEnum();
        final java.lang.Object other$isEnum = other.getIsEnum();
        if (this$isEnum == null ? other$isEnum != null : !this$isEnum.equals(other$isEnum)) return false;
        final java.lang.Object this$hasTimePrecision = this.getHasTimePrecision();
        final java.lang.Object other$hasTimePrecision = other.getHasTimePrecision();
        if (this$hasTimePrecision == null ? other$hasTimePrecision != null : !this$hasTimePrecision.equals(other$hasTimePrecision)) return false;
        final java.lang.Object this$isArchived = this.getIsArchived();
        final java.lang.Object other$isArchived = other.getIsArchived();
        if (this$isArchived == null ? other$isArchived != null : !this$isArchived.equals(other$isArchived)) return false;
        final java.lang.Object this$archivedAt = this.getArchivedAt();
        final java.lang.Object other$archivedAt = other.getArchivedAt();
        if (this$archivedAt == null ? other$archivedAt != null : !this$archivedAt.equals(other$archivedAt)) return false;
        final java.lang.Object this$customMetadataVersion = this.getCustomMetadataVersion();
        final java.lang.Object other$customMetadataVersion = other.getCustomMetadataVersion();
        if (this$customMetadataVersion == null ? other$customMetadataVersion != null : !this$customMetadataVersion.equals(other$customMetadataVersion)) return false;
        final java.lang.Object this$description = this.getDescription();
        final java.lang.Object other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
        final java.lang.Object this$applicableEntityTypes = this.getApplicableEntityTypes();
        final java.lang.Object other$applicableEntityTypes = other.getApplicableEntityTypes();
        if (this$applicableEntityTypes == null ? other$applicableEntityTypes != null : !this$applicableEntityTypes.equals(other$applicableEntityTypes)) return false;
        final java.lang.Object this$customApplicableEntityTypes = this.getCustomApplicableEntityTypes();
        final java.lang.Object other$customApplicableEntityTypes = other.getCustomApplicableEntityTypes();
        if (this$customApplicableEntityTypes == null ? other$customApplicableEntityTypes != null : !this$customApplicableEntityTypes.equals(other$customApplicableEntityTypes)) return false;
        final java.lang.Object this$applicableConnections = this.getApplicableConnections();
        final java.lang.Object other$applicableConnections = other.getApplicableConnections();
        if (this$applicableConnections == null ? other$applicableConnections != null : !this$applicableConnections.equals(other$applicableConnections)) return false;
        final java.lang.Object this$applicableGlossaries = this.getApplicableGlossaries();
        final java.lang.Object other$applicableGlossaries = other.getApplicableGlossaries();
        if (this$applicableGlossaries == null ? other$applicableGlossaries != null : !this$applicableGlossaries.equals(other$applicableGlossaries)) return false;
        final java.lang.Object this$applicableDomains = this.getApplicableDomains();
        final java.lang.Object other$applicableDomains = other.getApplicableDomains();
        if (this$applicableDomains == null ? other$applicableDomains != null : !this$applicableDomains.equals(other$applicableDomains)) return false;
        final java.lang.Object this$applicableAssetTypes = this.getApplicableAssetTypes();
        final java.lang.Object other$applicableAssetTypes = other.getApplicableAssetTypes();
        if (this$applicableAssetTypes == null ? other$applicableAssetTypes != null : !this$applicableAssetTypes.equals(other$applicableAssetTypes)) return false;
        final java.lang.Object this$applicableGlossaryTypes = this.getApplicableGlossaryTypes();
        final java.lang.Object other$applicableGlossaryTypes = other.getApplicableGlossaryTypes();
        if (this$applicableGlossaryTypes == null ? other$applicableGlossaryTypes != null : !this$applicableGlossaryTypes.equals(other$applicableGlossaryTypes)) return false;
        final java.lang.Object this$applicableDomainTypes = this.getApplicableDomainTypes();
        final java.lang.Object other$applicableDomainTypes = other.getApplicableDomainTypes();
        if (this$applicableDomainTypes == null ? other$applicableDomainTypes != null : !this$applicableDomainTypes.equals(other$applicableDomainTypes)) return false;
        final java.lang.Object this$applicableOtherAssetTypes = this.getApplicableOtherAssetTypes();
        final java.lang.Object other$applicableOtherAssetTypes = other.getApplicableOtherAssetTypes();
        if (this$applicableOtherAssetTypes == null ? other$applicableOtherAssetTypes != null : !this$applicableOtherAssetTypes.equals(other$applicableOtherAssetTypes)) return false;
        final java.lang.Object this$maxStrLength = this.getMaxStrLength();
        final java.lang.Object other$maxStrLength = other.getMaxStrLength();
        if (this$maxStrLength == null ? other$maxStrLength != null : !this$maxStrLength.equals(other$maxStrLength)) return false;
        final java.lang.Object this$isDeprecated = this.getIsDeprecated();
        final java.lang.Object other$isDeprecated = other.getIsDeprecated();
        if (this$isDeprecated == null ? other$isDeprecated != null : !this$isDeprecated.equals(other$isDeprecated)) return false;
        final java.lang.Object this$primitiveType = this.getPrimitiveType();
        final java.lang.Object other$primitiveType = other.getPrimitiveType();
        if (this$primitiveType == null ? other$primitiveType != null : !this$primitiveType.equals(other$primitiveType)) return false;
        final java.lang.Object this$enumType = this.getEnumType();
        final java.lang.Object other$enumType = other.getEnumType();
        if (this$enumType == null ? other$enumType != null : !this$enumType.equals(other$enumType)) return false;
        final java.lang.Object this$customType = this.getCustomType();
        final java.lang.Object other$customType = other.getCustomType();
        if (this$customType == null ? other$customType != null : !this$customType.equals(other$customType)) return false;
        final java.lang.Object this$archivedBy = this.getArchivedBy();
        final java.lang.Object other$archivedBy = other.getArchivedBy();
        if (this$archivedBy == null ? other$archivedBy != null : !this$archivedBy.equals(other$archivedBy)) return false;
        final java.lang.Object this$isSoftReference = this.getIsSoftReference();
        final java.lang.Object other$isSoftReference = other.getIsSoftReference();
        if (this$isSoftReference == null ? other$isSoftReference != null : !this$isSoftReference.equals(other$isSoftReference)) return false;
        final java.lang.Object this$isAppendOnPartialUpdate = this.getIsAppendOnPartialUpdate();
        final java.lang.Object other$isAppendOnPartialUpdate = other.getIsAppendOnPartialUpdate();
        if (this$isAppendOnPartialUpdate == null ? other$isAppendOnPartialUpdate != null : !this$isAppendOnPartialUpdate.equals(other$isAppendOnPartialUpdate)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AttributeDefOptions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $allowSearch = this.getAllowSearch();
        result = result * PRIME + ($allowSearch == null ? 43 : $allowSearch.hashCode());
        final java.lang.Object $allowFiltering = this.getAllowFiltering();
        result = result * PRIME + ($allowFiltering == null ? 43 : $allowFiltering.hashCode());
        final java.lang.Object $multiValueSelect = this.getMultiValueSelect();
        result = result * PRIME + ($multiValueSelect == null ? 43 : $multiValueSelect.hashCode());
        final java.lang.Object $showInOverview = this.getShowInOverview();
        result = result * PRIME + ($showInOverview == null ? 43 : $showInOverview.hashCode());
        final java.lang.Object $isEnum = this.getIsEnum();
        result = result * PRIME + ($isEnum == null ? 43 : $isEnum.hashCode());
        final java.lang.Object $hasTimePrecision = this.getHasTimePrecision();
        result = result * PRIME + ($hasTimePrecision == null ? 43 : $hasTimePrecision.hashCode());
        final java.lang.Object $isArchived = this.getIsArchived();
        result = result * PRIME + ($isArchived == null ? 43 : $isArchived.hashCode());
        final java.lang.Object $archivedAt = this.getArchivedAt();
        result = result * PRIME + ($archivedAt == null ? 43 : $archivedAt.hashCode());
        final java.lang.Object $customMetadataVersion = this.getCustomMetadataVersion();
        result = result * PRIME + ($customMetadataVersion == null ? 43 : $customMetadataVersion.hashCode());
        final java.lang.Object $description = this.getDescription();
        result = result * PRIME + ($description == null ? 43 : $description.hashCode());
        final java.lang.Object $applicableEntityTypes = this.getApplicableEntityTypes();
        result = result * PRIME + ($applicableEntityTypes == null ? 43 : $applicableEntityTypes.hashCode());
        final java.lang.Object $customApplicableEntityTypes = this.getCustomApplicableEntityTypes();
        result = result * PRIME + ($customApplicableEntityTypes == null ? 43 : $customApplicableEntityTypes.hashCode());
        final java.lang.Object $applicableConnections = this.getApplicableConnections();
        result = result * PRIME + ($applicableConnections == null ? 43 : $applicableConnections.hashCode());
        final java.lang.Object $applicableGlossaries = this.getApplicableGlossaries();
        result = result * PRIME + ($applicableGlossaries == null ? 43 : $applicableGlossaries.hashCode());
        final java.lang.Object $applicableDomains = this.getApplicableDomains();
        result = result * PRIME + ($applicableDomains == null ? 43 : $applicableDomains.hashCode());
        final java.lang.Object $applicableAssetTypes = this.getApplicableAssetTypes();
        result = result * PRIME + ($applicableAssetTypes == null ? 43 : $applicableAssetTypes.hashCode());
        final java.lang.Object $applicableGlossaryTypes = this.getApplicableGlossaryTypes();
        result = result * PRIME + ($applicableGlossaryTypes == null ? 43 : $applicableGlossaryTypes.hashCode());
        final java.lang.Object $applicableDomainTypes = this.getApplicableDomainTypes();
        result = result * PRIME + ($applicableDomainTypes == null ? 43 : $applicableDomainTypes.hashCode());
        final java.lang.Object $applicableOtherAssetTypes = this.getApplicableOtherAssetTypes();
        result = result * PRIME + ($applicableOtherAssetTypes == null ? 43 : $applicableOtherAssetTypes.hashCode());
        final java.lang.Object $maxStrLength = this.getMaxStrLength();
        result = result * PRIME + ($maxStrLength == null ? 43 : $maxStrLength.hashCode());
        final java.lang.Object $isDeprecated = this.getIsDeprecated();
        result = result * PRIME + ($isDeprecated == null ? 43 : $isDeprecated.hashCode());
        final java.lang.Object $primitiveType = this.getPrimitiveType();
        result = result * PRIME + ($primitiveType == null ? 43 : $primitiveType.hashCode());
        final java.lang.Object $enumType = this.getEnumType();
        result = result * PRIME + ($enumType == null ? 43 : $enumType.hashCode());
        final java.lang.Object $customType = this.getCustomType();
        result = result * PRIME + ($customType == null ? 43 : $customType.hashCode());
        final java.lang.Object $archivedBy = this.getArchivedBy();
        result = result * PRIME + ($archivedBy == null ? 43 : $archivedBy.hashCode());
        final java.lang.Object $isSoftReference = this.getIsSoftReference();
        result = result * PRIME + ($isSoftReference == null ? 43 : $isSoftReference.hashCode());
        final java.lang.Object $isAppendOnPartialUpdate = this.getIsAppendOnPartialUpdate();
        result = result * PRIME + ($isAppendOnPartialUpdate == null ? 43 : $isAppendOnPartialUpdate.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AttributeDefOptions(super=" + super.toString() + ", customMetadataVersion=" + this.getCustomMetadataVersion() + ", description=" + this.getDescription() + ", applicableEntityTypes=" + this.getApplicableEntityTypes() + ", customApplicableEntityTypes=" + this.getCustomApplicableEntityTypes() + ", applicableConnections=" + this.getApplicableConnections() + ", applicableGlossaries=" + this.getApplicableGlossaries() + ", applicableDomains=" + this.getApplicableDomains() + ", applicableAssetTypes=" + this.getApplicableAssetTypes() + ", applicableGlossaryTypes=" + this.getApplicableGlossaryTypes() + ", applicableDomainTypes=" + this.getApplicableDomainTypes() + ", applicableOtherAssetTypes=" + this.getApplicableOtherAssetTypes() + ", allowSearch=" + this.getAllowSearch() + ", maxStrLength=" + this.getMaxStrLength() + ", allowFiltering=" + this.getAllowFiltering() + ", multiValueSelect=" + this.getMultiValueSelect() + ", showInOverview=" + this.getShowInOverview() + ", isDeprecated=" + this.getIsDeprecated() + ", primitiveType=" + this.getPrimitiveType() + ", isEnum=" + this.getIsEnum() + ", enumType=" + this.getEnumType() + ", customType=" + this.getCustomType() + ", hasTimePrecision=" + this.getHasTimePrecision() + ", isArchived=" + this.getIsArchived() + ", archivedAt=" + this.getArchivedAt() + ", archivedBy=" + this.getArchivedBy() + ", isSoftReference=" + this.getIsSoftReference() + ", isAppendOnPartialUpdate=" + this.getIsAppendOnPartialUpdate() + ")";
    }
}
