// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.typedefs;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.enums.AtlanTypeCategory;

/**
 * Structural definition of custom metadata.
 */
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = CustomMetadataDef.CustomMetadataDefBuilderImpl.class)
public class CustomMetadataDef extends TypeDef {
    private static final long serialVersionUID = 2L;
    /**
     * Fixed category for custom metadata typedefs.
     */
    AtlanTypeCategory category;
    /**
     * Options for the custom metadata.
     */
    CustomMetadataOptions options;

    /**
     * Builds the minimal object necessary to create a custom metadata definition.
     * Note: without any enrichment, this will create a custom metadata set with no attributes. This is valid,
     * but probably not useful for anything!
     *
     * @param displayName the human-readable name for the custom metadata set
     * @return the minimal request necessary to create the custom metadata typedef, as a builder
     */
    public static CustomMetadataDefBuilder<?, ?> creator(String displayName) {
        return CustomMetadataDef.builder().name(displayName).displayName(displayName);
    }

    /**
     * Create this custom metadata definition in Atlan.
     * @return the result of the creation, or null if the creation failed
     * @throws AtlanException on any API communication issues
     */
    public synchronized CustomMetadataDef create() throws AtlanException {
        return create(Atlan.getDefaultClient());
    }

    /**
     * Create this custom metadata definition in Atlan.
     *
     * @param client connectivity to the Atlan tenant on which to create the custom metadata
     * @return the result of the creation, or null if the creation failed
     * @throws AtlanException on any API communication issues
     */
    public synchronized CustomMetadataDef create(AtlanClient client) throws AtlanException {
        TypeDefResponse response = client.typeDefs.create(this);
        if (response != null && !response.getCustomMetadataDefs().isEmpty()) {
            return response.getCustomMetadataDefs().get(0);
        }
        return null;
    }

    /**
     * Update this custom metadata definition in Atlan.
     * Note: there are many restrictions on what you can / should update, so this should really be treated
     * as an internal method. (This will also force a refresh of the custom metadata cache.)
     *
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API communication issues
     */
    public synchronized CustomMetadataDef update() throws AtlanException {
        return update(Atlan.getDefaultClient());
    }

    /**
     * Update this custom metadata definition in Atlan.
     * Note: there are many restrictions on what you can / should update, so this should really be treated
     * as an internal method. (This will also force a refresh of the custom metadata cache.)
     *
     * @param client connectivity to the Atlan tenant on which to update the custom metadata
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API communication issues
     */
    public CustomMetadataDef update(AtlanClient client) throws AtlanException {
        TypeDefResponse response = client.typeDefs.update(this);
        if (response != null && !response.getCustomMetadataDefs().isEmpty()) {
            return response.getCustomMetadataDefs().get(0);
        }
        return null;
    }

    /**
     * Hard-deletes (purges) a custom metadata definition by its human-readable name. This operation is irreversible.
     * If there are any existing uses of the custom metadata on an asset, this operation will fail.
     *
     * @param displayName human-readable name of the custom metadata definition
     * @throws AtlanException on any error during the API invocation
     */
    public static synchronized void purge(String displayName) throws AtlanException {
        purge(Atlan.getDefaultClient(), displayName);
    }

    /**
     * Hard-deletes (purges) a custom metadata definition by its human-readable name. This operation is irreversible.
     * If there are any existing uses of the custom metadata on an asset, this operation will fail.
     *
     * @param client connectivity to the Atlan tenant from which to purge the custom metadata
     * @param displayName human-readable name of the custom metadata definition
     * @throws AtlanException on any error during the API invocation
     */
    public static synchronized void purge(AtlanClient client, String displayName) throws AtlanException {
        String internalName = client.getCustomMetadataCache().getIdForName(displayName);
        client.typeDefs.purge(internalName);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static AtlanTypeCategory $default$category() {
        return AtlanTypeCategory.CUSTOM_METADATA;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class CustomMetadataDefBuilder<C extends CustomMetadataDef, B extends CustomMetadataDef.CustomMetadataDefBuilder<C, B>> extends TypeDef.TypeDefBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean category$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanTypeCategory category$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private CustomMetadataOptions options;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            CustomMetadataDef.CustomMetadataDefBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final CustomMetadataDef instance, final CustomMetadataDef.CustomMetadataDefBuilder<?, ?> b) {
            b.category(instance.category);
            b.options(instance.options);
        }

        /**
         * Fixed category for custom metadata typedefs.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B category(final AtlanTypeCategory category) {
            this.category$value = category;
            category$set = true;
            return self();
        }

        /**
         * Options for the custom metadata.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B options(final CustomMetadataOptions options) {
            this.options = options;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "CustomMetadataDef.CustomMetadataDefBuilder(super=" + super.toString() + ", category$value=" + this.category$value + ", options=" + this.options + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class CustomMetadataDefBuilderImpl extends CustomMetadataDef.CustomMetadataDefBuilder<CustomMetadataDef, CustomMetadataDef.CustomMetadataDefBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private CustomMetadataDefBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected CustomMetadataDef.CustomMetadataDefBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public CustomMetadataDef build() {
            return new CustomMetadataDef(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected CustomMetadataDef(final CustomMetadataDef.CustomMetadataDefBuilder<?, ?> b) {
        super(b);
        if (b.category$set) this.category = b.category$value;
         else this.category = CustomMetadataDef.$default$category();
        this.options = b.options;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static CustomMetadataDef.CustomMetadataDefBuilder<?, ?> builder() {
        return new CustomMetadataDef.CustomMetadataDefBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CustomMetadataDef.CustomMetadataDefBuilder<?, ?> toBuilder() {
        return new CustomMetadataDef.CustomMetadataDefBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Options for the custom metadata.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public CustomMetadataOptions getOptions() {
        return this.options;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CustomMetadataDef)) return false;
        final CustomMetadataDef other = (CustomMetadataDef) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$category = this.getCategory();
        final java.lang.Object other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) return false;
        final java.lang.Object this$options = this.getOptions();
        final java.lang.Object other$options = other.getOptions();
        if (this$options == null ? other$options != null : !this$options.equals(other$options)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof CustomMetadataDef;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $category = this.getCategory();
        result = result * PRIME + ($category == null ? 43 : $category.hashCode());
        final java.lang.Object $options = this.getOptions();
        result = result * PRIME + ($options == null ? 43 : $options.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "CustomMetadataDef(super=" + super.toString() + ", category=" + this.getCategory() + ", options=" + this.getOptions() + ")";
    }

    /**
     * Fixed category for custom metadata typedefs.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanTypeCategory getCategory() {
        return this.category;
    }
}
