// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.typedefs;

import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanIcon;
import com.atlan.model.enums.AtlanTagColor;
import com.atlan.model.enums.LogoType;

@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = CustomMetadataOptions.CustomMetadataOptionsBuilderImpl.class)
public class CustomMetadataOptions extends AtlanObject {
    private static final long serialVersionUID = 2L;

    /**
     * Provide custom metadata options that set the logo for the custom metadata from the image at
     * the provided URL. The custom metadata will be editable through the UI.
     *
     * @param url to an image (for example a .png)
     * @return the necessary options for setting this image as the logo for the custom metadata
     */
    public static CustomMetadataOptions withImage(String url) {
        return withImage(url, false);
    }

    /**
     * Provide custom metadata options that set the logo for the custom metadata from the image at
     * the provided URL.
     *
     * @param url to an image (for example a .png)
     * @param locked if true, the custom metadata cannot be modified through the Atlan UI
     * @return the necessary options for setting this image as the logo for the custom metadata
     */
    public static CustomMetadataOptions withImage(String url, boolean locked) {
        return CustomMetadataOptions.builder().logoType(LogoType.IMAGE).logoUrl(url).isLocked(Boolean.toString(locked)).build();
    }

    /**
     * Provide custom metadata options that set the logo for the custom metadata to the provided
     * emoji. The custom metadata will be editable through the UI.
     *
     * @param emoji the emoji character to use for the logo
     * @return the necessary options for setting this emoji character as the logo for the custom metadata
     */
    public static CustomMetadataOptions withEmoji(String emoji) {
        return withEmoji(emoji, false);
    }

    /**
     * Provide custom metadata options that set the logo for the custom metadata to the provided
     * emoji.
     *
     * @param emoji the emoji character to use for the logo
     * @param locked if true, the custom metadata cannot be modified through the Atlan UI
     * @return the necessary options for setting this emoji character as the logo for the custom metadata
     */
    public static CustomMetadataOptions withEmoji(String emoji, boolean locked) {
        return CustomMetadataOptions.builder().logoType(LogoType.EMOJI).emoji(emoji).isLocked(Boolean.toString(locked)).build();
    }

    /**
     * Provide custom metadata options that set the logo for the custom metadata to the provided
     * icon and color. The custom metadata will be editable through the UI.
     *
     * @param icon the icon to use for the logo
     * @param color the color to use for the icon
     * @return the necessary options for setting this icon (and color) as the logo for the custom metadata
     */
    public static CustomMetadataOptions withIcon(AtlanIcon icon, AtlanTagColor color) {
        return withIcon(icon, color, false);
    }

    /**
     * Provide custom metadata options that set the logo for the custom metadata to the provided
     * icon.
     *
     * @param icon the icon to use for the logo
     * @param color the color to use for the icon
     * @param locked if true, the custom metadata cannot be modified through the Atlan UI
     * @return the necessary options for setting this icon (and color) as the logo for the custom metadata
     */
    public static CustomMetadataOptions withIcon(AtlanIcon icon, AtlanTagColor color, boolean locked) {
        return CustomMetadataOptions.builder().logoType(LogoType.ICON).iconColor(color).iconName(icon).isLocked(Boolean.toString(locked)).build();
    }

    /**
     * Type of logo used for the custom metadata.
     */
    LogoType logoType;
    /**
     * Color to use for the icon.
     */
    AtlanTagColor iconColor;
    /**
     * Icon to use to represent the custom metadata.
     */
    AtlanIcon iconName;
    /**
     * If the {@code logoType} is emoji, this should hold the emoji character.
     */
    String emoji;
    /**
     * If the {@code logoType} is image, this should hold a URL to the image.
     */
    String logoUrl;
    /**
     * Indicates whether the custom metadata can be managed in the UI (false) or not (true).
     */
    String isLocked;
    /**
     * Unique identifier (GUID) of the image used for the logo, for logos that are uploaded directly to Atlan.
     */
    String imageId;


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class CustomMetadataOptionsBuilder<C extends CustomMetadataOptions, B extends CustomMetadataOptions.CustomMetadataOptionsBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private LogoType logoType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanTagColor iconColor;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanIcon iconName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String emoji;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String logoUrl;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String isLocked;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String imageId;

        /**
         * Type of logo used for the custom metadata.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B logoType(final LogoType logoType) {
            this.logoType = logoType;
            return self();
        }

        /**
         * Color to use for the icon.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B iconColor(final AtlanTagColor iconColor) {
            this.iconColor = iconColor;
            return self();
        }

        /**
         * Icon to use to represent the custom metadata.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B iconName(final AtlanIcon iconName) {
            this.iconName = iconName;
            return self();
        }

        /**
         * If the {@code logoType} is emoji, this should hold the emoji character.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B emoji(final String emoji) {
            this.emoji = emoji;
            return self();
        }

        /**
         * If the {@code logoType} is image, this should hold a URL to the image.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B logoUrl(final String logoUrl) {
            this.logoUrl = logoUrl;
            return self();
        }

        /**
         * Indicates whether the custom metadata can be managed in the UI (false) or not (true).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isLocked(final String isLocked) {
            this.isLocked = isLocked;
            return self();
        }

        /**
         * Unique identifier (GUID) of the image used for the logo, for logos that are uploaded directly to Atlan.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B imageId(final String imageId) {
            this.imageId = imageId;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "CustomMetadataOptions.CustomMetadataOptionsBuilder(super=" + super.toString() + ", logoType=" + this.logoType + ", iconColor=" + this.iconColor + ", iconName=" + this.iconName + ", emoji=" + this.emoji + ", logoUrl=" + this.logoUrl + ", isLocked=" + this.isLocked + ", imageId=" + this.imageId + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class CustomMetadataOptionsBuilderImpl extends CustomMetadataOptions.CustomMetadataOptionsBuilder<CustomMetadataOptions, CustomMetadataOptions.CustomMetadataOptionsBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private CustomMetadataOptionsBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected CustomMetadataOptions.CustomMetadataOptionsBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public CustomMetadataOptions build() {
            return new CustomMetadataOptions(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected CustomMetadataOptions(final CustomMetadataOptions.CustomMetadataOptionsBuilder<?, ?> b) {
        super(b);
        this.logoType = b.logoType;
        this.iconColor = b.iconColor;
        this.iconName = b.iconName;
        this.emoji = b.emoji;
        this.logoUrl = b.logoUrl;
        this.isLocked = b.isLocked;
        this.imageId = b.imageId;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static CustomMetadataOptions.CustomMetadataOptionsBuilder<?, ?> builder() {
        return new CustomMetadataOptions.CustomMetadataOptionsBuilderImpl();
    }

    /**
     * Type of logo used for the custom metadata.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public LogoType getLogoType() {
        return this.logoType;
    }

    /**
     * Color to use for the icon.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanTagColor getIconColor() {
        return this.iconColor;
    }

    /**
     * Icon to use to represent the custom metadata.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanIcon getIconName() {
        return this.iconName;
    }

    /**
     * If the {@code logoType} is emoji, this should hold the emoji character.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getEmoji() {
        return this.emoji;
    }

    /**
     * If the {@code logoType} is image, this should hold a URL to the image.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLogoUrl() {
        return this.logoUrl;
    }

    /**
     * Indicates whether the custom metadata can be managed in the UI (false) or not (true).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getIsLocked() {
        return this.isLocked;
    }

    /**
     * Unique identifier (GUID) of the image used for the logo, for logos that are uploaded directly to Atlan.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getImageId() {
        return this.imageId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CustomMetadataOptions)) return false;
        final CustomMetadataOptions other = (CustomMetadataOptions) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$logoType = this.getLogoType();
        final java.lang.Object other$logoType = other.getLogoType();
        if (this$logoType == null ? other$logoType != null : !this$logoType.equals(other$logoType)) return false;
        final java.lang.Object this$iconColor = this.getIconColor();
        final java.lang.Object other$iconColor = other.getIconColor();
        if (this$iconColor == null ? other$iconColor != null : !this$iconColor.equals(other$iconColor)) return false;
        final java.lang.Object this$iconName = this.getIconName();
        final java.lang.Object other$iconName = other.getIconName();
        if (this$iconName == null ? other$iconName != null : !this$iconName.equals(other$iconName)) return false;
        final java.lang.Object this$emoji = this.getEmoji();
        final java.lang.Object other$emoji = other.getEmoji();
        if (this$emoji == null ? other$emoji != null : !this$emoji.equals(other$emoji)) return false;
        final java.lang.Object this$logoUrl = this.getLogoUrl();
        final java.lang.Object other$logoUrl = other.getLogoUrl();
        if (this$logoUrl == null ? other$logoUrl != null : !this$logoUrl.equals(other$logoUrl)) return false;
        final java.lang.Object this$isLocked = this.getIsLocked();
        final java.lang.Object other$isLocked = other.getIsLocked();
        if (this$isLocked == null ? other$isLocked != null : !this$isLocked.equals(other$isLocked)) return false;
        final java.lang.Object this$imageId = this.getImageId();
        final java.lang.Object other$imageId = other.getImageId();
        if (this$imageId == null ? other$imageId != null : !this$imageId.equals(other$imageId)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof CustomMetadataOptions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $logoType = this.getLogoType();
        result = result * PRIME + ($logoType == null ? 43 : $logoType.hashCode());
        final java.lang.Object $iconColor = this.getIconColor();
        result = result * PRIME + ($iconColor == null ? 43 : $iconColor.hashCode());
        final java.lang.Object $iconName = this.getIconName();
        result = result * PRIME + ($iconName == null ? 43 : $iconName.hashCode());
        final java.lang.Object $emoji = this.getEmoji();
        result = result * PRIME + ($emoji == null ? 43 : $emoji.hashCode());
        final java.lang.Object $logoUrl = this.getLogoUrl();
        result = result * PRIME + ($logoUrl == null ? 43 : $logoUrl.hashCode());
        final java.lang.Object $isLocked = this.getIsLocked();
        result = result * PRIME + ($isLocked == null ? 43 : $isLocked.hashCode());
        final java.lang.Object $imageId = this.getImageId();
        result = result * PRIME + ($imageId == null ? 43 : $imageId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "CustomMetadataOptions(super=" + super.toString() + ", logoType=" + this.getLogoType() + ", iconColor=" + this.getIconColor() + ", iconName=" + this.getIconName() + ", emoji=" + this.getEmoji() + ", logoUrl=" + this.getLogoUrl() + ", isLocked=" + this.getIsLocked() + ", imageId=" + this.getImageId() + ")";
    }
}
