// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.typedefs;

import com.atlan.model.enums.AtlanTypeCategory;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Structural definition of an entity.
 */
@JsonPropertyOrder({"name", "description", "typeVersion", "serviceType", "superTypes", "attributeDefs"})
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = EntityDef.EntityDefBuilderImpl.class)
public class EntityDef extends TypeDef {
    private static final long serialVersionUID = 2L;
    /**
     * Fixed category for entity typedefs.
     */
    AtlanTypeCategory category;
    /**
     * Relationships that can exist for the entity.
     */
    List<RelationshipAttributeDef> relationshipAttributeDefs;
    /**
     * Subtypes of this entity type.
     */
    List<String> subTypes;
    /**
     * Supertypes of this entity type.
     */
    List<String> superTypes;
    /**
     * Unused.
     */
    @JsonIgnore
    Map<String, Object> businessAttributeDefs;

    /**
     * Build up an entity definition from the provided parameters and default settings for all other parameters.
     * NOTE: INTERNAL USE ONLY.
     *
     * @param name name of the entity definition
     * @param attributes definitions for each attribute within the entity definition
     * @return a builder for an entity definition
     */
    public static EntityDefBuilder<?, ?> creator(String name, List<AttributeDef> attributes) {
        return creator(name, attributes, null);
    }

    /**
     * Build up an entity definition from the provided parameters and default settings for all other parameters.
     * NOTE: INTERNAL USE ONLY.
     *
     * @param name name of the entity definition
     * @param attributes definitions for each attribute within the entity definition
     * @param superTypes names of the types that this entity definition should inherit from
     * @return a builder for an entity definition
     */
    public static EntityDefBuilder<?, ?> creator(String name, List<AttributeDef> attributes, List<String> superTypes) {
        if (superTypes == null) {
            superTypes = new ArrayList<>();
        }
        if (superTypes.isEmpty()) {
            superTypes.add("Asset");
        }
        return EntityDef.builder().name(name).serviceType("custom_extension").typeVersion("1.0").attributeDefs(attributes).superTypes(superTypes).category(null);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static AtlanTypeCategory $default$category() {
        return AtlanTypeCategory.ENTITY;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class EntityDefBuilder<C extends EntityDef, B extends EntityDef.EntityDefBuilder<C, B>> extends TypeDef.TypeDefBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean category$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanTypeCategory category$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<RelationshipAttributeDef> relationshipAttributeDefs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<String> subTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<String> superTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, Object> businessAttributeDefs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            EntityDef.EntityDefBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final EntityDef instance, final EntityDef.EntityDefBuilder<?, ?> b) {
            b.category(instance.category);
            b.relationshipAttributeDefs(instance.relationshipAttributeDefs);
            b.subTypes(instance.subTypes);
            b.superTypes(instance.superTypes);
            b.businessAttributeDefs(instance.businessAttributeDefs);
        }

        /**
         * Fixed category for entity typedefs.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B category(final AtlanTypeCategory category) {
            this.category$value = category;
            category$set = true;
            return self();
        }

        /**
         * Relationships that can exist for the entity.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B relationshipAttributeDefs(final List<RelationshipAttributeDef> relationshipAttributeDefs) {
            this.relationshipAttributeDefs = relationshipAttributeDefs;
            return self();
        }

        /**
         * Subtypes of this entity type.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B subTypes(final List<String> subTypes) {
            this.subTypes = subTypes;
            return self();
        }

        /**
         * Supertypes of this entity type.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B superTypes(final List<String> superTypes) {
            this.superTypes = superTypes;
            return self();
        }

        /**
         * Unused.
         * @return {@code this}.
         */
        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B businessAttributeDefs(final Map<String, Object> businessAttributeDefs) {
            this.businessAttributeDefs = businessAttributeDefs;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "EntityDef.EntityDefBuilder(super=" + super.toString() + ", category$value=" + this.category$value + ", relationshipAttributeDefs=" + this.relationshipAttributeDefs + ", subTypes=" + this.subTypes + ", superTypes=" + this.superTypes + ", businessAttributeDefs=" + this.businessAttributeDefs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @JsonPropertyOrder({"name", "description", "typeVersion", "serviceType", "superTypes", "attributeDefs"})
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class EntityDefBuilderImpl extends EntityDef.EntityDefBuilder<EntityDef, EntityDef.EntityDefBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private EntityDefBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected EntityDef.EntityDefBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public EntityDef build() {
            return new EntityDef(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected EntityDef(final EntityDef.EntityDefBuilder<?, ?> b) {
        super(b);
        if (b.category$set) this.category = b.category$value;
         else this.category = EntityDef.$default$category();
        this.relationshipAttributeDefs = b.relationshipAttributeDefs;
        this.subTypes = b.subTypes;
        this.superTypes = b.superTypes;
        this.businessAttributeDefs = b.businessAttributeDefs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static EntityDef.EntityDefBuilder<?, ?> builder() {
        return new EntityDef.EntityDefBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public EntityDef.EntityDefBuilder<?, ?> toBuilder() {
        return new EntityDef.EntityDefBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Relationships that can exist for the entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<RelationshipAttributeDef> getRelationshipAttributeDefs() {
        return this.relationshipAttributeDefs;
    }

    /**
     * Subtypes of this entity type.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getSubTypes() {
        return this.subTypes;
    }

    /**
     * Supertypes of this entity type.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getSuperTypes() {
        return this.superTypes;
    }

    /**
     * Unused.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getBusinessAttributeDefs() {
        return this.businessAttributeDefs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof EntityDef)) return false;
        final EntityDef other = (EntityDef) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$category = this.getCategory();
        final java.lang.Object other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) return false;
        final java.lang.Object this$relationshipAttributeDefs = this.getRelationshipAttributeDefs();
        final java.lang.Object other$relationshipAttributeDefs = other.getRelationshipAttributeDefs();
        if (this$relationshipAttributeDefs == null ? other$relationshipAttributeDefs != null : !this$relationshipAttributeDefs.equals(other$relationshipAttributeDefs)) return false;
        final java.lang.Object this$subTypes = this.getSubTypes();
        final java.lang.Object other$subTypes = other.getSubTypes();
        if (this$subTypes == null ? other$subTypes != null : !this$subTypes.equals(other$subTypes)) return false;
        final java.lang.Object this$superTypes = this.getSuperTypes();
        final java.lang.Object other$superTypes = other.getSuperTypes();
        if (this$superTypes == null ? other$superTypes != null : !this$superTypes.equals(other$superTypes)) return false;
        final java.lang.Object this$businessAttributeDefs = this.getBusinessAttributeDefs();
        final java.lang.Object other$businessAttributeDefs = other.getBusinessAttributeDefs();
        if (this$businessAttributeDefs == null ? other$businessAttributeDefs != null : !this$businessAttributeDefs.equals(other$businessAttributeDefs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof EntityDef;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $category = this.getCategory();
        result = result * PRIME + ($category == null ? 43 : $category.hashCode());
        final java.lang.Object $relationshipAttributeDefs = this.getRelationshipAttributeDefs();
        result = result * PRIME + ($relationshipAttributeDefs == null ? 43 : $relationshipAttributeDefs.hashCode());
        final java.lang.Object $subTypes = this.getSubTypes();
        result = result * PRIME + ($subTypes == null ? 43 : $subTypes.hashCode());
        final java.lang.Object $superTypes = this.getSuperTypes();
        result = result * PRIME + ($superTypes == null ? 43 : $superTypes.hashCode());
        final java.lang.Object $businessAttributeDefs = this.getBusinessAttributeDefs();
        result = result * PRIME + ($businessAttributeDefs == null ? 43 : $businessAttributeDefs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "EntityDef(super=" + super.toString() + ", category=" + this.getCategory() + ", relationshipAttributeDefs=" + this.getRelationshipAttributeDefs() + ", subTypes=" + this.getSubTypes() + ", superTypes=" + this.getSuperTypes() + ", businessAttributeDefs=" + this.getBusinessAttributeDefs() + ")";
    }

    /**
     * Fixed category for entity typedefs.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanTypeCategory getCategory() {
        return this.category;
    }
}
