// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.typedefs;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanTypeCategory;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.*;

/**
 * Structural definition of an enumeration.
 * Note that unlike other type definitions, enumerations do NOT use hashed internal string IDs. Their
 * name is precisely the same as the name viewable in the UI.
 */
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = EnumDef.EnumDefBuilderImpl.class)
public class EnumDef extends TypeDef {
    private static final long serialVersionUID = 2L;
    /**
     * Fixed category for enum typedefs.
     */
    AtlanTypeCategory category;
    /**
     * Individual valid values for the enumeration.
     */
    List<ElementDef> elementDefs;

    /**
     * Translate the element definitions in this enumeration into a simple list of strings.
     *
     * @return list of valid values for the enumeration
     */
    @JsonIgnore
    public List<String> getValidValues() {
        if (elementDefs != null && !elementDefs.isEmpty()) {
            return elementDefs.stream().map(ElementDef::getValue).collect(Collectors.toList());
        } else {
            return Collections.emptyList();
        }
    }

    /**
     * Builds the minimal object necessary to create an enumeration definition.
     *
     * @param displayName the human-readable name for the enumeration
     * @param values the list of valid values (as strings) for the enumeration
     * @return the minimal request necessary to create the enumeration typedef, as a builder
     */
    public static EnumDefBuilder<?, ?> creator(String displayName, List<String> values) {
        return EnumDef.builder().name(displayName).elementDefs(ElementDef.from(values));
    }

    /**
     * Builds the minimal object necessary to update an enumeration definition.
     *
     * @param displayName the human-readable name for the enumeration
     * @param values the list of additional valid values (as strings) to add to the existing enumeration
     * @param replaceExisting if true, will replace all existing values in the enumeration with the new ones; or if false the new ones will be appended to the existing set
     * @return the minimal request necessary to update the enumeration typedef, as a builder
     * @throws AtlanException on any API issues related to retrieving the existing enumeration
     */
    public static EnumDefBuilder<?, ?> updater(String displayName, List<String> values, boolean replaceExisting) throws AtlanException {
        return updater(Atlan.getDefaultClient(), displayName, values, replaceExisting);
    }

    /**
     * Builds the minimal object necessary to update an enumeration definition.
     *
     * @param client connectivity to the Atlan tenant on which to update the enumeration
     * @param displayName the human-readable name for the enumeration
     * @param values the list of additional valid values (as strings) to add to the existing enumeration
     * @param replaceExisting if true, will replace all existing values in the enumeration with the new ones; or if false the new ones will be appended to the existing set
     * @return the minimal request necessary to update the enumeration typedef, as a builder
     * @throws AtlanException on any API issues related to retrieving the existing enumeration
     */
    public static EnumDefBuilder<?, ?> updater(AtlanClient client, String displayName, List<String> values, boolean replaceExisting) throws AtlanException {
        List<String> combined;
        if (replaceExisting) {
            combined = values;
        } else {
            combined = new ArrayList<>();
            List<String> existing = client.getEnumCache().getByName(displayName).getValidValues();
            for (String one : existing) {
                if (!values.contains(one)) {
                    combined.add(one);
                }
            }
            combined.addAll(values);
        }
        return EnumDef.builder().name(displayName).elementDefs(ElementDef.from(combined));
    }

    /**
     * Create this enumeration definition in Atlan.
     * @return the result of the creation, or null if the creation failed
     * @throws AtlanException on any API communication issues
     */
    public synchronized EnumDef create() throws AtlanException {
        return create(Atlan.getDefaultClient());
    }

    /**
     * Create this enumeration definition in Atlan.
     *
     * @param client connectivity to the Atlan tenant on which to create the enumeration
     * @return the result of the creation, or null if the creation failed
     * @throws AtlanException on any API communication issues
     */
    public synchronized EnumDef create(AtlanClient client) throws AtlanException {
        TypeDefResponse response = client.typeDefs.create(this);
        if (response != null && !response.getEnumDefs().isEmpty()) {
            return response.getEnumDefs().get(0);
        }
        return null;
    }

    /**
     * Update this enumeration definition in Atlan.
     *
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API communication issues
     */
    public synchronized EnumDef update() throws AtlanException {
        return update(Atlan.getDefaultClient());
    }

    /**
     * Update this enumeration definition in Atlan.
     *
     * @param client connectivity to the Atlan tenant on which to update the enumeration
     * @return the result of the update, or null if the update failed
     * @throws AtlanException on any API communication issues
     */
    public synchronized EnumDef update(AtlanClient client) throws AtlanException {
        TypeDefResponse response = client.typeDefs.update(this);
        if (response != null && !response.getEnumDefs().isEmpty()) {
            return response.getEnumDefs().get(0);
        }
        return null;
    }

    /**
     * Hard-deletes (purges) an enumeration by its human-readable name. This operation is irreversible.
     * If there are any existing enumeration instances, this operation will fail.
     *
     * @param displayName human-readable name of the enumeration
     * @throws AtlanException on any error during the API invocation
     */
    public static synchronized void purge(String displayName) throws AtlanException {
        purge(Atlan.getDefaultClient(), displayName);
    }

    /**
     * Hard-deletes (purges) an enumeration by its human-readable name. This operation is irreversible.
     * If there are any existing enumeration instances, this operation will fail.
     *
     * @param client connectivity to the Atlan tenant from which to purge the enumeration
     * @param displayName human-readable name of the enumeration
     * @throws AtlanException on any error during the API invocation
     */
    public static synchronized void purge(AtlanClient client, String displayName) throws AtlanException {
        client.typeDefs.purge(displayName);
    }


    /**
     * Structure for definition of a valid value in an enumeration.
     */
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = EnumDef.ElementDef.ElementDefBuilderImpl.class)
    public static class ElementDef extends AtlanObject {
        private static final long serialVersionUID = 2L;
        /** Value of the element (the valid value). */
        String value;
        /** (Optional) Description of the element. */
        String description;
        /** Position of the element within the list of valid values. */
        Integer ordinal;

        /**
         * Build a valid value definition.
         *
         * @param ordinal position of the valid value definition in the overall list
         * @param value of the valid value
         * @return the valid value definition
         */
        public static ElementDef of(int ordinal, String value) {
            return ElementDef.builder().ordinal(ordinal).value(value).build();
        }

        /**
         * Build a list of valid values from the provided list of strings.
         *
         * @param values to enumerate as valid values
         * @return a list of the valid values
         */
        protected static List<ElementDef> from(List<String> values) {
            if (values != null && !values.isEmpty()) {
                List<ElementDef> elements = new ArrayList<>();
                for (int i = 0; i < values.size(); i++) {
                    elements.add(ElementDef.of(i, values.get(i)));
                }
                return Collections.unmodifiableList(elements);
            } else {
                return Collections.emptyList();
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static abstract class ElementDefBuilder<C extends EnumDef.ElementDef, B extends EnumDef.ElementDef.ElementDefBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String value;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private String description;
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private Integer ordinal;

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B value(final String value) {
                this.value = value;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B description(final String description) {
                this.description = description;
                return self();
            }

            /**
             * @return {@code this}.
             */
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public B ordinal(final Integer ordinal) {
                this.ordinal = ordinal;
                return self();
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected abstract B self();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public abstract C build();

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public java.lang.String toString() {
                return "EnumDef.ElementDef.ElementDefBuilder(super=" + super.toString() + ", value=" + this.value + ", description=" + this.description + ", ordinal=" + this.ordinal + ")";
            }
        }


        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
        static final class ElementDefBuilderImpl extends EnumDef.ElementDef.ElementDefBuilder<EnumDef.ElementDef, EnumDef.ElementDef.ElementDefBuilderImpl> {
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            private ElementDefBuilderImpl() {
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            protected EnumDef.ElementDef.ElementDefBuilderImpl self() {
                return this;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public EnumDef.ElementDef build() {
                return new EnumDef.ElementDef(this);
            }
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected ElementDef(final EnumDef.ElementDef.ElementDefBuilder<?, ?> b) {
            super(b);
            this.value = b.value;
            this.description = b.description;
            this.ordinal = b.ordinal;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public static EnumDef.ElementDef.ElementDefBuilder<?, ?> builder() {
            return new EnumDef.ElementDef.ElementDefBuilderImpl();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getValue() {
            return this.value;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getDescription() {
            return this.description;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Integer getOrdinal() {
            return this.ordinal;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof EnumDef.ElementDef)) return false;
            final EnumDef.ElementDef other = (EnumDef.ElementDef) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$ordinal = this.getOrdinal();
            final java.lang.Object other$ordinal = other.getOrdinal();
            if (this$ordinal == null ? other$ordinal != null : !this$ordinal.equals(other$ordinal)) return false;
            final java.lang.Object this$value = this.getValue();
            final java.lang.Object other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
            final java.lang.Object this$description = this.getDescription();
            final java.lang.Object other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof EnumDef.ElementDef;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $ordinal = this.getOrdinal();
            result = result * PRIME + ($ordinal == null ? 43 : $ordinal.hashCode());
            final java.lang.Object $value = this.getValue();
            result = result * PRIME + ($value == null ? 43 : $value.hashCode());
            final java.lang.Object $description = this.getDescription();
            result = result * PRIME + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "EnumDef.ElementDef(super=" + super.toString() + ", value=" + this.getValue() + ", description=" + this.getDescription() + ", ordinal=" + this.getOrdinal() + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static AtlanTypeCategory $default$category() {
        return AtlanTypeCategory.ENUM;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class EnumDefBuilder<C extends EnumDef, B extends EnumDef.EnumDefBuilder<C, B>> extends TypeDef.TypeDefBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean category$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanTypeCategory category$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<ElementDef> elementDefs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            EnumDef.EnumDefBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final EnumDef instance, final EnumDef.EnumDefBuilder<?, ?> b) {
            b.category(instance.category);
            b.elementDefs(instance.elementDefs == null ? java.util.Collections.<ElementDef>emptyList() : instance.elementDefs);
        }

        /**
         * Fixed category for enum typedefs.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B category(final AtlanTypeCategory category) {
            this.category$value = category;
            category$set = true;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B elementDef(final ElementDef elementDef) {
            if (this.elementDefs == null) this.elementDefs = new java.util.ArrayList<ElementDef>();
            this.elementDefs.add(elementDef);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B elementDefs(final java.util.Collection<? extends ElementDef> elementDefs) {
            if (elementDefs == null) {
                throw new java.lang.NullPointerException("elementDefs cannot be null");
            }
            if (this.elementDefs == null) this.elementDefs = new java.util.ArrayList<ElementDef>();
            this.elementDefs.addAll(elementDefs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearElementDefs() {
            if (this.elementDefs != null) this.elementDefs.clear();
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "EnumDef.EnumDefBuilder(super=" + super.toString() + ", category$value=" + this.category$value + ", elementDefs=" + this.elementDefs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class EnumDefBuilderImpl extends EnumDef.EnumDefBuilder<EnumDef, EnumDef.EnumDefBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private EnumDefBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected EnumDef.EnumDefBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public EnumDef build() {
            return new EnumDef(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected EnumDef(final EnumDef.EnumDefBuilder<?, ?> b) {
        super(b);
        if (b.category$set) this.category = b.category$value;
         else this.category = EnumDef.$default$category();
        java.util.List<ElementDef> elementDefs;
        switch (b.elementDefs == null ? 0 : b.elementDefs.size()) {
        case 0: 
            elementDefs = java.util.Collections.emptyList();
            break;
        case 1: 
            elementDefs = java.util.Collections.singletonList(b.elementDefs.get(0));
            break;
        default: 
            elementDefs = java.util.Collections.unmodifiableList(new java.util.ArrayList<ElementDef>(b.elementDefs));
        }
        this.elementDefs = elementDefs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static EnumDef.EnumDefBuilder<?, ?> builder() {
        return new EnumDef.EnumDefBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public EnumDef.EnumDefBuilder<?, ?> toBuilder() {
        return new EnumDef.EnumDefBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Individual valid values for the enumeration.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<ElementDef> getElementDefs() {
        return this.elementDefs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof EnumDef)) return false;
        final EnumDef other = (EnumDef) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$category = this.getCategory();
        final java.lang.Object other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) return false;
        final java.lang.Object this$elementDefs = this.getElementDefs();
        final java.lang.Object other$elementDefs = other.getElementDefs();
        if (this$elementDefs == null ? other$elementDefs != null : !this$elementDefs.equals(other$elementDefs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof EnumDef;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $category = this.getCategory();
        result = result * PRIME + ($category == null ? 43 : $category.hashCode());
        final java.lang.Object $elementDefs = this.getElementDefs();
        result = result * PRIME + ($elementDefs == null ? 43 : $elementDefs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "EnumDef(super=" + super.toString() + ", category=" + this.getCategory() + ", elementDefs=" + this.getElementDefs() + ")";
    }

    /**
     * Fixed category for enum typedefs.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanTypeCategory getCategory() {
        return this.category;
    }
}
