// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.typedefs;

import com.atlan.model.enums.AtlanTypeCategory;
import com.atlan.model.enums.PropagateTags;
import com.atlan.model.enums.RelationshipCategory;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * Structural definition of an entity.
 */
@JsonPropertyOrder({"name", "description", "typeVersion", "relationshipCategory", "relationshipLabel", "serviceType", "endDef1", "endDef2", "propagateTags", "relationshipAttributeDefs"})
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = RelationshipDef.RelationshipDefBuilderImpl.class)
public class RelationshipDef extends TypeDef {
    private static final long serialVersionUID = 2L;
    /**
     * Fixed category for entity typedefs.
     */
    AtlanTypeCategory category;
    /**
     * TBC
     */
    String relationshipLabel;
    /**
     * Style of relationship in regard to containment and lifecycle.
     */
    RelationshipCategory relationshipCategory;
    /**
     * Whether Atlan tags should propagate through this relationship, and if so in which direction(s).
     */
    PropagateTags propagateTags;
    /**
     * Definition for the first endpoint of the relationship.
     */
    RelationshipEndDef endDef1;
    /**
     * Definition for the second endpoint of the relationship.
     */
    RelationshipEndDef endDef2;
    /**
     * Relationships that can exist for the entity.
     */
    List<RelationshipAttributeDef> relationshipAttributeDefs;
    /**
     * Subtypes of this entity type.
     */
    List<String> subTypes;
    /**
     * Supertypes of this entity type.
     */
    List<String> superTypes;
    /**
     * Unused.
     */
    @JsonIgnore
    Map<String, Object> businessAttributeDefs;

    /**
     * Build up a relationship definition from the provided parameters and default settings for all other parameters.
     * NOTE: INTERNAL USE ONLY.
     *
     * @param name name of the relationship definition
     * @param end1 definition of the first endpoint of the relationship
     * @param end2 definition of the second endpoint of the relationship
     * @return a builder for a relationship definition
     */
    public static RelationshipDefBuilder<?, ?> creator(String name, RelationshipEndDef end1, RelationshipEndDef end2) {
        return creator(name, end1, end2, Collections.emptyList());
    }

    /**
     * Build up a relationship definition from the provided parameters and default settings for all other parameters.
     * NOTE: INTERNAL USE ONLY.
     *
     * @param name name of the relationship definition
     * @param end1 definition of the first endpoint of the relationship
     * @param end2 definition of the second endpoint of the relationship
     * @param attributes definitions for each attribute within the relationship definition
     * @return a builder for a relationship definition
     */
    public static RelationshipDefBuilder<?, ?> creator(String name, RelationshipEndDef end1, RelationshipEndDef end2, List<AttributeDef> attributes) {
        RelationshipCategory categoryToUse = RelationshipCategory.ASSOCIATION;
        if (end1.isContainer || end2.isContainer) {
            categoryToUse = RelationshipCategory.AGGREGATION;
        }
        return RelationshipDef.builder().name(name).serviceType("custom_extension").typeVersion("1.0").endDef1(end1).endDef2(end2).relationshipLabel("__" + end1.type + "." + end1.name).attributeDefs(attributes).relationshipCategory(categoryToUse).category(null);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static AtlanTypeCategory $default$category() {
        return AtlanTypeCategory.RELATIONSHIP;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static RelationshipCategory $default$relationshipCategory() {
        return RelationshipCategory.ASSOCIATION;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static PropagateTags $default$propagateTags() {
        return PropagateTags.NONE;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class RelationshipDefBuilder<C extends RelationshipDef, B extends RelationshipDef.RelationshipDefBuilder<C, B>> extends TypeDef.TypeDefBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean category$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanTypeCategory category$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String relationshipLabel;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean relationshipCategory$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private RelationshipCategory relationshipCategory$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean propagateTags$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private PropagateTags propagateTags$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private RelationshipEndDef endDef1;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private RelationshipEndDef endDef2;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<RelationshipAttributeDef> relationshipAttributeDefs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<String> subTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<String> superTypes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, Object> businessAttributeDefs;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            RelationshipDef.RelationshipDefBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final RelationshipDef instance, final RelationshipDef.RelationshipDefBuilder<?, ?> b) {
            b.category(instance.category);
            b.relationshipLabel(instance.relationshipLabel);
            b.relationshipCategory(instance.relationshipCategory);
            b.propagateTags(instance.propagateTags);
            b.endDef1(instance.endDef1);
            b.endDef2(instance.endDef2);
            b.relationshipAttributeDefs(instance.relationshipAttributeDefs);
            b.subTypes(instance.subTypes);
            b.superTypes(instance.superTypes);
            b.businessAttributeDefs(instance.businessAttributeDefs);
        }

        /**
         * Fixed category for entity typedefs.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B category(final AtlanTypeCategory category) {
            this.category$value = category;
            category$set = true;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B relationshipLabel(final String relationshipLabel) {
            this.relationshipLabel = relationshipLabel;
            return self();
        }

        /**
         * Style of relationship in regard to containment and lifecycle.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B relationshipCategory(final RelationshipCategory relationshipCategory) {
            this.relationshipCategory$value = relationshipCategory;
            relationshipCategory$set = true;
            return self();
        }

        /**
         * Whether Atlan tags should propagate through this relationship, and if so in which direction(s).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B propagateTags(final PropagateTags propagateTags) {
            this.propagateTags$value = propagateTags;
            propagateTags$set = true;
            return self();
        }

        /**
         * Definition for the first endpoint of the relationship.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B endDef1(final RelationshipEndDef endDef1) {
            this.endDef1 = endDef1;
            return self();
        }

        /**
         * Definition for the second endpoint of the relationship.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B endDef2(final RelationshipEndDef endDef2) {
            this.endDef2 = endDef2;
            return self();
        }

        /**
         * Relationships that can exist for the entity.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B relationshipAttributeDefs(final List<RelationshipAttributeDef> relationshipAttributeDefs) {
            this.relationshipAttributeDefs = relationshipAttributeDefs;
            return self();
        }

        /**
         * Subtypes of this entity type.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B subTypes(final List<String> subTypes) {
            this.subTypes = subTypes;
            return self();
        }

        /**
         * Supertypes of this entity type.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B superTypes(final List<String> superTypes) {
            this.superTypes = superTypes;
            return self();
        }

        /**
         * Unused.
         * @return {@code this}.
         */
        @JsonIgnore
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B businessAttributeDefs(final Map<String, Object> businessAttributeDefs) {
            this.businessAttributeDefs = businessAttributeDefs;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "RelationshipDef.RelationshipDefBuilder(super=" + super.toString() + ", category$value=" + this.category$value + ", relationshipLabel=" + this.relationshipLabel + ", relationshipCategory$value=" + this.relationshipCategory$value + ", propagateTags$value=" + this.propagateTags$value + ", endDef1=" + this.endDef1 + ", endDef2=" + this.endDef2 + ", relationshipAttributeDefs=" + this.relationshipAttributeDefs + ", subTypes=" + this.subTypes + ", superTypes=" + this.superTypes + ", businessAttributeDefs=" + this.businessAttributeDefs + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @JsonPropertyOrder({"name", "description", "typeVersion", "relationshipCategory", "relationshipLabel", "serviceType", "endDef1", "endDef2", "propagateTags", "relationshipAttributeDefs"})
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class RelationshipDefBuilderImpl extends RelationshipDef.RelationshipDefBuilder<RelationshipDef, RelationshipDef.RelationshipDefBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private RelationshipDefBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected RelationshipDef.RelationshipDefBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public RelationshipDef build() {
            return new RelationshipDef(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected RelationshipDef(final RelationshipDef.RelationshipDefBuilder<?, ?> b) {
        super(b);
        if (b.category$set) this.category = b.category$value;
         else this.category = RelationshipDef.$default$category();
        this.relationshipLabel = b.relationshipLabel;
        if (b.relationshipCategory$set) this.relationshipCategory = b.relationshipCategory$value;
         else this.relationshipCategory = RelationshipDef.$default$relationshipCategory();
        if (b.propagateTags$set) this.propagateTags = b.propagateTags$value;
         else this.propagateTags = RelationshipDef.$default$propagateTags();
        this.endDef1 = b.endDef1;
        this.endDef2 = b.endDef2;
        this.relationshipAttributeDefs = b.relationshipAttributeDefs;
        this.subTypes = b.subTypes;
        this.superTypes = b.superTypes;
        this.businessAttributeDefs = b.businessAttributeDefs;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static RelationshipDef.RelationshipDefBuilder<?, ?> builder() {
        return new RelationshipDef.RelationshipDefBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RelationshipDef.RelationshipDefBuilder<?, ?> toBuilder() {
        return new RelationshipDef.RelationshipDefBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getRelationshipLabel() {
        return this.relationshipLabel;
    }

    /**
     * Style of relationship in regard to containment and lifecycle.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RelationshipCategory getRelationshipCategory() {
        return this.relationshipCategory;
    }

    /**
     * Whether Atlan tags should propagate through this relationship, and if so in which direction(s).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PropagateTags getPropagateTags() {
        return this.propagateTags;
    }

    /**
     * Definition for the first endpoint of the relationship.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RelationshipEndDef getEndDef1() {
        return this.endDef1;
    }

    /**
     * Definition for the second endpoint of the relationship.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RelationshipEndDef getEndDef2() {
        return this.endDef2;
    }

    /**
     * Relationships that can exist for the entity.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<RelationshipAttributeDef> getRelationshipAttributeDefs() {
        return this.relationshipAttributeDefs;
    }

    /**
     * Subtypes of this entity type.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getSubTypes() {
        return this.subTypes;
    }

    /**
     * Supertypes of this entity type.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<String> getSuperTypes() {
        return this.superTypes;
    }

    /**
     * Unused.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, Object> getBusinessAttributeDefs() {
        return this.businessAttributeDefs;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof RelationshipDef)) return false;
        final RelationshipDef other = (RelationshipDef) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$category = this.getCategory();
        final java.lang.Object other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) return false;
        final java.lang.Object this$relationshipLabel = this.getRelationshipLabel();
        final java.lang.Object other$relationshipLabel = other.getRelationshipLabel();
        if (this$relationshipLabel == null ? other$relationshipLabel != null : !this$relationshipLabel.equals(other$relationshipLabel)) return false;
        final java.lang.Object this$relationshipCategory = this.getRelationshipCategory();
        final java.lang.Object other$relationshipCategory = other.getRelationshipCategory();
        if (this$relationshipCategory == null ? other$relationshipCategory != null : !this$relationshipCategory.equals(other$relationshipCategory)) return false;
        final java.lang.Object this$propagateTags = this.getPropagateTags();
        final java.lang.Object other$propagateTags = other.getPropagateTags();
        if (this$propagateTags == null ? other$propagateTags != null : !this$propagateTags.equals(other$propagateTags)) return false;
        final java.lang.Object this$endDef1 = this.getEndDef1();
        final java.lang.Object other$endDef1 = other.getEndDef1();
        if (this$endDef1 == null ? other$endDef1 != null : !this$endDef1.equals(other$endDef1)) return false;
        final java.lang.Object this$endDef2 = this.getEndDef2();
        final java.lang.Object other$endDef2 = other.getEndDef2();
        if (this$endDef2 == null ? other$endDef2 != null : !this$endDef2.equals(other$endDef2)) return false;
        final java.lang.Object this$relationshipAttributeDefs = this.getRelationshipAttributeDefs();
        final java.lang.Object other$relationshipAttributeDefs = other.getRelationshipAttributeDefs();
        if (this$relationshipAttributeDefs == null ? other$relationshipAttributeDefs != null : !this$relationshipAttributeDefs.equals(other$relationshipAttributeDefs)) return false;
        final java.lang.Object this$subTypes = this.getSubTypes();
        final java.lang.Object other$subTypes = other.getSubTypes();
        if (this$subTypes == null ? other$subTypes != null : !this$subTypes.equals(other$subTypes)) return false;
        final java.lang.Object this$superTypes = this.getSuperTypes();
        final java.lang.Object other$superTypes = other.getSuperTypes();
        if (this$superTypes == null ? other$superTypes != null : !this$superTypes.equals(other$superTypes)) return false;
        final java.lang.Object this$businessAttributeDefs = this.getBusinessAttributeDefs();
        final java.lang.Object other$businessAttributeDefs = other.getBusinessAttributeDefs();
        if (this$businessAttributeDefs == null ? other$businessAttributeDefs != null : !this$businessAttributeDefs.equals(other$businessAttributeDefs)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof RelationshipDef;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $category = this.getCategory();
        result = result * PRIME + ($category == null ? 43 : $category.hashCode());
        final java.lang.Object $relationshipLabel = this.getRelationshipLabel();
        result = result * PRIME + ($relationshipLabel == null ? 43 : $relationshipLabel.hashCode());
        final java.lang.Object $relationshipCategory = this.getRelationshipCategory();
        result = result * PRIME + ($relationshipCategory == null ? 43 : $relationshipCategory.hashCode());
        final java.lang.Object $propagateTags = this.getPropagateTags();
        result = result * PRIME + ($propagateTags == null ? 43 : $propagateTags.hashCode());
        final java.lang.Object $endDef1 = this.getEndDef1();
        result = result * PRIME + ($endDef1 == null ? 43 : $endDef1.hashCode());
        final java.lang.Object $endDef2 = this.getEndDef2();
        result = result * PRIME + ($endDef2 == null ? 43 : $endDef2.hashCode());
        final java.lang.Object $relationshipAttributeDefs = this.getRelationshipAttributeDefs();
        result = result * PRIME + ($relationshipAttributeDefs == null ? 43 : $relationshipAttributeDefs.hashCode());
        final java.lang.Object $subTypes = this.getSubTypes();
        result = result * PRIME + ($subTypes == null ? 43 : $subTypes.hashCode());
        final java.lang.Object $superTypes = this.getSuperTypes();
        result = result * PRIME + ($superTypes == null ? 43 : $superTypes.hashCode());
        final java.lang.Object $businessAttributeDefs = this.getBusinessAttributeDefs();
        result = result * PRIME + ($businessAttributeDefs == null ? 43 : $businessAttributeDefs.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "RelationshipDef(super=" + super.toString() + ", category=" + this.getCategory() + ", relationshipLabel=" + this.getRelationshipLabel() + ", relationshipCategory=" + this.getRelationshipCategory() + ", propagateTags=" + this.getPropagateTags() + ", endDef1=" + this.getEndDef1() + ", endDef2=" + this.getEndDef2() + ", relationshipAttributeDefs=" + this.getRelationshipAttributeDefs() + ", subTypes=" + this.getSubTypes() + ", superTypes=" + this.getSuperTypes() + ", businessAttributeDefs=" + this.getBusinessAttributeDefs() + ")";
    }

    /**
     * Fixed category for entity typedefs.
     */
    @Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanTypeCategory getCategory() {
        return this.category;
    }
}
