// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.typedefs;

import com.atlan.model.enums.AtlanCustomAttributeCardinality;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Defines the characteristics of the structure of one end of a relationship.
 */
@JsonPropertyOrder({"type", "name", "description", "isContainer", "cardinality", "isLegacyAttribute"})
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = RelationshipEndDef.RelationshipEndDefBuilderImpl.class)
public class RelationshipEndDef extends AttributeDef {
    private static final long serialVersionUID = 2L;
    /**
     * Name of the attribute that represents this end of the relationship.
     */
    String name;
    /**
     * Description of the relationship from this end of it.
     */
    String description;
    /**
     * Name of the type definition (entity type) for the other end of the relationship.
     */
    String type;
    /**
     * Whether this end of the relationship is a container ("owns" the other end's assets).
     */
    Boolean isContainer;
    /**
     * TBC
     */
    Boolean isLegacyAttribute;
    /**
     * Cardinality of this end of the relationship.
     */
    AtlanCustomAttributeCardinality cardinality;

    /**
     * Builds the minimal object necessary to construct a relationship end definition.
     * NOTE: INTERNAL USE ONLY.
     *
     * @param name of the attribute that represents this end of the relationship
     * @param type name of the entity definition for the other end of the relationship
     * @param isContainer whether this end of the relationship "owns" the other end's assets
     * @param cardinality of this end of the relationship
     * @return builder containing minimal information necessary to define a new relationship end
     */
    public static RelationshipEndDefBuilder<?, ?> creator(String name, String type, boolean isContainer, AtlanCustomAttributeCardinality cardinality) {
        return RelationshipEndDef.builder().name(name).type(type).isContainer(isContainer).cardinality(cardinality).isOptional(null).valuesMinCount(null).valuesMaxCount(null).isUnique(null).isIndexable(null).includeInNotification(null).isNew(null);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private static Boolean $default$isLegacyAttribute() {
        return false;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class RelationshipEndDefBuilder<C extends RelationshipEndDef, B extends RelationshipEndDef.RelationshipEndDefBuilder<C, B>> extends AttributeDef.AttributeDefBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String name;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String description;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String type;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isContainer;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean isLegacyAttribute$set;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Boolean isLegacyAttribute$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanCustomAttributeCardinality cardinality;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            RelationshipEndDef.RelationshipEndDefBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final RelationshipEndDef instance, final RelationshipEndDef.RelationshipEndDefBuilder<?, ?> b) {
            b.name(instance.name);
            b.description(instance.description);
            b.type(instance.type);
            b.isContainer(instance.isContainer);
            b.isLegacyAttribute(instance.isLegacyAttribute);
            b.cardinality(instance.cardinality);
        }

        /**
         * Name of the attribute that represents this end of the relationship.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B name(final String name) {
            this.name = name;
            return self();
        }

        /**
         * Description of the relationship from this end of it.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B description(final String description) {
            this.description = description;
            return self();
        }

        /**
         * Name of the type definition (entity type) for the other end of the relationship.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B type(final String type) {
            this.type = type;
            return self();
        }

        /**
         * Whether this end of the relationship is a container ("owns" the other end's assets).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isContainer(final Boolean isContainer) {
            this.isContainer = isContainer;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B isLegacyAttribute(final Boolean isLegacyAttribute) {
            this.isLegacyAttribute$value = isLegacyAttribute;
            isLegacyAttribute$set = true;
            return self();
        }

        /**
         * Cardinality of this end of the relationship.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B cardinality(final AtlanCustomAttributeCardinality cardinality) {
            this.cardinality = cardinality;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "RelationshipEndDef.RelationshipEndDefBuilder(super=" + super.toString() + ", name=" + this.name + ", description=" + this.description + ", type=" + this.type + ", isContainer=" + this.isContainer + ", isLegacyAttribute$value=" + this.isLegacyAttribute$value + ", cardinality=" + this.cardinality + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @JsonPropertyOrder({"type", "name", "description", "isContainer", "cardinality", "isLegacyAttribute"})
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class RelationshipEndDefBuilderImpl extends RelationshipEndDef.RelationshipEndDefBuilder<RelationshipEndDef, RelationshipEndDef.RelationshipEndDefBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private RelationshipEndDefBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected RelationshipEndDef.RelationshipEndDefBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public RelationshipEndDef build() {
            return new RelationshipEndDef(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected RelationshipEndDef(final RelationshipEndDef.RelationshipEndDefBuilder<?, ?> b) {
        super(b);
        this.name = b.name;
        this.description = b.description;
        this.type = b.type;
        this.isContainer = b.isContainer;
        if (b.isLegacyAttribute$set) this.isLegacyAttribute = b.isLegacyAttribute$value;
         else this.isLegacyAttribute = RelationshipEndDef.$default$isLegacyAttribute();
        this.cardinality = b.cardinality;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static RelationshipEndDef.RelationshipEndDefBuilder<?, ?> builder() {
        return new RelationshipEndDef.RelationshipEndDefBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RelationshipEndDef.RelationshipEndDefBuilder<?, ?> toBuilder() {
        return new RelationshipEndDef.RelationshipEndDefBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Name of the attribute that represents this end of the relationship.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
        return this.name;
    }

    /**
     * Description of the relationship from this end of it.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Name of the type definition (entity type) for the other end of the relationship.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getType() {
        return this.type;
    }

    /**
     * Whether this end of the relationship is a container ("owns" the other end's assets).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsContainer() {
        return this.isContainer;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Boolean getIsLegacyAttribute() {
        return this.isLegacyAttribute;
    }

    /**
     * Cardinality of this end of the relationship.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanCustomAttributeCardinality getCardinality() {
        return this.cardinality;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof RelationshipEndDef)) return false;
        final RelationshipEndDef other = (RelationshipEndDef) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$isContainer = this.getIsContainer();
        final java.lang.Object other$isContainer = other.getIsContainer();
        if (this$isContainer == null ? other$isContainer != null : !this$isContainer.equals(other$isContainer)) return false;
        final java.lang.Object this$isLegacyAttribute = this.getIsLegacyAttribute();
        final java.lang.Object other$isLegacyAttribute = other.getIsLegacyAttribute();
        if (this$isLegacyAttribute == null ? other$isLegacyAttribute != null : !this$isLegacyAttribute.equals(other$isLegacyAttribute)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$description = this.getDescription();
        final java.lang.Object other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        final java.lang.Object this$cardinality = this.getCardinality();
        final java.lang.Object other$cardinality = other.getCardinality();
        if (this$cardinality == null ? other$cardinality != null : !this$cardinality.equals(other$cardinality)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof RelationshipEndDef;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $isContainer = this.getIsContainer();
        result = result * PRIME + ($isContainer == null ? 43 : $isContainer.hashCode());
        final java.lang.Object $isLegacyAttribute = this.getIsLegacyAttribute();
        result = result * PRIME + ($isLegacyAttribute == null ? 43 : $isLegacyAttribute.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $description = this.getDescription();
        result = result * PRIME + ($description == null ? 43 : $description.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        final java.lang.Object $cardinality = this.getCardinality();
        result = result * PRIME + ($cardinality == null ? 43 : $cardinality.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "RelationshipEndDef(super=" + super.toString() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", type=" + this.getType() + ", isContainer=" + this.getIsContainer() + ", isLegacyAttribute=" + this.getIsLegacyAttribute() + ", cardinality=" + this.getCardinality() + ")";
    }
}
