// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.typedefs;

import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanTypeCategory;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import lombok.*;

/**
 * Base class for all type definitions (typedefs) in Atlan.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "category")
@JsonSubTypes({@JsonSubTypes.Type(value = AtlanTagDef.class, name = "CLASSIFICATION"), @JsonSubTypes.Type(value = EnumDef.class, name = "ENUM"), @JsonSubTypes.Type(value = CustomMetadataDef.class, name = "BUSINESS_METADATA"), @JsonSubTypes.Type(value = EntityDef.class, name = "ENTITY"), @JsonSubTypes.Type(value = RelationshipDef.class, name = "RELATIONSHIP"), @JsonSubTypes.Type(value = StructDef.class, name = "STRUCT")})
public abstract class TypeDef extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * Type of the type definition itself.
     */
    transient AtlanTypeCategory category;
    /**
     * Unique identifier for the type definition.
     */
    String guid;
    /**
     * User who created the type definition.
     */
    String createdBy;
    /**
     * User who last updated the type definition.
     */
    String updatedBy;
    /**
     * Time (epoch) in milliseconds when the type definition was created.
     */
    Long createTime;
    /**
     * Time (epoch) in milliseconds when the type definition was last updated.
     */
    Long updateTime;
    /**
     * TBC
     */
    Long version;
    /**
     * Internal hashed-string name for the type definition.
     */
    String name;
    /**
     * Explanation of the type definition.
     */
    String description;
    /**
     * TBC
     */
    String serviceType;
    /**
     * TBC
     */
    String typeVersion;
    /**
     * List of attributes defined within the type definition.
     */
    List<AttributeDef> attributeDefs;
    /**
     * Human-readable name of the type definition.
     */
    String displayName;


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class TypeDefBuilder<C extends TypeDef, B extends TypeDef.TypeDefBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private AtlanTypeCategory category;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String guid;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String createdBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String updatedBy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long createTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long updateTime;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long version;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String name;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String description;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String serviceType;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String typeVersion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<AttributeDef> attributeDefs;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String displayName;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            TypeDef.TypeDefBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final TypeDef instance, final TypeDef.TypeDefBuilder<?, ?> b) {
            b.category(instance.category);
            b.guid(instance.guid);
            b.createdBy(instance.createdBy);
            b.updatedBy(instance.updatedBy);
            b.createTime(instance.createTime);
            b.updateTime(instance.updateTime);
            b.version(instance.version);
            b.name(instance.name);
            b.description(instance.description);
            b.serviceType(instance.serviceType);
            b.typeVersion(instance.typeVersion);
            b.attributeDefs(instance.attributeDefs == null ? java.util.Collections.<AttributeDef>emptyList() : instance.attributeDefs);
            b.displayName(instance.displayName);
        }

        /**
         * Type of the type definition itself.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B category(final AtlanTypeCategory category) {
            this.category = category;
            return self();
        }

        /**
         * Unique identifier for the type definition.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B guid(final String guid) {
            this.guid = guid;
            return self();
        }

        /**
         * User who created the type definition.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B createdBy(final String createdBy) {
            this.createdBy = createdBy;
            return self();
        }

        /**
         * User who last updated the type definition.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B updatedBy(final String updatedBy) {
            this.updatedBy = updatedBy;
            return self();
        }

        /**
         * Time (epoch) in milliseconds when the type definition was created.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B createTime(final Long createTime) {
            this.createTime = createTime;
            return self();
        }

        /**
         * Time (epoch) in milliseconds when the type definition was last updated.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B updateTime(final Long updateTime) {
            this.updateTime = updateTime;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B version(final Long version) {
            this.version = version;
            return self();
        }

        /**
         * Internal hashed-string name for the type definition.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B name(final String name) {
            this.name = name;
            return self();
        }

        /**
         * Explanation of the type definition.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B description(final String description) {
            this.description = description;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B serviceType(final String serviceType) {
            this.serviceType = serviceType;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B typeVersion(final String typeVersion) {
            this.typeVersion = typeVersion;
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B attributeDef(final AttributeDef attributeDef) {
            if (this.attributeDefs == null) this.attributeDefs = new java.util.ArrayList<AttributeDef>();
            this.attributeDefs.add(attributeDef);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B attributeDefs(final java.util.Collection<? extends AttributeDef> attributeDefs) {
            if (attributeDefs == null) {
                throw new java.lang.NullPointerException("attributeDefs cannot be null");
            }
            if (this.attributeDefs == null) this.attributeDefs = new java.util.ArrayList<AttributeDef>();
            this.attributeDefs.addAll(attributeDefs);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAttributeDefs() {
            if (this.attributeDefs != null) this.attributeDefs.clear();
            return self();
        }

        /**
         * Human-readable name of the type definition.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B displayName(final String displayName) {
            this.displayName = displayName;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "TypeDef.TypeDefBuilder(super=" + super.toString() + ", category=" + this.category + ", guid=" + this.guid + ", createdBy=" + this.createdBy + ", updatedBy=" + this.updatedBy + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ", version=" + this.version + ", name=" + this.name + ", description=" + this.description + ", serviceType=" + this.serviceType + ", typeVersion=" + this.typeVersion + ", attributeDefs=" + this.attributeDefs + ", displayName=" + this.displayName + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected TypeDef(final TypeDef.TypeDefBuilder<?, ?> b) {
        super(b);
        this.category = b.category;
        this.guid = b.guid;
        this.createdBy = b.createdBy;
        this.updatedBy = b.updatedBy;
        this.createTime = b.createTime;
        this.updateTime = b.updateTime;
        this.version = b.version;
        this.name = b.name;
        this.description = b.description;
        this.serviceType = b.serviceType;
        this.typeVersion = b.typeVersion;
        java.util.List<AttributeDef> attributeDefs;
        switch (b.attributeDefs == null ? 0 : b.attributeDefs.size()) {
        case 0: 
            attributeDefs = java.util.Collections.emptyList();
            break;
        case 1: 
            attributeDefs = java.util.Collections.singletonList(b.attributeDefs.get(0));
            break;
        default: 
            attributeDefs = java.util.Collections.unmodifiableList(new java.util.ArrayList<AttributeDef>(b.attributeDefs));
        }
        this.attributeDefs = attributeDefs;
        this.displayName = b.displayName;
    }

    /**
     * Type of the type definition itself.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanTypeCategory getCategory() {
        return this.category;
    }

    /**
     * Unique identifier for the type definition.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGuid() {
        return this.guid;
    }

    /**
     * User who created the type definition.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    /**
     * User who last updated the type definition.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    /**
     * Time (epoch) in milliseconds when the type definition was created.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getCreateTime() {
        return this.createTime;
    }

    /**
     * Time (epoch) in milliseconds when the type definition was last updated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getUpdateTime() {
        return this.updateTime;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getVersion() {
        return this.version;
    }

    /**
     * Internal hashed-string name for the type definition.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
        return this.name;
    }

    /**
     * Explanation of the type definition.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getServiceType() {
        return this.serviceType;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getTypeVersion() {
        return this.typeVersion;
    }

    /**
     * List of attributes defined within the type definition.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<AttributeDef> getAttributeDefs() {
        return this.attributeDefs;
    }

    /**
     * Human-readable name of the type definition.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof TypeDef)) return false;
        final TypeDef other = (TypeDef) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$createTime = this.getCreateTime();
        final java.lang.Object other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) return false;
        final java.lang.Object this$updateTime = this.getUpdateTime();
        final java.lang.Object other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) return false;
        final java.lang.Object this$version = this.getVersion();
        final java.lang.Object other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) return false;
        final java.lang.Object this$guid = this.getGuid();
        final java.lang.Object other$guid = other.getGuid();
        if (this$guid == null ? other$guid != null : !this$guid.equals(other$guid)) return false;
        final java.lang.Object this$createdBy = this.getCreatedBy();
        final java.lang.Object other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) return false;
        final java.lang.Object this$updatedBy = this.getUpdatedBy();
        final java.lang.Object other$updatedBy = other.getUpdatedBy();
        if (this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$description = this.getDescription();
        final java.lang.Object other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
        final java.lang.Object this$serviceType = this.getServiceType();
        final java.lang.Object other$serviceType = other.getServiceType();
        if (this$serviceType == null ? other$serviceType != null : !this$serviceType.equals(other$serviceType)) return false;
        final java.lang.Object this$typeVersion = this.getTypeVersion();
        final java.lang.Object other$typeVersion = other.getTypeVersion();
        if (this$typeVersion == null ? other$typeVersion != null : !this$typeVersion.equals(other$typeVersion)) return false;
        final java.lang.Object this$attributeDefs = this.getAttributeDefs();
        final java.lang.Object other$attributeDefs = other.getAttributeDefs();
        if (this$attributeDefs == null ? other$attributeDefs != null : !this$attributeDefs.equals(other$attributeDefs)) return false;
        final java.lang.Object this$displayName = this.getDisplayName();
        final java.lang.Object other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof TypeDef;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $createTime = this.getCreateTime();
        result = result * PRIME + ($createTime == null ? 43 : $createTime.hashCode());
        final java.lang.Object $updateTime = this.getUpdateTime();
        result = result * PRIME + ($updateTime == null ? 43 : $updateTime.hashCode());
        final java.lang.Object $version = this.getVersion();
        result = result * PRIME + ($version == null ? 43 : $version.hashCode());
        final java.lang.Object $guid = this.getGuid();
        result = result * PRIME + ($guid == null ? 43 : $guid.hashCode());
        final java.lang.Object $createdBy = this.getCreatedBy();
        result = result * PRIME + ($createdBy == null ? 43 : $createdBy.hashCode());
        final java.lang.Object $updatedBy = this.getUpdatedBy();
        result = result * PRIME + ($updatedBy == null ? 43 : $updatedBy.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $description = this.getDescription();
        result = result * PRIME + ($description == null ? 43 : $description.hashCode());
        final java.lang.Object $serviceType = this.getServiceType();
        result = result * PRIME + ($serviceType == null ? 43 : $serviceType.hashCode());
        final java.lang.Object $typeVersion = this.getTypeVersion();
        result = result * PRIME + ($typeVersion == null ? 43 : $typeVersion.hashCode());
        final java.lang.Object $attributeDefs = this.getAttributeDefs();
        result = result * PRIME + ($attributeDefs == null ? 43 : $attributeDefs.hashCode());
        final java.lang.Object $displayName = this.getDisplayName();
        result = result * PRIME + ($displayName == null ? 43 : $displayName.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "TypeDef(super=" + super.toString() + ", category=" + this.getCategory() + ", guid=" + this.getGuid() + ", createdBy=" + this.getCreatedBy() + ", updatedBy=" + this.getUpdatedBy() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", version=" + this.getVersion() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", serviceType=" + this.getServiceType() + ", typeVersion=" + this.getTypeVersion() + ", attributeDefs=" + this.getAttributeDefs() + ", displayName=" + this.getDisplayName() + ")";
    }
}
