// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.workflow;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.PackageParameter;
import com.atlan.model.core.AtlanObject;
import java.util.List;

/**
 * Definition of a runnable workflow in Atlan.
 */
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = Workflow.WorkflowBuilderImpl.class)
public class Workflow extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * Metadata that describes the workflow.
     */
    WorkflowMetadata metadata;
    /**
     * Specification of the workflow: per-task inputs, outputs, and logic.
     */
    WorkflowSpec spec;
    /**
     * Parameters to send to the workflow as a whole (not an individual task).
     */
    List<PackageParameter> payload;

    /**
     * Run the workflow immediately.
     *
     * @return the details of the workflow run
     * @throws AtlanException on any API communication issue
     */
    public WorkflowResponse run() throws AtlanException {
        return run(Atlan.getDefaultClient());
    }

    /**
     * Run the workflow immediately.
     *
     * @param client connectivity to the Atlan tenant on which to run the workflow
     * @return the details of the workflow run
     * @throws AtlanException on any API communication issue
     */
    public WorkflowResponse run(AtlanClient client) throws AtlanException {
        return client.workflows.run(this);
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class WorkflowBuilder<C extends Workflow, B extends Workflow.WorkflowBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private WorkflowMetadata metadata;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private WorkflowSpec spec;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<PackageParameter> payload;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            Workflow.WorkflowBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final Workflow instance, final Workflow.WorkflowBuilder<?, ?> b) {
            b.metadata(instance.metadata);
            b.spec(instance.spec);
            b.payload(instance.payload);
        }

        /**
         * Metadata that describes the workflow.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B metadata(final WorkflowMetadata metadata) {
            this.metadata = metadata;
            return self();
        }

        /**
         * Specification of the workflow: per-task inputs, outputs, and logic.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B spec(final WorkflowSpec spec) {
            this.spec = spec;
            return self();
        }

        /**
         * Parameters to send to the workflow as a whole (not an individual task).
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B payload(final List<PackageParameter> payload) {
            this.payload = payload;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "Workflow.WorkflowBuilder(super=" + super.toString() + ", metadata=" + this.metadata + ", spec=" + this.spec + ", payload=" + this.payload + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class WorkflowBuilderImpl extends Workflow.WorkflowBuilder<Workflow, Workflow.WorkflowBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private WorkflowBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected Workflow.WorkflowBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Workflow build() {
            return new Workflow(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected Workflow(final Workflow.WorkflowBuilder<?, ?> b) {
        super(b);
        this.metadata = b.metadata;
        this.spec = b.spec;
        this.payload = b.payload;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static Workflow.WorkflowBuilder<?, ?> builder() {
        return new Workflow.WorkflowBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Workflow.WorkflowBuilder<?, ?> toBuilder() {
        return new Workflow.WorkflowBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Metadata that describes the workflow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WorkflowMetadata getMetadata() {
        return this.metadata;
    }

    /**
     * Specification of the workflow: per-task inputs, outputs, and logic.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WorkflowSpec getSpec() {
        return this.spec;
    }

    /**
     * Parameters to send to the workflow as a whole (not an individual task).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<PackageParameter> getPayload() {
        return this.payload;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Workflow)) return false;
        final Workflow other = (Workflow) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$metadata = this.getMetadata();
        final java.lang.Object other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
        final java.lang.Object this$spec = this.getSpec();
        final java.lang.Object other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) return false;
        final java.lang.Object this$payload = this.getPayload();
        final java.lang.Object other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Workflow;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $metadata = this.getMetadata();
        result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
        final java.lang.Object $spec = this.getSpec();
        result = result * PRIME + ($spec == null ? 43 : $spec.hashCode());
        final java.lang.Object $payload = this.getPayload();
        result = result * PRIME + ($payload == null ? 43 : $payload.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Workflow(super=" + super.toString() + ", metadata=" + this.getMetadata() + ", spec=" + this.getSpec() + ", payload=" + this.getPayload() + ")";
    }
}
