// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.workflow;

import com.atlan.model.core.AtlanObject;
import java.util.List;
import java.util.Map;

/**
 * Metadata that describes a workflow.
 */
@SuppressWarnings("cast")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = WorkflowMetadata.WorkflowMetadataBuilderImpl.class)
public class WorkflowMetadata extends AtlanObject {
    private static final long serialVersionUID = 2L;
    /**
     * Labels that describe the workflow. These are usually a combination of keys that
     * start with {@code orchestration.atlan.com}, {@code package.argoproj.io}, and
     * {@code workflows.argoproj.io}.
     */
    Map<String, String> labels;
    /**
     * Annotations that describe the workflow. These are usually a combination of keys that
     * start with {@code orchestration.atlan.com} and {@code package.argoproj.io}.
     */
    Map<String, String> annotations;
    /**
     * Name of the workflow.
     */
    String name;
    /**
     * Kubernetes namespace in which the workflow is defined.
     */
    String namespace;
    /**
     * Unique identifier (GUID) of the workflow.
     */
    final String uid;
    /**
     * TBC
     */
    final String resourceVersion;
    /**
     * TBC
     */
    final String generateName;
    /**
     * Indication of the version of this workflow. Each modification to the workflow will increment the
     * generation, such that a generation of {@code 1} is the initial workflow definition, a generation of
     * {@code 2} is the first time the workflow's configuration has been modified, and so on.
     */
    final Long generation;
    /**
     * Time at which the workflow was created, as a formatted string.
     */
    final String creationTimestamp;
    /**
     * TBC *
     */
    final List<Object> managedFields;


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static abstract class WorkflowMetadataBuilder<C extends WorkflowMetadata, B extends WorkflowMetadata.WorkflowMetadataBuilder<C, B>> extends AtlanObject.AtlanObjectBuilder<C, B> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> labels$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> labels$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> annotations$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> annotations$value;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String name;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String namespace;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String uid;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String resourceVersion;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String generateName;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Long generation;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String creationTimestamp;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private List<Object> managedFields;

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected B $fillValuesFrom(final C instance) {
            super.$fillValuesFrom(instance);
            WorkflowMetadata.WorkflowMetadataBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private static void $fillValuesFromInstanceIntoBuilder(final WorkflowMetadata instance, final WorkflowMetadata.WorkflowMetadataBuilder<?, ?> b) {
            b.labels(instance.labels == null ? java.util.Collections.<String, String>emptyMap() : instance.labels);
            b.annotations(instance.annotations == null ? java.util.Collections.<String, String>emptyMap() : instance.annotations);
            b.name(instance.name);
            b.namespace(instance.namespace);
            b.uid(instance.uid);
            b.resourceVersion(instance.resourceVersion);
            b.generateName(instance.generateName);
            b.generation(instance.generation);
            b.creationTimestamp(instance.creationTimestamp);
            b.managedFields(instance.managedFields);
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B label(final String labelKey, final String labelValue) {
            if (this.labels$key == null) {
                this.labels$key = new java.util.ArrayList<String>();
                this.labels$value = new java.util.ArrayList<String>();
            }
            this.labels$key.add(labelKey);
            this.labels$value.add(labelValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B labels(final java.util.Map<? extends String, ? extends String> labels) {
            if (labels == null) {
                throw new java.lang.NullPointerException("labels cannot be null");
            }
            if (this.labels$key == null) {
                this.labels$key = new java.util.ArrayList<String>();
                this.labels$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : labels.entrySet()) {
                this.labels$key.add($lombokEntry.getKey());
                this.labels$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearLabels() {
            if (this.labels$key != null) {
                this.labels$key.clear();
                this.labels$value.clear();
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B annotation(final String annotationKey, final String annotationValue) {
            if (this.annotations$key == null) {
                this.annotations$key = new java.util.ArrayList<String>();
                this.annotations$value = new java.util.ArrayList<String>();
            }
            this.annotations$key.add(annotationKey);
            this.annotations$value.add(annotationValue);
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B annotations(final java.util.Map<? extends String, ? extends String> annotations) {
            if (annotations == null) {
                throw new java.lang.NullPointerException("annotations cannot be null");
            }
            if (this.annotations$key == null) {
                this.annotations$key = new java.util.ArrayList<String>();
                this.annotations$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : annotations.entrySet()) {
                this.annotations$key.add($lombokEntry.getKey());
                this.annotations$value.add($lombokEntry.getValue());
            }
            return self();
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B clearAnnotations() {
            if (this.annotations$key != null) {
                this.annotations$key.clear();
                this.annotations$value.clear();
            }
            return self();
        }

        /**
         * Name of the workflow.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B name(final String name) {
            this.name = name;
            return self();
        }

        /**
         * Kubernetes namespace in which the workflow is defined.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B namespace(final String namespace) {
            this.namespace = namespace;
            return self();
        }

        /**
         * Unique identifier (GUID) of the workflow.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B uid(final String uid) {
            this.uid = uid;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B resourceVersion(final String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return self();
        }

        /**
         * TBC
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B generateName(final String generateName) {
            this.generateName = generateName;
            return self();
        }

        /**
         * Indication of the version of this workflow. Each modification to the workflow will increment the
         * generation, such that a generation of {@code 1} is the initial workflow definition, a generation of
         * {@code 2} is the first time the workflow's configuration has been modified, and so on.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B generation(final Long generation) {
            this.generation = generation;
            return self();
        }

        /**
         * Time at which the workflow was created, as a formatted string.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B creationTimestamp(final String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return self();
        }

        /**
         * TBC *
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public B managedFields(final List<Object> managedFields) {
            this.managedFields = managedFields;
            return self();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected abstract B self();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public abstract C build();

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "WorkflowMetadata.WorkflowMetadataBuilder(super=" + super.toString() + ", labels$key=" + this.labels$key + ", labels$value=" + this.labels$value + ", annotations$key=" + this.annotations$key + ", annotations$value=" + this.annotations$value + ", name=" + this.name + ", namespace=" + this.namespace + ", uid=" + this.uid + ", resourceVersion=" + this.resourceVersion + ", generateName=" + this.generateName + ", generation=" + this.generation + ", creationTimestamp=" + this.creationTimestamp + ", managedFields=" + this.managedFields + ")";
        }
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "", buildMethodName = "build")
    static final class WorkflowMetadataBuilderImpl extends WorkflowMetadata.WorkflowMetadataBuilder<WorkflowMetadata, WorkflowMetadata.WorkflowMetadataBuilderImpl> {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private WorkflowMetadataBuilderImpl() {
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected WorkflowMetadata.WorkflowMetadataBuilderImpl self() {
            return this;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public WorkflowMetadata build() {
            return new WorkflowMetadata(this);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected WorkflowMetadata(final WorkflowMetadata.WorkflowMetadataBuilder<?, ?> b) {
        super(b);
        java.util.Map<String, String> labels;
        switch (b.labels$key == null ? 0 : b.labels$key.size()) {
        case 0: 
            labels = java.util.Collections.emptyMap();
            break;
        case 1: 
            labels = java.util.Collections.singletonMap(b.labels$key.get(0), b.labels$value.get(0));
            break;
        default: 
            labels = new java.util.LinkedHashMap<String, String>(b.labels$key.size() < 1073741824 ? 1 + b.labels$key.size() + (b.labels$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.labels$key.size(); $i++) labels.put(b.labels$key.get($i), (String) b.labels$value.get($i));
            labels = java.util.Collections.unmodifiableMap(labels);
        }
        this.labels = labels;
        java.util.Map<String, String> annotations;
        switch (b.annotations$key == null ? 0 : b.annotations$key.size()) {
        case 0: 
            annotations = java.util.Collections.emptyMap();
            break;
        case 1: 
            annotations = java.util.Collections.singletonMap(b.annotations$key.get(0), b.annotations$value.get(0));
            break;
        default: 
            annotations = new java.util.LinkedHashMap<String, String>(b.annotations$key.size() < 1073741824 ? 1 + b.annotations$key.size() + (b.annotations$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
            for (int $i = 0; $i < b.annotations$key.size(); $i++) annotations.put(b.annotations$key.get($i), (String) b.annotations$value.get($i));
            annotations = java.util.Collections.unmodifiableMap(annotations);
        }
        this.annotations = annotations;
        this.name = b.name;
        this.namespace = b.namespace;
        this.uid = b.uid;
        this.resourceVersion = b.resourceVersion;
        this.generateName = b.generateName;
        this.generation = b.generation;
        this.creationTimestamp = b.creationTimestamp;
        this.managedFields = b.managedFields;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static WorkflowMetadata.WorkflowMetadataBuilder<?, ?> builder() {
        return new WorkflowMetadata.WorkflowMetadataBuilderImpl();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WorkflowMetadata.WorkflowMetadataBuilder<?, ?> toBuilder() {
        return new WorkflowMetadata.WorkflowMetadataBuilderImpl().$fillValuesFrom(this);
    }

    /**
     * Labels that describe the workflow. These are usually a combination of keys that
     * start with {@code orchestration.atlan.com}, {@code package.argoproj.io}, and
     * {@code workflows.argoproj.io}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getLabels() {
        return this.labels;
    }

    /**
     * Annotations that describe the workflow. These are usually a combination of keys that
     * start with {@code orchestration.atlan.com} and {@code package.argoproj.io}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    /**
     * Name of the workflow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getName() {
        return this.name;
    }

    /**
     * Kubernetes namespace in which the workflow is defined.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getNamespace() {
        return this.namespace;
    }

    /**
     * Unique identifier (GUID) of the workflow.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getUid() {
        return this.uid;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    /**
     * TBC
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getGenerateName() {
        return this.generateName;
    }

    /**
     * Indication of the version of this workflow. Each modification to the workflow will increment the
     * generation, such that a generation of {@code 1} is the initial workflow definition, a generation of
     * {@code 2} is the first time the workflow's configuration has been modified, and so on.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Long getGeneration() {
        return this.generation;
    }

    /**
     * Time at which the workflow was created, as a formatted string.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    /**
     * TBC *
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Object> getManagedFields() {
        return this.managedFields;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof WorkflowMetadata)) return false;
        final WorkflowMetadata other = (WorkflowMetadata) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$generation = this.getGeneration();
        final java.lang.Object other$generation = other.getGeneration();
        if (this$generation == null ? other$generation != null : !this$generation.equals(other$generation)) return false;
        final java.lang.Object this$labels = this.getLabels();
        final java.lang.Object other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !this$labels.equals(other$labels)) return false;
        final java.lang.Object this$annotations = this.getAnnotations();
        final java.lang.Object other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !this$annotations.equals(other$annotations)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$namespace = this.getNamespace();
        final java.lang.Object other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) return false;
        final java.lang.Object this$uid = this.getUid();
        final java.lang.Object other$uid = other.getUid();
        if (this$uid == null ? other$uid != null : !this$uid.equals(other$uid)) return false;
        final java.lang.Object this$resourceVersion = this.getResourceVersion();
        final java.lang.Object other$resourceVersion = other.getResourceVersion();
        if (this$resourceVersion == null ? other$resourceVersion != null : !this$resourceVersion.equals(other$resourceVersion)) return false;
        final java.lang.Object this$generateName = this.getGenerateName();
        final java.lang.Object other$generateName = other.getGenerateName();
        if (this$generateName == null ? other$generateName != null : !this$generateName.equals(other$generateName)) return false;
        final java.lang.Object this$creationTimestamp = this.getCreationTimestamp();
        final java.lang.Object other$creationTimestamp = other.getCreationTimestamp();
        if (this$creationTimestamp == null ? other$creationTimestamp != null : !this$creationTimestamp.equals(other$creationTimestamp)) return false;
        final java.lang.Object this$managedFields = this.getManagedFields();
        final java.lang.Object other$managedFields = other.getManagedFields();
        if (this$managedFields == null ? other$managedFields != null : !this$managedFields.equals(other$managedFields)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof WorkflowMetadata;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $generation = this.getGeneration();
        result = result * PRIME + ($generation == null ? 43 : $generation.hashCode());
        final java.lang.Object $labels = this.getLabels();
        result = result * PRIME + ($labels == null ? 43 : $labels.hashCode());
        final java.lang.Object $annotations = this.getAnnotations();
        result = result * PRIME + ($annotations == null ? 43 : $annotations.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $namespace = this.getNamespace();
        result = result * PRIME + ($namespace == null ? 43 : $namespace.hashCode());
        final java.lang.Object $uid = this.getUid();
        result = result * PRIME + ($uid == null ? 43 : $uid.hashCode());
        final java.lang.Object $resourceVersion = this.getResourceVersion();
        result = result * PRIME + ($resourceVersion == null ? 43 : $resourceVersion.hashCode());
        final java.lang.Object $generateName = this.getGenerateName();
        result = result * PRIME + ($generateName == null ? 43 : $generateName.hashCode());
        final java.lang.Object $creationTimestamp = this.getCreationTimestamp();
        result = result * PRIME + ($creationTimestamp == null ? 43 : $creationTimestamp.hashCode());
        final java.lang.Object $managedFields = this.getManagedFields();
        result = result * PRIME + ($managedFields == null ? 43 : $managedFields.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "WorkflowMetadata(super=" + super.toString() + ", labels=" + this.getLabels() + ", annotations=" + this.getAnnotations() + ", name=" + this.getName() + ", namespace=" + this.getNamespace() + ", uid=" + this.getUid() + ", resourceVersion=" + this.getResourceVersion() + ", generateName=" + this.getGenerateName() + ", generation=" + this.getGeneration() + ", creationTimestamp=" + this.getCreationTimestamp() + ", managedFields=" + this.getManagedFields() + ")";
    }
}
