// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.workflow;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.enums.AtlanWorkflowPhase;
import com.atlan.net.ApiResource;
import com.atlan.net.HttpClient;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class WorkflowResponse extends ApiResource {
    private static final long serialVersionUID = 2L;
    /**
     * Connectivity to the Atlan tenant where the workflow request was run.
     */
    @JsonIgnore
    AtlanClient client;
    WorkflowMetadata metadata;
    WorkflowSpec spec;
    List<Object> payload;

    /**
     * Monitor the status of the workflow's run, blocking until it has completed.
     * Note that this variation of the method will not log any activity, but will simply block
     * until the workflow completes.
     *
     * @return the status at completion, or null if the workflow was not even run
     * @throws AtlanException on any errors running the workflow
     * @throws InterruptedException on any interruption of the busy wait loop
     */
    public AtlanWorkflowPhase monitorStatus() throws AtlanException, InterruptedException {
        return monitorStatus(null);
    }

    /**
     * Monitor the status of the workflow's run, blocking until it has completed.
     *
     * @param log through which to log status information (INFO-level, by default)
     * @return the status at completion, or null if the workflow was not even run
     * @throws AtlanException on any errors running the workflow
     * @throws InterruptedException on any interruption of the busy wait loop
     */
    public AtlanWorkflowPhase monitorStatus(Logger log) throws AtlanException, InterruptedException {
        return monitorStatus(log, Level.INFO);
    }

    /**
     * Monitor the status of the workflow's run, blocking until it has completed.
     *
     * @param log through which to log status information (INFO-level)
     * @param level through which to log the status information
     * @return the status at completion, or null if the workflow was not even run
     * @throws AtlanException on any errors running the workflow
     * @throws InterruptedException on any interruption of the busy wait loop
     */
    public AtlanWorkflowPhase monitorStatus(Logger log, Level level) throws AtlanException, InterruptedException {
        return monitorStatus(log, level, Long.MAX_VALUE);
    }

    /**
     * Monitor the status of the workflow's run, blocking until it has completed.
     *
     * @param log through which to log status information (INFO-level)
     * @param level through which to log the status information
     * @param maxWaitTime maximum time to block (in seconds), after which to stop monitoring and return
     * @return the status at completion, or null if the workflow was not even run (or has not yet completed when returning)
     * @throws AtlanException on any errors running the workflow
     * @throws InterruptedException on any interruption of the busy wait loop
     */
    public AtlanWorkflowPhase monitorStatus(Logger log, Level level, long maxWaitTime) throws AtlanException, InterruptedException {
        long start = System.currentTimeMillis();
        long elapsed;
        if (getMetadata() != null && getMetadata().getName() != null) {
            String name = getMetadata().getName();
            AtlanWorkflowPhase status = null;
            do {
                // Fix a value here so that we go to the high-end of the wait duration,
                // but still apply a jitter each time
                // (Moved to the start of the loop to give a brief startup delay to avoid
                //  any false-positives on retrieving the latest run and picking up a previous
                //  run.)
                Thread.sleep(HttpClient.waitTime(5).toMillis());
                final WorkflowSearchResult runDetails = getRunDetails(name);
                if (runDetails != null) {
                    status = runDetails.getStatus();
                }
                if (log != null) {
                    log.atLevel(level).log("Workflow {}: {}", name, status);
                }
                elapsed = (System.currentTimeMillis() - start) / 1000;
            } while (status != AtlanWorkflowPhase.SUCCESS && status != AtlanWorkflowPhase.ERROR && status != AtlanWorkflowPhase.FAILED && elapsed <= maxWaitTime);
            if (log != null) {
                log.atLevel(level).log("Workflow {}: {}", name, status);
            }
            return status;
        } else {
            if (log != null) {
                log.atLevel(level).log("Skipping workflow monitoring — nothing to monitor.");
            }
            return null;
        }
    }

    /**
     * Stop this workflow.
     * Note: the result will be returned immediately (async), so you may need to further poll
     * until the workflow is actually stopped.
     *
     * @throws AtlanException on any API errors stopping the workflow run
     * @return the result of the stop command, or null if there was no running workflow to stop
     */
    public WorkflowRunResponse stop() throws AtlanException {
        WorkflowSearchResult latest = getRunDetails(getMetadata().getName());
        if (latest != null && latest.get_id() != null) {
            return client.workflows.stop(latest.get_id(), null);
        }
        return null;
    }

    /**
     * Retrieve the workflow run details.
     *
     * @param name of the workflow template
     * @return the details of the workflow run
     * @throws AtlanException on any API errors searching for the workflow run
     */
    protected WorkflowSearchResult getRunDetails(String name) throws AtlanException {
        return WorkflowSearchRequest.findLatestRun(client, name);
    }

    /**
     * Connectivity to the Atlan tenant where the workflow request was run.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanClient getClient() {
        return this.client;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WorkflowMetadata getMetadata() {
        return this.metadata;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WorkflowSpec getSpec() {
        return this.spec;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Object> getPayload() {
        return this.payload;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof WorkflowResponse)) return false;
        final WorkflowResponse other = (WorkflowResponse) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$client = this.getClient();
        final java.lang.Object other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) return false;
        final java.lang.Object this$metadata = this.getMetadata();
        final java.lang.Object other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
        final java.lang.Object this$spec = this.getSpec();
        final java.lang.Object other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) return false;
        final java.lang.Object this$payload = this.getPayload();
        final java.lang.Object other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof WorkflowResponse;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $client = this.getClient();
        result = result * PRIME + ($client == null ? 43 : $client.hashCode());
        final java.lang.Object $metadata = this.getMetadata();
        result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
        final java.lang.Object $spec = this.getSpec();
        result = result * PRIME + ($spec == null ? 43 : $spec.hashCode());
        final java.lang.Object $payload = this.getPayload();
        result = result * PRIME + ($payload == null ? 43 : $payload.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "WorkflowResponse(super=" + super.toString() + ", client=" + this.getClient() + ", metadata=" + this.getMetadata() + ", spec=" + this.getSpec() + ", payload=" + this.getPayload() + ")";
    }

    /**
     * Connectivity to the Atlan tenant where the workflow request was run.
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setClient(final AtlanClient client) {
        this.client = client;
    }
}
