// Generated by delombok at Wed Oct 09 00:01:45 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.model.workflow;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanWorkflowPhase;
import java.util.List;

/**
 * Encapsulation of a single search result for workflows.
 */
public class WorkflowSearchResult extends AtlanObject {
    private static final long serialVersionUID = 2L;
    String _index;
    String _type;
    String _id;
    Object _seq_no;
    Object _primary_term;
    List<Object> sort;
    WorkflowSearchResultDetail _source;

    /**
     * Retrieve the status of the workflow run.
     */
    public AtlanWorkflowPhase getStatus() {
        if (_source != null) {
            WorkflowSearchResultStatus status = _source.getStatus();
            if (status != null) {
                return status.getPhase();
            }
        }
        return null;
    }

    /**
     * Re-run this workflow.
     *
     * @return details of the workflow run
     * @throws AtlanException on any API communication issue
     */
    public WorkflowRunResponse rerun() throws AtlanException {
        return rerun(false);
    }

    /**
     * Re-run this workflow.
     *
     * @param client connectivity to the Atlan tenant on which to rerun the workflow
     * @return details of the workflow run
     * @throws AtlanException on any API communication issue
     */
    public WorkflowRunResponse rerun(AtlanClient client) throws AtlanException {
        return rerun(client, false);
    }

    /**
     * Re-run this workflow.
     *
     * @param idempotent if true, the workflow will only be rerun if it is not already currently running
     * @return details of the workflow run (if idempotent, will return details of the already-running workflow)
     * @throws AtlanException on any API communication issue
     */
    public WorkflowRunResponse rerun(boolean idempotent) throws AtlanException {
        return rerun(Atlan.getDefaultClient(), idempotent);
    }

    /**
     * Re-run this workflow.
     *
     * @param client connectivity to the Atlan tenant on which to rerun the workflow
     * @param idempotent if true, the workflow will only be rerun if it is not already currently running
     * @return details of the workflow run (if idempotent, will return details of the already-running workflow)
     * @throws AtlanException on any API communication issue
     */
    public WorkflowRunResponse rerun(AtlanClient client, boolean idempotent) throws AtlanException {
        if (_source != null) {
            if (idempotent) {
                String name = _source.getSpec().getWorkflowTemplateRef().get("name");
                try {
                    Thread.sleep(10000);
                    WorkflowSearchResult running = WorkflowSearchRequest.findCurrentRun(client, name);
                    if (running != null) {
                        WorkflowRunResponse response = new WorkflowRunResponse();
                        response.client = client;
                        response.metadata = running._source.getMetadata();
                        response.spec = running._source.getSpec();
                        response.status = running._source.status;
                        return response;
                    }
                } catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            return client.workflows.run(_source);
        }
        return null;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String get_index() {
        return this._index;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String get_type() {
        return this._type;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String get_id() {
        return this._id;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object get_seq_no() {
        return this._seq_no;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Object get_primary_term() {
        return this._primary_term;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<Object> getSort() {
        return this.sort;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WorkflowSearchResultDetail get_source() {
        return this._source;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof WorkflowSearchResult)) return false;
        final WorkflowSearchResult other = (WorkflowSearchResult) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$_index = this.get_index();
        final java.lang.Object other$_index = other.get_index();
        if (this$_index == null ? other$_index != null : !this$_index.equals(other$_index)) return false;
        final java.lang.Object this$_type = this.get_type();
        final java.lang.Object other$_type = other.get_type();
        if (this$_type == null ? other$_type != null : !this$_type.equals(other$_type)) return false;
        final java.lang.Object this$_id = this.get_id();
        final java.lang.Object other$_id = other.get_id();
        if (this$_id == null ? other$_id != null : !this$_id.equals(other$_id)) return false;
        final java.lang.Object this$_seq_no = this.get_seq_no();
        final java.lang.Object other$_seq_no = other.get_seq_no();
        if (this$_seq_no == null ? other$_seq_no != null : !this$_seq_no.equals(other$_seq_no)) return false;
        final java.lang.Object this$_primary_term = this.get_primary_term();
        final java.lang.Object other$_primary_term = other.get_primary_term();
        if (this$_primary_term == null ? other$_primary_term != null : !this$_primary_term.equals(other$_primary_term)) return false;
        final java.lang.Object this$sort = this.getSort();
        final java.lang.Object other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !this$sort.equals(other$sort)) return false;
        final java.lang.Object this$_source = this.get_source();
        final java.lang.Object other$_source = other.get_source();
        if (this$_source == null ? other$_source != null : !this$_source.equals(other$_source)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof WorkflowSearchResult;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $_index = this.get_index();
        result = result * PRIME + ($_index == null ? 43 : $_index.hashCode());
        final java.lang.Object $_type = this.get_type();
        result = result * PRIME + ($_type == null ? 43 : $_type.hashCode());
        final java.lang.Object $_id = this.get_id();
        result = result * PRIME + ($_id == null ? 43 : $_id.hashCode());
        final java.lang.Object $_seq_no = this.get_seq_no();
        result = result * PRIME + ($_seq_no == null ? 43 : $_seq_no.hashCode());
        final java.lang.Object $_primary_term = this.get_primary_term();
        result = result * PRIME + ($_primary_term == null ? 43 : $_primary_term.hashCode());
        final java.lang.Object $sort = this.getSort();
        result = result * PRIME + ($sort == null ? 43 : $sort.hashCode());
        final java.lang.Object $_source = this.get_source();
        result = result * PRIME + ($_source == null ? 43 : $_source.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "WorkflowSearchResult(super=" + super.toString() + ", _index=" + this.get_index() + ", _type=" + this.get_type() + ", _id=" + this.get_id() + ", _seq_no=" + this.get_seq_no() + ", _primary_term=" + this.get_primary_term() + ", sort=" + this.getSort() + ", _source=" + this.get_source() + ")";
    }
}
