// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.net;

/* Based on original code from https://github.com/stripe/stripe-java (under MIT license) */
import static java.util.Objects.requireNonNull;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import lombok.experimental.NonFinal;

/**
 * Common interface representing an HTTP response from Atlan.
 */
abstract class AbstractAtlanResponse<T> {
    /**
     * The HTTP status code of the response.
     */
    int code;
    /**
     * The HTTP headers of the response.
     */
    HttpHeaders headers;
    /**
     * The metrics of the request / response round-trip, if enabled.
     * Note: if retries are also enabled, this will contain ONLY the metrics for the final retry and no others.
     */
    @NonFinal
    RequestMetrics metrics;
    /**
     * The body of the response.
     */
    T body;

    public final int code() {
        return this.code;
    }

    public final HttpHeaders headers() {
        return this.headers;
    }

    public final T body() {
        return this.body;
    }

    /**
     * Number of times the request was retried. Used for internal tests only.
     */
    @NonFinal
    int numRetries;

    /**
     * Gets the date of the request, as returned by Atlan.
     *
     * @return the date of the request, as returned by Atlan
     */
    public Instant date() {
        Optional<String> dateStr = this.headers.firstValue("Date");
        if (!dateStr.isPresent()) {
            return null;
        }
        return ZonedDateTime.parse(dateStr.get(), DateTimeFormatter.RFC_1123_DATE_TIME).toInstant();
    }

    protected AbstractAtlanResponse(int code, HttpHeaders headers, T body) {
        requireNonNull(headers);
        requireNonNull(body);
        this.code = code;
        this.headers = headers;
        this.body = body;
    }

    /**
     * The metrics of the request / response round-trip, if enabled.
     * Note: if retries are also enabled, this will contain ONLY the metrics for the final retry and no others.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RequestMetrics metrics() {
        return this.metrics;
    }

    /**
     * The metrics of the request / response round-trip, if enabled.
     * Note: if retries are also enabled, this will contain ONLY the metrics for the final retry and no others.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    AbstractAtlanResponse<T> metrics(final RequestMetrics metrics) {
        this.metrics = metrics;
        return this;
    }

    /**
     * Number of times the request was retried. Used for internal tests only.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int numRetries() {
        return this.numRetries;
    }

    /**
     * Number of times the request was retried. Used for internal tests only.
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    AbstractAtlanResponse<T> numRetries(final int numRetries) {
        this.numRetries = numRetries;
        return this;
    }
}
