// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.net;

/* Based on original code from https://github.com/stripe/stripe-java (under MIT license) */
import com.atlan.AtlanClient;
import com.atlan.exception.ApiConnectionException;
import com.atlan.exception.AtlanException;
import com.atlan.exception.AuthenticationException;
import com.atlan.exception.ErrorCode;
import com.atlan.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.*;

/**
 * A request to Atlan's API.
 */
public final class AtlanRequest {
    /**
     * Connectivity to the Atlan tenant.
     */
    private final AtlanClient client;
    /**
     * The HTTP method for the request (GET, POST or DELETE).
     */
    private final ApiResource.RequestMethod method;
    /**
     * The URL for the request. If this is a GET or DELETE request, the URL also includes the request
     * parameters in its query string.
     */
    private final URL url;
    /**
     * The body of the request. For POST requests, this will be either a {@code application/json}
     * payload or a multi-part form upload (for files). For GET requests, this will be {@code null}.
     */
    private final HttpContent content;
    /**
     * The HTTP headers of the request ({@code Authorization}, {@code Atlan-Version}, {@code
     * Atlan-Account}, {@code Idempotency-Key}...).
     */
    private final HttpHeaders headers;
    /**
     * The body of the request (as an unmodifiable JSON string).
     */
    private final String body;
    /**
     * The special modifiers of the request.
     */
    private final RequestOptions options;
    /**
     * Unique identifier (GUID) of this request.
     */
    private final String requestId;

    /**
     * Initializes a new instance of the {@link AtlanRequest} class, used for the majority of requests.
     *
     * @param client connectivity to an Atlan tenant
     * @param method the HTTP method
     * @param url the URL of the request
     * @param body the body of the request
     * @param options the special modifiers of the request
     * @param requestId unique identifier (GUID) of a single request to Atlan
     * @throws AtlanException if the request cannot be initialized for any reason
     */
    public AtlanRequest(AtlanClient client, ApiResource.RequestMethod method, String url, String body, RequestOptions options, String requestId) throws AtlanException {
        this(client, method, url, body, options, requestId, "application/json");
    }

    /**
     * Initializes a new instance of the {@link AtlanRequest} class, used for the majority of requests.
     *
     * @param client connectivity to an Atlan tenant
     * @param method the HTTP method
     * @param url the URL of the request
     * @param body the body of the request
     * @param options the special modifiers of the request
     * @param requestId unique identifier (GUID) of a single request to Atlan
     * @param acceptType mime-type for the content accepted in the response to this query
     * @throws AtlanException if the request cannot be initialized for any reason
     */
    public AtlanRequest(AtlanClient client, ApiResource.RequestMethod method, String url, String body, RequestOptions options, String requestId, String acceptType) throws AtlanException {
        try {
            this.client = client;
            this.body = body;
            this.options = (options != null) ? options : RequestOptions.getDefault();
            this.requestId = requestId;
            this.method = method;
            this.url = new URL(url);
            this.content = (body == null || body.isEmpty()) ? null : HttpContent.buildJSONEncodedContent(body);
            this.headers = buildHeaders(true, options, acceptType);
        } catch (IOException e) {
            throw new ApiConnectionException(ErrorCode.CONNECTION_ERROR, e, client.getBaseUrl());
        }
    }

    /**
     * Initializes a new instance of the {@link AtlanRequest} class, used specifically for uploading files (images).
     *
     * @param client connectivity to an Atlan tenant
     * @param method the HTTP method
     * @param url the URL of the request
     * @param file the file to be uploaded through the request
     * @param filename name of the file the InputStream is reading
     * @param extras (optional) additional form-encoded parameters to send
     * @param options the special modifiers of the request
     * @param requestId unique identifier (GUID) of a single request to Atlan
     * @throws AtlanException if the request cannot be initialized for any reason
     */
    public AtlanRequest(AtlanClient client, ApiResource.RequestMethod method, String url, InputStream file, String filename, Map<String, String> extras, RequestOptions options, String requestId) throws AtlanException {
        try {
            this.client = client;
            this.body = null;
            this.options = (options != null) ? options : RequestOptions.getDefault();
            this.requestId = requestId;
            this.method = method;
            this.url = new URL(url);
            List<KeyValuePair<String, Object>> parameters = new ArrayList<>();
            parameters.add(new KeyValuePair<>("file", file));
            if (extras != null) {
                for (Map.Entry<String, String> entry : extras.entrySet()) {
                    parameters.add(new KeyValuePair<>(entry.getKey(), entry.getValue()));
                }
            }
            this.content = HttpContent.buildMultipartFormDataContent(parameters, filename);
            this.headers = buildHeaders(true, options, "application/json");
        } catch (IOException e) {
            throw new ApiConnectionException(ErrorCode.CONNECTION_ERROR, e, client.getBaseUrl());
        }
    }

    /**
     * Initializes a new instance of the {@link AtlanRequest} class, used specifically for exchanging form-urlencoded
     * content.
     *
     * @param client connectivity to an Atlan tenant
     * @param method the HTTP method
     * @param url the URL of the request
     * @param map of key-value pairs to be form-urlencoded
     * @param options the special modifiers of the request
     * @param requestId unique identifier (GUID) of a single request to Atlan
     * @throws AtlanException if the request cannot be initialized for any reason
     */
    public AtlanRequest(AtlanClient client, ApiResource.RequestMethod method, String url, Map<String, Object> map, RequestOptions options, String requestId) throws AtlanException {
        try {
            this.client = client;
            this.body = null;
            this.options = (options != null) ? options : RequestOptions.getDefault();
            this.requestId = requestId;
            this.method = method;
            this.url = new URL(url);
            this.content = FormEncoder.createHttpContent(map);
            this.headers = buildHeaders(false, options, "application/json");
        } catch (IOException e) {
            throw new ApiConnectionException(ErrorCode.CONNECTION_ERROR, e, client.getBaseUrl());
        }
    }

    private HttpHeaders buildHeaders(boolean checkApiToken, RequestOptions provided, String acceptType) throws AuthenticationException {
        Map<String, List<String>> headerMap = new HashMap<>();
        // Request-Id + any custom headers (do these first, so they cannot clobber auth, etc)
        headerMap.put("X-Atlan-Request-Id", List.of(requestId));
        if (client.getExtraHeaders() != null) {
            headerMap.putAll(client.getExtraHeaders());
        }
        // Note: we will NOT use the member 'options' here, as we only want these to
        // override any set against the client itself if they are actually provided.
        // (Any defaults should not clobber any extras placed on the client level.)
        if (provided != null && provided.getExtraHeaders() != null) {
            headerMap.putAll(provided.getExtraHeaders());
        }
        // Accept
        headerMap.put("Accept", List.of(acceptType));
        // Accept-Charset
        headerMap.put("Accept-Charset", List.of(ApiResource.CHARSET.name()));
        // Authorization
        String apiToken = client.getApiToken();
        if (checkApiToken) {
            if (apiToken == null) {
                throw new AuthenticationException(ErrorCode.NO_API_TOKEN);
            } else if (apiToken.isEmpty()) {
                throw new AuthenticationException(ErrorCode.EMPTY_API_TOKEN);
            } else if (StringUtils.containsWhitespace(apiToken)) {
                throw new AuthenticationException(ErrorCode.INVALID_API_TOKEN);
            }
        }
        headerMap.put("Authorization", List.of(String.format("Bearer %s", apiToken)));
        return HttpHeaders.of(headerMap);
    }

    /**
     * Connectivity to the Atlan tenant.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public AtlanClient client() {
        return this.client;
    }

    /**
     * The HTTP method for the request (GET, POST or DELETE).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ApiResource.RequestMethod method() {
        return this.method;
    }

    /**
     * The URL for the request. If this is a GET or DELETE request, the URL also includes the request
     * parameters in its query string.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public URL url() {
        return this.url;
    }

    /**
     * The body of the request. For POST requests, this will be either a {@code application/json}
     * payload or a multi-part form upload (for files). For GET requests, this will be {@code null}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HttpContent content() {
        return this.content;
    }

    /**
     * The HTTP headers of the request ({@code Authorization}, {@code Atlan-Version}, {@code
     * Atlan-Account}, {@code Idempotency-Key}...).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HttpHeaders headers() {
        return this.headers;
    }

    /**
     * The body of the request (as an unmodifiable JSON string).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String body() {
        return this.body;
    }

    /**
     * The special modifiers of the request.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RequestOptions options() {
        return this.options;
    }

    /**
     * Unique identifier (GUID) of this request.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String requestId() {
        return this.requestId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AtlanRequest)) return false;
        final AtlanRequest other = (AtlanRequest) o;
        final java.lang.Object this$client = this.client();
        final java.lang.Object other$client = other.client();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) return false;
        final java.lang.Object this$method = this.method();
        final java.lang.Object other$method = other.method();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) return false;
        final java.lang.Object this$url = this.url();
        final java.lang.Object other$url = other.url();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
        final java.lang.Object this$content = this.content();
        final java.lang.Object other$content = other.content();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) return false;
        final java.lang.Object this$headers = this.headers();
        final java.lang.Object other$headers = other.headers();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) return false;
        final java.lang.Object this$body = this.body();
        final java.lang.Object other$body = other.body();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) return false;
        final java.lang.Object this$options = this.options();
        final java.lang.Object other$options = other.options();
        if (this$options == null ? other$options != null : !this$options.equals(other$options)) return false;
        final java.lang.Object this$requestId = this.requestId();
        final java.lang.Object other$requestId = other.requestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $client = this.client();
        result = result * PRIME + ($client == null ? 43 : $client.hashCode());
        final java.lang.Object $method = this.method();
        result = result * PRIME + ($method == null ? 43 : $method.hashCode());
        final java.lang.Object $url = this.url();
        result = result * PRIME + ($url == null ? 43 : $url.hashCode());
        final java.lang.Object $content = this.content();
        result = result * PRIME + ($content == null ? 43 : $content.hashCode());
        final java.lang.Object $headers = this.headers();
        result = result * PRIME + ($headers == null ? 43 : $headers.hashCode());
        final java.lang.Object $body = this.body();
        result = result * PRIME + ($body == null ? 43 : $body.hashCode());
        final java.lang.Object $options = this.options();
        result = result * PRIME + ($options == null ? 43 : $options.hashCode());
        final java.lang.Object $requestId = this.requestId();
        result = result * PRIME + ($requestId == null ? 43 : $requestId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "AtlanRequest(client=" + this.client() + ", method=" + this.method() + ", url=" + this.url() + ", content=" + this.content() + ", headers=" + this.headers() + ", body=" + this.body() + ", options=" + this.options() + ", requestId=" + this.requestId() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected AtlanRequest(final AtlanClient client, final ApiResource.RequestMethod method, final URL url, final HttpContent content, final HttpHeaders headers, final String body, final RequestOptions options, final String requestId) {
        this.client = client;
        this.method = method;
        this.url = url;
        this.content = content;
        this.headers = headers;
        this.body = body;
        this.options = options;
        this.requestId = requestId;
    }
}
