// Generated by delombok at Wed Oct 09 00:01:44 UTC 2024
/* SPDX-License-Identifier: Apache-2.0
   Copyright 2022 Atlan Pte. Ltd. */
package com.atlan.net;

/* Based on original code from https://github.com/stripe/stripe-java (under MIT license) */
import com.atlan.Atlan;
import com.atlan.AtlanClient;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.List;
import java.util.Map;

/**
 * Class to encapsulate all the options that can be overridden on individual API calls.
 * For the moment, only {@link #getDefault()} is used (behind-the-scenes), but this would provide the foundation
 * to open up per-request variations of things like the maximum number of retries to allow.
 */
@SuppressWarnings("cast")
public class RequestOptions {
    private final int connectTimeout;
    private final int readTimeout;
    private final int maxNetworkRetries;
    private final Proxy connectionProxy;
    private final PasswordAuthentication proxyCredential;
    private final Map<String, List<String>> extraHeaders;

    /**
     * Returns a default set of request options, using the global settings of the SDK.
     *
     * @return default request options
     */
    public static RequestOptions getDefault() {
        return RequestOptions.builder().connectTimeout(Atlan.DEFAULT_CONNECT_TIMEOUT).readTimeout(Atlan.DEFAULT_READ_TIMEOUT).maxNetworkRetries(Atlan.getMaxNetworkRetries()).extraHeaders(Atlan.EXTRA_HEADERS).build();
    }

    /**
     * Returns a new set of request options, initialized from the values set in the provided client.
     *
     * @param client from which to initialize the options
     * @return a new set of request options
     */
    public static RequestOptionsBuilder from(AtlanClient client) {
        return RequestOptions.builder().connectTimeout(client.getConnectTimeout()).readTimeout(client.getReadTimeout()).maxNetworkRetries(client.getMaxNetworkRetries()).connectionProxy(client.getConnectionProxy()).proxyCredential(client.getProxyCredential()).extraHeaders(client.getExtraHeaders());
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    RequestOptions(final int connectTimeout, final int readTimeout, final int maxNetworkRetries, final Proxy connectionProxy, final PasswordAuthentication proxyCredential, final Map<String, List<String>> extraHeaders) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.maxNetworkRetries = maxNetworkRetries;
        this.connectionProxy = connectionProxy;
        this.proxyCredential = proxyCredential;
        this.extraHeaders = extraHeaders;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class RequestOptionsBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private int connectTimeout;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private int readTimeout;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private int maxNetworkRetries;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Proxy connectionProxy;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private PasswordAuthentication proxyCredential;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<String> extraHeaders$key;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private java.util.ArrayList<List<String>> extraHeaders$value;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        RequestOptionsBuilder() {
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public RequestOptions.RequestOptionsBuilder connectTimeout(final int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public RequestOptions.RequestOptionsBuilder readTimeout(final int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public RequestOptions.RequestOptionsBuilder maxNetworkRetries(final int maxNetworkRetries) {
            this.maxNetworkRetries = maxNetworkRetries;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public RequestOptions.RequestOptionsBuilder connectionProxy(final Proxy connectionProxy) {
            this.connectionProxy = connectionProxy;
            return this;
        }

        /**
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public RequestOptions.RequestOptionsBuilder proxyCredential(final PasswordAuthentication proxyCredential) {
            this.proxyCredential = proxyCredential;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public RequestOptions.RequestOptionsBuilder extraHeader(final String extraHeaderKey, final List<String> extraHeaderValue) {
            if (this.extraHeaders$key == null) {
                this.extraHeaders$key = new java.util.ArrayList<String>();
                this.extraHeaders$value = new java.util.ArrayList<List<String>>();
            }
            this.extraHeaders$key.add(extraHeaderKey);
            this.extraHeaders$value.add(extraHeaderValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public RequestOptions.RequestOptionsBuilder extraHeaders(final java.util.Map<? extends String, ? extends List<String>> extraHeaders) {
            if (extraHeaders == null) {
                throw new java.lang.NullPointerException("extraHeaders cannot be null");
            }
            if (this.extraHeaders$key == null) {
                this.extraHeaders$key = new java.util.ArrayList<String>();
                this.extraHeaders$value = new java.util.ArrayList<List<String>>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends List<String>> $lombokEntry : extraHeaders.entrySet()) {
                this.extraHeaders$key.add($lombokEntry.getKey());
                this.extraHeaders$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public RequestOptions.RequestOptionsBuilder clearExtraHeaders() {
            if (this.extraHeaders$key != null) {
                this.extraHeaders$key.clear();
                this.extraHeaders$value.clear();
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public RequestOptions build() {
            java.util.Map<String, List<String>> extraHeaders;
            switch (this.extraHeaders$key == null ? 0 : this.extraHeaders$key.size()) {
            case 0: 
                extraHeaders = java.util.Collections.emptyMap();
                break;
            case 1: 
                extraHeaders = java.util.Collections.singletonMap(this.extraHeaders$key.get(0), this.extraHeaders$value.get(0));
                break;
            default: 
                extraHeaders = new java.util.LinkedHashMap<String, List<String>>(this.extraHeaders$key.size() < 1073741824 ? 1 + this.extraHeaders$key.size() + (this.extraHeaders$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.extraHeaders$key.size(); $i++) extraHeaders.put(this.extraHeaders$key.get($i), (List<String>) this.extraHeaders$value.get($i));
                extraHeaders = java.util.Collections.unmodifiableMap(extraHeaders);
            }
            return new RequestOptions(this.connectTimeout, this.readTimeout, this.maxNetworkRetries, this.connectionProxy, this.proxyCredential, extraHeaders);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "RequestOptions.RequestOptionsBuilder(connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + ", maxNetworkRetries=" + this.maxNetworkRetries + ", connectionProxy=" + this.connectionProxy + ", proxyCredential=" + this.proxyCredential + ", extraHeaders$key=" + this.extraHeaders$key + ", extraHeaders$value=" + this.extraHeaders$value + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static RequestOptions.RequestOptionsBuilder builder() {
        return new RequestOptions.RequestOptionsBuilder();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public RequestOptions.RequestOptionsBuilder toBuilder() {
        final RequestOptions.RequestOptionsBuilder builder = new RequestOptions.RequestOptionsBuilder().connectTimeout(this.connectTimeout).readTimeout(this.readTimeout).maxNetworkRetries(this.maxNetworkRetries).connectionProxy(this.connectionProxy).proxyCredential(this.proxyCredential);
        if (this.extraHeaders != null) builder.extraHeaders(this.extraHeaders);
        return builder;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getMaxNetworkRetries() {
        return this.maxNetworkRetries;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Proxy getConnectionProxy() {
        return this.connectionProxy;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PasswordAuthentication getProxyCredential() {
        return this.proxyCredential;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, List<String>> getExtraHeaders() {
        return this.extraHeaders;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof RequestOptions)) return false;
        final RequestOptions other = (RequestOptions) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.getConnectTimeout() != other.getConnectTimeout()) return false;
        if (this.getReadTimeout() != other.getReadTimeout()) return false;
        if (this.getMaxNetworkRetries() != other.getMaxNetworkRetries()) return false;
        final java.lang.Object this$connectionProxy = this.getConnectionProxy();
        final java.lang.Object other$connectionProxy = other.getConnectionProxy();
        if (this$connectionProxy == null ? other$connectionProxy != null : !this$connectionProxy.equals(other$connectionProxy)) return false;
        final java.lang.Object this$proxyCredential = this.getProxyCredential();
        final java.lang.Object other$proxyCredential = other.getProxyCredential();
        if (this$proxyCredential == null ? other$proxyCredential != null : !this$proxyCredential.equals(other$proxyCredential)) return false;
        final java.lang.Object this$extraHeaders = this.getExtraHeaders();
        final java.lang.Object other$extraHeaders = other.getExtraHeaders();
        if (this$extraHeaders == null ? other$extraHeaders != null : !this$extraHeaders.equals(other$extraHeaders)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof RequestOptions;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.getConnectTimeout();
        result = result * PRIME + this.getReadTimeout();
        result = result * PRIME + this.getMaxNetworkRetries();
        final java.lang.Object $connectionProxy = this.getConnectionProxy();
        result = result * PRIME + ($connectionProxy == null ? 43 : $connectionProxy.hashCode());
        final java.lang.Object $proxyCredential = this.getProxyCredential();
        result = result * PRIME + ($proxyCredential == null ? 43 : $proxyCredential.hashCode());
        final java.lang.Object $extraHeaders = this.getExtraHeaders();
        result = result * PRIME + ($extraHeaders == null ? 43 : $extraHeaders.hashCode());
        return result;
    }
}
