/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import com.atlan.AtlanClient;
import com.atlan.api.HeraclesEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.AtlanGroup;
import com.atlan.model.admin.CreateGroupResponse;
import com.atlan.model.admin.GroupRequest;
import com.atlan.model.admin.GroupResponse;
import com.atlan.model.admin.UserRequest;
import com.atlan.model.admin.UserResponse;
import com.atlan.model.core.AtlanObject;
import com.atlan.net.ApiResource;
import com.atlan.net.RequestOptions;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class GroupsEndpoint
extends HeraclesEndpoint {
    private static final String endpoint = "/groups";

    public GroupsEndpoint(AtlanClient client) {
        super(client);
    }

    public GroupResponse list(GroupRequest request) throws AtlanException {
        return this.list(request, null);
    }

    public GroupResponse list(GroupRequest request, RequestOptions options) throws AtlanException {
        ArrayList<CallSite> queryParams = new ArrayList<CallSite>();
        if (request.getFilter() != null) {
            queryParams.add((CallSite)((Object)("filter=" + ApiResource.urlEncode(request.getFilter()))));
        }
        if (request.getSort() != null) {
            queryParams.add((CallSite)((Object)("sort=" + ApiResource.urlEncode(request.getSort()))));
        }
        queryParams.add((CallSite)((Object)("count=" + request.getCount())));
        queryParams.add((CallSite)((Object)("offset=" + request.getOffset())));
        queryParams.add((CallSite)((Object)("limit=" + request.getLimit())));
        String url = String.format("%s%s?%s", this.getBaseUrl(), endpoint, String.join((CharSequence)"&", queryParams));
        GroupResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", GroupResponse.class, options);
        response.setClient(this.client);
        response.setRequest(request);
        return response;
    }

    public GroupResponse list(String filter, String sort, boolean count, int offset, int limit) throws AtlanException {
        return this.list(filter, sort, count, offset, limit, null);
    }

    public GroupResponse list(String filter, String sort, boolean count, int offset, int limit, RequestOptions options) throws AtlanException {
        return this.list((GroupRequest)((GroupRequest.GroupRequestBuilder)((GroupRequest.GroupRequestBuilder)((GroupRequest.GroupRequestBuilder)((GroupRequest.GroupRequestBuilder)((GroupRequest.GroupRequestBuilder)GroupRequest.builder().filter(filter)).sort(sort)).count(count)).offset(offset)).limit(limit)).build(), options);
    }

    public GroupResponse list(String filter) throws AtlanException {
        return this.list(filter, null);
    }

    public GroupResponse list(String filter, RequestOptions options) throws AtlanException {
        return this.list((GroupRequest)((GroupRequest.GroupRequestBuilder)GroupRequest.builder().filter(filter)).build(), options);
    }

    public List<AtlanGroup> list() throws AtlanException {
        return this.list((RequestOptions)null);
    }

    public List<AtlanGroup> list(RequestOptions options) throws AtlanException {
        return this.list(20, options);
    }

    public List<AtlanGroup> list(int pageSize, RequestOptions options) throws AtlanException {
        ArrayList<AtlanGroup> groups = new ArrayList<AtlanGroup>();
        GroupResponse response = this.list((GroupRequest)((GroupRequest.GroupRequestBuilder)GroupRequest.builder().limit(pageSize)).build(), options);
        if (response != null) {
            for (AtlanGroup group : response) {
                groups.add(group);
            }
        }
        return groups;
    }

    public List<AtlanGroup> get(String alias) throws AtlanException {
        return this.get(alias, null);
    }

    public List<AtlanGroup> get(String alias, RequestOptions options) throws AtlanException {
        GroupResponse response = this.list("{\"$and\":[{\"alias\":{\"$ilike\":\"%" + alias + "%\"}}]}", options);
        if (response != null && response.getRecords() != null) {
            return response.getRecords();
        }
        return null;
    }

    public String create(AtlanGroup group) throws AtlanException {
        return this.create(group, (RequestOptions)null);
    }

    public String create(AtlanGroup group, RequestOptions options) throws AtlanException {
        CreateGroupResponse response = this.create(group, null, options);
        if (response != null) {
            return response.getGroup();
        }
        return null;
    }

    public CreateGroupResponse create(AtlanGroup group, List<String> userIds) throws AtlanException {
        return this.create(group, userIds, null);
    }

    public CreateGroupResponse create(AtlanGroup group, List<String> userIds, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), endpoint);
        Object cgr = CreateGroupRequest.builder().group(group);
        if (userIds != null && !userIds.isEmpty()) {
            cgr = ((CreateGroupRequest.CreateGroupRequestBuilder)cgr).users(userIds);
        }
        return ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, ((CreateGroupRequest.CreateGroupRequestBuilder)cgr).build(), CreateGroupResponse.class, options);
    }

    public void update(String id, AtlanGroup group) throws AtlanException {
        this.update(id, group, null);
    }

    public void update(String id, AtlanGroup group, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/%s", this.getBaseUrl(), endpoint, id);
        ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, group, options);
    }

    public UserResponse listMembers(String id, UserRequest request) throws AtlanException {
        return this.listMembers(id, request, null);
    }

    public UserResponse listMembers(String id, UserRequest request, RequestOptions options) throws AtlanException {
        ArrayList<CallSite> queryParams = new ArrayList<CallSite>();
        queryParams.add((CallSite)((Object)("offset=" + request.getOffset())));
        queryParams.add((CallSite)((Object)("limit=" + request.getLimit())));
        queryParams.add((CallSite)((Object)("sort=" + ApiResource.urlEncode(request.getSort()))));
        if (request.getFilter() != null) {
            queryParams.add((CallSite)((Object)("filter=" + ApiResource.urlEncode(request.getFilter()))));
        }
        if (request.getColumns() != null && !request.getColumns().isEmpty()) {
            queryParams.add((CallSite)((Object)("columns=" + String.join((CharSequence)",", request.getColumns()))));
        }
        String url = String.format("%s%s/%s/members?%s", this.getBaseUrl(), endpoint, id, String.join((CharSequence)"&", queryParams));
        UserResponse response = ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", UserResponse.class, options);
        response.setClient(this.client);
        response.setRequest(request);
        return response;
    }

    public UserResponse listMembers(String id) throws AtlanException {
        return this.listMembers(id, (RequestOptions)null);
    }

    public UserResponse listMembers(String id, RequestOptions options) throws AtlanException {
        return this.listMembers(id, (UserRequest)UserRequest.builder().build(), options);
    }

    public void removeMembers(String id, List<String> userIds) throws AtlanException {
        this.removeMembers(id, userIds, null);
    }

    public void removeMembers(String id, List<String> userIds, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/%s/members/remove", this.getBaseUrl(), endpoint, id);
        AtlanObject rfgr = ((RemoveFromGroupRequest.RemoveFromGroupRequestBuilder)RemoveFromGroupRequest.builder().users(userIds)).build();
        ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, rfgr, options);
    }

    public void purge(String id) throws AtlanException {
        this.purge(id, null);
    }

    public void purge(String id, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/%s/delete", this.getBaseUrl(), endpoint, id);
        ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, "", options);
    }

    static final class CreateGroupRequest
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        AtlanGroup group;
        List<String> users;

        @Generated
        protected CreateGroupRequest(CreateGroupRequestBuilder<?, ?> b) {
            super(b);
            this.group = b.group;
            this.users = b.users;
        }

        @Generated
        public static CreateGroupRequestBuilder<?, ?> builder() {
            return new CreateGroupRequestBuilderImpl();
        }

        @Generated
        public AtlanGroup getGroup() {
            return this.group;
        }

        @Generated
        public List<String> getUsers() {
            return this.users;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateGroupRequest)) {
                return false;
            }
            CreateGroupRequest other = (CreateGroupRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AtlanGroup this$group = this.getGroup();
            AtlanGroup other$group = other.getGroup();
            if (this$group == null ? other$group != null : !((Object)this$group).equals(other$group)) {
                return false;
            }
            List<String> this$users = this.getUsers();
            List<String> other$users = other.getUsers();
            return !(this$users == null ? other$users != null : !((Object)this$users).equals(other$users));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CreateGroupRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AtlanGroup $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : ((Object)$group).hashCode());
            List<String> $users = this.getUsers();
            result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
            return result;
        }

        @Generated
        public static abstract class CreateGroupRequestBuilder<C extends CreateGroupRequest, B extends CreateGroupRequestBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private AtlanGroup group;
            @Generated
            private List<String> users;

            @Generated
            public B group(AtlanGroup group) {
                this.group = group;
                return (B)this.self();
            }

            @Generated
            public B users(List<String> users) {
                this.users = users;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "GroupsEndpoint.CreateGroupRequest.CreateGroupRequestBuilder(super=" + super.toString() + ", group=" + this.group + ", users=" + this.users + ")";
            }
        }

        @Generated
        private static final class CreateGroupRequestBuilderImpl
        extends CreateGroupRequestBuilder<CreateGroupRequest, CreateGroupRequestBuilderImpl> {
            @Generated
            private CreateGroupRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected CreateGroupRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public CreateGroupRequest build() {
                return new CreateGroupRequest(this);
            }
        }
    }

    static final class RemoveFromGroupRequest
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        List<String> users;

        @Generated
        protected RemoveFromGroupRequest(RemoveFromGroupRequestBuilder<?, ?> b) {
            super(b);
            this.users = b.users;
        }

        @Generated
        public static RemoveFromGroupRequestBuilder<?, ?> builder() {
            return new RemoveFromGroupRequestBuilderImpl();
        }

        @Generated
        public List<String> getUsers() {
            return this.users;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RemoveFromGroupRequest)) {
                return false;
            }
            RemoveFromGroupRequest other = (RemoveFromGroupRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$users = this.getUsers();
            List<String> other$users = other.getUsers();
            return !(this$users == null ? other$users != null : !((Object)this$users).equals(other$users));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RemoveFromGroupRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $users = this.getUsers();
            result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
            return result;
        }

        @Generated
        public static abstract class RemoveFromGroupRequestBuilder<C extends RemoveFromGroupRequest, B extends RemoveFromGroupRequestBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private List<String> users;

            @Generated
            public B users(List<String> users) {
                this.users = users;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "GroupsEndpoint.RemoveFromGroupRequest.RemoveFromGroupRequestBuilder(super=" + super.toString() + ", users=" + this.users + ")";
            }
        }

        @Generated
        private static final class RemoveFromGroupRequestBuilderImpl
        extends RemoveFromGroupRequestBuilder<RemoveFromGroupRequest, RemoveFromGroupRequestBuilderImpl> {
            @Generated
            private RemoveFromGroupRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected RemoveFromGroupRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public RemoveFromGroupRequest build() {
                return new RemoveFromGroupRequest(this);
            }
        }
    }
}

