/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import com.atlan.AtlanClient;
import com.atlan.api.AbstractEndpoint;
import com.atlan.exception.ApiConnectionException;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.PermissionException;
import com.atlan.net.ApiResource;
import com.atlan.net.RequestOptions;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Map;
import lombok.Generated;

public class ImpersonationEndpoint
extends AbstractEndpoint {
    private static final String SERVICE = "http://keycloak-http.keycloak.svc.cluster.local";
    private static final String endpoint = "/auth/realms/default/protocol/openid-connect/token";

    public ImpersonationEndpoint(AtlanClient client) {
        super(client);
    }

    protected String getBaseUrl() throws ApiConnectionException {
        if (!this.client.isInternal()) {
            throw new ApiConnectionException(ErrorCode.INTERNAL_ONLY);
        }
        return SERVICE;
    }

    public String escalate() throws AtlanException {
        return this.escalate(null);
    }

    public String escalate(RequestOptions options) throws AtlanException {
        String tokenUrl = String.format("%s%s", this.getBaseUrl(), endpoint);
        String clientId = System.getenv("CLIENT_ID");
        String clientSecret = System.getenv("CLIENT_SECRET");
        if (clientId == null || clientId.isEmpty() || clientSecret == null || clientSecret.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_CREDENTIALS);
        }
        Map<String, Object> argoMap = Map.of("grant_type", "client_credentials", "client_id", clientId, "client_secret", clientSecret, "scope", "openid");
        try {
            AccessTokenResponse clientToken = ApiResource.request(this.client, ApiResource.RequestMethod.POST, tokenUrl, argoMap, AccessTokenResponse.class, options);
            return clientToken.getAccessToken();
        }
        catch (AtlanException e) {
            throw new PermissionException(ErrorCode.UNABLE_TO_ESCALATE, (Throwable)e);
        }
    }

    public String user(String userId) throws AtlanException {
        return this.user(userId, null);
    }

    public String user(String userId, RequestOptions options) throws AtlanException {
        String argoToken;
        String tokenUrl = String.format("%s/auth/realms/default/protocol/openid-connect/token", this.getBaseUrl());
        String clientId = System.getenv("CLIENT_ID");
        String clientSecret = System.getenv("CLIENT_SECRET");
        if (clientId == null || clientId.isEmpty() || clientSecret == null || clientSecret.isEmpty()) {
            throw new InvalidRequestException(ErrorCode.MISSING_CREDENTIALS);
        }
        Map<String, Object> argoMap = Map.of("grant_type", "client_credentials", "client_id", clientId, "client_secret", clientSecret);
        try {
            AccessTokenResponse clientToken = ApiResource.request(this.client, ApiResource.RequestMethod.POST, tokenUrl, argoMap, AccessTokenResponse.class, options);
            argoToken = clientToken.getAccessToken();
        }
        catch (AtlanException e) {
            throw new PermissionException(ErrorCode.UNABLE_TO_ESCALATE, (Throwable)e);
        }
        Map<String, Object> userMap = Map.of("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange", "client_id", clientId, "client_secret", clientSecret, "subject_token", argoToken, "requested_subject", userId);
        try {
            AccessTokenResponse userToken = ApiResource.request(this.client, ApiResource.RequestMethod.POST, tokenUrl, userMap, AccessTokenResponse.class, options);
            return userToken.getAccessToken();
        }
        catch (AtlanException e) {
            throw new PermissionException(ErrorCode.UNABLE_TO_IMPERSONATE, (Throwable)e);
        }
    }

    @JsonDeserialize(builder=AccessTokenResponseBuilder.class)
    private static final class AccessTokenResponse
    extends ApiResource {
        private static final long serialVersionUID = 2L;
        @JsonProperty(value="access_token")
        String accessToken;
        @JsonProperty(value="expires_in")
        Long expiresIn;
        @JsonProperty(value="refresh_expires_in")
        Long refreshExpiresIn;
        @JsonProperty(value="refresh_token")
        String refreshToken;
        @JsonProperty(value="token_type")
        String tokenType;
        @JsonProperty(value="not-before-policy")
        Long notBeforePolicy;
        @JsonProperty(value="session_state")
        String sessionState;
        String scope;

        @Generated
        AccessTokenResponse(String accessToken, Long expiresIn, Long refreshExpiresIn, String refreshToken, String tokenType, Long notBeforePolicy, String sessionState, String scope) {
            this.accessToken = accessToken;
            this.expiresIn = expiresIn;
            this.refreshExpiresIn = refreshExpiresIn;
            this.refreshToken = refreshToken;
            this.tokenType = tokenType;
            this.notBeforePolicy = notBeforePolicy;
            this.sessionState = sessionState;
            this.scope = scope;
        }

        @Generated
        public static AccessTokenResponseBuilder builder() {
            return new AccessTokenResponseBuilder();
        }

        @Generated
        public AccessTokenResponseBuilder toBuilder() {
            return new AccessTokenResponseBuilder().accessToken(this.accessToken).expiresIn(this.expiresIn).refreshExpiresIn(this.refreshExpiresIn).refreshToken(this.refreshToken).tokenType(this.tokenType).notBeforePolicy(this.notBeforePolicy).sessionState(this.sessionState).scope(this.scope);
        }

        @Generated
        public String getAccessToken() {
            return this.accessToken;
        }

        @Generated
        public Long getExpiresIn() {
            return this.expiresIn;
        }

        @Generated
        public Long getRefreshExpiresIn() {
            return this.refreshExpiresIn;
        }

        @Generated
        public String getRefreshToken() {
            return this.refreshToken;
        }

        @Generated
        public String getTokenType() {
            return this.tokenType;
        }

        @Generated
        public Long getNotBeforePolicy() {
            return this.notBeforePolicy;
        }

        @Generated
        public String getSessionState() {
            return this.sessionState;
        }

        @Generated
        public String getScope() {
            return this.scope;
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        public static class AccessTokenResponseBuilder {
            @Generated
            private String accessToken;
            @Generated
            private Long expiresIn;
            @Generated
            private Long refreshExpiresIn;
            @Generated
            private String refreshToken;
            @Generated
            private String tokenType;
            @Generated
            private Long notBeforePolicy;
            @Generated
            private String sessionState;
            @Generated
            private String scope;

            @Generated
            AccessTokenResponseBuilder() {
            }

            @JsonProperty(value="access_token")
            @Generated
            public AccessTokenResponseBuilder accessToken(String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            @JsonProperty(value="expires_in")
            @Generated
            public AccessTokenResponseBuilder expiresIn(Long expiresIn) {
                this.expiresIn = expiresIn;
                return this;
            }

            @JsonProperty(value="refresh_expires_in")
            @Generated
            public AccessTokenResponseBuilder refreshExpiresIn(Long refreshExpiresIn) {
                this.refreshExpiresIn = refreshExpiresIn;
                return this;
            }

            @JsonProperty(value="refresh_token")
            @Generated
            public AccessTokenResponseBuilder refreshToken(String refreshToken) {
                this.refreshToken = refreshToken;
                return this;
            }

            @JsonProperty(value="token_type")
            @Generated
            public AccessTokenResponseBuilder tokenType(String tokenType) {
                this.tokenType = tokenType;
                return this;
            }

            @JsonProperty(value="not-before-policy")
            @Generated
            public AccessTokenResponseBuilder notBeforePolicy(Long notBeforePolicy) {
                this.notBeforePolicy = notBeforePolicy;
                return this;
            }

            @JsonProperty(value="session_state")
            @Generated
            public AccessTokenResponseBuilder sessionState(String sessionState) {
                this.sessionState = sessionState;
                return this;
            }

            @Generated
            public AccessTokenResponseBuilder scope(String scope) {
                this.scope = scope;
                return this;
            }

            @Generated
            public AccessTokenResponse build() {
                return new AccessTokenResponse(this.accessToken, this.expiresIn, this.refreshExpiresIn, this.refreshToken, this.tokenType, this.notBeforePolicy, this.sessionState, this.scope);
            }

            @Generated
            public String toString() {
                return "ImpersonationEndpoint.AccessTokenResponse.AccessTokenResponseBuilder(accessToken=" + this.accessToken + ", expiresIn=" + this.expiresIn + ", refreshExpiresIn=" + this.refreshExpiresIn + ", refreshToken=" + this.refreshToken + ", tokenType=" + this.tokenType + ", notBeforePolicy=" + this.notBeforePolicy + ", sessionState=" + this.sessionState + ", scope=" + this.scope + ")";
            }
        }
    }
}

