/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import com.atlan.AtlanClient;
import com.atlan.api.AtlasEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ConflictException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.enums.AtlanTypeCategory;
import com.atlan.model.typedefs.AtlanTagDef;
import com.atlan.model.typedefs.CustomMetadataDef;
import com.atlan.model.typedefs.EntityDef;
import com.atlan.model.typedefs.EnumDef;
import com.atlan.model.typedefs.RelationshipDef;
import com.atlan.model.typedefs.StructDef;
import com.atlan.model.typedefs.TypeDef;
import com.atlan.model.typedefs.TypeDefResponse;
import com.atlan.net.ApiResource;
import com.atlan.net.RequestOptions;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;

public class TypeDefsEndpoint
extends AtlasEndpoint {
    public static final Set<String> RESERVED_SERVICE_TYPES = Set.of("atlas_core", "atlan", "aws", "azure", "gcp", "google");
    private static final String endpoint = "/types/typedefs";
    private static final String endpoint_singular = "/types/typedef";
    private static final String endpoint_by_name = "/types/typedef/name";

    public TypeDefsEndpoint(AtlanClient client) {
        super(client);
    }

    public TypeDefResponse list(AtlanTypeCategory category) throws AtlanException {
        return this.list(category, null);
    }

    public TypeDefResponse list(AtlanTypeCategory category, RequestOptions options) throws AtlanException {
        return this.list(List.of(category), options);
    }

    public TypeDefResponse list(List<AtlanTypeCategory> categories) throws AtlanException {
        return this.list(categories, null);
    }

    public TypeDefResponse list(List<AtlanTypeCategory> categories, RequestOptions options) throws AtlanException {
        StringBuilder url = new StringBuilder(String.format("%s%s", this.getBaseUrl(), String.format("%s", endpoint)));
        for (int i = 0; i < categories.size(); ++i) {
            AtlanTypeCategory category = categories.get(i);
            if (i == 0) {
                url.append("?");
            } else {
                url.append("&");
            }
            url.append(String.format("type=%s", category.getValue().toLowerCase(Locale.ROOT)));
        }
        return ApiResource.request(this.client, ApiResource.RequestMethod.GET, url.toString(), "", TypeDefResponse.class, options);
    }

    public TypeDef get(String internalName) throws AtlanException {
        return this.get(internalName, null);
    }

    public TypeDef get(String internalName, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s/%s", this.getBaseUrl(), endpoint_by_name, internalName);
        WrappedTypeDef response = ApiResource.request(this.client, ApiResource.RequestMethod.GET, url, "", WrappedTypeDef.class, options);
        TypeDef typeDef = response.getTypeDef();
        typeDef.setRawJsonObject(response.getRawJsonObject());
        return typeDef;
    }

    public synchronized TypeDefResponse create(TypeDef typeDef) throws AtlanException {
        return this.create(typeDef, null);
    }

    public synchronized TypeDefResponse create(TypeDef typeDef, RequestOptions options) throws AtlanException {
        return this.create(List.of(typeDef), options);
    }

    public synchronized TypeDefResponse create(List<TypeDef> typeDefs) throws AtlanException {
        return this.create(typeDefs, null);
    }

    public synchronized TypeDefResponse create(List<TypeDef> typeDefs, RequestOptions options) throws AtlanException {
        TypeDefResponse response = null;
        if (typeDefs != null) {
            block3: for (TypeDef typeDef : typeDefs) {
                switch (typeDef.getCategory()) {
                    case ATLAN_TAG: 
                    case CUSTOM_METADATA: 
                    case ENUM: {
                        continue block3;
                    }
                }
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_CREATE_TYPEDEF_CATEGORY, typeDef.getCategory().getValue());
            }
            response = this._create(typeDefs, options);
        }
        return response;
    }

    public synchronized TypeDefResponse _create(TypeDef typeDef) throws AtlanException {
        return this._create(typeDef, null);
    }

    public synchronized TypeDefResponse _create(TypeDef typeDef, RequestOptions options) throws AtlanException {
        return this._create(List.of(typeDef), options);
    }

    public synchronized TypeDefResponse _create(List<TypeDef> typeDefs) throws AtlanException {
        return this._create(typeDefs, null);
    }

    public synchronized TypeDefResponse _create(List<TypeDef> typeDefs, RequestOptions options) throws AtlanException {
        TypeDefResponse.TypeDefResponseBuilder builder = TypeDefResponse.builder();
        if (typeDefs != null) {
            for (TypeDef typeDef : typeDefs) {
                String serviceType = typeDef.getServiceType();
                if (serviceType != null && RESERVED_SERVICE_TYPES.contains(serviceType)) {
                    throw new ConflictException(ErrorCode.RESERVED_SERVICE_TYPE, serviceType);
                }
                switch (typeDef.getCategory()) {
                    case ATLAN_TAG: {
                        builder.atlanTagDef((AtlanTagDef)typeDef);
                        break;
                    }
                    case CUSTOM_METADATA: {
                        builder.customMetadataDef((CustomMetadataDef)typeDef);
                        break;
                    }
                    case ENUM: {
                        builder.enumDef((EnumDef)typeDef);
                        break;
                    }
                    case STRUCT: {
                        builder.structDef((StructDef)typeDef);
                        break;
                    }
                    case ENTITY: {
                        builder.entityDef((EntityDef)typeDef);
                        break;
                    }
                    case RELATIONSHIP: {
                        builder.relationshipDef((RelationshipDef)typeDef);
                    }
                }
            }
            TypeDefResponse response = this._create(builder, options);
            if (response != null) {
                if (!response.getAtlanTagDefs().isEmpty()) {
                    this.client.getAtlanTagCache().refresh();
                }
                if (!response.getCustomMetadataDefs().isEmpty()) {
                    this.client.getCustomMetadataCache().refresh();
                }
                if (!response.getEnumDefs().isEmpty()) {
                    this.client.getEnumCache().refreshCache();
                }
                return response;
            }
        }
        return builder.build();
    }

    private synchronized TypeDefResponse _create(TypeDefResponse.TypeDefResponseBuilder builder, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), endpoint);
        return ApiResource.request(this.client, ApiResource.RequestMethod.POST, url, builder.build(), TypeDefResponse.class, options);
    }

    public synchronized TypeDefResponse update(TypeDef typeDef) throws AtlanException {
        return this.update(typeDef, null);
    }

    public synchronized TypeDefResponse update(TypeDef typeDef, RequestOptions options) throws AtlanException {
        TypeDefResponse response = null;
        if (typeDef != null) {
            switch (typeDef.getCategory()) {
                case ATLAN_TAG: 
                case CUSTOM_METADATA: 
                case ENUM: {
                    response = this._update(typeDef, options);
                    break;
                }
                default: {
                    throw new InvalidRequestException(ErrorCode.UNABLE_TO_UPDATE_TYPEDEF_CATEGORY, typeDef.getCategory().getValue());
                }
            }
        }
        return response;
    }

    public synchronized TypeDefResponse _update(TypeDef typeDef) throws AtlanException {
        return this._update(typeDef, null);
    }

    public synchronized TypeDefResponse _update(TypeDef typeDef, RequestOptions options) throws AtlanException {
        TypeDefResponse.TypeDefResponseBuilder builder = TypeDefResponse.builder();
        if (typeDef != null) {
            String serviceType = typeDef.getServiceType();
            if (serviceType != null && RESERVED_SERVICE_TYPES.contains(serviceType)) {
                throw new ConflictException(ErrorCode.RESERVED_SERVICE_TYPE, serviceType);
            }
            switch (typeDef.getCategory()) {
                case ATLAN_TAG: {
                    builder.atlanTagDefs(List.of((AtlanTagDef)typeDef));
                    break;
                }
                case CUSTOM_METADATA: {
                    builder.customMetadataDefs(List.of((CustomMetadataDef)typeDef));
                    break;
                }
                case ENUM: {
                    builder.enumDefs(List.of((EnumDef)typeDef));
                    break;
                }
                case STRUCT: {
                    builder.structDefs(List.of((StructDef)typeDef));
                    break;
                }
                case ENTITY: {
                    builder.entityDefs(List.of((EntityDef)typeDef));
                    break;
                }
                case RELATIONSHIP: {
                    builder.relationshipDefs(List.of((RelationshipDef)typeDef));
                }
            }
            TypeDefResponse response = this._update(builder, options);
            if (response != null) {
                if (!response.getAtlanTagDefs().isEmpty()) {
                    this.client.getAtlanTagCache().refresh();
                }
                if (!response.getCustomMetadataDefs().isEmpty()) {
                    this.client.getCustomMetadataCache().refresh();
                }
                if (!response.getEnumDefs().isEmpty()) {
                    this.client.getEnumCache().refreshCache();
                }
            }
        }
        return builder.build();
    }

    private synchronized TypeDefResponse _update(TypeDefResponse.TypeDefResponseBuilder builder, RequestOptions options) throws AtlanException {
        String url = String.format("%s%s", this.getBaseUrl(), endpoint);
        return ApiResource.request(this.client, ApiResource.RequestMethod.PUT, url, builder.build(), TypeDefResponse.class, options);
    }

    public synchronized void purge(String internalName) throws AtlanException {
        this.purge(internalName, null);
    }

    public synchronized void purge(String internalName, RequestOptions options) throws AtlanException {
        TypeDef typeDef = this.get(internalName);
        String serviceType = typeDef.getServiceType();
        if (serviceType != null && RESERVED_SERVICE_TYPES.contains(serviceType)) {
            throw new ConflictException(ErrorCode.RESERVED_SERVICE_TYPE, serviceType);
        }
        String url = String.format("%s%s", this.getBaseUrl(), String.format("%s/name/%s", endpoint_singular, StringUtils.encodeContent(internalName)));
        ApiResource.request(this.client, ApiResource.RequestMethod.DELETE, url, "", null, options);
        switch (typeDef.getCategory()) {
            case ATLAN_TAG: {
                this.client.getAtlanTagCache().refresh();
                break;
            }
            case ENUM: {
                this.client.getEnumCache().refreshCache();
                break;
            }
            case CUSTOM_METADATA: {
                this.client.getCustomMetadataCache().refresh();
                break;
            }
        }
    }

    @JsonSerialize(using=WrappedTypeDefSerializer.class)
    @JsonDeserialize(using=WrappedTypeDefDeserializer.class)
    private static final class WrappedTypeDef
    extends ApiResource {
        private static final long serialVersionUID = 2L;
        TypeDef typeDef;

        public WrappedTypeDef(TypeDef typeDef) {
            this.typeDef = typeDef;
        }

        @Generated
        public TypeDef getTypeDef() {
            return this.typeDef;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WrappedTypeDef)) {
                return false;
            }
            WrappedTypeDef other = (WrappedTypeDef)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TypeDef this$typeDef = this.getTypeDef();
            TypeDef other$typeDef = other.getTypeDef();
            return !(this$typeDef == null ? other$typeDef != null : !((Object)this$typeDef).equals(other$typeDef));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WrappedTypeDef;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TypeDef $typeDef = this.getTypeDef();
            result = result * 59 + ($typeDef == null ? 43 : ((Object)$typeDef).hashCode());
            return result;
        }
    }

    private static class WrappedTypeDefSerializer
    extends StdSerializer<WrappedTypeDef> {
        private static final long serialVersionUID = 2L;
        private final AtlanClient client;

        public WrappedTypeDefSerializer(AtlanClient client) {
            this(WrappedTypeDef.class, client);
        }

        public WrappedTypeDefSerializer(Class<WrappedTypeDef> t, AtlanClient client) {
            super(t);
            this.client = client;
        }

        public void serialize(WrappedTypeDef wrappedTypeDef, JsonGenerator gen, SerializerProvider sp) throws IOException, JsonProcessingException {
            TypeDef typeDef = wrappedTypeDef.getTypeDef();
            this.client.writeValue(gen, typeDef);
        }
    }

    private static class WrappedTypeDefDeserializer
    extends StdDeserializer<WrappedTypeDef> {
        private static final long serialVersionUID = 2L;

        public WrappedTypeDefDeserializer() {
            this(null);
        }

        public WrappedTypeDefDeserializer(Class<?> t) {
            super(t);
        }

        public WrappedTypeDef deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            TypeDef typeDef = (TypeDef)parser.getCodec().readValue(parser, (TypeReference)new TypeReference<TypeDef>(){});
            return new WrappedTypeDef(typeDef);
        }
    }
}

