/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.core.AtlanObject;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMassCache<T extends AtlanObject> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractMassCache.class);
    private volatile Map<String, String> mapIdToName = new ConcurrentHashMap<String, String>();
    private volatile Map<String, String> mapNameToId = new ConcurrentHashMap<String, String>();
    private volatile Map<String, T> mapIdToObject = new ConcurrentHashMap<String, T>();
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    protected AtomicBoolean bulkRefresh = new AtomicBoolean(true);

    public void refresh() throws AtlanException {
        this.lock.writeLock().lock();
        try {
            this.mapIdToName.clear();
            this.mapNameToId.clear();
            this.mapIdToObject.clear();
            this.refreshCache();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void cacheById(String id) throws AtlanException {
        if (this.bulkRefresh.get()) {
            this.refresh();
        } else {
            this.lock.writeLock().lock();
            try {
                this.lookupById(id);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public void cacheByName(String name) throws AtlanException {
        if (this.bulkRefresh.get()) {
            this.refresh();
        } else {
            this.lock.writeLock().lock();
            try {
                this.lookupByName(name);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    protected abstract void refreshCache() throws AtlanException;

    protected abstract void lookupById(String var1) throws AtlanException;

    protected abstract void lookupByName(String var1) throws AtlanException;

    protected void cache(String id, String name, T object) {
        this.mapIdToName.put(id, name);
        this.mapNameToId.put(name, id);
        if (object != null) {
            this.mapIdToObject.put(id, object);
        }
    }

    protected boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.mapIdToObject.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected Set<Map.Entry<String, T>> entrySet() {
        this.lock.readLock().lock();
        try {
            Set<Map.Entry<String, T>> set = this.mapIdToObject.entrySet();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isNameKnown(String name) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.mapNameToId.containsKey(name);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isIdKnown(String id) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.mapIdToName.containsKey(id);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected String getIdFromName(String name) {
        this.lock.readLock().lock();
        try {
            String string = this.mapNameToId.get(name);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected String getNameFromId(String id) {
        this.lock.readLock().lock();
        try {
            String string = this.mapIdToName.get(id);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected T getObjectById(String id) {
        this.lock.readLock().lock();
        try {
            AtlanObject atlanObject = (AtlanObject)this.mapIdToObject.get(id);
            return (T)atlanObject;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getIdForName(String name) throws AtlanException {
        return this.getIdForName(name, true);
    }

    public String getIdForName(String name, boolean allowRefresh) throws AtlanException {
        if (name != null && !name.isEmpty()) {
            String id = this.getIdFromName(name);
            if (id == null && allowRefresh) {
                this.cacheByName(name);
                id = this.getIdFromName(name);
            }
            if (id == null) {
                throw new NotFoundException(ErrorCode.ID_NOT_FOUND_BY_NAME, name);
            }
            return id;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_NAME);
    }

    public String getNameForId(String id) throws AtlanException {
        return this.getNameForId(id, true);
    }

    public String getNameForId(String id, boolean allowRefresh) throws AtlanException {
        if (id != null && !id.isEmpty()) {
            String name = this.getNameFromId(id);
            if (name == null && allowRefresh) {
                this.cacheById(id);
                name = this.getNameFromId(id);
            }
            if (name == null) {
                throw new NotFoundException(ErrorCode.NAME_NOT_FOUND_BY_ID, id);
            }
            return name;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_ID);
    }

    public T getById(String id) throws AtlanException {
        return this.getById(id, true);
    }

    public T getById(String id, boolean allowRefresh) throws AtlanException {
        if (id != null && !id.isEmpty()) {
            T result = this.getObjectById(id);
            if (result == null && allowRefresh) {
                this.cacheById(id);
                result = this.getObjectById(id);
            }
            if (result == null) {
                throw new NotFoundException(ErrorCode.NAME_NOT_FOUND_BY_ID, id);
            }
            return result;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_ID);
    }

    public T getByName(String name) throws AtlanException {
        return this.getByName(name, true);
    }

    public T getByName(String name, boolean allowRefresh) throws AtlanException {
        if (name != null && !name.isEmpty()) {
            String id = this.getIdForName(name, allowRefresh);
            return this.getById(id, false);
        }
        throw new InvalidRequestException(ErrorCode.MISSING_NAME);
    }

    @Generated
    public AtomicBoolean getBulkRefresh() {
        return this.bulkRefresh;
    }
}

