/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.api.GroupsEndpoint;
import com.atlan.cache.AbstractMassCache;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.admin.AtlanGroup;
import com.atlan.model.admin.GroupResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupCache
extends AbstractMassCache<AtlanGroup> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GroupCache.class);
    private volatile Map<String, String> mapAliasToId = new ConcurrentHashMap<String, String>();
    private final GroupsEndpoint groupsEndpoint;

    public GroupCache(GroupsEndpoint groupsEndpoint) {
        this.groupsEndpoint = groupsEndpoint;
    }

    @Override
    protected void refreshCache() throws AtlanException {
        log.debug("Refreshing cache of groups...");
        List<AtlanGroup> groups = this.groupsEndpoint.list();
        this.mapAliasToId.clear();
        for (AtlanGroup group : groups) {
            String groupId = group.getId();
            String groupName = group.getName();
            this.cache(groupId, groupName, group);
        }
    }

    @Override
    protected void cache(String id, String name, AtlanGroup object) {
        String alias;
        super.cache(id, name, object);
        if (object != null && (alias = object.getAlias()) != null) {
            this.mapAliasToId.put(alias, id);
        }
    }

    private String getIdFromAlias(String alias) {
        this.lock.readLock().lock();
        try {
            String string = this.mapAliasToId.get(alias);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getIdForAlias(String alias) throws AtlanException {
        return this.getIdForAlias(alias, true);
    }

    public String getIdForAlias(String alias, boolean allowRefresh) throws AtlanException {
        if (alias != null && !alias.isEmpty()) {
            String groupId = this.getIdFromAlias(alias);
            if (groupId == null && allowRefresh) {
                this.cacheByAlias(alias);
                groupId = this.getIdFromAlias(alias);
            }
            if (groupId == null) {
                throw new NotFoundException(ErrorCode.GROUP_NOT_FOUND_BY_ALIAS, alias);
            }
            return groupId;
        }
        throw new InvalidRequestException(ErrorCode.MISSING_GROUP_ALIAS);
    }

    public String getNameForAlias(String alias) throws AtlanException {
        return this.getNameForAlias(alias, true);
    }

    public String getNameForAlias(String alias, boolean allowRefresh) throws AtlanException {
        String guid = this.getIdForAlias(alias, allowRefresh);
        return this.getNameForId(guid, false);
    }

    @Override
    protected void lookupByName(String name) throws AtlanException {
        GroupResponse response = this.groupsEndpoint.list("{\"name\":\"" + name + "\"}");
        this.cacheResponse(response);
    }

    @Override
    protected void lookupById(String id) throws AtlanException {
        GroupResponse response = this.groupsEndpoint.list("{\"id\":\"" + id + "\"}");
        this.cacheResponse(response);
    }

    public void cacheByAlias(String alias) throws AtlanException {
        if (this.bulkRefresh.get()) {
            this.refresh();
        } else {
            this.lock.writeLock().lock();
            try {
                this.lookupByAlias(alias);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    protected void lookupByAlias(String alias) throws AtlanException {
        GroupResponse response = this.groupsEndpoint.list("{\"alias\":\"" + alias + "\"}");
        this.cacheResponse(response);
    }

    private void cacheResponse(GroupResponse response) {
        if (response != null && response.getRecords() != null) {
            List<AtlanGroup> groups = response.getRecords();
            for (AtlanGroup group : groups) {
                String groupId = group.getId();
                this.cache(groupId, group.getName(), group);
            }
        }
    }
}

