/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.generators;

import com.atlan.generators.GeneratorConfig;
import com.atlan.generators.TypeGenerator;
import com.atlan.model.typedefs.AttributeDef;
import com.atlan.util.StringUtils;
import lombok.Generated;

public class AttributeGenerator
extends TypeGenerator {
    private TypeGenerator.MappedType type;
    private String renamed;
    private String snakeCaseRenamed;
    private boolean retyped = false;

    protected AttributeGenerator(GeneratorConfig cfg) {
        super(cfg);
    }

    public AttributeGenerator(String className, AttributeDef attributeDef, GeneratorConfig cfg) {
        super(cfg);
        this.className = className;
        this.originalName = attributeDef.getDisplayName() == null ? attributeDef.getName() : attributeDef.getDisplayName();
        this.description = this.cache.getAttributeDescription(className, this.originalName);
        this.resolveName();
        this.resolveType(attributeDef);
    }

    @Override
    protected void resolveClassName() {
    }

    protected void resolveName() {
        this.renamed = StringUtils.getLowerCamelCase(this.getOriginalName());
        this.snakeCaseRenamed = StringUtils.getLowerSnakeCase(this.getOriginalName());
    }

    protected void resolveType(AttributeDef attributeDef) {
        this.type = this.getMappedType(attributeDef.getTypeName());
    }

    public String getFullType() {
        Object fullType;
        String container = this.type.getContainer();
        if (container != null) {
            long nestingCount = container.chars().filter(c -> c == 60).count();
            fullType = container + this.type.getName() + ">".repeat((int)nestingCount);
        } else {
            fullType = this.type.getName();
        }
        return fullType;
    }

    public String getReferenceType() {
        Object refType;
        String container = this.type.getContainer();
        Object baseName = this.type.getName();
        if (this.type.getType() == TypeGenerator.MappedType.Type.ASSET) {
            baseName = "I" + (String)baseName;
        }
        if (container != null) {
            long nestingCount = container.chars().filter(c -> c == 60).count();
            refType = container + (String)baseName + ">".repeat((int)nestingCount);
        } else {
            refType = baseName;
        }
        return refType;
    }

    public String getSingular() {
        if (this.getType().getContainer() != null) {
            return this.cfg.resolveSingular(this.getOriginalName());
        }
        return null;
    }

    @Generated
    public TypeGenerator.MappedType getType() {
        return this.type;
    }

    @Generated
    public String getRenamed() {
        return this.renamed;
    }

    @Generated
    public String getSnakeCaseRenamed() {
        return this.snakeCaseRenamed;
    }

    @Generated
    public boolean getRetyped() {
        return this.retyped;
    }

    @Generated
    void setType(TypeGenerator.MappedType type) {
        this.type = type;
    }

    @Generated
    void setRenamed(String renamed) {
        this.renamed = renamed;
    }

    @Generated
    void setSnakeCaseRenamed(String snakeCaseRenamed) {
        this.snakeCaseRenamed = snakeCaseRenamed;
    }

    @Generated
    void setRetyped(boolean retyped) {
        this.retyped = retyped;
    }
}

