/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.admin;

import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.HekaFlow;
import com.atlan.model.enums.ParsingFlow;
import com.atlan.model.enums.QueryStatus;
import com.atlan.net.ApiEventStreamResource;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class QueryResponse
extends ApiEventStreamResource {
    private static final long serialVersionUID = 2L;
    String requestId;
    String errorName;
    String errorMessage;
    String errorCode;
    String queryId;
    List<List<String>> rows;
    List<ColumnDetails> columns;
    QueryDetails details;

    public QueryResponse(List<QueryResponse> events) {
        if (events != null) {
            this.rows = new ArrayList<List<String>>();
            this.columns = new ArrayList<ColumnDetails>();
            for (QueryResponse event : events) {
                if (event.getRows() != null && !event.getRows().isEmpty()) {
                    this.rows.addAll(event.getRows());
                }
                if (!this.columns.isEmpty() || event.getColumns() == null || event.getColumns().isEmpty()) continue;
                this.columns = event.getColumns();
            }
            QueryResponse lastEvent = events.get(events.size() - 1);
            this.requestId = lastEvent.getRequestId();
            this.errorName = lastEvent.getErrorName();
            this.errorMessage = lastEvent.getErrorMessage();
            this.errorCode = lastEvent.getErrorCode();
            this.queryId = lastEvent.getQueryId();
            this.details = lastEvent.getDetails();
        }
    }

    @JsonCreator
    public QueryResponse(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="errorName") String errorName, @JsonProperty(value="errorMessage") String errorMessage, @JsonProperty(value="errorCode") String errorCode, @JsonProperty(value="queryId") String queryId, @JsonProperty(value="rows") List<List<String>> rows, @JsonProperty(value="columns") List<ColumnDetails> columns, @JsonProperty(value="details") QueryDetails details) {
        this.requestId = requestId;
        this.errorName = errorName;
        this.errorMessage = errorMessage;
        this.errorCode = errorCode;
        this.queryId = queryId;
        this.rows = rows;
        this.columns = columns;
        this.details = details;
    }

    @Generated
    public String getRequestId() {
        return this.requestId;
    }

    @Generated
    public String getErrorName() {
        return this.errorName;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public String getErrorCode() {
        return this.errorCode;
    }

    @Generated
    public String getQueryId() {
        return this.queryId;
    }

    @Generated
    public List<List<String>> getRows() {
        return this.rows;
    }

    @Generated
    public List<ColumnDetails> getColumns() {
        return this.columns;
    }

    @Generated
    public QueryDetails getDetails() {
        return this.details;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryResponse)) {
            return false;
        }
        QueryResponse other = (QueryResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$errorName = this.getErrorName();
        String other$errorName = other.getErrorName();
        if (this$errorName == null ? other$errorName != null : !this$errorName.equals(other$errorName)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        String this$queryId = this.getQueryId();
        String other$queryId = other.getQueryId();
        if (this$queryId == null ? other$queryId != null : !this$queryId.equals(other$queryId)) {
            return false;
        }
        List<List<String>> this$rows = this.getRows();
        List<List<String>> other$rows = other.getRows();
        if (this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows)) {
            return false;
        }
        List<ColumnDetails> this$columns = this.getColumns();
        List<ColumnDetails> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        QueryDetails this$details = this.getDetails();
        QueryDetails other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !((Object)this$details).equals(other$details));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QueryResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $errorName = this.getErrorName();
        result = result * 59 + ($errorName == null ? 43 : $errorName.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        String $queryId = this.getQueryId();
        result = result * 59 + ($queryId == null ? 43 : $queryId.hashCode());
        List<List<String>> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        List<ColumnDetails> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        QueryDetails $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "QueryResponse(super=" + super.toString() + ", requestId=" + this.getRequestId() + ", errorName=" + this.getErrorName() + ", errorMessage=" + this.getErrorMessage() + ", errorCode=" + this.getErrorCode() + ", queryId=" + this.getQueryId() + ", rows=" + this.getRows() + ", columns=" + this.getColumns() + ", details=" + this.getDetails() + ")";
    }

    @JsonDeserialize(builder=QueryDetailsBuilderImpl.class)
    public static final class QueryDetails
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        Long totalRowsStreamed;
        QueryStatus status;
        String parsedQuery;
        String pushdownQuery;
        Long executionTime;
        String sourceQueryId;
        String resultOutputLocation;
        List<String> warnings;
        ParsingFlow parsingFlow;
        HekaFlow hekaFlow;
        String s3UploadPath;
        @JsonProperty(value="source_first_connection_time")
        Integer sourceFirstConnectionTime;
        @JsonProperty(value="source_first_connection_time_perc")
        Double sourceFirstConnectionPercentage;
        @JsonProperty(value="explain_call_time_perc")
        Double explainCallTimePercentage;
        @JsonProperty(value="init_data_source_time")
        Integer initDataSourceTime;
        @JsonProperty(value="init_data_source_time_perc")
        Double initDataSourcePercentage;
        @JsonProperty(value="authorization_time")
        Integer authorizationTime;
        @JsonProperty(value="authorization_time_perc")
        Double authorizationPercentage;
        @JsonProperty(value="rewrite_validation_time")
        Integer rewriteValidationTime;
        @JsonProperty(value="rewrite_validation_time_perc")
        Double rewriteValidationPercentage;
        @JsonProperty(value="extract_table_metadata_time")
        Integer extractTableMetadataTime;
        @JsonProperty(value="extract_table_metadata_time_perc")
        Double extractTableMetadataPercentage;
        @JsonProperty(value="execution_time")
        Integer executionTimeInternal;
        @JsonProperty(value="execution_time_perc")
        Double executionPercentage;
        @JsonProperty(value="bypass_parsing_time")
        Integer bypassQueryTime;
        @JsonProperty(value="bypass_parsing_time_perc")
        Double bypassParsingPercentage;
        @JsonProperty(value="check_insights_enabled_time")
        Integer checkInsightsEnabledTime;
        @JsonProperty(value="check_insights_enabled_time_perc")
        Double checkInsightsEnabledPercentage;
        @JsonProperty(value="initialization_time")
        Integer initializationTime;
        @JsonProperty(value="initialization_time_perc")
        Double initializationPercentage;
        @JsonProperty(value="extract_credentials_time")
        Integer extractCredentialsTime;
        @JsonProperty(value="extract_credentials_time_perc")
        Double extractCredentialsPercentage;
        @JsonProperty(value="overall_time")
        Integer overallTime;
        @JsonProperty(value="overall_time_perc")
        Double overallTimePercentage;
        @JsonProperty(value="heka_atlan_time")
        Integer hekaAtlanTime;
        @JsonProperty(value="calcite_parsing_time_perc")
        Double calciteParsingPercentage;
        @JsonProperty(value="calcite_validation_time_perc")
        Double calciteValidationPercentage;
        AssetDetails asset;
        String developerMessage;
        Long line;
        Long column;
        String object;

        @Generated
        protected QueryDetails(QueryDetailsBuilder<?, ?> b) {
            super(b);
            this.totalRowsStreamed = b.totalRowsStreamed;
            this.status = b.status;
            this.parsedQuery = b.parsedQuery;
            this.pushdownQuery = b.pushdownQuery;
            this.executionTime = b.executionTime;
            this.sourceQueryId = b.sourceQueryId;
            this.resultOutputLocation = b.resultOutputLocation;
            this.warnings = b.warnings;
            this.parsingFlow = b.parsingFlow;
            this.hekaFlow = b.hekaFlow;
            this.s3UploadPath = b.s3UploadPath;
            this.sourceFirstConnectionTime = b.sourceFirstConnectionTime;
            this.sourceFirstConnectionPercentage = b.sourceFirstConnectionPercentage;
            this.explainCallTimePercentage = b.explainCallTimePercentage;
            this.initDataSourceTime = b.initDataSourceTime;
            this.initDataSourcePercentage = b.initDataSourcePercentage;
            this.authorizationTime = b.authorizationTime;
            this.authorizationPercentage = b.authorizationPercentage;
            this.rewriteValidationTime = b.rewriteValidationTime;
            this.rewriteValidationPercentage = b.rewriteValidationPercentage;
            this.extractTableMetadataTime = b.extractTableMetadataTime;
            this.extractTableMetadataPercentage = b.extractTableMetadataPercentage;
            this.executionTimeInternal = b.executionTimeInternal;
            this.executionPercentage = b.executionPercentage;
            this.bypassQueryTime = b.bypassQueryTime;
            this.bypassParsingPercentage = b.bypassParsingPercentage;
            this.checkInsightsEnabledTime = b.checkInsightsEnabledTime;
            this.checkInsightsEnabledPercentage = b.checkInsightsEnabledPercentage;
            this.initializationTime = b.initializationTime;
            this.initializationPercentage = b.initializationPercentage;
            this.extractCredentialsTime = b.extractCredentialsTime;
            this.extractCredentialsPercentage = b.extractCredentialsPercentage;
            this.overallTime = b.overallTime;
            this.overallTimePercentage = b.overallTimePercentage;
            this.hekaAtlanTime = b.hekaAtlanTime;
            this.calciteParsingPercentage = b.calciteParsingPercentage;
            this.calciteValidationPercentage = b.calciteValidationPercentage;
            this.asset = b.asset;
            this.developerMessage = b.developerMessage;
            this.line = b.line;
            this.column = b.column;
            this.object = b.object;
        }

        @Generated
        public static QueryDetailsBuilder<?, ?> builder() {
            return new QueryDetailsBuilderImpl();
        }

        @Generated
        public QueryDetailsBuilder<?, ?> toBuilder() {
            return new QueryDetailsBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public Long getTotalRowsStreamed() {
            return this.totalRowsStreamed;
        }

        @Generated
        public QueryStatus getStatus() {
            return this.status;
        }

        @Generated
        public String getParsedQuery() {
            return this.parsedQuery;
        }

        @Generated
        public String getPushdownQuery() {
            return this.pushdownQuery;
        }

        @Generated
        public Long getExecutionTime() {
            return this.executionTime;
        }

        @Generated
        public String getSourceQueryId() {
            return this.sourceQueryId;
        }

        @Generated
        public String getResultOutputLocation() {
            return this.resultOutputLocation;
        }

        @Generated
        public List<String> getWarnings() {
            return this.warnings;
        }

        @Generated
        public ParsingFlow getParsingFlow() {
            return this.parsingFlow;
        }

        @Generated
        public HekaFlow getHekaFlow() {
            return this.hekaFlow;
        }

        @Generated
        public String getS3UploadPath() {
            return this.s3UploadPath;
        }

        @Generated
        public Integer getSourceFirstConnectionTime() {
            return this.sourceFirstConnectionTime;
        }

        @Generated
        public Double getSourceFirstConnectionPercentage() {
            return this.sourceFirstConnectionPercentage;
        }

        @Generated
        public Double getExplainCallTimePercentage() {
            return this.explainCallTimePercentage;
        }

        @Generated
        public Integer getInitDataSourceTime() {
            return this.initDataSourceTime;
        }

        @Generated
        public Double getInitDataSourcePercentage() {
            return this.initDataSourcePercentage;
        }

        @Generated
        public Integer getAuthorizationTime() {
            return this.authorizationTime;
        }

        @Generated
        public Double getAuthorizationPercentage() {
            return this.authorizationPercentage;
        }

        @Generated
        public Integer getRewriteValidationTime() {
            return this.rewriteValidationTime;
        }

        @Generated
        public Double getRewriteValidationPercentage() {
            return this.rewriteValidationPercentage;
        }

        @Generated
        public Integer getExtractTableMetadataTime() {
            return this.extractTableMetadataTime;
        }

        @Generated
        public Double getExtractTableMetadataPercentage() {
            return this.extractTableMetadataPercentage;
        }

        @Generated
        public Integer getExecutionTimeInternal() {
            return this.executionTimeInternal;
        }

        @Generated
        public Double getExecutionPercentage() {
            return this.executionPercentage;
        }

        @Generated
        public Integer getBypassQueryTime() {
            return this.bypassQueryTime;
        }

        @Generated
        public Double getBypassParsingPercentage() {
            return this.bypassParsingPercentage;
        }

        @Generated
        public Integer getCheckInsightsEnabledTime() {
            return this.checkInsightsEnabledTime;
        }

        @Generated
        public Double getCheckInsightsEnabledPercentage() {
            return this.checkInsightsEnabledPercentage;
        }

        @Generated
        public Integer getInitializationTime() {
            return this.initializationTime;
        }

        @Generated
        public Double getInitializationPercentage() {
            return this.initializationPercentage;
        }

        @Generated
        public Integer getExtractCredentialsTime() {
            return this.extractCredentialsTime;
        }

        @Generated
        public Double getExtractCredentialsPercentage() {
            return this.extractCredentialsPercentage;
        }

        @Generated
        public Integer getOverallTime() {
            return this.overallTime;
        }

        @Generated
        public Double getOverallTimePercentage() {
            return this.overallTimePercentage;
        }

        @Generated
        public Integer getHekaAtlanTime() {
            return this.hekaAtlanTime;
        }

        @Generated
        public Double getCalciteParsingPercentage() {
            return this.calciteParsingPercentage;
        }

        @Generated
        public Double getCalciteValidationPercentage() {
            return this.calciteValidationPercentage;
        }

        @Generated
        public AssetDetails getAsset() {
            return this.asset;
        }

        @Generated
        public String getDeveloperMessage() {
            return this.developerMessage;
        }

        @Generated
        public Long getLine() {
            return this.line;
        }

        @Generated
        public Long getColumn() {
            return this.column;
        }

        @Generated
        public String getObject() {
            return this.object;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryDetails)) {
                return false;
            }
            QueryDetails other = (QueryDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Long this$totalRowsStreamed = this.getTotalRowsStreamed();
            Long other$totalRowsStreamed = other.getTotalRowsStreamed();
            if (this$totalRowsStreamed == null ? other$totalRowsStreamed != null : !((Object)this$totalRowsStreamed).equals(other$totalRowsStreamed)) {
                return false;
            }
            Long this$executionTime = this.getExecutionTime();
            Long other$executionTime = other.getExecutionTime();
            if (this$executionTime == null ? other$executionTime != null : !((Object)this$executionTime).equals(other$executionTime)) {
                return false;
            }
            Integer this$sourceFirstConnectionTime = this.getSourceFirstConnectionTime();
            Integer other$sourceFirstConnectionTime = other.getSourceFirstConnectionTime();
            if (this$sourceFirstConnectionTime == null ? other$sourceFirstConnectionTime != null : !((Object)this$sourceFirstConnectionTime).equals(other$sourceFirstConnectionTime)) {
                return false;
            }
            Double this$sourceFirstConnectionPercentage = this.getSourceFirstConnectionPercentage();
            Double other$sourceFirstConnectionPercentage = other.getSourceFirstConnectionPercentage();
            if (this$sourceFirstConnectionPercentage == null ? other$sourceFirstConnectionPercentage != null : !((Object)this$sourceFirstConnectionPercentage).equals(other$sourceFirstConnectionPercentage)) {
                return false;
            }
            Double this$explainCallTimePercentage = this.getExplainCallTimePercentage();
            Double other$explainCallTimePercentage = other.getExplainCallTimePercentage();
            if (this$explainCallTimePercentage == null ? other$explainCallTimePercentage != null : !((Object)this$explainCallTimePercentage).equals(other$explainCallTimePercentage)) {
                return false;
            }
            Integer this$initDataSourceTime = this.getInitDataSourceTime();
            Integer other$initDataSourceTime = other.getInitDataSourceTime();
            if (this$initDataSourceTime == null ? other$initDataSourceTime != null : !((Object)this$initDataSourceTime).equals(other$initDataSourceTime)) {
                return false;
            }
            Double this$initDataSourcePercentage = this.getInitDataSourcePercentage();
            Double other$initDataSourcePercentage = other.getInitDataSourcePercentage();
            if (this$initDataSourcePercentage == null ? other$initDataSourcePercentage != null : !((Object)this$initDataSourcePercentage).equals(other$initDataSourcePercentage)) {
                return false;
            }
            Integer this$authorizationTime = this.getAuthorizationTime();
            Integer other$authorizationTime = other.getAuthorizationTime();
            if (this$authorizationTime == null ? other$authorizationTime != null : !((Object)this$authorizationTime).equals(other$authorizationTime)) {
                return false;
            }
            Double this$authorizationPercentage = this.getAuthorizationPercentage();
            Double other$authorizationPercentage = other.getAuthorizationPercentage();
            if (this$authorizationPercentage == null ? other$authorizationPercentage != null : !((Object)this$authorizationPercentage).equals(other$authorizationPercentage)) {
                return false;
            }
            Integer this$rewriteValidationTime = this.getRewriteValidationTime();
            Integer other$rewriteValidationTime = other.getRewriteValidationTime();
            if (this$rewriteValidationTime == null ? other$rewriteValidationTime != null : !((Object)this$rewriteValidationTime).equals(other$rewriteValidationTime)) {
                return false;
            }
            Double this$rewriteValidationPercentage = this.getRewriteValidationPercentage();
            Double other$rewriteValidationPercentage = other.getRewriteValidationPercentage();
            if (this$rewriteValidationPercentage == null ? other$rewriteValidationPercentage != null : !((Object)this$rewriteValidationPercentage).equals(other$rewriteValidationPercentage)) {
                return false;
            }
            Integer this$extractTableMetadataTime = this.getExtractTableMetadataTime();
            Integer other$extractTableMetadataTime = other.getExtractTableMetadataTime();
            if (this$extractTableMetadataTime == null ? other$extractTableMetadataTime != null : !((Object)this$extractTableMetadataTime).equals(other$extractTableMetadataTime)) {
                return false;
            }
            Double this$extractTableMetadataPercentage = this.getExtractTableMetadataPercentage();
            Double other$extractTableMetadataPercentage = other.getExtractTableMetadataPercentage();
            if (this$extractTableMetadataPercentage == null ? other$extractTableMetadataPercentage != null : !((Object)this$extractTableMetadataPercentage).equals(other$extractTableMetadataPercentage)) {
                return false;
            }
            Integer this$executionTimeInternal = this.getExecutionTimeInternal();
            Integer other$executionTimeInternal = other.getExecutionTimeInternal();
            if (this$executionTimeInternal == null ? other$executionTimeInternal != null : !((Object)this$executionTimeInternal).equals(other$executionTimeInternal)) {
                return false;
            }
            Double this$executionPercentage = this.getExecutionPercentage();
            Double other$executionPercentage = other.getExecutionPercentage();
            if (this$executionPercentage == null ? other$executionPercentage != null : !((Object)this$executionPercentage).equals(other$executionPercentage)) {
                return false;
            }
            Integer this$bypassQueryTime = this.getBypassQueryTime();
            Integer other$bypassQueryTime = other.getBypassQueryTime();
            if (this$bypassQueryTime == null ? other$bypassQueryTime != null : !((Object)this$bypassQueryTime).equals(other$bypassQueryTime)) {
                return false;
            }
            Double this$bypassParsingPercentage = this.getBypassParsingPercentage();
            Double other$bypassParsingPercentage = other.getBypassParsingPercentage();
            if (this$bypassParsingPercentage == null ? other$bypassParsingPercentage != null : !((Object)this$bypassParsingPercentage).equals(other$bypassParsingPercentage)) {
                return false;
            }
            Integer this$checkInsightsEnabledTime = this.getCheckInsightsEnabledTime();
            Integer other$checkInsightsEnabledTime = other.getCheckInsightsEnabledTime();
            if (this$checkInsightsEnabledTime == null ? other$checkInsightsEnabledTime != null : !((Object)this$checkInsightsEnabledTime).equals(other$checkInsightsEnabledTime)) {
                return false;
            }
            Double this$checkInsightsEnabledPercentage = this.getCheckInsightsEnabledPercentage();
            Double other$checkInsightsEnabledPercentage = other.getCheckInsightsEnabledPercentage();
            if (this$checkInsightsEnabledPercentage == null ? other$checkInsightsEnabledPercentage != null : !((Object)this$checkInsightsEnabledPercentage).equals(other$checkInsightsEnabledPercentage)) {
                return false;
            }
            Integer this$initializationTime = this.getInitializationTime();
            Integer other$initializationTime = other.getInitializationTime();
            if (this$initializationTime == null ? other$initializationTime != null : !((Object)this$initializationTime).equals(other$initializationTime)) {
                return false;
            }
            Double this$initializationPercentage = this.getInitializationPercentage();
            Double other$initializationPercentage = other.getInitializationPercentage();
            if (this$initializationPercentage == null ? other$initializationPercentage != null : !((Object)this$initializationPercentage).equals(other$initializationPercentage)) {
                return false;
            }
            Integer this$extractCredentialsTime = this.getExtractCredentialsTime();
            Integer other$extractCredentialsTime = other.getExtractCredentialsTime();
            if (this$extractCredentialsTime == null ? other$extractCredentialsTime != null : !((Object)this$extractCredentialsTime).equals(other$extractCredentialsTime)) {
                return false;
            }
            Double this$extractCredentialsPercentage = this.getExtractCredentialsPercentage();
            Double other$extractCredentialsPercentage = other.getExtractCredentialsPercentage();
            if (this$extractCredentialsPercentage == null ? other$extractCredentialsPercentage != null : !((Object)this$extractCredentialsPercentage).equals(other$extractCredentialsPercentage)) {
                return false;
            }
            Integer this$overallTime = this.getOverallTime();
            Integer other$overallTime = other.getOverallTime();
            if (this$overallTime == null ? other$overallTime != null : !((Object)this$overallTime).equals(other$overallTime)) {
                return false;
            }
            Double this$overallTimePercentage = this.getOverallTimePercentage();
            Double other$overallTimePercentage = other.getOverallTimePercentage();
            if (this$overallTimePercentage == null ? other$overallTimePercentage != null : !((Object)this$overallTimePercentage).equals(other$overallTimePercentage)) {
                return false;
            }
            Integer this$hekaAtlanTime = this.getHekaAtlanTime();
            Integer other$hekaAtlanTime = other.getHekaAtlanTime();
            if (this$hekaAtlanTime == null ? other$hekaAtlanTime != null : !((Object)this$hekaAtlanTime).equals(other$hekaAtlanTime)) {
                return false;
            }
            Double this$calciteParsingPercentage = this.getCalciteParsingPercentage();
            Double other$calciteParsingPercentage = other.getCalciteParsingPercentage();
            if (this$calciteParsingPercentage == null ? other$calciteParsingPercentage != null : !((Object)this$calciteParsingPercentage).equals(other$calciteParsingPercentage)) {
                return false;
            }
            Double this$calciteValidationPercentage = this.getCalciteValidationPercentage();
            Double other$calciteValidationPercentage = other.getCalciteValidationPercentage();
            if (this$calciteValidationPercentage == null ? other$calciteValidationPercentage != null : !((Object)this$calciteValidationPercentage).equals(other$calciteValidationPercentage)) {
                return false;
            }
            Long this$line = this.getLine();
            Long other$line = other.getLine();
            if (this$line == null ? other$line != null : !((Object)this$line).equals(other$line)) {
                return false;
            }
            Long this$column = this.getColumn();
            Long other$column = other.getColumn();
            if (this$column == null ? other$column != null : !((Object)this$column).equals(other$column)) {
                return false;
            }
            QueryStatus this$status = this.getStatus();
            QueryStatus other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$parsedQuery = this.getParsedQuery();
            String other$parsedQuery = other.getParsedQuery();
            if (this$parsedQuery == null ? other$parsedQuery != null : !this$parsedQuery.equals(other$parsedQuery)) {
                return false;
            }
            String this$pushdownQuery = this.getPushdownQuery();
            String other$pushdownQuery = other.getPushdownQuery();
            if (this$pushdownQuery == null ? other$pushdownQuery != null : !this$pushdownQuery.equals(other$pushdownQuery)) {
                return false;
            }
            String this$sourceQueryId = this.getSourceQueryId();
            String other$sourceQueryId = other.getSourceQueryId();
            if (this$sourceQueryId == null ? other$sourceQueryId != null : !this$sourceQueryId.equals(other$sourceQueryId)) {
                return false;
            }
            String this$resultOutputLocation = this.getResultOutputLocation();
            String other$resultOutputLocation = other.getResultOutputLocation();
            if (this$resultOutputLocation == null ? other$resultOutputLocation != null : !this$resultOutputLocation.equals(other$resultOutputLocation)) {
                return false;
            }
            List<String> this$warnings = this.getWarnings();
            List<String> other$warnings = other.getWarnings();
            if (this$warnings == null ? other$warnings != null : !((Object)this$warnings).equals(other$warnings)) {
                return false;
            }
            ParsingFlow this$parsingFlow = this.getParsingFlow();
            ParsingFlow other$parsingFlow = other.getParsingFlow();
            if (this$parsingFlow == null ? other$parsingFlow != null : !this$parsingFlow.equals(other$parsingFlow)) {
                return false;
            }
            HekaFlow this$hekaFlow = this.getHekaFlow();
            HekaFlow other$hekaFlow = other.getHekaFlow();
            if (this$hekaFlow == null ? other$hekaFlow != null : !this$hekaFlow.equals(other$hekaFlow)) {
                return false;
            }
            String this$s3UploadPath = this.getS3UploadPath();
            String other$s3UploadPath = other.getS3UploadPath();
            if (this$s3UploadPath == null ? other$s3UploadPath != null : !this$s3UploadPath.equals(other$s3UploadPath)) {
                return false;
            }
            AssetDetails this$asset = this.getAsset();
            AssetDetails other$asset = other.getAsset();
            if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
                return false;
            }
            String this$developerMessage = this.getDeveloperMessage();
            String other$developerMessage = other.getDeveloperMessage();
            if (this$developerMessage == null ? other$developerMessage != null : !this$developerMessage.equals(other$developerMessage)) {
                return false;
            }
            String this$object = this.getObject();
            String other$object = other.getObject();
            return !(this$object == null ? other$object != null : !this$object.equals(other$object));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof QueryDetails;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Long $totalRowsStreamed = this.getTotalRowsStreamed();
            result = result * 59 + ($totalRowsStreamed == null ? 43 : ((Object)$totalRowsStreamed).hashCode());
            Long $executionTime = this.getExecutionTime();
            result = result * 59 + ($executionTime == null ? 43 : ((Object)$executionTime).hashCode());
            Integer $sourceFirstConnectionTime = this.getSourceFirstConnectionTime();
            result = result * 59 + ($sourceFirstConnectionTime == null ? 43 : ((Object)$sourceFirstConnectionTime).hashCode());
            Double $sourceFirstConnectionPercentage = this.getSourceFirstConnectionPercentage();
            result = result * 59 + ($sourceFirstConnectionPercentage == null ? 43 : ((Object)$sourceFirstConnectionPercentage).hashCode());
            Double $explainCallTimePercentage = this.getExplainCallTimePercentage();
            result = result * 59 + ($explainCallTimePercentage == null ? 43 : ((Object)$explainCallTimePercentage).hashCode());
            Integer $initDataSourceTime = this.getInitDataSourceTime();
            result = result * 59 + ($initDataSourceTime == null ? 43 : ((Object)$initDataSourceTime).hashCode());
            Double $initDataSourcePercentage = this.getInitDataSourcePercentage();
            result = result * 59 + ($initDataSourcePercentage == null ? 43 : ((Object)$initDataSourcePercentage).hashCode());
            Integer $authorizationTime = this.getAuthorizationTime();
            result = result * 59 + ($authorizationTime == null ? 43 : ((Object)$authorizationTime).hashCode());
            Double $authorizationPercentage = this.getAuthorizationPercentage();
            result = result * 59 + ($authorizationPercentage == null ? 43 : ((Object)$authorizationPercentage).hashCode());
            Integer $rewriteValidationTime = this.getRewriteValidationTime();
            result = result * 59 + ($rewriteValidationTime == null ? 43 : ((Object)$rewriteValidationTime).hashCode());
            Double $rewriteValidationPercentage = this.getRewriteValidationPercentage();
            result = result * 59 + ($rewriteValidationPercentage == null ? 43 : ((Object)$rewriteValidationPercentage).hashCode());
            Integer $extractTableMetadataTime = this.getExtractTableMetadataTime();
            result = result * 59 + ($extractTableMetadataTime == null ? 43 : ((Object)$extractTableMetadataTime).hashCode());
            Double $extractTableMetadataPercentage = this.getExtractTableMetadataPercentage();
            result = result * 59 + ($extractTableMetadataPercentage == null ? 43 : ((Object)$extractTableMetadataPercentage).hashCode());
            Integer $executionTimeInternal = this.getExecutionTimeInternal();
            result = result * 59 + ($executionTimeInternal == null ? 43 : ((Object)$executionTimeInternal).hashCode());
            Double $executionPercentage = this.getExecutionPercentage();
            result = result * 59 + ($executionPercentage == null ? 43 : ((Object)$executionPercentage).hashCode());
            Integer $bypassQueryTime = this.getBypassQueryTime();
            result = result * 59 + ($bypassQueryTime == null ? 43 : ((Object)$bypassQueryTime).hashCode());
            Double $bypassParsingPercentage = this.getBypassParsingPercentage();
            result = result * 59 + ($bypassParsingPercentage == null ? 43 : ((Object)$bypassParsingPercentage).hashCode());
            Integer $checkInsightsEnabledTime = this.getCheckInsightsEnabledTime();
            result = result * 59 + ($checkInsightsEnabledTime == null ? 43 : ((Object)$checkInsightsEnabledTime).hashCode());
            Double $checkInsightsEnabledPercentage = this.getCheckInsightsEnabledPercentage();
            result = result * 59 + ($checkInsightsEnabledPercentage == null ? 43 : ((Object)$checkInsightsEnabledPercentage).hashCode());
            Integer $initializationTime = this.getInitializationTime();
            result = result * 59 + ($initializationTime == null ? 43 : ((Object)$initializationTime).hashCode());
            Double $initializationPercentage = this.getInitializationPercentage();
            result = result * 59 + ($initializationPercentage == null ? 43 : ((Object)$initializationPercentage).hashCode());
            Integer $extractCredentialsTime = this.getExtractCredentialsTime();
            result = result * 59 + ($extractCredentialsTime == null ? 43 : ((Object)$extractCredentialsTime).hashCode());
            Double $extractCredentialsPercentage = this.getExtractCredentialsPercentage();
            result = result * 59 + ($extractCredentialsPercentage == null ? 43 : ((Object)$extractCredentialsPercentage).hashCode());
            Integer $overallTime = this.getOverallTime();
            result = result * 59 + ($overallTime == null ? 43 : ((Object)$overallTime).hashCode());
            Double $overallTimePercentage = this.getOverallTimePercentage();
            result = result * 59 + ($overallTimePercentage == null ? 43 : ((Object)$overallTimePercentage).hashCode());
            Integer $hekaAtlanTime = this.getHekaAtlanTime();
            result = result * 59 + ($hekaAtlanTime == null ? 43 : ((Object)$hekaAtlanTime).hashCode());
            Double $calciteParsingPercentage = this.getCalciteParsingPercentage();
            result = result * 59 + ($calciteParsingPercentage == null ? 43 : ((Object)$calciteParsingPercentage).hashCode());
            Double $calciteValidationPercentage = this.getCalciteValidationPercentage();
            result = result * 59 + ($calciteValidationPercentage == null ? 43 : ((Object)$calciteValidationPercentage).hashCode());
            Long $line = this.getLine();
            result = result * 59 + ($line == null ? 43 : ((Object)$line).hashCode());
            Long $column = this.getColumn();
            result = result * 59 + ($column == null ? 43 : ((Object)$column).hashCode());
            QueryStatus $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $parsedQuery = this.getParsedQuery();
            result = result * 59 + ($parsedQuery == null ? 43 : $parsedQuery.hashCode());
            String $pushdownQuery = this.getPushdownQuery();
            result = result * 59 + ($pushdownQuery == null ? 43 : $pushdownQuery.hashCode());
            String $sourceQueryId = this.getSourceQueryId();
            result = result * 59 + ($sourceQueryId == null ? 43 : $sourceQueryId.hashCode());
            String $resultOutputLocation = this.getResultOutputLocation();
            result = result * 59 + ($resultOutputLocation == null ? 43 : $resultOutputLocation.hashCode());
            List<String> $warnings = this.getWarnings();
            result = result * 59 + ($warnings == null ? 43 : ((Object)$warnings).hashCode());
            ParsingFlow $parsingFlow = this.getParsingFlow();
            result = result * 59 + ($parsingFlow == null ? 43 : $parsingFlow.hashCode());
            HekaFlow $hekaFlow = this.getHekaFlow();
            result = result * 59 + ($hekaFlow == null ? 43 : $hekaFlow.hashCode());
            String $s3UploadPath = this.getS3UploadPath();
            result = result * 59 + ($s3UploadPath == null ? 43 : $s3UploadPath.hashCode());
            AssetDetails $asset = this.getAsset();
            result = result * 59 + ($asset == null ? 43 : ((Object)$asset).hashCode());
            String $developerMessage = this.getDeveloperMessage();
            result = result * 59 + ($developerMessage == null ? 43 : $developerMessage.hashCode());
            String $object = this.getObject();
            result = result * 59 + ($object == null ? 43 : $object.hashCode());
            return result;
        }

        @Override
        @Generated
        public String toString() {
            return "QueryResponse.QueryDetails(super=" + super.toString() + ", totalRowsStreamed=" + this.getTotalRowsStreamed() + ", status=" + this.getStatus() + ", parsedQuery=" + this.getParsedQuery() + ", pushdownQuery=" + this.getPushdownQuery() + ", executionTime=" + this.getExecutionTime() + ", sourceQueryId=" + this.getSourceQueryId() + ", resultOutputLocation=" + this.getResultOutputLocation() + ", warnings=" + this.getWarnings() + ", parsingFlow=" + this.getParsingFlow() + ", hekaFlow=" + this.getHekaFlow() + ", s3UploadPath=" + this.getS3UploadPath() + ", sourceFirstConnectionTime=" + this.getSourceFirstConnectionTime() + ", sourceFirstConnectionPercentage=" + this.getSourceFirstConnectionPercentage() + ", explainCallTimePercentage=" + this.getExplainCallTimePercentage() + ", initDataSourceTime=" + this.getInitDataSourceTime() + ", initDataSourcePercentage=" + this.getInitDataSourcePercentage() + ", authorizationTime=" + this.getAuthorizationTime() + ", authorizationPercentage=" + this.getAuthorizationPercentage() + ", rewriteValidationTime=" + this.getRewriteValidationTime() + ", rewriteValidationPercentage=" + this.getRewriteValidationPercentage() + ", extractTableMetadataTime=" + this.getExtractTableMetadataTime() + ", extractTableMetadataPercentage=" + this.getExtractTableMetadataPercentage() + ", executionTimeInternal=" + this.getExecutionTimeInternal() + ", executionPercentage=" + this.getExecutionPercentage() + ", bypassQueryTime=" + this.getBypassQueryTime() + ", bypassParsingPercentage=" + this.getBypassParsingPercentage() + ", checkInsightsEnabledTime=" + this.getCheckInsightsEnabledTime() + ", checkInsightsEnabledPercentage=" + this.getCheckInsightsEnabledPercentage() + ", initializationTime=" + this.getInitializationTime() + ", initializationPercentage=" + this.getInitializationPercentage() + ", extractCredentialsTime=" + this.getExtractCredentialsTime() + ", extractCredentialsPercentage=" + this.getExtractCredentialsPercentage() + ", overallTime=" + this.getOverallTime() + ", overallTimePercentage=" + this.getOverallTimePercentage() + ", hekaAtlanTime=" + this.getHekaAtlanTime() + ", calciteParsingPercentage=" + this.getCalciteParsingPercentage() + ", calciteValidationPercentage=" + this.getCalciteValidationPercentage() + ", asset=" + this.getAsset() + ", developerMessage=" + this.getDeveloperMessage() + ", line=" + this.getLine() + ", column=" + this.getColumn() + ", object=" + this.getObject() + ")";
        }

        @Generated
        public static abstract class QueryDetailsBuilder<C extends QueryDetails, B extends QueryDetailsBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private Long totalRowsStreamed;
            @Generated
            private QueryStatus status;
            @Generated
            private String parsedQuery;
            @Generated
            private String pushdownQuery;
            @Generated
            private Long executionTime;
            @Generated
            private String sourceQueryId;
            @Generated
            private String resultOutputLocation;
            @Generated
            private List<String> warnings;
            @Generated
            private ParsingFlow parsingFlow;
            @Generated
            private HekaFlow hekaFlow;
            @Generated
            private String s3UploadPath;
            @Generated
            private Integer sourceFirstConnectionTime;
            @Generated
            private Double sourceFirstConnectionPercentage;
            @Generated
            private Double explainCallTimePercentage;
            @Generated
            private Integer initDataSourceTime;
            @Generated
            private Double initDataSourcePercentage;
            @Generated
            private Integer authorizationTime;
            @Generated
            private Double authorizationPercentage;
            @Generated
            private Integer rewriteValidationTime;
            @Generated
            private Double rewriteValidationPercentage;
            @Generated
            private Integer extractTableMetadataTime;
            @Generated
            private Double extractTableMetadataPercentage;
            @Generated
            private Integer executionTimeInternal;
            @Generated
            private Double executionPercentage;
            @Generated
            private Integer bypassQueryTime;
            @Generated
            private Double bypassParsingPercentage;
            @Generated
            private Integer checkInsightsEnabledTime;
            @Generated
            private Double checkInsightsEnabledPercentage;
            @Generated
            private Integer initializationTime;
            @Generated
            private Double initializationPercentage;
            @Generated
            private Integer extractCredentialsTime;
            @Generated
            private Double extractCredentialsPercentage;
            @Generated
            private Integer overallTime;
            @Generated
            private Double overallTimePercentage;
            @Generated
            private Integer hekaAtlanTime;
            @Generated
            private Double calciteParsingPercentage;
            @Generated
            private Double calciteValidationPercentage;
            @Generated
            private AssetDetails asset;
            @Generated
            private String developerMessage;
            @Generated
            private Long line;
            @Generated
            private Long column;
            @Generated
            private String object;

            @Override
            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                QueryDetailsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(QueryDetails instance, QueryDetailsBuilder<?, ?> b) {
                b.totalRowsStreamed(instance.totalRowsStreamed);
                b.status(instance.status);
                b.parsedQuery(instance.parsedQuery);
                b.pushdownQuery(instance.pushdownQuery);
                b.executionTime(instance.executionTime);
                b.sourceQueryId(instance.sourceQueryId);
                b.resultOutputLocation(instance.resultOutputLocation);
                b.warnings(instance.warnings);
                b.parsingFlow(instance.parsingFlow);
                b.hekaFlow(instance.hekaFlow);
                b.s3UploadPath(instance.s3UploadPath);
                b.sourceFirstConnectionTime(instance.sourceFirstConnectionTime);
                b.sourceFirstConnectionPercentage(instance.sourceFirstConnectionPercentage);
                b.explainCallTimePercentage(instance.explainCallTimePercentage);
                b.initDataSourceTime(instance.initDataSourceTime);
                b.initDataSourcePercentage(instance.initDataSourcePercentage);
                b.authorizationTime(instance.authorizationTime);
                b.authorizationPercentage(instance.authorizationPercentage);
                b.rewriteValidationTime(instance.rewriteValidationTime);
                b.rewriteValidationPercentage(instance.rewriteValidationPercentage);
                b.extractTableMetadataTime(instance.extractTableMetadataTime);
                b.extractTableMetadataPercentage(instance.extractTableMetadataPercentage);
                b.executionTimeInternal(instance.executionTimeInternal);
                b.executionPercentage(instance.executionPercentage);
                b.bypassQueryTime(instance.bypassQueryTime);
                b.bypassParsingPercentage(instance.bypassParsingPercentage);
                b.checkInsightsEnabledTime(instance.checkInsightsEnabledTime);
                b.checkInsightsEnabledPercentage(instance.checkInsightsEnabledPercentage);
                b.initializationTime(instance.initializationTime);
                b.initializationPercentage(instance.initializationPercentage);
                b.extractCredentialsTime(instance.extractCredentialsTime);
                b.extractCredentialsPercentage(instance.extractCredentialsPercentage);
                b.overallTime(instance.overallTime);
                b.overallTimePercentage(instance.overallTimePercentage);
                b.hekaAtlanTime(instance.hekaAtlanTime);
                b.calciteParsingPercentage(instance.calciteParsingPercentage);
                b.calciteValidationPercentage(instance.calciteValidationPercentage);
                b.asset(instance.asset);
                b.developerMessage(instance.developerMessage);
                b.line(instance.line);
                b.column(instance.column);
                b.object(instance.object);
            }

            @Generated
            public B totalRowsStreamed(Long totalRowsStreamed) {
                this.totalRowsStreamed = totalRowsStreamed;
                return (B)this.self();
            }

            @Generated
            public B status(QueryStatus status) {
                this.status = status;
                return (B)this.self();
            }

            @Generated
            public B parsedQuery(String parsedQuery) {
                this.parsedQuery = parsedQuery;
                return (B)this.self();
            }

            @Generated
            public B pushdownQuery(String pushdownQuery) {
                this.pushdownQuery = pushdownQuery;
                return (B)this.self();
            }

            @Generated
            public B executionTime(Long executionTime) {
                this.executionTime = executionTime;
                return (B)this.self();
            }

            @Generated
            public B sourceQueryId(String sourceQueryId) {
                this.sourceQueryId = sourceQueryId;
                return (B)this.self();
            }

            @Generated
            public B resultOutputLocation(String resultOutputLocation) {
                this.resultOutputLocation = resultOutputLocation;
                return (B)this.self();
            }

            @Generated
            public B warnings(List<String> warnings) {
                this.warnings = warnings;
                return (B)this.self();
            }

            @Generated
            public B parsingFlow(ParsingFlow parsingFlow) {
                this.parsingFlow = parsingFlow;
                return (B)this.self();
            }

            @Generated
            public B hekaFlow(HekaFlow hekaFlow) {
                this.hekaFlow = hekaFlow;
                return (B)this.self();
            }

            @Generated
            public B s3UploadPath(String s3UploadPath) {
                this.s3UploadPath = s3UploadPath;
                return (B)this.self();
            }

            @JsonProperty(value="source_first_connection_time")
            @Generated
            public B sourceFirstConnectionTime(Integer sourceFirstConnectionTime) {
                this.sourceFirstConnectionTime = sourceFirstConnectionTime;
                return (B)this.self();
            }

            @JsonProperty(value="source_first_connection_time_perc")
            @Generated
            public B sourceFirstConnectionPercentage(Double sourceFirstConnectionPercentage) {
                this.sourceFirstConnectionPercentage = sourceFirstConnectionPercentage;
                return (B)this.self();
            }

            @JsonProperty(value="explain_call_time_perc")
            @Generated
            public B explainCallTimePercentage(Double explainCallTimePercentage) {
                this.explainCallTimePercentage = explainCallTimePercentage;
                return (B)this.self();
            }

            @JsonProperty(value="init_data_source_time")
            @Generated
            public B initDataSourceTime(Integer initDataSourceTime) {
                this.initDataSourceTime = initDataSourceTime;
                return (B)this.self();
            }

            @JsonProperty(value="init_data_source_time_perc")
            @Generated
            public B initDataSourcePercentage(Double initDataSourcePercentage) {
                this.initDataSourcePercentage = initDataSourcePercentage;
                return (B)this.self();
            }

            @JsonProperty(value="authorization_time")
            @Generated
            public B authorizationTime(Integer authorizationTime) {
                this.authorizationTime = authorizationTime;
                return (B)this.self();
            }

            @JsonProperty(value="authorization_time_perc")
            @Generated
            public B authorizationPercentage(Double authorizationPercentage) {
                this.authorizationPercentage = authorizationPercentage;
                return (B)this.self();
            }

            @JsonProperty(value="rewrite_validation_time")
            @Generated
            public B rewriteValidationTime(Integer rewriteValidationTime) {
                this.rewriteValidationTime = rewriteValidationTime;
                return (B)this.self();
            }

            @JsonProperty(value="rewrite_validation_time_perc")
            @Generated
            public B rewriteValidationPercentage(Double rewriteValidationPercentage) {
                this.rewriteValidationPercentage = rewriteValidationPercentage;
                return (B)this.self();
            }

            @JsonProperty(value="extract_table_metadata_time")
            @Generated
            public B extractTableMetadataTime(Integer extractTableMetadataTime) {
                this.extractTableMetadataTime = extractTableMetadataTime;
                return (B)this.self();
            }

            @JsonProperty(value="extract_table_metadata_time_perc")
            @Generated
            public B extractTableMetadataPercentage(Double extractTableMetadataPercentage) {
                this.extractTableMetadataPercentage = extractTableMetadataPercentage;
                return (B)this.self();
            }

            @JsonProperty(value="execution_time")
            @Generated
            public B executionTimeInternal(Integer executionTimeInternal) {
                this.executionTimeInternal = executionTimeInternal;
                return (B)this.self();
            }

            @JsonProperty(value="execution_time_perc")
            @Generated
            public B executionPercentage(Double executionPercentage) {
                this.executionPercentage = executionPercentage;
                return (B)this.self();
            }

            @JsonProperty(value="bypass_parsing_time")
            @Generated
            public B bypassQueryTime(Integer bypassQueryTime) {
                this.bypassQueryTime = bypassQueryTime;
                return (B)this.self();
            }

            @JsonProperty(value="bypass_parsing_time_perc")
            @Generated
            public B bypassParsingPercentage(Double bypassParsingPercentage) {
                this.bypassParsingPercentage = bypassParsingPercentage;
                return (B)this.self();
            }

            @JsonProperty(value="check_insights_enabled_time")
            @Generated
            public B checkInsightsEnabledTime(Integer checkInsightsEnabledTime) {
                this.checkInsightsEnabledTime = checkInsightsEnabledTime;
                return (B)this.self();
            }

            @JsonProperty(value="check_insights_enabled_time_perc")
            @Generated
            public B checkInsightsEnabledPercentage(Double checkInsightsEnabledPercentage) {
                this.checkInsightsEnabledPercentage = checkInsightsEnabledPercentage;
                return (B)this.self();
            }

            @JsonProperty(value="initialization_time")
            @Generated
            public B initializationTime(Integer initializationTime) {
                this.initializationTime = initializationTime;
                return (B)this.self();
            }

            @JsonProperty(value="initialization_time_perc")
            @Generated
            public B initializationPercentage(Double initializationPercentage) {
                this.initializationPercentage = initializationPercentage;
                return (B)this.self();
            }

            @JsonProperty(value="extract_credentials_time")
            @Generated
            public B extractCredentialsTime(Integer extractCredentialsTime) {
                this.extractCredentialsTime = extractCredentialsTime;
                return (B)this.self();
            }

            @JsonProperty(value="extract_credentials_time_perc")
            @Generated
            public B extractCredentialsPercentage(Double extractCredentialsPercentage) {
                this.extractCredentialsPercentage = extractCredentialsPercentage;
                return (B)this.self();
            }

            @JsonProperty(value="overall_time")
            @Generated
            public B overallTime(Integer overallTime) {
                this.overallTime = overallTime;
                return (B)this.self();
            }

            @JsonProperty(value="overall_time_perc")
            @Generated
            public B overallTimePercentage(Double overallTimePercentage) {
                this.overallTimePercentage = overallTimePercentage;
                return (B)this.self();
            }

            @JsonProperty(value="heka_atlan_time")
            @Generated
            public B hekaAtlanTime(Integer hekaAtlanTime) {
                this.hekaAtlanTime = hekaAtlanTime;
                return (B)this.self();
            }

            @JsonProperty(value="calcite_parsing_time_perc")
            @Generated
            public B calciteParsingPercentage(Double calciteParsingPercentage) {
                this.calciteParsingPercentage = calciteParsingPercentage;
                return (B)this.self();
            }

            @JsonProperty(value="calcite_validation_time_perc")
            @Generated
            public B calciteValidationPercentage(Double calciteValidationPercentage) {
                this.calciteValidationPercentage = calciteValidationPercentage;
                return (B)this.self();
            }

            @Generated
            public B asset(AssetDetails asset) {
                this.asset = asset;
                return (B)this.self();
            }

            @Generated
            public B developerMessage(String developerMessage) {
                this.developerMessage = developerMessage;
                return (B)this.self();
            }

            @Generated
            public B line(Long line) {
                this.line = line;
                return (B)this.self();
            }

            @Generated
            public B column(Long column) {
                this.column = column;
                return (B)this.self();
            }

            @Generated
            public B object(String object) {
                this.object = object;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "QueryResponse.QueryDetails.QueryDetailsBuilder(super=" + super.toString() + ", totalRowsStreamed=" + this.totalRowsStreamed + ", status=" + this.status + ", parsedQuery=" + this.parsedQuery + ", pushdownQuery=" + this.pushdownQuery + ", executionTime=" + this.executionTime + ", sourceQueryId=" + this.sourceQueryId + ", resultOutputLocation=" + this.resultOutputLocation + ", warnings=" + this.warnings + ", parsingFlow=" + this.parsingFlow + ", hekaFlow=" + this.hekaFlow + ", s3UploadPath=" + this.s3UploadPath + ", sourceFirstConnectionTime=" + this.sourceFirstConnectionTime + ", sourceFirstConnectionPercentage=" + this.sourceFirstConnectionPercentage + ", explainCallTimePercentage=" + this.explainCallTimePercentage + ", initDataSourceTime=" + this.initDataSourceTime + ", initDataSourcePercentage=" + this.initDataSourcePercentage + ", authorizationTime=" + this.authorizationTime + ", authorizationPercentage=" + this.authorizationPercentage + ", rewriteValidationTime=" + this.rewriteValidationTime + ", rewriteValidationPercentage=" + this.rewriteValidationPercentage + ", extractTableMetadataTime=" + this.extractTableMetadataTime + ", extractTableMetadataPercentage=" + this.extractTableMetadataPercentage + ", executionTimeInternal=" + this.executionTimeInternal + ", executionPercentage=" + this.executionPercentage + ", bypassQueryTime=" + this.bypassQueryTime + ", bypassParsingPercentage=" + this.bypassParsingPercentage + ", checkInsightsEnabledTime=" + this.checkInsightsEnabledTime + ", checkInsightsEnabledPercentage=" + this.checkInsightsEnabledPercentage + ", initializationTime=" + this.initializationTime + ", initializationPercentage=" + this.initializationPercentage + ", extractCredentialsTime=" + this.extractCredentialsTime + ", extractCredentialsPercentage=" + this.extractCredentialsPercentage + ", overallTime=" + this.overallTime + ", overallTimePercentage=" + this.overallTimePercentage + ", hekaAtlanTime=" + this.hekaAtlanTime + ", calciteParsingPercentage=" + this.calciteParsingPercentage + ", calciteValidationPercentage=" + this.calciteValidationPercentage + ", asset=" + this.asset + ", developerMessage=" + this.developerMessage + ", line=" + this.line + ", column=" + this.column + ", object=" + this.object + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class QueryDetailsBuilderImpl
        extends QueryDetailsBuilder<QueryDetails, QueryDetailsBuilderImpl> {
            @Generated
            private QueryDetailsBuilderImpl() {
            }

            @Override
            @Generated
            protected QueryDetailsBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public QueryDetails build() {
                return new QueryDetails(this);
            }
        }
    }

    @JsonDeserialize(builder=AssetDetailsBuilderImpl.class)
    public static final class AssetDetails
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        String connectionName;
        String connectionQN;
        String database;
        String schema;
        String table;

        @Generated
        protected AssetDetails(AssetDetailsBuilder<?, ?> b) {
            super(b);
            this.connectionName = b.connectionName;
            this.connectionQN = b.connectionQN;
            this.database = b.database;
            this.schema = b.schema;
            this.table = b.table;
        }

        @Generated
        public static AssetDetailsBuilder<?, ?> builder() {
            return new AssetDetailsBuilderImpl();
        }

        @Generated
        public AssetDetailsBuilder<?, ?> toBuilder() {
            return new AssetDetailsBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public String getConnectionName() {
            return this.connectionName;
        }

        @Generated
        public String getConnectionQN() {
            return this.connectionQN;
        }

        @Generated
        public String getDatabase() {
            return this.database;
        }

        @Generated
        public String getSchema() {
            return this.schema;
        }

        @Generated
        public String getTable() {
            return this.table;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssetDetails)) {
                return false;
            }
            AssetDetails other = (AssetDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$connectionName = this.getConnectionName();
            String other$connectionName = other.getConnectionName();
            if (this$connectionName == null ? other$connectionName != null : !this$connectionName.equals(other$connectionName)) {
                return false;
            }
            String this$connectionQN = this.getConnectionQN();
            String other$connectionQN = other.getConnectionQN();
            if (this$connectionQN == null ? other$connectionQN != null : !this$connectionQN.equals(other$connectionQN)) {
                return false;
            }
            String this$database = this.getDatabase();
            String other$database = other.getDatabase();
            if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
                return false;
            }
            String this$schema = this.getSchema();
            String other$schema = other.getSchema();
            if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
                return false;
            }
            String this$table = this.getTable();
            String other$table = other.getTable();
            return !(this$table == null ? other$table != null : !this$table.equals(other$table));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AssetDetails;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $connectionName = this.getConnectionName();
            result = result * 59 + ($connectionName == null ? 43 : $connectionName.hashCode());
            String $connectionQN = this.getConnectionQN();
            result = result * 59 + ($connectionQN == null ? 43 : $connectionQN.hashCode());
            String $database = this.getDatabase();
            result = result * 59 + ($database == null ? 43 : $database.hashCode());
            String $schema = this.getSchema();
            result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
            String $table = this.getTable();
            result = result * 59 + ($table == null ? 43 : $table.hashCode());
            return result;
        }

        @Override
        @Generated
        public String toString() {
            return "QueryResponse.AssetDetails(super=" + super.toString() + ", connectionName=" + this.getConnectionName() + ", connectionQN=" + this.getConnectionQN() + ", database=" + this.getDatabase() + ", schema=" + this.getSchema() + ", table=" + this.getTable() + ")";
        }

        @Generated
        public static abstract class AssetDetailsBuilder<C extends AssetDetails, B extends AssetDetailsBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private String connectionName;
            @Generated
            private String connectionQN;
            @Generated
            private String database;
            @Generated
            private String schema;
            @Generated
            private String table;

            @Override
            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                AssetDetailsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(AssetDetails instance, AssetDetailsBuilder<?, ?> b) {
                b.connectionName(instance.connectionName);
                b.connectionQN(instance.connectionQN);
                b.database(instance.database);
                b.schema(instance.schema);
                b.table(instance.table);
            }

            @Generated
            public B connectionName(String connectionName) {
                this.connectionName = connectionName;
                return (B)this.self();
            }

            @Generated
            public B connectionQN(String connectionQN) {
                this.connectionQN = connectionQN;
                return (B)this.self();
            }

            @Generated
            public B database(String database) {
                this.database = database;
                return (B)this.self();
            }

            @Generated
            public B schema(String schema) {
                this.schema = schema;
                return (B)this.self();
            }

            @Generated
            public B table(String table) {
                this.table = table;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "QueryResponse.AssetDetails.AssetDetailsBuilder(super=" + super.toString() + ", connectionName=" + this.connectionName + ", connectionQN=" + this.connectionQN + ", database=" + this.database + ", schema=" + this.schema + ", table=" + this.table + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class AssetDetailsBuilderImpl
        extends AssetDetailsBuilder<AssetDetails, AssetDetailsBuilderImpl> {
            @Generated
            private AssetDetailsBuilderImpl() {
            }

            @Override
            @Generated
            protected AssetDetailsBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public AssetDetails build() {
                return new AssetDetails(this);
            }
        }
    }

    @JsonDeserialize(builder=ColumnTypeBuilderImpl.class)
    public static final class ColumnType
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        Integer id;
        String name;
        String rep;

        @Generated
        protected ColumnType(ColumnTypeBuilder<?, ?> b) {
            super(b);
            this.id = b.id;
            this.name = b.name;
            this.rep = b.rep;
        }

        @Generated
        public static ColumnTypeBuilder<?, ?> builder() {
            return new ColumnTypeBuilderImpl();
        }

        @Generated
        public ColumnTypeBuilder<?, ?> toBuilder() {
            return new ColumnTypeBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public Integer getId() {
            return this.id;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getRep() {
            return this.rep;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColumnType)) {
                return false;
            }
            ColumnType other = (ColumnType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$id = this.getId();
            Integer other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$rep = this.getRep();
            String other$rep = other.getRep();
            return !(this$rep == null ? other$rep != null : !this$rep.equals(other$rep));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ColumnType;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $rep = this.getRep();
            result = result * 59 + ($rep == null ? 43 : $rep.hashCode());
            return result;
        }

        @Override
        @Generated
        public String toString() {
            return "QueryResponse.ColumnType(super=" + super.toString() + ", id=" + this.getId() + ", name=" + this.getName() + ", rep=" + this.getRep() + ")";
        }

        @Generated
        public static abstract class ColumnTypeBuilder<C extends ColumnType, B extends ColumnTypeBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private Integer id;
            @Generated
            private String name;
            @Generated
            private String rep;

            @Override
            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                ColumnTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(ColumnType instance, ColumnTypeBuilder<?, ?> b) {
                b.id(instance.id);
                b.name(instance.name);
                b.rep(instance.rep);
            }

            @Generated
            public B id(Integer id) {
                this.id = id;
                return (B)this.self();
            }

            @Generated
            public B name(String name) {
                this.name = name;
                return (B)this.self();
            }

            @Generated
            public B rep(String rep) {
                this.rep = rep;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "QueryResponse.ColumnType.ColumnTypeBuilder(super=" + super.toString() + ", id=" + this.id + ", name=" + this.name + ", rep=" + this.rep + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class ColumnTypeBuilderImpl
        extends ColumnTypeBuilder<ColumnType, ColumnTypeBuilderImpl> {
            @Generated
            private ColumnTypeBuilderImpl() {
            }

            @Override
            @Generated
            protected ColumnTypeBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public ColumnType build() {
                return new ColumnType(this);
            }
        }
    }

    @JsonDeserialize(builder=ColumnDetailsBuilderImpl.class)
    public static final class ColumnDetails
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        Integer ordinal;
        Boolean autoIncrement;
        Boolean caseSensitive;
        Boolean searchable;
        Boolean currency;
        Integer nullable;
        Boolean signed;
        Integer displaySize;
        String label;
        String columnName;
        String schemaName;
        Integer precision;
        Integer scale;
        String tableName;
        String catalogName;
        Boolean readOnly;
        Boolean writable;
        Boolean definitelyWritable;
        String columnClassName;
        ColumnType type;

        @Generated
        protected ColumnDetails(ColumnDetailsBuilder<?, ?> b) {
            super(b);
            this.ordinal = b.ordinal;
            this.autoIncrement = b.autoIncrement;
            this.caseSensitive = b.caseSensitive;
            this.searchable = b.searchable;
            this.currency = b.currency;
            this.nullable = b.nullable;
            this.signed = b.signed;
            this.displaySize = b.displaySize;
            this.label = b.label;
            this.columnName = b.columnName;
            this.schemaName = b.schemaName;
            this.precision = b.precision;
            this.scale = b.scale;
            this.tableName = b.tableName;
            this.catalogName = b.catalogName;
            this.readOnly = b.readOnly;
            this.writable = b.writable;
            this.definitelyWritable = b.definitelyWritable;
            this.columnClassName = b.columnClassName;
            this.type = b.type;
        }

        @Generated
        public static ColumnDetailsBuilder<?, ?> builder() {
            return new ColumnDetailsBuilderImpl();
        }

        @Generated
        public ColumnDetailsBuilder<?, ?> toBuilder() {
            return new ColumnDetailsBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public Integer getOrdinal() {
            return this.ordinal;
        }

        @Generated
        public Boolean getAutoIncrement() {
            return this.autoIncrement;
        }

        @Generated
        public Boolean getCaseSensitive() {
            return this.caseSensitive;
        }

        @Generated
        public Boolean getSearchable() {
            return this.searchable;
        }

        @Generated
        public Boolean getCurrency() {
            return this.currency;
        }

        @Generated
        public Integer getNullable() {
            return this.nullable;
        }

        @Generated
        public Boolean getSigned() {
            return this.signed;
        }

        @Generated
        public Integer getDisplaySize() {
            return this.displaySize;
        }

        @Generated
        public String getLabel() {
            return this.label;
        }

        @Generated
        public String getColumnName() {
            return this.columnName;
        }

        @Generated
        public String getSchemaName() {
            return this.schemaName;
        }

        @Generated
        public Integer getPrecision() {
            return this.precision;
        }

        @Generated
        public Integer getScale() {
            return this.scale;
        }

        @Generated
        public String getTableName() {
            return this.tableName;
        }

        @Generated
        public String getCatalogName() {
            return this.catalogName;
        }

        @Generated
        public Boolean getReadOnly() {
            return this.readOnly;
        }

        @Generated
        public Boolean getWritable() {
            return this.writable;
        }

        @Generated
        public Boolean getDefinitelyWritable() {
            return this.definitelyWritable;
        }

        @Generated
        public String getColumnClassName() {
            return this.columnClassName;
        }

        @Generated
        public ColumnType getType() {
            return this.type;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColumnDetails)) {
                return false;
            }
            ColumnDetails other = (ColumnDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$ordinal = this.getOrdinal();
            Integer other$ordinal = other.getOrdinal();
            if (this$ordinal == null ? other$ordinal != null : !((Object)this$ordinal).equals(other$ordinal)) {
                return false;
            }
            Boolean this$autoIncrement = this.getAutoIncrement();
            Boolean other$autoIncrement = other.getAutoIncrement();
            if (this$autoIncrement == null ? other$autoIncrement != null : !((Object)this$autoIncrement).equals(other$autoIncrement)) {
                return false;
            }
            Boolean this$caseSensitive = this.getCaseSensitive();
            Boolean other$caseSensitive = other.getCaseSensitive();
            if (this$caseSensitive == null ? other$caseSensitive != null : !((Object)this$caseSensitive).equals(other$caseSensitive)) {
                return false;
            }
            Boolean this$searchable = this.getSearchable();
            Boolean other$searchable = other.getSearchable();
            if (this$searchable == null ? other$searchable != null : !((Object)this$searchable).equals(other$searchable)) {
                return false;
            }
            Boolean this$currency = this.getCurrency();
            Boolean other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !((Object)this$currency).equals(other$currency)) {
                return false;
            }
            Integer this$nullable = this.getNullable();
            Integer other$nullable = other.getNullable();
            if (this$nullable == null ? other$nullable != null : !((Object)this$nullable).equals(other$nullable)) {
                return false;
            }
            Boolean this$signed = this.getSigned();
            Boolean other$signed = other.getSigned();
            if (this$signed == null ? other$signed != null : !((Object)this$signed).equals(other$signed)) {
                return false;
            }
            Integer this$displaySize = this.getDisplaySize();
            Integer other$displaySize = other.getDisplaySize();
            if (this$displaySize == null ? other$displaySize != null : !((Object)this$displaySize).equals(other$displaySize)) {
                return false;
            }
            Integer this$precision = this.getPrecision();
            Integer other$precision = other.getPrecision();
            if (this$precision == null ? other$precision != null : !((Object)this$precision).equals(other$precision)) {
                return false;
            }
            Integer this$scale = this.getScale();
            Integer other$scale = other.getScale();
            if (this$scale == null ? other$scale != null : !((Object)this$scale).equals(other$scale)) {
                return false;
            }
            Boolean this$readOnly = this.getReadOnly();
            Boolean other$readOnly = other.getReadOnly();
            if (this$readOnly == null ? other$readOnly != null : !((Object)this$readOnly).equals(other$readOnly)) {
                return false;
            }
            Boolean this$writable = this.getWritable();
            Boolean other$writable = other.getWritable();
            if (this$writable == null ? other$writable != null : !((Object)this$writable).equals(other$writable)) {
                return false;
            }
            Boolean this$definitelyWritable = this.getDefinitelyWritable();
            Boolean other$definitelyWritable = other.getDefinitelyWritable();
            if (this$definitelyWritable == null ? other$definitelyWritable != null : !((Object)this$definitelyWritable).equals(other$definitelyWritable)) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            String this$columnName = this.getColumnName();
            String other$columnName = other.getColumnName();
            if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
                return false;
            }
            String this$schemaName = this.getSchemaName();
            String other$schemaName = other.getSchemaName();
            if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
                return false;
            }
            String this$tableName = this.getTableName();
            String other$tableName = other.getTableName();
            if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
                return false;
            }
            String this$catalogName = this.getCatalogName();
            String other$catalogName = other.getCatalogName();
            if (this$catalogName == null ? other$catalogName != null : !this$catalogName.equals(other$catalogName)) {
                return false;
            }
            String this$columnClassName = this.getColumnClassName();
            String other$columnClassName = other.getColumnClassName();
            if (this$columnClassName == null ? other$columnClassName != null : !this$columnClassName.equals(other$columnClassName)) {
                return false;
            }
            ColumnType this$type = this.getType();
            ColumnType other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)this$type).equals(other$type));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ColumnDetails;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $ordinal = this.getOrdinal();
            result = result * 59 + ($ordinal == null ? 43 : ((Object)$ordinal).hashCode());
            Boolean $autoIncrement = this.getAutoIncrement();
            result = result * 59 + ($autoIncrement == null ? 43 : ((Object)$autoIncrement).hashCode());
            Boolean $caseSensitive = this.getCaseSensitive();
            result = result * 59 + ($caseSensitive == null ? 43 : ((Object)$caseSensitive).hashCode());
            Boolean $searchable = this.getSearchable();
            result = result * 59 + ($searchable == null ? 43 : ((Object)$searchable).hashCode());
            Boolean $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : ((Object)$currency).hashCode());
            Integer $nullable = this.getNullable();
            result = result * 59 + ($nullable == null ? 43 : ((Object)$nullable).hashCode());
            Boolean $signed = this.getSigned();
            result = result * 59 + ($signed == null ? 43 : ((Object)$signed).hashCode());
            Integer $displaySize = this.getDisplaySize();
            result = result * 59 + ($displaySize == null ? 43 : ((Object)$displaySize).hashCode());
            Integer $precision = this.getPrecision();
            result = result * 59 + ($precision == null ? 43 : ((Object)$precision).hashCode());
            Integer $scale = this.getScale();
            result = result * 59 + ($scale == null ? 43 : ((Object)$scale).hashCode());
            Boolean $readOnly = this.getReadOnly();
            result = result * 59 + ($readOnly == null ? 43 : ((Object)$readOnly).hashCode());
            Boolean $writable = this.getWritable();
            result = result * 59 + ($writable == null ? 43 : ((Object)$writable).hashCode());
            Boolean $definitelyWritable = this.getDefinitelyWritable();
            result = result * 59 + ($definitelyWritable == null ? 43 : ((Object)$definitelyWritable).hashCode());
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            String $columnName = this.getColumnName();
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            String $schemaName = this.getSchemaName();
            result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
            String $tableName = this.getTableName();
            result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
            String $catalogName = this.getCatalogName();
            result = result * 59 + ($catalogName == null ? 43 : $catalogName.hashCode());
            String $columnClassName = this.getColumnClassName();
            result = result * 59 + ($columnClassName == null ? 43 : $columnClassName.hashCode());
            ColumnType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
            return result;
        }

        @Override
        @Generated
        public String toString() {
            return "QueryResponse.ColumnDetails(super=" + super.toString() + ", ordinal=" + this.getOrdinal() + ", autoIncrement=" + this.getAutoIncrement() + ", caseSensitive=" + this.getCaseSensitive() + ", searchable=" + this.getSearchable() + ", currency=" + this.getCurrency() + ", nullable=" + this.getNullable() + ", signed=" + this.getSigned() + ", displaySize=" + this.getDisplaySize() + ", label=" + this.getLabel() + ", columnName=" + this.getColumnName() + ", schemaName=" + this.getSchemaName() + ", precision=" + this.getPrecision() + ", scale=" + this.getScale() + ", tableName=" + this.getTableName() + ", catalogName=" + this.getCatalogName() + ", readOnly=" + this.getReadOnly() + ", writable=" + this.getWritable() + ", definitelyWritable=" + this.getDefinitelyWritable() + ", columnClassName=" + this.getColumnClassName() + ", type=" + this.getType() + ")";
        }

        @Generated
        public static abstract class ColumnDetailsBuilder<C extends ColumnDetails, B extends ColumnDetailsBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private Integer ordinal;
            @Generated
            private Boolean autoIncrement;
            @Generated
            private Boolean caseSensitive;
            @Generated
            private Boolean searchable;
            @Generated
            private Boolean currency;
            @Generated
            private Integer nullable;
            @Generated
            private Boolean signed;
            @Generated
            private Integer displaySize;
            @Generated
            private String label;
            @Generated
            private String columnName;
            @Generated
            private String schemaName;
            @Generated
            private Integer precision;
            @Generated
            private Integer scale;
            @Generated
            private String tableName;
            @Generated
            private String catalogName;
            @Generated
            private Boolean readOnly;
            @Generated
            private Boolean writable;
            @Generated
            private Boolean definitelyWritable;
            @Generated
            private String columnClassName;
            @Generated
            private ColumnType type;

            @Override
            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                ColumnDetailsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(ColumnDetails instance, ColumnDetailsBuilder<?, ?> b) {
                b.ordinal(instance.ordinal);
                b.autoIncrement(instance.autoIncrement);
                b.caseSensitive(instance.caseSensitive);
                b.searchable(instance.searchable);
                b.currency(instance.currency);
                b.nullable(instance.nullable);
                b.signed(instance.signed);
                b.displaySize(instance.displaySize);
                b.label(instance.label);
                b.columnName(instance.columnName);
                b.schemaName(instance.schemaName);
                b.precision(instance.precision);
                b.scale(instance.scale);
                b.tableName(instance.tableName);
                b.catalogName(instance.catalogName);
                b.readOnly(instance.readOnly);
                b.writable(instance.writable);
                b.definitelyWritable(instance.definitelyWritable);
                b.columnClassName(instance.columnClassName);
                b.type(instance.type);
            }

            @Generated
            public B ordinal(Integer ordinal) {
                this.ordinal = ordinal;
                return (B)this.self();
            }

            @Generated
            public B autoIncrement(Boolean autoIncrement) {
                this.autoIncrement = autoIncrement;
                return (B)this.self();
            }

            @Generated
            public B caseSensitive(Boolean caseSensitive) {
                this.caseSensitive = caseSensitive;
                return (B)this.self();
            }

            @Generated
            public B searchable(Boolean searchable) {
                this.searchable = searchable;
                return (B)this.self();
            }

            @Generated
            public B currency(Boolean currency) {
                this.currency = currency;
                return (B)this.self();
            }

            @Generated
            public B nullable(Integer nullable) {
                this.nullable = nullable;
                return (B)this.self();
            }

            @Generated
            public B signed(Boolean signed) {
                this.signed = signed;
                return (B)this.self();
            }

            @Generated
            public B displaySize(Integer displaySize) {
                this.displaySize = displaySize;
                return (B)this.self();
            }

            @Generated
            public B label(String label) {
                this.label = label;
                return (B)this.self();
            }

            @Generated
            public B columnName(String columnName) {
                this.columnName = columnName;
                return (B)this.self();
            }

            @Generated
            public B schemaName(String schemaName) {
                this.schemaName = schemaName;
                return (B)this.self();
            }

            @Generated
            public B precision(Integer precision) {
                this.precision = precision;
                return (B)this.self();
            }

            @Generated
            public B scale(Integer scale) {
                this.scale = scale;
                return (B)this.self();
            }

            @Generated
            public B tableName(String tableName) {
                this.tableName = tableName;
                return (B)this.self();
            }

            @Generated
            public B catalogName(String catalogName) {
                this.catalogName = catalogName;
                return (B)this.self();
            }

            @Generated
            public B readOnly(Boolean readOnly) {
                this.readOnly = readOnly;
                return (B)this.self();
            }

            @Generated
            public B writable(Boolean writable) {
                this.writable = writable;
                return (B)this.self();
            }

            @Generated
            public B definitelyWritable(Boolean definitelyWritable) {
                this.definitelyWritable = definitelyWritable;
                return (B)this.self();
            }

            @Generated
            public B columnClassName(String columnClassName) {
                this.columnClassName = columnClassName;
                return (B)this.self();
            }

            @Generated
            public B type(ColumnType type) {
                this.type = type;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "QueryResponse.ColumnDetails.ColumnDetailsBuilder(super=" + super.toString() + ", ordinal=" + this.ordinal + ", autoIncrement=" + this.autoIncrement + ", caseSensitive=" + this.caseSensitive + ", searchable=" + this.searchable + ", currency=" + this.currency + ", nullable=" + this.nullable + ", signed=" + this.signed + ", displaySize=" + this.displaySize + ", label=" + this.label + ", columnName=" + this.columnName + ", schemaName=" + this.schemaName + ", precision=" + this.precision + ", scale=" + this.scale + ", tableName=" + this.tableName + ", catalogName=" + this.catalogName + ", readOnly=" + this.readOnly + ", writable=" + this.writable + ", definitelyWritable=" + this.definitelyWritable + ", columnClassName=" + this.columnClassName + ", type=" + this.type + ")";
            }
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class ColumnDetailsBuilderImpl
        extends ColumnDetailsBuilder<ColumnDetails, ColumnDetailsBuilderImpl> {
            @Generated
            private ColumnDetailsBuilderImpl() {
            }

            @Override
            @Generated
            protected ColumnDetailsBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public ColumnDetails build() {
                return new ColumnDetails(this);
            }
        }
    }
}

