/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.CubeHierarchy;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.ICubeField;
import com.atlan.model.assets.ICubeHierarchy;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IMultiDimensionalDataset;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeField
extends Asset
implements ICubeField,
IMultiDimensionalDataset,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CubeField.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "CubeField";
    String typeName;
    @Attribute
    String cubeDimensionName;
    @Attribute
    String cubeDimensionQualifiedName;
    @Attribute
    Long cubeFieldGeneration;
    @Attribute
    Long cubeFieldLevel;
    @Attribute
    String cubeFieldMeasureExpression;
    @Attribute
    ICubeHierarchy cubeHierarchy;
    @Attribute
    String cubeHierarchyName;
    @Attribute
    String cubeHierarchyQualifiedName;
    @Attribute
    String cubeName;
    @Attribute
    SortedSet<ICubeField> cubeNestedFields;
    @Attribute
    ICubeField cubeParentField;
    @Attribute
    String cubeParentFieldName;
    @Attribute
    String cubeParentFieldQualifiedName;
    @Attribute
    String cubeQualifiedName;
    @Attribute
    Long cubeSubFieldCount;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public CubeField trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return CubeField.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return CubeField.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return CubeField.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return CubeField.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return CubeField.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return CubeField.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static CubeField refByGuid(String guid) {
        return CubeField.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static CubeField refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((CubeFieldBuilder)((CubeFieldBuilder)CubeField._internal().guid(guid)).semantic(semantic)).build();
    }

    public static CubeField refByQualifiedName(String qualifiedName) {
        return CubeField.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static CubeField refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((CubeFieldBuilder)((CubeFieldBuilder)CubeField._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static CubeField get(String id) throws AtlanException {
        return CubeField.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static CubeField get(AtlanClient client, String id) throws AtlanException {
        return CubeField.get(client, id, true);
    }

    @JsonIgnore
    public static CubeField get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof CubeField) {
                return (CubeField)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof CubeField) {
            return (CubeField)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return CubeField.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static CubeFieldBuilder<?, ?> creator(String name, CubeHierarchy hierarchy) throws InvalidRequestException {
        CubeField.validateRelationship("CubeHierarchy", Map.of("connectionQualifiedName", hierarchy.getConnectionQualifiedName(), "cubeName", hierarchy.getCubeName(), "cubeQualifiedName", hierarchy.getCubeQualifiedName(), "cubeDimensionName", hierarchy.getCubeDimensionName(), "cubeDimensionQualifiedName", hierarchy.getCubeDimensionQualifiedName(), "name", hierarchy.getName(), "qualifiedName", hierarchy.getQualifiedName()));
        return CubeField.creator(name, hierarchy.getConnectionQualifiedName(), hierarchy.getCubeName(), hierarchy.getCubeQualifiedName(), hierarchy.getCubeDimensionName(), hierarchy.getCubeDimensionQualifiedName(), hierarchy.getName(), hierarchy.getQualifiedName(), null, null).cubeHierarchy(hierarchy.trimToReference());
    }

    public static CubeFieldBuilder<?, ?> creator(String name, CubeField parentField) throws InvalidRequestException {
        CubeField.validateRelationship(TYPE_NAME, Map.of("connectionQualifiedName", parentField.getConnectionQualifiedName(), "cubeName", parentField.getCubeName(), "cubeQualifiedName", parentField.getCubeQualifiedName(), "cubeDimensionName", parentField.getCubeDimensionName(), "cubeDimensionQualifiedName", parentField.getCubeDimensionQualifiedName(), "cubeHierarchyName", parentField.getCubeHierarchyName(), "cubeHierarchyQualifiedName", parentField.getCubeHierarchyQualifiedName(), "name", parentField.getName(), "qualifiedName", parentField.getQualifiedName()));
        return CubeField.creator(name, parentField.getConnectionQualifiedName(), parentField.getCubeName(), parentField.getCubeQualifiedName(), parentField.getCubeDimensionName(), parentField.getCubeDimensionQualifiedName(), parentField.getCubeHierarchyName(), parentField.getCubeHierarchyQualifiedName(), parentField.getName(), parentField.getQualifiedName()).cubeParentField(parentField.trimToReference());
    }

    public static CubeFieldBuilder<?, ?> creator(String name, String parentQualifiedName) {
        String parentFieldName = null;
        String parentFieldQualifiedName = null;
        String hierarchyQualifiedName = CubeField.getHierarchyQualifiedName(parentQualifiedName);
        if (!hierarchyQualifiedName.equals(parentQualifiedName)) {
            parentFieldQualifiedName = parentQualifiedName;
            String parentSlug = StringUtils.getNameFromQualifiedName(parentQualifiedName);
            parentFieldName = IMultiDimensionalDataset.getNameFromSlug(parentSlug);
        }
        String hierarchySlug = StringUtils.getNameFromQualifiedName(hierarchyQualifiedName);
        String hierarchyName = IMultiDimensionalDataset.getNameFromSlug(hierarchySlug);
        String dimensionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(hierarchyQualifiedName);
        String dimensionSlug = StringUtils.getNameFromQualifiedName(dimensionQualifiedName);
        String dimensionName = IMultiDimensionalDataset.getNameFromSlug(dimensionSlug);
        String cubeQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(dimensionQualifiedName);
        String cubeSlug = StringUtils.getNameFromQualifiedName(cubeQualifiedName);
        String cubeName = IMultiDimensionalDataset.getNameFromSlug(cubeSlug);
        String connectionQualifiedName = StringUtils.getConnectionQualifiedName(cubeQualifiedName);
        return CubeField.creator(name, connectionQualifiedName, cubeName, cubeQualifiedName, dimensionName, dimensionQualifiedName, hierarchyName, hierarchyQualifiedName, parentFieldName, parentFieldQualifiedName);
    }

    public static CubeFieldBuilder<?, ?> creator(String name, String connectionQualifiedName, String cubeName, String cubeQualifiedName, String dimensionName, String dimensionQualifiedName, String hierarchyName, String hierarchyQualifiedName, String parentFieldName, String parentFieldQualifiedName) {
        CubeFieldBuilder builder = (CubeFieldBuilder)CubeField._internal().name(name);
        if (parentFieldName != null && parentFieldQualifiedName != null) {
            ((Asset.AssetBuilder)((CubeFieldBuilder)((CubeFieldBuilder)builder.cubeParentField(CubeField.refByQualifiedName(parentFieldQualifiedName))).cubeParentFieldName(parentFieldName)).cubeParentFieldQualifiedName(parentFieldQualifiedName)).qualifiedName(CubeField.generateQualifiedName(name, parentFieldQualifiedName));
        } else {
            builder.qualifiedName(CubeField.generateQualifiedName(name, hierarchyQualifiedName));
        }
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(connectionQualifiedName);
        return (CubeFieldBuilder)((CubeFieldBuilder)((Asset.AssetBuilder)((CubeFieldBuilder)((CubeFieldBuilder)((CubeFieldBuilder)((CubeFieldBuilder)((CubeFieldBuilder)((CubeFieldBuilder)((CubeFieldBuilder)builder.guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).cubeName(cubeName)).cubeQualifiedName(cubeQualifiedName)).cubeDimensionName(dimensionName)).cubeDimensionQualifiedName(dimensionQualifiedName)).cubeHierarchyName(hierarchyName)).cubeHierarchyQualifiedName(hierarchyQualifiedName)).cubeHierarchy(CubeHierarchy.refByQualifiedName(hierarchyQualifiedName))).connectorType(connectorType)).connectionQualifiedName(connectionQualifiedName);
    }

    public static CubeFieldBuilder<?, ?> updater(String qualifiedName, String name) {
        return (CubeFieldBuilder)((CubeFieldBuilder)((CubeFieldBuilder)CubeField._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public static String getHierarchyQualifiedName(String parentQualifiedName) {
        if (parentQualifiedName != null) {
            List tokens = Arrays.stream(parentQualifiedName.split("/")).collect(Collectors.toList());
            return String.join((CharSequence)"/", tokens.subList(0, 6));
        }
        return null;
    }

    public static String generateQualifiedName(String name, String parentQualifiedName) {
        return parentQualifiedName + "/" + IMultiDimensionalDataset.getSlugForName(name);
    }

    public CubeFieldBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        CubeField.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return CubeField.updater(this.getQualifiedName(), this.getName());
    }

    public static CubeField removeDescription(String qualifiedName, String name) throws AtlanException {
        return CubeField.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static CubeField removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CubeField)Asset.removeDescription(client, CubeField.updater(qualifiedName, name));
    }

    public static CubeField removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return CubeField.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static CubeField removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CubeField)Asset.removeUserDescription(client, CubeField.updater(qualifiedName, name));
    }

    public static CubeField removeOwners(String qualifiedName, String name) throws AtlanException {
        return CubeField.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static CubeField removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CubeField)Asset.removeOwners(client, CubeField.updater(qualifiedName, name));
    }

    public static CubeField updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return CubeField.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static CubeField updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (CubeField)Asset.updateCertificate(client, CubeField._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static CubeField removeCertificate(String qualifiedName, String name) throws AtlanException {
        return CubeField.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static CubeField removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CubeField)Asset.removeCertificate(client, CubeField.updater(qualifiedName, name));
    }

    public static CubeField updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return CubeField.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static CubeField updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (CubeField)Asset.updateAnnouncement(client, CubeField._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static CubeField removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return CubeField.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static CubeField removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (CubeField)Asset.removeAnnouncement(client, CubeField.updater(qualifiedName, name));
    }

    public static CubeField replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return CubeField.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static CubeField replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (CubeField)Asset.replaceTerms(client, CubeField.updater(qualifiedName, name), terms);
    }

    public static CubeField appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return CubeField.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static CubeField appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CubeField)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static CubeField removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return CubeField.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static CubeField removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (CubeField)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static CubeField appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return CubeField.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static CubeField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (CubeField)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static CubeField appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return CubeField.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static CubeField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (CubeField)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        CubeField.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected CubeField(CubeFieldBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : CubeField.$default$typeName();
        this.cubeDimensionName = b.cubeDimensionName;
        this.cubeDimensionQualifiedName = b.cubeDimensionQualifiedName;
        this.cubeFieldGeneration = b.cubeFieldGeneration;
        this.cubeFieldLevel = b.cubeFieldLevel;
        this.cubeFieldMeasureExpression = b.cubeFieldMeasureExpression;
        this.cubeHierarchy = b.cubeHierarchy;
        this.cubeHierarchyName = b.cubeHierarchyName;
        this.cubeHierarchyQualifiedName = b.cubeHierarchyQualifiedName;
        this.cubeName = b.cubeName;
        SortedSet<ICubeField> cubeNestedFields = new TreeSet<ICubeField>();
        if (b.cubeNestedFields != null) {
            cubeNestedFields.addAll(b.cubeNestedFields);
        }
        cubeNestedFields = Collections.unmodifiableSortedSet(cubeNestedFields);
        this.cubeNestedFields = cubeNestedFields;
        this.cubeParentField = b.cubeParentField;
        this.cubeParentFieldName = b.cubeParentFieldName;
        this.cubeParentFieldQualifiedName = b.cubeParentFieldQualifiedName;
        this.cubeQualifiedName = b.cubeQualifiedName;
        this.cubeSubFieldCount = b.cubeSubFieldCount;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static CubeFieldBuilder<?, ?> _internal() {
        return new CubeFieldBuilderImpl();
    }

    @Generated
    public CubeFieldBuilder<?, ?> toBuilder() {
        return new CubeFieldBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getCubeDimensionName() {
        return this.cubeDimensionName;
    }

    @Override
    @Generated
    public String getCubeDimensionQualifiedName() {
        return this.cubeDimensionQualifiedName;
    }

    @Override
    @Generated
    public Long getCubeFieldGeneration() {
        return this.cubeFieldGeneration;
    }

    @Override
    @Generated
    public Long getCubeFieldLevel() {
        return this.cubeFieldLevel;
    }

    @Override
    @Generated
    public String getCubeFieldMeasureExpression() {
        return this.cubeFieldMeasureExpression;
    }

    @Override
    @Generated
    public ICubeHierarchy getCubeHierarchy() {
        return this.cubeHierarchy;
    }

    @Override
    @Generated
    public String getCubeHierarchyName() {
        return this.cubeHierarchyName;
    }

    @Override
    @Generated
    public String getCubeHierarchyQualifiedName() {
        return this.cubeHierarchyQualifiedName;
    }

    @Override
    @Generated
    public String getCubeName() {
        return this.cubeName;
    }

    @Override
    @Generated
    public SortedSet<ICubeField> getCubeNestedFields() {
        return this.cubeNestedFields;
    }

    @Override
    @Generated
    public ICubeField getCubeParentField() {
        return this.cubeParentField;
    }

    @Override
    @Generated
    public String getCubeParentFieldName() {
        return this.cubeParentFieldName;
    }

    @Override
    @Generated
    public String getCubeParentFieldQualifiedName() {
        return this.cubeParentFieldQualifiedName;
    }

    @Override
    @Generated
    public String getCubeQualifiedName() {
        return this.cubeQualifiedName;
    }

    @Override
    @Generated
    public Long getCubeSubFieldCount() {
        return this.cubeSubFieldCount;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CubeField)) {
            return false;
        }
        CubeField other = (CubeField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$cubeFieldGeneration = this.getCubeFieldGeneration();
        Long other$cubeFieldGeneration = other.getCubeFieldGeneration();
        if (this$cubeFieldGeneration == null ? other$cubeFieldGeneration != null : !((Object)this$cubeFieldGeneration).equals(other$cubeFieldGeneration)) {
            return false;
        }
        Long this$cubeFieldLevel = this.getCubeFieldLevel();
        Long other$cubeFieldLevel = other.getCubeFieldLevel();
        if (this$cubeFieldLevel == null ? other$cubeFieldLevel != null : !((Object)this$cubeFieldLevel).equals(other$cubeFieldLevel)) {
            return false;
        }
        Long this$cubeSubFieldCount = this.getCubeSubFieldCount();
        Long other$cubeSubFieldCount = other.getCubeSubFieldCount();
        if (this$cubeSubFieldCount == null ? other$cubeSubFieldCount != null : !((Object)this$cubeSubFieldCount).equals(other$cubeSubFieldCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$cubeDimensionName = this.getCubeDimensionName();
        String other$cubeDimensionName = other.getCubeDimensionName();
        if (this$cubeDimensionName == null ? other$cubeDimensionName != null : !this$cubeDimensionName.equals(other$cubeDimensionName)) {
            return false;
        }
        String this$cubeDimensionQualifiedName = this.getCubeDimensionQualifiedName();
        String other$cubeDimensionQualifiedName = other.getCubeDimensionQualifiedName();
        if (this$cubeDimensionQualifiedName == null ? other$cubeDimensionQualifiedName != null : !this$cubeDimensionQualifiedName.equals(other$cubeDimensionQualifiedName)) {
            return false;
        }
        String this$cubeFieldMeasureExpression = this.getCubeFieldMeasureExpression();
        String other$cubeFieldMeasureExpression = other.getCubeFieldMeasureExpression();
        if (this$cubeFieldMeasureExpression == null ? other$cubeFieldMeasureExpression != null : !this$cubeFieldMeasureExpression.equals(other$cubeFieldMeasureExpression)) {
            return false;
        }
        ICubeHierarchy this$cubeHierarchy = this.getCubeHierarchy();
        ICubeHierarchy other$cubeHierarchy = other.getCubeHierarchy();
        if (this$cubeHierarchy == null ? other$cubeHierarchy != null : !this$cubeHierarchy.equals(other$cubeHierarchy)) {
            return false;
        }
        String this$cubeHierarchyName = this.getCubeHierarchyName();
        String other$cubeHierarchyName = other.getCubeHierarchyName();
        if (this$cubeHierarchyName == null ? other$cubeHierarchyName != null : !this$cubeHierarchyName.equals(other$cubeHierarchyName)) {
            return false;
        }
        String this$cubeHierarchyQualifiedName = this.getCubeHierarchyQualifiedName();
        String other$cubeHierarchyQualifiedName = other.getCubeHierarchyQualifiedName();
        if (this$cubeHierarchyQualifiedName == null ? other$cubeHierarchyQualifiedName != null : !this$cubeHierarchyQualifiedName.equals(other$cubeHierarchyQualifiedName)) {
            return false;
        }
        String this$cubeName = this.getCubeName();
        String other$cubeName = other.getCubeName();
        if (this$cubeName == null ? other$cubeName != null : !this$cubeName.equals(other$cubeName)) {
            return false;
        }
        SortedSet<ICubeField> this$cubeNestedFields = this.getCubeNestedFields();
        SortedSet<ICubeField> other$cubeNestedFields = other.getCubeNestedFields();
        if (this$cubeNestedFields == null ? other$cubeNestedFields != null : !this$cubeNestedFields.equals(other$cubeNestedFields)) {
            return false;
        }
        ICubeField this$cubeParentField = this.getCubeParentField();
        ICubeField other$cubeParentField = other.getCubeParentField();
        if (this$cubeParentField == null ? other$cubeParentField != null : !this$cubeParentField.equals(other$cubeParentField)) {
            return false;
        }
        String this$cubeParentFieldName = this.getCubeParentFieldName();
        String other$cubeParentFieldName = other.getCubeParentFieldName();
        if (this$cubeParentFieldName == null ? other$cubeParentFieldName != null : !this$cubeParentFieldName.equals(other$cubeParentFieldName)) {
            return false;
        }
        String this$cubeParentFieldQualifiedName = this.getCubeParentFieldQualifiedName();
        String other$cubeParentFieldQualifiedName = other.getCubeParentFieldQualifiedName();
        if (this$cubeParentFieldQualifiedName == null ? other$cubeParentFieldQualifiedName != null : !this$cubeParentFieldQualifiedName.equals(other$cubeParentFieldQualifiedName)) {
            return false;
        }
        String this$cubeQualifiedName = this.getCubeQualifiedName();
        String other$cubeQualifiedName = other.getCubeQualifiedName();
        if (this$cubeQualifiedName == null ? other$cubeQualifiedName != null : !this$cubeQualifiedName.equals(other$cubeQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CubeField;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $cubeFieldGeneration = this.getCubeFieldGeneration();
        result = result * 59 + ($cubeFieldGeneration == null ? 43 : ((Object)$cubeFieldGeneration).hashCode());
        Long $cubeFieldLevel = this.getCubeFieldLevel();
        result = result * 59 + ($cubeFieldLevel == null ? 43 : ((Object)$cubeFieldLevel).hashCode());
        Long $cubeSubFieldCount = this.getCubeSubFieldCount();
        result = result * 59 + ($cubeSubFieldCount == null ? 43 : ((Object)$cubeSubFieldCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $cubeDimensionName = this.getCubeDimensionName();
        result = result * 59 + ($cubeDimensionName == null ? 43 : $cubeDimensionName.hashCode());
        String $cubeDimensionQualifiedName = this.getCubeDimensionQualifiedName();
        result = result * 59 + ($cubeDimensionQualifiedName == null ? 43 : $cubeDimensionQualifiedName.hashCode());
        String $cubeFieldMeasureExpression = this.getCubeFieldMeasureExpression();
        result = result * 59 + ($cubeFieldMeasureExpression == null ? 43 : $cubeFieldMeasureExpression.hashCode());
        ICubeHierarchy $cubeHierarchy = this.getCubeHierarchy();
        result = result * 59 + ($cubeHierarchy == null ? 43 : $cubeHierarchy.hashCode());
        String $cubeHierarchyName = this.getCubeHierarchyName();
        result = result * 59 + ($cubeHierarchyName == null ? 43 : $cubeHierarchyName.hashCode());
        String $cubeHierarchyQualifiedName = this.getCubeHierarchyQualifiedName();
        result = result * 59 + ($cubeHierarchyQualifiedName == null ? 43 : $cubeHierarchyQualifiedName.hashCode());
        String $cubeName = this.getCubeName();
        result = result * 59 + ($cubeName == null ? 43 : $cubeName.hashCode());
        SortedSet<ICubeField> $cubeNestedFields = this.getCubeNestedFields();
        result = result * 59 + ($cubeNestedFields == null ? 43 : $cubeNestedFields.hashCode());
        ICubeField $cubeParentField = this.getCubeParentField();
        result = result * 59 + ($cubeParentField == null ? 43 : $cubeParentField.hashCode());
        String $cubeParentFieldName = this.getCubeParentFieldName();
        result = result * 59 + ($cubeParentFieldName == null ? 43 : $cubeParentFieldName.hashCode());
        String $cubeParentFieldQualifiedName = this.getCubeParentFieldQualifiedName();
        result = result * 59 + ($cubeParentFieldQualifiedName == null ? 43 : $cubeParentFieldQualifiedName.hashCode());
        String $cubeQualifiedName = this.getCubeQualifiedName();
        result = result * 59 + ($cubeQualifiedName == null ? 43 : $cubeQualifiedName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "CubeField(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", cubeDimensionName=" + this.getCubeDimensionName() + ", cubeDimensionQualifiedName=" + this.getCubeDimensionQualifiedName() + ", cubeFieldGeneration=" + this.getCubeFieldGeneration() + ", cubeFieldLevel=" + this.getCubeFieldLevel() + ", cubeFieldMeasureExpression=" + this.getCubeFieldMeasureExpression() + ", cubeHierarchy=" + this.getCubeHierarchy() + ", cubeHierarchyName=" + this.getCubeHierarchyName() + ", cubeHierarchyQualifiedName=" + this.getCubeHierarchyQualifiedName() + ", cubeName=" + this.getCubeName() + ", cubeNestedFields=" + this.getCubeNestedFields() + ", cubeParentField=" + this.getCubeParentField() + ", cubeParentFieldName=" + this.getCubeParentFieldName() + ", cubeParentFieldQualifiedName=" + this.getCubeParentFieldQualifiedName() + ", cubeQualifiedName=" + this.getCubeQualifiedName() + ", cubeSubFieldCount=" + this.getCubeSubFieldCount() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class CubeFieldBuilder<C extends CubeField, B extends CubeFieldBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String cubeDimensionName;
        @Generated
        private String cubeDimensionQualifiedName;
        @Generated
        private Long cubeFieldGeneration;
        @Generated
        private Long cubeFieldLevel;
        @Generated
        private String cubeFieldMeasureExpression;
        @Generated
        private ICubeHierarchy cubeHierarchy;
        @Generated
        private String cubeHierarchyName;
        @Generated
        private String cubeHierarchyQualifiedName;
        @Generated
        private String cubeName;
        @Generated
        private ArrayList<ICubeField> cubeNestedFields;
        @Generated
        private ICubeField cubeParentField;
        @Generated
        private String cubeParentFieldName;
        @Generated
        private String cubeParentFieldQualifiedName;
        @Generated
        private String cubeQualifiedName;
        @Generated
        private Long cubeSubFieldCount;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CubeFieldBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(CubeField instance, CubeFieldBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.cubeDimensionName(instance.cubeDimensionName);
            b.cubeDimensionQualifiedName(instance.cubeDimensionQualifiedName);
            b.cubeFieldGeneration(instance.cubeFieldGeneration);
            b.cubeFieldLevel(instance.cubeFieldLevel);
            b.cubeFieldMeasureExpression(instance.cubeFieldMeasureExpression);
            b.cubeHierarchy(instance.cubeHierarchy);
            b.cubeHierarchyName(instance.cubeHierarchyName);
            b.cubeHierarchyQualifiedName(instance.cubeHierarchyQualifiedName);
            b.cubeName(instance.cubeName);
            b.cubeNestedFields(instance.cubeNestedFields == null ? Collections.emptySortedSet() : instance.cubeNestedFields);
            b.cubeParentField(instance.cubeParentField);
            b.cubeParentFieldName(instance.cubeParentFieldName);
            b.cubeParentFieldQualifiedName(instance.cubeParentFieldQualifiedName);
            b.cubeQualifiedName(instance.cubeQualifiedName);
            b.cubeSubFieldCount(instance.cubeSubFieldCount);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B cubeDimensionName(String cubeDimensionName) {
            this.cubeDimensionName = cubeDimensionName;
            return (B)this.self();
        }

        @Generated
        public B cubeDimensionQualifiedName(String cubeDimensionQualifiedName) {
            this.cubeDimensionQualifiedName = cubeDimensionQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B cubeFieldGeneration(Long cubeFieldGeneration) {
            this.cubeFieldGeneration = cubeFieldGeneration;
            return (B)this.self();
        }

        @Generated
        public B cubeFieldLevel(Long cubeFieldLevel) {
            this.cubeFieldLevel = cubeFieldLevel;
            return (B)this.self();
        }

        @Generated
        public B cubeFieldMeasureExpression(String cubeFieldMeasureExpression) {
            this.cubeFieldMeasureExpression = cubeFieldMeasureExpression;
            return (B)this.self();
        }

        @Generated
        public B cubeHierarchy(ICubeHierarchy cubeHierarchy) {
            this.cubeHierarchy = cubeHierarchy;
            return (B)this.self();
        }

        @Generated
        public B cubeHierarchyName(String cubeHierarchyName) {
            this.cubeHierarchyName = cubeHierarchyName;
            return (B)this.self();
        }

        @Generated
        public B cubeHierarchyQualifiedName(String cubeHierarchyQualifiedName) {
            this.cubeHierarchyQualifiedName = cubeHierarchyQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B cubeName(String cubeName) {
            this.cubeName = cubeName;
            return (B)this.self();
        }

        @Generated
        public B cubeNestedField(ICubeField cubeNestedField) {
            if (this.cubeNestedFields == null) {
                this.cubeNestedFields = new ArrayList();
            }
            this.cubeNestedFields.add(cubeNestedField);
            return (B)this.self();
        }

        @Generated
        public B cubeNestedFields(Collection<? extends ICubeField> cubeNestedFields) {
            if (cubeNestedFields == null) {
                throw new NullPointerException("cubeNestedFields cannot be null");
            }
            if (this.cubeNestedFields == null) {
                this.cubeNestedFields = new ArrayList();
            }
            this.cubeNestedFields.addAll(cubeNestedFields);
            return (B)this.self();
        }

        @Generated
        public B clearCubeNestedFields() {
            if (this.cubeNestedFields != null) {
                this.cubeNestedFields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B cubeParentField(ICubeField cubeParentField) {
            this.cubeParentField = cubeParentField;
            return (B)this.self();
        }

        @Generated
        public B cubeParentFieldName(String cubeParentFieldName) {
            this.cubeParentFieldName = cubeParentFieldName;
            return (B)this.self();
        }

        @Generated
        public B cubeParentFieldQualifiedName(String cubeParentFieldQualifiedName) {
            this.cubeParentFieldQualifiedName = cubeParentFieldQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B cubeQualifiedName(String cubeQualifiedName) {
            this.cubeQualifiedName = cubeQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B cubeSubFieldCount(Long cubeSubFieldCount) {
            this.cubeSubFieldCount = cubeSubFieldCount;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CubeField.CubeFieldBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", cubeDimensionName=" + this.cubeDimensionName + ", cubeDimensionQualifiedName=" + this.cubeDimensionQualifiedName + ", cubeFieldGeneration=" + this.cubeFieldGeneration + ", cubeFieldLevel=" + this.cubeFieldLevel + ", cubeFieldMeasureExpression=" + this.cubeFieldMeasureExpression + ", cubeHierarchy=" + this.cubeHierarchy + ", cubeHierarchyName=" + this.cubeHierarchyName + ", cubeHierarchyQualifiedName=" + this.cubeHierarchyQualifiedName + ", cubeName=" + this.cubeName + ", cubeNestedFields=" + this.cubeNestedFields + ", cubeParentField=" + this.cubeParentField + ", cubeParentFieldName=" + this.cubeParentFieldName + ", cubeParentFieldQualifiedName=" + this.cubeParentFieldQualifiedName + ", cubeQualifiedName=" + this.cubeQualifiedName + ", cubeSubFieldCount=" + this.cubeSubFieldCount + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }

    @Generated
    private static final class CubeFieldBuilderImpl
    extends CubeFieldBuilder<CubeField, CubeFieldBuilderImpl> {
        @Generated
        private CubeFieldBuilderImpl() {
        }

        @Override
        @Generated
        protected CubeFieldBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CubeField build() {
            return new CubeField(this);
        }
    }
}

