/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IDM;
import com.atlan.model.assets.IDMAttribute;
import com.atlan.model.assets.IDMAttributeAssociation;
import com.atlan.model.assets.IDMEntity;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMAttribute
extends Asset
implements IDMAttribute,
IDM,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DMAttribute.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DMAttribute";
    String typeName;
    @Attribute
    @Date
    Long dmBusinessDate;
    @Attribute
    String dmDataModelDomain;
    @Attribute
    String dmDataModelName;
    @Attribute
    String dmDataModelNamespace;
    @Attribute
    String dmDataModelQualifiedName;
    @Attribute
    String dmDataType;
    @Attribute
    SortedSet<IDMEntity> dmEntities;
    @Attribute
    String dmEntityName;
    @Attribute
    String dmEntityQualifiedName;
    @Attribute
    @Date
    Long dmExpiredAtBusinessDate;
    @Attribute
    @Date
    Long dmExpiredAtSystemDate;
    @Attribute
    Boolean dmIsDerived;
    @Attribute
    Boolean dmIsForeign;
    @Attribute
    Boolean dmIsNullable;
    @Attribute
    Boolean dmIsPrimary;
    @Attribute
    SortedSet<IDMAttribute> dmMappedFromAttributes;
    @Attribute
    SortedSet<IDMAttribute> dmMappedToAttributes;
    @Attribute
    Long dmPrecision;
    @Attribute
    SortedSet<IDMAttributeAssociation> dmRelatedFromAttributes;
    @Attribute
    SortedSet<IDMAttributeAssociation> dmRelatedToAttributes;
    @Attribute
    Long dmScale;
    @Attribute
    @Date
    Long dmSystemDate;
    @Attribute
    String dmVersionName;
    @Attribute
    String dmVersionQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public DMAttribute trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return DMAttribute.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return DMAttribute.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return DMAttribute.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return DMAttribute.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return DMAttribute.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return DMAttribute.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static DMAttribute refByGuid(String guid) {
        return DMAttribute.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static DMAttribute refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((DMAttributeBuilder)((DMAttributeBuilder)DMAttribute._internal().guid(guid)).semantic(semantic)).build();
    }

    public static DMAttribute refByQualifiedName(String qualifiedName) {
        return DMAttribute.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static DMAttribute refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((DMAttributeBuilder)((DMAttributeBuilder)DMAttribute._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static DMAttribute get(String id) throws AtlanException {
        return DMAttribute.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static DMAttribute get(AtlanClient client, String id) throws AtlanException {
        return DMAttribute.get(client, id, true);
    }

    @JsonIgnore
    public static DMAttribute get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof DMAttribute) {
                return (DMAttribute)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof DMAttribute) {
            return (DMAttribute)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return DMAttribute.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static DMAttributeBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DMAttributeBuilder)((DMAttributeBuilder)((DMAttributeBuilder)DMAttribute._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public DMAttributeBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        DMAttribute.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return DMAttribute.updater(this.getQualifiedName(), this.getName());
    }

    public static DMAttribute removeDescription(String qualifiedName, String name) throws AtlanException {
        return DMAttribute.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DMAttribute removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMAttribute)Asset.removeDescription(client, DMAttribute.updater(qualifiedName, name));
    }

    public static DMAttribute removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return DMAttribute.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DMAttribute removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMAttribute)Asset.removeUserDescription(client, DMAttribute.updater(qualifiedName, name));
    }

    public static DMAttribute removeOwners(String qualifiedName, String name) throws AtlanException {
        return DMAttribute.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DMAttribute removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMAttribute)Asset.removeOwners(client, DMAttribute.updater(qualifiedName, name));
    }

    public static DMAttribute updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return DMAttribute.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static DMAttribute updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DMAttribute)Asset.updateCertificate(client, DMAttribute._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DMAttribute removeCertificate(String qualifiedName, String name) throws AtlanException {
        return DMAttribute.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DMAttribute removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMAttribute)Asset.removeCertificate(client, DMAttribute.updater(qualifiedName, name));
    }

    public static DMAttribute updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return DMAttribute.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static DMAttribute updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DMAttribute)Asset.updateAnnouncement(client, DMAttribute._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DMAttribute removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return DMAttribute.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DMAttribute removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DMAttribute)Asset.removeAnnouncement(client, DMAttribute.updater(qualifiedName, name));
    }

    public static DMAttribute replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return DMAttribute.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static DMAttribute replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DMAttribute)Asset.replaceTerms(client, DMAttribute.updater(qualifiedName, name), terms);
    }

    public static DMAttribute appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return DMAttribute.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static DMAttribute appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DMAttribute)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DMAttribute removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return DMAttribute.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static DMAttribute removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DMAttribute)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DMAttribute appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return DMAttribute.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static DMAttribute appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DMAttribute)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static DMAttribute appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return DMAttribute.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static DMAttribute appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DMAttribute)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        DMAttribute.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DMAttribute(DMAttributeBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : DMAttribute.$default$typeName();
        this.dmBusinessDate = b.dmBusinessDate;
        this.dmDataModelDomain = b.dmDataModelDomain;
        this.dmDataModelName = b.dmDataModelName;
        this.dmDataModelNamespace = b.dmDataModelNamespace;
        this.dmDataModelQualifiedName = b.dmDataModelQualifiedName;
        this.dmDataType = b.dmDataType;
        SortedSet<IDMEntity> dmEntities = new TreeSet<IDMEntity>();
        if (b.dmEntities != null) {
            dmEntities.addAll(b.dmEntities);
        }
        dmEntities = Collections.unmodifiableSortedSet(dmEntities);
        this.dmEntities = dmEntities;
        this.dmEntityName = b.dmEntityName;
        this.dmEntityQualifiedName = b.dmEntityQualifiedName;
        this.dmExpiredAtBusinessDate = b.dmExpiredAtBusinessDate;
        this.dmExpiredAtSystemDate = b.dmExpiredAtSystemDate;
        this.dmIsDerived = b.dmIsDerived;
        this.dmIsForeign = b.dmIsForeign;
        this.dmIsNullable = b.dmIsNullable;
        this.dmIsPrimary = b.dmIsPrimary;
        SortedSet<IDMAttribute> dmMappedFromAttributes = new TreeSet<IDMAttribute>();
        if (b.dmMappedFromAttributes != null) {
            dmMappedFromAttributes.addAll(b.dmMappedFromAttributes);
        }
        dmMappedFromAttributes = Collections.unmodifiableSortedSet(dmMappedFromAttributes);
        this.dmMappedFromAttributes = dmMappedFromAttributes;
        SortedSet<IDMAttribute> dmMappedToAttributes = new TreeSet<IDMAttribute>();
        if (b.dmMappedToAttributes != null) {
            dmMappedToAttributes.addAll(b.dmMappedToAttributes);
        }
        dmMappedToAttributes = Collections.unmodifiableSortedSet(dmMappedToAttributes);
        this.dmMappedToAttributes = dmMappedToAttributes;
        this.dmPrecision = b.dmPrecision;
        SortedSet<IDMAttributeAssociation> dmRelatedFromAttributes = new TreeSet<IDMAttributeAssociation>();
        if (b.dmRelatedFromAttributes != null) {
            dmRelatedFromAttributes.addAll(b.dmRelatedFromAttributes);
        }
        dmRelatedFromAttributes = Collections.unmodifiableSortedSet(dmRelatedFromAttributes);
        this.dmRelatedFromAttributes = dmRelatedFromAttributes;
        SortedSet<IDMAttributeAssociation> dmRelatedToAttributes = new TreeSet<IDMAttributeAssociation>();
        if (b.dmRelatedToAttributes != null) {
            dmRelatedToAttributes.addAll(b.dmRelatedToAttributes);
        }
        dmRelatedToAttributes = Collections.unmodifiableSortedSet(dmRelatedToAttributes);
        this.dmRelatedToAttributes = dmRelatedToAttributes;
        this.dmScale = b.dmScale;
        this.dmSystemDate = b.dmSystemDate;
        this.dmVersionName = b.dmVersionName;
        this.dmVersionQualifiedName = b.dmVersionQualifiedName;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static DMAttributeBuilder<?, ?> _internal() {
        return new DMAttributeBuilderImpl();
    }

    @Generated
    public DMAttributeBuilder<?, ?> toBuilder() {
        return new DMAttributeBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public Long getDmBusinessDate() {
        return this.dmBusinessDate;
    }

    @Override
    @Generated
    public String getDmDataModelDomain() {
        return this.dmDataModelDomain;
    }

    @Override
    @Generated
    public String getDmDataModelName() {
        return this.dmDataModelName;
    }

    @Override
    @Generated
    public String getDmDataModelNamespace() {
        return this.dmDataModelNamespace;
    }

    @Override
    @Generated
    public String getDmDataModelQualifiedName() {
        return this.dmDataModelQualifiedName;
    }

    @Override
    @Generated
    public String getDmDataType() {
        return this.dmDataType;
    }

    @Override
    @Generated
    public SortedSet<IDMEntity> getDmEntities() {
        return this.dmEntities;
    }

    @Override
    @Generated
    public String getDmEntityName() {
        return this.dmEntityName;
    }

    @Override
    @Generated
    public String getDmEntityQualifiedName() {
        return this.dmEntityQualifiedName;
    }

    @Override
    @Generated
    public Long getDmExpiredAtBusinessDate() {
        return this.dmExpiredAtBusinessDate;
    }

    @Override
    @Generated
    public Long getDmExpiredAtSystemDate() {
        return this.dmExpiredAtSystemDate;
    }

    @Override
    @Generated
    public Boolean getDmIsDerived() {
        return this.dmIsDerived;
    }

    @Override
    @Generated
    public Boolean getDmIsForeign() {
        return this.dmIsForeign;
    }

    @Override
    @Generated
    public Boolean getDmIsNullable() {
        return this.dmIsNullable;
    }

    @Override
    @Generated
    public Boolean getDmIsPrimary() {
        return this.dmIsPrimary;
    }

    @Override
    @Generated
    public SortedSet<IDMAttribute> getDmMappedFromAttributes() {
        return this.dmMappedFromAttributes;
    }

    @Override
    @Generated
    public SortedSet<IDMAttribute> getDmMappedToAttributes() {
        return this.dmMappedToAttributes;
    }

    @Override
    @Generated
    public Long getDmPrecision() {
        return this.dmPrecision;
    }

    @Override
    @Generated
    public SortedSet<IDMAttributeAssociation> getDmRelatedFromAttributes() {
        return this.dmRelatedFromAttributes;
    }

    @Override
    @Generated
    public SortedSet<IDMAttributeAssociation> getDmRelatedToAttributes() {
        return this.dmRelatedToAttributes;
    }

    @Override
    @Generated
    public Long getDmScale() {
        return this.dmScale;
    }

    @Override
    @Generated
    public Long getDmSystemDate() {
        return this.dmSystemDate;
    }

    @Override
    @Generated
    public String getDmVersionName() {
        return this.dmVersionName;
    }

    @Override
    @Generated
    public String getDmVersionQualifiedName() {
        return this.dmVersionQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DMAttribute)) {
            return false;
        }
        DMAttribute other = (DMAttribute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$dmBusinessDate = this.getDmBusinessDate();
        Long other$dmBusinessDate = other.getDmBusinessDate();
        if (this$dmBusinessDate == null ? other$dmBusinessDate != null : !((Object)this$dmBusinessDate).equals(other$dmBusinessDate)) {
            return false;
        }
        Long this$dmExpiredAtBusinessDate = this.getDmExpiredAtBusinessDate();
        Long other$dmExpiredAtBusinessDate = other.getDmExpiredAtBusinessDate();
        if (this$dmExpiredAtBusinessDate == null ? other$dmExpiredAtBusinessDate != null : !((Object)this$dmExpiredAtBusinessDate).equals(other$dmExpiredAtBusinessDate)) {
            return false;
        }
        Long this$dmExpiredAtSystemDate = this.getDmExpiredAtSystemDate();
        Long other$dmExpiredAtSystemDate = other.getDmExpiredAtSystemDate();
        if (this$dmExpiredAtSystemDate == null ? other$dmExpiredAtSystemDate != null : !((Object)this$dmExpiredAtSystemDate).equals(other$dmExpiredAtSystemDate)) {
            return false;
        }
        Boolean this$dmIsDerived = this.getDmIsDerived();
        Boolean other$dmIsDerived = other.getDmIsDerived();
        if (this$dmIsDerived == null ? other$dmIsDerived != null : !((Object)this$dmIsDerived).equals(other$dmIsDerived)) {
            return false;
        }
        Boolean this$dmIsForeign = this.getDmIsForeign();
        Boolean other$dmIsForeign = other.getDmIsForeign();
        if (this$dmIsForeign == null ? other$dmIsForeign != null : !((Object)this$dmIsForeign).equals(other$dmIsForeign)) {
            return false;
        }
        Boolean this$dmIsNullable = this.getDmIsNullable();
        Boolean other$dmIsNullable = other.getDmIsNullable();
        if (this$dmIsNullable == null ? other$dmIsNullable != null : !((Object)this$dmIsNullable).equals(other$dmIsNullable)) {
            return false;
        }
        Boolean this$dmIsPrimary = this.getDmIsPrimary();
        Boolean other$dmIsPrimary = other.getDmIsPrimary();
        if (this$dmIsPrimary == null ? other$dmIsPrimary != null : !((Object)this$dmIsPrimary).equals(other$dmIsPrimary)) {
            return false;
        }
        Long this$dmPrecision = this.getDmPrecision();
        Long other$dmPrecision = other.getDmPrecision();
        if (this$dmPrecision == null ? other$dmPrecision != null : !((Object)this$dmPrecision).equals(other$dmPrecision)) {
            return false;
        }
        Long this$dmScale = this.getDmScale();
        Long other$dmScale = other.getDmScale();
        if (this$dmScale == null ? other$dmScale != null : !((Object)this$dmScale).equals(other$dmScale)) {
            return false;
        }
        Long this$dmSystemDate = this.getDmSystemDate();
        Long other$dmSystemDate = other.getDmSystemDate();
        if (this$dmSystemDate == null ? other$dmSystemDate != null : !((Object)this$dmSystemDate).equals(other$dmSystemDate)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$dmDataModelDomain = this.getDmDataModelDomain();
        String other$dmDataModelDomain = other.getDmDataModelDomain();
        if (this$dmDataModelDomain == null ? other$dmDataModelDomain != null : !this$dmDataModelDomain.equals(other$dmDataModelDomain)) {
            return false;
        }
        String this$dmDataModelName = this.getDmDataModelName();
        String other$dmDataModelName = other.getDmDataModelName();
        if (this$dmDataModelName == null ? other$dmDataModelName != null : !this$dmDataModelName.equals(other$dmDataModelName)) {
            return false;
        }
        String this$dmDataModelNamespace = this.getDmDataModelNamespace();
        String other$dmDataModelNamespace = other.getDmDataModelNamespace();
        if (this$dmDataModelNamespace == null ? other$dmDataModelNamespace != null : !this$dmDataModelNamespace.equals(other$dmDataModelNamespace)) {
            return false;
        }
        String this$dmDataModelQualifiedName = this.getDmDataModelQualifiedName();
        String other$dmDataModelQualifiedName = other.getDmDataModelQualifiedName();
        if (this$dmDataModelQualifiedName == null ? other$dmDataModelQualifiedName != null : !this$dmDataModelQualifiedName.equals(other$dmDataModelQualifiedName)) {
            return false;
        }
        String this$dmDataType = this.getDmDataType();
        String other$dmDataType = other.getDmDataType();
        if (this$dmDataType == null ? other$dmDataType != null : !this$dmDataType.equals(other$dmDataType)) {
            return false;
        }
        SortedSet<IDMEntity> this$dmEntities = this.getDmEntities();
        SortedSet<IDMEntity> other$dmEntities = other.getDmEntities();
        if (this$dmEntities == null ? other$dmEntities != null : !this$dmEntities.equals(other$dmEntities)) {
            return false;
        }
        String this$dmEntityName = this.getDmEntityName();
        String other$dmEntityName = other.getDmEntityName();
        if (this$dmEntityName == null ? other$dmEntityName != null : !this$dmEntityName.equals(other$dmEntityName)) {
            return false;
        }
        String this$dmEntityQualifiedName = this.getDmEntityQualifiedName();
        String other$dmEntityQualifiedName = other.getDmEntityQualifiedName();
        if (this$dmEntityQualifiedName == null ? other$dmEntityQualifiedName != null : !this$dmEntityQualifiedName.equals(other$dmEntityQualifiedName)) {
            return false;
        }
        SortedSet<IDMAttribute> this$dmMappedFromAttributes = this.getDmMappedFromAttributes();
        SortedSet<IDMAttribute> other$dmMappedFromAttributes = other.getDmMappedFromAttributes();
        if (this$dmMappedFromAttributes == null ? other$dmMappedFromAttributes != null : !this$dmMappedFromAttributes.equals(other$dmMappedFromAttributes)) {
            return false;
        }
        SortedSet<IDMAttribute> this$dmMappedToAttributes = this.getDmMappedToAttributes();
        SortedSet<IDMAttribute> other$dmMappedToAttributes = other.getDmMappedToAttributes();
        if (this$dmMappedToAttributes == null ? other$dmMappedToAttributes != null : !this$dmMappedToAttributes.equals(other$dmMappedToAttributes)) {
            return false;
        }
        SortedSet<IDMAttributeAssociation> this$dmRelatedFromAttributes = this.getDmRelatedFromAttributes();
        SortedSet<IDMAttributeAssociation> other$dmRelatedFromAttributes = other.getDmRelatedFromAttributes();
        if (this$dmRelatedFromAttributes == null ? other$dmRelatedFromAttributes != null : !this$dmRelatedFromAttributes.equals(other$dmRelatedFromAttributes)) {
            return false;
        }
        SortedSet<IDMAttributeAssociation> this$dmRelatedToAttributes = this.getDmRelatedToAttributes();
        SortedSet<IDMAttributeAssociation> other$dmRelatedToAttributes = other.getDmRelatedToAttributes();
        if (this$dmRelatedToAttributes == null ? other$dmRelatedToAttributes != null : !this$dmRelatedToAttributes.equals(other$dmRelatedToAttributes)) {
            return false;
        }
        String this$dmVersionName = this.getDmVersionName();
        String other$dmVersionName = other.getDmVersionName();
        if (this$dmVersionName == null ? other$dmVersionName != null : !this$dmVersionName.equals(other$dmVersionName)) {
            return false;
        }
        String this$dmVersionQualifiedName = this.getDmVersionQualifiedName();
        String other$dmVersionQualifiedName = other.getDmVersionQualifiedName();
        if (this$dmVersionQualifiedName == null ? other$dmVersionQualifiedName != null : !this$dmVersionQualifiedName.equals(other$dmVersionQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DMAttribute;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $dmBusinessDate = this.getDmBusinessDate();
        result = result * 59 + ($dmBusinessDate == null ? 43 : ((Object)$dmBusinessDate).hashCode());
        Long $dmExpiredAtBusinessDate = this.getDmExpiredAtBusinessDate();
        result = result * 59 + ($dmExpiredAtBusinessDate == null ? 43 : ((Object)$dmExpiredAtBusinessDate).hashCode());
        Long $dmExpiredAtSystemDate = this.getDmExpiredAtSystemDate();
        result = result * 59 + ($dmExpiredAtSystemDate == null ? 43 : ((Object)$dmExpiredAtSystemDate).hashCode());
        Boolean $dmIsDerived = this.getDmIsDerived();
        result = result * 59 + ($dmIsDerived == null ? 43 : ((Object)$dmIsDerived).hashCode());
        Boolean $dmIsForeign = this.getDmIsForeign();
        result = result * 59 + ($dmIsForeign == null ? 43 : ((Object)$dmIsForeign).hashCode());
        Boolean $dmIsNullable = this.getDmIsNullable();
        result = result * 59 + ($dmIsNullable == null ? 43 : ((Object)$dmIsNullable).hashCode());
        Boolean $dmIsPrimary = this.getDmIsPrimary();
        result = result * 59 + ($dmIsPrimary == null ? 43 : ((Object)$dmIsPrimary).hashCode());
        Long $dmPrecision = this.getDmPrecision();
        result = result * 59 + ($dmPrecision == null ? 43 : ((Object)$dmPrecision).hashCode());
        Long $dmScale = this.getDmScale();
        result = result * 59 + ($dmScale == null ? 43 : ((Object)$dmScale).hashCode());
        Long $dmSystemDate = this.getDmSystemDate();
        result = result * 59 + ($dmSystemDate == null ? 43 : ((Object)$dmSystemDate).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $dmDataModelDomain = this.getDmDataModelDomain();
        result = result * 59 + ($dmDataModelDomain == null ? 43 : $dmDataModelDomain.hashCode());
        String $dmDataModelName = this.getDmDataModelName();
        result = result * 59 + ($dmDataModelName == null ? 43 : $dmDataModelName.hashCode());
        String $dmDataModelNamespace = this.getDmDataModelNamespace();
        result = result * 59 + ($dmDataModelNamespace == null ? 43 : $dmDataModelNamespace.hashCode());
        String $dmDataModelQualifiedName = this.getDmDataModelQualifiedName();
        result = result * 59 + ($dmDataModelQualifiedName == null ? 43 : $dmDataModelQualifiedName.hashCode());
        String $dmDataType = this.getDmDataType();
        result = result * 59 + ($dmDataType == null ? 43 : $dmDataType.hashCode());
        SortedSet<IDMEntity> $dmEntities = this.getDmEntities();
        result = result * 59 + ($dmEntities == null ? 43 : $dmEntities.hashCode());
        String $dmEntityName = this.getDmEntityName();
        result = result * 59 + ($dmEntityName == null ? 43 : $dmEntityName.hashCode());
        String $dmEntityQualifiedName = this.getDmEntityQualifiedName();
        result = result * 59 + ($dmEntityQualifiedName == null ? 43 : $dmEntityQualifiedName.hashCode());
        SortedSet<IDMAttribute> $dmMappedFromAttributes = this.getDmMappedFromAttributes();
        result = result * 59 + ($dmMappedFromAttributes == null ? 43 : $dmMappedFromAttributes.hashCode());
        SortedSet<IDMAttribute> $dmMappedToAttributes = this.getDmMappedToAttributes();
        result = result * 59 + ($dmMappedToAttributes == null ? 43 : $dmMappedToAttributes.hashCode());
        SortedSet<IDMAttributeAssociation> $dmRelatedFromAttributes = this.getDmRelatedFromAttributes();
        result = result * 59 + ($dmRelatedFromAttributes == null ? 43 : $dmRelatedFromAttributes.hashCode());
        SortedSet<IDMAttributeAssociation> $dmRelatedToAttributes = this.getDmRelatedToAttributes();
        result = result * 59 + ($dmRelatedToAttributes == null ? 43 : $dmRelatedToAttributes.hashCode());
        String $dmVersionName = this.getDmVersionName();
        result = result * 59 + ($dmVersionName == null ? 43 : $dmVersionName.hashCode());
        String $dmVersionQualifiedName = this.getDmVersionQualifiedName();
        result = result * 59 + ($dmVersionQualifiedName == null ? 43 : $dmVersionQualifiedName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DMAttribute(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dmBusinessDate=" + this.getDmBusinessDate() + ", dmDataModelDomain=" + this.getDmDataModelDomain() + ", dmDataModelName=" + this.getDmDataModelName() + ", dmDataModelNamespace=" + this.getDmDataModelNamespace() + ", dmDataModelQualifiedName=" + this.getDmDataModelQualifiedName() + ", dmDataType=" + this.getDmDataType() + ", dmEntities=" + this.getDmEntities() + ", dmEntityName=" + this.getDmEntityName() + ", dmEntityQualifiedName=" + this.getDmEntityQualifiedName() + ", dmExpiredAtBusinessDate=" + this.getDmExpiredAtBusinessDate() + ", dmExpiredAtSystemDate=" + this.getDmExpiredAtSystemDate() + ", dmIsDerived=" + this.getDmIsDerived() + ", dmIsForeign=" + this.getDmIsForeign() + ", dmIsNullable=" + this.getDmIsNullable() + ", dmIsPrimary=" + this.getDmIsPrimary() + ", dmMappedFromAttributes=" + this.getDmMappedFromAttributes() + ", dmMappedToAttributes=" + this.getDmMappedToAttributes() + ", dmPrecision=" + this.getDmPrecision() + ", dmRelatedFromAttributes=" + this.getDmRelatedFromAttributes() + ", dmRelatedToAttributes=" + this.getDmRelatedToAttributes() + ", dmScale=" + this.getDmScale() + ", dmSystemDate=" + this.getDmSystemDate() + ", dmVersionName=" + this.getDmVersionName() + ", dmVersionQualifiedName=" + this.getDmVersionQualifiedName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class DMAttributeBuilder<C extends DMAttribute, B extends DMAttributeBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Long dmBusinessDate;
        @Generated
        private String dmDataModelDomain;
        @Generated
        private String dmDataModelName;
        @Generated
        private String dmDataModelNamespace;
        @Generated
        private String dmDataModelQualifiedName;
        @Generated
        private String dmDataType;
        @Generated
        private ArrayList<IDMEntity> dmEntities;
        @Generated
        private String dmEntityName;
        @Generated
        private String dmEntityQualifiedName;
        @Generated
        private Long dmExpiredAtBusinessDate;
        @Generated
        private Long dmExpiredAtSystemDate;
        @Generated
        private Boolean dmIsDerived;
        @Generated
        private Boolean dmIsForeign;
        @Generated
        private Boolean dmIsNullable;
        @Generated
        private Boolean dmIsPrimary;
        @Generated
        private ArrayList<IDMAttribute> dmMappedFromAttributes;
        @Generated
        private ArrayList<IDMAttribute> dmMappedToAttributes;
        @Generated
        private Long dmPrecision;
        @Generated
        private ArrayList<IDMAttributeAssociation> dmRelatedFromAttributes;
        @Generated
        private ArrayList<IDMAttributeAssociation> dmRelatedToAttributes;
        @Generated
        private Long dmScale;
        @Generated
        private Long dmSystemDate;
        @Generated
        private String dmVersionName;
        @Generated
        private String dmVersionQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DMAttributeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DMAttribute instance, DMAttributeBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dmBusinessDate(instance.dmBusinessDate);
            b.dmDataModelDomain(instance.dmDataModelDomain);
            b.dmDataModelName(instance.dmDataModelName);
            b.dmDataModelNamespace(instance.dmDataModelNamespace);
            b.dmDataModelQualifiedName(instance.dmDataModelQualifiedName);
            b.dmDataType(instance.dmDataType);
            b.dmEntities(instance.dmEntities == null ? Collections.emptySortedSet() : instance.dmEntities);
            b.dmEntityName(instance.dmEntityName);
            b.dmEntityQualifiedName(instance.dmEntityQualifiedName);
            b.dmExpiredAtBusinessDate(instance.dmExpiredAtBusinessDate);
            b.dmExpiredAtSystemDate(instance.dmExpiredAtSystemDate);
            b.dmIsDerived(instance.dmIsDerived);
            b.dmIsForeign(instance.dmIsForeign);
            b.dmIsNullable(instance.dmIsNullable);
            b.dmIsPrimary(instance.dmIsPrimary);
            b.dmMappedFromAttributes(instance.dmMappedFromAttributes == null ? Collections.emptySortedSet() : instance.dmMappedFromAttributes);
            b.dmMappedToAttributes(instance.dmMappedToAttributes == null ? Collections.emptySortedSet() : instance.dmMappedToAttributes);
            b.dmPrecision(instance.dmPrecision);
            b.dmRelatedFromAttributes(instance.dmRelatedFromAttributes == null ? Collections.emptySortedSet() : instance.dmRelatedFromAttributes);
            b.dmRelatedToAttributes(instance.dmRelatedToAttributes == null ? Collections.emptySortedSet() : instance.dmRelatedToAttributes);
            b.dmScale(instance.dmScale);
            b.dmSystemDate(instance.dmSystemDate);
            b.dmVersionName(instance.dmVersionName);
            b.dmVersionQualifiedName(instance.dmVersionQualifiedName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dmBusinessDate(Long dmBusinessDate) {
            this.dmBusinessDate = dmBusinessDate;
            return (B)this.self();
        }

        @Generated
        public B dmDataModelDomain(String dmDataModelDomain) {
            this.dmDataModelDomain = dmDataModelDomain;
            return (B)this.self();
        }

        @Generated
        public B dmDataModelName(String dmDataModelName) {
            this.dmDataModelName = dmDataModelName;
            return (B)this.self();
        }

        @Generated
        public B dmDataModelNamespace(String dmDataModelNamespace) {
            this.dmDataModelNamespace = dmDataModelNamespace;
            return (B)this.self();
        }

        @Generated
        public B dmDataModelQualifiedName(String dmDataModelQualifiedName) {
            this.dmDataModelQualifiedName = dmDataModelQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B dmDataType(String dmDataType) {
            this.dmDataType = dmDataType;
            return (B)this.self();
        }

        @Generated
        public B dmEntity(IDMEntity dmEntity) {
            if (this.dmEntities == null) {
                this.dmEntities = new ArrayList();
            }
            this.dmEntities.add(dmEntity);
            return (B)this.self();
        }

        @Generated
        public B dmEntities(Collection<? extends IDMEntity> dmEntities) {
            if (dmEntities == null) {
                throw new NullPointerException("dmEntities cannot be null");
            }
            if (this.dmEntities == null) {
                this.dmEntities = new ArrayList();
            }
            this.dmEntities.addAll(dmEntities);
            return (B)this.self();
        }

        @Generated
        public B clearDmEntities() {
            if (this.dmEntities != null) {
                this.dmEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dmEntityName(String dmEntityName) {
            this.dmEntityName = dmEntityName;
            return (B)this.self();
        }

        @Generated
        public B dmEntityQualifiedName(String dmEntityQualifiedName) {
            this.dmEntityQualifiedName = dmEntityQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B dmExpiredAtBusinessDate(Long dmExpiredAtBusinessDate) {
            this.dmExpiredAtBusinessDate = dmExpiredAtBusinessDate;
            return (B)this.self();
        }

        @Generated
        public B dmExpiredAtSystemDate(Long dmExpiredAtSystemDate) {
            this.dmExpiredAtSystemDate = dmExpiredAtSystemDate;
            return (B)this.self();
        }

        @Generated
        public B dmIsDerived(Boolean dmIsDerived) {
            this.dmIsDerived = dmIsDerived;
            return (B)this.self();
        }

        @Generated
        public B dmIsForeign(Boolean dmIsForeign) {
            this.dmIsForeign = dmIsForeign;
            return (B)this.self();
        }

        @Generated
        public B dmIsNullable(Boolean dmIsNullable) {
            this.dmIsNullable = dmIsNullable;
            return (B)this.self();
        }

        @Generated
        public B dmIsPrimary(Boolean dmIsPrimary) {
            this.dmIsPrimary = dmIsPrimary;
            return (B)this.self();
        }

        @Generated
        public B dmMappedFromAttribute(IDMAttribute dmMappedFromAttribute) {
            if (this.dmMappedFromAttributes == null) {
                this.dmMappedFromAttributes = new ArrayList();
            }
            this.dmMappedFromAttributes.add(dmMappedFromAttribute);
            return (B)this.self();
        }

        @Generated
        public B dmMappedFromAttributes(Collection<? extends IDMAttribute> dmMappedFromAttributes) {
            if (dmMappedFromAttributes == null) {
                throw new NullPointerException("dmMappedFromAttributes cannot be null");
            }
            if (this.dmMappedFromAttributes == null) {
                this.dmMappedFromAttributes = new ArrayList();
            }
            this.dmMappedFromAttributes.addAll(dmMappedFromAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearDmMappedFromAttributes() {
            if (this.dmMappedFromAttributes != null) {
                this.dmMappedFromAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dmMappedToAttribute(IDMAttribute dmMappedToAttribute) {
            if (this.dmMappedToAttributes == null) {
                this.dmMappedToAttributes = new ArrayList();
            }
            this.dmMappedToAttributes.add(dmMappedToAttribute);
            return (B)this.self();
        }

        @Generated
        public B dmMappedToAttributes(Collection<? extends IDMAttribute> dmMappedToAttributes) {
            if (dmMappedToAttributes == null) {
                throw new NullPointerException("dmMappedToAttributes cannot be null");
            }
            if (this.dmMappedToAttributes == null) {
                this.dmMappedToAttributes = new ArrayList();
            }
            this.dmMappedToAttributes.addAll(dmMappedToAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearDmMappedToAttributes() {
            if (this.dmMappedToAttributes != null) {
                this.dmMappedToAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dmPrecision(Long dmPrecision) {
            this.dmPrecision = dmPrecision;
            return (B)this.self();
        }

        @Generated
        public B dmRelatedFromAttribute(IDMAttributeAssociation dmRelatedFromAttribute) {
            if (this.dmRelatedFromAttributes == null) {
                this.dmRelatedFromAttributes = new ArrayList();
            }
            this.dmRelatedFromAttributes.add(dmRelatedFromAttribute);
            return (B)this.self();
        }

        @Generated
        public B dmRelatedFromAttributes(Collection<? extends IDMAttributeAssociation> dmRelatedFromAttributes) {
            if (dmRelatedFromAttributes == null) {
                throw new NullPointerException("dmRelatedFromAttributes cannot be null");
            }
            if (this.dmRelatedFromAttributes == null) {
                this.dmRelatedFromAttributes = new ArrayList();
            }
            this.dmRelatedFromAttributes.addAll(dmRelatedFromAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearDmRelatedFromAttributes() {
            if (this.dmRelatedFromAttributes != null) {
                this.dmRelatedFromAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dmRelatedToAttribute(IDMAttributeAssociation dmRelatedToAttribute) {
            if (this.dmRelatedToAttributes == null) {
                this.dmRelatedToAttributes = new ArrayList();
            }
            this.dmRelatedToAttributes.add(dmRelatedToAttribute);
            return (B)this.self();
        }

        @Generated
        public B dmRelatedToAttributes(Collection<? extends IDMAttributeAssociation> dmRelatedToAttributes) {
            if (dmRelatedToAttributes == null) {
                throw new NullPointerException("dmRelatedToAttributes cannot be null");
            }
            if (this.dmRelatedToAttributes == null) {
                this.dmRelatedToAttributes = new ArrayList();
            }
            this.dmRelatedToAttributes.addAll(dmRelatedToAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearDmRelatedToAttributes() {
            if (this.dmRelatedToAttributes != null) {
                this.dmRelatedToAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dmScale(Long dmScale) {
            this.dmScale = dmScale;
            return (B)this.self();
        }

        @Generated
        public B dmSystemDate(Long dmSystemDate) {
            this.dmSystemDate = dmSystemDate;
            return (B)this.self();
        }

        @Generated
        public B dmVersionName(String dmVersionName) {
            this.dmVersionName = dmVersionName;
            return (B)this.self();
        }

        @Generated
        public B dmVersionQualifiedName(String dmVersionQualifiedName) {
            this.dmVersionQualifiedName = dmVersionQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DMAttribute.DMAttributeBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dmBusinessDate=" + this.dmBusinessDate + ", dmDataModelDomain=" + this.dmDataModelDomain + ", dmDataModelName=" + this.dmDataModelName + ", dmDataModelNamespace=" + this.dmDataModelNamespace + ", dmDataModelQualifiedName=" + this.dmDataModelQualifiedName + ", dmDataType=" + this.dmDataType + ", dmEntities=" + this.dmEntities + ", dmEntityName=" + this.dmEntityName + ", dmEntityQualifiedName=" + this.dmEntityQualifiedName + ", dmExpiredAtBusinessDate=" + this.dmExpiredAtBusinessDate + ", dmExpiredAtSystemDate=" + this.dmExpiredAtSystemDate + ", dmIsDerived=" + this.dmIsDerived + ", dmIsForeign=" + this.dmIsForeign + ", dmIsNullable=" + this.dmIsNullable + ", dmIsPrimary=" + this.dmIsPrimary + ", dmMappedFromAttributes=" + this.dmMappedFromAttributes + ", dmMappedToAttributes=" + this.dmMappedToAttributes + ", dmPrecision=" + this.dmPrecision + ", dmRelatedFromAttributes=" + this.dmRelatedFromAttributes + ", dmRelatedToAttributes=" + this.dmRelatedToAttributes + ", dmScale=" + this.dmScale + ", dmSystemDate=" + this.dmSystemDate + ", dmVersionName=" + this.dmVersionName + ", dmVersionQualifiedName=" + this.dmVersionQualifiedName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }

    @Generated
    private static final class DMAttributeBuilderImpl
    extends DMAttributeBuilder<DMAttribute, DMAttributeBuilderImpl> {
        @Generated
        private DMAttributeBuilderImpl() {
        }

        @Override
        @Generated
        protected DMAttributeBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DMAttribute build() {
            return new DMAttribute(this);
        }
    }
}

