/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IDbt;
import com.atlan.model.assets.IDbtModel;
import com.atlan.model.assets.IDbtModelColumn;
import com.atlan.model.assets.IDbtSource;
import com.atlan.model.assets.IDbtTest;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISQL;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.model.structs.DbtJobRun;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbtTest
extends Asset
implements IDbtTest,
IDbt,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DbtTest.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DbtTest";
    String typeName;
    @Attribute
    String dbtAccountName;
    @Attribute
    String dbtAlias;
    @Attribute
    String dbtConnectionContext;
    @Attribute
    String dbtEnvironmentDbtVersion;
    @Attribute
    String dbtEnvironmentName;
    @Attribute
    @Date
    Long dbtJobLastRun;
    @Attribute
    String dbtJobName;
    @Attribute
    @Date
    Long dbtJobNextRun;
    @Attribute
    String dbtJobNextRunHumanized;
    @Attribute
    List<DbtJobRun> dbtJobRuns;
    @Attribute
    String dbtJobSchedule;
    @Attribute
    String dbtJobScheduleCronHumanized;
    @Attribute
    String dbtJobStatus;
    @Attribute
    String dbtMeta;
    @Attribute
    SortedSet<IDbtModelColumn> dbtModelColumns;
    @Attribute
    SortedSet<IDbtModel> dbtModels;
    @Attribute
    String dbtPackageName;
    @Attribute
    String dbtProjectName;
    @Attribute
    String dbtSemanticLayerProxyUrl;
    @Attribute
    SortedSet<IDbtSource> dbtSources;
    @Attribute
    SortedSet<String> dbtTags;
    @Attribute
    String dbtTestCompiledCode;
    @Attribute
    String dbtTestCompiledSQL;
    @Attribute
    String dbtTestError;
    @Attribute
    String dbtTestLanguage;
    @Attribute
    String dbtTestRawCode;
    @Attribute
    String dbtTestRawSQL;
    @Attribute
    String dbtTestState;
    @Attribute
    String dbtTestStatus;
    @Attribute
    String dbtUniqueId;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    SortedSet<ISQL> sqlAssets;

    @Override
    public DbtTest trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return DbtTest.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return DbtTest.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return DbtTest.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return DbtTest.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return DbtTest.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return DbtTest.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static DbtTest refByGuid(String guid) {
        return DbtTest.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static DbtTest refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((DbtTestBuilder)((DbtTestBuilder)DbtTest._internal().guid(guid)).semantic(semantic)).build();
    }

    public static DbtTest refByQualifiedName(String qualifiedName) {
        return DbtTest.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static DbtTest refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((DbtTestBuilder)((DbtTestBuilder)DbtTest._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static DbtTest get(String id) throws AtlanException {
        return DbtTest.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static DbtTest get(AtlanClient client, String id) throws AtlanException {
        return DbtTest.get(client, id, true);
    }

    @JsonIgnore
    public static DbtTest get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof DbtTest) {
                return (DbtTest)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof DbtTest) {
            return (DbtTest)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return DbtTest.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static DbtTestBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DbtTestBuilder)((DbtTestBuilder)((DbtTestBuilder)DbtTest._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public DbtTestBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        DbtTest.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return DbtTest.updater(this.getQualifiedName(), this.getName());
    }

    public static DbtTest removeDescription(String qualifiedName, String name) throws AtlanException {
        return DbtTest.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DbtTest removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtTest)Asset.removeDescription(client, DbtTest.updater(qualifiedName, name));
    }

    public static DbtTest removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return DbtTest.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DbtTest removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtTest)Asset.removeUserDescription(client, DbtTest.updater(qualifiedName, name));
    }

    public static DbtTest removeOwners(String qualifiedName, String name) throws AtlanException {
        return DbtTest.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DbtTest removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtTest)Asset.removeOwners(client, DbtTest.updater(qualifiedName, name));
    }

    public static DbtTest updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return DbtTest.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static DbtTest updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DbtTest)Asset.updateCertificate(client, DbtTest._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DbtTest removeCertificate(String qualifiedName, String name) throws AtlanException {
        return DbtTest.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DbtTest removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtTest)Asset.removeCertificate(client, DbtTest.updater(qualifiedName, name));
    }

    public static DbtTest updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return DbtTest.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static DbtTest updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DbtTest)Asset.updateAnnouncement(client, DbtTest._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DbtTest removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return DbtTest.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DbtTest removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DbtTest)Asset.removeAnnouncement(client, DbtTest.updater(qualifiedName, name));
    }

    public static DbtTest replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return DbtTest.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static DbtTest replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DbtTest)Asset.replaceTerms(client, DbtTest.updater(qualifiedName, name), terms);
    }

    public static DbtTest appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return DbtTest.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static DbtTest appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DbtTest)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DbtTest removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return DbtTest.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static DbtTest removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DbtTest)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DbtTest appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return DbtTest.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static DbtTest appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DbtTest)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static DbtTest appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return DbtTest.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static DbtTest appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DbtTest)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        DbtTest.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DbtTest(DbtTestBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : DbtTest.$default$typeName();
        this.dbtAccountName = b.dbtAccountName;
        this.dbtAlias = b.dbtAlias;
        this.dbtConnectionContext = b.dbtConnectionContext;
        this.dbtEnvironmentDbtVersion = b.dbtEnvironmentDbtVersion;
        this.dbtEnvironmentName = b.dbtEnvironmentName;
        this.dbtJobLastRun = b.dbtJobLastRun;
        this.dbtJobName = b.dbtJobName;
        this.dbtJobNextRun = b.dbtJobNextRun;
        this.dbtJobNextRunHumanized = b.dbtJobNextRunHumanized;
        this.dbtJobRuns = switch (b.dbtJobRuns == null ? 0 : b.dbtJobRuns.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.dbtJobRuns.get(0));
            default -> Collections.unmodifiableList(new ArrayList<DbtJobRun>(b.dbtJobRuns));
        };
        this.dbtJobSchedule = b.dbtJobSchedule;
        this.dbtJobScheduleCronHumanized = b.dbtJobScheduleCronHumanized;
        this.dbtJobStatus = b.dbtJobStatus;
        this.dbtMeta = b.dbtMeta;
        SortedSet<IDbtModelColumn> dbtModelColumns = new TreeSet<IDbtModelColumn>();
        if (b.dbtModelColumns != null) {
            dbtModelColumns.addAll(b.dbtModelColumns);
        }
        dbtModelColumns = Collections.unmodifiableSortedSet(dbtModelColumns);
        this.dbtModelColumns = dbtModelColumns;
        SortedSet<IDbtModel> dbtModels = new TreeSet<IDbtModel>();
        if (b.dbtModels != null) {
            dbtModels.addAll(b.dbtModels);
        }
        dbtModels = Collections.unmodifiableSortedSet(dbtModels);
        this.dbtModels = dbtModels;
        this.dbtPackageName = b.dbtPackageName;
        this.dbtProjectName = b.dbtProjectName;
        this.dbtSemanticLayerProxyUrl = b.dbtSemanticLayerProxyUrl;
        SortedSet<IDbtSource> dbtSources = new TreeSet<IDbtSource>();
        if (b.dbtSources != null) {
            dbtSources.addAll(b.dbtSources);
        }
        dbtSources = Collections.unmodifiableSortedSet(dbtSources);
        this.dbtSources = dbtSources;
        SortedSet<String> dbtTags = new TreeSet<String>();
        if (b.dbtTags != null) {
            dbtTags.addAll(b.dbtTags);
        }
        dbtTags = Collections.unmodifiableSortedSet(dbtTags);
        this.dbtTags = dbtTags;
        this.dbtTestCompiledCode = b.dbtTestCompiledCode;
        this.dbtTestCompiledSQL = b.dbtTestCompiledSQL;
        this.dbtTestError = b.dbtTestError;
        this.dbtTestLanguage = b.dbtTestLanguage;
        this.dbtTestRawCode = b.dbtTestRawCode;
        this.dbtTestRawSQL = b.dbtTestRawSQL;
        this.dbtTestState = b.dbtTestState;
        this.dbtTestStatus = b.dbtTestStatus;
        this.dbtUniqueId = b.dbtUniqueId;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        SortedSet<ISQL> sqlAssets = new TreeSet<ISQL>();
        if (b.sqlAssets != null) {
            sqlAssets.addAll(b.sqlAssets);
        }
        sqlAssets = Collections.unmodifiableSortedSet(sqlAssets);
        this.sqlAssets = sqlAssets;
    }

    @Generated
    public static DbtTestBuilder<?, ?> _internal() {
        return new DbtTestBuilderImpl();
    }

    @Generated
    public DbtTestBuilder<?, ?> toBuilder() {
        return new DbtTestBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getDbtAccountName() {
        return this.dbtAccountName;
    }

    @Override
    @Generated
    public String getDbtAlias() {
        return this.dbtAlias;
    }

    @Override
    @Generated
    public String getDbtConnectionContext() {
        return this.dbtConnectionContext;
    }

    @Override
    @Generated
    public String getDbtEnvironmentDbtVersion() {
        return this.dbtEnvironmentDbtVersion;
    }

    @Override
    @Generated
    public String getDbtEnvironmentName() {
        return this.dbtEnvironmentName;
    }

    @Override
    @Generated
    public Long getDbtJobLastRun() {
        return this.dbtJobLastRun;
    }

    @Override
    @Generated
    public String getDbtJobName() {
        return this.dbtJobName;
    }

    @Override
    @Generated
    public Long getDbtJobNextRun() {
        return this.dbtJobNextRun;
    }

    @Override
    @Generated
    public String getDbtJobNextRunHumanized() {
        return this.dbtJobNextRunHumanized;
    }

    @Override
    @Generated
    public List<DbtJobRun> getDbtJobRuns() {
        return this.dbtJobRuns;
    }

    @Override
    @Generated
    public String getDbtJobSchedule() {
        return this.dbtJobSchedule;
    }

    @Override
    @Generated
    public String getDbtJobScheduleCronHumanized() {
        return this.dbtJobScheduleCronHumanized;
    }

    @Override
    @Generated
    public String getDbtJobStatus() {
        return this.dbtJobStatus;
    }

    @Override
    @Generated
    public String getDbtMeta() {
        return this.dbtMeta;
    }

    @Override
    @Generated
    public SortedSet<IDbtModelColumn> getDbtModelColumns() {
        return this.dbtModelColumns;
    }

    @Override
    @Generated
    public SortedSet<IDbtModel> getDbtModels() {
        return this.dbtModels;
    }

    @Override
    @Generated
    public String getDbtPackageName() {
        return this.dbtPackageName;
    }

    @Override
    @Generated
    public String getDbtProjectName() {
        return this.dbtProjectName;
    }

    @Override
    @Generated
    public String getDbtSemanticLayerProxyUrl() {
        return this.dbtSemanticLayerProxyUrl;
    }

    @Override
    @Generated
    public SortedSet<IDbtSource> getDbtSources() {
        return this.dbtSources;
    }

    @Override
    @Generated
    public SortedSet<String> getDbtTags() {
        return this.dbtTags;
    }

    @Override
    @Generated
    public String getDbtTestCompiledCode() {
        return this.dbtTestCompiledCode;
    }

    @Override
    @Generated
    public String getDbtTestCompiledSQL() {
        return this.dbtTestCompiledSQL;
    }

    @Override
    @Generated
    public String getDbtTestError() {
        return this.dbtTestError;
    }

    @Override
    @Generated
    public String getDbtTestLanguage() {
        return this.dbtTestLanguage;
    }

    @Override
    @Generated
    public String getDbtTestRawCode() {
        return this.dbtTestRawCode;
    }

    @Override
    @Generated
    public String getDbtTestRawSQL() {
        return this.dbtTestRawSQL;
    }

    @Override
    @Generated
    public String getDbtTestState() {
        return this.dbtTestState;
    }

    @Override
    @Generated
    public String getDbtTestStatus() {
        return this.dbtTestStatus;
    }

    @Override
    @Generated
    public String getDbtUniqueId() {
        return this.dbtUniqueId;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<ISQL> getSqlAssets() {
        return this.sqlAssets;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbtTest)) {
            return false;
        }
        DbtTest other = (DbtTest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$dbtJobLastRun = this.getDbtJobLastRun();
        Long other$dbtJobLastRun = other.getDbtJobLastRun();
        if (this$dbtJobLastRun == null ? other$dbtJobLastRun != null : !((Object)this$dbtJobLastRun).equals(other$dbtJobLastRun)) {
            return false;
        }
        Long this$dbtJobNextRun = this.getDbtJobNextRun();
        Long other$dbtJobNextRun = other.getDbtJobNextRun();
        if (this$dbtJobNextRun == null ? other$dbtJobNextRun != null : !((Object)this$dbtJobNextRun).equals(other$dbtJobNextRun)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$dbtAccountName = this.getDbtAccountName();
        String other$dbtAccountName = other.getDbtAccountName();
        if (this$dbtAccountName == null ? other$dbtAccountName != null : !this$dbtAccountName.equals(other$dbtAccountName)) {
            return false;
        }
        String this$dbtAlias = this.getDbtAlias();
        String other$dbtAlias = other.getDbtAlias();
        if (this$dbtAlias == null ? other$dbtAlias != null : !this$dbtAlias.equals(other$dbtAlias)) {
            return false;
        }
        String this$dbtConnectionContext = this.getDbtConnectionContext();
        String other$dbtConnectionContext = other.getDbtConnectionContext();
        if (this$dbtConnectionContext == null ? other$dbtConnectionContext != null : !this$dbtConnectionContext.equals(other$dbtConnectionContext)) {
            return false;
        }
        String this$dbtEnvironmentDbtVersion = this.getDbtEnvironmentDbtVersion();
        String other$dbtEnvironmentDbtVersion = other.getDbtEnvironmentDbtVersion();
        if (this$dbtEnvironmentDbtVersion == null ? other$dbtEnvironmentDbtVersion != null : !this$dbtEnvironmentDbtVersion.equals(other$dbtEnvironmentDbtVersion)) {
            return false;
        }
        String this$dbtEnvironmentName = this.getDbtEnvironmentName();
        String other$dbtEnvironmentName = other.getDbtEnvironmentName();
        if (this$dbtEnvironmentName == null ? other$dbtEnvironmentName != null : !this$dbtEnvironmentName.equals(other$dbtEnvironmentName)) {
            return false;
        }
        String this$dbtJobName = this.getDbtJobName();
        String other$dbtJobName = other.getDbtJobName();
        if (this$dbtJobName == null ? other$dbtJobName != null : !this$dbtJobName.equals(other$dbtJobName)) {
            return false;
        }
        String this$dbtJobNextRunHumanized = this.getDbtJobNextRunHumanized();
        String other$dbtJobNextRunHumanized = other.getDbtJobNextRunHumanized();
        if (this$dbtJobNextRunHumanized == null ? other$dbtJobNextRunHumanized != null : !this$dbtJobNextRunHumanized.equals(other$dbtJobNextRunHumanized)) {
            return false;
        }
        List<DbtJobRun> this$dbtJobRuns = this.getDbtJobRuns();
        List<DbtJobRun> other$dbtJobRuns = other.getDbtJobRuns();
        if (this$dbtJobRuns == null ? other$dbtJobRuns != null : !((Object)this$dbtJobRuns).equals(other$dbtJobRuns)) {
            return false;
        }
        String this$dbtJobSchedule = this.getDbtJobSchedule();
        String other$dbtJobSchedule = other.getDbtJobSchedule();
        if (this$dbtJobSchedule == null ? other$dbtJobSchedule != null : !this$dbtJobSchedule.equals(other$dbtJobSchedule)) {
            return false;
        }
        String this$dbtJobScheduleCronHumanized = this.getDbtJobScheduleCronHumanized();
        String other$dbtJobScheduleCronHumanized = other.getDbtJobScheduleCronHumanized();
        if (this$dbtJobScheduleCronHumanized == null ? other$dbtJobScheduleCronHumanized != null : !this$dbtJobScheduleCronHumanized.equals(other$dbtJobScheduleCronHumanized)) {
            return false;
        }
        String this$dbtJobStatus = this.getDbtJobStatus();
        String other$dbtJobStatus = other.getDbtJobStatus();
        if (this$dbtJobStatus == null ? other$dbtJobStatus != null : !this$dbtJobStatus.equals(other$dbtJobStatus)) {
            return false;
        }
        String this$dbtMeta = this.getDbtMeta();
        String other$dbtMeta = other.getDbtMeta();
        if (this$dbtMeta == null ? other$dbtMeta != null : !this$dbtMeta.equals(other$dbtMeta)) {
            return false;
        }
        SortedSet<IDbtModelColumn> this$dbtModelColumns = this.getDbtModelColumns();
        SortedSet<IDbtModelColumn> other$dbtModelColumns = other.getDbtModelColumns();
        if (this$dbtModelColumns == null ? other$dbtModelColumns != null : !this$dbtModelColumns.equals(other$dbtModelColumns)) {
            return false;
        }
        SortedSet<IDbtModel> this$dbtModels = this.getDbtModels();
        SortedSet<IDbtModel> other$dbtModels = other.getDbtModels();
        if (this$dbtModels == null ? other$dbtModels != null : !this$dbtModels.equals(other$dbtModels)) {
            return false;
        }
        String this$dbtPackageName = this.getDbtPackageName();
        String other$dbtPackageName = other.getDbtPackageName();
        if (this$dbtPackageName == null ? other$dbtPackageName != null : !this$dbtPackageName.equals(other$dbtPackageName)) {
            return false;
        }
        String this$dbtProjectName = this.getDbtProjectName();
        String other$dbtProjectName = other.getDbtProjectName();
        if (this$dbtProjectName == null ? other$dbtProjectName != null : !this$dbtProjectName.equals(other$dbtProjectName)) {
            return false;
        }
        String this$dbtSemanticLayerProxyUrl = this.getDbtSemanticLayerProxyUrl();
        String other$dbtSemanticLayerProxyUrl = other.getDbtSemanticLayerProxyUrl();
        if (this$dbtSemanticLayerProxyUrl == null ? other$dbtSemanticLayerProxyUrl != null : !this$dbtSemanticLayerProxyUrl.equals(other$dbtSemanticLayerProxyUrl)) {
            return false;
        }
        SortedSet<IDbtSource> this$dbtSources = this.getDbtSources();
        SortedSet<IDbtSource> other$dbtSources = other.getDbtSources();
        if (this$dbtSources == null ? other$dbtSources != null : !this$dbtSources.equals(other$dbtSources)) {
            return false;
        }
        SortedSet<String> this$dbtTags = this.getDbtTags();
        SortedSet<String> other$dbtTags = other.getDbtTags();
        if (this$dbtTags == null ? other$dbtTags != null : !this$dbtTags.equals(other$dbtTags)) {
            return false;
        }
        String this$dbtTestCompiledCode = this.getDbtTestCompiledCode();
        String other$dbtTestCompiledCode = other.getDbtTestCompiledCode();
        if (this$dbtTestCompiledCode == null ? other$dbtTestCompiledCode != null : !this$dbtTestCompiledCode.equals(other$dbtTestCompiledCode)) {
            return false;
        }
        String this$dbtTestCompiledSQL = this.getDbtTestCompiledSQL();
        String other$dbtTestCompiledSQL = other.getDbtTestCompiledSQL();
        if (this$dbtTestCompiledSQL == null ? other$dbtTestCompiledSQL != null : !this$dbtTestCompiledSQL.equals(other$dbtTestCompiledSQL)) {
            return false;
        }
        String this$dbtTestError = this.getDbtTestError();
        String other$dbtTestError = other.getDbtTestError();
        if (this$dbtTestError == null ? other$dbtTestError != null : !this$dbtTestError.equals(other$dbtTestError)) {
            return false;
        }
        String this$dbtTestLanguage = this.getDbtTestLanguage();
        String other$dbtTestLanguage = other.getDbtTestLanguage();
        if (this$dbtTestLanguage == null ? other$dbtTestLanguage != null : !this$dbtTestLanguage.equals(other$dbtTestLanguage)) {
            return false;
        }
        String this$dbtTestRawCode = this.getDbtTestRawCode();
        String other$dbtTestRawCode = other.getDbtTestRawCode();
        if (this$dbtTestRawCode == null ? other$dbtTestRawCode != null : !this$dbtTestRawCode.equals(other$dbtTestRawCode)) {
            return false;
        }
        String this$dbtTestRawSQL = this.getDbtTestRawSQL();
        String other$dbtTestRawSQL = other.getDbtTestRawSQL();
        if (this$dbtTestRawSQL == null ? other$dbtTestRawSQL != null : !this$dbtTestRawSQL.equals(other$dbtTestRawSQL)) {
            return false;
        }
        String this$dbtTestState = this.getDbtTestState();
        String other$dbtTestState = other.getDbtTestState();
        if (this$dbtTestState == null ? other$dbtTestState != null : !this$dbtTestState.equals(other$dbtTestState)) {
            return false;
        }
        String this$dbtTestStatus = this.getDbtTestStatus();
        String other$dbtTestStatus = other.getDbtTestStatus();
        if (this$dbtTestStatus == null ? other$dbtTestStatus != null : !this$dbtTestStatus.equals(other$dbtTestStatus)) {
            return false;
        }
        String this$dbtUniqueId = this.getDbtUniqueId();
        String other$dbtUniqueId = other.getDbtUniqueId();
        if (this$dbtUniqueId == null ? other$dbtUniqueId != null : !this$dbtUniqueId.equals(other$dbtUniqueId)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        SortedSet<ISQL> this$sqlAssets = this.getSqlAssets();
        SortedSet<ISQL> other$sqlAssets = other.getSqlAssets();
        return !(this$sqlAssets == null ? other$sqlAssets != null : !this$sqlAssets.equals(other$sqlAssets));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DbtTest;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $dbtJobLastRun = this.getDbtJobLastRun();
        result = result * 59 + ($dbtJobLastRun == null ? 43 : ((Object)$dbtJobLastRun).hashCode());
        Long $dbtJobNextRun = this.getDbtJobNextRun();
        result = result * 59 + ($dbtJobNextRun == null ? 43 : ((Object)$dbtJobNextRun).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $dbtAccountName = this.getDbtAccountName();
        result = result * 59 + ($dbtAccountName == null ? 43 : $dbtAccountName.hashCode());
        String $dbtAlias = this.getDbtAlias();
        result = result * 59 + ($dbtAlias == null ? 43 : $dbtAlias.hashCode());
        String $dbtConnectionContext = this.getDbtConnectionContext();
        result = result * 59 + ($dbtConnectionContext == null ? 43 : $dbtConnectionContext.hashCode());
        String $dbtEnvironmentDbtVersion = this.getDbtEnvironmentDbtVersion();
        result = result * 59 + ($dbtEnvironmentDbtVersion == null ? 43 : $dbtEnvironmentDbtVersion.hashCode());
        String $dbtEnvironmentName = this.getDbtEnvironmentName();
        result = result * 59 + ($dbtEnvironmentName == null ? 43 : $dbtEnvironmentName.hashCode());
        String $dbtJobName = this.getDbtJobName();
        result = result * 59 + ($dbtJobName == null ? 43 : $dbtJobName.hashCode());
        String $dbtJobNextRunHumanized = this.getDbtJobNextRunHumanized();
        result = result * 59 + ($dbtJobNextRunHumanized == null ? 43 : $dbtJobNextRunHumanized.hashCode());
        List<DbtJobRun> $dbtJobRuns = this.getDbtJobRuns();
        result = result * 59 + ($dbtJobRuns == null ? 43 : ((Object)$dbtJobRuns).hashCode());
        String $dbtJobSchedule = this.getDbtJobSchedule();
        result = result * 59 + ($dbtJobSchedule == null ? 43 : $dbtJobSchedule.hashCode());
        String $dbtJobScheduleCronHumanized = this.getDbtJobScheduleCronHumanized();
        result = result * 59 + ($dbtJobScheduleCronHumanized == null ? 43 : $dbtJobScheduleCronHumanized.hashCode());
        String $dbtJobStatus = this.getDbtJobStatus();
        result = result * 59 + ($dbtJobStatus == null ? 43 : $dbtJobStatus.hashCode());
        String $dbtMeta = this.getDbtMeta();
        result = result * 59 + ($dbtMeta == null ? 43 : $dbtMeta.hashCode());
        SortedSet<IDbtModelColumn> $dbtModelColumns = this.getDbtModelColumns();
        result = result * 59 + ($dbtModelColumns == null ? 43 : $dbtModelColumns.hashCode());
        SortedSet<IDbtModel> $dbtModels = this.getDbtModels();
        result = result * 59 + ($dbtModels == null ? 43 : $dbtModels.hashCode());
        String $dbtPackageName = this.getDbtPackageName();
        result = result * 59 + ($dbtPackageName == null ? 43 : $dbtPackageName.hashCode());
        String $dbtProjectName = this.getDbtProjectName();
        result = result * 59 + ($dbtProjectName == null ? 43 : $dbtProjectName.hashCode());
        String $dbtSemanticLayerProxyUrl = this.getDbtSemanticLayerProxyUrl();
        result = result * 59 + ($dbtSemanticLayerProxyUrl == null ? 43 : $dbtSemanticLayerProxyUrl.hashCode());
        SortedSet<IDbtSource> $dbtSources = this.getDbtSources();
        result = result * 59 + ($dbtSources == null ? 43 : $dbtSources.hashCode());
        SortedSet<String> $dbtTags = this.getDbtTags();
        result = result * 59 + ($dbtTags == null ? 43 : $dbtTags.hashCode());
        String $dbtTestCompiledCode = this.getDbtTestCompiledCode();
        result = result * 59 + ($dbtTestCompiledCode == null ? 43 : $dbtTestCompiledCode.hashCode());
        String $dbtTestCompiledSQL = this.getDbtTestCompiledSQL();
        result = result * 59 + ($dbtTestCompiledSQL == null ? 43 : $dbtTestCompiledSQL.hashCode());
        String $dbtTestError = this.getDbtTestError();
        result = result * 59 + ($dbtTestError == null ? 43 : $dbtTestError.hashCode());
        String $dbtTestLanguage = this.getDbtTestLanguage();
        result = result * 59 + ($dbtTestLanguage == null ? 43 : $dbtTestLanguage.hashCode());
        String $dbtTestRawCode = this.getDbtTestRawCode();
        result = result * 59 + ($dbtTestRawCode == null ? 43 : $dbtTestRawCode.hashCode());
        String $dbtTestRawSQL = this.getDbtTestRawSQL();
        result = result * 59 + ($dbtTestRawSQL == null ? 43 : $dbtTestRawSQL.hashCode());
        String $dbtTestState = this.getDbtTestState();
        result = result * 59 + ($dbtTestState == null ? 43 : $dbtTestState.hashCode());
        String $dbtTestStatus = this.getDbtTestStatus();
        result = result * 59 + ($dbtTestStatus == null ? 43 : $dbtTestStatus.hashCode());
        String $dbtUniqueId = this.getDbtUniqueId();
        result = result * 59 + ($dbtUniqueId == null ? 43 : $dbtUniqueId.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        SortedSet<ISQL> $sqlAssets = this.getSqlAssets();
        result = result * 59 + ($sqlAssets == null ? 43 : $sqlAssets.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DbtTest(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", dbtAccountName=" + this.getDbtAccountName() + ", dbtAlias=" + this.getDbtAlias() + ", dbtConnectionContext=" + this.getDbtConnectionContext() + ", dbtEnvironmentDbtVersion=" + this.getDbtEnvironmentDbtVersion() + ", dbtEnvironmentName=" + this.getDbtEnvironmentName() + ", dbtJobLastRun=" + this.getDbtJobLastRun() + ", dbtJobName=" + this.getDbtJobName() + ", dbtJobNextRun=" + this.getDbtJobNextRun() + ", dbtJobNextRunHumanized=" + this.getDbtJobNextRunHumanized() + ", dbtJobRuns=" + this.getDbtJobRuns() + ", dbtJobSchedule=" + this.getDbtJobSchedule() + ", dbtJobScheduleCronHumanized=" + this.getDbtJobScheduleCronHumanized() + ", dbtJobStatus=" + this.getDbtJobStatus() + ", dbtMeta=" + this.getDbtMeta() + ", dbtModelColumns=" + this.getDbtModelColumns() + ", dbtModels=" + this.getDbtModels() + ", dbtPackageName=" + this.getDbtPackageName() + ", dbtProjectName=" + this.getDbtProjectName() + ", dbtSemanticLayerProxyUrl=" + this.getDbtSemanticLayerProxyUrl() + ", dbtSources=" + this.getDbtSources() + ", dbtTags=" + this.getDbtTags() + ", dbtTestCompiledCode=" + this.getDbtTestCompiledCode() + ", dbtTestCompiledSQL=" + this.getDbtTestCompiledSQL() + ", dbtTestError=" + this.getDbtTestError() + ", dbtTestLanguage=" + this.getDbtTestLanguage() + ", dbtTestRawCode=" + this.getDbtTestRawCode() + ", dbtTestRawSQL=" + this.getDbtTestRawSQL() + ", dbtTestState=" + this.getDbtTestState() + ", dbtTestStatus=" + this.getDbtTestStatus() + ", dbtUniqueId=" + this.getDbtUniqueId() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", sqlAssets=" + this.getSqlAssets() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class DbtTestBuilder<C extends DbtTest, B extends DbtTestBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String dbtAccountName;
        @Generated
        private String dbtAlias;
        @Generated
        private String dbtConnectionContext;
        @Generated
        private String dbtEnvironmentDbtVersion;
        @Generated
        private String dbtEnvironmentName;
        @Generated
        private Long dbtJobLastRun;
        @Generated
        private String dbtJobName;
        @Generated
        private Long dbtJobNextRun;
        @Generated
        private String dbtJobNextRunHumanized;
        @Generated
        private ArrayList<DbtJobRun> dbtJobRuns;
        @Generated
        private String dbtJobSchedule;
        @Generated
        private String dbtJobScheduleCronHumanized;
        @Generated
        private String dbtJobStatus;
        @Generated
        private String dbtMeta;
        @Generated
        private ArrayList<IDbtModelColumn> dbtModelColumns;
        @Generated
        private ArrayList<IDbtModel> dbtModels;
        @Generated
        private String dbtPackageName;
        @Generated
        private String dbtProjectName;
        @Generated
        private String dbtSemanticLayerProxyUrl;
        @Generated
        private ArrayList<IDbtSource> dbtSources;
        @Generated
        private ArrayList<String> dbtTags;
        @Generated
        private String dbtTestCompiledCode;
        @Generated
        private String dbtTestCompiledSQL;
        @Generated
        private String dbtTestError;
        @Generated
        private String dbtTestLanguage;
        @Generated
        private String dbtTestRawCode;
        @Generated
        private String dbtTestRawSQL;
        @Generated
        private String dbtTestState;
        @Generated
        private String dbtTestStatus;
        @Generated
        private String dbtUniqueId;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ArrayList<ISQL> sqlAssets;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DbtTestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DbtTest instance, DbtTestBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dbtAccountName(instance.dbtAccountName);
            b.dbtAlias(instance.dbtAlias);
            b.dbtConnectionContext(instance.dbtConnectionContext);
            b.dbtEnvironmentDbtVersion(instance.dbtEnvironmentDbtVersion);
            b.dbtEnvironmentName(instance.dbtEnvironmentName);
            b.dbtJobLastRun(instance.dbtJobLastRun);
            b.dbtJobName(instance.dbtJobName);
            b.dbtJobNextRun(instance.dbtJobNextRun);
            b.dbtJobNextRunHumanized(instance.dbtJobNextRunHumanized);
            b.dbtJobRuns(instance.dbtJobRuns == null ? Collections.emptyList() : instance.dbtJobRuns);
            b.dbtJobSchedule(instance.dbtJobSchedule);
            b.dbtJobScheduleCronHumanized(instance.dbtJobScheduleCronHumanized);
            b.dbtJobStatus(instance.dbtJobStatus);
            b.dbtMeta(instance.dbtMeta);
            b.dbtModelColumns(instance.dbtModelColumns == null ? Collections.emptySortedSet() : instance.dbtModelColumns);
            b.dbtModels(instance.dbtModels == null ? Collections.emptySortedSet() : instance.dbtModels);
            b.dbtPackageName(instance.dbtPackageName);
            b.dbtProjectName(instance.dbtProjectName);
            b.dbtSemanticLayerProxyUrl(instance.dbtSemanticLayerProxyUrl);
            b.dbtSources(instance.dbtSources == null ? Collections.emptySortedSet() : instance.dbtSources);
            b.dbtTags(instance.dbtTags == null ? Collections.emptySortedSet() : instance.dbtTags);
            b.dbtTestCompiledCode(instance.dbtTestCompiledCode);
            b.dbtTestCompiledSQL(instance.dbtTestCompiledSQL);
            b.dbtTestError(instance.dbtTestError);
            b.dbtTestLanguage(instance.dbtTestLanguage);
            b.dbtTestRawCode(instance.dbtTestRawCode);
            b.dbtTestRawSQL(instance.dbtTestRawSQL);
            b.dbtTestState(instance.dbtTestState);
            b.dbtTestStatus(instance.dbtTestStatus);
            b.dbtUniqueId(instance.dbtUniqueId);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.sqlAssets(instance.sqlAssets == null ? Collections.emptySortedSet() : instance.sqlAssets);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dbtAccountName(String dbtAccountName) {
            this.dbtAccountName = dbtAccountName;
            return (B)this.self();
        }

        @Generated
        public B dbtAlias(String dbtAlias) {
            this.dbtAlias = dbtAlias;
            return (B)this.self();
        }

        @Generated
        public B dbtConnectionContext(String dbtConnectionContext) {
            this.dbtConnectionContext = dbtConnectionContext;
            return (B)this.self();
        }

        @Generated
        public B dbtEnvironmentDbtVersion(String dbtEnvironmentDbtVersion) {
            this.dbtEnvironmentDbtVersion = dbtEnvironmentDbtVersion;
            return (B)this.self();
        }

        @Generated
        public B dbtEnvironmentName(String dbtEnvironmentName) {
            this.dbtEnvironmentName = dbtEnvironmentName;
            return (B)this.self();
        }

        @Generated
        public B dbtJobLastRun(Long dbtJobLastRun) {
            this.dbtJobLastRun = dbtJobLastRun;
            return (B)this.self();
        }

        @Generated
        public B dbtJobName(String dbtJobName) {
            this.dbtJobName = dbtJobName;
            return (B)this.self();
        }

        @Generated
        public B dbtJobNextRun(Long dbtJobNextRun) {
            this.dbtJobNextRun = dbtJobNextRun;
            return (B)this.self();
        }

        @Generated
        public B dbtJobNextRunHumanized(String dbtJobNextRunHumanized) {
            this.dbtJobNextRunHumanized = dbtJobNextRunHumanized;
            return (B)this.self();
        }

        @Generated
        public B dbtJobRun(DbtJobRun dbtJobRun) {
            if (this.dbtJobRuns == null) {
                this.dbtJobRuns = new ArrayList();
            }
            this.dbtJobRuns.add(dbtJobRun);
            return (B)this.self();
        }

        @Generated
        public B dbtJobRuns(Collection<? extends DbtJobRun> dbtJobRuns) {
            if (dbtJobRuns == null) {
                throw new NullPointerException("dbtJobRuns cannot be null");
            }
            if (this.dbtJobRuns == null) {
                this.dbtJobRuns = new ArrayList();
            }
            this.dbtJobRuns.addAll(dbtJobRuns);
            return (B)this.self();
        }

        @Generated
        public B clearDbtJobRuns() {
            if (this.dbtJobRuns != null) {
                this.dbtJobRuns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtJobSchedule(String dbtJobSchedule) {
            this.dbtJobSchedule = dbtJobSchedule;
            return (B)this.self();
        }

        @Generated
        public B dbtJobScheduleCronHumanized(String dbtJobScheduleCronHumanized) {
            this.dbtJobScheduleCronHumanized = dbtJobScheduleCronHumanized;
            return (B)this.self();
        }

        @Generated
        public B dbtJobStatus(String dbtJobStatus) {
            this.dbtJobStatus = dbtJobStatus;
            return (B)this.self();
        }

        @Generated
        public B dbtMeta(String dbtMeta) {
            this.dbtMeta = dbtMeta;
            return (B)this.self();
        }

        @Generated
        public B dbtModelColumn(IDbtModelColumn dbtModelColumn) {
            if (this.dbtModelColumns == null) {
                this.dbtModelColumns = new ArrayList();
            }
            this.dbtModelColumns.add(dbtModelColumn);
            return (B)this.self();
        }

        @Generated
        public B dbtModelColumns(Collection<? extends IDbtModelColumn> dbtModelColumns) {
            if (dbtModelColumns == null) {
                throw new NullPointerException("dbtModelColumns cannot be null");
            }
            if (this.dbtModelColumns == null) {
                this.dbtModelColumns = new ArrayList();
            }
            this.dbtModelColumns.addAll(dbtModelColumns);
            return (B)this.self();
        }

        @Generated
        public B clearDbtModelColumns() {
            if (this.dbtModelColumns != null) {
                this.dbtModelColumns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtModel(IDbtModel dbtModel) {
            if (this.dbtModels == null) {
                this.dbtModels = new ArrayList();
            }
            this.dbtModels.add(dbtModel);
            return (B)this.self();
        }

        @Generated
        public B dbtModels(Collection<? extends IDbtModel> dbtModels) {
            if (dbtModels == null) {
                throw new NullPointerException("dbtModels cannot be null");
            }
            if (this.dbtModels == null) {
                this.dbtModels = new ArrayList();
            }
            this.dbtModels.addAll(dbtModels);
            return (B)this.self();
        }

        @Generated
        public B clearDbtModels() {
            if (this.dbtModels != null) {
                this.dbtModels.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtPackageName(String dbtPackageName) {
            this.dbtPackageName = dbtPackageName;
            return (B)this.self();
        }

        @Generated
        public B dbtProjectName(String dbtProjectName) {
            this.dbtProjectName = dbtProjectName;
            return (B)this.self();
        }

        @Generated
        public B dbtSemanticLayerProxyUrl(String dbtSemanticLayerProxyUrl) {
            this.dbtSemanticLayerProxyUrl = dbtSemanticLayerProxyUrl;
            return (B)this.self();
        }

        @Generated
        public B dbtSource(IDbtSource dbtSource) {
            if (this.dbtSources == null) {
                this.dbtSources = new ArrayList();
            }
            this.dbtSources.add(dbtSource);
            return (B)this.self();
        }

        @Generated
        public B dbtSources(Collection<? extends IDbtSource> dbtSources) {
            if (dbtSources == null) {
                throw new NullPointerException("dbtSources cannot be null");
            }
            if (this.dbtSources == null) {
                this.dbtSources = new ArrayList();
            }
            this.dbtSources.addAll(dbtSources);
            return (B)this.self();
        }

        @Generated
        public B clearDbtSources() {
            if (this.dbtSources != null) {
                this.dbtSources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtTag(String dbtTag) {
            if (this.dbtTags == null) {
                this.dbtTags = new ArrayList();
            }
            this.dbtTags.add(dbtTag);
            return (B)this.self();
        }

        @Generated
        public B dbtTags(Collection<? extends String> dbtTags) {
            if (dbtTags == null) {
                throw new NullPointerException("dbtTags cannot be null");
            }
            if (this.dbtTags == null) {
                this.dbtTags = new ArrayList();
            }
            this.dbtTags.addAll(dbtTags);
            return (B)this.self();
        }

        @Generated
        public B clearDbtTags() {
            if (this.dbtTags != null) {
                this.dbtTags.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtTestCompiledCode(String dbtTestCompiledCode) {
            this.dbtTestCompiledCode = dbtTestCompiledCode;
            return (B)this.self();
        }

        @Generated
        public B dbtTestCompiledSQL(String dbtTestCompiledSQL) {
            this.dbtTestCompiledSQL = dbtTestCompiledSQL;
            return (B)this.self();
        }

        @Generated
        public B dbtTestError(String dbtTestError) {
            this.dbtTestError = dbtTestError;
            return (B)this.self();
        }

        @Generated
        public B dbtTestLanguage(String dbtTestLanguage) {
            this.dbtTestLanguage = dbtTestLanguage;
            return (B)this.self();
        }

        @Generated
        public B dbtTestRawCode(String dbtTestRawCode) {
            this.dbtTestRawCode = dbtTestRawCode;
            return (B)this.self();
        }

        @Generated
        public B dbtTestRawSQL(String dbtTestRawSQL) {
            this.dbtTestRawSQL = dbtTestRawSQL;
            return (B)this.self();
        }

        @Generated
        public B dbtTestState(String dbtTestState) {
            this.dbtTestState = dbtTestState;
            return (B)this.self();
        }

        @Generated
        public B dbtTestStatus(String dbtTestStatus) {
            this.dbtTestStatus = dbtTestStatus;
            return (B)this.self();
        }

        @Generated
        public B dbtUniqueId(String dbtUniqueId) {
            this.dbtUniqueId = dbtUniqueId;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sqlAsset(ISQL sqlAsset) {
            if (this.sqlAssets == null) {
                this.sqlAssets = new ArrayList();
            }
            this.sqlAssets.add(sqlAsset);
            return (B)this.self();
        }

        @Generated
        public B sqlAssets(Collection<? extends ISQL> sqlAssets) {
            if (sqlAssets == null) {
                throw new NullPointerException("sqlAssets cannot be null");
            }
            if (this.sqlAssets == null) {
                this.sqlAssets = new ArrayList();
            }
            this.sqlAssets.addAll(sqlAssets);
            return (B)this.self();
        }

        @Generated
        public B clearSqlAssets() {
            if (this.sqlAssets != null) {
                this.sqlAssets.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DbtTest.DbtTestBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dbtAccountName=" + this.dbtAccountName + ", dbtAlias=" + this.dbtAlias + ", dbtConnectionContext=" + this.dbtConnectionContext + ", dbtEnvironmentDbtVersion=" + this.dbtEnvironmentDbtVersion + ", dbtEnvironmentName=" + this.dbtEnvironmentName + ", dbtJobLastRun=" + this.dbtJobLastRun + ", dbtJobName=" + this.dbtJobName + ", dbtJobNextRun=" + this.dbtJobNextRun + ", dbtJobNextRunHumanized=" + this.dbtJobNextRunHumanized + ", dbtJobRuns=" + this.dbtJobRuns + ", dbtJobSchedule=" + this.dbtJobSchedule + ", dbtJobScheduleCronHumanized=" + this.dbtJobScheduleCronHumanized + ", dbtJobStatus=" + this.dbtJobStatus + ", dbtMeta=" + this.dbtMeta + ", dbtModelColumns=" + this.dbtModelColumns + ", dbtModels=" + this.dbtModels + ", dbtPackageName=" + this.dbtPackageName + ", dbtProjectName=" + this.dbtProjectName + ", dbtSemanticLayerProxyUrl=" + this.dbtSemanticLayerProxyUrl + ", dbtSources=" + this.dbtSources + ", dbtTags=" + this.dbtTags + ", dbtTestCompiledCode=" + this.dbtTestCompiledCode + ", dbtTestCompiledSQL=" + this.dbtTestCompiledSQL + ", dbtTestError=" + this.dbtTestError + ", dbtTestLanguage=" + this.dbtTestLanguage + ", dbtTestRawCode=" + this.dbtTestRawCode + ", dbtTestRawSQL=" + this.dbtTestRawSQL + ", dbtTestState=" + this.dbtTestState + ", dbtTestStatus=" + this.dbtTestStatus + ", dbtUniqueId=" + this.dbtUniqueId + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", sqlAssets=" + this.sqlAssets + ")";
        }
    }

    @Generated
    private static final class DbtTestBuilderImpl
    extends DbtTestBuilder<DbtTest, DbtTestBuilderImpl> {
        @Generated
        private DbtTestBuilderImpl() {
        }

        @Override
        @Generated
        protected DbtTestBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DbtTest build() {
            return new DbtTest(this);
        }
    }
}

