/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IAtlanQuery;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IColumn;
import com.atlan.model.assets.IDbtModel;
import com.atlan.model.assets.IDbtSource;
import com.atlan.model.assets.IDbtTest;
import com.atlan.model.assets.IDynamoDB;
import com.atlan.model.assets.IDynamoDBGlobalSecondaryIndex;
import com.atlan.model.assets.IDynamoDBSecondaryIndex;
import com.atlan.model.assets.IDynamoDBTable;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.INoSQL;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISQL;
import com.atlan.model.assets.ISchema;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.assets.ITable;
import com.atlan.model.assets.ITablePartition;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.DynamoDBSecondaryIndexProjectionType;
import com.atlan.model.enums.DynamoDBStatus;
import com.atlan.model.enums.TableType;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDBGlobalSecondaryIndex
extends Asset
implements IDynamoDBGlobalSecondaryIndex,
IDynamoDBSecondaryIndex,
ITable,
IDynamoDB,
ISQL,
ICatalog,
IAsset,
IReferenceable,
INoSQL {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamoDBGlobalSecondaryIndex.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DynamoDBGlobalSecondaryIndex";
    String typeName;
    @Attribute
    String alias;
    @Attribute
    String calculationViewName;
    @Attribute
    String calculationViewQualifiedName;
    @Attribute
    Long columnCount;
    @Attribute
    SortedSet<IColumn> columns;
    @Attribute
    String databaseName;
    @Attribute
    String databaseQualifiedName;
    @Attribute
    SortedSet<IDbtModel> dbtModels;
    @Attribute
    SortedSet<IDbtSource> dbtSources;
    @Attribute
    SortedSet<IDbtTest> dbtTests;
    @Attribute
    SortedSet<ITable> dimensions;
    @Attribute
    String dynamoDBPartitionKey;
    @Attribute
    Long dynamoDBReadCapacityUnits;
    @Attribute
    DynamoDBSecondaryIndexProjectionType dynamoDBSecondaryIndexProjectionType;
    @Attribute
    String dynamoDBSortKey;
    @Attribute
    DynamoDBStatus dynamoDBStatus;
    @Attribute
    IDynamoDBTable dynamoDBTable;
    @Attribute
    Long dynamoDBWriteCapacityUnits;
    @Attribute
    String externalLocation;
    @Attribute
    String externalLocationFormat;
    @Attribute
    String externalLocationRegion;
    @Attribute
    SortedSet<ITable> facts;
    @Attribute
    String icebergCatalogName;
    @Attribute
    String icebergCatalogSource;
    @Attribute
    String icebergCatalogTableName;
    @Attribute
    String icebergCatalogTableNamespace;
    @Attribute
    String icebergTableBaseLocation;
    @Attribute
    String icebergTableType;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    Boolean isPartitioned;
    @Attribute
    Boolean isProfiled;
    @Attribute
    Boolean isQueryPreview;
    @Attribute
    Boolean isSharded;
    @Attribute
    Boolean isTemporary;
    @Attribute
    @Date
    Long lastProfiledAt;
    @Attribute
    String noSQLSchemaDefinition;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    Long partitionCount;
    @Attribute
    String partitionList;
    @Attribute
    String partitionStrategy;
    @Attribute
    SortedSet<ITablePartition> partitions;
    @Attribute
    SortedSet<IAtlanQuery> queries;
    @Attribute
    Long queryCount;
    @Attribute
    @Date
    Long queryCountUpdatedAt;
    @Attribute
    Map<String, String> queryPreviewConfig;
    @Attribute
    Long queryUserCount;
    @Attribute
    Map<String, Long> queryUserMap;
    @Attribute
    Long rowCount;
    @Attribute
    @JsonProperty(value="atlanSchema")
    ISchema schema;
    @Attribute
    String schemaName;
    @Attribute
    String schemaQualifiedName;
    @Attribute
    Long sizeBytes;
    @Attribute
    SortedSet<IDbtSource> sqlDBTSources;
    @Attribute
    SortedSet<IDbtModel> sqlDbtModels;
    @Attribute
    String tableExternalVolumeName;
    @Attribute
    String tableName;
    @Attribute
    String tableQualifiedName;
    @Attribute
    Long tableRetentionTime;
    @Attribute
    TableType tableType;
    @Attribute
    String viewName;
    @Attribute
    String viewQualifiedName;

    @Override
    public DynamoDBGlobalSecondaryIndex trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return DynamoDBGlobalSecondaryIndex.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return DynamoDBGlobalSecondaryIndex.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return DynamoDBGlobalSecondaryIndex.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return DynamoDBGlobalSecondaryIndex.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return DynamoDBGlobalSecondaryIndex.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return DynamoDBGlobalSecondaryIndex.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static DynamoDBGlobalSecondaryIndex refByGuid(String guid) {
        return DynamoDBGlobalSecondaryIndex.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static DynamoDBGlobalSecondaryIndex refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((DynamoDBGlobalSecondaryIndexBuilder)((DynamoDBGlobalSecondaryIndexBuilder)DynamoDBGlobalSecondaryIndex._internal().guid(guid)).semantic(semantic)).build();
    }

    public static DynamoDBGlobalSecondaryIndex refByQualifiedName(String qualifiedName) {
        return DynamoDBGlobalSecondaryIndex.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static DynamoDBGlobalSecondaryIndex refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((DynamoDBGlobalSecondaryIndexBuilder)((DynamoDBGlobalSecondaryIndexBuilder)DynamoDBGlobalSecondaryIndex._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static DynamoDBGlobalSecondaryIndex get(String id) throws AtlanException {
        return DynamoDBGlobalSecondaryIndex.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static DynamoDBGlobalSecondaryIndex get(AtlanClient client, String id) throws AtlanException {
        return DynamoDBGlobalSecondaryIndex.get(client, id, true);
    }

    @JsonIgnore
    public static DynamoDBGlobalSecondaryIndex get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof DynamoDBGlobalSecondaryIndex) {
                return (DynamoDBGlobalSecondaryIndex)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof DynamoDBGlobalSecondaryIndex) {
            return (DynamoDBGlobalSecondaryIndex)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return DynamoDBGlobalSecondaryIndex.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static DynamoDBGlobalSecondaryIndexBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DynamoDBGlobalSecondaryIndexBuilder)((DynamoDBGlobalSecondaryIndexBuilder)((DynamoDBGlobalSecondaryIndexBuilder)DynamoDBGlobalSecondaryIndex._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public DynamoDBGlobalSecondaryIndexBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        DynamoDBGlobalSecondaryIndex.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return DynamoDBGlobalSecondaryIndex.updater(this.getQualifiedName(), this.getName());
    }

    public static DynamoDBGlobalSecondaryIndex removeDescription(String qualifiedName, String name) throws AtlanException {
        return DynamoDBGlobalSecondaryIndex.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DynamoDBGlobalSecondaryIndex removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DynamoDBGlobalSecondaryIndex)Asset.removeDescription(client, DynamoDBGlobalSecondaryIndex.updater(qualifiedName, name));
    }

    public static DynamoDBGlobalSecondaryIndex removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return DynamoDBGlobalSecondaryIndex.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DynamoDBGlobalSecondaryIndex removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DynamoDBGlobalSecondaryIndex)Asset.removeUserDescription(client, DynamoDBGlobalSecondaryIndex.updater(qualifiedName, name));
    }

    public static DynamoDBGlobalSecondaryIndex removeOwners(String qualifiedName, String name) throws AtlanException {
        return DynamoDBGlobalSecondaryIndex.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DynamoDBGlobalSecondaryIndex removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DynamoDBGlobalSecondaryIndex)Asset.removeOwners(client, DynamoDBGlobalSecondaryIndex.updater(qualifiedName, name));
    }

    public static DynamoDBGlobalSecondaryIndex updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return DynamoDBGlobalSecondaryIndex.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static DynamoDBGlobalSecondaryIndex updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (DynamoDBGlobalSecondaryIndex)Asset.updateCertificate(client, DynamoDBGlobalSecondaryIndex._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DynamoDBGlobalSecondaryIndex removeCertificate(String qualifiedName, String name) throws AtlanException {
        return DynamoDBGlobalSecondaryIndex.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DynamoDBGlobalSecondaryIndex removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DynamoDBGlobalSecondaryIndex)Asset.removeCertificate(client, DynamoDBGlobalSecondaryIndex.updater(qualifiedName, name));
    }

    public static DynamoDBGlobalSecondaryIndex updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return DynamoDBGlobalSecondaryIndex.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static DynamoDBGlobalSecondaryIndex updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DynamoDBGlobalSecondaryIndex)Asset.updateAnnouncement(client, DynamoDBGlobalSecondaryIndex._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DynamoDBGlobalSecondaryIndex removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return DynamoDBGlobalSecondaryIndex.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static DynamoDBGlobalSecondaryIndex removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (DynamoDBGlobalSecondaryIndex)Asset.removeAnnouncement(client, DynamoDBGlobalSecondaryIndex.updater(qualifiedName, name));
    }

    public static DynamoDBGlobalSecondaryIndex replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return DynamoDBGlobalSecondaryIndex.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static DynamoDBGlobalSecondaryIndex replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (DynamoDBGlobalSecondaryIndex)Asset.replaceTerms(client, DynamoDBGlobalSecondaryIndex.updater(qualifiedName, name), terms);
    }

    public static DynamoDBGlobalSecondaryIndex appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return DynamoDBGlobalSecondaryIndex.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static DynamoDBGlobalSecondaryIndex appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DynamoDBGlobalSecondaryIndex)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DynamoDBGlobalSecondaryIndex removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return DynamoDBGlobalSecondaryIndex.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static DynamoDBGlobalSecondaryIndex removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (DynamoDBGlobalSecondaryIndex)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static DynamoDBGlobalSecondaryIndex appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return DynamoDBGlobalSecondaryIndex.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static DynamoDBGlobalSecondaryIndex appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (DynamoDBGlobalSecondaryIndex)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static DynamoDBGlobalSecondaryIndex appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return DynamoDBGlobalSecondaryIndex.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static DynamoDBGlobalSecondaryIndex appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (DynamoDBGlobalSecondaryIndex)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        DynamoDBGlobalSecondaryIndex.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DynamoDBGlobalSecondaryIndex(DynamoDBGlobalSecondaryIndexBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> queryUserMap;
        Map<Object, Object> queryPreviewConfig;
        this.typeName = b.typeName$set ? b.typeName$value : DynamoDBGlobalSecondaryIndex.$default$typeName();
        this.alias = b.alias;
        this.calculationViewName = b.calculationViewName;
        this.calculationViewQualifiedName = b.calculationViewQualifiedName;
        this.columnCount = b.columnCount;
        SortedSet<IColumn> columns = new TreeSet<IColumn>();
        if (b.columns != null) {
            columns.addAll(b.columns);
        }
        columns = Collections.unmodifiableSortedSet(columns);
        this.columns = columns;
        this.databaseName = b.databaseName;
        this.databaseQualifiedName = b.databaseQualifiedName;
        SortedSet<IDbtModel> dbtModels = new TreeSet<IDbtModel>();
        if (b.dbtModels != null) {
            dbtModels.addAll(b.dbtModels);
        }
        dbtModels = Collections.unmodifiableSortedSet(dbtModels);
        this.dbtModels = dbtModels;
        SortedSet<IDbtSource> dbtSources = new TreeSet<IDbtSource>();
        if (b.dbtSources != null) {
            dbtSources.addAll(b.dbtSources);
        }
        dbtSources = Collections.unmodifiableSortedSet(dbtSources);
        this.dbtSources = dbtSources;
        SortedSet<IDbtTest> dbtTests = new TreeSet<IDbtTest>();
        if (b.dbtTests != null) {
            dbtTests.addAll(b.dbtTests);
        }
        dbtTests = Collections.unmodifiableSortedSet(dbtTests);
        this.dbtTests = dbtTests;
        SortedSet<ITable> dimensions = new TreeSet<ITable>();
        if (b.dimensions != null) {
            dimensions.addAll(b.dimensions);
        }
        dimensions = Collections.unmodifiableSortedSet(dimensions);
        this.dimensions = dimensions;
        this.dynamoDBPartitionKey = b.dynamoDBPartitionKey;
        this.dynamoDBReadCapacityUnits = b.dynamoDBReadCapacityUnits;
        this.dynamoDBSecondaryIndexProjectionType = b.dynamoDBSecondaryIndexProjectionType;
        this.dynamoDBSortKey = b.dynamoDBSortKey;
        this.dynamoDBStatus = b.dynamoDBStatus;
        this.dynamoDBTable = b.dynamoDBTable;
        this.dynamoDBWriteCapacityUnits = b.dynamoDBWriteCapacityUnits;
        this.externalLocation = b.externalLocation;
        this.externalLocationFormat = b.externalLocationFormat;
        this.externalLocationRegion = b.externalLocationRegion;
        SortedSet<ITable> facts = new TreeSet<ITable>();
        if (b.facts != null) {
            facts.addAll(b.facts);
        }
        facts = Collections.unmodifiableSortedSet(facts);
        this.facts = facts;
        this.icebergCatalogName = b.icebergCatalogName;
        this.icebergCatalogSource = b.icebergCatalogSource;
        this.icebergCatalogTableName = b.icebergCatalogTableName;
        this.icebergCatalogTableNamespace = b.icebergCatalogTableNamespace;
        this.icebergTableBaseLocation = b.icebergTableBaseLocation;
        this.icebergTableType = b.icebergTableType;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.isPartitioned = b.isPartitioned;
        this.isProfiled = b.isProfiled;
        this.isQueryPreview = b.isQueryPreview;
        this.isSharded = b.isSharded;
        this.isTemporary = b.isTemporary;
        this.lastProfiledAt = b.lastProfiledAt;
        this.noSQLSchemaDefinition = b.noSQLSchemaDefinition;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.partitionCount = b.partitionCount;
        this.partitionList = b.partitionList;
        this.partitionStrategy = b.partitionStrategy;
        SortedSet<ITablePartition> partitions = new TreeSet<ITablePartition>();
        if (b.partitions != null) {
            partitions.addAll(b.partitions);
        }
        partitions = Collections.unmodifiableSortedSet(partitions);
        this.partitions = partitions;
        SortedSet<IAtlanQuery> queries = new TreeSet<IAtlanQuery>();
        if (b.queries != null) {
            queries.addAll(b.queries);
        }
        queries = Collections.unmodifiableSortedSet(queries);
        this.queries = queries;
        this.queryCount = b.queryCount;
        this.queryCountUpdatedAt = b.queryCountUpdatedAt;
        switch (b.queryPreviewConfig$key == null ? 0 : b.queryPreviewConfig$key.size()) {
            case 0: {
                queryPreviewConfig = Collections.emptyMap();
                break;
            }
            case 1: {
                queryPreviewConfig = Collections.singletonMap(b.queryPreviewConfig$key.get(0), b.queryPreviewConfig$value.get(0));
                break;
            }
            default: {
                queryPreviewConfig = new LinkedHashMap(b.queryPreviewConfig$key.size() < 0x40000000 ? 1 + b.queryPreviewConfig$key.size() + (b.queryPreviewConfig$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.queryPreviewConfig$key.size(); ++$i) {
                    queryPreviewConfig.put(b.queryPreviewConfig$key.get($i), b.queryPreviewConfig$value.get($i));
                }
                queryPreviewConfig = Collections.unmodifiableMap(queryPreviewConfig);
            }
        }
        this.queryPreviewConfig = queryPreviewConfig;
        this.queryUserCount = b.queryUserCount;
        switch (b.queryUserMap$key == null ? 0 : b.queryUserMap$key.size()) {
            case 0: {
                queryUserMap = Collections.emptyMap();
                break;
            }
            case 1: {
                queryUserMap = Collections.singletonMap(b.queryUserMap$key.get(0), b.queryUserMap$value.get(0));
                break;
            }
            default: {
                queryUserMap = new LinkedHashMap(b.queryUserMap$key.size() < 0x40000000 ? 1 + b.queryUserMap$key.size() + (b.queryUserMap$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.queryUserMap$key.size(); ++$i) {
                    queryUserMap.put(b.queryUserMap$key.get($i), b.queryUserMap$value.get($i));
                }
                queryUserMap = Collections.unmodifiableMap(queryUserMap);
            }
        }
        this.queryUserMap = queryUserMap;
        this.rowCount = b.rowCount;
        this.schema = b.schema;
        this.schemaName = b.schemaName;
        this.schemaQualifiedName = b.schemaQualifiedName;
        this.sizeBytes = b.sizeBytes;
        SortedSet<IDbtSource> sqlDBTSources = new TreeSet<IDbtSource>();
        if (b.sqlDBTSources != null) {
            sqlDBTSources.addAll(b.sqlDBTSources);
        }
        sqlDBTSources = Collections.unmodifiableSortedSet(sqlDBTSources);
        this.sqlDBTSources = sqlDBTSources;
        SortedSet<IDbtModel> sqlDbtModels = new TreeSet<IDbtModel>();
        if (b.sqlDbtModels != null) {
            sqlDbtModels.addAll(b.sqlDbtModels);
        }
        sqlDbtModels = Collections.unmodifiableSortedSet(sqlDbtModels);
        this.sqlDbtModels = sqlDbtModels;
        this.tableExternalVolumeName = b.tableExternalVolumeName;
        this.tableName = b.tableName;
        this.tableQualifiedName = b.tableQualifiedName;
        this.tableRetentionTime = b.tableRetentionTime;
        this.tableType = b.tableType;
        this.viewName = b.viewName;
        this.viewQualifiedName = b.viewQualifiedName;
    }

    @Generated
    public static DynamoDBGlobalSecondaryIndexBuilder<?, ?> _internal() {
        return new DynamoDBGlobalSecondaryIndexBuilderImpl();
    }

    @Generated
    public DynamoDBGlobalSecondaryIndexBuilder<?, ?> toBuilder() {
        return new DynamoDBGlobalSecondaryIndexBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Override
    @Generated
    public String getCalculationViewName() {
        return this.calculationViewName;
    }

    @Override
    @Generated
    public String getCalculationViewQualifiedName() {
        return this.calculationViewQualifiedName;
    }

    @Override
    @Generated
    public Long getColumnCount() {
        return this.columnCount;
    }

    @Override
    @Generated
    public SortedSet<IColumn> getColumns() {
        return this.columns;
    }

    @Override
    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    @Generated
    public String getDatabaseQualifiedName() {
        return this.databaseQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IDbtModel> getDbtModels() {
        return this.dbtModels;
    }

    @Override
    @Generated
    public SortedSet<IDbtSource> getDbtSources() {
        return this.dbtSources;
    }

    @Override
    @Generated
    public SortedSet<IDbtTest> getDbtTests() {
        return this.dbtTests;
    }

    @Override
    @Generated
    public SortedSet<ITable> getDimensions() {
        return this.dimensions;
    }

    @Override
    @Generated
    public String getDynamoDBPartitionKey() {
        return this.dynamoDBPartitionKey;
    }

    @Override
    @Generated
    public Long getDynamoDBReadCapacityUnits() {
        return this.dynamoDBReadCapacityUnits;
    }

    @Override
    @Generated
    public DynamoDBSecondaryIndexProjectionType getDynamoDBSecondaryIndexProjectionType() {
        return this.dynamoDBSecondaryIndexProjectionType;
    }

    @Override
    @Generated
    public String getDynamoDBSortKey() {
        return this.dynamoDBSortKey;
    }

    @Override
    @Generated
    public DynamoDBStatus getDynamoDBStatus() {
        return this.dynamoDBStatus;
    }

    @Override
    @Generated
    public IDynamoDBTable getDynamoDBTable() {
        return this.dynamoDBTable;
    }

    @Override
    @Generated
    public Long getDynamoDBWriteCapacityUnits() {
        return this.dynamoDBWriteCapacityUnits;
    }

    @Override
    @Generated
    public String getExternalLocation() {
        return this.externalLocation;
    }

    @Override
    @Generated
    public String getExternalLocationFormat() {
        return this.externalLocationFormat;
    }

    @Override
    @Generated
    public String getExternalLocationRegion() {
        return this.externalLocationRegion;
    }

    @Override
    @Generated
    public SortedSet<ITable> getFacts() {
        return this.facts;
    }

    @Override
    @Generated
    public String getIcebergCatalogName() {
        return this.icebergCatalogName;
    }

    @Override
    @Generated
    public String getIcebergCatalogSource() {
        return this.icebergCatalogSource;
    }

    @Override
    @Generated
    public String getIcebergCatalogTableName() {
        return this.icebergCatalogTableName;
    }

    @Override
    @Generated
    public String getIcebergCatalogTableNamespace() {
        return this.icebergCatalogTableNamespace;
    }

    @Override
    @Generated
    public String getIcebergTableBaseLocation() {
        return this.icebergTableBaseLocation;
    }

    @Override
    @Generated
    public String getIcebergTableType() {
        return this.icebergTableType;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public Boolean getIsPartitioned() {
        return this.isPartitioned;
    }

    @Override
    @Generated
    public Boolean getIsProfiled() {
        return this.isProfiled;
    }

    @Override
    @Generated
    public Boolean getIsQueryPreview() {
        return this.isQueryPreview;
    }

    @Override
    @Generated
    public Boolean getIsSharded() {
        return this.isSharded;
    }

    @Override
    @Generated
    public Boolean getIsTemporary() {
        return this.isTemporary;
    }

    @Override
    @Generated
    public Long getLastProfiledAt() {
        return this.lastProfiledAt;
    }

    @Override
    @Generated
    public String getNoSQLSchemaDefinition() {
        return this.noSQLSchemaDefinition;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public Long getPartitionCount() {
        return this.partitionCount;
    }

    @Override
    @Generated
    public String getPartitionList() {
        return this.partitionList;
    }

    @Override
    @Generated
    public String getPartitionStrategy() {
        return this.partitionStrategy;
    }

    @Override
    @Generated
    public SortedSet<ITablePartition> getPartitions() {
        return this.partitions;
    }

    @Override
    @Generated
    public SortedSet<IAtlanQuery> getQueries() {
        return this.queries;
    }

    @Override
    @Generated
    public Long getQueryCount() {
        return this.queryCount;
    }

    @Override
    @Generated
    public Long getQueryCountUpdatedAt() {
        return this.queryCountUpdatedAt;
    }

    @Override
    @Generated
    public Map<String, String> getQueryPreviewConfig() {
        return this.queryPreviewConfig;
    }

    @Override
    @Generated
    public Long getQueryUserCount() {
        return this.queryUserCount;
    }

    @Override
    @Generated
    public Map<String, Long> getQueryUserMap() {
        return this.queryUserMap;
    }

    @Override
    @Generated
    public Long getRowCount() {
        return this.rowCount;
    }

    @Override
    @Generated
    public ISchema getSchema() {
        return this.schema;
    }

    @Override
    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    @Generated
    public String getSchemaQualifiedName() {
        return this.schemaQualifiedName;
    }

    @Override
    @Generated
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    @Override
    @Generated
    public SortedSet<IDbtSource> getSqlDBTSources() {
        return this.sqlDBTSources;
    }

    @Override
    @Generated
    public SortedSet<IDbtModel> getSqlDbtModels() {
        return this.sqlDbtModels;
    }

    @Override
    @Generated
    public String getTableExternalVolumeName() {
        return this.tableExternalVolumeName;
    }

    @Override
    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Override
    @Generated
    public String getTableQualifiedName() {
        return this.tableQualifiedName;
    }

    @Override
    @Generated
    public Long getTableRetentionTime() {
        return this.tableRetentionTime;
    }

    @Override
    @Generated
    public TableType getTableType() {
        return this.tableType;
    }

    @Override
    @Generated
    public String getViewName() {
        return this.viewName;
    }

    @Override
    @Generated
    public String getViewQualifiedName() {
        return this.viewQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamoDBGlobalSecondaryIndex)) {
            return false;
        }
        DynamoDBGlobalSecondaryIndex other = (DynamoDBGlobalSecondaryIndex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$columnCount = this.getColumnCount();
        Long other$columnCount = other.getColumnCount();
        if (this$columnCount == null ? other$columnCount != null : !((Object)this$columnCount).equals(other$columnCount)) {
            return false;
        }
        Long this$dynamoDBReadCapacityUnits = this.getDynamoDBReadCapacityUnits();
        Long other$dynamoDBReadCapacityUnits = other.getDynamoDBReadCapacityUnits();
        if (this$dynamoDBReadCapacityUnits == null ? other$dynamoDBReadCapacityUnits != null : !((Object)this$dynamoDBReadCapacityUnits).equals(other$dynamoDBReadCapacityUnits)) {
            return false;
        }
        Long this$dynamoDBWriteCapacityUnits = this.getDynamoDBWriteCapacityUnits();
        Long other$dynamoDBWriteCapacityUnits = other.getDynamoDBWriteCapacityUnits();
        if (this$dynamoDBWriteCapacityUnits == null ? other$dynamoDBWriteCapacityUnits != null : !((Object)this$dynamoDBWriteCapacityUnits).equals(other$dynamoDBWriteCapacityUnits)) {
            return false;
        }
        Boolean this$isPartitioned = this.getIsPartitioned();
        Boolean other$isPartitioned = other.getIsPartitioned();
        if (this$isPartitioned == null ? other$isPartitioned != null : !((Object)this$isPartitioned).equals(other$isPartitioned)) {
            return false;
        }
        Boolean this$isProfiled = this.getIsProfiled();
        Boolean other$isProfiled = other.getIsProfiled();
        if (this$isProfiled == null ? other$isProfiled != null : !((Object)this$isProfiled).equals(other$isProfiled)) {
            return false;
        }
        Boolean this$isQueryPreview = this.getIsQueryPreview();
        Boolean other$isQueryPreview = other.getIsQueryPreview();
        if (this$isQueryPreview == null ? other$isQueryPreview != null : !((Object)this$isQueryPreview).equals(other$isQueryPreview)) {
            return false;
        }
        Boolean this$isSharded = this.getIsSharded();
        Boolean other$isSharded = other.getIsSharded();
        if (this$isSharded == null ? other$isSharded != null : !((Object)this$isSharded).equals(other$isSharded)) {
            return false;
        }
        Boolean this$isTemporary = this.getIsTemporary();
        Boolean other$isTemporary = other.getIsTemporary();
        if (this$isTemporary == null ? other$isTemporary != null : !((Object)this$isTemporary).equals(other$isTemporary)) {
            return false;
        }
        Long this$lastProfiledAt = this.getLastProfiledAt();
        Long other$lastProfiledAt = other.getLastProfiledAt();
        if (this$lastProfiledAt == null ? other$lastProfiledAt != null : !((Object)this$lastProfiledAt).equals(other$lastProfiledAt)) {
            return false;
        }
        Long this$partitionCount = this.getPartitionCount();
        Long other$partitionCount = other.getPartitionCount();
        if (this$partitionCount == null ? other$partitionCount != null : !((Object)this$partitionCount).equals(other$partitionCount)) {
            return false;
        }
        Long this$queryCount = this.getQueryCount();
        Long other$queryCount = other.getQueryCount();
        if (this$queryCount == null ? other$queryCount != null : !((Object)this$queryCount).equals(other$queryCount)) {
            return false;
        }
        Long this$queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        Long other$queryCountUpdatedAt = other.getQueryCountUpdatedAt();
        if (this$queryCountUpdatedAt == null ? other$queryCountUpdatedAt != null : !((Object)this$queryCountUpdatedAt).equals(other$queryCountUpdatedAt)) {
            return false;
        }
        Long this$queryUserCount = this.getQueryUserCount();
        Long other$queryUserCount = other.getQueryUserCount();
        if (this$queryUserCount == null ? other$queryUserCount != null : !((Object)this$queryUserCount).equals(other$queryUserCount)) {
            return false;
        }
        Long this$rowCount = this.getRowCount();
        Long other$rowCount = other.getRowCount();
        if (this$rowCount == null ? other$rowCount != null : !((Object)this$rowCount).equals(other$rowCount)) {
            return false;
        }
        Long this$sizeBytes = this.getSizeBytes();
        Long other$sizeBytes = other.getSizeBytes();
        if (this$sizeBytes == null ? other$sizeBytes != null : !((Object)this$sizeBytes).equals(other$sizeBytes)) {
            return false;
        }
        Long this$tableRetentionTime = this.getTableRetentionTime();
        Long other$tableRetentionTime = other.getTableRetentionTime();
        if (this$tableRetentionTime == null ? other$tableRetentionTime != null : !((Object)this$tableRetentionTime).equals(other$tableRetentionTime)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$calculationViewName = this.getCalculationViewName();
        String other$calculationViewName = other.getCalculationViewName();
        if (this$calculationViewName == null ? other$calculationViewName != null : !this$calculationViewName.equals(other$calculationViewName)) {
            return false;
        }
        String this$calculationViewQualifiedName = this.getCalculationViewQualifiedName();
        String other$calculationViewQualifiedName = other.getCalculationViewQualifiedName();
        if (this$calculationViewQualifiedName == null ? other$calculationViewQualifiedName != null : !this$calculationViewQualifiedName.equals(other$calculationViewQualifiedName)) {
            return false;
        }
        SortedSet<IColumn> this$columns = this.getColumns();
        SortedSet<IColumn> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$databaseQualifiedName = this.getDatabaseQualifiedName();
        String other$databaseQualifiedName = other.getDatabaseQualifiedName();
        if (this$databaseQualifiedName == null ? other$databaseQualifiedName != null : !this$databaseQualifiedName.equals(other$databaseQualifiedName)) {
            return false;
        }
        SortedSet<IDbtModel> this$dbtModels = this.getDbtModels();
        SortedSet<IDbtModel> other$dbtModels = other.getDbtModels();
        if (this$dbtModels == null ? other$dbtModels != null : !this$dbtModels.equals(other$dbtModels)) {
            return false;
        }
        SortedSet<IDbtSource> this$dbtSources = this.getDbtSources();
        SortedSet<IDbtSource> other$dbtSources = other.getDbtSources();
        if (this$dbtSources == null ? other$dbtSources != null : !this$dbtSources.equals(other$dbtSources)) {
            return false;
        }
        SortedSet<IDbtTest> this$dbtTests = this.getDbtTests();
        SortedSet<IDbtTest> other$dbtTests = other.getDbtTests();
        if (this$dbtTests == null ? other$dbtTests != null : !this$dbtTests.equals(other$dbtTests)) {
            return false;
        }
        SortedSet<ITable> this$dimensions = this.getDimensions();
        SortedSet<ITable> other$dimensions = other.getDimensions();
        if (this$dimensions == null ? other$dimensions != null : !this$dimensions.equals(other$dimensions)) {
            return false;
        }
        String this$dynamoDBPartitionKey = this.getDynamoDBPartitionKey();
        String other$dynamoDBPartitionKey = other.getDynamoDBPartitionKey();
        if (this$dynamoDBPartitionKey == null ? other$dynamoDBPartitionKey != null : !this$dynamoDBPartitionKey.equals(other$dynamoDBPartitionKey)) {
            return false;
        }
        DynamoDBSecondaryIndexProjectionType this$dynamoDBSecondaryIndexProjectionType = this.getDynamoDBSecondaryIndexProjectionType();
        DynamoDBSecondaryIndexProjectionType other$dynamoDBSecondaryIndexProjectionType = other.getDynamoDBSecondaryIndexProjectionType();
        if (this$dynamoDBSecondaryIndexProjectionType == null ? other$dynamoDBSecondaryIndexProjectionType != null : !this$dynamoDBSecondaryIndexProjectionType.equals(other$dynamoDBSecondaryIndexProjectionType)) {
            return false;
        }
        String this$dynamoDBSortKey = this.getDynamoDBSortKey();
        String other$dynamoDBSortKey = other.getDynamoDBSortKey();
        if (this$dynamoDBSortKey == null ? other$dynamoDBSortKey != null : !this$dynamoDBSortKey.equals(other$dynamoDBSortKey)) {
            return false;
        }
        DynamoDBStatus this$dynamoDBStatus = this.getDynamoDBStatus();
        DynamoDBStatus other$dynamoDBStatus = other.getDynamoDBStatus();
        if (this$dynamoDBStatus == null ? other$dynamoDBStatus != null : !this$dynamoDBStatus.equals(other$dynamoDBStatus)) {
            return false;
        }
        IDynamoDBTable this$dynamoDBTable = this.getDynamoDBTable();
        IDynamoDBTable other$dynamoDBTable = other.getDynamoDBTable();
        if (this$dynamoDBTable == null ? other$dynamoDBTable != null : !this$dynamoDBTable.equals(other$dynamoDBTable)) {
            return false;
        }
        String this$externalLocation = this.getExternalLocation();
        String other$externalLocation = other.getExternalLocation();
        if (this$externalLocation == null ? other$externalLocation != null : !this$externalLocation.equals(other$externalLocation)) {
            return false;
        }
        String this$externalLocationFormat = this.getExternalLocationFormat();
        String other$externalLocationFormat = other.getExternalLocationFormat();
        if (this$externalLocationFormat == null ? other$externalLocationFormat != null : !this$externalLocationFormat.equals(other$externalLocationFormat)) {
            return false;
        }
        String this$externalLocationRegion = this.getExternalLocationRegion();
        String other$externalLocationRegion = other.getExternalLocationRegion();
        if (this$externalLocationRegion == null ? other$externalLocationRegion != null : !this$externalLocationRegion.equals(other$externalLocationRegion)) {
            return false;
        }
        SortedSet<ITable> this$facts = this.getFacts();
        SortedSet<ITable> other$facts = other.getFacts();
        if (this$facts == null ? other$facts != null : !this$facts.equals(other$facts)) {
            return false;
        }
        String this$icebergCatalogName = this.getIcebergCatalogName();
        String other$icebergCatalogName = other.getIcebergCatalogName();
        if (this$icebergCatalogName == null ? other$icebergCatalogName != null : !this$icebergCatalogName.equals(other$icebergCatalogName)) {
            return false;
        }
        String this$icebergCatalogSource = this.getIcebergCatalogSource();
        String other$icebergCatalogSource = other.getIcebergCatalogSource();
        if (this$icebergCatalogSource == null ? other$icebergCatalogSource != null : !this$icebergCatalogSource.equals(other$icebergCatalogSource)) {
            return false;
        }
        String this$icebergCatalogTableName = this.getIcebergCatalogTableName();
        String other$icebergCatalogTableName = other.getIcebergCatalogTableName();
        if (this$icebergCatalogTableName == null ? other$icebergCatalogTableName != null : !this$icebergCatalogTableName.equals(other$icebergCatalogTableName)) {
            return false;
        }
        String this$icebergCatalogTableNamespace = this.getIcebergCatalogTableNamespace();
        String other$icebergCatalogTableNamespace = other.getIcebergCatalogTableNamespace();
        if (this$icebergCatalogTableNamespace == null ? other$icebergCatalogTableNamespace != null : !this$icebergCatalogTableNamespace.equals(other$icebergCatalogTableNamespace)) {
            return false;
        }
        String this$icebergTableBaseLocation = this.getIcebergTableBaseLocation();
        String other$icebergTableBaseLocation = other.getIcebergTableBaseLocation();
        if (this$icebergTableBaseLocation == null ? other$icebergTableBaseLocation != null : !this$icebergTableBaseLocation.equals(other$icebergTableBaseLocation)) {
            return false;
        }
        String this$icebergTableType = this.getIcebergTableType();
        String other$icebergTableType = other.getIcebergTableType();
        if (this$icebergTableType == null ? other$icebergTableType != null : !this$icebergTableType.equals(other$icebergTableType)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        String this$noSQLSchemaDefinition = this.getNoSQLSchemaDefinition();
        String other$noSQLSchemaDefinition = other.getNoSQLSchemaDefinition();
        if (this$noSQLSchemaDefinition == null ? other$noSQLSchemaDefinition != null : !this$noSQLSchemaDefinition.equals(other$noSQLSchemaDefinition)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        String this$partitionList = this.getPartitionList();
        String other$partitionList = other.getPartitionList();
        if (this$partitionList == null ? other$partitionList != null : !this$partitionList.equals(other$partitionList)) {
            return false;
        }
        String this$partitionStrategy = this.getPartitionStrategy();
        String other$partitionStrategy = other.getPartitionStrategy();
        if (this$partitionStrategy == null ? other$partitionStrategy != null : !this$partitionStrategy.equals(other$partitionStrategy)) {
            return false;
        }
        SortedSet<ITablePartition> this$partitions = this.getPartitions();
        SortedSet<ITablePartition> other$partitions = other.getPartitions();
        if (this$partitions == null ? other$partitions != null : !this$partitions.equals(other$partitions)) {
            return false;
        }
        SortedSet<IAtlanQuery> this$queries = this.getQueries();
        SortedSet<IAtlanQuery> other$queries = other.getQueries();
        if (this$queries == null ? other$queries != null : !this$queries.equals(other$queries)) {
            return false;
        }
        Map<String, String> this$queryPreviewConfig = this.getQueryPreviewConfig();
        Map<String, String> other$queryPreviewConfig = other.getQueryPreviewConfig();
        if (this$queryPreviewConfig == null ? other$queryPreviewConfig != null : !((Object)this$queryPreviewConfig).equals(other$queryPreviewConfig)) {
            return false;
        }
        Map<String, Long> this$queryUserMap = this.getQueryUserMap();
        Map<String, Long> other$queryUserMap = other.getQueryUserMap();
        if (this$queryUserMap == null ? other$queryUserMap != null : !((Object)this$queryUserMap).equals(other$queryUserMap)) {
            return false;
        }
        ISchema this$schema = this.getSchema();
        ISchema other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$schemaQualifiedName = this.getSchemaQualifiedName();
        String other$schemaQualifiedName = other.getSchemaQualifiedName();
        if (this$schemaQualifiedName == null ? other$schemaQualifiedName != null : !this$schemaQualifiedName.equals(other$schemaQualifiedName)) {
            return false;
        }
        SortedSet<IDbtSource> this$sqlDBTSources = this.getSqlDBTSources();
        SortedSet<IDbtSource> other$sqlDBTSources = other.getSqlDBTSources();
        if (this$sqlDBTSources == null ? other$sqlDBTSources != null : !this$sqlDBTSources.equals(other$sqlDBTSources)) {
            return false;
        }
        SortedSet<IDbtModel> this$sqlDbtModels = this.getSqlDbtModels();
        SortedSet<IDbtModel> other$sqlDbtModels = other.getSqlDbtModels();
        if (this$sqlDbtModels == null ? other$sqlDbtModels != null : !this$sqlDbtModels.equals(other$sqlDbtModels)) {
            return false;
        }
        String this$tableExternalVolumeName = this.getTableExternalVolumeName();
        String other$tableExternalVolumeName = other.getTableExternalVolumeName();
        if (this$tableExternalVolumeName == null ? other$tableExternalVolumeName != null : !this$tableExternalVolumeName.equals(other$tableExternalVolumeName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$tableQualifiedName = this.getTableQualifiedName();
        String other$tableQualifiedName = other.getTableQualifiedName();
        if (this$tableQualifiedName == null ? other$tableQualifiedName != null : !this$tableQualifiedName.equals(other$tableQualifiedName)) {
            return false;
        }
        TableType this$tableType = this.getTableType();
        TableType other$tableType = other.getTableType();
        if (this$tableType == null ? other$tableType != null : !this$tableType.equals(other$tableType)) {
            return false;
        }
        String this$viewName = this.getViewName();
        String other$viewName = other.getViewName();
        if (this$viewName == null ? other$viewName != null : !this$viewName.equals(other$viewName)) {
            return false;
        }
        String this$viewQualifiedName = this.getViewQualifiedName();
        String other$viewQualifiedName = other.getViewQualifiedName();
        return !(this$viewQualifiedName == null ? other$viewQualifiedName != null : !this$viewQualifiedName.equals(other$viewQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DynamoDBGlobalSecondaryIndex;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $columnCount = this.getColumnCount();
        result = result * 59 + ($columnCount == null ? 43 : ((Object)$columnCount).hashCode());
        Long $dynamoDBReadCapacityUnits = this.getDynamoDBReadCapacityUnits();
        result = result * 59 + ($dynamoDBReadCapacityUnits == null ? 43 : ((Object)$dynamoDBReadCapacityUnits).hashCode());
        Long $dynamoDBWriteCapacityUnits = this.getDynamoDBWriteCapacityUnits();
        result = result * 59 + ($dynamoDBWriteCapacityUnits == null ? 43 : ((Object)$dynamoDBWriteCapacityUnits).hashCode());
        Boolean $isPartitioned = this.getIsPartitioned();
        result = result * 59 + ($isPartitioned == null ? 43 : ((Object)$isPartitioned).hashCode());
        Boolean $isProfiled = this.getIsProfiled();
        result = result * 59 + ($isProfiled == null ? 43 : ((Object)$isProfiled).hashCode());
        Boolean $isQueryPreview = this.getIsQueryPreview();
        result = result * 59 + ($isQueryPreview == null ? 43 : ((Object)$isQueryPreview).hashCode());
        Boolean $isSharded = this.getIsSharded();
        result = result * 59 + ($isSharded == null ? 43 : ((Object)$isSharded).hashCode());
        Boolean $isTemporary = this.getIsTemporary();
        result = result * 59 + ($isTemporary == null ? 43 : ((Object)$isTemporary).hashCode());
        Long $lastProfiledAt = this.getLastProfiledAt();
        result = result * 59 + ($lastProfiledAt == null ? 43 : ((Object)$lastProfiledAt).hashCode());
        Long $partitionCount = this.getPartitionCount();
        result = result * 59 + ($partitionCount == null ? 43 : ((Object)$partitionCount).hashCode());
        Long $queryCount = this.getQueryCount();
        result = result * 59 + ($queryCount == null ? 43 : ((Object)$queryCount).hashCode());
        Long $queryCountUpdatedAt = this.getQueryCountUpdatedAt();
        result = result * 59 + ($queryCountUpdatedAt == null ? 43 : ((Object)$queryCountUpdatedAt).hashCode());
        Long $queryUserCount = this.getQueryUserCount();
        result = result * 59 + ($queryUserCount == null ? 43 : ((Object)$queryUserCount).hashCode());
        Long $rowCount = this.getRowCount();
        result = result * 59 + ($rowCount == null ? 43 : ((Object)$rowCount).hashCode());
        Long $sizeBytes = this.getSizeBytes();
        result = result * 59 + ($sizeBytes == null ? 43 : ((Object)$sizeBytes).hashCode());
        Long $tableRetentionTime = this.getTableRetentionTime();
        result = result * 59 + ($tableRetentionTime == null ? 43 : ((Object)$tableRetentionTime).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $calculationViewName = this.getCalculationViewName();
        result = result * 59 + ($calculationViewName == null ? 43 : $calculationViewName.hashCode());
        String $calculationViewQualifiedName = this.getCalculationViewQualifiedName();
        result = result * 59 + ($calculationViewQualifiedName == null ? 43 : $calculationViewQualifiedName.hashCode());
        SortedSet<IColumn> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : $columns.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $databaseQualifiedName = this.getDatabaseQualifiedName();
        result = result * 59 + ($databaseQualifiedName == null ? 43 : $databaseQualifiedName.hashCode());
        SortedSet<IDbtModel> $dbtModels = this.getDbtModels();
        result = result * 59 + ($dbtModels == null ? 43 : $dbtModels.hashCode());
        SortedSet<IDbtSource> $dbtSources = this.getDbtSources();
        result = result * 59 + ($dbtSources == null ? 43 : $dbtSources.hashCode());
        SortedSet<IDbtTest> $dbtTests = this.getDbtTests();
        result = result * 59 + ($dbtTests == null ? 43 : $dbtTests.hashCode());
        SortedSet<ITable> $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : $dimensions.hashCode());
        String $dynamoDBPartitionKey = this.getDynamoDBPartitionKey();
        result = result * 59 + ($dynamoDBPartitionKey == null ? 43 : $dynamoDBPartitionKey.hashCode());
        DynamoDBSecondaryIndexProjectionType $dynamoDBSecondaryIndexProjectionType = this.getDynamoDBSecondaryIndexProjectionType();
        result = result * 59 + ($dynamoDBSecondaryIndexProjectionType == null ? 43 : $dynamoDBSecondaryIndexProjectionType.hashCode());
        String $dynamoDBSortKey = this.getDynamoDBSortKey();
        result = result * 59 + ($dynamoDBSortKey == null ? 43 : $dynamoDBSortKey.hashCode());
        DynamoDBStatus $dynamoDBStatus = this.getDynamoDBStatus();
        result = result * 59 + ($dynamoDBStatus == null ? 43 : $dynamoDBStatus.hashCode());
        IDynamoDBTable $dynamoDBTable = this.getDynamoDBTable();
        result = result * 59 + ($dynamoDBTable == null ? 43 : $dynamoDBTable.hashCode());
        String $externalLocation = this.getExternalLocation();
        result = result * 59 + ($externalLocation == null ? 43 : $externalLocation.hashCode());
        String $externalLocationFormat = this.getExternalLocationFormat();
        result = result * 59 + ($externalLocationFormat == null ? 43 : $externalLocationFormat.hashCode());
        String $externalLocationRegion = this.getExternalLocationRegion();
        result = result * 59 + ($externalLocationRegion == null ? 43 : $externalLocationRegion.hashCode());
        SortedSet<ITable> $facts = this.getFacts();
        result = result * 59 + ($facts == null ? 43 : $facts.hashCode());
        String $icebergCatalogName = this.getIcebergCatalogName();
        result = result * 59 + ($icebergCatalogName == null ? 43 : $icebergCatalogName.hashCode());
        String $icebergCatalogSource = this.getIcebergCatalogSource();
        result = result * 59 + ($icebergCatalogSource == null ? 43 : $icebergCatalogSource.hashCode());
        String $icebergCatalogTableName = this.getIcebergCatalogTableName();
        result = result * 59 + ($icebergCatalogTableName == null ? 43 : $icebergCatalogTableName.hashCode());
        String $icebergCatalogTableNamespace = this.getIcebergCatalogTableNamespace();
        result = result * 59 + ($icebergCatalogTableNamespace == null ? 43 : $icebergCatalogTableNamespace.hashCode());
        String $icebergTableBaseLocation = this.getIcebergTableBaseLocation();
        result = result * 59 + ($icebergTableBaseLocation == null ? 43 : $icebergTableBaseLocation.hashCode());
        String $icebergTableType = this.getIcebergTableType();
        result = result * 59 + ($icebergTableType == null ? 43 : $icebergTableType.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        String $noSQLSchemaDefinition = this.getNoSQLSchemaDefinition();
        result = result * 59 + ($noSQLSchemaDefinition == null ? 43 : $noSQLSchemaDefinition.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        String $partitionList = this.getPartitionList();
        result = result * 59 + ($partitionList == null ? 43 : $partitionList.hashCode());
        String $partitionStrategy = this.getPartitionStrategy();
        result = result * 59 + ($partitionStrategy == null ? 43 : $partitionStrategy.hashCode());
        SortedSet<ITablePartition> $partitions = this.getPartitions();
        result = result * 59 + ($partitions == null ? 43 : $partitions.hashCode());
        SortedSet<IAtlanQuery> $queries = this.getQueries();
        result = result * 59 + ($queries == null ? 43 : $queries.hashCode());
        Map<String, String> $queryPreviewConfig = this.getQueryPreviewConfig();
        result = result * 59 + ($queryPreviewConfig == null ? 43 : ((Object)$queryPreviewConfig).hashCode());
        Map<String, Long> $queryUserMap = this.getQueryUserMap();
        result = result * 59 + ($queryUserMap == null ? 43 : ((Object)$queryUserMap).hashCode());
        ISchema $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $schemaQualifiedName = this.getSchemaQualifiedName();
        result = result * 59 + ($schemaQualifiedName == null ? 43 : $schemaQualifiedName.hashCode());
        SortedSet<IDbtSource> $sqlDBTSources = this.getSqlDBTSources();
        result = result * 59 + ($sqlDBTSources == null ? 43 : $sqlDBTSources.hashCode());
        SortedSet<IDbtModel> $sqlDbtModels = this.getSqlDbtModels();
        result = result * 59 + ($sqlDbtModels == null ? 43 : $sqlDbtModels.hashCode());
        String $tableExternalVolumeName = this.getTableExternalVolumeName();
        result = result * 59 + ($tableExternalVolumeName == null ? 43 : $tableExternalVolumeName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $tableQualifiedName = this.getTableQualifiedName();
        result = result * 59 + ($tableQualifiedName == null ? 43 : $tableQualifiedName.hashCode());
        TableType $tableType = this.getTableType();
        result = result * 59 + ($tableType == null ? 43 : $tableType.hashCode());
        String $viewName = this.getViewName();
        result = result * 59 + ($viewName == null ? 43 : $viewName.hashCode());
        String $viewQualifiedName = this.getViewQualifiedName();
        result = result * 59 + ($viewQualifiedName == null ? 43 : $viewQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DynamoDBGlobalSecondaryIndex(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", alias=" + this.getAlias() + ", calculationViewName=" + this.getCalculationViewName() + ", calculationViewQualifiedName=" + this.getCalculationViewQualifiedName() + ", columnCount=" + this.getColumnCount() + ", columns=" + this.getColumns() + ", databaseName=" + this.getDatabaseName() + ", databaseQualifiedName=" + this.getDatabaseQualifiedName() + ", dbtModels=" + this.getDbtModels() + ", dbtSources=" + this.getDbtSources() + ", dbtTests=" + this.getDbtTests() + ", dimensions=" + this.getDimensions() + ", dynamoDBPartitionKey=" + this.getDynamoDBPartitionKey() + ", dynamoDBReadCapacityUnits=" + this.getDynamoDBReadCapacityUnits() + ", dynamoDBSecondaryIndexProjectionType=" + this.getDynamoDBSecondaryIndexProjectionType() + ", dynamoDBSortKey=" + this.getDynamoDBSortKey() + ", dynamoDBStatus=" + this.getDynamoDBStatus() + ", dynamoDBTable=" + this.getDynamoDBTable() + ", dynamoDBWriteCapacityUnits=" + this.getDynamoDBWriteCapacityUnits() + ", externalLocation=" + this.getExternalLocation() + ", externalLocationFormat=" + this.getExternalLocationFormat() + ", externalLocationRegion=" + this.getExternalLocationRegion() + ", facts=" + this.getFacts() + ", icebergCatalogName=" + this.getIcebergCatalogName() + ", icebergCatalogSource=" + this.getIcebergCatalogSource() + ", icebergCatalogTableName=" + this.getIcebergCatalogTableName() + ", icebergCatalogTableNamespace=" + this.getIcebergCatalogTableNamespace() + ", icebergTableBaseLocation=" + this.getIcebergTableBaseLocation() + ", icebergTableType=" + this.getIcebergTableType() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", isPartitioned=" + this.getIsPartitioned() + ", isProfiled=" + this.getIsProfiled() + ", isQueryPreview=" + this.getIsQueryPreview() + ", isSharded=" + this.getIsSharded() + ", isTemporary=" + this.getIsTemporary() + ", lastProfiledAt=" + this.getLastProfiledAt() + ", noSQLSchemaDefinition=" + this.getNoSQLSchemaDefinition() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", partitionCount=" + this.getPartitionCount() + ", partitionList=" + this.getPartitionList() + ", partitionStrategy=" + this.getPartitionStrategy() + ", partitions=" + this.getPartitions() + ", queries=" + this.getQueries() + ", queryCount=" + this.getQueryCount() + ", queryCountUpdatedAt=" + this.getQueryCountUpdatedAt() + ", queryPreviewConfig=" + this.getQueryPreviewConfig() + ", queryUserCount=" + this.getQueryUserCount() + ", queryUserMap=" + this.getQueryUserMap() + ", rowCount=" + this.getRowCount() + ", schema=" + this.getSchema() + ", schemaName=" + this.getSchemaName() + ", schemaQualifiedName=" + this.getSchemaQualifiedName() + ", sizeBytes=" + this.getSizeBytes() + ", sqlDBTSources=" + this.getSqlDBTSources() + ", sqlDbtModels=" + this.getSqlDbtModels() + ", tableExternalVolumeName=" + this.getTableExternalVolumeName() + ", tableName=" + this.getTableName() + ", tableQualifiedName=" + this.getTableQualifiedName() + ", tableRetentionTime=" + this.getTableRetentionTime() + ", tableType=" + this.getTableType() + ", viewName=" + this.getViewName() + ", viewQualifiedName=" + this.getViewQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class DynamoDBGlobalSecondaryIndexBuilder<C extends DynamoDBGlobalSecondaryIndex, B extends DynamoDBGlobalSecondaryIndexBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String alias;
        @Generated
        private String calculationViewName;
        @Generated
        private String calculationViewQualifiedName;
        @Generated
        private Long columnCount;
        @Generated
        private ArrayList<IColumn> columns;
        @Generated
        private String databaseName;
        @Generated
        private String databaseQualifiedName;
        @Generated
        private ArrayList<IDbtModel> dbtModels;
        @Generated
        private ArrayList<IDbtSource> dbtSources;
        @Generated
        private ArrayList<IDbtTest> dbtTests;
        @Generated
        private ArrayList<ITable> dimensions;
        @Generated
        private String dynamoDBPartitionKey;
        @Generated
        private Long dynamoDBReadCapacityUnits;
        @Generated
        private DynamoDBSecondaryIndexProjectionType dynamoDBSecondaryIndexProjectionType;
        @Generated
        private String dynamoDBSortKey;
        @Generated
        private DynamoDBStatus dynamoDBStatus;
        @Generated
        private IDynamoDBTable dynamoDBTable;
        @Generated
        private Long dynamoDBWriteCapacityUnits;
        @Generated
        private String externalLocation;
        @Generated
        private String externalLocationFormat;
        @Generated
        private String externalLocationRegion;
        @Generated
        private ArrayList<ITable> facts;
        @Generated
        private String icebergCatalogName;
        @Generated
        private String icebergCatalogSource;
        @Generated
        private String icebergCatalogTableName;
        @Generated
        private String icebergCatalogTableNamespace;
        @Generated
        private String icebergTableBaseLocation;
        @Generated
        private String icebergTableType;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private Boolean isPartitioned;
        @Generated
        private Boolean isProfiled;
        @Generated
        private Boolean isQueryPreview;
        @Generated
        private Boolean isSharded;
        @Generated
        private Boolean isTemporary;
        @Generated
        private Long lastProfiledAt;
        @Generated
        private String noSQLSchemaDefinition;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private Long partitionCount;
        @Generated
        private String partitionList;
        @Generated
        private String partitionStrategy;
        @Generated
        private ArrayList<ITablePartition> partitions;
        @Generated
        private ArrayList<IAtlanQuery> queries;
        @Generated
        private Long queryCount;
        @Generated
        private Long queryCountUpdatedAt;
        @Generated
        private ArrayList<String> queryPreviewConfig$key;
        @Generated
        private ArrayList<String> queryPreviewConfig$value;
        @Generated
        private Long queryUserCount;
        @Generated
        private ArrayList<String> queryUserMap$key;
        @Generated
        private ArrayList<Long> queryUserMap$value;
        @Generated
        private Long rowCount;
        @Generated
        private ISchema schema;
        @Generated
        private String schemaName;
        @Generated
        private String schemaQualifiedName;
        @Generated
        private Long sizeBytes;
        @Generated
        private ArrayList<IDbtSource> sqlDBTSources;
        @Generated
        private ArrayList<IDbtModel> sqlDbtModels;
        @Generated
        private String tableExternalVolumeName;
        @Generated
        private String tableName;
        @Generated
        private String tableQualifiedName;
        @Generated
        private Long tableRetentionTime;
        @Generated
        private TableType tableType;
        @Generated
        private String viewName;
        @Generated
        private String viewQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DynamoDBGlobalSecondaryIndexBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DynamoDBGlobalSecondaryIndex instance, DynamoDBGlobalSecondaryIndexBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.alias(instance.alias);
            b.calculationViewName(instance.calculationViewName);
            b.calculationViewQualifiedName(instance.calculationViewQualifiedName);
            b.columnCount(instance.columnCount);
            b.columns(instance.columns == null ? Collections.emptySortedSet() : instance.columns);
            b.databaseName(instance.databaseName);
            b.databaseQualifiedName(instance.databaseQualifiedName);
            b.dbtModels(instance.dbtModels == null ? Collections.emptySortedSet() : instance.dbtModels);
            b.dbtSources(instance.dbtSources == null ? Collections.emptySortedSet() : instance.dbtSources);
            b.dbtTests(instance.dbtTests == null ? Collections.emptySortedSet() : instance.dbtTests);
            b.dimensions(instance.dimensions == null ? Collections.emptySortedSet() : instance.dimensions);
            b.dynamoDBPartitionKey(instance.dynamoDBPartitionKey);
            b.dynamoDBReadCapacityUnits(instance.dynamoDBReadCapacityUnits);
            b.dynamoDBSecondaryIndexProjectionType(instance.dynamoDBSecondaryIndexProjectionType);
            b.dynamoDBSortKey(instance.dynamoDBSortKey);
            b.dynamoDBStatus(instance.dynamoDBStatus);
            b.dynamoDBTable(instance.dynamoDBTable);
            b.dynamoDBWriteCapacityUnits(instance.dynamoDBWriteCapacityUnits);
            b.externalLocation(instance.externalLocation);
            b.externalLocationFormat(instance.externalLocationFormat);
            b.externalLocationRegion(instance.externalLocationRegion);
            b.facts(instance.facts == null ? Collections.emptySortedSet() : instance.facts);
            b.icebergCatalogName(instance.icebergCatalogName);
            b.icebergCatalogSource(instance.icebergCatalogSource);
            b.icebergCatalogTableName(instance.icebergCatalogTableName);
            b.icebergCatalogTableNamespace(instance.icebergCatalogTableNamespace);
            b.icebergTableBaseLocation(instance.icebergTableBaseLocation);
            b.icebergTableType(instance.icebergTableType);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.isPartitioned(instance.isPartitioned);
            b.isProfiled(instance.isProfiled);
            b.isQueryPreview(instance.isQueryPreview);
            b.isSharded(instance.isSharded);
            b.isTemporary(instance.isTemporary);
            b.lastProfiledAt(instance.lastProfiledAt);
            b.noSQLSchemaDefinition(instance.noSQLSchemaDefinition);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.partitionCount(instance.partitionCount);
            b.partitionList(instance.partitionList);
            b.partitionStrategy(instance.partitionStrategy);
            b.partitions(instance.partitions == null ? Collections.emptySortedSet() : instance.partitions);
            b.queries(instance.queries == null ? Collections.emptySortedSet() : instance.queries);
            b.queryCount(instance.queryCount);
            b.queryCountUpdatedAt(instance.queryCountUpdatedAt);
            b.queryPreviewConfig(instance.queryPreviewConfig == null ? Collections.emptyMap() : instance.queryPreviewConfig);
            b.queryUserCount(instance.queryUserCount);
            b.queryUserMap(instance.queryUserMap == null ? Collections.emptyMap() : instance.queryUserMap);
            b.rowCount(instance.rowCount);
            b.schema(instance.schema);
            b.schemaName(instance.schemaName);
            b.schemaQualifiedName(instance.schemaQualifiedName);
            b.sizeBytes(instance.sizeBytes);
            b.sqlDBTSources(instance.sqlDBTSources == null ? Collections.emptySortedSet() : instance.sqlDBTSources);
            b.sqlDbtModels(instance.sqlDbtModels == null ? Collections.emptySortedSet() : instance.sqlDbtModels);
            b.tableExternalVolumeName(instance.tableExternalVolumeName);
            b.tableName(instance.tableName);
            b.tableQualifiedName(instance.tableQualifiedName);
            b.tableRetentionTime(instance.tableRetentionTime);
            b.tableType(instance.tableType);
            b.viewName(instance.viewName);
            b.viewQualifiedName(instance.viewQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B alias(String alias) {
            this.alias = alias;
            return (B)this.self();
        }

        @Generated
        public B calculationViewName(String calculationViewName) {
            this.calculationViewName = calculationViewName;
            return (B)this.self();
        }

        @Generated
        public B calculationViewQualifiedName(String calculationViewQualifiedName) {
            this.calculationViewQualifiedName = calculationViewQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B columnCount(Long columnCount) {
            this.columnCount = columnCount;
            return (B)this.self();
        }

        @Generated
        public B column(IColumn column) {
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.add(column);
            return (B)this.self();
        }

        @Generated
        public B columns(Collection<? extends IColumn> columns) {
            if (columns == null) {
                throw new NullPointerException("columns cannot be null");
            }
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.addAll(columns);
            return (B)this.self();
        }

        @Generated
        public B clearColumns() {
            if (this.columns != null) {
                this.columns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B databaseName(String databaseName) {
            this.databaseName = databaseName;
            return (B)this.self();
        }

        @Generated
        public B databaseQualifiedName(String databaseQualifiedName) {
            this.databaseQualifiedName = databaseQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B dbtModel(IDbtModel dbtModel) {
            if (this.dbtModels == null) {
                this.dbtModels = new ArrayList();
            }
            this.dbtModels.add(dbtModel);
            return (B)this.self();
        }

        @Generated
        public B dbtModels(Collection<? extends IDbtModel> dbtModels) {
            if (dbtModels == null) {
                throw new NullPointerException("dbtModels cannot be null");
            }
            if (this.dbtModels == null) {
                this.dbtModels = new ArrayList();
            }
            this.dbtModels.addAll(dbtModels);
            return (B)this.self();
        }

        @Generated
        public B clearDbtModels() {
            if (this.dbtModels != null) {
                this.dbtModels.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtSource(IDbtSource dbtSource) {
            if (this.dbtSources == null) {
                this.dbtSources = new ArrayList();
            }
            this.dbtSources.add(dbtSource);
            return (B)this.self();
        }

        @Generated
        public B dbtSources(Collection<? extends IDbtSource> dbtSources) {
            if (dbtSources == null) {
                throw new NullPointerException("dbtSources cannot be null");
            }
            if (this.dbtSources == null) {
                this.dbtSources = new ArrayList();
            }
            this.dbtSources.addAll(dbtSources);
            return (B)this.self();
        }

        @Generated
        public B clearDbtSources() {
            if (this.dbtSources != null) {
                this.dbtSources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtTest(IDbtTest dbtTest) {
            if (this.dbtTests == null) {
                this.dbtTests = new ArrayList();
            }
            this.dbtTests.add(dbtTest);
            return (B)this.self();
        }

        @Generated
        public B dbtTests(Collection<? extends IDbtTest> dbtTests) {
            if (dbtTests == null) {
                throw new NullPointerException("dbtTests cannot be null");
            }
            if (this.dbtTests == null) {
                this.dbtTests = new ArrayList();
            }
            this.dbtTests.addAll(dbtTests);
            return (B)this.self();
        }

        @Generated
        public B clearDbtTests() {
            if (this.dbtTests != null) {
                this.dbtTests.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dimension(ITable dimension) {
            if (this.dimensions == null) {
                this.dimensions = new ArrayList();
            }
            this.dimensions.add(dimension);
            return (B)this.self();
        }

        @Generated
        public B dimensions(Collection<? extends ITable> dimensions) {
            if (dimensions == null) {
                throw new NullPointerException("dimensions cannot be null");
            }
            if (this.dimensions == null) {
                this.dimensions = new ArrayList();
            }
            this.dimensions.addAll(dimensions);
            return (B)this.self();
        }

        @Generated
        public B clearDimensions() {
            if (this.dimensions != null) {
                this.dimensions.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dynamoDBPartitionKey(String dynamoDBPartitionKey) {
            this.dynamoDBPartitionKey = dynamoDBPartitionKey;
            return (B)this.self();
        }

        @Generated
        public B dynamoDBReadCapacityUnits(Long dynamoDBReadCapacityUnits) {
            this.dynamoDBReadCapacityUnits = dynamoDBReadCapacityUnits;
            return (B)this.self();
        }

        @Generated
        public B dynamoDBSecondaryIndexProjectionType(DynamoDBSecondaryIndexProjectionType dynamoDBSecondaryIndexProjectionType) {
            this.dynamoDBSecondaryIndexProjectionType = dynamoDBSecondaryIndexProjectionType;
            return (B)this.self();
        }

        @Generated
        public B dynamoDBSortKey(String dynamoDBSortKey) {
            this.dynamoDBSortKey = dynamoDBSortKey;
            return (B)this.self();
        }

        @Generated
        public B dynamoDBStatus(DynamoDBStatus dynamoDBStatus) {
            this.dynamoDBStatus = dynamoDBStatus;
            return (B)this.self();
        }

        @Generated
        public B dynamoDBTable(IDynamoDBTable dynamoDBTable) {
            this.dynamoDBTable = dynamoDBTable;
            return (B)this.self();
        }

        @Generated
        public B dynamoDBWriteCapacityUnits(Long dynamoDBWriteCapacityUnits) {
            this.dynamoDBWriteCapacityUnits = dynamoDBWriteCapacityUnits;
            return (B)this.self();
        }

        @Generated
        public B externalLocation(String externalLocation) {
            this.externalLocation = externalLocation;
            return (B)this.self();
        }

        @Generated
        public B externalLocationFormat(String externalLocationFormat) {
            this.externalLocationFormat = externalLocationFormat;
            return (B)this.self();
        }

        @Generated
        public B externalLocationRegion(String externalLocationRegion) {
            this.externalLocationRegion = externalLocationRegion;
            return (B)this.self();
        }

        @Generated
        public B fact(ITable fact) {
            if (this.facts == null) {
                this.facts = new ArrayList();
            }
            this.facts.add(fact);
            return (B)this.self();
        }

        @Generated
        public B facts(Collection<? extends ITable> facts) {
            if (facts == null) {
                throw new NullPointerException("facts cannot be null");
            }
            if (this.facts == null) {
                this.facts = new ArrayList();
            }
            this.facts.addAll(facts);
            return (B)this.self();
        }

        @Generated
        public B clearFacts() {
            if (this.facts != null) {
                this.facts.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B icebergCatalogName(String icebergCatalogName) {
            this.icebergCatalogName = icebergCatalogName;
            return (B)this.self();
        }

        @Generated
        public B icebergCatalogSource(String icebergCatalogSource) {
            this.icebergCatalogSource = icebergCatalogSource;
            return (B)this.self();
        }

        @Generated
        public B icebergCatalogTableName(String icebergCatalogTableName) {
            this.icebergCatalogTableName = icebergCatalogTableName;
            return (B)this.self();
        }

        @Generated
        public B icebergCatalogTableNamespace(String icebergCatalogTableNamespace) {
            this.icebergCatalogTableNamespace = icebergCatalogTableNamespace;
            return (B)this.self();
        }

        @Generated
        public B icebergTableBaseLocation(String icebergTableBaseLocation) {
            this.icebergTableBaseLocation = icebergTableBaseLocation;
            return (B)this.self();
        }

        @Generated
        public B icebergTableType(String icebergTableType) {
            this.icebergTableType = icebergTableType;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isPartitioned(Boolean isPartitioned) {
            this.isPartitioned = isPartitioned;
            return (B)this.self();
        }

        @Generated
        public B isProfiled(Boolean isProfiled) {
            this.isProfiled = isProfiled;
            return (B)this.self();
        }

        @Generated
        public B isQueryPreview(Boolean isQueryPreview) {
            this.isQueryPreview = isQueryPreview;
            return (B)this.self();
        }

        @Generated
        public B isSharded(Boolean isSharded) {
            this.isSharded = isSharded;
            return (B)this.self();
        }

        @Generated
        public B isTemporary(Boolean isTemporary) {
            this.isTemporary = isTemporary;
            return (B)this.self();
        }

        @Generated
        public B lastProfiledAt(Long lastProfiledAt) {
            this.lastProfiledAt = lastProfiledAt;
            return (B)this.self();
        }

        @Generated
        public B noSQLSchemaDefinition(String noSQLSchemaDefinition) {
            this.noSQLSchemaDefinition = noSQLSchemaDefinition;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B partitionCount(Long partitionCount) {
            this.partitionCount = partitionCount;
            return (B)this.self();
        }

        @Generated
        public B partitionList(String partitionList) {
            this.partitionList = partitionList;
            return (B)this.self();
        }

        @Generated
        public B partitionStrategy(String partitionStrategy) {
            this.partitionStrategy = partitionStrategy;
            return (B)this.self();
        }

        @Generated
        public B partition(ITablePartition partition) {
            if (this.partitions == null) {
                this.partitions = new ArrayList();
            }
            this.partitions.add(partition);
            return (B)this.self();
        }

        @Generated
        public B partitions(Collection<? extends ITablePartition> partitions) {
            if (partitions == null) {
                throw new NullPointerException("partitions cannot be null");
            }
            if (this.partitions == null) {
                this.partitions = new ArrayList();
            }
            this.partitions.addAll(partitions);
            return (B)this.self();
        }

        @Generated
        public B clearPartitions() {
            if (this.partitions != null) {
                this.partitions.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B query(IAtlanQuery query) {
            if (this.queries == null) {
                this.queries = new ArrayList();
            }
            this.queries.add(query);
            return (B)this.self();
        }

        @Generated
        public B queries(Collection<? extends IAtlanQuery> queries) {
            if (queries == null) {
                throw new NullPointerException("queries cannot be null");
            }
            if (this.queries == null) {
                this.queries = new ArrayList();
            }
            this.queries.addAll(queries);
            return (B)this.self();
        }

        @Generated
        public B clearQueries() {
            if (this.queries != null) {
                this.queries.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B queryCount(Long queryCount) {
            this.queryCount = queryCount;
            return (B)this.self();
        }

        @Generated
        public B queryCountUpdatedAt(Long queryCountUpdatedAt) {
            this.queryCountUpdatedAt = queryCountUpdatedAt;
            return (B)this.self();
        }

        @Generated
        public B putQueryPreviewConfig(String putQueryPreviewConfigKey, String putQueryPreviewConfigValue) {
            if (this.queryPreviewConfig$key == null) {
                this.queryPreviewConfig$key = new ArrayList();
                this.queryPreviewConfig$value = new ArrayList();
            }
            this.queryPreviewConfig$key.add(putQueryPreviewConfigKey);
            this.queryPreviewConfig$value.add(putQueryPreviewConfigValue);
            return (B)this.self();
        }

        @Generated
        public B queryPreviewConfig(Map<? extends String, ? extends String> queryPreviewConfig) {
            if (queryPreviewConfig == null) {
                throw new NullPointerException("queryPreviewConfig cannot be null");
            }
            if (this.queryPreviewConfig$key == null) {
                this.queryPreviewConfig$key = new ArrayList();
                this.queryPreviewConfig$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : queryPreviewConfig.entrySet()) {
                this.queryPreviewConfig$key.add($lombokEntry.getKey());
                this.queryPreviewConfig$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearQueryPreviewConfig() {
            if (this.queryPreviewConfig$key != null) {
                this.queryPreviewConfig$key.clear();
                this.queryPreviewConfig$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B queryUserCount(Long queryUserCount) {
            this.queryUserCount = queryUserCount;
            return (B)this.self();
        }

        @Generated
        public B putQueryUserMap(String putQueryUserMapKey, Long putQueryUserMapValue) {
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new ArrayList();
                this.queryUserMap$value = new ArrayList();
            }
            this.queryUserMap$key.add(putQueryUserMapKey);
            this.queryUserMap$value.add(putQueryUserMapValue);
            return (B)this.self();
        }

        @Generated
        public B queryUserMap(Map<? extends String, ? extends Long> queryUserMap) {
            if (queryUserMap == null) {
                throw new NullPointerException("queryUserMap cannot be null");
            }
            if (this.queryUserMap$key == null) {
                this.queryUserMap$key = new ArrayList();
                this.queryUserMap$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Long> $lombokEntry : queryUserMap.entrySet()) {
                this.queryUserMap$key.add($lombokEntry.getKey());
                this.queryUserMap$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearQueryUserMap() {
            if (this.queryUserMap$key != null) {
                this.queryUserMap$key.clear();
                this.queryUserMap$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B rowCount(Long rowCount) {
            this.rowCount = rowCount;
            return (B)this.self();
        }

        @JsonProperty(value="atlanSchema")
        @Generated
        public B schema(ISchema schema) {
            this.schema = schema;
            return (B)this.self();
        }

        @Generated
        public B schemaName(String schemaName) {
            this.schemaName = schemaName;
            return (B)this.self();
        }

        @Generated
        public B schemaQualifiedName(String schemaQualifiedName) {
            this.schemaQualifiedName = schemaQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B sizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
            return (B)this.self();
        }

        @Generated
        public B sqlDBTSource(IDbtSource sqlDBTSource) {
            if (this.sqlDBTSources == null) {
                this.sqlDBTSources = new ArrayList();
            }
            this.sqlDBTSources.add(sqlDBTSource);
            return (B)this.self();
        }

        @Generated
        public B sqlDBTSources(Collection<? extends IDbtSource> sqlDBTSources) {
            if (sqlDBTSources == null) {
                throw new NullPointerException("sqlDBTSources cannot be null");
            }
            if (this.sqlDBTSources == null) {
                this.sqlDBTSources = new ArrayList();
            }
            this.sqlDBTSources.addAll(sqlDBTSources);
            return (B)this.self();
        }

        @Generated
        public B clearSqlDBTSources() {
            if (this.sqlDBTSources != null) {
                this.sqlDBTSources.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sqlDbtModel(IDbtModel sqlDbtModel) {
            if (this.sqlDbtModels == null) {
                this.sqlDbtModels = new ArrayList();
            }
            this.sqlDbtModels.add(sqlDbtModel);
            return (B)this.self();
        }

        @Generated
        public B sqlDbtModels(Collection<? extends IDbtModel> sqlDbtModels) {
            if (sqlDbtModels == null) {
                throw new NullPointerException("sqlDbtModels cannot be null");
            }
            if (this.sqlDbtModels == null) {
                this.sqlDbtModels = new ArrayList();
            }
            this.sqlDbtModels.addAll(sqlDbtModels);
            return (B)this.self();
        }

        @Generated
        public B clearSqlDbtModels() {
            if (this.sqlDbtModels != null) {
                this.sqlDbtModels.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B tableExternalVolumeName(String tableExternalVolumeName) {
            this.tableExternalVolumeName = tableExternalVolumeName;
            return (B)this.self();
        }

        @Generated
        public B tableName(String tableName) {
            this.tableName = tableName;
            return (B)this.self();
        }

        @Generated
        public B tableQualifiedName(String tableQualifiedName) {
            this.tableQualifiedName = tableQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B tableRetentionTime(Long tableRetentionTime) {
            this.tableRetentionTime = tableRetentionTime;
            return (B)this.self();
        }

        @Generated
        public B tableType(TableType tableType) {
            this.tableType = tableType;
            return (B)this.self();
        }

        @Generated
        public B viewName(String viewName) {
            this.viewName = viewName;
            return (B)this.self();
        }

        @Generated
        public B viewQualifiedName(String viewQualifiedName) {
            this.viewQualifiedName = viewQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DynamoDBGlobalSecondaryIndex.DynamoDBGlobalSecondaryIndexBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", alias=" + this.alias + ", calculationViewName=" + this.calculationViewName + ", calculationViewQualifiedName=" + this.calculationViewQualifiedName + ", columnCount=" + this.columnCount + ", columns=" + this.columns + ", databaseName=" + this.databaseName + ", databaseQualifiedName=" + this.databaseQualifiedName + ", dbtModels=" + this.dbtModels + ", dbtSources=" + this.dbtSources + ", dbtTests=" + this.dbtTests + ", dimensions=" + this.dimensions + ", dynamoDBPartitionKey=" + this.dynamoDBPartitionKey + ", dynamoDBReadCapacityUnits=" + this.dynamoDBReadCapacityUnits + ", dynamoDBSecondaryIndexProjectionType=" + this.dynamoDBSecondaryIndexProjectionType + ", dynamoDBSortKey=" + this.dynamoDBSortKey + ", dynamoDBStatus=" + this.dynamoDBStatus + ", dynamoDBTable=" + this.dynamoDBTable + ", dynamoDBWriteCapacityUnits=" + this.dynamoDBWriteCapacityUnits + ", externalLocation=" + this.externalLocation + ", externalLocationFormat=" + this.externalLocationFormat + ", externalLocationRegion=" + this.externalLocationRegion + ", facts=" + this.facts + ", icebergCatalogName=" + this.icebergCatalogName + ", icebergCatalogSource=" + this.icebergCatalogSource + ", icebergCatalogTableName=" + this.icebergCatalogTableName + ", icebergCatalogTableNamespace=" + this.icebergCatalogTableNamespace + ", icebergTableBaseLocation=" + this.icebergTableBaseLocation + ", icebergTableType=" + this.icebergTableType + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", isPartitioned=" + this.isPartitioned + ", isProfiled=" + this.isProfiled + ", isQueryPreview=" + this.isQueryPreview + ", isSharded=" + this.isSharded + ", isTemporary=" + this.isTemporary + ", lastProfiledAt=" + this.lastProfiledAt + ", noSQLSchemaDefinition=" + this.noSQLSchemaDefinition + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", partitionCount=" + this.partitionCount + ", partitionList=" + this.partitionList + ", partitionStrategy=" + this.partitionStrategy + ", partitions=" + this.partitions + ", queries=" + this.queries + ", queryCount=" + this.queryCount + ", queryCountUpdatedAt=" + this.queryCountUpdatedAt + ", queryPreviewConfig$key=" + this.queryPreviewConfig$key + ", queryPreviewConfig$value=" + this.queryPreviewConfig$value + ", queryUserCount=" + this.queryUserCount + ", queryUserMap$key=" + this.queryUserMap$key + ", queryUserMap$value=" + this.queryUserMap$value + ", rowCount=" + this.rowCount + ", schema=" + this.schema + ", schemaName=" + this.schemaName + ", schemaQualifiedName=" + this.schemaQualifiedName + ", sizeBytes=" + this.sizeBytes + ", sqlDBTSources=" + this.sqlDBTSources + ", sqlDbtModels=" + this.sqlDbtModels + ", tableExternalVolumeName=" + this.tableExternalVolumeName + ", tableName=" + this.tableName + ", tableQualifiedName=" + this.tableQualifiedName + ", tableRetentionTime=" + this.tableRetentionTime + ", tableType=" + this.tableType + ", viewName=" + this.viewName + ", viewQualifiedName=" + this.viewQualifiedName + ")";
        }
    }

    @Generated
    private static final class DynamoDBGlobalSecondaryIndexBuilderImpl
    extends DynamoDBGlobalSecondaryIndexBuilder<DynamoDBGlobalSecondaryIndex, DynamoDBGlobalSecondaryIndexBuilderImpl> {
        @Generated
        private DynamoDBGlobalSecondaryIndexBuilderImpl() {
        }

        @Override
        @Generated
        protected DynamoDBGlobalSecondaryIndexBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DynamoDBGlobalSecondaryIndex build() {
            return new DynamoDBGlobalSecondaryIndex(this);
        }
    }
}

