/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IColumnProcess;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IMatillionComponent;
import com.atlan.model.assets.IPowerBIDataflow;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineageProcess
extends Asset
implements ILineageProcess,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LineageProcess.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Process";
    String typeName;
    @Attribute
    String additionalEtlContext;
    @Attribute
    SortedSet<IAirflowTask> airflowTasks;
    @Attribute
    String ast;
    @Attribute
    String code;
    @Attribute
    SortedSet<IColumnProcess> columnProcesses;
    @Attribute
    SortedSet<ICatalog> inputs;
    @Attribute
    IMatillionComponent matillionComponent;
    @Attribute
    SortedSet<ICatalog> outputs;
    @Attribute
    IPowerBIDataflow powerBIDataflow;
    @Attribute
    SortedSet<ISparkJob> sparkJobs;
    @Attribute
    String sql;

    @Override
    public LineageProcess trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return LineageProcess.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return LineageProcess.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return LineageProcess.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return LineageProcess.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return LineageProcess.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return LineageProcess.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static LineageProcess refByGuid(String guid) {
        return LineageProcess.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static LineageProcess refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((LineageProcessBuilder)((LineageProcessBuilder)LineageProcess._internal().guid(guid)).semantic(semantic)).build();
    }

    public static LineageProcess refByQualifiedName(String qualifiedName) {
        return LineageProcess.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static LineageProcess refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((LineageProcessBuilder)((LineageProcessBuilder)LineageProcess._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static LineageProcess get(String id) throws AtlanException {
        return LineageProcess.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static LineageProcess get(AtlanClient client, String id) throws AtlanException {
        return LineageProcess.get(client, id, true);
    }

    @JsonIgnore
    public static LineageProcess get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof LineageProcess) {
                return (LineageProcess)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof LineageProcess) {
            return (LineageProcess)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return LineageProcess.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static LineageProcessBuilder<?, ?> creator(String name, String connectionQualifiedName, String id, List<ICatalog> inputs, List<ICatalog> outputs, LineageProcess parent) {
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(connectionQualifiedName);
        return ((LineageProcessBuilder)((LineageProcessBuilder)((LineageProcessBuilder)((LineageProcessBuilder)((LineageProcessBuilder)((LineageProcessBuilder)LineageProcess._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(LineageProcess.generateQualifiedName(name, connectionQualifiedName, id, inputs, outputs, parent))).name(name)).connectorType(connectorType)).connectionQualifiedName(connectionQualifiedName)).inputs(inputs)).outputs(outputs);
    }

    public static LineageProcessBuilder<?, ?> updater(String qualifiedName, String name) {
        return (LineageProcessBuilder)((LineageProcessBuilder)((LineageProcessBuilder)LineageProcess._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public LineageProcessBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        LineageProcess.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return LineageProcess.updater(this.getQualifiedName(), this.getName());
    }

    public static String generateQualifiedName(String name, String connectionQualifiedName, String id, List<ICatalog> inputs, List<ICatalog> outputs, LineageProcess parent) {
        if (id != null && id.length() > 0) {
            return connectionQualifiedName + "/" + id;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(name).append(connectionQualifiedName);
        if (parent != null) {
            LineageProcess.appendRelationship(sb, parent);
        }
        LineageProcess.appendRelationships(sb, inputs);
        LineageProcess.appendRelationships(sb, outputs);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(sb.toString().getBytes(StandardCharsets.UTF_8));
            String hashed = String.format("%032x", new BigInteger(1, md.digest()));
            return connectionQualifiedName + "/" + hashed;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to generate the qualifiedName for the process: MD5 algorithm does not exist on your platform!");
        }
    }

    private static void appendRelationships(StringBuilder sb, List<ICatalog> relationships) {
        for (ICatalog relationship : relationships) {
            LineageProcess.appendRelationship(sb, (IAsset)((Object)relationship));
        }
    }

    private static void appendRelationship(StringBuilder sb, IAsset relationship) {
        if (relationship.getGuid() != null) {
            sb.append(relationship.getGuid());
        } else if (relationship.getUniqueAttributes() != null && relationship.getUniqueAttributes().getQualifiedName() != null) {
            sb.append(relationship.getUniqueAttributes().getQualifiedName());
        }
    }

    public static LineageProcess removeDescription(String qualifiedName, String name) throws AtlanException {
        return LineageProcess.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LineageProcess removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LineageProcess)Asset.removeDescription(client, LineageProcess.updater(qualifiedName, name));
    }

    public static LineageProcess removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return LineageProcess.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LineageProcess removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LineageProcess)Asset.removeUserDescription(client, LineageProcess.updater(qualifiedName, name));
    }

    public static LineageProcess removeOwners(String qualifiedName, String name) throws AtlanException {
        return LineageProcess.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LineageProcess removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LineageProcess)Asset.removeOwners(client, LineageProcess.updater(qualifiedName, name));
    }

    public static LineageProcess updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return LineageProcess.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static LineageProcess updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (LineageProcess)Asset.updateCertificate(client, LineageProcess._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static LineageProcess removeCertificate(String qualifiedName, String name) throws AtlanException {
        return LineageProcess.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LineageProcess removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LineageProcess)Asset.removeCertificate(client, LineageProcess.updater(qualifiedName, name));
    }

    public static LineageProcess updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return LineageProcess.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static LineageProcess updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LineageProcess)Asset.updateAnnouncement(client, LineageProcess._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static LineageProcess removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return LineageProcess.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LineageProcess removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LineageProcess)Asset.removeAnnouncement(client, LineageProcess.updater(qualifiedName, name));
    }

    public static LineageProcess replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return LineageProcess.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static LineageProcess replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (LineageProcess)Asset.replaceTerms(client, LineageProcess.updater(qualifiedName, name), terms);
    }

    public static LineageProcess appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return LineageProcess.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static LineageProcess appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LineageProcess)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static LineageProcess removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return LineageProcess.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static LineageProcess removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LineageProcess)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static LineageProcess appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return LineageProcess.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static LineageProcess appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (LineageProcess)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static LineageProcess appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return LineageProcess.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static LineageProcess appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (LineageProcess)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        LineageProcess.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected LineageProcess(LineageProcessBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : LineageProcess.$default$typeName();
        this.additionalEtlContext = b.additionalEtlContext;
        SortedSet<IAirflowTask> airflowTasks = new TreeSet<IAirflowTask>();
        if (b.airflowTasks != null) {
            airflowTasks.addAll(b.airflowTasks);
        }
        airflowTasks = Collections.unmodifiableSortedSet(airflowTasks);
        this.airflowTasks = airflowTasks;
        this.ast = b.ast;
        this.code = b.code;
        SortedSet<IColumnProcess> columnProcesses = new TreeSet<IColumnProcess>();
        if (b.columnProcesses != null) {
            columnProcesses.addAll(b.columnProcesses);
        }
        columnProcesses = Collections.unmodifiableSortedSet(columnProcesses);
        this.columnProcesses = columnProcesses;
        SortedSet<ICatalog> inputs = new TreeSet<ICatalog>();
        if (b.inputs != null) {
            inputs.addAll(b.inputs);
        }
        inputs = Collections.unmodifiableSortedSet(inputs);
        this.inputs = inputs;
        this.matillionComponent = b.matillionComponent;
        SortedSet<ICatalog> outputs = new TreeSet<ICatalog>();
        if (b.outputs != null) {
            outputs.addAll(b.outputs);
        }
        outputs = Collections.unmodifiableSortedSet(outputs);
        this.outputs = outputs;
        this.powerBIDataflow = b.powerBIDataflow;
        SortedSet<ISparkJob> sparkJobs = new TreeSet<ISparkJob>();
        if (b.sparkJobs != null) {
            sparkJobs.addAll(b.sparkJobs);
        }
        sparkJobs = Collections.unmodifiableSortedSet(sparkJobs);
        this.sparkJobs = sparkJobs;
        this.sql = b.sql;
    }

    @Generated
    public static LineageProcessBuilder<?, ?> _internal() {
        return new LineageProcessBuilderImpl();
    }

    @Generated
    public LineageProcessBuilder<?, ?> toBuilder() {
        return new LineageProcessBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getAdditionalEtlContext() {
        return this.additionalEtlContext;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getAirflowTasks() {
        return this.airflowTasks;
    }

    @Override
    @Generated
    public String getAst() {
        return this.ast;
    }

    @Override
    @Generated
    public String getCode() {
        return this.code;
    }

    @Override
    @Generated
    public SortedSet<IColumnProcess> getColumnProcesses() {
        return this.columnProcesses;
    }

    @Override
    @Generated
    public SortedSet<ICatalog> getInputs() {
        return this.inputs;
    }

    @Override
    @Generated
    public IMatillionComponent getMatillionComponent() {
        return this.matillionComponent;
    }

    @Override
    @Generated
    public SortedSet<ICatalog> getOutputs() {
        return this.outputs;
    }

    @Override
    @Generated
    public IPowerBIDataflow getPowerBIDataflow() {
        return this.powerBIDataflow;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getSparkJobs() {
        return this.sparkJobs;
    }

    @Override
    @Generated
    public String getSql() {
        return this.sql;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LineageProcess)) {
            return false;
        }
        LineageProcess other = (LineageProcess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$additionalEtlContext = this.getAdditionalEtlContext();
        String other$additionalEtlContext = other.getAdditionalEtlContext();
        if (this$additionalEtlContext == null ? other$additionalEtlContext != null : !this$additionalEtlContext.equals(other$additionalEtlContext)) {
            return false;
        }
        SortedSet<IAirflowTask> this$airflowTasks = this.getAirflowTasks();
        SortedSet<IAirflowTask> other$airflowTasks = other.getAirflowTasks();
        if (this$airflowTasks == null ? other$airflowTasks != null : !this$airflowTasks.equals(other$airflowTasks)) {
            return false;
        }
        String this$ast = this.getAst();
        String other$ast = other.getAst();
        if (this$ast == null ? other$ast != null : !this$ast.equals(other$ast)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        SortedSet<IColumnProcess> this$columnProcesses = this.getColumnProcesses();
        SortedSet<IColumnProcess> other$columnProcesses = other.getColumnProcesses();
        if (this$columnProcesses == null ? other$columnProcesses != null : !this$columnProcesses.equals(other$columnProcesses)) {
            return false;
        }
        SortedSet<ICatalog> this$inputs = this.getInputs();
        SortedSet<ICatalog> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !this$inputs.equals(other$inputs)) {
            return false;
        }
        IMatillionComponent this$matillionComponent = this.getMatillionComponent();
        IMatillionComponent other$matillionComponent = other.getMatillionComponent();
        if (this$matillionComponent == null ? other$matillionComponent != null : !this$matillionComponent.equals(other$matillionComponent)) {
            return false;
        }
        SortedSet<ICatalog> this$outputs = this.getOutputs();
        SortedSet<ICatalog> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !this$outputs.equals(other$outputs)) {
            return false;
        }
        IPowerBIDataflow this$powerBIDataflow = this.getPowerBIDataflow();
        IPowerBIDataflow other$powerBIDataflow = other.getPowerBIDataflow();
        if (this$powerBIDataflow == null ? other$powerBIDataflow != null : !this$powerBIDataflow.equals(other$powerBIDataflow)) {
            return false;
        }
        SortedSet<ISparkJob> this$sparkJobs = this.getSparkJobs();
        SortedSet<ISparkJob> other$sparkJobs = other.getSparkJobs();
        if (this$sparkJobs == null ? other$sparkJobs != null : !this$sparkJobs.equals(other$sparkJobs)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        return !(this$sql == null ? other$sql != null : !this$sql.equals(other$sql));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LineageProcess;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $additionalEtlContext = this.getAdditionalEtlContext();
        result = result * 59 + ($additionalEtlContext == null ? 43 : $additionalEtlContext.hashCode());
        SortedSet<IAirflowTask> $airflowTasks = this.getAirflowTasks();
        result = result * 59 + ($airflowTasks == null ? 43 : $airflowTasks.hashCode());
        String $ast = this.getAst();
        result = result * 59 + ($ast == null ? 43 : $ast.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        SortedSet<IColumnProcess> $columnProcesses = this.getColumnProcesses();
        result = result * 59 + ($columnProcesses == null ? 43 : $columnProcesses.hashCode());
        SortedSet<ICatalog> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : $inputs.hashCode());
        IMatillionComponent $matillionComponent = this.getMatillionComponent();
        result = result * 59 + ($matillionComponent == null ? 43 : $matillionComponent.hashCode());
        SortedSet<ICatalog> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : $outputs.hashCode());
        IPowerBIDataflow $powerBIDataflow = this.getPowerBIDataflow();
        result = result * 59 + ($powerBIDataflow == null ? 43 : $powerBIDataflow.hashCode());
        SortedSet<ISparkJob> $sparkJobs = this.getSparkJobs();
        result = result * 59 + ($sparkJobs == null ? 43 : $sparkJobs.hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "LineageProcess(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", additionalEtlContext=" + this.getAdditionalEtlContext() + ", airflowTasks=" + this.getAirflowTasks() + ", ast=" + this.getAst() + ", code=" + this.getCode() + ", columnProcesses=" + this.getColumnProcesses() + ", inputs=" + this.getInputs() + ", matillionComponent=" + this.getMatillionComponent() + ", outputs=" + this.getOutputs() + ", powerBIDataflow=" + this.getPowerBIDataflow() + ", sparkJobs=" + this.getSparkJobs() + ", sql=" + this.getSql() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class LineageProcessBuilder<C extends LineageProcess, B extends LineageProcessBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String additionalEtlContext;
        @Generated
        private ArrayList<IAirflowTask> airflowTasks;
        @Generated
        private String ast;
        @Generated
        private String code;
        @Generated
        private ArrayList<IColumnProcess> columnProcesses;
        @Generated
        private ArrayList<ICatalog> inputs;
        @Generated
        private IMatillionComponent matillionComponent;
        @Generated
        private ArrayList<ICatalog> outputs;
        @Generated
        private IPowerBIDataflow powerBIDataflow;
        @Generated
        private ArrayList<ISparkJob> sparkJobs;
        @Generated
        private String sql;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LineageProcessBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LineageProcess instance, LineageProcessBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.additionalEtlContext(instance.additionalEtlContext);
            b.airflowTasks(instance.airflowTasks == null ? Collections.emptySortedSet() : instance.airflowTasks);
            b.ast(instance.ast);
            b.code(instance.code);
            b.columnProcesses(instance.columnProcesses == null ? Collections.emptySortedSet() : instance.columnProcesses);
            b.inputs(instance.inputs == null ? Collections.emptySortedSet() : instance.inputs);
            b.matillionComponent(instance.matillionComponent);
            b.outputs(instance.outputs == null ? Collections.emptySortedSet() : instance.outputs);
            b.powerBIDataflow(instance.powerBIDataflow);
            b.sparkJobs(instance.sparkJobs == null ? Collections.emptySortedSet() : instance.sparkJobs);
            b.sql(instance.sql);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B additionalEtlContext(String additionalEtlContext) {
            this.additionalEtlContext = additionalEtlContext;
            return (B)this.self();
        }

        @Generated
        public B airflowTask(IAirflowTask airflowTask) {
            if (this.airflowTasks == null) {
                this.airflowTasks = new ArrayList();
            }
            this.airflowTasks.add(airflowTask);
            return (B)this.self();
        }

        @Generated
        public B airflowTasks(Collection<? extends IAirflowTask> airflowTasks) {
            if (airflowTasks == null) {
                throw new NullPointerException("airflowTasks cannot be null");
            }
            if (this.airflowTasks == null) {
                this.airflowTasks = new ArrayList();
            }
            this.airflowTasks.addAll(airflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearAirflowTasks() {
            if (this.airflowTasks != null) {
                this.airflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B ast(String ast) {
            this.ast = ast;
            return (B)this.self();
        }

        @Generated
        public B code(String code) {
            this.code = code;
            return (B)this.self();
        }

        @Generated
        public B columnProcess(IColumnProcess columnProcess) {
            if (this.columnProcesses == null) {
                this.columnProcesses = new ArrayList();
            }
            this.columnProcesses.add(columnProcess);
            return (B)this.self();
        }

        @Generated
        public B columnProcesses(Collection<? extends IColumnProcess> columnProcesses) {
            if (columnProcesses == null) {
                throw new NullPointerException("columnProcesses cannot be null");
            }
            if (this.columnProcesses == null) {
                this.columnProcesses = new ArrayList();
            }
            this.columnProcesses.addAll(columnProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearColumnProcesses() {
            if (this.columnProcesses != null) {
                this.columnProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B input(ICatalog input) {
            if (this.inputs == null) {
                this.inputs = new ArrayList();
            }
            this.inputs.add(input);
            return (B)this.self();
        }

        @Generated
        public B inputs(Collection<? extends ICatalog> inputs) {
            if (inputs == null) {
                throw new NullPointerException("inputs cannot be null");
            }
            if (this.inputs == null) {
                this.inputs = new ArrayList();
            }
            this.inputs.addAll(inputs);
            return (B)this.self();
        }

        @Generated
        public B clearInputs() {
            if (this.inputs != null) {
                this.inputs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B matillionComponent(IMatillionComponent matillionComponent) {
            this.matillionComponent = matillionComponent;
            return (B)this.self();
        }

        @Generated
        public B output(ICatalog output) {
            if (this.outputs == null) {
                this.outputs = new ArrayList();
            }
            this.outputs.add(output);
            return (B)this.self();
        }

        @Generated
        public B outputs(Collection<? extends ICatalog> outputs) {
            if (outputs == null) {
                throw new NullPointerException("outputs cannot be null");
            }
            if (this.outputs == null) {
                this.outputs = new ArrayList();
            }
            this.outputs.addAll(outputs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputs() {
            if (this.outputs != null) {
                this.outputs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B powerBIDataflow(IPowerBIDataflow powerBIDataflow) {
            this.powerBIDataflow = powerBIDataflow;
            return (B)this.self();
        }

        @Generated
        public B sparkJob(ISparkJob sparkJob) {
            if (this.sparkJobs == null) {
                this.sparkJobs = new ArrayList();
            }
            this.sparkJobs.add(sparkJob);
            return (B)this.self();
        }

        @Generated
        public B sparkJobs(Collection<? extends ISparkJob> sparkJobs) {
            if (sparkJobs == null) {
                throw new NullPointerException("sparkJobs cannot be null");
            }
            if (this.sparkJobs == null) {
                this.sparkJobs = new ArrayList();
            }
            this.sparkJobs.addAll(sparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearSparkJobs() {
            if (this.sparkJobs != null) {
                this.sparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sql(String sql) {
            this.sql = sql;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "LineageProcess.LineageProcessBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", additionalEtlContext=" + this.additionalEtlContext + ", airflowTasks=" + this.airflowTasks + ", ast=" + this.ast + ", code=" + this.code + ", columnProcesses=" + this.columnProcesses + ", inputs=" + this.inputs + ", matillionComponent=" + this.matillionComponent + ", outputs=" + this.outputs + ", powerBIDataflow=" + this.powerBIDataflow + ", sparkJobs=" + this.sparkJobs + ", sql=" + this.sql + ")";
        }
    }

    @Generated
    private static final class LineageProcessBuilderImpl
    extends LineageProcessBuilder<LineageProcess, LineageProcessBuilderImpl> {
        @Generated
        private LineageProcessBuilderImpl() {
        }

        @Override
        @Generated
        protected LineageProcessBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LineageProcess build() {
            return new LineageProcess(this);
        }
    }
}

