/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.ILooker;
import com.atlan.model.assets.ILookerDashboard;
import com.atlan.model.assets.ILookerField;
import com.atlan.model.assets.ILookerFolder;
import com.atlan.model.assets.ILookerLook;
import com.atlan.model.assets.ILookerTile;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookerDashboard
extends Asset
implements ILookerDashboard,
ILooker,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LookerDashboard.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerDashboard";
    String typeName;
    @Attribute
    SortedSet<ILookerField> fields;
    @Attribute
    ILookerFolder folder;
    @Attribute
    String folderName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<ILookerLook> looks;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    @Date
    Long sourceLastAccessedAt;
    @Attribute
    @Date
    Long sourceLastViewedAt;
    @Attribute
    Integer sourceMetadataId;
    @Attribute
    Integer sourceUserId;
    @Attribute
    Integer sourceViewCount;
    @Attribute
    Integer sourcelastUpdaterId;
    @Attribute
    SortedSet<ILookerTile> tiles;

    @Override
    public LookerDashboard trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return LookerDashboard.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return LookerDashboard.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return LookerDashboard.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return LookerDashboard.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return LookerDashboard.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return LookerDashboard.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static LookerDashboard refByGuid(String guid) {
        return LookerDashboard.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static LookerDashboard refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((LookerDashboardBuilder)((LookerDashboardBuilder)LookerDashboard._internal().guid(guid)).semantic(semantic)).build();
    }

    public static LookerDashboard refByQualifiedName(String qualifiedName) {
        return LookerDashboard.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static LookerDashboard refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((LookerDashboardBuilder)((LookerDashboardBuilder)LookerDashboard._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static LookerDashboard get(String id) throws AtlanException {
        return LookerDashboard.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static LookerDashboard get(AtlanClient client, String id) throws AtlanException {
        return LookerDashboard.get(client, id, true);
    }

    @JsonIgnore
    public static LookerDashboard get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof LookerDashboard) {
                return (LookerDashboard)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof LookerDashboard) {
            return (LookerDashboard)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return LookerDashboard.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static LookerDashboardBuilder<?, ?> updater(String qualifiedName, String name) {
        return (LookerDashboardBuilder)((LookerDashboardBuilder)((LookerDashboardBuilder)LookerDashboard._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public LookerDashboardBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        LookerDashboard.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return LookerDashboard.updater(this.getQualifiedName(), this.getName());
    }

    public static LookerDashboard removeDescription(String qualifiedName, String name) throws AtlanException {
        return LookerDashboard.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerDashboard removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerDashboard)Asset.removeDescription(client, LookerDashboard.updater(qualifiedName, name));
    }

    public static LookerDashboard removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return LookerDashboard.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerDashboard removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerDashboard)Asset.removeUserDescription(client, LookerDashboard.updater(qualifiedName, name));
    }

    public static LookerDashboard removeOwners(String qualifiedName, String name) throws AtlanException {
        return LookerDashboard.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerDashboard removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerDashboard)Asset.removeOwners(client, LookerDashboard.updater(qualifiedName, name));
    }

    public static LookerDashboard updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return LookerDashboard.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static LookerDashboard updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (LookerDashboard)Asset.updateCertificate(client, LookerDashboard._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static LookerDashboard removeCertificate(String qualifiedName, String name) throws AtlanException {
        return LookerDashboard.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerDashboard removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerDashboard)Asset.removeCertificate(client, LookerDashboard.updater(qualifiedName, name));
    }

    public static LookerDashboard updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return LookerDashboard.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static LookerDashboard updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerDashboard)Asset.updateAnnouncement(client, LookerDashboard._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static LookerDashboard removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return LookerDashboard.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static LookerDashboard removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (LookerDashboard)Asset.removeAnnouncement(client, LookerDashboard.updater(qualifiedName, name));
    }

    public static LookerDashboard replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return LookerDashboard.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static LookerDashboard replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerDashboard)Asset.replaceTerms(client, LookerDashboard.updater(qualifiedName, name), terms);
    }

    public static LookerDashboard appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return LookerDashboard.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static LookerDashboard appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerDashboard)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static LookerDashboard removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return LookerDashboard.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static LookerDashboard removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (LookerDashboard)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static LookerDashboard appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return LookerDashboard.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static LookerDashboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (LookerDashboard)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static LookerDashboard appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return LookerDashboard.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static LookerDashboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (LookerDashboard)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        LookerDashboard.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected LookerDashboard(LookerDashboardBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : LookerDashboard.$default$typeName();
        SortedSet<ILookerField> fields = new TreeSet<ILookerField>();
        if (b.fields != null) {
            fields.addAll(b.fields);
        }
        fields = Collections.unmodifiableSortedSet(fields);
        this.fields = fields;
        this.folder = b.folder;
        this.folderName = b.folderName;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<ILookerLook> looks = new TreeSet<ILookerLook>();
        if (b.looks != null) {
            looks.addAll(b.looks);
        }
        looks = Collections.unmodifiableSortedSet(looks);
        this.looks = looks;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.sourceLastAccessedAt = b.sourceLastAccessedAt;
        this.sourceLastViewedAt = b.sourceLastViewedAt;
        this.sourceMetadataId = b.sourceMetadataId;
        this.sourceUserId = b.sourceUserId;
        this.sourceViewCount = b.sourceViewCount;
        this.sourcelastUpdaterId = b.sourcelastUpdaterId;
        SortedSet<ILookerTile> tiles = new TreeSet<ILookerTile>();
        if (b.tiles != null) {
            tiles.addAll(b.tiles);
        }
        tiles = Collections.unmodifiableSortedSet(tiles);
        this.tiles = tiles;
    }

    @Generated
    public static LookerDashboardBuilder<?, ?> _internal() {
        return new LookerDashboardBuilderImpl();
    }

    @Generated
    public LookerDashboardBuilder<?, ?> toBuilder() {
        return new LookerDashboardBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<ILookerField> getFields() {
        return this.fields;
    }

    @Override
    @Generated
    public ILookerFolder getFolder() {
        return this.folder;
    }

    @Override
    @Generated
    public String getFolderName() {
        return this.folderName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<ILookerLook> getLooks() {
        return this.looks;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public Long getSourceLastAccessedAt() {
        return this.sourceLastAccessedAt;
    }

    @Override
    @Generated
    public Long getSourceLastViewedAt() {
        return this.sourceLastViewedAt;
    }

    @Override
    @Generated
    public Integer getSourceMetadataId() {
        return this.sourceMetadataId;
    }

    @Override
    @Generated
    public Integer getSourceUserId() {
        return this.sourceUserId;
    }

    @Override
    @Generated
    public Integer getSourceViewCount() {
        return this.sourceViewCount;
    }

    @Override
    @Generated
    public Integer getSourcelastUpdaterId() {
        return this.sourcelastUpdaterId;
    }

    @Override
    @Generated
    public SortedSet<ILookerTile> getTiles() {
        return this.tiles;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookerDashboard)) {
            return false;
        }
        LookerDashboard other = (LookerDashboard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$sourceLastAccessedAt = this.getSourceLastAccessedAt();
        Long other$sourceLastAccessedAt = other.getSourceLastAccessedAt();
        if (this$sourceLastAccessedAt == null ? other$sourceLastAccessedAt != null : !((Object)this$sourceLastAccessedAt).equals(other$sourceLastAccessedAt)) {
            return false;
        }
        Long this$sourceLastViewedAt = this.getSourceLastViewedAt();
        Long other$sourceLastViewedAt = other.getSourceLastViewedAt();
        if (this$sourceLastViewedAt == null ? other$sourceLastViewedAt != null : !((Object)this$sourceLastViewedAt).equals(other$sourceLastViewedAt)) {
            return false;
        }
        Integer this$sourceMetadataId = this.getSourceMetadataId();
        Integer other$sourceMetadataId = other.getSourceMetadataId();
        if (this$sourceMetadataId == null ? other$sourceMetadataId != null : !((Object)this$sourceMetadataId).equals(other$sourceMetadataId)) {
            return false;
        }
        Integer this$sourceUserId = this.getSourceUserId();
        Integer other$sourceUserId = other.getSourceUserId();
        if (this$sourceUserId == null ? other$sourceUserId != null : !((Object)this$sourceUserId).equals(other$sourceUserId)) {
            return false;
        }
        Integer this$sourceViewCount = this.getSourceViewCount();
        Integer other$sourceViewCount = other.getSourceViewCount();
        if (this$sourceViewCount == null ? other$sourceViewCount != null : !((Object)this$sourceViewCount).equals(other$sourceViewCount)) {
            return false;
        }
        Integer this$sourcelastUpdaterId = this.getSourcelastUpdaterId();
        Integer other$sourcelastUpdaterId = other.getSourcelastUpdaterId();
        if (this$sourcelastUpdaterId == null ? other$sourcelastUpdaterId != null : !((Object)this$sourcelastUpdaterId).equals(other$sourcelastUpdaterId)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<ILookerField> this$fields = this.getFields();
        SortedSet<ILookerField> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !this$fields.equals(other$fields)) {
            return false;
        }
        ILookerFolder this$folder = this.getFolder();
        ILookerFolder other$folder = other.getFolder();
        if (this$folder == null ? other$folder != null : !this$folder.equals(other$folder)) {
            return false;
        }
        String this$folderName = this.getFolderName();
        String other$folderName = other.getFolderName();
        if (this$folderName == null ? other$folderName != null : !this$folderName.equals(other$folderName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<ILookerLook> this$looks = this.getLooks();
        SortedSet<ILookerLook> other$looks = other.getLooks();
        if (this$looks == null ? other$looks != null : !this$looks.equals(other$looks)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        SortedSet<ILookerTile> this$tiles = this.getTiles();
        SortedSet<ILookerTile> other$tiles = other.getTiles();
        return !(this$tiles == null ? other$tiles != null : !this$tiles.equals(other$tiles));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LookerDashboard;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $sourceLastAccessedAt = this.getSourceLastAccessedAt();
        result = result * 59 + ($sourceLastAccessedAt == null ? 43 : ((Object)$sourceLastAccessedAt).hashCode());
        Long $sourceLastViewedAt = this.getSourceLastViewedAt();
        result = result * 59 + ($sourceLastViewedAt == null ? 43 : ((Object)$sourceLastViewedAt).hashCode());
        Integer $sourceMetadataId = this.getSourceMetadataId();
        result = result * 59 + ($sourceMetadataId == null ? 43 : ((Object)$sourceMetadataId).hashCode());
        Integer $sourceUserId = this.getSourceUserId();
        result = result * 59 + ($sourceUserId == null ? 43 : ((Object)$sourceUserId).hashCode());
        Integer $sourceViewCount = this.getSourceViewCount();
        result = result * 59 + ($sourceViewCount == null ? 43 : ((Object)$sourceViewCount).hashCode());
        Integer $sourcelastUpdaterId = this.getSourcelastUpdaterId();
        result = result * 59 + ($sourcelastUpdaterId == null ? 43 : ((Object)$sourcelastUpdaterId).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<ILookerField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : $fields.hashCode());
        ILookerFolder $folder = this.getFolder();
        result = result * 59 + ($folder == null ? 43 : $folder.hashCode());
        String $folderName = this.getFolderName();
        result = result * 59 + ($folderName == null ? 43 : $folderName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<ILookerLook> $looks = this.getLooks();
        result = result * 59 + ($looks == null ? 43 : $looks.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        SortedSet<ILookerTile> $tiles = this.getTiles();
        result = result * 59 + ($tiles == null ? 43 : $tiles.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "LookerDashboard(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", fields=" + this.getFields() + ", folder=" + this.getFolder() + ", folderName=" + this.getFolderName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", looks=" + this.getLooks() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", sourceLastAccessedAt=" + this.getSourceLastAccessedAt() + ", sourceLastViewedAt=" + this.getSourceLastViewedAt() + ", sourceMetadataId=" + this.getSourceMetadataId() + ", sourceUserId=" + this.getSourceUserId() + ", sourceViewCount=" + this.getSourceViewCount() + ", sourcelastUpdaterId=" + this.getSourcelastUpdaterId() + ", tiles=" + this.getTiles() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class LookerDashboardBuilder<C extends LookerDashboard, B extends LookerDashboardBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<ILookerField> fields;
        @Generated
        private ILookerFolder folder;
        @Generated
        private String folderName;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<ILookerLook> looks;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private Long sourceLastAccessedAt;
        @Generated
        private Long sourceLastViewedAt;
        @Generated
        private Integer sourceMetadataId;
        @Generated
        private Integer sourceUserId;
        @Generated
        private Integer sourceViewCount;
        @Generated
        private Integer sourcelastUpdaterId;
        @Generated
        private ArrayList<ILookerTile> tiles;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LookerDashboardBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LookerDashboard instance, LookerDashboardBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.fields(instance.fields == null ? Collections.emptySortedSet() : instance.fields);
            b.folder(instance.folder);
            b.folderName(instance.folderName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.looks(instance.looks == null ? Collections.emptySortedSet() : instance.looks);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.sourceLastAccessedAt(instance.sourceLastAccessedAt);
            b.sourceLastViewedAt(instance.sourceLastViewedAt);
            b.sourceMetadataId(instance.sourceMetadataId);
            b.sourceUserId(instance.sourceUserId);
            b.sourceViewCount(instance.sourceViewCount);
            b.sourcelastUpdaterId(instance.sourcelastUpdaterId);
            b.tiles(instance.tiles == null ? Collections.emptySortedSet() : instance.tiles);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B field(ILookerField field) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.add(field);
            return (B)this.self();
        }

        @Generated
        public B fields(Collection<? extends ILookerField> fields) {
            if (fields == null) {
                throw new NullPointerException("fields cannot be null");
            }
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.addAll(fields);
            return (B)this.self();
        }

        @Generated
        public B clearFields() {
            if (this.fields != null) {
                this.fields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B folder(ILookerFolder folder) {
            this.folder = folder;
            return (B)this.self();
        }

        @Generated
        public B folderName(String folderName) {
            this.folderName = folderName;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B look(ILookerLook look) {
            if (this.looks == null) {
                this.looks = new ArrayList();
            }
            this.looks.add(look);
            return (B)this.self();
        }

        @Generated
        public B looks(Collection<? extends ILookerLook> looks) {
            if (looks == null) {
                throw new NullPointerException("looks cannot be null");
            }
            if (this.looks == null) {
                this.looks = new ArrayList();
            }
            this.looks.addAll(looks);
            return (B)this.self();
        }

        @Generated
        public B clearLooks() {
            if (this.looks != null) {
                this.looks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sourceLastAccessedAt(Long sourceLastAccessedAt) {
            this.sourceLastAccessedAt = sourceLastAccessedAt;
            return (B)this.self();
        }

        @Generated
        public B sourceLastViewedAt(Long sourceLastViewedAt) {
            this.sourceLastViewedAt = sourceLastViewedAt;
            return (B)this.self();
        }

        @Generated
        public B sourceMetadataId(Integer sourceMetadataId) {
            this.sourceMetadataId = sourceMetadataId;
            return (B)this.self();
        }

        @Generated
        public B sourceUserId(Integer sourceUserId) {
            this.sourceUserId = sourceUserId;
            return (B)this.self();
        }

        @Generated
        public B sourceViewCount(Integer sourceViewCount) {
            this.sourceViewCount = sourceViewCount;
            return (B)this.self();
        }

        @Generated
        public B sourcelastUpdaterId(Integer sourcelastUpdaterId) {
            this.sourcelastUpdaterId = sourcelastUpdaterId;
            return (B)this.self();
        }

        @Generated
        public B tile(ILookerTile tile) {
            if (this.tiles == null) {
                this.tiles = new ArrayList();
            }
            this.tiles.add(tile);
            return (B)this.self();
        }

        @Generated
        public B tiles(Collection<? extends ILookerTile> tiles) {
            if (tiles == null) {
                throw new NullPointerException("tiles cannot be null");
            }
            if (this.tiles == null) {
                this.tiles = new ArrayList();
            }
            this.tiles.addAll(tiles);
            return (B)this.self();
        }

        @Generated
        public B clearTiles() {
            if (this.tiles != null) {
                this.tiles.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "LookerDashboard.LookerDashboardBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", fields=" + this.fields + ", folder=" + this.folder + ", folderName=" + this.folderName + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", looks=" + this.looks + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", sourceLastAccessedAt=" + this.sourceLastAccessedAt + ", sourceLastViewedAt=" + this.sourceLastViewedAt + ", sourceMetadataId=" + this.sourceMetadataId + ", sourceUserId=" + this.sourceUserId + ", sourceViewCount=" + this.sourceViewCount + ", sourcelastUpdaterId=" + this.sourcelastUpdaterId + ", tiles=" + this.tiles + ")";
        }
    }

    @Generated
    private static final class LookerDashboardBuilderImpl
    extends LookerDashboardBuilder<LookerDashboard, LookerDashboardBuilderImpl> {
        @Generated
        private LookerDashboardBuilderImpl() {
        }

        @Override
        @Generated
        protected LookerDashboardBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LookerDashboard build() {
            return new LookerDashboard(this);
        }
    }
}

