/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IMicroStrategy;
import com.atlan.model.assets.IMicroStrategyAttribute;
import com.atlan.model.assets.IMicroStrategyCube;
import com.atlan.model.assets.IMicroStrategyMetric;
import com.atlan.model.assets.IMicroStrategyProject;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroStrategyCube
extends Asset
implements IMicroStrategyCube,
IMicroStrategy,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MicroStrategyCube.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MicroStrategyCube";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IMicroStrategyAttribute> microStrategyAttributes;
    @Attribute
    @Date
    Long microStrategyCertifiedAt;
    @Attribute
    String microStrategyCertifiedBy;
    @Attribute
    SortedSet<String> microStrategyCubeNames;
    @Attribute
    SortedSet<String> microStrategyCubeQualifiedNames;
    @Attribute
    String microStrategyCubeQuery;
    @Attribute
    String microStrategyCubeType;
    @Attribute
    Boolean microStrategyIsCertified;
    @Attribute
    List<Map<String, String>> microStrategyLocation;
    @Attribute
    SortedSet<IMicroStrategyMetric> microStrategyMetrics;
    @Attribute
    IMicroStrategyProject microStrategyProject;
    @Attribute
    String microStrategyProjectName;
    @Attribute
    String microStrategyProjectQualifiedName;
    @Attribute
    SortedSet<String> microStrategyReportNames;
    @Attribute
    SortedSet<String> microStrategyReportQualifiedNames;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;

    @Override
    public MicroStrategyCube trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return MicroStrategyCube.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return MicroStrategyCube.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return MicroStrategyCube.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return MicroStrategyCube.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return MicroStrategyCube.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return MicroStrategyCube.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static MicroStrategyCube refByGuid(String guid) {
        return MicroStrategyCube.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static MicroStrategyCube refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((MicroStrategyCubeBuilder)((MicroStrategyCubeBuilder)MicroStrategyCube._internal().guid(guid)).semantic(semantic)).build();
    }

    public static MicroStrategyCube refByQualifiedName(String qualifiedName) {
        return MicroStrategyCube.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static MicroStrategyCube refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((MicroStrategyCubeBuilder)((MicroStrategyCubeBuilder)MicroStrategyCube._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static MicroStrategyCube get(String id) throws AtlanException {
        return MicroStrategyCube.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static MicroStrategyCube get(AtlanClient client, String id) throws AtlanException {
        return MicroStrategyCube.get(client, id, true);
    }

    @JsonIgnore
    public static MicroStrategyCube get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof MicroStrategyCube) {
                return (MicroStrategyCube)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof MicroStrategyCube) {
            return (MicroStrategyCube)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return MicroStrategyCube.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static MicroStrategyCubeBuilder<?, ?> updater(String qualifiedName, String name) {
        return (MicroStrategyCubeBuilder)((MicroStrategyCubeBuilder)((MicroStrategyCubeBuilder)MicroStrategyCube._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public MicroStrategyCubeBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        MicroStrategyCube.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return MicroStrategyCube.updater(this.getQualifiedName(), this.getName());
    }

    public static MicroStrategyCube removeDescription(String qualifiedName, String name) throws AtlanException {
        return MicroStrategyCube.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MicroStrategyCube removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MicroStrategyCube)Asset.removeDescription(client, MicroStrategyCube.updater(qualifiedName, name));
    }

    public static MicroStrategyCube removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return MicroStrategyCube.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MicroStrategyCube removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MicroStrategyCube)Asset.removeUserDescription(client, MicroStrategyCube.updater(qualifiedName, name));
    }

    public static MicroStrategyCube removeOwners(String qualifiedName, String name) throws AtlanException {
        return MicroStrategyCube.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MicroStrategyCube removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MicroStrategyCube)Asset.removeOwners(client, MicroStrategyCube.updater(qualifiedName, name));
    }

    public static MicroStrategyCube updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return MicroStrategyCube.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static MicroStrategyCube updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (MicroStrategyCube)Asset.updateCertificate(client, MicroStrategyCube._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static MicroStrategyCube removeCertificate(String qualifiedName, String name) throws AtlanException {
        return MicroStrategyCube.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MicroStrategyCube removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MicroStrategyCube)Asset.removeCertificate(client, MicroStrategyCube.updater(qualifiedName, name));
    }

    public static MicroStrategyCube updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return MicroStrategyCube.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static MicroStrategyCube updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MicroStrategyCube)Asset.updateAnnouncement(client, MicroStrategyCube._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static MicroStrategyCube removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return MicroStrategyCube.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static MicroStrategyCube removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (MicroStrategyCube)Asset.removeAnnouncement(client, MicroStrategyCube.updater(qualifiedName, name));
    }

    public static MicroStrategyCube replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return MicroStrategyCube.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static MicroStrategyCube replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (MicroStrategyCube)Asset.replaceTerms(client, MicroStrategyCube.updater(qualifiedName, name), terms);
    }

    public static MicroStrategyCube appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return MicroStrategyCube.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static MicroStrategyCube appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MicroStrategyCube)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static MicroStrategyCube removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return MicroStrategyCube.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static MicroStrategyCube removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (MicroStrategyCube)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static MicroStrategyCube appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return MicroStrategyCube.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static MicroStrategyCube appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (MicroStrategyCube)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static MicroStrategyCube appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return MicroStrategyCube.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static MicroStrategyCube appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (MicroStrategyCube)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        MicroStrategyCube.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected MicroStrategyCube(MicroStrategyCubeBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : MicroStrategyCube.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IMicroStrategyAttribute> microStrategyAttributes = new TreeSet<IMicroStrategyAttribute>();
        if (b.microStrategyAttributes != null) {
            microStrategyAttributes.addAll(b.microStrategyAttributes);
        }
        microStrategyAttributes = Collections.unmodifiableSortedSet(microStrategyAttributes);
        this.microStrategyAttributes = microStrategyAttributes;
        this.microStrategyCertifiedAt = b.microStrategyCertifiedAt;
        this.microStrategyCertifiedBy = b.microStrategyCertifiedBy;
        SortedSet<String> microStrategyCubeNames = new TreeSet<String>();
        if (b.microStrategyCubeNames != null) {
            microStrategyCubeNames.addAll(b.microStrategyCubeNames);
        }
        microStrategyCubeNames = Collections.unmodifiableSortedSet(microStrategyCubeNames);
        this.microStrategyCubeNames = microStrategyCubeNames;
        SortedSet<String> microStrategyCubeQualifiedNames = new TreeSet<String>();
        if (b.microStrategyCubeQualifiedNames != null) {
            microStrategyCubeQualifiedNames.addAll(b.microStrategyCubeQualifiedNames);
        }
        microStrategyCubeQualifiedNames = Collections.unmodifiableSortedSet(microStrategyCubeQualifiedNames);
        this.microStrategyCubeQualifiedNames = microStrategyCubeQualifiedNames;
        this.microStrategyCubeQuery = b.microStrategyCubeQuery;
        this.microStrategyCubeType = b.microStrategyCubeType;
        this.microStrategyIsCertified = b.microStrategyIsCertified;
        this.microStrategyLocation = switch (b.microStrategyLocation == null ? 0 : b.microStrategyLocation.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.microStrategyLocation.get(0));
            default -> Collections.unmodifiableList(new ArrayList<Map<String, String>>(b.microStrategyLocation));
        };
        SortedSet<IMicroStrategyMetric> microStrategyMetrics = new TreeSet<IMicroStrategyMetric>();
        if (b.microStrategyMetrics != null) {
            microStrategyMetrics.addAll(b.microStrategyMetrics);
        }
        microStrategyMetrics = Collections.unmodifiableSortedSet(microStrategyMetrics);
        this.microStrategyMetrics = microStrategyMetrics;
        this.microStrategyProject = b.microStrategyProject;
        this.microStrategyProjectName = b.microStrategyProjectName;
        this.microStrategyProjectQualifiedName = b.microStrategyProjectQualifiedName;
        SortedSet<String> microStrategyReportNames = new TreeSet<String>();
        if (b.microStrategyReportNames != null) {
            microStrategyReportNames.addAll(b.microStrategyReportNames);
        }
        microStrategyReportNames = Collections.unmodifiableSortedSet(microStrategyReportNames);
        this.microStrategyReportNames = microStrategyReportNames;
        SortedSet<String> microStrategyReportQualifiedNames = new TreeSet<String>();
        if (b.microStrategyReportQualifiedNames != null) {
            microStrategyReportQualifiedNames.addAll(b.microStrategyReportQualifiedNames);
        }
        microStrategyReportQualifiedNames = Collections.unmodifiableSortedSet(microStrategyReportQualifiedNames);
        this.microStrategyReportQualifiedNames = microStrategyReportQualifiedNames;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
    }

    @Generated
    public static MicroStrategyCubeBuilder<?, ?> _internal() {
        return new MicroStrategyCubeBuilderImpl();
    }

    @Generated
    public MicroStrategyCubeBuilder<?, ?> toBuilder() {
        return new MicroStrategyCubeBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IMicroStrategyAttribute> getMicroStrategyAttributes() {
        return this.microStrategyAttributes;
    }

    @Override
    @Generated
    public Long getMicroStrategyCertifiedAt() {
        return this.microStrategyCertifiedAt;
    }

    @Override
    @Generated
    public String getMicroStrategyCertifiedBy() {
        return this.microStrategyCertifiedBy;
    }

    @Override
    @Generated
    public SortedSet<String> getMicroStrategyCubeNames() {
        return this.microStrategyCubeNames;
    }

    @Override
    @Generated
    public SortedSet<String> getMicroStrategyCubeQualifiedNames() {
        return this.microStrategyCubeQualifiedNames;
    }

    @Override
    @Generated
    public String getMicroStrategyCubeQuery() {
        return this.microStrategyCubeQuery;
    }

    @Override
    @Generated
    public String getMicroStrategyCubeType() {
        return this.microStrategyCubeType;
    }

    @Override
    @Generated
    public Boolean getMicroStrategyIsCertified() {
        return this.microStrategyIsCertified;
    }

    @Override
    @Generated
    public List<Map<String, String>> getMicroStrategyLocation() {
        return this.microStrategyLocation;
    }

    @Override
    @Generated
    public SortedSet<IMicroStrategyMetric> getMicroStrategyMetrics() {
        return this.microStrategyMetrics;
    }

    @Override
    @Generated
    public IMicroStrategyProject getMicroStrategyProject() {
        return this.microStrategyProject;
    }

    @Override
    @Generated
    public String getMicroStrategyProjectName() {
        return this.microStrategyProjectName;
    }

    @Override
    @Generated
    public String getMicroStrategyProjectQualifiedName() {
        return this.microStrategyProjectQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<String> getMicroStrategyReportNames() {
        return this.microStrategyReportNames;
    }

    @Override
    @Generated
    public SortedSet<String> getMicroStrategyReportQualifiedNames() {
        return this.microStrategyReportQualifiedNames;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MicroStrategyCube)) {
            return false;
        }
        MicroStrategyCube other = (MicroStrategyCube)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$microStrategyCertifiedAt = this.getMicroStrategyCertifiedAt();
        Long other$microStrategyCertifiedAt = other.getMicroStrategyCertifiedAt();
        if (this$microStrategyCertifiedAt == null ? other$microStrategyCertifiedAt != null : !((Object)this$microStrategyCertifiedAt).equals(other$microStrategyCertifiedAt)) {
            return false;
        }
        Boolean this$microStrategyIsCertified = this.getMicroStrategyIsCertified();
        Boolean other$microStrategyIsCertified = other.getMicroStrategyIsCertified();
        if (this$microStrategyIsCertified == null ? other$microStrategyIsCertified != null : !((Object)this$microStrategyIsCertified).equals(other$microStrategyIsCertified)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IMicroStrategyAttribute> this$microStrategyAttributes = this.getMicroStrategyAttributes();
        SortedSet<IMicroStrategyAttribute> other$microStrategyAttributes = other.getMicroStrategyAttributes();
        if (this$microStrategyAttributes == null ? other$microStrategyAttributes != null : !this$microStrategyAttributes.equals(other$microStrategyAttributes)) {
            return false;
        }
        String this$microStrategyCertifiedBy = this.getMicroStrategyCertifiedBy();
        String other$microStrategyCertifiedBy = other.getMicroStrategyCertifiedBy();
        if (this$microStrategyCertifiedBy == null ? other$microStrategyCertifiedBy != null : !this$microStrategyCertifiedBy.equals(other$microStrategyCertifiedBy)) {
            return false;
        }
        SortedSet<String> this$microStrategyCubeNames = this.getMicroStrategyCubeNames();
        SortedSet<String> other$microStrategyCubeNames = other.getMicroStrategyCubeNames();
        if (this$microStrategyCubeNames == null ? other$microStrategyCubeNames != null : !this$microStrategyCubeNames.equals(other$microStrategyCubeNames)) {
            return false;
        }
        SortedSet<String> this$microStrategyCubeQualifiedNames = this.getMicroStrategyCubeQualifiedNames();
        SortedSet<String> other$microStrategyCubeQualifiedNames = other.getMicroStrategyCubeQualifiedNames();
        if (this$microStrategyCubeQualifiedNames == null ? other$microStrategyCubeQualifiedNames != null : !this$microStrategyCubeQualifiedNames.equals(other$microStrategyCubeQualifiedNames)) {
            return false;
        }
        String this$microStrategyCubeQuery = this.getMicroStrategyCubeQuery();
        String other$microStrategyCubeQuery = other.getMicroStrategyCubeQuery();
        if (this$microStrategyCubeQuery == null ? other$microStrategyCubeQuery != null : !this$microStrategyCubeQuery.equals(other$microStrategyCubeQuery)) {
            return false;
        }
        String this$microStrategyCubeType = this.getMicroStrategyCubeType();
        String other$microStrategyCubeType = other.getMicroStrategyCubeType();
        if (this$microStrategyCubeType == null ? other$microStrategyCubeType != null : !this$microStrategyCubeType.equals(other$microStrategyCubeType)) {
            return false;
        }
        List<Map<String, String>> this$microStrategyLocation = this.getMicroStrategyLocation();
        List<Map<String, String>> other$microStrategyLocation = other.getMicroStrategyLocation();
        if (this$microStrategyLocation == null ? other$microStrategyLocation != null : !((Object)this$microStrategyLocation).equals(other$microStrategyLocation)) {
            return false;
        }
        SortedSet<IMicroStrategyMetric> this$microStrategyMetrics = this.getMicroStrategyMetrics();
        SortedSet<IMicroStrategyMetric> other$microStrategyMetrics = other.getMicroStrategyMetrics();
        if (this$microStrategyMetrics == null ? other$microStrategyMetrics != null : !this$microStrategyMetrics.equals(other$microStrategyMetrics)) {
            return false;
        }
        IMicroStrategyProject this$microStrategyProject = this.getMicroStrategyProject();
        IMicroStrategyProject other$microStrategyProject = other.getMicroStrategyProject();
        if (this$microStrategyProject == null ? other$microStrategyProject != null : !this$microStrategyProject.equals(other$microStrategyProject)) {
            return false;
        }
        String this$microStrategyProjectName = this.getMicroStrategyProjectName();
        String other$microStrategyProjectName = other.getMicroStrategyProjectName();
        if (this$microStrategyProjectName == null ? other$microStrategyProjectName != null : !this$microStrategyProjectName.equals(other$microStrategyProjectName)) {
            return false;
        }
        String this$microStrategyProjectQualifiedName = this.getMicroStrategyProjectQualifiedName();
        String other$microStrategyProjectQualifiedName = other.getMicroStrategyProjectQualifiedName();
        if (this$microStrategyProjectQualifiedName == null ? other$microStrategyProjectQualifiedName != null : !this$microStrategyProjectQualifiedName.equals(other$microStrategyProjectQualifiedName)) {
            return false;
        }
        SortedSet<String> this$microStrategyReportNames = this.getMicroStrategyReportNames();
        SortedSet<String> other$microStrategyReportNames = other.getMicroStrategyReportNames();
        if (this$microStrategyReportNames == null ? other$microStrategyReportNames != null : !this$microStrategyReportNames.equals(other$microStrategyReportNames)) {
            return false;
        }
        SortedSet<String> this$microStrategyReportQualifiedNames = this.getMicroStrategyReportQualifiedNames();
        SortedSet<String> other$microStrategyReportQualifiedNames = other.getMicroStrategyReportQualifiedNames();
        if (this$microStrategyReportQualifiedNames == null ? other$microStrategyReportQualifiedNames != null : !this$microStrategyReportQualifiedNames.equals(other$microStrategyReportQualifiedNames)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        return !(this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MicroStrategyCube;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $microStrategyCertifiedAt = this.getMicroStrategyCertifiedAt();
        result = result * 59 + ($microStrategyCertifiedAt == null ? 43 : ((Object)$microStrategyCertifiedAt).hashCode());
        Boolean $microStrategyIsCertified = this.getMicroStrategyIsCertified();
        result = result * 59 + ($microStrategyIsCertified == null ? 43 : ((Object)$microStrategyIsCertified).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IMicroStrategyAttribute> $microStrategyAttributes = this.getMicroStrategyAttributes();
        result = result * 59 + ($microStrategyAttributes == null ? 43 : $microStrategyAttributes.hashCode());
        String $microStrategyCertifiedBy = this.getMicroStrategyCertifiedBy();
        result = result * 59 + ($microStrategyCertifiedBy == null ? 43 : $microStrategyCertifiedBy.hashCode());
        SortedSet<String> $microStrategyCubeNames = this.getMicroStrategyCubeNames();
        result = result * 59 + ($microStrategyCubeNames == null ? 43 : $microStrategyCubeNames.hashCode());
        SortedSet<String> $microStrategyCubeQualifiedNames = this.getMicroStrategyCubeQualifiedNames();
        result = result * 59 + ($microStrategyCubeQualifiedNames == null ? 43 : $microStrategyCubeQualifiedNames.hashCode());
        String $microStrategyCubeQuery = this.getMicroStrategyCubeQuery();
        result = result * 59 + ($microStrategyCubeQuery == null ? 43 : $microStrategyCubeQuery.hashCode());
        String $microStrategyCubeType = this.getMicroStrategyCubeType();
        result = result * 59 + ($microStrategyCubeType == null ? 43 : $microStrategyCubeType.hashCode());
        List<Map<String, String>> $microStrategyLocation = this.getMicroStrategyLocation();
        result = result * 59 + ($microStrategyLocation == null ? 43 : ((Object)$microStrategyLocation).hashCode());
        SortedSet<IMicroStrategyMetric> $microStrategyMetrics = this.getMicroStrategyMetrics();
        result = result * 59 + ($microStrategyMetrics == null ? 43 : $microStrategyMetrics.hashCode());
        IMicroStrategyProject $microStrategyProject = this.getMicroStrategyProject();
        result = result * 59 + ($microStrategyProject == null ? 43 : $microStrategyProject.hashCode());
        String $microStrategyProjectName = this.getMicroStrategyProjectName();
        result = result * 59 + ($microStrategyProjectName == null ? 43 : $microStrategyProjectName.hashCode());
        String $microStrategyProjectQualifiedName = this.getMicroStrategyProjectQualifiedName();
        result = result * 59 + ($microStrategyProjectQualifiedName == null ? 43 : $microStrategyProjectQualifiedName.hashCode());
        SortedSet<String> $microStrategyReportNames = this.getMicroStrategyReportNames();
        result = result * 59 + ($microStrategyReportNames == null ? 43 : $microStrategyReportNames.hashCode());
        SortedSet<String> $microStrategyReportQualifiedNames = this.getMicroStrategyReportQualifiedNames();
        result = result * 59 + ($microStrategyReportQualifiedNames == null ? 43 : $microStrategyReportQualifiedNames.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "MicroStrategyCube(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", microStrategyAttributes=" + this.getMicroStrategyAttributes() + ", microStrategyCertifiedAt=" + this.getMicroStrategyCertifiedAt() + ", microStrategyCertifiedBy=" + this.getMicroStrategyCertifiedBy() + ", microStrategyCubeNames=" + this.getMicroStrategyCubeNames() + ", microStrategyCubeQualifiedNames=" + this.getMicroStrategyCubeQualifiedNames() + ", microStrategyCubeQuery=" + this.getMicroStrategyCubeQuery() + ", microStrategyCubeType=" + this.getMicroStrategyCubeType() + ", microStrategyIsCertified=" + this.getMicroStrategyIsCertified() + ", microStrategyLocation=" + this.getMicroStrategyLocation() + ", microStrategyMetrics=" + this.getMicroStrategyMetrics() + ", microStrategyProject=" + this.getMicroStrategyProject() + ", microStrategyProjectName=" + this.getMicroStrategyProjectName() + ", microStrategyProjectQualifiedName=" + this.getMicroStrategyProjectQualifiedName() + ", microStrategyReportNames=" + this.getMicroStrategyReportNames() + ", microStrategyReportQualifiedNames=" + this.getMicroStrategyReportQualifiedNames() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class MicroStrategyCubeBuilder<C extends MicroStrategyCube, B extends MicroStrategyCubeBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IMicroStrategyAttribute> microStrategyAttributes;
        @Generated
        private Long microStrategyCertifiedAt;
        @Generated
        private String microStrategyCertifiedBy;
        @Generated
        private ArrayList<String> microStrategyCubeNames;
        @Generated
        private ArrayList<String> microStrategyCubeQualifiedNames;
        @Generated
        private String microStrategyCubeQuery;
        @Generated
        private String microStrategyCubeType;
        @Generated
        private Boolean microStrategyIsCertified;
        @Generated
        private ArrayList<Map<String, String>> microStrategyLocation;
        @Generated
        private ArrayList<IMicroStrategyMetric> microStrategyMetrics;
        @Generated
        private IMicroStrategyProject microStrategyProject;
        @Generated
        private String microStrategyProjectName;
        @Generated
        private String microStrategyProjectQualifiedName;
        @Generated
        private ArrayList<String> microStrategyReportNames;
        @Generated
        private ArrayList<String> microStrategyReportQualifiedNames;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MicroStrategyCubeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(MicroStrategyCube instance, MicroStrategyCubeBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.microStrategyAttributes(instance.microStrategyAttributes == null ? Collections.emptySortedSet() : instance.microStrategyAttributes);
            b.microStrategyCertifiedAt(instance.microStrategyCertifiedAt);
            b.microStrategyCertifiedBy(instance.microStrategyCertifiedBy);
            b.microStrategyCubeNames(instance.microStrategyCubeNames == null ? Collections.emptySortedSet() : instance.microStrategyCubeNames);
            b.microStrategyCubeQualifiedNames(instance.microStrategyCubeQualifiedNames == null ? Collections.emptySortedSet() : instance.microStrategyCubeQualifiedNames);
            b.microStrategyCubeQuery(instance.microStrategyCubeQuery);
            b.microStrategyCubeType(instance.microStrategyCubeType);
            b.microStrategyIsCertified(instance.microStrategyIsCertified);
            b.microStrategyLocation(instance.microStrategyLocation == null ? Collections.emptyList() : instance.microStrategyLocation);
            b.microStrategyMetrics(instance.microStrategyMetrics == null ? Collections.emptySortedSet() : instance.microStrategyMetrics);
            b.microStrategyProject(instance.microStrategyProject);
            b.microStrategyProjectName(instance.microStrategyProjectName);
            b.microStrategyProjectQualifiedName(instance.microStrategyProjectQualifiedName);
            b.microStrategyReportNames(instance.microStrategyReportNames == null ? Collections.emptySortedSet() : instance.microStrategyReportNames);
            b.microStrategyReportQualifiedNames(instance.microStrategyReportQualifiedNames == null ? Collections.emptySortedSet() : instance.microStrategyReportQualifiedNames);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B microStrategyAttribute(IMicroStrategyAttribute microStrategyAttribute) {
            if (this.microStrategyAttributes == null) {
                this.microStrategyAttributes = new ArrayList();
            }
            this.microStrategyAttributes.add(microStrategyAttribute);
            return (B)this.self();
        }

        @Generated
        public B microStrategyAttributes(Collection<? extends IMicroStrategyAttribute> microStrategyAttributes) {
            if (microStrategyAttributes == null) {
                throw new NullPointerException("microStrategyAttributes cannot be null");
            }
            if (this.microStrategyAttributes == null) {
                this.microStrategyAttributes = new ArrayList();
            }
            this.microStrategyAttributes.addAll(microStrategyAttributes);
            return (B)this.self();
        }

        @Generated
        public B clearMicroStrategyAttributes() {
            if (this.microStrategyAttributes != null) {
                this.microStrategyAttributes.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B microStrategyCertifiedAt(Long microStrategyCertifiedAt) {
            this.microStrategyCertifiedAt = microStrategyCertifiedAt;
            return (B)this.self();
        }

        @Generated
        public B microStrategyCertifiedBy(String microStrategyCertifiedBy) {
            this.microStrategyCertifiedBy = microStrategyCertifiedBy;
            return (B)this.self();
        }

        @Generated
        public B microStrategyCubeName(String microStrategyCubeName) {
            if (this.microStrategyCubeNames == null) {
                this.microStrategyCubeNames = new ArrayList();
            }
            this.microStrategyCubeNames.add(microStrategyCubeName);
            return (B)this.self();
        }

        @Generated
        public B microStrategyCubeNames(Collection<? extends String> microStrategyCubeNames) {
            if (microStrategyCubeNames == null) {
                throw new NullPointerException("microStrategyCubeNames cannot be null");
            }
            if (this.microStrategyCubeNames == null) {
                this.microStrategyCubeNames = new ArrayList();
            }
            this.microStrategyCubeNames.addAll(microStrategyCubeNames);
            return (B)this.self();
        }

        @Generated
        public B clearMicroStrategyCubeNames() {
            if (this.microStrategyCubeNames != null) {
                this.microStrategyCubeNames.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B microStrategyCubeQualifiedName(String microStrategyCubeQualifiedName) {
            if (this.microStrategyCubeQualifiedNames == null) {
                this.microStrategyCubeQualifiedNames = new ArrayList();
            }
            this.microStrategyCubeQualifiedNames.add(microStrategyCubeQualifiedName);
            return (B)this.self();
        }

        @Generated
        public B microStrategyCubeQualifiedNames(Collection<? extends String> microStrategyCubeQualifiedNames) {
            if (microStrategyCubeQualifiedNames == null) {
                throw new NullPointerException("microStrategyCubeQualifiedNames cannot be null");
            }
            if (this.microStrategyCubeQualifiedNames == null) {
                this.microStrategyCubeQualifiedNames = new ArrayList();
            }
            this.microStrategyCubeQualifiedNames.addAll(microStrategyCubeQualifiedNames);
            return (B)this.self();
        }

        @Generated
        public B clearMicroStrategyCubeQualifiedNames() {
            if (this.microStrategyCubeQualifiedNames != null) {
                this.microStrategyCubeQualifiedNames.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B microStrategyCubeQuery(String microStrategyCubeQuery) {
            this.microStrategyCubeQuery = microStrategyCubeQuery;
            return (B)this.self();
        }

        @Generated
        public B microStrategyCubeType(String microStrategyCubeType) {
            this.microStrategyCubeType = microStrategyCubeType;
            return (B)this.self();
        }

        @Generated
        public B microStrategyIsCertified(Boolean microStrategyIsCertified) {
            this.microStrategyIsCertified = microStrategyIsCertified;
            return (B)this.self();
        }

        @Generated
        public B putMicroStrategyLocation(Map<String, String> putMicroStrategyLocation) {
            if (this.microStrategyLocation == null) {
                this.microStrategyLocation = new ArrayList();
            }
            this.microStrategyLocation.add(putMicroStrategyLocation);
            return (B)this.self();
        }

        @Generated
        public B microStrategyLocation(Collection<? extends Map<String, String>> microStrategyLocation) {
            if (microStrategyLocation == null) {
                throw new NullPointerException("microStrategyLocation cannot be null");
            }
            if (this.microStrategyLocation == null) {
                this.microStrategyLocation = new ArrayList();
            }
            this.microStrategyLocation.addAll(microStrategyLocation);
            return (B)this.self();
        }

        @Generated
        public B clearMicroStrategyLocation() {
            if (this.microStrategyLocation != null) {
                this.microStrategyLocation.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B microStrategyMetric(IMicroStrategyMetric microStrategyMetric) {
            if (this.microStrategyMetrics == null) {
                this.microStrategyMetrics = new ArrayList();
            }
            this.microStrategyMetrics.add(microStrategyMetric);
            return (B)this.self();
        }

        @Generated
        public B microStrategyMetrics(Collection<? extends IMicroStrategyMetric> microStrategyMetrics) {
            if (microStrategyMetrics == null) {
                throw new NullPointerException("microStrategyMetrics cannot be null");
            }
            if (this.microStrategyMetrics == null) {
                this.microStrategyMetrics = new ArrayList();
            }
            this.microStrategyMetrics.addAll(microStrategyMetrics);
            return (B)this.self();
        }

        @Generated
        public B clearMicroStrategyMetrics() {
            if (this.microStrategyMetrics != null) {
                this.microStrategyMetrics.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B microStrategyProject(IMicroStrategyProject microStrategyProject) {
            this.microStrategyProject = microStrategyProject;
            return (B)this.self();
        }

        @Generated
        public B microStrategyProjectName(String microStrategyProjectName) {
            this.microStrategyProjectName = microStrategyProjectName;
            return (B)this.self();
        }

        @Generated
        public B microStrategyProjectQualifiedName(String microStrategyProjectQualifiedName) {
            this.microStrategyProjectQualifiedName = microStrategyProjectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B microStrategyReportName(String microStrategyReportName) {
            if (this.microStrategyReportNames == null) {
                this.microStrategyReportNames = new ArrayList();
            }
            this.microStrategyReportNames.add(microStrategyReportName);
            return (B)this.self();
        }

        @Generated
        public B microStrategyReportNames(Collection<? extends String> microStrategyReportNames) {
            if (microStrategyReportNames == null) {
                throw new NullPointerException("microStrategyReportNames cannot be null");
            }
            if (this.microStrategyReportNames == null) {
                this.microStrategyReportNames = new ArrayList();
            }
            this.microStrategyReportNames.addAll(microStrategyReportNames);
            return (B)this.self();
        }

        @Generated
        public B clearMicroStrategyReportNames() {
            if (this.microStrategyReportNames != null) {
                this.microStrategyReportNames.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B microStrategyReportQualifiedName(String microStrategyReportQualifiedName) {
            if (this.microStrategyReportQualifiedNames == null) {
                this.microStrategyReportQualifiedNames = new ArrayList();
            }
            this.microStrategyReportQualifiedNames.add(microStrategyReportQualifiedName);
            return (B)this.self();
        }

        @Generated
        public B microStrategyReportQualifiedNames(Collection<? extends String> microStrategyReportQualifiedNames) {
            if (microStrategyReportQualifiedNames == null) {
                throw new NullPointerException("microStrategyReportQualifiedNames cannot be null");
            }
            if (this.microStrategyReportQualifiedNames == null) {
                this.microStrategyReportQualifiedNames = new ArrayList();
            }
            this.microStrategyReportQualifiedNames.addAll(microStrategyReportQualifiedNames);
            return (B)this.self();
        }

        @Generated
        public B clearMicroStrategyReportQualifiedNames() {
            if (this.microStrategyReportQualifiedNames != null) {
                this.microStrategyReportQualifiedNames.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "MicroStrategyCube.MicroStrategyCubeBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", microStrategyAttributes=" + this.microStrategyAttributes + ", microStrategyCertifiedAt=" + this.microStrategyCertifiedAt + ", microStrategyCertifiedBy=" + this.microStrategyCertifiedBy + ", microStrategyCubeNames=" + this.microStrategyCubeNames + ", microStrategyCubeQualifiedNames=" + this.microStrategyCubeQualifiedNames + ", microStrategyCubeQuery=" + this.microStrategyCubeQuery + ", microStrategyCubeType=" + this.microStrategyCubeType + ", microStrategyIsCertified=" + this.microStrategyIsCertified + ", microStrategyLocation=" + this.microStrategyLocation + ", microStrategyMetrics=" + this.microStrategyMetrics + ", microStrategyProject=" + this.microStrategyProject + ", microStrategyProjectName=" + this.microStrategyProjectName + ", microStrategyProjectQualifiedName=" + this.microStrategyProjectQualifiedName + ", microStrategyReportNames=" + this.microStrategyReportNames + ", microStrategyReportQualifiedNames=" + this.microStrategyReportQualifiedNames + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ")";
        }
    }

    @Generated
    private static final class MicroStrategyCubeBuilderImpl
    extends MicroStrategyCubeBuilder<MicroStrategyCube, MicroStrategyCubeBuilderImpl> {
        @Generated
        private MicroStrategyCubeBuilderImpl() {
        }

        @Override
        @Generated
        protected MicroStrategyCubeBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MicroStrategyCube build() {
            return new MicroStrategyCube(this);
        }
    }
}

