/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IPowerBI;
import com.atlan.model.assets.IPowerBIDataset;
import com.atlan.model.assets.IPowerBIDatasource;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.PowerBIEndorsementType;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerBIDatasource
extends Asset
implements IPowerBIDatasource,
IPowerBI,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PowerBIDatasource.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PowerBIDatasource";
    String typeName;
    @Attribute
    Map<String, String> connectionDetails;
    @Attribute
    SortedSet<IPowerBIDataset> datasets;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    PowerBIEndorsementType powerBIEndorsement;
    @Attribute
    String powerBIFormatString;
    @Attribute
    Boolean powerBIIsHidden;
    @Attribute
    String powerBITableQualifiedName;

    @Override
    public PowerBIDatasource trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return PowerBIDatasource.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return PowerBIDatasource.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return PowerBIDatasource.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return PowerBIDatasource.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return PowerBIDatasource.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return PowerBIDatasource.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static PowerBIDatasource refByGuid(String guid) {
        return PowerBIDatasource.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static PowerBIDatasource refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((PowerBIDatasourceBuilder)((PowerBIDatasourceBuilder)PowerBIDatasource._internal().guid(guid)).semantic(semantic)).build();
    }

    public static PowerBIDatasource refByQualifiedName(String qualifiedName) {
        return PowerBIDatasource.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static PowerBIDatasource refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((PowerBIDatasourceBuilder)((PowerBIDatasourceBuilder)PowerBIDatasource._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static PowerBIDatasource get(String id) throws AtlanException {
        return PowerBIDatasource.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static PowerBIDatasource get(AtlanClient client, String id) throws AtlanException {
        return PowerBIDatasource.get(client, id, true);
    }

    @JsonIgnore
    public static PowerBIDatasource get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof PowerBIDatasource) {
                return (PowerBIDatasource)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof PowerBIDatasource) {
            return (PowerBIDatasource)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return PowerBIDatasource.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static PowerBIDatasourceBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PowerBIDatasourceBuilder)((PowerBIDatasourceBuilder)((PowerBIDatasourceBuilder)PowerBIDatasource._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public PowerBIDatasourceBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        PowerBIDatasource.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return PowerBIDatasource.updater(this.getQualifiedName(), this.getName());
    }

    public static PowerBIDatasource removeDescription(String qualifiedName, String name) throws AtlanException {
        return PowerBIDatasource.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PowerBIDatasource removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIDatasource)Asset.removeDescription(client, PowerBIDatasource.updater(qualifiedName, name));
    }

    public static PowerBIDatasource removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return PowerBIDatasource.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PowerBIDatasource removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIDatasource)Asset.removeUserDescription(client, PowerBIDatasource.updater(qualifiedName, name));
    }

    public static PowerBIDatasource removeOwners(String qualifiedName, String name) throws AtlanException {
        return PowerBIDatasource.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PowerBIDatasource removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIDatasource)Asset.removeOwners(client, PowerBIDatasource.updater(qualifiedName, name));
    }

    public static PowerBIDatasource updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return PowerBIDatasource.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static PowerBIDatasource updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (PowerBIDatasource)Asset.updateCertificate(client, PowerBIDatasource._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PowerBIDatasource removeCertificate(String qualifiedName, String name) throws AtlanException {
        return PowerBIDatasource.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PowerBIDatasource removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIDatasource)Asset.removeCertificate(client, PowerBIDatasource.updater(qualifiedName, name));
    }

    public static PowerBIDatasource updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return PowerBIDatasource.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static PowerBIDatasource updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PowerBIDatasource)Asset.updateAnnouncement(client, PowerBIDatasource._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PowerBIDatasource removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return PowerBIDatasource.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PowerBIDatasource removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PowerBIDatasource)Asset.removeAnnouncement(client, PowerBIDatasource.updater(qualifiedName, name));
    }

    public static PowerBIDatasource replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return PowerBIDatasource.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static PowerBIDatasource replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIDatasource)Asset.replaceTerms(client, PowerBIDatasource.updater(qualifiedName, name), terms);
    }

    public static PowerBIDatasource appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return PowerBIDatasource.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static PowerBIDatasource appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIDatasource)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static PowerBIDatasource removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return PowerBIDatasource.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static PowerBIDatasource removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PowerBIDatasource)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static PowerBIDatasource appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return PowerBIDatasource.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static PowerBIDatasource appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (PowerBIDatasource)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static PowerBIDatasource appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return PowerBIDatasource.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static PowerBIDatasource appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (PowerBIDatasource)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        PowerBIDatasource.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PowerBIDatasource(PowerBIDatasourceBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> connectionDetails;
        this.typeName = b.typeName$set ? b.typeName$value : PowerBIDatasource.$default$typeName();
        switch (b.connectionDetails$key == null ? 0 : b.connectionDetails$key.size()) {
            case 0: {
                connectionDetails = Collections.emptyMap();
                break;
            }
            case 1: {
                connectionDetails = Collections.singletonMap(b.connectionDetails$key.get(0), b.connectionDetails$value.get(0));
                break;
            }
            default: {
                connectionDetails = new LinkedHashMap(b.connectionDetails$key.size() < 0x40000000 ? 1 + b.connectionDetails$key.size() + (b.connectionDetails$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.connectionDetails$key.size(); ++$i) {
                    connectionDetails.put(b.connectionDetails$key.get($i), b.connectionDetails$value.get($i));
                }
                connectionDetails = Collections.unmodifiableMap(connectionDetails);
            }
        }
        this.connectionDetails = connectionDetails;
        SortedSet<IPowerBIDataset> datasets = new TreeSet<IPowerBIDataset>();
        if (b.datasets != null) {
            datasets.addAll(b.datasets);
        }
        datasets = Collections.unmodifiableSortedSet(datasets);
        this.datasets = datasets;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.powerBIEndorsement = b.powerBIEndorsement;
        this.powerBIFormatString = b.powerBIFormatString;
        this.powerBIIsHidden = b.powerBIIsHidden;
        this.powerBITableQualifiedName = b.powerBITableQualifiedName;
    }

    @Generated
    public static PowerBIDatasourceBuilder<?, ?> _internal() {
        return new PowerBIDatasourceBuilderImpl();
    }

    @Generated
    public PowerBIDatasourceBuilder<?, ?> toBuilder() {
        return new PowerBIDatasourceBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public Map<String, String> getConnectionDetails() {
        return this.connectionDetails;
    }

    @Override
    @Generated
    public SortedSet<IPowerBIDataset> getDatasets() {
        return this.datasets;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public PowerBIEndorsementType getPowerBIEndorsement() {
        return this.powerBIEndorsement;
    }

    @Override
    @Generated
    public String getPowerBIFormatString() {
        return this.powerBIFormatString;
    }

    @Override
    @Generated
    public Boolean getPowerBIIsHidden() {
        return this.powerBIIsHidden;
    }

    @Override
    @Generated
    public String getPowerBITableQualifiedName() {
        return this.powerBITableQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerBIDatasource)) {
            return false;
        }
        PowerBIDatasource other = (PowerBIDatasource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$powerBIIsHidden = this.getPowerBIIsHidden();
        Boolean other$powerBIIsHidden = other.getPowerBIIsHidden();
        if (this$powerBIIsHidden == null ? other$powerBIIsHidden != null : !((Object)this$powerBIIsHidden).equals(other$powerBIIsHidden)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        Map<String, String> this$connectionDetails = this.getConnectionDetails();
        Map<String, String> other$connectionDetails = other.getConnectionDetails();
        if (this$connectionDetails == null ? other$connectionDetails != null : !((Object)this$connectionDetails).equals(other$connectionDetails)) {
            return false;
        }
        SortedSet<IPowerBIDataset> this$datasets = this.getDatasets();
        SortedSet<IPowerBIDataset> other$datasets = other.getDatasets();
        if (this$datasets == null ? other$datasets != null : !this$datasets.equals(other$datasets)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        PowerBIEndorsementType this$powerBIEndorsement = this.getPowerBIEndorsement();
        PowerBIEndorsementType other$powerBIEndorsement = other.getPowerBIEndorsement();
        if (this$powerBIEndorsement == null ? other$powerBIEndorsement != null : !this$powerBIEndorsement.equals(other$powerBIEndorsement)) {
            return false;
        }
        String this$powerBIFormatString = this.getPowerBIFormatString();
        String other$powerBIFormatString = other.getPowerBIFormatString();
        if (this$powerBIFormatString == null ? other$powerBIFormatString != null : !this$powerBIFormatString.equals(other$powerBIFormatString)) {
            return false;
        }
        String this$powerBITableQualifiedName = this.getPowerBITableQualifiedName();
        String other$powerBITableQualifiedName = other.getPowerBITableQualifiedName();
        return !(this$powerBITableQualifiedName == null ? other$powerBITableQualifiedName != null : !this$powerBITableQualifiedName.equals(other$powerBITableQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PowerBIDatasource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $powerBIIsHidden = this.getPowerBIIsHidden();
        result = result * 59 + ($powerBIIsHidden == null ? 43 : ((Object)$powerBIIsHidden).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        Map<String, String> $connectionDetails = this.getConnectionDetails();
        result = result * 59 + ($connectionDetails == null ? 43 : ((Object)$connectionDetails).hashCode());
        SortedSet<IPowerBIDataset> $datasets = this.getDatasets();
        result = result * 59 + ($datasets == null ? 43 : $datasets.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        PowerBIEndorsementType $powerBIEndorsement = this.getPowerBIEndorsement();
        result = result * 59 + ($powerBIEndorsement == null ? 43 : $powerBIEndorsement.hashCode());
        String $powerBIFormatString = this.getPowerBIFormatString();
        result = result * 59 + ($powerBIFormatString == null ? 43 : $powerBIFormatString.hashCode());
        String $powerBITableQualifiedName = this.getPowerBITableQualifiedName();
        result = result * 59 + ($powerBITableQualifiedName == null ? 43 : $powerBITableQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "PowerBIDatasource(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", connectionDetails=" + this.getConnectionDetails() + ", datasets=" + this.getDatasets() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", powerBIEndorsement=" + this.getPowerBIEndorsement() + ", powerBIFormatString=" + this.getPowerBIFormatString() + ", powerBIIsHidden=" + this.getPowerBIIsHidden() + ", powerBITableQualifiedName=" + this.getPowerBITableQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class PowerBIDatasourceBuilder<C extends PowerBIDatasource, B extends PowerBIDatasourceBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<String> connectionDetails$key;
        @Generated
        private ArrayList<String> connectionDetails$value;
        @Generated
        private ArrayList<IPowerBIDataset> datasets;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private PowerBIEndorsementType powerBIEndorsement;
        @Generated
        private String powerBIFormatString;
        @Generated
        private Boolean powerBIIsHidden;
        @Generated
        private String powerBITableQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PowerBIDatasourceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PowerBIDatasource instance, PowerBIDatasourceBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.connectionDetails(instance.connectionDetails == null ? Collections.emptyMap() : instance.connectionDetails);
            b.datasets(instance.datasets == null ? Collections.emptySortedSet() : instance.datasets);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.powerBIEndorsement(instance.powerBIEndorsement);
            b.powerBIFormatString(instance.powerBIFormatString);
            b.powerBIIsHidden(instance.powerBIIsHidden);
            b.powerBITableQualifiedName(instance.powerBITableQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B connectionDetail(String connectionDetailKey, String connectionDetailValue) {
            if (this.connectionDetails$key == null) {
                this.connectionDetails$key = new ArrayList();
                this.connectionDetails$value = new ArrayList();
            }
            this.connectionDetails$key.add(connectionDetailKey);
            this.connectionDetails$value.add(connectionDetailValue);
            return (B)this.self();
        }

        @Generated
        public B connectionDetails(Map<? extends String, ? extends String> connectionDetails) {
            if (connectionDetails == null) {
                throw new NullPointerException("connectionDetails cannot be null");
            }
            if (this.connectionDetails$key == null) {
                this.connectionDetails$key = new ArrayList();
                this.connectionDetails$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : connectionDetails.entrySet()) {
                this.connectionDetails$key.add($lombokEntry.getKey());
                this.connectionDetails$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearConnectionDetails() {
            if (this.connectionDetails$key != null) {
                this.connectionDetails$key.clear();
                this.connectionDetails$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dataset(IPowerBIDataset dataset) {
            if (this.datasets == null) {
                this.datasets = new ArrayList();
            }
            this.datasets.add(dataset);
            return (B)this.self();
        }

        @Generated
        public B datasets(Collection<? extends IPowerBIDataset> datasets) {
            if (datasets == null) {
                throw new NullPointerException("datasets cannot be null");
            }
            if (this.datasets == null) {
                this.datasets = new ArrayList();
            }
            this.datasets.addAll(datasets);
            return (B)this.self();
        }

        @Generated
        public B clearDatasets() {
            if (this.datasets != null) {
                this.datasets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B powerBIEndorsement(PowerBIEndorsementType powerBIEndorsement) {
            this.powerBIEndorsement = powerBIEndorsement;
            return (B)this.self();
        }

        @Generated
        public B powerBIFormatString(String powerBIFormatString) {
            this.powerBIFormatString = powerBIFormatString;
            return (B)this.self();
        }

        @Generated
        public B powerBIIsHidden(Boolean powerBIIsHidden) {
            this.powerBIIsHidden = powerBIIsHidden;
            return (B)this.self();
        }

        @Generated
        public B powerBITableQualifiedName(String powerBITableQualifiedName) {
            this.powerBITableQualifiedName = powerBITableQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PowerBIDatasource.PowerBIDatasourceBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", connectionDetails$key=" + this.connectionDetails$key + ", connectionDetails$value=" + this.connectionDetails$value + ", datasets=" + this.datasets + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", powerBIEndorsement=" + this.powerBIEndorsement + ", powerBIFormatString=" + this.powerBIFormatString + ", powerBIIsHidden=" + this.powerBIIsHidden + ", powerBITableQualifiedName=" + this.powerBITableQualifiedName + ")";
        }
    }

    @Generated
    private static final class PowerBIDatasourceBuilderImpl
    extends PowerBIDatasourceBuilder<PowerBIDatasource, PowerBIDatasourceBuilderImpl> {
        @Generated
        private PowerBIDatasourceBuilderImpl() {
        }

        @Override
        @Generated
        protected PowerBIDatasourceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PowerBIDatasource build() {
            return new PowerBIDatasource(this);
        }
    }
}

