/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IPreset;
import com.atlan.model.assets.IPresetChart;
import com.atlan.model.assets.IPresetDashboard;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.assets.PresetDashboard;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PresetChart
extends Asset
implements IPresetChart,
IPreset,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PresetChart.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "PresetChart";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    String presetChartDescriptionMarkdown;
    @Attribute
    Map<String, String> presetChartFormData;
    @Attribute
    IPresetDashboard presetDashboard;
    @Attribute
    Long presetDashboardId;
    @Attribute
    String presetDashboardQualifiedName;
    @Attribute
    Long presetWorkspaceId;
    @Attribute
    String presetWorkspaceQualifiedName;

    @Override
    public PresetChart trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return PresetChart.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return PresetChart.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return PresetChart.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return PresetChart.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return PresetChart.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return PresetChart.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static PresetChart refByGuid(String guid) {
        return PresetChart.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static PresetChart refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((PresetChartBuilder)((PresetChartBuilder)PresetChart._internal().guid(guid)).semantic(semantic)).build();
    }

    public static PresetChart refByQualifiedName(String qualifiedName) {
        return PresetChart.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static PresetChart refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((PresetChartBuilder)((PresetChartBuilder)PresetChart._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static PresetChart get(String id) throws AtlanException {
        return PresetChart.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static PresetChart get(AtlanClient client, String id) throws AtlanException {
        return PresetChart.get(client, id, true);
    }

    @JsonIgnore
    public static PresetChart get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof PresetChart) {
                return (PresetChart)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof PresetChart) {
            return (PresetChart)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return PresetChart.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static PresetChartBuilder<?, ?> creator(String name, PresetDashboard collection) throws InvalidRequestException {
        PresetChart.validateRelationship("PresetDashboard", Map.of("connectionQualifiedName", collection.getConnectionQualifiedName(), "presetWorkspaceQualifiedName", collection.getPresetWorkspaceQualifiedName(), "qualifiedName", collection.getQualifiedName()));
        return PresetChart.creator(name, collection.getConnectionQualifiedName(), collection.getPresetWorkspaceQualifiedName(), collection.getQualifiedName()).presetDashboard(collection.trimToReference());
    }

    public static PresetChartBuilder<?, ?> creator(String name, String collectionQualifiedName) {
        String workspaceQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(collectionQualifiedName);
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(workspaceQualifiedName);
        return PresetChart.creator(name, connectionQualifiedName, workspaceQualifiedName, collectionQualifiedName);
    }

    public static PresetChartBuilder<?, ?> creator(String name, String connectionQualifiedName, String workspaceQualifiedName, String collectionQualifiedName) {
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(connectionQualifiedName);
        return (PresetChartBuilder)((Asset.AssetBuilder)((PresetChartBuilder)((PresetChartBuilder)((PresetChartBuilder)((PresetChartBuilder)((PresetChartBuilder)((PresetChartBuilder)PresetChart._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).name(name)).qualifiedName(collectionQualifiedName + "/" + name)).connectorType(connectorType)).presetDashboardQualifiedName(collectionQualifiedName)).presetDashboard(PresetDashboard.refByQualifiedName(collectionQualifiedName))).presetWorkspaceQualifiedName(workspaceQualifiedName)).connectionQualifiedName(connectionQualifiedName);
    }

    public static PresetChartBuilder<?, ?> updater(String qualifiedName, String name) {
        return (PresetChartBuilder)((PresetChartBuilder)((PresetChartBuilder)PresetChart._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public PresetChartBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        PresetChart.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return PresetChart.updater(this.getQualifiedName(), this.getName());
    }

    public static PresetChart removeDescription(String qualifiedName, String name) throws AtlanException {
        return PresetChart.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PresetChart removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetChart)Asset.removeDescription(client, PresetChart.updater(qualifiedName, name));
    }

    public static PresetChart removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return PresetChart.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PresetChart removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetChart)Asset.removeUserDescription(client, PresetChart.updater(qualifiedName, name));
    }

    public static PresetChart removeOwners(String qualifiedName, String name) throws AtlanException {
        return PresetChart.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PresetChart removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetChart)Asset.removeOwners(client, PresetChart.updater(qualifiedName, name));
    }

    public static PresetChart updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return PresetChart.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static PresetChart updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (PresetChart)Asset.updateCertificate(client, PresetChart._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static PresetChart removeCertificate(String qualifiedName, String name) throws AtlanException {
        return PresetChart.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PresetChart removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetChart)Asset.removeCertificate(client, PresetChart.updater(qualifiedName, name));
    }

    public static PresetChart updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return PresetChart.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static PresetChart updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (PresetChart)Asset.updateAnnouncement(client, PresetChart._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static PresetChart removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return PresetChart.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static PresetChart removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (PresetChart)Asset.removeAnnouncement(client, PresetChart.updater(qualifiedName, name));
    }

    public static PresetChart replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return PresetChart.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static PresetChart replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (PresetChart)Asset.replaceTerms(client, PresetChart.updater(qualifiedName, name), terms);
    }

    public static PresetChart appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return PresetChart.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static PresetChart appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PresetChart)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static PresetChart removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return PresetChart.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static PresetChart removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (PresetChart)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static PresetChart appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return PresetChart.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static PresetChart appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (PresetChart)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static PresetChart appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return PresetChart.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static PresetChart appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (PresetChart)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        PresetChart.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected PresetChart(PresetChartBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> presetChartFormData;
        this.typeName = b.typeName$set ? b.typeName$value : PresetChart.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.presetChartDescriptionMarkdown = b.presetChartDescriptionMarkdown;
        switch (b.presetChartFormData$key == null ? 0 : b.presetChartFormData$key.size()) {
            case 0: {
                presetChartFormData = Collections.emptyMap();
                break;
            }
            case 1: {
                presetChartFormData = Collections.singletonMap(b.presetChartFormData$key.get(0), b.presetChartFormData$value.get(0));
                break;
            }
            default: {
                presetChartFormData = new LinkedHashMap(b.presetChartFormData$key.size() < 0x40000000 ? 1 + b.presetChartFormData$key.size() + (b.presetChartFormData$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.presetChartFormData$key.size(); ++$i) {
                    presetChartFormData.put(b.presetChartFormData$key.get($i), b.presetChartFormData$value.get($i));
                }
                presetChartFormData = Collections.unmodifiableMap(presetChartFormData);
            }
        }
        this.presetChartFormData = presetChartFormData;
        this.presetDashboard = b.presetDashboard;
        this.presetDashboardId = b.presetDashboardId;
        this.presetDashboardQualifiedName = b.presetDashboardQualifiedName;
        this.presetWorkspaceId = b.presetWorkspaceId;
        this.presetWorkspaceQualifiedName = b.presetWorkspaceQualifiedName;
    }

    @Generated
    public static PresetChartBuilder<?, ?> _internal() {
        return new PresetChartBuilderImpl();
    }

    @Generated
    public PresetChartBuilder<?, ?> toBuilder() {
        return new PresetChartBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public String getPresetChartDescriptionMarkdown() {
        return this.presetChartDescriptionMarkdown;
    }

    @Override
    @Generated
    public Map<String, String> getPresetChartFormData() {
        return this.presetChartFormData;
    }

    @Override
    @Generated
    public IPresetDashboard getPresetDashboard() {
        return this.presetDashboard;
    }

    @Override
    @Generated
    public Long getPresetDashboardId() {
        return this.presetDashboardId;
    }

    @Override
    @Generated
    public String getPresetDashboardQualifiedName() {
        return this.presetDashboardQualifiedName;
    }

    @Override
    @Generated
    public Long getPresetWorkspaceId() {
        return this.presetWorkspaceId;
    }

    @Override
    @Generated
    public String getPresetWorkspaceQualifiedName() {
        return this.presetWorkspaceQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PresetChart)) {
            return false;
        }
        PresetChart other = (PresetChart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$presetDashboardId = this.getPresetDashboardId();
        Long other$presetDashboardId = other.getPresetDashboardId();
        if (this$presetDashboardId == null ? other$presetDashboardId != null : !((Object)this$presetDashboardId).equals(other$presetDashboardId)) {
            return false;
        }
        Long this$presetWorkspaceId = this.getPresetWorkspaceId();
        Long other$presetWorkspaceId = other.getPresetWorkspaceId();
        if (this$presetWorkspaceId == null ? other$presetWorkspaceId != null : !((Object)this$presetWorkspaceId).equals(other$presetWorkspaceId)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        String this$presetChartDescriptionMarkdown = this.getPresetChartDescriptionMarkdown();
        String other$presetChartDescriptionMarkdown = other.getPresetChartDescriptionMarkdown();
        if (this$presetChartDescriptionMarkdown == null ? other$presetChartDescriptionMarkdown != null : !this$presetChartDescriptionMarkdown.equals(other$presetChartDescriptionMarkdown)) {
            return false;
        }
        Map<String, String> this$presetChartFormData = this.getPresetChartFormData();
        Map<String, String> other$presetChartFormData = other.getPresetChartFormData();
        if (this$presetChartFormData == null ? other$presetChartFormData != null : !((Object)this$presetChartFormData).equals(other$presetChartFormData)) {
            return false;
        }
        IPresetDashboard this$presetDashboard = this.getPresetDashboard();
        IPresetDashboard other$presetDashboard = other.getPresetDashboard();
        if (this$presetDashboard == null ? other$presetDashboard != null : !this$presetDashboard.equals(other$presetDashboard)) {
            return false;
        }
        String this$presetDashboardQualifiedName = this.getPresetDashboardQualifiedName();
        String other$presetDashboardQualifiedName = other.getPresetDashboardQualifiedName();
        if (this$presetDashboardQualifiedName == null ? other$presetDashboardQualifiedName != null : !this$presetDashboardQualifiedName.equals(other$presetDashboardQualifiedName)) {
            return false;
        }
        String this$presetWorkspaceQualifiedName = this.getPresetWorkspaceQualifiedName();
        String other$presetWorkspaceQualifiedName = other.getPresetWorkspaceQualifiedName();
        return !(this$presetWorkspaceQualifiedName == null ? other$presetWorkspaceQualifiedName != null : !this$presetWorkspaceQualifiedName.equals(other$presetWorkspaceQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PresetChart;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $presetDashboardId = this.getPresetDashboardId();
        result = result * 59 + ($presetDashboardId == null ? 43 : ((Object)$presetDashboardId).hashCode());
        Long $presetWorkspaceId = this.getPresetWorkspaceId();
        result = result * 59 + ($presetWorkspaceId == null ? 43 : ((Object)$presetWorkspaceId).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        String $presetChartDescriptionMarkdown = this.getPresetChartDescriptionMarkdown();
        result = result * 59 + ($presetChartDescriptionMarkdown == null ? 43 : $presetChartDescriptionMarkdown.hashCode());
        Map<String, String> $presetChartFormData = this.getPresetChartFormData();
        result = result * 59 + ($presetChartFormData == null ? 43 : ((Object)$presetChartFormData).hashCode());
        IPresetDashboard $presetDashboard = this.getPresetDashboard();
        result = result * 59 + ($presetDashboard == null ? 43 : $presetDashboard.hashCode());
        String $presetDashboardQualifiedName = this.getPresetDashboardQualifiedName();
        result = result * 59 + ($presetDashboardQualifiedName == null ? 43 : $presetDashboardQualifiedName.hashCode());
        String $presetWorkspaceQualifiedName = this.getPresetWorkspaceQualifiedName();
        result = result * 59 + ($presetWorkspaceQualifiedName == null ? 43 : $presetWorkspaceQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "PresetChart(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", presetChartDescriptionMarkdown=" + this.getPresetChartDescriptionMarkdown() + ", presetChartFormData=" + this.getPresetChartFormData() + ", presetDashboard=" + this.getPresetDashboard() + ", presetDashboardId=" + this.getPresetDashboardId() + ", presetDashboardQualifiedName=" + this.getPresetDashboardQualifiedName() + ", presetWorkspaceId=" + this.getPresetWorkspaceId() + ", presetWorkspaceQualifiedName=" + this.getPresetWorkspaceQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class PresetChartBuilder<C extends PresetChart, B extends PresetChartBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private String presetChartDescriptionMarkdown;
        @Generated
        private ArrayList<String> presetChartFormData$key;
        @Generated
        private ArrayList<String> presetChartFormData$value;
        @Generated
        private IPresetDashboard presetDashboard;
        @Generated
        private Long presetDashboardId;
        @Generated
        private String presetDashboardQualifiedName;
        @Generated
        private Long presetWorkspaceId;
        @Generated
        private String presetWorkspaceQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PresetChartBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(PresetChart instance, PresetChartBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.presetChartDescriptionMarkdown(instance.presetChartDescriptionMarkdown);
            b.presetChartFormData(instance.presetChartFormData == null ? Collections.emptyMap() : instance.presetChartFormData);
            b.presetDashboard(instance.presetDashboard);
            b.presetDashboardId(instance.presetDashboardId);
            b.presetDashboardQualifiedName(instance.presetDashboardQualifiedName);
            b.presetWorkspaceId(instance.presetWorkspaceId);
            b.presetWorkspaceQualifiedName(instance.presetWorkspaceQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B presetChartDescriptionMarkdown(String presetChartDescriptionMarkdown) {
            this.presetChartDescriptionMarkdown = presetChartDescriptionMarkdown;
            return (B)this.self();
        }

        @Generated
        public B putPresetChartFormData(String putPresetChartFormDataKey, String putPresetChartFormDataValue) {
            if (this.presetChartFormData$key == null) {
                this.presetChartFormData$key = new ArrayList();
                this.presetChartFormData$value = new ArrayList();
            }
            this.presetChartFormData$key.add(putPresetChartFormDataKey);
            this.presetChartFormData$value.add(putPresetChartFormDataValue);
            return (B)this.self();
        }

        @Generated
        public B presetChartFormData(Map<? extends String, ? extends String> presetChartFormData) {
            if (presetChartFormData == null) {
                throw new NullPointerException("presetChartFormData cannot be null");
            }
            if (this.presetChartFormData$key == null) {
                this.presetChartFormData$key = new ArrayList();
                this.presetChartFormData$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : presetChartFormData.entrySet()) {
                this.presetChartFormData$key.add($lombokEntry.getKey());
                this.presetChartFormData$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearPresetChartFormData() {
            if (this.presetChartFormData$key != null) {
                this.presetChartFormData$key.clear();
                this.presetChartFormData$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B presetDashboard(IPresetDashboard presetDashboard) {
            this.presetDashboard = presetDashboard;
            return (B)this.self();
        }

        @Generated
        public B presetDashboardId(Long presetDashboardId) {
            this.presetDashboardId = presetDashboardId;
            return (B)this.self();
        }

        @Generated
        public B presetDashboardQualifiedName(String presetDashboardQualifiedName) {
            this.presetDashboardQualifiedName = presetDashboardQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceId(Long presetWorkspaceId) {
            this.presetWorkspaceId = presetWorkspaceId;
            return (B)this.self();
        }

        @Generated
        public B presetWorkspaceQualifiedName(String presetWorkspaceQualifiedName) {
            this.presetWorkspaceQualifiedName = presetWorkspaceQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PresetChart.PresetChartBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", presetChartDescriptionMarkdown=" + this.presetChartDescriptionMarkdown + ", presetChartFormData$key=" + this.presetChartFormData$key + ", presetChartFormData$value=" + this.presetChartFormData$value + ", presetDashboard=" + this.presetDashboard + ", presetDashboardId=" + this.presetDashboardId + ", presetDashboardQualifiedName=" + this.presetDashboardQualifiedName + ", presetWorkspaceId=" + this.presetWorkspaceId + ", presetWorkspaceQualifiedName=" + this.presetWorkspaceQualifiedName + ")";
        }
    }

    @Generated
    private static final class PresetChartBuilderImpl
    extends PresetChartBuilder<PresetChart, PresetChartBuilderImpl> {
        @Generated
        private PresetChartBuilderImpl() {
        }

        @Override
        @Generated
        protected PresetChartBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PresetChart build() {
            return new PresetChart(this);
        }
    }
}

