/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IQuickSight;
import com.atlan.model.assets.IQuickSightAnalysis;
import com.atlan.model.assets.IQuickSightAnalysisVisual;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickSightAnalysisVisual
extends Asset
implements IQuickSightAnalysisVisual,
IQuickSight,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuickSightAnalysisVisual.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "QuickSightAnalysisVisual";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    IQuickSightAnalysis quickSightAnalysis;
    @Attribute
    String quickSightAnalysisQualifiedName;
    @Attribute
    String quickSightId;
    @Attribute
    String quickSightSheetId;
    @Attribute
    String quickSightSheetName;

    @Override
    public QuickSightAnalysisVisual trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return QuickSightAnalysisVisual.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return QuickSightAnalysisVisual.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return QuickSightAnalysisVisual.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return QuickSightAnalysisVisual.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return QuickSightAnalysisVisual.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return QuickSightAnalysisVisual.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static QuickSightAnalysisVisual refByGuid(String guid) {
        return QuickSightAnalysisVisual.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static QuickSightAnalysisVisual refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((QuickSightAnalysisVisualBuilder)((QuickSightAnalysisVisualBuilder)QuickSightAnalysisVisual._internal().guid(guid)).semantic(semantic)).build();
    }

    public static QuickSightAnalysisVisual refByQualifiedName(String qualifiedName) {
        return QuickSightAnalysisVisual.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static QuickSightAnalysisVisual refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((QuickSightAnalysisVisualBuilder)((QuickSightAnalysisVisualBuilder)QuickSightAnalysisVisual._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static QuickSightAnalysisVisual get(String id) throws AtlanException {
        return QuickSightAnalysisVisual.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static QuickSightAnalysisVisual get(AtlanClient client, String id) throws AtlanException {
        return QuickSightAnalysisVisual.get(client, id, true);
    }

    @JsonIgnore
    public static QuickSightAnalysisVisual get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof QuickSightAnalysisVisual) {
                return (QuickSightAnalysisVisual)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof QuickSightAnalysisVisual) {
            return (QuickSightAnalysisVisual)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return QuickSightAnalysisVisual.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static QuickSightAnalysisVisualBuilder<?, ?> updater(String qualifiedName, String name) {
        return (QuickSightAnalysisVisualBuilder)((QuickSightAnalysisVisualBuilder)((QuickSightAnalysisVisualBuilder)QuickSightAnalysisVisual._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public QuickSightAnalysisVisualBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        QuickSightAnalysisVisual.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return QuickSightAnalysisVisual.updater(this.getQualifiedName(), this.getName());
    }

    public static QuickSightAnalysisVisual removeDescription(String qualifiedName, String name) throws AtlanException {
        return QuickSightAnalysisVisual.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QuickSightAnalysisVisual removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightAnalysisVisual)Asset.removeDescription(client, QuickSightAnalysisVisual.updater(qualifiedName, name));
    }

    public static QuickSightAnalysisVisual removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return QuickSightAnalysisVisual.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QuickSightAnalysisVisual removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightAnalysisVisual)Asset.removeUserDescription(client, QuickSightAnalysisVisual.updater(qualifiedName, name));
    }

    public static QuickSightAnalysisVisual removeOwners(String qualifiedName, String name) throws AtlanException {
        return QuickSightAnalysisVisual.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QuickSightAnalysisVisual removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightAnalysisVisual)Asset.removeOwners(client, QuickSightAnalysisVisual.updater(qualifiedName, name));
    }

    public static QuickSightAnalysisVisual updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return QuickSightAnalysisVisual.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static QuickSightAnalysisVisual updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (QuickSightAnalysisVisual)Asset.updateCertificate(client, QuickSightAnalysisVisual._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static QuickSightAnalysisVisual removeCertificate(String qualifiedName, String name) throws AtlanException {
        return QuickSightAnalysisVisual.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QuickSightAnalysisVisual removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightAnalysisVisual)Asset.removeCertificate(client, QuickSightAnalysisVisual.updater(qualifiedName, name));
    }

    public static QuickSightAnalysisVisual updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return QuickSightAnalysisVisual.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static QuickSightAnalysisVisual updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (QuickSightAnalysisVisual)Asset.updateAnnouncement(client, QuickSightAnalysisVisual._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static QuickSightAnalysisVisual removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return QuickSightAnalysisVisual.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QuickSightAnalysisVisual removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightAnalysisVisual)Asset.removeAnnouncement(client, QuickSightAnalysisVisual.updater(qualifiedName, name));
    }

    public static QuickSightAnalysisVisual replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return QuickSightAnalysisVisual.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static QuickSightAnalysisVisual replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightAnalysisVisual)Asset.replaceTerms(client, QuickSightAnalysisVisual.updater(qualifiedName, name), terms);
    }

    public static QuickSightAnalysisVisual appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return QuickSightAnalysisVisual.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static QuickSightAnalysisVisual appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightAnalysisVisual)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static QuickSightAnalysisVisual removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return QuickSightAnalysisVisual.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static QuickSightAnalysisVisual removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightAnalysisVisual)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static QuickSightAnalysisVisual appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return QuickSightAnalysisVisual.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static QuickSightAnalysisVisual appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (QuickSightAnalysisVisual)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static QuickSightAnalysisVisual appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return QuickSightAnalysisVisual.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static QuickSightAnalysisVisual appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (QuickSightAnalysisVisual)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        QuickSightAnalysisVisual.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected QuickSightAnalysisVisual(QuickSightAnalysisVisualBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : QuickSightAnalysisVisual.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.quickSightAnalysis = b.quickSightAnalysis;
        this.quickSightAnalysisQualifiedName = b.quickSightAnalysisQualifiedName;
        this.quickSightId = b.quickSightId;
        this.quickSightSheetId = b.quickSightSheetId;
        this.quickSightSheetName = b.quickSightSheetName;
    }

    @Generated
    public static QuickSightAnalysisVisualBuilder<?, ?> _internal() {
        return new QuickSightAnalysisVisualBuilderImpl();
    }

    @Generated
    public QuickSightAnalysisVisualBuilder<?, ?> toBuilder() {
        return new QuickSightAnalysisVisualBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public IQuickSightAnalysis getQuickSightAnalysis() {
        return this.quickSightAnalysis;
    }

    @Override
    @Generated
    public String getQuickSightAnalysisQualifiedName() {
        return this.quickSightAnalysisQualifiedName;
    }

    @Override
    @Generated
    public String getQuickSightId() {
        return this.quickSightId;
    }

    @Override
    @Generated
    public String getQuickSightSheetId() {
        return this.quickSightSheetId;
    }

    @Override
    @Generated
    public String getQuickSightSheetName() {
        return this.quickSightSheetName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuickSightAnalysisVisual)) {
            return false;
        }
        QuickSightAnalysisVisual other = (QuickSightAnalysisVisual)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        IQuickSightAnalysis this$quickSightAnalysis = this.getQuickSightAnalysis();
        IQuickSightAnalysis other$quickSightAnalysis = other.getQuickSightAnalysis();
        if (this$quickSightAnalysis == null ? other$quickSightAnalysis != null : !this$quickSightAnalysis.equals(other$quickSightAnalysis)) {
            return false;
        }
        String this$quickSightAnalysisQualifiedName = this.getQuickSightAnalysisQualifiedName();
        String other$quickSightAnalysisQualifiedName = other.getQuickSightAnalysisQualifiedName();
        if (this$quickSightAnalysisQualifiedName == null ? other$quickSightAnalysisQualifiedName != null : !this$quickSightAnalysisQualifiedName.equals(other$quickSightAnalysisQualifiedName)) {
            return false;
        }
        String this$quickSightId = this.getQuickSightId();
        String other$quickSightId = other.getQuickSightId();
        if (this$quickSightId == null ? other$quickSightId != null : !this$quickSightId.equals(other$quickSightId)) {
            return false;
        }
        String this$quickSightSheetId = this.getQuickSightSheetId();
        String other$quickSightSheetId = other.getQuickSightSheetId();
        if (this$quickSightSheetId == null ? other$quickSightSheetId != null : !this$quickSightSheetId.equals(other$quickSightSheetId)) {
            return false;
        }
        String this$quickSightSheetName = this.getQuickSightSheetName();
        String other$quickSightSheetName = other.getQuickSightSheetName();
        return !(this$quickSightSheetName == null ? other$quickSightSheetName != null : !this$quickSightSheetName.equals(other$quickSightSheetName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QuickSightAnalysisVisual;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        IQuickSightAnalysis $quickSightAnalysis = this.getQuickSightAnalysis();
        result = result * 59 + ($quickSightAnalysis == null ? 43 : $quickSightAnalysis.hashCode());
        String $quickSightAnalysisQualifiedName = this.getQuickSightAnalysisQualifiedName();
        result = result * 59 + ($quickSightAnalysisQualifiedName == null ? 43 : $quickSightAnalysisQualifiedName.hashCode());
        String $quickSightId = this.getQuickSightId();
        result = result * 59 + ($quickSightId == null ? 43 : $quickSightId.hashCode());
        String $quickSightSheetId = this.getQuickSightSheetId();
        result = result * 59 + ($quickSightSheetId == null ? 43 : $quickSightSheetId.hashCode());
        String $quickSightSheetName = this.getQuickSightSheetName();
        result = result * 59 + ($quickSightSheetName == null ? 43 : $quickSightSheetName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "QuickSightAnalysisVisual(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", quickSightAnalysis=" + this.getQuickSightAnalysis() + ", quickSightAnalysisQualifiedName=" + this.getQuickSightAnalysisQualifiedName() + ", quickSightId=" + this.getQuickSightId() + ", quickSightSheetId=" + this.getQuickSightSheetId() + ", quickSightSheetName=" + this.getQuickSightSheetName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class QuickSightAnalysisVisualBuilder<C extends QuickSightAnalysisVisual, B extends QuickSightAnalysisVisualBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private IQuickSightAnalysis quickSightAnalysis;
        @Generated
        private String quickSightAnalysisQualifiedName;
        @Generated
        private String quickSightId;
        @Generated
        private String quickSightSheetId;
        @Generated
        private String quickSightSheetName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            QuickSightAnalysisVisualBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(QuickSightAnalysisVisual instance, QuickSightAnalysisVisualBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.quickSightAnalysis(instance.quickSightAnalysis);
            b.quickSightAnalysisQualifiedName(instance.quickSightAnalysisQualifiedName);
            b.quickSightId(instance.quickSightId);
            b.quickSightSheetId(instance.quickSightSheetId);
            b.quickSightSheetName(instance.quickSightSheetName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B quickSightAnalysis(IQuickSightAnalysis quickSightAnalysis) {
            this.quickSightAnalysis = quickSightAnalysis;
            return (B)this.self();
        }

        @Generated
        public B quickSightAnalysisQualifiedName(String quickSightAnalysisQualifiedName) {
            this.quickSightAnalysisQualifiedName = quickSightAnalysisQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B quickSightId(String quickSightId) {
            this.quickSightId = quickSightId;
            return (B)this.self();
        }

        @Generated
        public B quickSightSheetId(String quickSightSheetId) {
            this.quickSightSheetId = quickSightSheetId;
            return (B)this.self();
        }

        @Generated
        public B quickSightSheetName(String quickSightSheetName) {
            this.quickSightSheetName = quickSightSheetName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "QuickSightAnalysisVisual.QuickSightAnalysisVisualBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", quickSightAnalysis=" + this.quickSightAnalysis + ", quickSightAnalysisQualifiedName=" + this.quickSightAnalysisQualifiedName + ", quickSightId=" + this.quickSightId + ", quickSightSheetId=" + this.quickSightSheetId + ", quickSightSheetName=" + this.quickSightSheetName + ")";
        }
    }

    @Generated
    private static final class QuickSightAnalysisVisualBuilderImpl
    extends QuickSightAnalysisVisualBuilder<QuickSightAnalysisVisual, QuickSightAnalysisVisualBuilderImpl> {
        @Generated
        private QuickSightAnalysisVisualBuilderImpl() {
        }

        @Override
        @Generated
        protected QuickSightAnalysisVisualBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public QuickSightAnalysisVisual build() {
            return new QuickSightAnalysisVisual(this);
        }
    }
}

