/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IQuickSight;
import com.atlan.model.assets.IQuickSightDataset;
import com.atlan.model.assets.IQuickSightDatasetField;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.QuickSightDatasetFieldType;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickSightDatasetField
extends Asset
implements IQuickSightDatasetField,
IQuickSight,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuickSightDatasetField.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "QuickSightDatasetField";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    IQuickSightDataset quickSightDataset;
    @Attribute
    QuickSightDatasetFieldType quickSightDatasetFieldType;
    @Attribute
    String quickSightDatasetQualifiedName;
    @Attribute
    String quickSightId;
    @Attribute
    String quickSightSheetId;
    @Attribute
    String quickSightSheetName;

    @Override
    public QuickSightDatasetField trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return QuickSightDatasetField.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return QuickSightDatasetField.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return QuickSightDatasetField.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return QuickSightDatasetField.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return QuickSightDatasetField.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return QuickSightDatasetField.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static QuickSightDatasetField refByGuid(String guid) {
        return QuickSightDatasetField.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static QuickSightDatasetField refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((QuickSightDatasetFieldBuilder)((QuickSightDatasetFieldBuilder)QuickSightDatasetField._internal().guid(guid)).semantic(semantic)).build();
    }

    public static QuickSightDatasetField refByQualifiedName(String qualifiedName) {
        return QuickSightDatasetField.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static QuickSightDatasetField refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((QuickSightDatasetFieldBuilder)((QuickSightDatasetFieldBuilder)QuickSightDatasetField._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static QuickSightDatasetField get(String id) throws AtlanException {
        return QuickSightDatasetField.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static QuickSightDatasetField get(AtlanClient client, String id) throws AtlanException {
        return QuickSightDatasetField.get(client, id, true);
    }

    @JsonIgnore
    public static QuickSightDatasetField get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof QuickSightDatasetField) {
                return (QuickSightDatasetField)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof QuickSightDatasetField) {
            return (QuickSightDatasetField)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return QuickSightDatasetField.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static QuickSightDatasetFieldBuilder<?, ?> updater(String qualifiedName, String name) {
        return (QuickSightDatasetFieldBuilder)((QuickSightDatasetFieldBuilder)((QuickSightDatasetFieldBuilder)QuickSightDatasetField._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public QuickSightDatasetFieldBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        QuickSightDatasetField.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return QuickSightDatasetField.updater(this.getQualifiedName(), this.getName());
    }

    public static QuickSightDatasetField removeDescription(String qualifiedName, String name) throws AtlanException {
        return QuickSightDatasetField.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QuickSightDatasetField removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightDatasetField)Asset.removeDescription(client, QuickSightDatasetField.updater(qualifiedName, name));
    }

    public static QuickSightDatasetField removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return QuickSightDatasetField.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QuickSightDatasetField removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightDatasetField)Asset.removeUserDescription(client, QuickSightDatasetField.updater(qualifiedName, name));
    }

    public static QuickSightDatasetField removeOwners(String qualifiedName, String name) throws AtlanException {
        return QuickSightDatasetField.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QuickSightDatasetField removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightDatasetField)Asset.removeOwners(client, QuickSightDatasetField.updater(qualifiedName, name));
    }

    public static QuickSightDatasetField updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return QuickSightDatasetField.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static QuickSightDatasetField updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (QuickSightDatasetField)Asset.updateCertificate(client, QuickSightDatasetField._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static QuickSightDatasetField removeCertificate(String qualifiedName, String name) throws AtlanException {
        return QuickSightDatasetField.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QuickSightDatasetField removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightDatasetField)Asset.removeCertificate(client, QuickSightDatasetField.updater(qualifiedName, name));
    }

    public static QuickSightDatasetField updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return QuickSightDatasetField.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static QuickSightDatasetField updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (QuickSightDatasetField)Asset.updateAnnouncement(client, QuickSightDatasetField._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static QuickSightDatasetField removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return QuickSightDatasetField.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static QuickSightDatasetField removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (QuickSightDatasetField)Asset.removeAnnouncement(client, QuickSightDatasetField.updater(qualifiedName, name));
    }

    public static QuickSightDatasetField replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return QuickSightDatasetField.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static QuickSightDatasetField replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightDatasetField)Asset.replaceTerms(client, QuickSightDatasetField.updater(qualifiedName, name), terms);
    }

    public static QuickSightDatasetField appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return QuickSightDatasetField.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static QuickSightDatasetField appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightDatasetField)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static QuickSightDatasetField removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return QuickSightDatasetField.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static QuickSightDatasetField removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (QuickSightDatasetField)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static QuickSightDatasetField appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return QuickSightDatasetField.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static QuickSightDatasetField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (QuickSightDatasetField)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static QuickSightDatasetField appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return QuickSightDatasetField.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static QuickSightDatasetField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (QuickSightDatasetField)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        QuickSightDatasetField.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected QuickSightDatasetField(QuickSightDatasetFieldBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : QuickSightDatasetField.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.quickSightDataset = b.quickSightDataset;
        this.quickSightDatasetFieldType = b.quickSightDatasetFieldType;
        this.quickSightDatasetQualifiedName = b.quickSightDatasetQualifiedName;
        this.quickSightId = b.quickSightId;
        this.quickSightSheetId = b.quickSightSheetId;
        this.quickSightSheetName = b.quickSightSheetName;
    }

    @Generated
    public static QuickSightDatasetFieldBuilder<?, ?> _internal() {
        return new QuickSightDatasetFieldBuilderImpl();
    }

    @Generated
    public QuickSightDatasetFieldBuilder<?, ?> toBuilder() {
        return new QuickSightDatasetFieldBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public IQuickSightDataset getQuickSightDataset() {
        return this.quickSightDataset;
    }

    @Override
    @Generated
    public QuickSightDatasetFieldType getQuickSightDatasetFieldType() {
        return this.quickSightDatasetFieldType;
    }

    @Override
    @Generated
    public String getQuickSightDatasetQualifiedName() {
        return this.quickSightDatasetQualifiedName;
    }

    @Override
    @Generated
    public String getQuickSightId() {
        return this.quickSightId;
    }

    @Override
    @Generated
    public String getQuickSightSheetId() {
        return this.quickSightSheetId;
    }

    @Override
    @Generated
    public String getQuickSightSheetName() {
        return this.quickSightSheetName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuickSightDatasetField)) {
            return false;
        }
        QuickSightDatasetField other = (QuickSightDatasetField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        IQuickSightDataset this$quickSightDataset = this.getQuickSightDataset();
        IQuickSightDataset other$quickSightDataset = other.getQuickSightDataset();
        if (this$quickSightDataset == null ? other$quickSightDataset != null : !this$quickSightDataset.equals(other$quickSightDataset)) {
            return false;
        }
        QuickSightDatasetFieldType this$quickSightDatasetFieldType = this.getQuickSightDatasetFieldType();
        QuickSightDatasetFieldType other$quickSightDatasetFieldType = other.getQuickSightDatasetFieldType();
        if (this$quickSightDatasetFieldType == null ? other$quickSightDatasetFieldType != null : !this$quickSightDatasetFieldType.equals(other$quickSightDatasetFieldType)) {
            return false;
        }
        String this$quickSightDatasetQualifiedName = this.getQuickSightDatasetQualifiedName();
        String other$quickSightDatasetQualifiedName = other.getQuickSightDatasetQualifiedName();
        if (this$quickSightDatasetQualifiedName == null ? other$quickSightDatasetQualifiedName != null : !this$quickSightDatasetQualifiedName.equals(other$quickSightDatasetQualifiedName)) {
            return false;
        }
        String this$quickSightId = this.getQuickSightId();
        String other$quickSightId = other.getQuickSightId();
        if (this$quickSightId == null ? other$quickSightId != null : !this$quickSightId.equals(other$quickSightId)) {
            return false;
        }
        String this$quickSightSheetId = this.getQuickSightSheetId();
        String other$quickSightSheetId = other.getQuickSightSheetId();
        if (this$quickSightSheetId == null ? other$quickSightSheetId != null : !this$quickSightSheetId.equals(other$quickSightSheetId)) {
            return false;
        }
        String this$quickSightSheetName = this.getQuickSightSheetName();
        String other$quickSightSheetName = other.getQuickSightSheetName();
        return !(this$quickSightSheetName == null ? other$quickSightSheetName != null : !this$quickSightSheetName.equals(other$quickSightSheetName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QuickSightDatasetField;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        IQuickSightDataset $quickSightDataset = this.getQuickSightDataset();
        result = result * 59 + ($quickSightDataset == null ? 43 : $quickSightDataset.hashCode());
        QuickSightDatasetFieldType $quickSightDatasetFieldType = this.getQuickSightDatasetFieldType();
        result = result * 59 + ($quickSightDatasetFieldType == null ? 43 : $quickSightDatasetFieldType.hashCode());
        String $quickSightDatasetQualifiedName = this.getQuickSightDatasetQualifiedName();
        result = result * 59 + ($quickSightDatasetQualifiedName == null ? 43 : $quickSightDatasetQualifiedName.hashCode());
        String $quickSightId = this.getQuickSightId();
        result = result * 59 + ($quickSightId == null ? 43 : $quickSightId.hashCode());
        String $quickSightSheetId = this.getQuickSightSheetId();
        result = result * 59 + ($quickSightSheetId == null ? 43 : $quickSightSheetId.hashCode());
        String $quickSightSheetName = this.getQuickSightSheetName();
        result = result * 59 + ($quickSightSheetName == null ? 43 : $quickSightSheetName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "QuickSightDatasetField(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", quickSightDataset=" + this.getQuickSightDataset() + ", quickSightDatasetFieldType=" + this.getQuickSightDatasetFieldType() + ", quickSightDatasetQualifiedName=" + this.getQuickSightDatasetQualifiedName() + ", quickSightId=" + this.getQuickSightId() + ", quickSightSheetId=" + this.getQuickSightSheetId() + ", quickSightSheetName=" + this.getQuickSightSheetName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class QuickSightDatasetFieldBuilder<C extends QuickSightDatasetField, B extends QuickSightDatasetFieldBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private IQuickSightDataset quickSightDataset;
        @Generated
        private QuickSightDatasetFieldType quickSightDatasetFieldType;
        @Generated
        private String quickSightDatasetQualifiedName;
        @Generated
        private String quickSightId;
        @Generated
        private String quickSightSheetId;
        @Generated
        private String quickSightSheetName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            QuickSightDatasetFieldBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(QuickSightDatasetField instance, QuickSightDatasetFieldBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.quickSightDataset(instance.quickSightDataset);
            b.quickSightDatasetFieldType(instance.quickSightDatasetFieldType);
            b.quickSightDatasetQualifiedName(instance.quickSightDatasetQualifiedName);
            b.quickSightId(instance.quickSightId);
            b.quickSightSheetId(instance.quickSightSheetId);
            b.quickSightSheetName(instance.quickSightSheetName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B quickSightDataset(IQuickSightDataset quickSightDataset) {
            this.quickSightDataset = quickSightDataset;
            return (B)this.self();
        }

        @Generated
        public B quickSightDatasetFieldType(QuickSightDatasetFieldType quickSightDatasetFieldType) {
            this.quickSightDatasetFieldType = quickSightDatasetFieldType;
            return (B)this.self();
        }

        @Generated
        public B quickSightDatasetQualifiedName(String quickSightDatasetQualifiedName) {
            this.quickSightDatasetQualifiedName = quickSightDatasetQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B quickSightId(String quickSightId) {
            this.quickSightId = quickSightId;
            return (B)this.self();
        }

        @Generated
        public B quickSightSheetId(String quickSightSheetId) {
            this.quickSightSheetId = quickSightSheetId;
            return (B)this.self();
        }

        @Generated
        public B quickSightSheetName(String quickSightSheetName) {
            this.quickSightSheetName = quickSightSheetName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "QuickSightDatasetField.QuickSightDatasetFieldBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", quickSightDataset=" + this.quickSightDataset + ", quickSightDatasetFieldType=" + this.quickSightDatasetFieldType + ", quickSightDatasetQualifiedName=" + this.quickSightDatasetQualifiedName + ", quickSightId=" + this.quickSightId + ", quickSightSheetId=" + this.quickSightSheetId + ", quickSightSheetName=" + this.quickSightSheetName + ")";
        }
    }

    @Generated
    private static final class QuickSightDatasetFieldBuilderImpl
    extends QuickSightDatasetFieldBuilder<QuickSightDatasetField, QuickSightDatasetFieldBuilderImpl> {
        @Generated
        private QuickSightDatasetFieldBuilderImpl() {
        }

        @Override
        @Generated
        protected QuickSightDatasetFieldBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public QuickSightDatasetField build() {
            return new QuickSightDatasetField(this);
        }
    }
}

