/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IRedash;
import com.atlan.model.assets.IRedashQuery;
import com.atlan.model.assets.IRedashVisualization;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedashVisualization
extends Asset
implements IRedashVisualization,
IRedash,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedashVisualization.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "RedashVisualization";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    Boolean redashIsPublished;
    @Attribute
    IRedashQuery redashQuery;
    @Attribute
    String redashQueryName;
    @Attribute
    String redashQueryQualifiedName;
    @Attribute
    String redashVisualizationType;

    @Override
    public RedashVisualization trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return RedashVisualization.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return RedashVisualization.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return RedashVisualization.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return RedashVisualization.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return RedashVisualization.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return RedashVisualization.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static RedashVisualization refByGuid(String guid) {
        return RedashVisualization.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static RedashVisualization refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((RedashVisualizationBuilder)((RedashVisualizationBuilder)RedashVisualization._internal().guid(guid)).semantic(semantic)).build();
    }

    public static RedashVisualization refByQualifiedName(String qualifiedName) {
        return RedashVisualization.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static RedashVisualization refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((RedashVisualizationBuilder)((RedashVisualizationBuilder)RedashVisualization._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static RedashVisualization get(String id) throws AtlanException {
        return RedashVisualization.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static RedashVisualization get(AtlanClient client, String id) throws AtlanException {
        return RedashVisualization.get(client, id, true);
    }

    @JsonIgnore
    public static RedashVisualization get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof RedashVisualization) {
                return (RedashVisualization)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof RedashVisualization) {
            return (RedashVisualization)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return RedashVisualization.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static RedashVisualizationBuilder<?, ?> updater(String qualifiedName, String name) {
        return (RedashVisualizationBuilder)((RedashVisualizationBuilder)((RedashVisualizationBuilder)RedashVisualization._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public RedashVisualizationBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        RedashVisualization.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return RedashVisualization.updater(this.getQualifiedName(), this.getName());
    }

    public static RedashVisualization removeDescription(String qualifiedName, String name) throws AtlanException {
        return RedashVisualization.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static RedashVisualization removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashVisualization)Asset.removeDescription(client, RedashVisualization.updater(qualifiedName, name));
    }

    public static RedashVisualization removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return RedashVisualization.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static RedashVisualization removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashVisualization)Asset.removeUserDescription(client, RedashVisualization.updater(qualifiedName, name));
    }

    public static RedashVisualization removeOwners(String qualifiedName, String name) throws AtlanException {
        return RedashVisualization.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static RedashVisualization removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashVisualization)Asset.removeOwners(client, RedashVisualization.updater(qualifiedName, name));
    }

    public static RedashVisualization updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return RedashVisualization.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static RedashVisualization updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (RedashVisualization)Asset.updateCertificate(client, RedashVisualization._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static RedashVisualization removeCertificate(String qualifiedName, String name) throws AtlanException {
        return RedashVisualization.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static RedashVisualization removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashVisualization)Asset.removeCertificate(client, RedashVisualization.updater(qualifiedName, name));
    }

    public static RedashVisualization updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return RedashVisualization.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static RedashVisualization updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (RedashVisualization)Asset.updateAnnouncement(client, RedashVisualization._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static RedashVisualization removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return RedashVisualization.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static RedashVisualization removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (RedashVisualization)Asset.removeAnnouncement(client, RedashVisualization.updater(qualifiedName, name));
    }

    public static RedashVisualization replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return RedashVisualization.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static RedashVisualization replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (RedashVisualization)Asset.replaceTerms(client, RedashVisualization.updater(qualifiedName, name), terms);
    }

    public static RedashVisualization appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return RedashVisualization.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static RedashVisualization appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (RedashVisualization)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static RedashVisualization removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return RedashVisualization.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static RedashVisualization removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (RedashVisualization)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static RedashVisualization appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return RedashVisualization.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static RedashVisualization appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (RedashVisualization)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static RedashVisualization appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return RedashVisualization.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static RedashVisualization appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (RedashVisualization)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        RedashVisualization.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected RedashVisualization(RedashVisualizationBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : RedashVisualization.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.redashIsPublished = b.redashIsPublished;
        this.redashQuery = b.redashQuery;
        this.redashQueryName = b.redashQueryName;
        this.redashQueryQualifiedName = b.redashQueryQualifiedName;
        this.redashVisualizationType = b.redashVisualizationType;
    }

    @Generated
    public static RedashVisualizationBuilder<?, ?> _internal() {
        return new RedashVisualizationBuilderImpl();
    }

    @Generated
    public RedashVisualizationBuilder<?, ?> toBuilder() {
        return new RedashVisualizationBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public Boolean getRedashIsPublished() {
        return this.redashIsPublished;
    }

    @Override
    @Generated
    public IRedashQuery getRedashQuery() {
        return this.redashQuery;
    }

    @Override
    @Generated
    public String getRedashQueryName() {
        return this.redashQueryName;
    }

    @Override
    @Generated
    public String getRedashQueryQualifiedName() {
        return this.redashQueryQualifiedName;
    }

    @Override
    @Generated
    public String getRedashVisualizationType() {
        return this.redashVisualizationType;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedashVisualization)) {
            return false;
        }
        RedashVisualization other = (RedashVisualization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$redashIsPublished = this.getRedashIsPublished();
        Boolean other$redashIsPublished = other.getRedashIsPublished();
        if (this$redashIsPublished == null ? other$redashIsPublished != null : !((Object)this$redashIsPublished).equals(other$redashIsPublished)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        IRedashQuery this$redashQuery = this.getRedashQuery();
        IRedashQuery other$redashQuery = other.getRedashQuery();
        if (this$redashQuery == null ? other$redashQuery != null : !this$redashQuery.equals(other$redashQuery)) {
            return false;
        }
        String this$redashQueryName = this.getRedashQueryName();
        String other$redashQueryName = other.getRedashQueryName();
        if (this$redashQueryName == null ? other$redashQueryName != null : !this$redashQueryName.equals(other$redashQueryName)) {
            return false;
        }
        String this$redashQueryQualifiedName = this.getRedashQueryQualifiedName();
        String other$redashQueryQualifiedName = other.getRedashQueryQualifiedName();
        if (this$redashQueryQualifiedName == null ? other$redashQueryQualifiedName != null : !this$redashQueryQualifiedName.equals(other$redashQueryQualifiedName)) {
            return false;
        }
        String this$redashVisualizationType = this.getRedashVisualizationType();
        String other$redashVisualizationType = other.getRedashVisualizationType();
        return !(this$redashVisualizationType == null ? other$redashVisualizationType != null : !this$redashVisualizationType.equals(other$redashVisualizationType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RedashVisualization;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $redashIsPublished = this.getRedashIsPublished();
        result = result * 59 + ($redashIsPublished == null ? 43 : ((Object)$redashIsPublished).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        IRedashQuery $redashQuery = this.getRedashQuery();
        result = result * 59 + ($redashQuery == null ? 43 : $redashQuery.hashCode());
        String $redashQueryName = this.getRedashQueryName();
        result = result * 59 + ($redashQueryName == null ? 43 : $redashQueryName.hashCode());
        String $redashQueryQualifiedName = this.getRedashQueryQualifiedName();
        result = result * 59 + ($redashQueryQualifiedName == null ? 43 : $redashQueryQualifiedName.hashCode());
        String $redashVisualizationType = this.getRedashVisualizationType();
        result = result * 59 + ($redashVisualizationType == null ? 43 : $redashVisualizationType.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "RedashVisualization(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", redashIsPublished=" + this.getRedashIsPublished() + ", redashQuery=" + this.getRedashQuery() + ", redashQueryName=" + this.getRedashQueryName() + ", redashQueryQualifiedName=" + this.getRedashQueryQualifiedName() + ", redashVisualizationType=" + this.getRedashVisualizationType() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class RedashVisualizationBuilder<C extends RedashVisualization, B extends RedashVisualizationBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private Boolean redashIsPublished;
        @Generated
        private IRedashQuery redashQuery;
        @Generated
        private String redashQueryName;
        @Generated
        private String redashQueryQualifiedName;
        @Generated
        private String redashVisualizationType;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RedashVisualizationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(RedashVisualization instance, RedashVisualizationBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.redashIsPublished(instance.redashIsPublished);
            b.redashQuery(instance.redashQuery);
            b.redashQueryName(instance.redashQueryName);
            b.redashQueryQualifiedName(instance.redashQueryQualifiedName);
            b.redashVisualizationType(instance.redashVisualizationType);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B redashIsPublished(Boolean redashIsPublished) {
            this.redashIsPublished = redashIsPublished;
            return (B)this.self();
        }

        @Generated
        public B redashQuery(IRedashQuery redashQuery) {
            this.redashQuery = redashQuery;
            return (B)this.self();
        }

        @Generated
        public B redashQueryName(String redashQueryName) {
            this.redashQueryName = redashQueryName;
            return (B)this.self();
        }

        @Generated
        public B redashQueryQualifiedName(String redashQueryQualifiedName) {
            this.redashQueryQualifiedName = redashQueryQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B redashVisualizationType(String redashVisualizationType) {
            this.redashVisualizationType = redashVisualizationType;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "RedashVisualization.RedashVisualizationBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", redashIsPublished=" + this.redashIsPublished + ", redashQuery=" + this.redashQuery + ", redashQueryName=" + this.redashQueryName + ", redashQueryQualifiedName=" + this.redashQueryQualifiedName + ", redashVisualizationType=" + this.redashVisualizationType + ")";
        }
    }

    @Generated
    private static final class RedashVisualizationBuilderImpl
    extends RedashVisualizationBuilder<RedashVisualization, RedashVisualizationBuilderImpl> {
        @Generated
        private RedashVisualizationBuilderImpl() {
        }

        @Override
        @Generated
        protected RedashVisualizationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RedashVisualization build() {
            return new RedashVisualization(this);
        }
    }
}

