/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISaaS;
import com.atlan.model.assets.ISalesforce;
import com.atlan.model.assets.ISalesforceField;
import com.atlan.model.assets.ISalesforceObject;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.assets.SalesforceObject;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceField
extends Asset
implements ISalesforceField,
ISalesforce,
ISaaS,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SalesforceField.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SalesforceField";
    String typeName;
    @Attribute
    String apiName;
    @Attribute
    String dataType;
    @Attribute
    String defaultValueFormula;
    @Attribute
    String formula;
    @Attribute
    String inlineHelpText;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    Boolean isCalculated;
    @Attribute
    Boolean isCaseSensitive;
    @Attribute
    Boolean isEncrypted;
    @Attribute
    Boolean isNullable;
    @Attribute
    Boolean isPolymorphicForeignKey;
    @Attribute
    Boolean isUnique;
    @Attribute
    SortedSet<ISalesforceObject> lookupObjects;
    @Attribute
    Long maxLength;
    @Attribute
    Double numericScale;
    @Attribute
    ISalesforceObject object;
    @Attribute
    String objectQualifiedName;
    @Attribute
    Integer order;
    @Attribute
    String organizationQualifiedName;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    SortedSet<String> picklistValues;
    @Attribute
    Integer precision;

    @Override
    public SalesforceField trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return SalesforceField.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return SalesforceField.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return SalesforceField.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return SalesforceField.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return SalesforceField.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return SalesforceField.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static SalesforceField refByGuid(String guid) {
        return SalesforceField.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static SalesforceField refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((SalesforceFieldBuilder)((SalesforceFieldBuilder)SalesforceField._internal().guid(guid)).semantic(semantic)).build();
    }

    public static SalesforceField refByQualifiedName(String qualifiedName) {
        return SalesforceField.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static SalesforceField refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((SalesforceFieldBuilder)((SalesforceFieldBuilder)SalesforceField._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static SalesforceField get(String id) throws AtlanException {
        return SalesforceField.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static SalesforceField get(AtlanClient client, String id) throws AtlanException {
        return SalesforceField.get(client, id, true);
    }

    @JsonIgnore
    public static SalesforceField get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof SalesforceField) {
                return (SalesforceField)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof SalesforceField) {
            return (SalesforceField)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return SalesforceField.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static SalesforceFieldBuilder<?, ?> creator(String name, SalesforceObject object) throws InvalidRequestException {
        SalesforceField.validateRelationship("SalesforceObject", Map.of("connectionQualifiedName", object.getConnectionQualifiedName(), "organizationQualifiedName", object.getOrganizationQualifiedName(), "qualifiedName", object.getQualifiedName()));
        return SalesforceField.creator(name, object.getConnectionQualifiedName(), object.getOrganizationQualifiedName(), object.getQualifiedName()).object(object.trimToReference());
    }

    public static SalesforceFieldBuilder<?, ?> creator(String name, String objectQualifiedName) {
        String organizationQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(objectQualifiedName);
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(organizationQualifiedName);
        return SalesforceField.creator(name, connectionQualifiedName, organizationQualifiedName, objectQualifiedName);
    }

    public static SalesforceFieldBuilder<?, ?> creator(String name, String connectionQualifiedName, String organizationQualifiedName, String objectQualifiedName) {
        return ((SalesforceFieldBuilder)((SalesforceFieldBuilder)((SalesforceFieldBuilder)((SalesforceFieldBuilder)((SalesforceFieldBuilder)((SalesforceFieldBuilder)((SalesforceFieldBuilder)SalesforceField._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(SalesforceField.generateQualifiedName(name, objectQualifiedName))).name(name)).connectionQualifiedName(connectionQualifiedName)).connectorType(AtlanConnectorType.SALESFORCE)).organizationQualifiedName(organizationQualifiedName)).object(SalesforceObject.refByQualifiedName(objectQualifiedName))).objectQualifiedName(objectQualifiedName);
    }

    public static String generateQualifiedName(String name, String objectQualifiedName) {
        return objectQualifiedName + "/" + name;
    }

    public static SalesforceFieldBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SalesforceFieldBuilder)((SalesforceFieldBuilder)((SalesforceFieldBuilder)SalesforceField._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public SalesforceFieldBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        SalesforceField.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return SalesforceField.updater(this.getQualifiedName(), this.getName());
    }

    public static SalesforceField removeDescription(String qualifiedName, String name) throws AtlanException {
        return SalesforceField.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SalesforceField removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceField)Asset.removeDescription(client, SalesforceField.updater(qualifiedName, name));
    }

    public static SalesforceField removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return SalesforceField.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SalesforceField removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceField)Asset.removeUserDescription(client, SalesforceField.updater(qualifiedName, name));
    }

    public static SalesforceField removeOwners(String qualifiedName, String name) throws AtlanException {
        return SalesforceField.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SalesforceField removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceField)Asset.removeOwners(client, SalesforceField.updater(qualifiedName, name));
    }

    public static SalesforceField updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return SalesforceField.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static SalesforceField updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SalesforceField)Asset.updateCertificate(client, SalesforceField._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SalesforceField removeCertificate(String qualifiedName, String name) throws AtlanException {
        return SalesforceField.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SalesforceField removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceField)Asset.removeCertificate(client, SalesforceField.updater(qualifiedName, name));
    }

    public static SalesforceField updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return SalesforceField.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static SalesforceField updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SalesforceField)Asset.updateAnnouncement(client, SalesforceField._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SalesforceField removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return SalesforceField.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SalesforceField removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SalesforceField)Asset.removeAnnouncement(client, SalesforceField.updater(qualifiedName, name));
    }

    public static SalesforceField replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return SalesforceField.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static SalesforceField replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SalesforceField)Asset.replaceTerms(client, SalesforceField.updater(qualifiedName, name), terms);
    }

    public static SalesforceField appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SalesforceField.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SalesforceField appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SalesforceField)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SalesforceField removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SalesforceField.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SalesforceField removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SalesforceField)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SalesforceField appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return SalesforceField.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static SalesforceField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SalesforceField)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static SalesforceField appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return SalesforceField.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static SalesforceField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SalesforceField)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        SalesforceField.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SalesforceField(SalesforceFieldBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SalesforceField.$default$typeName();
        this.apiName = b.apiName;
        this.dataType = b.dataType;
        this.defaultValueFormula = b.defaultValueFormula;
        this.formula = b.formula;
        this.inlineHelpText = b.inlineHelpText;
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        this.isCalculated = b.isCalculated;
        this.isCaseSensitive = b.isCaseSensitive;
        this.isEncrypted = b.isEncrypted;
        this.isNullable = b.isNullable;
        this.isPolymorphicForeignKey = b.isPolymorphicForeignKey;
        this.isUnique = b.isUnique;
        SortedSet<ISalesforceObject> lookupObjects = new TreeSet<ISalesforceObject>();
        if (b.lookupObjects != null) {
            lookupObjects.addAll(b.lookupObjects);
        }
        lookupObjects = Collections.unmodifiableSortedSet(lookupObjects);
        this.lookupObjects = lookupObjects;
        this.maxLength = b.maxLength;
        this.numericScale = b.numericScale;
        this.object = b.object;
        this.objectQualifiedName = b.objectQualifiedName;
        this.order = b.order;
        this.organizationQualifiedName = b.organizationQualifiedName;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        SortedSet<String> picklistValues = new TreeSet<String>();
        if (b.picklistValues != null) {
            picklistValues.addAll(b.picklistValues);
        }
        picklistValues = Collections.unmodifiableSortedSet(picklistValues);
        this.picklistValues = picklistValues;
        this.precision = b.precision;
    }

    @Generated
    public static SalesforceFieldBuilder<?, ?> _internal() {
        return new SalesforceFieldBuilderImpl();
    }

    @Generated
    public SalesforceFieldBuilder<?, ?> toBuilder() {
        return new SalesforceFieldBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getApiName() {
        return this.apiName;
    }

    @Override
    @Generated
    public String getDataType() {
        return this.dataType;
    }

    @Override
    @Generated
    public String getDefaultValueFormula() {
        return this.defaultValueFormula;
    }

    @Override
    @Generated
    public String getFormula() {
        return this.formula;
    }

    @Override
    @Generated
    public String getInlineHelpText() {
        return this.inlineHelpText;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public Boolean getIsCalculated() {
        return this.isCalculated;
    }

    @Override
    @Generated
    public Boolean getIsCaseSensitive() {
        return this.isCaseSensitive;
    }

    @Override
    @Generated
    public Boolean getIsEncrypted() {
        return this.isEncrypted;
    }

    @Override
    @Generated
    public Boolean getIsNullable() {
        return this.isNullable;
    }

    @Override
    @Generated
    public Boolean getIsPolymorphicForeignKey() {
        return this.isPolymorphicForeignKey;
    }

    @Override
    @Generated
    public Boolean getIsUnique() {
        return this.isUnique;
    }

    @Override
    @Generated
    public SortedSet<ISalesforceObject> getLookupObjects() {
        return this.lookupObjects;
    }

    @Override
    @Generated
    public Long getMaxLength() {
        return this.maxLength;
    }

    @Override
    @Generated
    public Double getNumericScale() {
        return this.numericScale;
    }

    @Override
    @Generated
    public ISalesforceObject getObject() {
        return this.object;
    }

    @Override
    @Generated
    public String getObjectQualifiedName() {
        return this.objectQualifiedName;
    }

    @Override
    @Generated
    public Integer getOrder() {
        return this.order;
    }

    @Override
    @Generated
    public String getOrganizationQualifiedName() {
        return this.organizationQualifiedName;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<String> getPicklistValues() {
        return this.picklistValues;
    }

    @Override
    @Generated
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SalesforceField)) {
            return false;
        }
        SalesforceField other = (SalesforceField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isCalculated = this.getIsCalculated();
        Boolean other$isCalculated = other.getIsCalculated();
        if (this$isCalculated == null ? other$isCalculated != null : !((Object)this$isCalculated).equals(other$isCalculated)) {
            return false;
        }
        Boolean this$isCaseSensitive = this.getIsCaseSensitive();
        Boolean other$isCaseSensitive = other.getIsCaseSensitive();
        if (this$isCaseSensitive == null ? other$isCaseSensitive != null : !((Object)this$isCaseSensitive).equals(other$isCaseSensitive)) {
            return false;
        }
        Boolean this$isEncrypted = this.getIsEncrypted();
        Boolean other$isEncrypted = other.getIsEncrypted();
        if (this$isEncrypted == null ? other$isEncrypted != null : !((Object)this$isEncrypted).equals(other$isEncrypted)) {
            return false;
        }
        Boolean this$isNullable = this.getIsNullable();
        Boolean other$isNullable = other.getIsNullable();
        if (this$isNullable == null ? other$isNullable != null : !((Object)this$isNullable).equals(other$isNullable)) {
            return false;
        }
        Boolean this$isPolymorphicForeignKey = this.getIsPolymorphicForeignKey();
        Boolean other$isPolymorphicForeignKey = other.getIsPolymorphicForeignKey();
        if (this$isPolymorphicForeignKey == null ? other$isPolymorphicForeignKey != null : !((Object)this$isPolymorphicForeignKey).equals(other$isPolymorphicForeignKey)) {
            return false;
        }
        Boolean this$isUnique = this.getIsUnique();
        Boolean other$isUnique = other.getIsUnique();
        if (this$isUnique == null ? other$isUnique != null : !((Object)this$isUnique).equals(other$isUnique)) {
            return false;
        }
        Long this$maxLength = this.getMaxLength();
        Long other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        Double this$numericScale = this.getNumericScale();
        Double other$numericScale = other.getNumericScale();
        if (this$numericScale == null ? other$numericScale != null : !((Object)this$numericScale).equals(other$numericScale)) {
            return false;
        }
        Integer this$order = this.getOrder();
        Integer other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        Integer this$precision = this.getPrecision();
        Integer other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !((Object)this$precision).equals(other$precision)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$apiName = this.getApiName();
        String other$apiName = other.getApiName();
        if (this$apiName == null ? other$apiName != null : !this$apiName.equals(other$apiName)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        String this$defaultValueFormula = this.getDefaultValueFormula();
        String other$defaultValueFormula = other.getDefaultValueFormula();
        if (this$defaultValueFormula == null ? other$defaultValueFormula != null : !this$defaultValueFormula.equals(other$defaultValueFormula)) {
            return false;
        }
        String this$formula = this.getFormula();
        String other$formula = other.getFormula();
        if (this$formula == null ? other$formula != null : !this$formula.equals(other$formula)) {
            return false;
        }
        String this$inlineHelpText = this.getInlineHelpText();
        String other$inlineHelpText = other.getInlineHelpText();
        if (this$inlineHelpText == null ? other$inlineHelpText != null : !this$inlineHelpText.equals(other$inlineHelpText)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<ISalesforceObject> this$lookupObjects = this.getLookupObjects();
        SortedSet<ISalesforceObject> other$lookupObjects = other.getLookupObjects();
        if (this$lookupObjects == null ? other$lookupObjects != null : !this$lookupObjects.equals(other$lookupObjects)) {
            return false;
        }
        ISalesforceObject this$object = this.getObject();
        ISalesforceObject other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$objectQualifiedName = this.getObjectQualifiedName();
        String other$objectQualifiedName = other.getObjectQualifiedName();
        if (this$objectQualifiedName == null ? other$objectQualifiedName != null : !this$objectQualifiedName.equals(other$objectQualifiedName)) {
            return false;
        }
        String this$organizationQualifiedName = this.getOrganizationQualifiedName();
        String other$organizationQualifiedName = other.getOrganizationQualifiedName();
        if (this$organizationQualifiedName == null ? other$organizationQualifiedName != null : !this$organizationQualifiedName.equals(other$organizationQualifiedName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        SortedSet<String> this$picklistValues = this.getPicklistValues();
        SortedSet<String> other$picklistValues = other.getPicklistValues();
        return !(this$picklistValues == null ? other$picklistValues != null : !this$picklistValues.equals(other$picklistValues));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SalesforceField;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isCalculated = this.getIsCalculated();
        result = result * 59 + ($isCalculated == null ? 43 : ((Object)$isCalculated).hashCode());
        Boolean $isCaseSensitive = this.getIsCaseSensitive();
        result = result * 59 + ($isCaseSensitive == null ? 43 : ((Object)$isCaseSensitive).hashCode());
        Boolean $isEncrypted = this.getIsEncrypted();
        result = result * 59 + ($isEncrypted == null ? 43 : ((Object)$isEncrypted).hashCode());
        Boolean $isNullable = this.getIsNullable();
        result = result * 59 + ($isNullable == null ? 43 : ((Object)$isNullable).hashCode());
        Boolean $isPolymorphicForeignKey = this.getIsPolymorphicForeignKey();
        result = result * 59 + ($isPolymorphicForeignKey == null ? 43 : ((Object)$isPolymorphicForeignKey).hashCode());
        Boolean $isUnique = this.getIsUnique();
        result = result * 59 + ($isUnique == null ? 43 : ((Object)$isUnique).hashCode());
        Long $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        Double $numericScale = this.getNumericScale();
        result = result * 59 + ($numericScale == null ? 43 : ((Object)$numericScale).hashCode());
        Integer $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        Integer $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : ((Object)$precision).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $apiName = this.getApiName();
        result = result * 59 + ($apiName == null ? 43 : $apiName.hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        String $defaultValueFormula = this.getDefaultValueFormula();
        result = result * 59 + ($defaultValueFormula == null ? 43 : $defaultValueFormula.hashCode());
        String $formula = this.getFormula();
        result = result * 59 + ($formula == null ? 43 : $formula.hashCode());
        String $inlineHelpText = this.getInlineHelpText();
        result = result * 59 + ($inlineHelpText == null ? 43 : $inlineHelpText.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<ISalesforceObject> $lookupObjects = this.getLookupObjects();
        result = result * 59 + ($lookupObjects == null ? 43 : $lookupObjects.hashCode());
        ISalesforceObject $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $objectQualifiedName = this.getObjectQualifiedName();
        result = result * 59 + ($objectQualifiedName == null ? 43 : $objectQualifiedName.hashCode());
        String $organizationQualifiedName = this.getOrganizationQualifiedName();
        result = result * 59 + ($organizationQualifiedName == null ? 43 : $organizationQualifiedName.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        SortedSet<String> $picklistValues = this.getPicklistValues();
        result = result * 59 + ($picklistValues == null ? 43 : $picklistValues.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SalesforceField(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", apiName=" + this.getApiName() + ", dataType=" + this.getDataType() + ", defaultValueFormula=" + this.getDefaultValueFormula() + ", formula=" + this.getFormula() + ", inlineHelpText=" + this.getInlineHelpText() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", isCalculated=" + this.getIsCalculated() + ", isCaseSensitive=" + this.getIsCaseSensitive() + ", isEncrypted=" + this.getIsEncrypted() + ", isNullable=" + this.getIsNullable() + ", isPolymorphicForeignKey=" + this.getIsPolymorphicForeignKey() + ", isUnique=" + this.getIsUnique() + ", lookupObjects=" + this.getLookupObjects() + ", maxLength=" + this.getMaxLength() + ", numericScale=" + this.getNumericScale() + ", object=" + this.getObject() + ", objectQualifiedName=" + this.getObjectQualifiedName() + ", order=" + this.getOrder() + ", organizationQualifiedName=" + this.getOrganizationQualifiedName() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", picklistValues=" + this.getPicklistValues() + ", precision=" + this.getPrecision() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class SalesforceFieldBuilder<C extends SalesforceField, B extends SalesforceFieldBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String apiName;
        @Generated
        private String dataType;
        @Generated
        private String defaultValueFormula;
        @Generated
        private String formula;
        @Generated
        private String inlineHelpText;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private Boolean isCalculated;
        @Generated
        private Boolean isCaseSensitive;
        @Generated
        private Boolean isEncrypted;
        @Generated
        private Boolean isNullable;
        @Generated
        private Boolean isPolymorphicForeignKey;
        @Generated
        private Boolean isUnique;
        @Generated
        private ArrayList<ISalesforceObject> lookupObjects;
        @Generated
        private Long maxLength;
        @Generated
        private Double numericScale;
        @Generated
        private ISalesforceObject object;
        @Generated
        private String objectQualifiedName;
        @Generated
        private Integer order;
        @Generated
        private String organizationQualifiedName;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ArrayList<String> picklistValues;
        @Generated
        private Integer precision;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SalesforceFieldBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SalesforceField instance, SalesforceFieldBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.apiName(instance.apiName);
            b.dataType(instance.dataType);
            b.defaultValueFormula(instance.defaultValueFormula);
            b.formula(instance.formula);
            b.inlineHelpText(instance.inlineHelpText);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.isCalculated(instance.isCalculated);
            b.isCaseSensitive(instance.isCaseSensitive);
            b.isEncrypted(instance.isEncrypted);
            b.isNullable(instance.isNullable);
            b.isPolymorphicForeignKey(instance.isPolymorphicForeignKey);
            b.isUnique(instance.isUnique);
            b.lookupObjects(instance.lookupObjects == null ? Collections.emptySortedSet() : instance.lookupObjects);
            b.maxLength(instance.maxLength);
            b.numericScale(instance.numericScale);
            b.object(instance.object);
            b.objectQualifiedName(instance.objectQualifiedName);
            b.order(instance.order);
            b.organizationQualifiedName(instance.organizationQualifiedName);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.picklistValues(instance.picklistValues == null ? Collections.emptySortedSet() : instance.picklistValues);
            b.precision(instance.precision);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B apiName(String apiName) {
            this.apiName = apiName;
            return (B)this.self();
        }

        @Generated
        public B dataType(String dataType) {
            this.dataType = dataType;
            return (B)this.self();
        }

        @Generated
        public B defaultValueFormula(String defaultValueFormula) {
            this.defaultValueFormula = defaultValueFormula;
            return (B)this.self();
        }

        @Generated
        public B formula(String formula) {
            this.formula = formula;
            return (B)this.self();
        }

        @Generated
        public B inlineHelpText(String inlineHelpText) {
            this.inlineHelpText = inlineHelpText;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isCalculated(Boolean isCalculated) {
            this.isCalculated = isCalculated;
            return (B)this.self();
        }

        @Generated
        public B isCaseSensitive(Boolean isCaseSensitive) {
            this.isCaseSensitive = isCaseSensitive;
            return (B)this.self();
        }

        @Generated
        public B isEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            return (B)this.self();
        }

        @Generated
        public B isNullable(Boolean isNullable) {
            this.isNullable = isNullable;
            return (B)this.self();
        }

        @Generated
        public B isPolymorphicForeignKey(Boolean isPolymorphicForeignKey) {
            this.isPolymorphicForeignKey = isPolymorphicForeignKey;
            return (B)this.self();
        }

        @Generated
        public B isUnique(Boolean isUnique) {
            this.isUnique = isUnique;
            return (B)this.self();
        }

        @Generated
        public B lookupObject(ISalesforceObject lookupObject) {
            if (this.lookupObjects == null) {
                this.lookupObjects = new ArrayList();
            }
            this.lookupObjects.add(lookupObject);
            return (B)this.self();
        }

        @Generated
        public B lookupObjects(Collection<? extends ISalesforceObject> lookupObjects) {
            if (lookupObjects == null) {
                throw new NullPointerException("lookupObjects cannot be null");
            }
            if (this.lookupObjects == null) {
                this.lookupObjects = new ArrayList();
            }
            this.lookupObjects.addAll(lookupObjects);
            return (B)this.self();
        }

        @Generated
        public B clearLookupObjects() {
            if (this.lookupObjects != null) {
                this.lookupObjects.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B maxLength(Long maxLength) {
            this.maxLength = maxLength;
            return (B)this.self();
        }

        @Generated
        public B numericScale(Double numericScale) {
            this.numericScale = numericScale;
            return (B)this.self();
        }

        @Generated
        public B object(ISalesforceObject object) {
            this.object = object;
            return (B)this.self();
        }

        @Generated
        public B objectQualifiedName(String objectQualifiedName) {
            this.objectQualifiedName = objectQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B order(Integer order) {
            this.order = order;
            return (B)this.self();
        }

        @Generated
        public B organizationQualifiedName(String organizationQualifiedName) {
            this.organizationQualifiedName = organizationQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B picklistValue(String picklistValue) {
            if (this.picklistValues == null) {
                this.picklistValues = new ArrayList();
            }
            this.picklistValues.add(picklistValue);
            return (B)this.self();
        }

        @Generated
        public B picklistValues(Collection<? extends String> picklistValues) {
            if (picklistValues == null) {
                throw new NullPointerException("picklistValues cannot be null");
            }
            if (this.picklistValues == null) {
                this.picklistValues = new ArrayList();
            }
            this.picklistValues.addAll(picklistValues);
            return (B)this.self();
        }

        @Generated
        public B clearPicklistValues() {
            if (this.picklistValues != null) {
                this.picklistValues.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B precision(Integer precision) {
            this.precision = precision;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SalesforceField.SalesforceFieldBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", apiName=" + this.apiName + ", dataType=" + this.dataType + ", defaultValueFormula=" + this.defaultValueFormula + ", formula=" + this.formula + ", inlineHelpText=" + this.inlineHelpText + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", isCalculated=" + this.isCalculated + ", isCaseSensitive=" + this.isCaseSensitive + ", isEncrypted=" + this.isEncrypted + ", isNullable=" + this.isNullable + ", isPolymorphicForeignKey=" + this.isPolymorphicForeignKey + ", isUnique=" + this.isUnique + ", lookupObjects=" + this.lookupObjects + ", maxLength=" + this.maxLength + ", numericScale=" + this.numericScale + ", object=" + this.object + ", objectQualifiedName=" + this.objectQualifiedName + ", order=" + this.order + ", organizationQualifiedName=" + this.organizationQualifiedName + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", picklistValues=" + this.picklistValues + ", precision=" + this.precision + ")";
        }
    }

    @Generated
    private static final class SalesforceFieldBuilderImpl
    extends SalesforceFieldBuilder<SalesforceField, SalesforceFieldBuilderImpl> {
        @Generated
        private SalesforceFieldBuilderImpl() {
        }

        @Override
        @Generated
        protected SalesforceFieldBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SalesforceField build() {
            return new SalesforceField(this);
        }
    }
}

