/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISigma;
import com.atlan.model.assets.ISigmaDataElement;
import com.atlan.model.assets.ISigmaDataElementField;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigmaDataElementField
extends Asset
implements ISigmaDataElementField,
ISigma,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SigmaDataElementField.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "SigmaDataElementField";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    ISigmaDataElement sigmaDataElement;
    @Attribute
    String sigmaDataElementFieldFormula;
    @Attribute
    Boolean sigmaDataElementFieldIsHidden;
    @Attribute
    String sigmaDataElementName;
    @Attribute
    String sigmaDataElementQualifiedName;
    @Attribute
    String sigmaPageName;
    @Attribute
    String sigmaPageQualifiedName;
    @Attribute
    String sigmaWorkbookName;
    @Attribute
    String sigmaWorkbookQualifiedName;

    @Override
    public SigmaDataElementField trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return SigmaDataElementField.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return SigmaDataElementField.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return SigmaDataElementField.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return SigmaDataElementField.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return SigmaDataElementField.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return SigmaDataElementField.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static SigmaDataElementField refByGuid(String guid) {
        return SigmaDataElementField.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static SigmaDataElementField refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((SigmaDataElementFieldBuilder)((SigmaDataElementFieldBuilder)SigmaDataElementField._internal().guid(guid)).semantic(semantic)).build();
    }

    public static SigmaDataElementField refByQualifiedName(String qualifiedName) {
        return SigmaDataElementField.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static SigmaDataElementField refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((SigmaDataElementFieldBuilder)((SigmaDataElementFieldBuilder)SigmaDataElementField._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static SigmaDataElementField get(String id) throws AtlanException {
        return SigmaDataElementField.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static SigmaDataElementField get(AtlanClient client, String id) throws AtlanException {
        return SigmaDataElementField.get(client, id, true);
    }

    @JsonIgnore
    public static SigmaDataElementField get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof SigmaDataElementField) {
                return (SigmaDataElementField)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof SigmaDataElementField) {
            return (SigmaDataElementField)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return SigmaDataElementField.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static SigmaDataElementFieldBuilder<?, ?> updater(String qualifiedName, String name) {
        return (SigmaDataElementFieldBuilder)((SigmaDataElementFieldBuilder)((SigmaDataElementFieldBuilder)SigmaDataElementField._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public SigmaDataElementFieldBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        SigmaDataElementField.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return SigmaDataElementField.updater(this.getQualifiedName(), this.getName());
    }

    public static SigmaDataElementField removeDescription(String qualifiedName, String name) throws AtlanException {
        return SigmaDataElementField.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SigmaDataElementField removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaDataElementField)Asset.removeDescription(client, SigmaDataElementField.updater(qualifiedName, name));
    }

    public static SigmaDataElementField removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return SigmaDataElementField.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SigmaDataElementField removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaDataElementField)Asset.removeUserDescription(client, SigmaDataElementField.updater(qualifiedName, name));
    }

    public static SigmaDataElementField removeOwners(String qualifiedName, String name) throws AtlanException {
        return SigmaDataElementField.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SigmaDataElementField removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaDataElementField)Asset.removeOwners(client, SigmaDataElementField.updater(qualifiedName, name));
    }

    public static SigmaDataElementField updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return SigmaDataElementField.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static SigmaDataElementField updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (SigmaDataElementField)Asset.updateCertificate(client, SigmaDataElementField._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static SigmaDataElementField removeCertificate(String qualifiedName, String name) throws AtlanException {
        return SigmaDataElementField.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SigmaDataElementField removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaDataElementField)Asset.removeCertificate(client, SigmaDataElementField.updater(qualifiedName, name));
    }

    public static SigmaDataElementField updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return SigmaDataElementField.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static SigmaDataElementField updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (SigmaDataElementField)Asset.updateAnnouncement(client, SigmaDataElementField._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static SigmaDataElementField removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return SigmaDataElementField.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static SigmaDataElementField removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (SigmaDataElementField)Asset.removeAnnouncement(client, SigmaDataElementField.updater(qualifiedName, name));
    }

    public static SigmaDataElementField replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return SigmaDataElementField.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static SigmaDataElementField replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (SigmaDataElementField)Asset.replaceTerms(client, SigmaDataElementField.updater(qualifiedName, name), terms);
    }

    public static SigmaDataElementField appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SigmaDataElementField.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SigmaDataElementField appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SigmaDataElementField)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SigmaDataElementField removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return SigmaDataElementField.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static SigmaDataElementField removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (SigmaDataElementField)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static SigmaDataElementField appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return SigmaDataElementField.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static SigmaDataElementField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (SigmaDataElementField)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static SigmaDataElementField appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return SigmaDataElementField.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static SigmaDataElementField appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (SigmaDataElementField)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        SigmaDataElementField.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected SigmaDataElementField(SigmaDataElementFieldBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : SigmaDataElementField.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.sigmaDataElement = b.sigmaDataElement;
        this.sigmaDataElementFieldFormula = b.sigmaDataElementFieldFormula;
        this.sigmaDataElementFieldIsHidden = b.sigmaDataElementFieldIsHidden;
        this.sigmaDataElementName = b.sigmaDataElementName;
        this.sigmaDataElementQualifiedName = b.sigmaDataElementQualifiedName;
        this.sigmaPageName = b.sigmaPageName;
        this.sigmaPageQualifiedName = b.sigmaPageQualifiedName;
        this.sigmaWorkbookName = b.sigmaWorkbookName;
        this.sigmaWorkbookQualifiedName = b.sigmaWorkbookQualifiedName;
    }

    @Generated
    public static SigmaDataElementFieldBuilder<?, ?> _internal() {
        return new SigmaDataElementFieldBuilderImpl();
    }

    @Generated
    public SigmaDataElementFieldBuilder<?, ?> toBuilder() {
        return new SigmaDataElementFieldBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public ISigmaDataElement getSigmaDataElement() {
        return this.sigmaDataElement;
    }

    @Override
    @Generated
    public String getSigmaDataElementFieldFormula() {
        return this.sigmaDataElementFieldFormula;
    }

    @Override
    @Generated
    public Boolean getSigmaDataElementFieldIsHidden() {
        return this.sigmaDataElementFieldIsHidden;
    }

    @Override
    @Generated
    public String getSigmaDataElementName() {
        return this.sigmaDataElementName;
    }

    @Override
    @Generated
    public String getSigmaDataElementQualifiedName() {
        return this.sigmaDataElementQualifiedName;
    }

    @Override
    @Generated
    public String getSigmaPageName() {
        return this.sigmaPageName;
    }

    @Override
    @Generated
    public String getSigmaPageQualifiedName() {
        return this.sigmaPageQualifiedName;
    }

    @Override
    @Generated
    public String getSigmaWorkbookName() {
        return this.sigmaWorkbookName;
    }

    @Override
    @Generated
    public String getSigmaWorkbookQualifiedName() {
        return this.sigmaWorkbookQualifiedName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SigmaDataElementField)) {
            return false;
        }
        SigmaDataElementField other = (SigmaDataElementField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$sigmaDataElementFieldIsHidden = this.getSigmaDataElementFieldIsHidden();
        Boolean other$sigmaDataElementFieldIsHidden = other.getSigmaDataElementFieldIsHidden();
        if (this$sigmaDataElementFieldIsHidden == null ? other$sigmaDataElementFieldIsHidden != null : !((Object)this$sigmaDataElementFieldIsHidden).equals(other$sigmaDataElementFieldIsHidden)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        ISigmaDataElement this$sigmaDataElement = this.getSigmaDataElement();
        ISigmaDataElement other$sigmaDataElement = other.getSigmaDataElement();
        if (this$sigmaDataElement == null ? other$sigmaDataElement != null : !this$sigmaDataElement.equals(other$sigmaDataElement)) {
            return false;
        }
        String this$sigmaDataElementFieldFormula = this.getSigmaDataElementFieldFormula();
        String other$sigmaDataElementFieldFormula = other.getSigmaDataElementFieldFormula();
        if (this$sigmaDataElementFieldFormula == null ? other$sigmaDataElementFieldFormula != null : !this$sigmaDataElementFieldFormula.equals(other$sigmaDataElementFieldFormula)) {
            return false;
        }
        String this$sigmaDataElementName = this.getSigmaDataElementName();
        String other$sigmaDataElementName = other.getSigmaDataElementName();
        if (this$sigmaDataElementName == null ? other$sigmaDataElementName != null : !this$sigmaDataElementName.equals(other$sigmaDataElementName)) {
            return false;
        }
        String this$sigmaDataElementQualifiedName = this.getSigmaDataElementQualifiedName();
        String other$sigmaDataElementQualifiedName = other.getSigmaDataElementQualifiedName();
        if (this$sigmaDataElementQualifiedName == null ? other$sigmaDataElementQualifiedName != null : !this$sigmaDataElementQualifiedName.equals(other$sigmaDataElementQualifiedName)) {
            return false;
        }
        String this$sigmaPageName = this.getSigmaPageName();
        String other$sigmaPageName = other.getSigmaPageName();
        if (this$sigmaPageName == null ? other$sigmaPageName != null : !this$sigmaPageName.equals(other$sigmaPageName)) {
            return false;
        }
        String this$sigmaPageQualifiedName = this.getSigmaPageQualifiedName();
        String other$sigmaPageQualifiedName = other.getSigmaPageQualifiedName();
        if (this$sigmaPageQualifiedName == null ? other$sigmaPageQualifiedName != null : !this$sigmaPageQualifiedName.equals(other$sigmaPageQualifiedName)) {
            return false;
        }
        String this$sigmaWorkbookName = this.getSigmaWorkbookName();
        String other$sigmaWorkbookName = other.getSigmaWorkbookName();
        if (this$sigmaWorkbookName == null ? other$sigmaWorkbookName != null : !this$sigmaWorkbookName.equals(other$sigmaWorkbookName)) {
            return false;
        }
        String this$sigmaWorkbookQualifiedName = this.getSigmaWorkbookQualifiedName();
        String other$sigmaWorkbookQualifiedName = other.getSigmaWorkbookQualifiedName();
        return !(this$sigmaWorkbookQualifiedName == null ? other$sigmaWorkbookQualifiedName != null : !this$sigmaWorkbookQualifiedName.equals(other$sigmaWorkbookQualifiedName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SigmaDataElementField;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $sigmaDataElementFieldIsHidden = this.getSigmaDataElementFieldIsHidden();
        result = result * 59 + ($sigmaDataElementFieldIsHidden == null ? 43 : ((Object)$sigmaDataElementFieldIsHidden).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        ISigmaDataElement $sigmaDataElement = this.getSigmaDataElement();
        result = result * 59 + ($sigmaDataElement == null ? 43 : $sigmaDataElement.hashCode());
        String $sigmaDataElementFieldFormula = this.getSigmaDataElementFieldFormula();
        result = result * 59 + ($sigmaDataElementFieldFormula == null ? 43 : $sigmaDataElementFieldFormula.hashCode());
        String $sigmaDataElementName = this.getSigmaDataElementName();
        result = result * 59 + ($sigmaDataElementName == null ? 43 : $sigmaDataElementName.hashCode());
        String $sigmaDataElementQualifiedName = this.getSigmaDataElementQualifiedName();
        result = result * 59 + ($sigmaDataElementQualifiedName == null ? 43 : $sigmaDataElementQualifiedName.hashCode());
        String $sigmaPageName = this.getSigmaPageName();
        result = result * 59 + ($sigmaPageName == null ? 43 : $sigmaPageName.hashCode());
        String $sigmaPageQualifiedName = this.getSigmaPageQualifiedName();
        result = result * 59 + ($sigmaPageQualifiedName == null ? 43 : $sigmaPageQualifiedName.hashCode());
        String $sigmaWorkbookName = this.getSigmaWorkbookName();
        result = result * 59 + ($sigmaWorkbookName == null ? 43 : $sigmaWorkbookName.hashCode());
        String $sigmaWorkbookQualifiedName = this.getSigmaWorkbookQualifiedName();
        result = result * 59 + ($sigmaWorkbookQualifiedName == null ? 43 : $sigmaWorkbookQualifiedName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SigmaDataElementField(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", sigmaDataElement=" + this.getSigmaDataElement() + ", sigmaDataElementFieldFormula=" + this.getSigmaDataElementFieldFormula() + ", sigmaDataElementFieldIsHidden=" + this.getSigmaDataElementFieldIsHidden() + ", sigmaDataElementName=" + this.getSigmaDataElementName() + ", sigmaDataElementQualifiedName=" + this.getSigmaDataElementQualifiedName() + ", sigmaPageName=" + this.getSigmaPageName() + ", sigmaPageQualifiedName=" + this.getSigmaPageQualifiedName() + ", sigmaWorkbookName=" + this.getSigmaWorkbookName() + ", sigmaWorkbookQualifiedName=" + this.getSigmaWorkbookQualifiedName() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class SigmaDataElementFieldBuilder<C extends SigmaDataElementField, B extends SigmaDataElementFieldBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private ISigmaDataElement sigmaDataElement;
        @Generated
        private String sigmaDataElementFieldFormula;
        @Generated
        private Boolean sigmaDataElementFieldIsHidden;
        @Generated
        private String sigmaDataElementName;
        @Generated
        private String sigmaDataElementQualifiedName;
        @Generated
        private String sigmaPageName;
        @Generated
        private String sigmaPageQualifiedName;
        @Generated
        private String sigmaWorkbookName;
        @Generated
        private String sigmaWorkbookQualifiedName;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SigmaDataElementFieldBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SigmaDataElementField instance, SigmaDataElementFieldBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.sigmaDataElement(instance.sigmaDataElement);
            b.sigmaDataElementFieldFormula(instance.sigmaDataElementFieldFormula);
            b.sigmaDataElementFieldIsHidden(instance.sigmaDataElementFieldIsHidden);
            b.sigmaDataElementName(instance.sigmaDataElementName);
            b.sigmaDataElementQualifiedName(instance.sigmaDataElementQualifiedName);
            b.sigmaPageName(instance.sigmaPageName);
            b.sigmaPageQualifiedName(instance.sigmaPageQualifiedName);
            b.sigmaWorkbookName(instance.sigmaWorkbookName);
            b.sigmaWorkbookQualifiedName(instance.sigmaWorkbookQualifiedName);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sigmaDataElement(ISigmaDataElement sigmaDataElement) {
            this.sigmaDataElement = sigmaDataElement;
            return (B)this.self();
        }

        @Generated
        public B sigmaDataElementFieldFormula(String sigmaDataElementFieldFormula) {
            this.sigmaDataElementFieldFormula = sigmaDataElementFieldFormula;
            return (B)this.self();
        }

        @Generated
        public B sigmaDataElementFieldIsHidden(Boolean sigmaDataElementFieldIsHidden) {
            this.sigmaDataElementFieldIsHidden = sigmaDataElementFieldIsHidden;
            return (B)this.self();
        }

        @Generated
        public B sigmaDataElementName(String sigmaDataElementName) {
            this.sigmaDataElementName = sigmaDataElementName;
            return (B)this.self();
        }

        @Generated
        public B sigmaDataElementQualifiedName(String sigmaDataElementQualifiedName) {
            this.sigmaDataElementQualifiedName = sigmaDataElementQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B sigmaPageName(String sigmaPageName) {
            this.sigmaPageName = sigmaPageName;
            return (B)this.self();
        }

        @Generated
        public B sigmaPageQualifiedName(String sigmaPageQualifiedName) {
            this.sigmaPageQualifiedName = sigmaPageQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B sigmaWorkbookName(String sigmaWorkbookName) {
            this.sigmaWorkbookName = sigmaWorkbookName;
            return (B)this.self();
        }

        @Generated
        public B sigmaWorkbookQualifiedName(String sigmaWorkbookQualifiedName) {
            this.sigmaWorkbookQualifiedName = sigmaWorkbookQualifiedName;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SigmaDataElementField.SigmaDataElementFieldBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", sigmaDataElement=" + this.sigmaDataElement + ", sigmaDataElementFieldFormula=" + this.sigmaDataElementFieldFormula + ", sigmaDataElementFieldIsHidden=" + this.sigmaDataElementFieldIsHidden + ", sigmaDataElementName=" + this.sigmaDataElementName + ", sigmaDataElementQualifiedName=" + this.sigmaDataElementQualifiedName + ", sigmaPageName=" + this.sigmaPageName + ", sigmaPageQualifiedName=" + this.sigmaPageQualifiedName + ", sigmaWorkbookName=" + this.sigmaWorkbookName + ", sigmaWorkbookQualifiedName=" + this.sigmaWorkbookQualifiedName + ")";
        }
    }

    @Generated
    private static final class SigmaDataElementFieldBuilderImpl
    extends SigmaDataElementFieldBuilder<SigmaDataElementField, SigmaDataElementFieldBuilderImpl> {
        @Generated
        private SigmaDataElementFieldBuilderImpl() {
        }

        @Override
        @Generated
        protected SigmaDataElementFieldBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SigmaDataElementField build() {
            return new SigmaDataElementField(this);
        }
    }
}

