/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.assets.IThoughtspot;
import com.atlan.model.assets.IThoughtspotDashlet;
import com.atlan.model.assets.IThoughtspotLiveboard;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThoughtspotLiveboard
extends Asset
implements IThoughtspotLiveboard,
IThoughtspot,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThoughtspotLiveboard.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ThoughtspotLiveboard";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    String thoughtspotChartType;
    @Attribute
    Long thoughtspotColumnCount;
    @Attribute
    SortedSet<IThoughtspotDashlet> thoughtspotDashlets;
    @Attribute
    Long thoughtspotJoinCount;
    @Attribute
    String thoughtspotQuestionText;

    @Override
    public ThoughtspotLiveboard trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return ThoughtspotLiveboard.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return ThoughtspotLiveboard.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return ThoughtspotLiveboard.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return ThoughtspotLiveboard.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return ThoughtspotLiveboard.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return ThoughtspotLiveboard.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static ThoughtspotLiveboard refByGuid(String guid) {
        return ThoughtspotLiveboard.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static ThoughtspotLiveboard refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((ThoughtspotLiveboardBuilder)((ThoughtspotLiveboardBuilder)ThoughtspotLiveboard._internal().guid(guid)).semantic(semantic)).build();
    }

    public static ThoughtspotLiveboard refByQualifiedName(String qualifiedName) {
        return ThoughtspotLiveboard.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static ThoughtspotLiveboard refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((ThoughtspotLiveboardBuilder)((ThoughtspotLiveboardBuilder)ThoughtspotLiveboard._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static ThoughtspotLiveboard get(String id) throws AtlanException {
        return ThoughtspotLiveboard.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static ThoughtspotLiveboard get(AtlanClient client, String id) throws AtlanException {
        return ThoughtspotLiveboard.get(client, id, true);
    }

    @JsonIgnore
    public static ThoughtspotLiveboard get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof ThoughtspotLiveboard) {
                return (ThoughtspotLiveboard)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof ThoughtspotLiveboard) {
            return (ThoughtspotLiveboard)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return ThoughtspotLiveboard.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static ThoughtspotLiveboardBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ThoughtspotLiveboardBuilder)((ThoughtspotLiveboardBuilder)((ThoughtspotLiveboardBuilder)ThoughtspotLiveboard._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public ThoughtspotLiveboardBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ThoughtspotLiveboard.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return ThoughtspotLiveboard.updater(this.getQualifiedName(), this.getName());
    }

    public static ThoughtspotLiveboard removeDescription(String qualifiedName, String name) throws AtlanException {
        return ThoughtspotLiveboard.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ThoughtspotLiveboard removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotLiveboard)Asset.removeDescription(client, ThoughtspotLiveboard.updater(qualifiedName, name));
    }

    public static ThoughtspotLiveboard removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return ThoughtspotLiveboard.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ThoughtspotLiveboard removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotLiveboard)Asset.removeUserDescription(client, ThoughtspotLiveboard.updater(qualifiedName, name));
    }

    public static ThoughtspotLiveboard removeOwners(String qualifiedName, String name) throws AtlanException {
        return ThoughtspotLiveboard.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ThoughtspotLiveboard removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotLiveboard)Asset.removeOwners(client, ThoughtspotLiveboard.updater(qualifiedName, name));
    }

    public static ThoughtspotLiveboard updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return ThoughtspotLiveboard.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static ThoughtspotLiveboard updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ThoughtspotLiveboard)Asset.updateCertificate(client, ThoughtspotLiveboard._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ThoughtspotLiveboard removeCertificate(String qualifiedName, String name) throws AtlanException {
        return ThoughtspotLiveboard.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ThoughtspotLiveboard removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotLiveboard)Asset.removeCertificate(client, ThoughtspotLiveboard.updater(qualifiedName, name));
    }

    public static ThoughtspotLiveboard updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return ThoughtspotLiveboard.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static ThoughtspotLiveboard updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ThoughtspotLiveboard)Asset.updateAnnouncement(client, ThoughtspotLiveboard._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ThoughtspotLiveboard removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return ThoughtspotLiveboard.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ThoughtspotLiveboard removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotLiveboard)Asset.removeAnnouncement(client, ThoughtspotLiveboard.updater(qualifiedName, name));
    }

    public static ThoughtspotLiveboard replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return ThoughtspotLiveboard.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static ThoughtspotLiveboard replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ThoughtspotLiveboard)Asset.replaceTerms(client, ThoughtspotLiveboard.updater(qualifiedName, name), terms);
    }

    public static ThoughtspotLiveboard appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return ThoughtspotLiveboard.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static ThoughtspotLiveboard appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ThoughtspotLiveboard)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ThoughtspotLiveboard removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return ThoughtspotLiveboard.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static ThoughtspotLiveboard removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ThoughtspotLiveboard)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ThoughtspotLiveboard appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return ThoughtspotLiveboard.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static ThoughtspotLiveboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ThoughtspotLiveboard)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static ThoughtspotLiveboard appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return ThoughtspotLiveboard.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static ThoughtspotLiveboard appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ThoughtspotLiveboard)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        ThoughtspotLiveboard.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ThoughtspotLiveboard(ThoughtspotLiveboardBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : ThoughtspotLiveboard.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.thoughtspotChartType = b.thoughtspotChartType;
        this.thoughtspotColumnCount = b.thoughtspotColumnCount;
        SortedSet<IThoughtspotDashlet> thoughtspotDashlets = new TreeSet<IThoughtspotDashlet>();
        if (b.thoughtspotDashlets != null) {
            thoughtspotDashlets.addAll(b.thoughtspotDashlets);
        }
        thoughtspotDashlets = Collections.unmodifiableSortedSet(thoughtspotDashlets);
        this.thoughtspotDashlets = thoughtspotDashlets;
        this.thoughtspotJoinCount = b.thoughtspotJoinCount;
        this.thoughtspotQuestionText = b.thoughtspotQuestionText;
    }

    @Generated
    public static ThoughtspotLiveboardBuilder<?, ?> _internal() {
        return new ThoughtspotLiveboardBuilderImpl();
    }

    @Generated
    public ThoughtspotLiveboardBuilder<?, ?> toBuilder() {
        return new ThoughtspotLiveboardBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public String getThoughtspotChartType() {
        return this.thoughtspotChartType;
    }

    @Override
    @Generated
    public Long getThoughtspotColumnCount() {
        return this.thoughtspotColumnCount;
    }

    @Override
    @Generated
    public SortedSet<IThoughtspotDashlet> getThoughtspotDashlets() {
        return this.thoughtspotDashlets;
    }

    @Override
    @Generated
    public Long getThoughtspotJoinCount() {
        return this.thoughtspotJoinCount;
    }

    @Override
    @Generated
    public String getThoughtspotQuestionText() {
        return this.thoughtspotQuestionText;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThoughtspotLiveboard)) {
            return false;
        }
        ThoughtspotLiveboard other = (ThoughtspotLiveboard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$thoughtspotColumnCount = this.getThoughtspotColumnCount();
        Long other$thoughtspotColumnCount = other.getThoughtspotColumnCount();
        if (this$thoughtspotColumnCount == null ? other$thoughtspotColumnCount != null : !((Object)this$thoughtspotColumnCount).equals(other$thoughtspotColumnCount)) {
            return false;
        }
        Long this$thoughtspotJoinCount = this.getThoughtspotJoinCount();
        Long other$thoughtspotJoinCount = other.getThoughtspotJoinCount();
        if (this$thoughtspotJoinCount == null ? other$thoughtspotJoinCount != null : !((Object)this$thoughtspotJoinCount).equals(other$thoughtspotJoinCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        String this$thoughtspotChartType = this.getThoughtspotChartType();
        String other$thoughtspotChartType = other.getThoughtspotChartType();
        if (this$thoughtspotChartType == null ? other$thoughtspotChartType != null : !this$thoughtspotChartType.equals(other$thoughtspotChartType)) {
            return false;
        }
        SortedSet<IThoughtspotDashlet> this$thoughtspotDashlets = this.getThoughtspotDashlets();
        SortedSet<IThoughtspotDashlet> other$thoughtspotDashlets = other.getThoughtspotDashlets();
        if (this$thoughtspotDashlets == null ? other$thoughtspotDashlets != null : !this$thoughtspotDashlets.equals(other$thoughtspotDashlets)) {
            return false;
        }
        String this$thoughtspotQuestionText = this.getThoughtspotQuestionText();
        String other$thoughtspotQuestionText = other.getThoughtspotQuestionText();
        return !(this$thoughtspotQuestionText == null ? other$thoughtspotQuestionText != null : !this$thoughtspotQuestionText.equals(other$thoughtspotQuestionText));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ThoughtspotLiveboard;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $thoughtspotColumnCount = this.getThoughtspotColumnCount();
        result = result * 59 + ($thoughtspotColumnCount == null ? 43 : ((Object)$thoughtspotColumnCount).hashCode());
        Long $thoughtspotJoinCount = this.getThoughtspotJoinCount();
        result = result * 59 + ($thoughtspotJoinCount == null ? 43 : ((Object)$thoughtspotJoinCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        String $thoughtspotChartType = this.getThoughtspotChartType();
        result = result * 59 + ($thoughtspotChartType == null ? 43 : $thoughtspotChartType.hashCode());
        SortedSet<IThoughtspotDashlet> $thoughtspotDashlets = this.getThoughtspotDashlets();
        result = result * 59 + ($thoughtspotDashlets == null ? 43 : $thoughtspotDashlets.hashCode());
        String $thoughtspotQuestionText = this.getThoughtspotQuestionText();
        result = result * 59 + ($thoughtspotQuestionText == null ? 43 : $thoughtspotQuestionText.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ThoughtspotLiveboard(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", thoughtspotChartType=" + this.getThoughtspotChartType() + ", thoughtspotColumnCount=" + this.getThoughtspotColumnCount() + ", thoughtspotDashlets=" + this.getThoughtspotDashlets() + ", thoughtspotJoinCount=" + this.getThoughtspotJoinCount() + ", thoughtspotQuestionText=" + this.getThoughtspotQuestionText() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class ThoughtspotLiveboardBuilder<C extends ThoughtspotLiveboard, B extends ThoughtspotLiveboardBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private String thoughtspotChartType;
        @Generated
        private Long thoughtspotColumnCount;
        @Generated
        private ArrayList<IThoughtspotDashlet> thoughtspotDashlets;
        @Generated
        private Long thoughtspotJoinCount;
        @Generated
        private String thoughtspotQuestionText;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ThoughtspotLiveboardBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ThoughtspotLiveboard instance, ThoughtspotLiveboardBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.thoughtspotChartType(instance.thoughtspotChartType);
            b.thoughtspotColumnCount(instance.thoughtspotColumnCount);
            b.thoughtspotDashlets(instance.thoughtspotDashlets == null ? Collections.emptySortedSet() : instance.thoughtspotDashlets);
            b.thoughtspotJoinCount(instance.thoughtspotJoinCount);
            b.thoughtspotQuestionText(instance.thoughtspotQuestionText);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B thoughtspotChartType(String thoughtspotChartType) {
            this.thoughtspotChartType = thoughtspotChartType;
            return (B)this.self();
        }

        @Generated
        public B thoughtspotColumnCount(Long thoughtspotColumnCount) {
            this.thoughtspotColumnCount = thoughtspotColumnCount;
            return (B)this.self();
        }

        @Generated
        public B thoughtspotDashlet(IThoughtspotDashlet thoughtspotDashlet) {
            if (this.thoughtspotDashlets == null) {
                this.thoughtspotDashlets = new ArrayList();
            }
            this.thoughtspotDashlets.add(thoughtspotDashlet);
            return (B)this.self();
        }

        @Generated
        public B thoughtspotDashlets(Collection<? extends IThoughtspotDashlet> thoughtspotDashlets) {
            if (thoughtspotDashlets == null) {
                throw new NullPointerException("thoughtspotDashlets cannot be null");
            }
            if (this.thoughtspotDashlets == null) {
                this.thoughtspotDashlets = new ArrayList();
            }
            this.thoughtspotDashlets.addAll(thoughtspotDashlets);
            return (B)this.self();
        }

        @Generated
        public B clearThoughtspotDashlets() {
            if (this.thoughtspotDashlets != null) {
                this.thoughtspotDashlets.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B thoughtspotJoinCount(Long thoughtspotJoinCount) {
            this.thoughtspotJoinCount = thoughtspotJoinCount;
            return (B)this.self();
        }

        @Generated
        public B thoughtspotQuestionText(String thoughtspotQuestionText) {
            this.thoughtspotQuestionText = thoughtspotQuestionText;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ThoughtspotLiveboard.ThoughtspotLiveboardBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", thoughtspotChartType=" + this.thoughtspotChartType + ", thoughtspotColumnCount=" + this.thoughtspotColumnCount + ", thoughtspotDashlets=" + this.thoughtspotDashlets + ", thoughtspotJoinCount=" + this.thoughtspotJoinCount + ", thoughtspotQuestionText=" + this.thoughtspotQuestionText + ")";
        }
    }

    @Generated
    private static final class ThoughtspotLiveboardBuilderImpl
    extends ThoughtspotLiveboardBuilder<ThoughtspotLiveboard, ThoughtspotLiveboardBuilderImpl> {
        @Generated
        private ThoughtspotLiveboardBuilderImpl() {
        }

        @Override
        @Generated
        protected ThoughtspotLiveboardBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ThoughtspotLiveboard build() {
            return new ThoughtspotLiveboard(this);
        }
    }
}

