/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.IAirflowTask;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IBI;
import com.atlan.model.assets.ICatalog;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.ILineageProcess;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.ISparkJob;
import com.atlan.model.assets.IThoughtspot;
import com.atlan.model.assets.IThoughtspotColumn;
import com.atlan.model.assets.IThoughtspotWorksheet;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThoughtspotWorksheet
extends Asset
implements IThoughtspotWorksheet,
IThoughtspot,
IBI,
ICatalog,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThoughtspotWorksheet.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ThoughtspotWorksheet";
    String typeName;
    @Attribute
    SortedSet<IAirflowTask> inputToAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> inputToProcesses;
    @Attribute
    SortedSet<ISparkJob> inputToSparkJobs;
    @Attribute
    SortedSet<IAirflowTask> outputFromAirflowTasks;
    @Attribute
    SortedSet<ILineageProcess> outputFromProcesses;
    @Attribute
    SortedSet<ISparkJob> outputFromSparkJobs;
    @Attribute
    String thoughtspotChartType;
    @Attribute
    Long thoughtspotColumnCount;
    @Attribute
    SortedSet<IThoughtspotColumn> thoughtspotColumns;
    @Attribute
    Long thoughtspotJoinCount;
    @Attribute
    String thoughtspotQuestionText;

    @Override
    public ThoughtspotWorksheet trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return ThoughtspotWorksheet.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return ThoughtspotWorksheet.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return ThoughtspotWorksheet.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return ThoughtspotWorksheet.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return ThoughtspotWorksheet.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return ThoughtspotWorksheet.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static ThoughtspotWorksheet refByGuid(String guid) {
        return ThoughtspotWorksheet.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static ThoughtspotWorksheet refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((ThoughtspotWorksheetBuilder)((ThoughtspotWorksheetBuilder)ThoughtspotWorksheet._internal().guid(guid)).semantic(semantic)).build();
    }

    public static ThoughtspotWorksheet refByQualifiedName(String qualifiedName) {
        return ThoughtspotWorksheet.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static ThoughtspotWorksheet refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((ThoughtspotWorksheetBuilder)((ThoughtspotWorksheetBuilder)ThoughtspotWorksheet._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static ThoughtspotWorksheet get(String id) throws AtlanException {
        return ThoughtspotWorksheet.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static ThoughtspotWorksheet get(AtlanClient client, String id) throws AtlanException {
        return ThoughtspotWorksheet.get(client, id, true);
    }

    @JsonIgnore
    public static ThoughtspotWorksheet get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof ThoughtspotWorksheet) {
                return (ThoughtspotWorksheet)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof ThoughtspotWorksheet) {
            return (ThoughtspotWorksheet)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return ThoughtspotWorksheet.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static ThoughtspotWorksheetBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ThoughtspotWorksheetBuilder)((ThoughtspotWorksheetBuilder)((ThoughtspotWorksheetBuilder)ThoughtspotWorksheet._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public ThoughtspotWorksheetBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        ThoughtspotWorksheet.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return ThoughtspotWorksheet.updater(this.getQualifiedName(), this.getName());
    }

    public static ThoughtspotWorksheet removeDescription(String qualifiedName, String name) throws AtlanException {
        return ThoughtspotWorksheet.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ThoughtspotWorksheet removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotWorksheet)Asset.removeDescription(client, ThoughtspotWorksheet.updater(qualifiedName, name));
    }

    public static ThoughtspotWorksheet removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return ThoughtspotWorksheet.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ThoughtspotWorksheet removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotWorksheet)Asset.removeUserDescription(client, ThoughtspotWorksheet.updater(qualifiedName, name));
    }

    public static ThoughtspotWorksheet removeOwners(String qualifiedName, String name) throws AtlanException {
        return ThoughtspotWorksheet.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ThoughtspotWorksheet removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotWorksheet)Asset.removeOwners(client, ThoughtspotWorksheet.updater(qualifiedName, name));
    }

    public static ThoughtspotWorksheet updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return ThoughtspotWorksheet.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static ThoughtspotWorksheet updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (ThoughtspotWorksheet)Asset.updateCertificate(client, ThoughtspotWorksheet._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ThoughtspotWorksheet removeCertificate(String qualifiedName, String name) throws AtlanException {
        return ThoughtspotWorksheet.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ThoughtspotWorksheet removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotWorksheet)Asset.removeCertificate(client, ThoughtspotWorksheet.updater(qualifiedName, name));
    }

    public static ThoughtspotWorksheet updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return ThoughtspotWorksheet.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static ThoughtspotWorksheet updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ThoughtspotWorksheet)Asset.updateAnnouncement(client, ThoughtspotWorksheet._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ThoughtspotWorksheet removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return ThoughtspotWorksheet.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static ThoughtspotWorksheet removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (ThoughtspotWorksheet)Asset.removeAnnouncement(client, ThoughtspotWorksheet.updater(qualifiedName, name));
    }

    public static ThoughtspotWorksheet replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return ThoughtspotWorksheet.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static ThoughtspotWorksheet replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (ThoughtspotWorksheet)Asset.replaceTerms(client, ThoughtspotWorksheet.updater(qualifiedName, name), terms);
    }

    public static ThoughtspotWorksheet appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return ThoughtspotWorksheet.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static ThoughtspotWorksheet appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ThoughtspotWorksheet)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ThoughtspotWorksheet removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return ThoughtspotWorksheet.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static ThoughtspotWorksheet removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (ThoughtspotWorksheet)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static ThoughtspotWorksheet appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return ThoughtspotWorksheet.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static ThoughtspotWorksheet appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (ThoughtspotWorksheet)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static ThoughtspotWorksheet appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return ThoughtspotWorksheet.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static ThoughtspotWorksheet appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (ThoughtspotWorksheet)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        ThoughtspotWorksheet.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ThoughtspotWorksheet(ThoughtspotWorksheetBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : ThoughtspotWorksheet.$default$typeName();
        SortedSet<IAirflowTask> inputToAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.inputToAirflowTasks != null) {
            inputToAirflowTasks.addAll(b.inputToAirflowTasks);
        }
        inputToAirflowTasks = Collections.unmodifiableSortedSet(inputToAirflowTasks);
        this.inputToAirflowTasks = inputToAirflowTasks;
        SortedSet<ILineageProcess> inputToProcesses = new TreeSet<ILineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<ISparkJob> inputToSparkJobs = new TreeSet<ISparkJob>();
        if (b.inputToSparkJobs != null) {
            inputToSparkJobs.addAll(b.inputToSparkJobs);
        }
        inputToSparkJobs = Collections.unmodifiableSortedSet(inputToSparkJobs);
        this.inputToSparkJobs = inputToSparkJobs;
        SortedSet<IAirflowTask> outputFromAirflowTasks = new TreeSet<IAirflowTask>();
        if (b.outputFromAirflowTasks != null) {
            outputFromAirflowTasks.addAll(b.outputFromAirflowTasks);
        }
        outputFromAirflowTasks = Collections.unmodifiableSortedSet(outputFromAirflowTasks);
        this.outputFromAirflowTasks = outputFromAirflowTasks;
        SortedSet<ILineageProcess> outputFromProcesses = new TreeSet<ILineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
        SortedSet<ISparkJob> outputFromSparkJobs = new TreeSet<ISparkJob>();
        if (b.outputFromSparkJobs != null) {
            outputFromSparkJobs.addAll(b.outputFromSparkJobs);
        }
        outputFromSparkJobs = Collections.unmodifiableSortedSet(outputFromSparkJobs);
        this.outputFromSparkJobs = outputFromSparkJobs;
        this.thoughtspotChartType = b.thoughtspotChartType;
        this.thoughtspotColumnCount = b.thoughtspotColumnCount;
        SortedSet<IThoughtspotColumn> thoughtspotColumns = new TreeSet<IThoughtspotColumn>();
        if (b.thoughtspotColumns != null) {
            thoughtspotColumns.addAll(b.thoughtspotColumns);
        }
        thoughtspotColumns = Collections.unmodifiableSortedSet(thoughtspotColumns);
        this.thoughtspotColumns = thoughtspotColumns;
        this.thoughtspotJoinCount = b.thoughtspotJoinCount;
        this.thoughtspotQuestionText = b.thoughtspotQuestionText;
    }

    @Generated
    public static ThoughtspotWorksheetBuilder<?, ?> _internal() {
        return new ThoughtspotWorksheetBuilderImpl();
    }

    @Generated
    public ThoughtspotWorksheetBuilder<?, ?> toBuilder() {
        return new ThoughtspotWorksheetBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getInputToAirflowTasks() {
        return this.inputToAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getInputToSparkJobs() {
        return this.inputToSparkJobs;
    }

    @Override
    @Generated
    public SortedSet<IAirflowTask> getOutputFromAirflowTasks() {
        return this.outputFromAirflowTasks;
    }

    @Override
    @Generated
    public SortedSet<ILineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Override
    @Generated
    public SortedSet<ISparkJob> getOutputFromSparkJobs() {
        return this.outputFromSparkJobs;
    }

    @Override
    @Generated
    public String getThoughtspotChartType() {
        return this.thoughtspotChartType;
    }

    @Override
    @Generated
    public Long getThoughtspotColumnCount() {
        return this.thoughtspotColumnCount;
    }

    @Override
    @Generated
    public SortedSet<IThoughtspotColumn> getThoughtspotColumns() {
        return this.thoughtspotColumns;
    }

    @Override
    @Generated
    public Long getThoughtspotJoinCount() {
        return this.thoughtspotJoinCount;
    }

    @Override
    @Generated
    public String getThoughtspotQuestionText() {
        return this.thoughtspotQuestionText;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThoughtspotWorksheet)) {
            return false;
        }
        ThoughtspotWorksheet other = (ThoughtspotWorksheet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$thoughtspotColumnCount = this.getThoughtspotColumnCount();
        Long other$thoughtspotColumnCount = other.getThoughtspotColumnCount();
        if (this$thoughtspotColumnCount == null ? other$thoughtspotColumnCount != null : !((Object)this$thoughtspotColumnCount).equals(other$thoughtspotColumnCount)) {
            return false;
        }
        Long this$thoughtspotJoinCount = this.getThoughtspotJoinCount();
        Long other$thoughtspotJoinCount = other.getThoughtspotJoinCount();
        if (this$thoughtspotJoinCount == null ? other$thoughtspotJoinCount != null : !((Object)this$thoughtspotJoinCount).equals(other$thoughtspotJoinCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<IAirflowTask> this$inputToAirflowTasks = this.getInputToAirflowTasks();
        SortedSet<IAirflowTask> other$inputToAirflowTasks = other.getInputToAirflowTasks();
        if (this$inputToAirflowTasks == null ? other$inputToAirflowTasks != null : !this$inputToAirflowTasks.equals(other$inputToAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<ILineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$inputToSparkJobs = this.getInputToSparkJobs();
        SortedSet<ISparkJob> other$inputToSparkJobs = other.getInputToSparkJobs();
        if (this$inputToSparkJobs == null ? other$inputToSparkJobs != null : !this$inputToSparkJobs.equals(other$inputToSparkJobs)) {
            return false;
        }
        SortedSet<IAirflowTask> this$outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        SortedSet<IAirflowTask> other$outputFromAirflowTasks = other.getOutputFromAirflowTasks();
        if (this$outputFromAirflowTasks == null ? other$outputFromAirflowTasks != null : !this$outputFromAirflowTasks.equals(other$outputFromAirflowTasks)) {
            return false;
        }
        SortedSet<ILineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<ILineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        if (this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses)) {
            return false;
        }
        SortedSet<ISparkJob> this$outputFromSparkJobs = this.getOutputFromSparkJobs();
        SortedSet<ISparkJob> other$outputFromSparkJobs = other.getOutputFromSparkJobs();
        if (this$outputFromSparkJobs == null ? other$outputFromSparkJobs != null : !this$outputFromSparkJobs.equals(other$outputFromSparkJobs)) {
            return false;
        }
        String this$thoughtspotChartType = this.getThoughtspotChartType();
        String other$thoughtspotChartType = other.getThoughtspotChartType();
        if (this$thoughtspotChartType == null ? other$thoughtspotChartType != null : !this$thoughtspotChartType.equals(other$thoughtspotChartType)) {
            return false;
        }
        SortedSet<IThoughtspotColumn> this$thoughtspotColumns = this.getThoughtspotColumns();
        SortedSet<IThoughtspotColumn> other$thoughtspotColumns = other.getThoughtspotColumns();
        if (this$thoughtspotColumns == null ? other$thoughtspotColumns != null : !this$thoughtspotColumns.equals(other$thoughtspotColumns)) {
            return false;
        }
        String this$thoughtspotQuestionText = this.getThoughtspotQuestionText();
        String other$thoughtspotQuestionText = other.getThoughtspotQuestionText();
        return !(this$thoughtspotQuestionText == null ? other$thoughtspotQuestionText != null : !this$thoughtspotQuestionText.equals(other$thoughtspotQuestionText));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ThoughtspotWorksheet;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $thoughtspotColumnCount = this.getThoughtspotColumnCount();
        result = result * 59 + ($thoughtspotColumnCount == null ? 43 : ((Object)$thoughtspotColumnCount).hashCode());
        Long $thoughtspotJoinCount = this.getThoughtspotJoinCount();
        result = result * 59 + ($thoughtspotJoinCount == null ? 43 : ((Object)$thoughtspotJoinCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<IAirflowTask> $inputToAirflowTasks = this.getInputToAirflowTasks();
        result = result * 59 + ($inputToAirflowTasks == null ? 43 : $inputToAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<ISparkJob> $inputToSparkJobs = this.getInputToSparkJobs();
        result = result * 59 + ($inputToSparkJobs == null ? 43 : $inputToSparkJobs.hashCode());
        SortedSet<IAirflowTask> $outputFromAirflowTasks = this.getOutputFromAirflowTasks();
        result = result * 59 + ($outputFromAirflowTasks == null ? 43 : $outputFromAirflowTasks.hashCode());
        SortedSet<ILineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        SortedSet<ISparkJob> $outputFromSparkJobs = this.getOutputFromSparkJobs();
        result = result * 59 + ($outputFromSparkJobs == null ? 43 : $outputFromSparkJobs.hashCode());
        String $thoughtspotChartType = this.getThoughtspotChartType();
        result = result * 59 + ($thoughtspotChartType == null ? 43 : $thoughtspotChartType.hashCode());
        SortedSet<IThoughtspotColumn> $thoughtspotColumns = this.getThoughtspotColumns();
        result = result * 59 + ($thoughtspotColumns == null ? 43 : $thoughtspotColumns.hashCode());
        String $thoughtspotQuestionText = this.getThoughtspotQuestionText();
        result = result * 59 + ($thoughtspotQuestionText == null ? 43 : $thoughtspotQuestionText.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ThoughtspotWorksheet(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", inputToAirflowTasks=" + this.getInputToAirflowTasks() + ", inputToProcesses=" + this.getInputToProcesses() + ", inputToSparkJobs=" + this.getInputToSparkJobs() + ", outputFromAirflowTasks=" + this.getOutputFromAirflowTasks() + ", outputFromProcesses=" + this.getOutputFromProcesses() + ", outputFromSparkJobs=" + this.getOutputFromSparkJobs() + ", thoughtspotChartType=" + this.getThoughtspotChartType() + ", thoughtspotColumnCount=" + this.getThoughtspotColumnCount() + ", thoughtspotColumns=" + this.getThoughtspotColumns() + ", thoughtspotJoinCount=" + this.getThoughtspotJoinCount() + ", thoughtspotQuestionText=" + this.getThoughtspotQuestionText() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class ThoughtspotWorksheetBuilder<C extends ThoughtspotWorksheet, B extends ThoughtspotWorksheetBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<IAirflowTask> inputToAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> inputToProcesses;
        @Generated
        private ArrayList<ISparkJob> inputToSparkJobs;
        @Generated
        private ArrayList<IAirflowTask> outputFromAirflowTasks;
        @Generated
        private ArrayList<ILineageProcess> outputFromProcesses;
        @Generated
        private ArrayList<ISparkJob> outputFromSparkJobs;
        @Generated
        private String thoughtspotChartType;
        @Generated
        private Long thoughtspotColumnCount;
        @Generated
        private ArrayList<IThoughtspotColumn> thoughtspotColumns;
        @Generated
        private Long thoughtspotJoinCount;
        @Generated
        private String thoughtspotQuestionText;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ThoughtspotWorksheetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ThoughtspotWorksheet instance, ThoughtspotWorksheetBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.inputToAirflowTasks(instance.inputToAirflowTasks == null ? Collections.emptySortedSet() : instance.inputToAirflowTasks);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.inputToSparkJobs(instance.inputToSparkJobs == null ? Collections.emptySortedSet() : instance.inputToSparkJobs);
            b.outputFromAirflowTasks(instance.outputFromAirflowTasks == null ? Collections.emptySortedSet() : instance.outputFromAirflowTasks);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
            b.outputFromSparkJobs(instance.outputFromSparkJobs == null ? Collections.emptySortedSet() : instance.outputFromSparkJobs);
            b.thoughtspotChartType(instance.thoughtspotChartType);
            b.thoughtspotColumnCount(instance.thoughtspotColumnCount);
            b.thoughtspotColumns(instance.thoughtspotColumns == null ? Collections.emptySortedSet() : instance.thoughtspotColumns);
            b.thoughtspotJoinCount(instance.thoughtspotJoinCount);
            b.thoughtspotQuestionText(instance.thoughtspotQuestionText);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTask(IAirflowTask inputToAirflowTask) {
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.add(inputToAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B inputToAirflowTasks(Collection<? extends IAirflowTask> inputToAirflowTasks) {
            if (inputToAirflowTasks == null) {
                throw new NullPointerException("inputToAirflowTasks cannot be null");
            }
            if (this.inputToAirflowTasks == null) {
                this.inputToAirflowTasks = new ArrayList();
            }
            this.inputToAirflowTasks.addAll(inputToAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearInputToAirflowTasks() {
            if (this.inputToAirflowTasks != null) {
                this.inputToAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(ILineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends ILineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJob(ISparkJob inputToSparkJob) {
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.add(inputToSparkJob);
            return (B)this.self();
        }

        @Generated
        public B inputToSparkJobs(Collection<? extends ISparkJob> inputToSparkJobs) {
            if (inputToSparkJobs == null) {
                throw new NullPointerException("inputToSparkJobs cannot be null");
            }
            if (this.inputToSparkJobs == null) {
                this.inputToSparkJobs = new ArrayList();
            }
            this.inputToSparkJobs.addAll(inputToSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearInputToSparkJobs() {
            if (this.inputToSparkJobs != null) {
                this.inputToSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTask(IAirflowTask outputFromAirflowTask) {
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.add(outputFromAirflowTask);
            return (B)this.self();
        }

        @Generated
        public B outputFromAirflowTasks(Collection<? extends IAirflowTask> outputFromAirflowTasks) {
            if (outputFromAirflowTasks == null) {
                throw new NullPointerException("outputFromAirflowTasks cannot be null");
            }
            if (this.outputFromAirflowTasks == null) {
                this.outputFromAirflowTasks = new ArrayList();
            }
            this.outputFromAirflowTasks.addAll(outputFromAirflowTasks);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromAirflowTasks() {
            if (this.outputFromAirflowTasks != null) {
                this.outputFromAirflowTasks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(ILineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends ILineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJob(ISparkJob outputFromSparkJob) {
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.add(outputFromSparkJob);
            return (B)this.self();
        }

        @Generated
        public B outputFromSparkJobs(Collection<? extends ISparkJob> outputFromSparkJobs) {
            if (outputFromSparkJobs == null) {
                throw new NullPointerException("outputFromSparkJobs cannot be null");
            }
            if (this.outputFromSparkJobs == null) {
                this.outputFromSparkJobs = new ArrayList();
            }
            this.outputFromSparkJobs.addAll(outputFromSparkJobs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromSparkJobs() {
            if (this.outputFromSparkJobs != null) {
                this.outputFromSparkJobs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B thoughtspotChartType(String thoughtspotChartType) {
            this.thoughtspotChartType = thoughtspotChartType;
            return (B)this.self();
        }

        @Generated
        public B thoughtspotColumnCount(Long thoughtspotColumnCount) {
            this.thoughtspotColumnCount = thoughtspotColumnCount;
            return (B)this.self();
        }

        @Generated
        public B thoughtspotColumn(IThoughtspotColumn thoughtspotColumn) {
            if (this.thoughtspotColumns == null) {
                this.thoughtspotColumns = new ArrayList();
            }
            this.thoughtspotColumns.add(thoughtspotColumn);
            return (B)this.self();
        }

        @Generated
        public B thoughtspotColumns(Collection<? extends IThoughtspotColumn> thoughtspotColumns) {
            if (thoughtspotColumns == null) {
                throw new NullPointerException("thoughtspotColumns cannot be null");
            }
            if (this.thoughtspotColumns == null) {
                this.thoughtspotColumns = new ArrayList();
            }
            this.thoughtspotColumns.addAll(thoughtspotColumns);
            return (B)this.self();
        }

        @Generated
        public B clearThoughtspotColumns() {
            if (this.thoughtspotColumns != null) {
                this.thoughtspotColumns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B thoughtspotJoinCount(Long thoughtspotJoinCount) {
            this.thoughtspotJoinCount = thoughtspotJoinCount;
            return (B)this.self();
        }

        @Generated
        public B thoughtspotQuestionText(String thoughtspotQuestionText) {
            this.thoughtspotQuestionText = thoughtspotQuestionText;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ThoughtspotWorksheet.ThoughtspotWorksheetBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", inputToAirflowTasks=" + this.inputToAirflowTasks + ", inputToProcesses=" + this.inputToProcesses + ", inputToSparkJobs=" + this.inputToSparkJobs + ", outputFromAirflowTasks=" + this.outputFromAirflowTasks + ", outputFromProcesses=" + this.outputFromProcesses + ", outputFromSparkJobs=" + this.outputFromSparkJobs + ", thoughtspotChartType=" + this.thoughtspotChartType + ", thoughtspotColumnCount=" + this.thoughtspotColumnCount + ", thoughtspotColumns=" + this.thoughtspotColumns + ", thoughtspotJoinCount=" + this.thoughtspotJoinCount + ", thoughtspotQuestionText=" + this.thoughtspotQuestionText + ")";
        }
    }

    @Generated
    private static final class ThoughtspotWorksheetBuilderImpl
    extends ThoughtspotWorksheetBuilder<ThoughtspotWorksheet, ThoughtspotWorksheetBuilderImpl> {
        @Generated
        private ThoughtspotWorksheetBuilderImpl() {
        }

        @Override
        @Generated
        protected ThoughtspotWorksheetBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ThoughtspotWorksheet build() {
            return new ThoughtspotWorksheet(this);
        }
    }
}

