/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Date;
import com.atlan.model.assets.IAsset;
import com.atlan.model.assets.IGlossaryTerm;
import com.atlan.model.assets.IReferenceable;
import com.atlan.model.assets.IWorkflowRun;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.CertificateStatus;
import com.atlan.model.enums.WorkflowRunStatus;
import com.atlan.model.enums.WorkflowRunType;
import com.atlan.model.relations.Reference;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.FluentSearch;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowRun
extends Asset
implements IWorkflowRun,
IAsset,
IReferenceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowRun.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "WorkflowRun";
    String typeName;
    @Attribute
    String workflowRunComment;
    @Attribute
    String workflowRunConfig;
    @Attribute
    String workflowRunCreatedBy;
    @Attribute
    @Date
    Long workflowRunDeletedAt;
    @Attribute
    @Date
    Long workflowRunExpiresAt;
    @Attribute
    String workflowRunOnAssetGuid;
    @Attribute
    WorkflowRunStatus workflowRunStatus;
    @Attribute
    WorkflowRunType workflowRunType;
    @Attribute
    String workflowRunUpdatedBy;
    @Attribute
    String workflowRunWorkflowGuid;

    @Override
    public WorkflowRun trimToReference() throws InvalidRequestException {
        if (this.getGuid() != null && !this.getGuid().isEmpty()) {
            return WorkflowRun.refByGuid(this.getGuid());
        }
        if (this.getQualifiedName() != null && !this.getQualifiedName().isEmpty()) {
            return WorkflowRun.refByQualifiedName(this.getQualifiedName());
        }
        if (this.getUniqueAttributes() != null && this.getUniqueAttributes().getQualifiedName() != null && !this.getUniqueAttributes().getQualifiedName().isEmpty()) {
            return WorkflowRun.refByQualifiedName(this.getUniqueAttributes().getQualifiedName());
        }
        throw new InvalidRequestException(ErrorCode.MISSING_REQUIRED_RELATIONSHIP_PARAM, TYPE_NAME, "guid, qualifiedName");
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select() {
        return WorkflowRun.select(Atlan.getDefaultClient());
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client) {
        return WorkflowRun.select(client, false);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(boolean includeArchived) {
        return WorkflowRun.select(Atlan.getDefaultClient(), includeArchived);
    }

    public static FluentSearch.FluentSearchBuilder<?, ?> select(AtlanClient client, boolean includeArchived) {
        FluentSearch.FluentSearchBuilder builder = (FluentSearch.FluentSearchBuilder)FluentSearch.builder(client).where(Asset.TYPE_NAME.eq(TYPE_NAME));
        if (!includeArchived) {
            builder.active();
        }
        return builder;
    }

    public static WorkflowRun refByGuid(String guid) {
        return WorkflowRun.refByGuid(guid, Reference.SaveSemantic.REPLACE);
    }

    public static WorkflowRun refByGuid(String guid, Reference.SaveSemantic semantic) {
        return ((WorkflowRunBuilder)((WorkflowRunBuilder)WorkflowRun._internal().guid(guid)).semantic(semantic)).build();
    }

    public static WorkflowRun refByQualifiedName(String qualifiedName) {
        return WorkflowRun.refByQualifiedName(qualifiedName, Reference.SaveSemantic.REPLACE);
    }

    public static WorkflowRun refByQualifiedName(String qualifiedName, Reference.SaveSemantic semantic) {
        return ((WorkflowRunBuilder)((WorkflowRunBuilder)WorkflowRun._internal().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).semantic(semantic)).build();
    }

    @JsonIgnore
    public static WorkflowRun get(String id) throws AtlanException {
        return WorkflowRun.get(Atlan.getDefaultClient(), id);
    }

    @JsonIgnore
    public static WorkflowRun get(AtlanClient client, String id) throws AtlanException {
        return WorkflowRun.get(client, id, true);
    }

    @JsonIgnore
    public static WorkflowRun get(AtlanClient client, String id, boolean includeRelationships) throws AtlanException {
        if (id == null) {
            throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, "(null)");
        }
        if (StringUtils.isUUID(id)) {
            Asset asset = Asset.get(client, id, includeRelationships);
            if (asset == null) {
                throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_GUID, id);
            }
            if (asset instanceof WorkflowRun) {
                return (WorkflowRun)asset;
            }
            throw new NotFoundException(ErrorCode.ASSET_NOT_TYPE_REQUESTED, id, TYPE_NAME);
        }
        Asset asset = Asset.get(client, TYPE_NAME, id, includeRelationships);
        if (asset instanceof WorkflowRun) {
            return (WorkflowRun)asset;
        }
        throw new NotFoundException(ErrorCode.ASSET_NOT_FOUND_BY_QN, id, TYPE_NAME);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return WorkflowRun.restore(Atlan.getDefaultClient(), qualifiedName);
    }

    public static boolean restore(AtlanClient client, String qualifiedName) throws AtlanException {
        return Asset.restore(client, TYPE_NAME, qualifiedName);
    }

    public static WorkflowRunBuilder<?, ?> updater(String qualifiedName, String name) {
        return (WorkflowRunBuilder)((WorkflowRunBuilder)((WorkflowRunBuilder)WorkflowRun._internal().guid("-" + ThreadLocalRandom.current().nextLong(0L, 0x7FFFFFFFFFFFFFFEL))).qualifiedName(qualifiedName)).name(name);
    }

    public WorkflowRunBuilder<?, ?> trimToRequired() throws InvalidRequestException {
        WorkflowRun.validateRequired(TYPE_NAME, Map.of("qualifiedName", this.getQualifiedName(), "name", this.getName()));
        return WorkflowRun.updater(this.getQualifiedName(), this.getName());
    }

    public static WorkflowRun removeDescription(String qualifiedName, String name) throws AtlanException {
        return WorkflowRun.removeDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static WorkflowRun removeDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (WorkflowRun)Asset.removeDescription(client, WorkflowRun.updater(qualifiedName, name));
    }

    public static WorkflowRun removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return WorkflowRun.removeUserDescription(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static WorkflowRun removeUserDescription(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (WorkflowRun)Asset.removeUserDescription(client, WorkflowRun.updater(qualifiedName, name));
    }

    public static WorkflowRun removeOwners(String qualifiedName, String name) throws AtlanException {
        return WorkflowRun.removeOwners(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static WorkflowRun removeOwners(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (WorkflowRun)Asset.removeOwners(client, WorkflowRun.updater(qualifiedName, name));
    }

    public static WorkflowRun updateCertificate(String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return WorkflowRun.updateCertificate(Atlan.getDefaultClient(), qualifiedName, certificate, message);
    }

    public static WorkflowRun updateCertificate(AtlanClient client, String qualifiedName, CertificateStatus certificate, String message) throws AtlanException {
        return (WorkflowRun)Asset.updateCertificate(client, WorkflowRun._internal(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static WorkflowRun removeCertificate(String qualifiedName, String name) throws AtlanException {
        return WorkflowRun.removeCertificate(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static WorkflowRun removeCertificate(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (WorkflowRun)Asset.removeCertificate(client, WorkflowRun.updater(qualifiedName, name));
    }

    public static WorkflowRun updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return WorkflowRun.updateAnnouncement(Atlan.getDefaultClient(), qualifiedName, type, title, message);
    }

    public static WorkflowRun updateAnnouncement(AtlanClient client, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (WorkflowRun)Asset.updateAnnouncement(client, WorkflowRun._internal(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static WorkflowRun removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return WorkflowRun.removeAnnouncement(Atlan.getDefaultClient(), qualifiedName, name);
    }

    public static WorkflowRun removeAnnouncement(AtlanClient client, String qualifiedName, String name) throws AtlanException {
        return (WorkflowRun)Asset.removeAnnouncement(client, WorkflowRun.updater(qualifiedName, name));
    }

    public static WorkflowRun replaceTerms(String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return WorkflowRun.replaceTerms(Atlan.getDefaultClient(), qualifiedName, name, terms);
    }

    public static WorkflowRun replaceTerms(AtlanClient client, String qualifiedName, String name, List<IGlossaryTerm> terms) throws AtlanException {
        return (WorkflowRun)Asset.replaceTerms(client, WorkflowRun.updater(qualifiedName, name), terms);
    }

    public static WorkflowRun appendTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return WorkflowRun.appendTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static WorkflowRun appendTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (WorkflowRun)Asset.appendTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static WorkflowRun removeTerms(String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return WorkflowRun.removeTerms(Atlan.getDefaultClient(), qualifiedName, terms);
    }

    public static WorkflowRun removeTerms(AtlanClient client, String qualifiedName, List<IGlossaryTerm> terms) throws AtlanException {
        return (WorkflowRun)Asset.removeTerms(client, TYPE_NAME, qualifiedName, terms);
    }

    public static WorkflowRun appendAtlanTags(String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return WorkflowRun.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames);
    }

    public static WorkflowRun appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames) throws AtlanException {
        return (WorkflowRun)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames);
    }

    public static WorkflowRun appendAtlanTags(String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return WorkflowRun.appendAtlanTags(Atlan.getDefaultClient(), qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static WorkflowRun appendAtlanTags(AtlanClient client, String qualifiedName, List<String> atlanTagNames, boolean propagate, boolean removePropagationsOnDelete, boolean restrictLineagePropagation) throws AtlanException {
        return (WorkflowRun)Asset.appendAtlanTags(client, TYPE_NAME, qualifiedName, atlanTagNames, propagate, removePropagationsOnDelete, restrictLineagePropagation);
    }

    public static void removeAtlanTag(String qualifiedName, String atlanTagName) throws AtlanException {
        WorkflowRun.removeAtlanTag(Atlan.getDefaultClient(), qualifiedName, atlanTagName);
    }

    public static void removeAtlanTag(AtlanClient client, String qualifiedName, String atlanTagName) throws AtlanException {
        Asset.removeAtlanTag(client, TYPE_NAME, qualifiedName, atlanTagName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected WorkflowRun(WorkflowRunBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : WorkflowRun.$default$typeName();
        this.workflowRunComment = b.workflowRunComment;
        this.workflowRunConfig = b.workflowRunConfig;
        this.workflowRunCreatedBy = b.workflowRunCreatedBy;
        this.workflowRunDeletedAt = b.workflowRunDeletedAt;
        this.workflowRunExpiresAt = b.workflowRunExpiresAt;
        this.workflowRunOnAssetGuid = b.workflowRunOnAssetGuid;
        this.workflowRunStatus = b.workflowRunStatus;
        this.workflowRunType = b.workflowRunType;
        this.workflowRunUpdatedBy = b.workflowRunUpdatedBy;
        this.workflowRunWorkflowGuid = b.workflowRunWorkflowGuid;
    }

    @Generated
    public static WorkflowRunBuilder<?, ?> _internal() {
        return new WorkflowRunBuilderImpl();
    }

    @Generated
    public WorkflowRunBuilder<?, ?> toBuilder() {
        return new WorkflowRunBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getWorkflowRunComment() {
        return this.workflowRunComment;
    }

    @Override
    @Generated
    public String getWorkflowRunConfig() {
        return this.workflowRunConfig;
    }

    @Override
    @Generated
    public String getWorkflowRunCreatedBy() {
        return this.workflowRunCreatedBy;
    }

    @Override
    @Generated
    public Long getWorkflowRunDeletedAt() {
        return this.workflowRunDeletedAt;
    }

    @Override
    @Generated
    public Long getWorkflowRunExpiresAt() {
        return this.workflowRunExpiresAt;
    }

    @Override
    @Generated
    public String getWorkflowRunOnAssetGuid() {
        return this.workflowRunOnAssetGuid;
    }

    @Override
    @Generated
    public WorkflowRunStatus getWorkflowRunStatus() {
        return this.workflowRunStatus;
    }

    @Override
    @Generated
    public WorkflowRunType getWorkflowRunType() {
        return this.workflowRunType;
    }

    @Override
    @Generated
    public String getWorkflowRunUpdatedBy() {
        return this.workflowRunUpdatedBy;
    }

    @Override
    @Generated
    public String getWorkflowRunWorkflowGuid() {
        return this.workflowRunWorkflowGuid;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowRun)) {
            return false;
        }
        WorkflowRun other = (WorkflowRun)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$workflowRunDeletedAt = this.getWorkflowRunDeletedAt();
        Long other$workflowRunDeletedAt = other.getWorkflowRunDeletedAt();
        if (this$workflowRunDeletedAt == null ? other$workflowRunDeletedAt != null : !((Object)this$workflowRunDeletedAt).equals(other$workflowRunDeletedAt)) {
            return false;
        }
        Long this$workflowRunExpiresAt = this.getWorkflowRunExpiresAt();
        Long other$workflowRunExpiresAt = other.getWorkflowRunExpiresAt();
        if (this$workflowRunExpiresAt == null ? other$workflowRunExpiresAt != null : !((Object)this$workflowRunExpiresAt).equals(other$workflowRunExpiresAt)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$workflowRunComment = this.getWorkflowRunComment();
        String other$workflowRunComment = other.getWorkflowRunComment();
        if (this$workflowRunComment == null ? other$workflowRunComment != null : !this$workflowRunComment.equals(other$workflowRunComment)) {
            return false;
        }
        String this$workflowRunConfig = this.getWorkflowRunConfig();
        String other$workflowRunConfig = other.getWorkflowRunConfig();
        if (this$workflowRunConfig == null ? other$workflowRunConfig != null : !this$workflowRunConfig.equals(other$workflowRunConfig)) {
            return false;
        }
        String this$workflowRunCreatedBy = this.getWorkflowRunCreatedBy();
        String other$workflowRunCreatedBy = other.getWorkflowRunCreatedBy();
        if (this$workflowRunCreatedBy == null ? other$workflowRunCreatedBy != null : !this$workflowRunCreatedBy.equals(other$workflowRunCreatedBy)) {
            return false;
        }
        String this$workflowRunOnAssetGuid = this.getWorkflowRunOnAssetGuid();
        String other$workflowRunOnAssetGuid = other.getWorkflowRunOnAssetGuid();
        if (this$workflowRunOnAssetGuid == null ? other$workflowRunOnAssetGuid != null : !this$workflowRunOnAssetGuid.equals(other$workflowRunOnAssetGuid)) {
            return false;
        }
        WorkflowRunStatus this$workflowRunStatus = this.getWorkflowRunStatus();
        WorkflowRunStatus other$workflowRunStatus = other.getWorkflowRunStatus();
        if (this$workflowRunStatus == null ? other$workflowRunStatus != null : !this$workflowRunStatus.equals(other$workflowRunStatus)) {
            return false;
        }
        WorkflowRunType this$workflowRunType = this.getWorkflowRunType();
        WorkflowRunType other$workflowRunType = other.getWorkflowRunType();
        if (this$workflowRunType == null ? other$workflowRunType != null : !this$workflowRunType.equals(other$workflowRunType)) {
            return false;
        }
        String this$workflowRunUpdatedBy = this.getWorkflowRunUpdatedBy();
        String other$workflowRunUpdatedBy = other.getWorkflowRunUpdatedBy();
        if (this$workflowRunUpdatedBy == null ? other$workflowRunUpdatedBy != null : !this$workflowRunUpdatedBy.equals(other$workflowRunUpdatedBy)) {
            return false;
        }
        String this$workflowRunWorkflowGuid = this.getWorkflowRunWorkflowGuid();
        String other$workflowRunWorkflowGuid = other.getWorkflowRunWorkflowGuid();
        return !(this$workflowRunWorkflowGuid == null ? other$workflowRunWorkflowGuid != null : !this$workflowRunWorkflowGuid.equals(other$workflowRunWorkflowGuid));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkflowRun;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $workflowRunDeletedAt = this.getWorkflowRunDeletedAt();
        result = result * 59 + ($workflowRunDeletedAt == null ? 43 : ((Object)$workflowRunDeletedAt).hashCode());
        Long $workflowRunExpiresAt = this.getWorkflowRunExpiresAt();
        result = result * 59 + ($workflowRunExpiresAt == null ? 43 : ((Object)$workflowRunExpiresAt).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $workflowRunComment = this.getWorkflowRunComment();
        result = result * 59 + ($workflowRunComment == null ? 43 : $workflowRunComment.hashCode());
        String $workflowRunConfig = this.getWorkflowRunConfig();
        result = result * 59 + ($workflowRunConfig == null ? 43 : $workflowRunConfig.hashCode());
        String $workflowRunCreatedBy = this.getWorkflowRunCreatedBy();
        result = result * 59 + ($workflowRunCreatedBy == null ? 43 : $workflowRunCreatedBy.hashCode());
        String $workflowRunOnAssetGuid = this.getWorkflowRunOnAssetGuid();
        result = result * 59 + ($workflowRunOnAssetGuid == null ? 43 : $workflowRunOnAssetGuid.hashCode());
        WorkflowRunStatus $workflowRunStatus = this.getWorkflowRunStatus();
        result = result * 59 + ($workflowRunStatus == null ? 43 : $workflowRunStatus.hashCode());
        WorkflowRunType $workflowRunType = this.getWorkflowRunType();
        result = result * 59 + ($workflowRunType == null ? 43 : $workflowRunType.hashCode());
        String $workflowRunUpdatedBy = this.getWorkflowRunUpdatedBy();
        result = result * 59 + ($workflowRunUpdatedBy == null ? 43 : $workflowRunUpdatedBy.hashCode());
        String $workflowRunWorkflowGuid = this.getWorkflowRunWorkflowGuid();
        result = result * 59 + ($workflowRunWorkflowGuid == null ? 43 : $workflowRunWorkflowGuid.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "WorkflowRun(super=" + super.toString() + ", typeName=" + this.getTypeName() + ", workflowRunComment=" + this.getWorkflowRunComment() + ", workflowRunConfig=" + this.getWorkflowRunConfig() + ", workflowRunCreatedBy=" + this.getWorkflowRunCreatedBy() + ", workflowRunDeletedAt=" + this.getWorkflowRunDeletedAt() + ", workflowRunExpiresAt=" + this.getWorkflowRunExpiresAt() + ", workflowRunOnAssetGuid=" + this.getWorkflowRunOnAssetGuid() + ", workflowRunStatus=" + this.getWorkflowRunStatus() + ", workflowRunType=" + this.getWorkflowRunType() + ", workflowRunUpdatedBy=" + this.getWorkflowRunUpdatedBy() + ", workflowRunWorkflowGuid=" + this.getWorkflowRunWorkflowGuid() + ")";
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public static abstract class WorkflowRunBuilder<C extends WorkflowRun, B extends WorkflowRunBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String workflowRunComment;
        @Generated
        private String workflowRunConfig;
        @Generated
        private String workflowRunCreatedBy;
        @Generated
        private Long workflowRunDeletedAt;
        @Generated
        private Long workflowRunExpiresAt;
        @Generated
        private String workflowRunOnAssetGuid;
        @Generated
        private WorkflowRunStatus workflowRunStatus;
        @Generated
        private WorkflowRunType workflowRunType;
        @Generated
        private String workflowRunUpdatedBy;
        @Generated
        private String workflowRunWorkflowGuid;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            WorkflowRunBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(WorkflowRun instance, WorkflowRunBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.workflowRunComment(instance.workflowRunComment);
            b.workflowRunConfig(instance.workflowRunConfig);
            b.workflowRunCreatedBy(instance.workflowRunCreatedBy);
            b.workflowRunDeletedAt(instance.workflowRunDeletedAt);
            b.workflowRunExpiresAt(instance.workflowRunExpiresAt);
            b.workflowRunOnAssetGuid(instance.workflowRunOnAssetGuid);
            b.workflowRunStatus(instance.workflowRunStatus);
            b.workflowRunType(instance.workflowRunType);
            b.workflowRunUpdatedBy(instance.workflowRunUpdatedBy);
            b.workflowRunWorkflowGuid(instance.workflowRunWorkflowGuid);
        }

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B workflowRunComment(String workflowRunComment) {
            this.workflowRunComment = workflowRunComment;
            return (B)this.self();
        }

        @Generated
        public B workflowRunConfig(String workflowRunConfig) {
            this.workflowRunConfig = workflowRunConfig;
            return (B)this.self();
        }

        @Generated
        public B workflowRunCreatedBy(String workflowRunCreatedBy) {
            this.workflowRunCreatedBy = workflowRunCreatedBy;
            return (B)this.self();
        }

        @Generated
        public B workflowRunDeletedAt(Long workflowRunDeletedAt) {
            this.workflowRunDeletedAt = workflowRunDeletedAt;
            return (B)this.self();
        }

        @Generated
        public B workflowRunExpiresAt(Long workflowRunExpiresAt) {
            this.workflowRunExpiresAt = workflowRunExpiresAt;
            return (B)this.self();
        }

        @Generated
        public B workflowRunOnAssetGuid(String workflowRunOnAssetGuid) {
            this.workflowRunOnAssetGuid = workflowRunOnAssetGuid;
            return (B)this.self();
        }

        @Generated
        public B workflowRunStatus(WorkflowRunStatus workflowRunStatus) {
            this.workflowRunStatus = workflowRunStatus;
            return (B)this.self();
        }

        @Generated
        public B workflowRunType(WorkflowRunType workflowRunType) {
            this.workflowRunType = workflowRunType;
            return (B)this.self();
        }

        @Generated
        public B workflowRunUpdatedBy(String workflowRunUpdatedBy) {
            this.workflowRunUpdatedBy = workflowRunUpdatedBy;
            return (B)this.self();
        }

        @Generated
        public B workflowRunWorkflowGuid(String workflowRunWorkflowGuid) {
            this.workflowRunWorkflowGuid = workflowRunWorkflowGuid;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "WorkflowRun.WorkflowRunBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", workflowRunComment=" + this.workflowRunComment + ", workflowRunConfig=" + this.workflowRunConfig + ", workflowRunCreatedBy=" + this.workflowRunCreatedBy + ", workflowRunDeletedAt=" + this.workflowRunDeletedAt + ", workflowRunExpiresAt=" + this.workflowRunExpiresAt + ", workflowRunOnAssetGuid=" + this.workflowRunOnAssetGuid + ", workflowRunStatus=" + this.workflowRunStatus + ", workflowRunType=" + this.workflowRunType + ", workflowRunUpdatedBy=" + this.workflowRunUpdatedBy + ", workflowRunWorkflowGuid=" + this.workflowRunWorkflowGuid + ")";
        }
    }

    @Generated
    private static final class WorkflowRunBuilderImpl
    extends WorkflowRunBuilder<WorkflowRun, WorkflowRunBuilderImpl> {
        @Generated
        private WorkflowRunBuilderImpl() {
        }

        @Override
        @Generated
        protected WorkflowRunBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public WorkflowRun build() {
            return new WorkflowRun(this);
        }
    }
}

