/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.core;

import com.atlan.exception.ApiException;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.PermissionException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.AtlanCollection;
import com.atlan.model.assets.Connection;
import com.atlan.model.core.AssetMutationResponse;
import com.atlan.model.core.AssetResponse;
import com.atlan.model.core.AtlanAsyncMutator;
import com.atlan.net.HttpClient;
import com.atlan.net.RequestOptions;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncCreationResponse
extends AssetMutationResponse
implements AtlanAsyncMutator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncCreationResponse.class);
    private static final long serialVersionUID = 2L;

    @Override
    public AssetMutationResponse block() throws ApiException {
        List<Asset> toCheck = this.getCreatedAssets();
        if (toCheck != null && !toCheck.isEmpty()) {
            try {
                this.retrieveAndCheck(toCheck, 0);
            }
            catch (InterruptedException e) {
                throw new ApiException(ErrorCode.RETRIES_INTERRUPTED, (Throwable)e, new String[0]);
            }
        }
        return this;
    }

    private void retrieveAndCheck(List<Asset> toCheck, int retryCount) throws InterruptedException, ApiException {
        ArrayList<Asset> leftovers = new ArrayList<Asset>();
        for (Asset one : toCheck) {
            if (!(one instanceof Connection) && !(one instanceof AtlanCollection)) continue;
            log.debug(" ... blocking to confirm {} accessibility: {}", (Object)one.getTypeName(), (Object)one.getGuid());
            try {
                AssetResponse candidate = this.client.assets.get(one.getGuid(), false, false, RequestOptions.from(this.client).maxNetworkRetries(60).build());
                if (candidate != null && candidate.getAsset() != null) continue;
                throw new ApiException(ErrorCode.RETRY_OVERRUN, null, new String[0]);
            }
            catch (PermissionException e) {
                throw new ApiException(ErrorCode.RETRY_OVERRUN, (Throwable)e, new String[0]);
            }
            catch (AtlanException e) {
                leftovers.add(one);
            }
        }
        if (!leftovers.isEmpty()) {
            if (retryCount == this.client.getMaxNetworkRetries()) {
                throw new ApiException(ErrorCode.RETRY_OVERRUN, null, new String[0]);
            }
            Thread.sleep(HttpClient.waitTime(retryCount).toMillis());
            this.retrieveAndCheck(leftovers, retryCount + 1);
        }
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncCreationResponse)) {
            return false;
        }
        AsyncCreationResponse other = (AsyncCreationResponse)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AsyncCreationResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Override
    @Generated
    public String toString() {
        return "AsyncCreationResponse(super=" + super.toString() + ")";
    }
}

