/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.fields;

import co.elastic.clients.elasticsearch._types.FieldSort;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CardinalityAggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.ExistsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import co.elastic.clients.util.NamedValue;
import co.elastic.clients.util.ObjectBuilder;
import java.util.List;
import java.util.Map;

public interface ISearchable {
    public static final String EMBEDDED_SOURCE_VALUE = "sourceValue";

    public Query hasAnyValue();

    public static Query hasAnyValue(String field) {
        return ExistsQuery.of(e -> e.field(field))._toQuery();
    }

    public Aggregation distinct();

    public static Aggregation distinct(String field) {
        return Aggregation.of(a -> a.cardinality(c -> (ObjectBuilder)c.field(field)));
    }

    public Aggregation distinct(int var1);

    public static Aggregation distinct(String field, int precision) {
        return Aggregation.of(a -> a.cardinality(c -> ((CardinalityAggregation.Builder)c.field(field)).precisionThreshold(Integer.valueOf(precision))));
    }

    public Aggregation count();

    public static Aggregation count(String field) {
        return Aggregation.of(a -> a.valueCount(v -> (ObjectBuilder)v.field(field)));
    }

    default public Aggregation bucketBy() {
        return this.bucketBy(10);
    }

    public static Aggregation bucketBy(String field) {
        return ISearchable.bucketBy(field, 10);
    }

    default public Aggregation bucketBy(int size) {
        return this.bucketBy(size, false);
    }

    public static Aggregation bucketBy(String field, int size) {
        return ISearchable.bucketBy(field, size, null);
    }

    public Aggregation bucketBy(int var1, boolean var2);

    public static Aggregation bucketBy(String field, int size, String sourceAttribute) {
        if (sourceAttribute != null && !sourceAttribute.isEmpty()) {
            return ISearchable.bucketBy(field, size, Map.of(EMBEDDED_SOURCE_VALUE, ISearchable.topHits(sourceAttribute)), null);
        }
        return Aggregation.of(a -> a.terms(t -> t.field(field).size(Integer.valueOf(size))));
    }

    public Aggregation bucketBy(int var1, Map<String, Aggregation> var2, List<NamedValue<SortOrder>> var3);

    public static Aggregation bucketBy(String field, int size, Map<String, Aggregation> nested, List<NamedValue<SortOrder>> order) {
        if (nested != null) {
            if (order != null) {
                return Aggregation.of(a -> a.terms(t -> t.field(field).size(Integer.valueOf(size)).order(order)).aggregations(nested));
            }
            return Aggregation.of(a -> a.terms(t -> t.field(field).size(Integer.valueOf(size))).aggregations(nested));
        }
        return Aggregation.of(a -> a.terms(t -> t.field(field).size(Integer.valueOf(size))));
    }

    private static Aggregation topHits(String field) {
        return Aggregation.of(h -> h.topHits((T t) -> t.size(Integer.valueOf(1)).source(SourceConfig.of(c -> c.filter(f -> f.includes(field, new String[0]))))));
    }

    public SortOptions order(SortOrder var1);

    public static SortOptions order(String field, SortOrder order) {
        return SortOptions.of(s -> s.field(FieldSort.of(f -> f.field(field).order(order))));
    }
}

