/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.fields;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.atlan.model.enums.AtlanEnum;
import com.atlan.model.enums.ElasticRegexOperator;
import com.atlan.model.fields.IKeywordSearchable;
import com.atlan.model.fields.IStemmedSearchable;
import com.atlan.model.fields.ITextSearchable;
import com.atlan.model.fields.SearchableField;
import com.atlan.model.lineage.LineageFilterFieldString;
import java.util.Collection;
import java.util.List;

public class KeywordTextStemmedField
extends SearchableField
implements IKeywordSearchable,
ITextSearchable,
IStemmedSearchable {
    private final String textFieldName;
    private final String stemmedFieldName;
    public final LineageFilterFieldString inLineage = new LineageFilterFieldString(this);

    public KeywordTextStemmedField(String atlan, String keyword, String text, String stemmed) {
        super(atlan, keyword);
        this.textFieldName = text;
        this.stemmedFieldName = stemmed;
    }

    @Override
    public String getKeywordFieldName() {
        return this.getElasticFieldName();
    }

    @Override
    public String getTextFieldName() {
        return this.textFieldName;
    }

    @Override
    public String getStemmedFieldName() {
        return this.stemmedFieldName;
    }

    @Override
    public Query startsWith(String value, boolean caseInsensitive) {
        return IKeywordSearchable.startsWith(this.getKeywordFieldName(), value, caseInsensitive);
    }

    @Override
    public Query eq(AtlanEnum value) {
        return IKeywordSearchable.eq(this.getKeywordFieldName(), value);
    }

    @Override
    public Query eq(String value, boolean caseInsensitive) {
        return IKeywordSearchable.eq(this.getKeywordFieldName(), value, caseInsensitive);
    }

    @Override
    public Query in(Collection<String> values) {
        return IKeywordSearchable.in(this.getKeywordFieldName(), values);
    }

    @Override
    public Query in(List<String> values, int minMustMatch) {
        return IKeywordSearchable.in(this.getKeywordFieldName(), values, minMustMatch);
    }

    @Override
    public Query wildcard(String value, boolean caseInsensitive) {
        return IKeywordSearchable.wildcard(this.getKeywordFieldName(), value, caseInsensitive);
    }

    @Override
    public Query regex(String regexp, Collection<ElasticRegexOperator> flags, boolean caseInsensitive) {
        return IKeywordSearchable.regex(this.getKeywordFieldName(), regexp, flags, caseInsensitive);
    }

    @Override
    public Query match(String value) {
        return ITextSearchable.match(this.getTextFieldName(), value);
    }

    @Override
    public Query matchStemmed(String value) {
        return IStemmedSearchable.matchStemmed(this.getStemmedFieldName(), value);
    }
}

