/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.lineage;

import com.atlan.Atlan;
import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.lineage.OpenLineageInputDataset;
import com.atlan.model.lineage.OpenLineageOutputDataset;
import com.atlan.model.lineage.OpenLineageRun;
import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClientUtils;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class OpenLineageEvent
extends AtlanObject {
    private static final long serialVersionUID = 2L;
    private OpenLineage.RunEventBuilder _builder;
    OpenLineageRun run;
    List<OpenLineageInputDataset> inputs;
    List<OpenLineageOutputDataset> outputs;
    OpenLineage.BaseEvent _event;

    public OpenLineageEvent(OpenLineage.BaseEvent event) {
        this._event = event;
    }

    public static OpenLineageEventBuilder<?, ?> creator(OpenLineageRun run, OpenLineage.RunEvent.EventType type) {
        OpenLineage ol = run.getJob().getOpenLineage();
        OpenLineage.RunEventBuilder b = ol.newRunEventBuilder().eventType(type).eventTime(ZonedDateTime.now(ZoneId.of("UTC"))).run(run.get_run()).job(run.getJob().get_job());
        return ((OpenLineageEventBuilder)OpenLineageEvent._internal().run(run))._builder(b);
    }

    public void emit() throws AtlanException {
        this.emit(Atlan.getDefaultClient());
    }

    public void emit(AtlanClient client) throws AtlanException {
        client.openLineage.send(this, AtlanConnectorType.SPARK);
    }

    OpenLineage.BaseEvent get_event() {
        if (this._event == null) {
            this._event = this._builder.inputs(this.inputs.stream().map(OpenLineageInputDataset::get_dataset).collect(Collectors.toList())).outputs(this.outputs.stream().map(OpenLineageOutputDataset::get_dataset).collect(Collectors.toList())).build();
        }
        return this._event;
    }

    @Override
    public String toJson(AtlanClient client) {
        return OpenLineageClientUtils.toJson((Object)this.get_event());
    }

    @Generated
    protected OpenLineageEvent(OpenLineageEventBuilder<?, ?> b) {
        super(b);
        this._builder = b._builder;
        this.run = b.run;
        this.inputs = switch (b.inputs == null ? 0 : b.inputs.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.inputs.get(0));
            default -> Collections.unmodifiableList(new ArrayList<OpenLineageInputDataset>(b.inputs));
        };
        this.outputs = switch (b.outputs == null ? 0 : b.outputs.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(b.outputs.get(0));
            default -> Collections.unmodifiableList(new ArrayList<OpenLineageOutputDataset>(b.outputs));
        };
        this._event = b._event;
    }

    @Generated
    public static OpenLineageEventBuilder<?, ?> _internal() {
        return new OpenLineageEventBuilderImpl();
    }

    @Generated
    public OpenLineageEventBuilder<?, ?> toBuilder() {
        return new OpenLineageEventBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenLineageEvent)) {
            return false;
        }
        OpenLineageEvent other = (OpenLineageEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OpenLineage.RunEventBuilder this$_builder = this._builder;
        OpenLineage.RunEventBuilder other$_builder = other._builder;
        if (this$_builder == null ? other$_builder != null : !this$_builder.equals(other$_builder)) {
            return false;
        }
        OpenLineageRun this$run = this.run;
        OpenLineageRun other$run = other.run;
        if (this$run == null ? other$run != null : !((Object)this$run).equals(other$run)) {
            return false;
        }
        List<OpenLineageInputDataset> this$inputs = this.inputs;
        List<OpenLineageInputDataset> other$inputs = other.inputs;
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        List<OpenLineageOutputDataset> this$outputs = this.outputs;
        List<OpenLineageOutputDataset> other$outputs = other.outputs;
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        OpenLineage.BaseEvent this$_event = this.get_event();
        OpenLineage.BaseEvent other$_event = other.get_event();
        return !(this$_event == null ? other$_event != null : !this$_event.equals(other$_event));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpenLineageEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OpenLineage.RunEventBuilder $_builder = this._builder;
        result = result * 59 + ($_builder == null ? 43 : $_builder.hashCode());
        OpenLineageRun $run = this.run;
        result = result * 59 + ($run == null ? 43 : ((Object)$run).hashCode());
        List<OpenLineageInputDataset> $inputs = this.inputs;
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        List<OpenLineageOutputDataset> $outputs = this.outputs;
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        OpenLineage.BaseEvent $_event = this.get_event();
        result = result * 59 + ($_event == null ? 43 : $_event.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "OpenLineageEvent(super=" + super.toString() + ", _builder=" + this._builder + ", run=" + this.run + ", inputs=" + this.inputs + ", outputs=" + this.outputs + ", _event=" + this.get_event() + ")";
    }

    @Generated
    public static abstract class OpenLineageEventBuilder<C extends OpenLineageEvent, B extends OpenLineageEventBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private OpenLineage.RunEventBuilder _builder;
        @Generated
        private OpenLineageRun run;
        @Generated
        private ArrayList<OpenLineageInputDataset> inputs;
        @Generated
        private ArrayList<OpenLineageOutputDataset> outputs;
        @Generated
        private OpenLineage.BaseEvent _event;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            OpenLineageEventBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(OpenLineageEvent instance, OpenLineageEventBuilder<?, ?> b) {
            b._builder(instance._builder);
            b.run(instance.run);
            b.inputs(instance.inputs == null ? Collections.emptyList() : instance.inputs);
            b.outputs(instance.outputs == null ? Collections.emptyList() : instance.outputs);
            b._event(instance._event);
        }

        @Generated
        public B _builder(OpenLineage.RunEventBuilder _builder) {
            this._builder = _builder;
            return (B)this.self();
        }

        @Generated
        public B run(OpenLineageRun run) {
            this.run = run;
            return (B)this.self();
        }

        @Generated
        public B input(OpenLineageInputDataset input) {
            if (this.inputs == null) {
                this.inputs = new ArrayList();
            }
            this.inputs.add(input);
            return (B)this.self();
        }

        @Generated
        public B inputs(Collection<? extends OpenLineageInputDataset> inputs) {
            if (inputs == null) {
                throw new NullPointerException("inputs cannot be null");
            }
            if (this.inputs == null) {
                this.inputs = new ArrayList();
            }
            this.inputs.addAll(inputs);
            return (B)this.self();
        }

        @Generated
        public B clearInputs() {
            if (this.inputs != null) {
                this.inputs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B output(OpenLineageOutputDataset output) {
            if (this.outputs == null) {
                this.outputs = new ArrayList();
            }
            this.outputs.add(output);
            return (B)this.self();
        }

        @Generated
        public B outputs(Collection<? extends OpenLineageOutputDataset> outputs) {
            if (outputs == null) {
                throw new NullPointerException("outputs cannot be null");
            }
            if (this.outputs == null) {
                this.outputs = new ArrayList();
            }
            this.outputs.addAll(outputs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputs() {
            if (this.outputs != null) {
                this.outputs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B _event(OpenLineage.BaseEvent _event) {
            this._event = _event;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "OpenLineageEvent.OpenLineageEventBuilder(super=" + super.toString() + ", _builder=" + this._builder + ", run=" + this.run + ", inputs=" + this.inputs + ", outputs=" + this.outputs + ", _event=" + this._event + ")";
        }
    }

    @Generated
    private static final class OpenLineageEventBuilderImpl
    extends OpenLineageEventBuilder<OpenLineageEvent, OpenLineageEventBuilderImpl> {
        @Generated
        private OpenLineageEventBuilderImpl() {
        }

        @Override
        @Generated
        protected OpenLineageEventBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OpenLineageEvent build() {
            return new OpenLineageEvent(this);
        }
    }
}

