/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.Credential;
import com.atlan.model.assets.Connection;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.AtlanPackageType;
import com.atlan.model.packages.AbstractCrawler;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class GlueCrawler
extends AbstractCrawler {
    public static final String PREFIX = AtlanPackageType.GLUE.getValue();

    public static GlueCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers, boolean allowQuery, boolean allowSamples, long rowLimit) throws AtlanException {
        return ((GlueCrawlerBuilder)((GlueCrawlerBuilder)GlueCrawler._internal().setup(PREFIX, "@atlan/glue", client, GlueCrawler.getConnection(client, connectionName, AtlanConnectorType.GLUE, adminRoles, adminGroups, adminUsers, allowQuery, allowSamples, rowLimit, "https://atlan-public.s3.eu-west-1.amazonaws.com/atlan/logos/aws-glue.png"))).include(null)).exclude((List<String>)null);
    }

    @Generated
    protected GlueCrawler(GlueCrawlerBuilder<?, ?> b) {
        super((AbstractCrawler.AbstractCrawlerBuilder<?, ?>)b);
    }

    @Generated
    public static GlueCrawlerBuilder<?, ?> _internal() {
        return new GlueCrawlerBuilderImpl();
    }

    @Generated
    public GlueCrawlerBuilder<?, ?> toBuilder() {
        return new GlueCrawlerBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlueCrawler)) {
            return false;
        }
        GlueCrawler other = (GlueCrawler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GlueCrawler;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "GlueCrawler(super=" + super.toString() + ")";
    }

    public static abstract class GlueCrawlerBuilder<C extends GlueCrawler, B extends GlueCrawlerBuilder<C, B>>
    extends AbstractCrawler.AbstractCrawlerBuilder<C, B> {
        public B direct(String region) {
            String epoch = Connection.getEpochFromQualifiedName(this.connection.getQualifiedName());
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.name("default-glue-" + epoch + "-0")).extra("region", region)).connectorConfigName("atlan-connectors-glue");
            return (B)((GlueCrawlerBuilder)this._credential(this.localCreds));
        }

        public B iamUserAuth(String accessKey, String secretKey) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.authType("iam")).username(accessKey)).password(secretKey);
            return (B)((GlueCrawlerBuilder)this._credential(this.localCreds));
        }

        public B include(List<String> assets) throws InvalidRequestException {
            if (assets == null) {
                return (B)((GlueCrawlerBuilder)this._parameter("include-filter", "{}"));
            }
            HashMap map = new HashMap();
            map.put("AwsDataCatalog", new HashMap());
            for (String one : assets) {
                ((Map)map.get("AwsDataCatalog")).put(one, Collections.emptyMap());
            }
            try {
                return (B)((GlueCrawlerBuilder)this._parameter("include-filter", Serde.allInclusiveMapper.writeValueAsString(map)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        public B exclude(List<String> assets) throws InvalidRequestException {
            if (assets == null) {
                return (B)((GlueCrawlerBuilder)this._parameter("exclude-filter", "{}"));
            }
            HashMap map = new HashMap();
            map.put("AwsDataCatalog", new HashMap());
            for (String one : assets) {
                ((Map)map.get("AwsDataCatalog")).put(one, Collections.emptyMap());
            }
            try {
                return (B)((GlueCrawlerBuilder)this._parameter("exclude-filter", Serde.allInclusiveMapper.writeValueAsString(map)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        public B exclude(String regex) {
            return (B)((GlueCrawlerBuilder)this._parameter("exclude-table-regex", regex));
        }

        @Override
        protected B metadata() {
            return (B)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)((GlueCrawlerBuilder)this._label("orchestration.atlan.com/certified", "true"))._label("orchestration.atlan.com/source", "glue"))._label("orchestration.atlan.com/sourceCategory", "lake"))._label("orchestration.atlan.com/type", "connector"))._label("orchestration.atlan.com/verified", "true"))._label("package.argoproj.io/installer", "argopm"))._label("package.argoproj.io/name", "a-t-ratlans-l-a-s-hglue"))._label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com"))._label("orchestration.atlan.com/default-glue-" + this.epoch, "true"))._label("orchestration.atlan.com/atlan-ui", "true"))._annotation("orchestration.atlan.com/allowSchedule", "true"))._annotation("orchestration.atlan.com/dependentPackage", ""))._annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/6335637665681"))._annotation("orchestration.atlan.com/emoji", "\ud83d\ude80"))._annotation("orchestration.atlan.com/icon", "https://atlan-public.s3.eu-west-1.amazonaws.com/atlan/logos/aws-glue.png"))._annotation("orchestration.atlan.com/logo", "https://atlan-public.s3.eu-west-1.amazonaws.com/atlan/logos/aws-glue.png"))._annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/glue"))._annotation("orchestration.atlan.com/name", "Glue Assets"))._annotation("orchestration.atlan.com/usecase", "crawling,auto-classifications"))._annotation("package.argoproj.io/author", "Atlan"))._annotation("package.argoproj.io/description", "Package to crawl AWS Glue assets and publish to Atlan for discovery."))._annotation("package.argoproj.io/homepage", "https://packages.atlan.com/-/web/detail/@atlan/glue"))._annotation("package.argoproj.io/keywords", "[\"lake\",\"connector\",\"crawler\",\"glue\",\"aws\",\"s3\"]"))._annotation("package.argoproj.io/name", "@atlan/glue"))._annotation("package.argoproj.io/registry", "https://packages.atlan.com"))._annotation("package.argoproj.io/repository", "git+https://github.com/atlanhq/marketplace-packages.git"))._annotation("package.argoproj.io/support", "support@atlan.com"))._annotation("orchestration.atlan.com/atlanName", PREFIX + "-default-glue-" + this.epoch))._parameters(Map.ofEntries(Map.entry("credentials-fetch-strategy", "credential_guid"), Map.entry("credential-guid", "{{credentialGuid}}"), Map.entry("connection", this.connection.toJson(this.client)), Map.entry("publish-mode", "production"), Map.entry("atlas-auth-type", "internal"))));
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            GlueCrawlerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(GlueCrawler instance, GlueCrawlerBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "GlueCrawler.GlueCrawlerBuilder(super=" + super.toString() + ")";
        }
    }

    @Generated
    private static final class GlueCrawlerBuilderImpl
    extends GlueCrawlerBuilder<GlueCrawler, GlueCrawlerBuilderImpl> {
        @Generated
        private GlueCrawlerBuilderImpl() {
        }

        @Override
        @Generated
        protected GlueCrawlerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public GlueCrawler build() {
            return new GlueCrawler(this);
        }
    }
}

