/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.packages;

import com.atlan.AtlanClient;
import com.atlan.exception.AtlanException;
import com.atlan.exception.ErrorCode;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.Credential;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.AtlanPackageType;
import com.atlan.model.packages.AbstractCrawler;
import com.atlan.serde.Serde;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SigmaCrawler
extends AbstractCrawler {
    public static final String PREFIX = AtlanPackageType.SIGMA.getValue();

    public static SigmaCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName) throws AtlanException {
        return SigmaCrawler.creator(client, connectionName, List.of(client.getRoleCache().getIdForName("$admin")), null, null);
    }

    public static SigmaCrawlerBuilder<?, ?> creator(AtlanClient client, String connectionName, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers) throws AtlanException {
        return ((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)SigmaCrawler._internal().setup(PREFIX, "@atlan/sigma", client, SigmaCrawler.getConnection(client, connectionName, AtlanConnectorType.SIGMA, adminRoles, adminGroups, adminUsers, false, false, 0L, "http://assets.atlan.com/assets/sigma.svg"))).include(null)).exclude(null);
    }

    @Generated
    protected SigmaCrawler(SigmaCrawlerBuilder<?, ?> b) {
        super((AbstractCrawler.AbstractCrawlerBuilder<?, ?>)b);
    }

    @Generated
    public static SigmaCrawlerBuilder<?, ?> _internal() {
        return new SigmaCrawlerBuilderImpl();
    }

    @Generated
    public SigmaCrawlerBuilder<?, ?> toBuilder() {
        return new SigmaCrawlerBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SigmaCrawler)) {
            return false;
        }
        SigmaCrawler other = (SigmaCrawler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SigmaCrawler;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "SigmaCrawler(super=" + super.toString() + ")";
    }

    public static abstract class SigmaCrawlerBuilder<C extends SigmaCrawler, B extends SigmaCrawlerBuilder<C, B>>
    extends AbstractCrawler.AbstractCrawlerBuilder<C, B> {
        public B direct(String hostname) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.name("default-sigma-" + this.epoch + "-0")).host(hostname)).port(443)).connectorConfigName("atlan-connectors-sigma");
            return (B)((SigmaCrawlerBuilder)this._credential(this.localCreds));
        }

        public B apiToken(String clientId, String apiToken) {
            ((Credential.CredentialBuilder)((Credential.CredentialBuilder)this.localCreds.authType("api_token")).username(clientId)).password(apiToken);
            return (B)((SigmaCrawlerBuilder)this._credential(this.localCreds));
        }

        public B include(List<String> workbooks) throws InvalidRequestException {
            Map<String, Map<String, String>> toInclude = AbstractCrawler.buildFlatFilter(workbooks);
            try {
                return (B)((SigmaCrawlerBuilder)this._parameter("include-filter", Serde.allInclusiveMapper.writeValueAsString(toInclude)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        public B exclude(List<String> workbooks) throws InvalidRequestException {
            Map<String, Map<String, String>> toExclude = AbstractCrawler.buildFlatFilter(workbooks);
            try {
                return (B)((SigmaCrawlerBuilder)this._parameter("exclude-filter", Serde.allInclusiveMapper.writeValueAsString(toExclude)));
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException(ErrorCode.UNABLE_TO_TRANSLATE_FILTERS, (Throwable)e);
            }
        }

        @Override
        protected B metadata() {
            return (B)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)((SigmaCrawlerBuilder)this._label("orchestration.atlan.com/certified", "true"))._label("orchestration.atlan.com/source", "sigma"))._label("orchestration.atlan.com/sourceCategory", "bi"))._label("orchestration.atlan.com/type", "connector"))._label("orchestration.atlan.com/verified", "true"))._label("package.argoproj.io/installer", "argopm"))._label("package.argoproj.io/name", "a-t-ratlans-l-a-s-hsigma"))._label("package.argoproj.io/registry", "httpsc-o-l-o-ns-l-a-s-hs-l-a-s-hpackages.atlan.com"))._label("orchestration.atlan.com/default-sigma-" + this.epoch, "true"))._label("orchestration.atlan.com/atlan-ui", "true"))._annotation("orchestration.atlan.com/allowSchedule", "true"))._annotation("orchestration.atlan.com/categories", "sigma,crawler"))._annotation("orchestration.atlan.com/dependentPackage", ""))._annotation("orchestration.atlan.com/docsUrl", "https://ask.atlan.com/hc/en-us/articles/8731744918813"))._annotation("orchestration.atlan.com/emoji", "\ud83d\ude80"))._annotation("orchestration.atlan.com/icon", "http://assets.atlan.com/assets/sigma.svg"))._annotation("orchestration.atlan.com/logo", "http://assets.atlan.com/assets/sigma.svg"))._annotation("orchestration.atlan.com/marketplaceLink", "https://packages.atlan.com/-/web/detail/@atlan/sigma"))._annotation("orchestration.atlan.com/name", "Sigma Assets"))._annotation("package.argoproj.io/author", "Atlan"))._annotation("package.argoproj.io/description", "Package to crawl Sigma assets and publish to Atlan for discovery"))._annotation("package.argoproj.io/homepage", "https://github.com/atlanhq/marketplace-packages#readme"))._annotation("package.argoproj.io/keywords", "[\"sigma\",\"bi\",\"connector\",\"crawler\"]"))._annotation("package.argoproj.io/name", "@atlan/sigma"))._annotation("package.argoproj.io/registry", "https://packages.atlan.com"))._annotation("package.argoproj.io/repository", "git+https://github.com/atlanhq/marketplace-packages.git"))._annotation("package.argoproj.io/support", "support@atlan.com"))._annotation("orchestration.atlan.com/atlanName", PREFIX + "-default-sigma-" + this.epoch))._parameters(Map.ofEntries(Map.entry("credential-guid", "{{credentialGuid}}"), Map.entry("connection", this.connection.toJson(this.client)), Map.entry("atlas-auth-type", "internal"), Map.entry("publish-mode", "production"))));
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SigmaCrawlerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(SigmaCrawler instance, SigmaCrawlerBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "SigmaCrawler.SigmaCrawlerBuilder(super=" + super.toString() + ")";
        }
    }

    @Generated
    private static final class SigmaCrawlerBuilderImpl
    extends SigmaCrawlerBuilder<SigmaCrawler, SigmaCrawlerBuilderImpl> {
        @Generated
        private SigmaCrawlerBuilderImpl() {
        }

        @Override
        @Generated
        protected SigmaCrawlerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SigmaCrawler build() {
            return new SigmaCrawler(this);
        }
    }
}

